
#line 1 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 242 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"


/** Data **/

#line 87 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 14, 1, 15, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 2, 1, 16, 2, 11, 0, 2, 
	12, 13, 2, 15, 0, 2, 15, 2, 
	2, 15, 14, 2, 15, 17, 2, 16, 
	4, 2, 16, 5, 2, 16, 6, 2, 
	16, 7, 2, 16, 8, 2, 16, 14, 
	2, 18, 19, 2, 20, 0, 2, 20, 
	2, 2, 20, 14, 2, 20, 17, 3, 
	3, 12, 13, 3, 9, 12, 13, 3, 
	10, 12, 13, 3, 11, 12, 13, 3, 
	12, 13, 16, 3, 15, 12, 13, 4, 
	1, 12, 13, 16, 4, 15, 0, 12, 
	13
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 22, 23, 24, 26, 37, 
	38, 39, 43, 48, 53, 58, 63, 67, 
	71, 73, 74, 75, 76, 77, 78, 79, 
	80, 81, 82, 83, 84, 85, 86, 87, 
	88, 93, 100, 105, 109, 115, 118, 120, 
	126, 137, 138, 140, 141, 142, 143, 144, 
	145, 146, 147, 148, 149, 150, 151, 152, 
	153, 154, 155, 156, 157, 158, 159, 160, 
	161, 162, 164, 165, 166, 168, 169, 170, 
	171, 172, 173, 174, 175, 176, 177, 178, 
	179, 180, 181, 182, 183, 184, 185, 194, 
	205, 207, 218, 220, 223, 225, 227, 229, 
	231, 233, 235, 237, 239, 241, 243, 245, 
	247, 249, 251, 253, 255, 257, 259, 261, 
	263, 265, 267, 270, 272, 274, 276, 278, 
	280, 282, 284, 286, 288, 290, 292, 294, 
	296, 298, 300, 302, 304, 306, 308, 310, 
	312, 314, 316, 318, 320, 322, 324, 326, 
	329, 331, 333, 335, 337, 339, 341, 343, 
	345, 347, 349, 351, 353, 355, 357, 360, 
	362, 364, 366, 368, 370, 372, 374, 376, 
	378, 380, 382, 384, 386, 388, 390, 392, 
	394, 396, 398, 400, 402, 404, 406, 408, 
	410, 412, 414, 416, 418, 420, 422, 424, 
	426, 428, 430, 432, 434, 436, 438, 440, 
	442, 444, 446, 448, 450, 453, 455, 457, 
	459, 461, 463, 465, 467, 469, 471, 473, 
	476, 478, 480, 482, 484, 486, 488, 490, 
	492, 494, 496, 498, 500, 502, 504, 506, 
	508, 510, 512, 514, 516, 518, 519, 520, 
	521, 522, 523, 524, 525, 526, 527, 528, 
	529, 530, 531, 532, 534, 535, 537, 538, 
	539, 540, 541, 542, 543, 544, 545, 546, 
	547, 548, 549, 550, 551, 552, 553, 554, 
	555, 556, 557, 558, 559, 560, 561, 562, 
	563, 564, 571, 574, 576, 578, 580, 582, 
	584, 586, 588, 590, 592, 594, 596, 598, 
	600, 602, 604, 606, 608, 610, 612, 614, 
	616, 618, 620, 622, 624, 627, 629, 631, 
	633, 635, 637, 639, 641, 643, 644, 645, 
	646, 647, 648, 649, 651, 652, 653, 654, 
	655, 656, 657, 658, 659, 660, 661, 662, 
	663, 664, 665, 666, 667, 675, 680, 682, 
	684, 686, 688, 690, 692, 694, 696, 698, 
	700, 702, 704, 706, 708, 710, 712, 714, 
	716, 719, 721, 723, 725, 727, 729, 731, 
	733, 735, 737, 739, 741, 743, 745, 747, 
	749, 751, 753, 755, 757, 759, 761, 763, 
	765, 767, 770, 772, 774, 776, 778, 780, 
	782, 784, 786, 788, 790, 792, 794, 796, 
	799, 801, 803, 805, 807, 809, 811, 813, 
	815, 817, 819, 821, 823, 825, 827, 829, 
	831, 833, 835, 837, 839, 841, 843, 845, 
	847, 849, 851, 853, 855, 857, 859, 861, 
	863, 865, 867, 869, 871, 873, 875, 877, 
	879, 881, 883, 885, 887, 889, 891, 893, 
	896, 898, 900, 902, 904, 906, 908, 910, 
	912, 914, 916, 918, 920, 922, 924, 926, 
	928, 930, 932, 934, 936, 938, 940, 941, 
	942, 943, 944, 945, 946, 947, 948, 949, 
	950, 951, 952, 953, 954, 955, 956, 957, 
	958, 959, 960, 961, 962, 963, 964, 965, 
	966, 967, 968, 969, 970, 971, 972, 973, 
	974, 983, 994, 996, 998, 1001, 1003, 1005, 
	1007, 1009, 1011, 1013, 1015, 1017, 1019, 1021, 
	1023, 1025, 1027, 1029, 1031, 1033, 1035, 1037, 
	1039, 1041, 1043, 1045, 1048, 1050, 1052, 1054, 
	1056, 1058, 1060, 1062, 1064, 1066, 1068, 1070, 
	1072, 1074, 1076, 1078, 1080, 1082, 1084, 1086, 
	1088, 1090, 1092, 1094, 1096, 1098, 1100, 1102, 
	1104, 1107, 1109, 1111, 1113, 1115, 1117, 1119, 
	1121, 1123, 1125, 1127, 1129, 1131, 1133, 1135, 
	1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151, 
	1153, 1155, 1157, 1159, 1161, 1163, 1165, 1168, 
	1170, 1172, 1174, 1176, 1178, 1180, 1182, 1184, 
	1186, 1188, 1191, 1193, 1195, 1197, 1199, 1201, 
	1203, 1205, 1207, 1209, 1211, 1213, 1215, 1217, 
	1219, 1221, 1223, 1225, 1227, 1229, 1231, 1233, 
	1235, 1236, 1237, 1238, 1239, 1240, 1241, 1242, 
	1243, 1244, 1245, 1246, 1247, 1248, 1249, 1250, 
	1259, 1270, 1272, 1274, 1277, 1279, 1281, 1283, 
	1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 
	1301, 1303, 1305, 1307, 1309, 1311, 1313, 1315, 
	1317, 1319, 1321, 1324, 1326, 1328, 1331, 1333, 
	1335, 1337, 1339, 1341, 1343, 1345, 1347, 1349, 
	1351, 1353, 1355, 1357, 1359, 1361, 1363, 1365, 
	1367, 1369, 1371, 1373, 1375, 1377, 1379, 1381, 
	1383, 1385, 1387, 1389, 1392, 1394, 1396, 1398, 
	1400, 1402, 1404, 1406, 1408, 1410, 1412, 1414, 
	1416, 1418, 1420, 1422, 1424, 1426, 1428, 1430, 
	1432, 1434, 1436, 1438, 1440, 1443, 1445, 1447, 
	1449, 1451, 1453, 1455, 1457, 1459, 1461, 1463, 
	1465, 1467, 1469, 1472, 1474, 1476, 1478, 1480, 
	1482, 1484, 1486, 1488, 1490, 1492, 1494, 1496, 
	1498, 1500, 1502, 1504, 1506, 1508, 1510, 1512, 
	1514, 1516, 1518, 1520, 1522, 1524, 1526, 1528, 
	1530, 1532, 1534, 1536, 1538, 1540, 1542, 1544, 
	1546, 1548, 1550, 1553, 1555, 1557, 1559, 1561, 
	1563, 1565, 1567, 1569, 1571, 1573, 1575, 1578, 
	1580, 1582, 1584, 1586, 1588, 1590, 1592, 1594, 
	1596, 1598, 1600, 1602, 1604, 1606, 1608, 1610, 
	1612, 1614, 1616, 1618, 1620, 1621, 1622, 1624, 
	1625, 1626, 1627, 1628, 1629, 1630, 1631, 1632, 
	1633, 1634, 1635, 1637, 1638, 1639, 1640, 1641, 
	1642, 1643, 1644, 1645, 1646, 1647
};

static const char _lexer_trans_keys[] = {
	-48, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -112, -108, -107, -104, 
	-102, -99, -97, -95, -94, -92, 32, 10, 
	10, 13, -48, 10, 32, 34, 35, 37, 
	42, 64, 124, 9, 13, 34, 34, 10, 
	32, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	13, 32, 64, 9, 10, 9, 10, 13, 
	32, 64, 11, 12, 10, 32, 64, 9, 
	13, 32, 124, 9, 13, 10, 32, 92, 
	124, 9, 13, 10, 92, 124, 10, 92, 
	10, 32, 92, 124, 9, 13, -48, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -48, -80, -66, -48, -67, -48, -66, 
	-48, -65, -47, -125, -47, -127, -47, -126, 
	-48, -72, -48, -68, -47, -127, -48, -69, 
	-48, -72, -48, 32, -66, -48, -77, -67, 
	-48, -76, -48, -80, -47, -126, -48, -75, 
	-48, -70, -47, -127, -47, -126, 58, 10, 
	10, -48, 10, 32, 35, 37, 42, 64, 
	9, 13, -112, -108, -107, -104, -102, -99, 
	-97, -95, -94, -92, 10, 10, 32, -48, 
	10, 32, 34, 35, 37, 42, 64, 124, 
	9, 13, -48, 10, -80, -66, 10, -48, 
	10, -67, 10, -48, 10, -66, 10, -48, 
	10, -65, 10, -47, 10, -125, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -72, 10, -48, 10, -68, 10, -47, 
	10, -127, 10, -48, 10, -69, 10, -48, 
	10, -72, 10, -48, 10, 32, -66, 10, 
	-48, 10, -77, 10, -48, 10, -76, 10, 
	-48, 10, -80, 10, -47, 10, -126, 10, 
	-48, 10, -66, 10, -48, 10, -68, 10, 
	-47, 10, -125, 10, 10, 32, -48, 10, 
	-74, 10, -48, 10, -75, 10, -47, 10, 
	-125, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -47, 10, -116, 10, -48, -47, 
	10, -78, 10, -48, 10, -66, 10, -48, 
	10, -71, 10, -47, 10, -127, 10, -47, 
	10, -126, 10, -48, 10, -78, 10, -48, 
	10, -66, 10, 10, 58, -126, -122, 10, 
	-47, 10, -128, 10, -47, 10, -125, 10, 
	-48, 10, -70, 10, -47, 10, -126, 10, 
	-47, 10, -125, 10, -47, 10, -128, 10, 
	-48, 10, -80, 10, 10, 32, -47, 10, 
	-127, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -47, 10, -113, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -47, 10, -128, 10, -48, 10, 
	-72, 10, -48, 10, -71, 10, -48, 10, 
	-66, 10, -48, 10, 32, -47, 10, -125, 
	10, -48, 10, -67, 10, -48, 10, -70, 
	10, -47, 10, -122, 10, -48, 10, -72, 
	10, -48, -47, 10, -66, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -48, 10, 
	-69, 10, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, -47, -126, 
	-48, -66, -48, -68, -47, -125, 32, -48, 
	-74, -48, -75, -47, -128, -125, -48, -75, 
	-72, -48, -76, -47, -117, -47, -127, -47, 
	-126, -48, -66, -47, -128, -48, -72, -47, 
	-113, -48, -68, -48, -75, -47, -128, -47, 
	-117, 58, 10, 10, -48, 10, 32, 35, 
	124, 9, 13, -95, -92, 10, -48, 10, 
	-78, 10, -48, 10, -66, 10, -48, 10, 
	-71, 10, -47, 10, -127, 10, -47, 10, 
	-126, 10, -48, 10, -78, 10, -48, 10, 
	-66, 10, 10, 58, -47, 10, -125, 10, 
	-48, 10, -67, 10, -48, 10, -70, 10, 
	-47, 10, -122, 10, -48, 10, -72, 10, 
	-48, -47, 10, -66, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -48, 10, -69, 
	10, -113, 10, -47, -127, -47, -126, -47, 
	-116, -48, -47, -78, -48, -66, -48, -71, 
	-47, -127, -47, -126, -48, -78, -48, -66, 
	58, 10, 10, -48, 10, 32, 35, 37, 
	64, 9, 13, -102, -97, -95, -92, 10, 
	-48, 10, -66, 10, -48, 10, -67, 10, 
	-47, 10, -126, 10, -48, 10, -75, 10, 
	-48, 10, -70, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, 10, 58, -47, 10, 
	-128, 10, -48, 10, -75, -72, 10, -48, 
	10, -76, 10, -47, 10, -117, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, -48, 
	10, -66, 10, -47, 10, -128, 10, -48, 
	10, -72, 10, -47, 10, -113, 10, -48, 
	10, -68, 10, -48, 10, -75, 10, -47, 
	10, -128, 10, -47, 10, -117, 10, -48, 
	-47, 10, -78, 10, -48, 10, -66, 10, 
	-48, 10, -71, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -48, 10, -78, 10, 
	-48, 10, -66, 10, -126, -122, 10, -47, 
	10, -128, 10, -47, 10, -125, 10, -48, 
	10, -70, 10, -47, 10, -126, 10, -47, 
	10, -125, 10, -47, 10, -128, 10, -48, 
	10, -80, 10, 10, 32, -47, 10, -127, 
	10, -47, 10, -122, 10, -48, 10, -75, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, -47, 10, -125, 10, -48, 10, -67, 
	10, -48, 10, -70, 10, -47, 10, -122, 
	10, -48, 10, -72, 10, -48, -47, 10, 
	-66, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -69, 10, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -126, -122, -47, -128, -47, -125, 
	-48, -70, -47, -126, -47, -125, -47, -128, 
	-48, -80, 32, -47, -127, -47, -122, -48, 
	-75, -48, -67, -48, -80, -47, -128, -48, 
	-72, -47, -113, 58, 10, 10, -48, 10, 
	32, 35, 37, 42, 64, 9, 13, -112, 
	-108, -107, -104, -102, -99, -97, -95, -94, 
	-92, 10, 10, 32, -48, 10, -80, -66, 
	10, -48, 10, -67, 10, -48, 10, -66, 
	10, -48, 10, -65, 10, -47, 10, -125, 
	10, -47, 10, -127, 10, -47, 10, -126, 
	10, -48, 10, -72, 10, -48, 10, -68, 
	10, -47, 10, -127, 10, -48, 10, -69, 
	10, -48, 10, -72, 10, -48, 10, 32, 
	-66, 10, -48, 10, -77, 10, -48, 10, 
	-76, 10, -48, 10, -80, 10, -47, 10, 
	-126, 10, -48, 10, -66, 10, -48, 10, 
	-68, 10, -47, 10, -125, 10, 10, 32, 
	-48, 10, -74, 10, -48, 10, -75, 10, 
	-47, 10, -125, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -47, 10, -116, 10, 
	-48, -47, 10, -78, 10, -48, 10, -66, 
	10, -48, 10, -71, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -78, 
	10, -48, 10, -66, 10, 10, 58, -122, 
	10, -48, 10, -75, 10, -48, 10, -67, 
	10, -48, 10, -80, 10, -47, 10, -128, 
	10, -48, 10, -72, 10, -48, 10, -71, 
	10, -48, 10, -66, 10, -48, 10, 32, 
	-47, 10, -125, 10, -48, 10, -67, 10, 
	-48, 10, -70, 10, -47, 10, -122, 10, 
	-48, 10, -72, 10, -48, -47, 10, -66, 
	10, -48, 10, -67, 10, -48, 10, -80, 
	10, -48, 10, -69, 10, -113, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -48, -75, -48, -67, -48, 
	-80, -47, -128, -48, -72, -48, -71, 58, 
	10, 10, -48, 10, 32, 35, 37, 42, 
	64, 9, 13, -112, -108, -107, -104, -102, 
	-99, -97, -95, -94, -92, 10, 10, 32, 
	-48, 10, -80, -66, 10, -48, 10, -67, 
	10, -48, 10, -66, 10, -48, 10, -65, 
	10, -47, 10, -125, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -72, 
	10, -48, 10, -68, 10, -47, 10, -127, 
	10, -48, 10, -69, 10, -48, 10, -72, 
	10, -48, 10, 32, -66, 10, -48, 10, 
	-77, -67, 10, -48, 10, -76, 10, -48, 
	10, -80, 10, -47, 10, -126, 10, -48, 
	10, -75, 10, -48, 10, -70, 10, -47, 
	10, -127, 10, -47, 10, -126, 10, 10, 
	58, -47, 10, -126, 10, -48, 10, -66, 
	10, -48, 10, -68, 10, -47, 10, -125, 
	10, 10, 32, -48, 10, -74, 10, -48, 
	10, -75, 10, -47, 10, -128, -125, 10, 
	-48, 10, -75, 10, -48, 10, -76, 10, 
	-47, 10, -117, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -48, 10, -66, 10, 
	-47, 10, -128, 10, -48, 10, -72, 10, 
	-47, 10, -113, 10, -47, 10, -127, 10, 
	-47, 10, -126, 10, -47, 10, -116, 10, 
	-48, -47, 10, -78, 10, -48, 10, -66, 
	10, -48, 10, -71, 10, -47, 10, -127, 
	10, -47, 10, -126, 10, -48, 10, -78, 
	10, -48, 10, -66, 10, -126, -122, 10, 
	-47, 10, -128, 10, -47, 10, -125, 10, 
	-48, 10, -70, 10, -47, 10, -126, 10, 
	-47, 10, -125, 10, -47, 10, -128, 10, 
	-48, 10, -80, 10, 10, 32, -47, 10, 
	-127, 10, -47, 10, -122, 10, -48, 10, 
	-75, 10, -48, 10, -67, 10, -48, 10, 
	-80, 10, -48, 10, -75, 10, -48, 10, 
	-67, 10, -48, 10, -80, 10, -47, 10, 
	-128, 10, -48, 10, -72, 10, -48, 10, 
	-71, 10, -48, 10, -66, 10, -48, 10, 
	32, -77, 10, -47, 10, -125, 10, -48, 
	10, -67, 10, -48, 10, -70, 10, -47, 
	10, -122, 10, -48, 10, -72, 10, -48, 
	-47, 10, -66, 10, -48, 10, -67, 10, 
	-48, 10, -80, 10, -48, 10, -69, 10, 
	10, 95, 10, 70, 10, 69, 10, 65, 
	10, 84, 10, 85, 10, 82, 10, 69, 
	10, 95, 10, 69, 10, 78, 10, 68, 
	10, 95, 10, 37, -48, -66, -48, 32, 
	-77, -47, -125, -48, -67, -48, -70, -47, 
	-122, -48, -72, -48, -47, -66, -48, -67, 
	-48, -80, -48, -69, -113, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 10, 1, 1, 2, 9, 1, 
	1, 2, 3, 3, 3, 3, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	3, 5, 3, 2, 4, 3, 2, 4, 
	9, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 2, 1, 1, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 7, 11, 
	2, 9, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 2, 1, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 5, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 1, 1, 1, 
	1, 1, 1, 2, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 6, 5, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	7, 11, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 7, 
	11, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 1, 0, 
	0, 1, 1, 1, 1, 1, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 1, 1, 1, 1, 0, 0, 1, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 23, 25, 27, 30, 41, 
	43, 45, 49, 54, 59, 64, 69, 73, 
	77, 80, 82, 84, 86, 88, 90, 92, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 115, 122, 127, 131, 137, 141, 144, 
	150, 161, 163, 166, 168, 170, 172, 174, 
	176, 178, 180, 182, 184, 186, 188, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 213, 215, 217, 220, 222, 224, 
	226, 228, 230, 232, 234, 236, 238, 240, 
	242, 244, 246, 248, 250, 252, 254, 263, 
	275, 278, 289, 292, 296, 299, 302, 305, 
	308, 311, 314, 317, 320, 323, 326, 329, 
	332, 335, 338, 341, 344, 347, 350, 353, 
	356, 359, 362, 366, 369, 372, 375, 378, 
	381, 384, 387, 390, 393, 396, 399, 402, 
	405, 408, 411, 414, 417, 420, 423, 426, 
	429, 432, 435, 438, 441, 444, 447, 450, 
	454, 457, 460, 463, 466, 469, 472, 475, 
	478, 481, 484, 487, 490, 493, 496, 500, 
	503, 506, 509, 512, 515, 518, 521, 524, 
	527, 530, 533, 536, 539, 542, 545, 548, 
	551, 554, 557, 560, 563, 566, 569, 572, 
	575, 578, 581, 584, 587, 590, 593, 596, 
	599, 602, 605, 608, 611, 614, 617, 620, 
	623, 626, 629, 632, 635, 639, 642, 645, 
	648, 651, 654, 657, 660, 663, 666, 669, 
	673, 676, 679, 682, 685, 688, 691, 694, 
	697, 700, 703, 706, 709, 712, 715, 718, 
	721, 724, 727, 730, 733, 736, 738, 740, 
	742, 744, 746, 748, 750, 752, 754, 756, 
	758, 760, 762, 764, 767, 769, 772, 774, 
	776, 778, 780, 782, 784, 786, 788, 790, 
	792, 794, 796, 798, 800, 802, 804, 806, 
	808, 810, 812, 814, 816, 818, 820, 822, 
	824, 826, 833, 837, 840, 843, 846, 849, 
	852, 855, 858, 861, 864, 867, 870, 873, 
	876, 879, 882, 885, 888, 891, 894, 897, 
	900, 903, 906, 909, 912, 916, 919, 922, 
	925, 928, 931, 934, 937, 940, 942, 944, 
	946, 948, 950, 952, 955, 957, 959, 961, 
	963, 965, 967, 969, 971, 973, 975, 977, 
	979, 981, 983, 985, 987, 995, 1001, 1004, 
	1007, 1010, 1013, 1016, 1019, 1022, 1025, 1028, 
	1031, 1034, 1037, 1040, 1043, 1046, 1049, 1052, 
	1055, 1059, 1062, 1065, 1068, 1071, 1074, 1077, 
	1080, 1083, 1086, 1089, 1092, 1095, 1098, 1101, 
	1104, 1107, 1110, 1113, 1116, 1119, 1122, 1125, 
	1128, 1131, 1135, 1138, 1141, 1144, 1147, 1150, 
	1153, 1156, 1159, 1162, 1165, 1168, 1171, 1174, 
	1178, 1181, 1184, 1187, 1190, 1193, 1196, 1199, 
	1202, 1205, 1208, 1211, 1214, 1217, 1220, 1223, 
	1226, 1229, 1232, 1235, 1238, 1241, 1244, 1247, 
	1250, 1253, 1256, 1259, 1262, 1265, 1268, 1271, 
	1274, 1277, 1280, 1283, 1286, 1289, 1292, 1295, 
	1298, 1301, 1304, 1307, 1310, 1313, 1316, 1319, 
	1323, 1326, 1329, 1332, 1335, 1338, 1341, 1344, 
	1347, 1350, 1353, 1356, 1359, 1362, 1365, 1368, 
	1371, 1374, 1377, 1380, 1383, 1386, 1389, 1391, 
	1393, 1395, 1397, 1399, 1401, 1403, 1405, 1407, 
	1409, 1411, 1413, 1415, 1417, 1419, 1421, 1423, 
	1425, 1427, 1429, 1431, 1433, 1435, 1437, 1439, 
	1441, 1443, 1445, 1447, 1449, 1451, 1453, 1455, 
	1457, 1466, 1478, 1481, 1484, 1488, 1491, 1494, 
	1497, 1500, 1503, 1506, 1509, 1512, 1515, 1518, 
	1521, 1524, 1527, 1530, 1533, 1536, 1539, 1542, 
	1545, 1548, 1551, 1554, 1558, 1561, 1564, 1567, 
	1570, 1573, 1576, 1579, 1582, 1585, 1588, 1591, 
	1594, 1597, 1600, 1603, 1606, 1609, 1612, 1615, 
	1618, 1621, 1624, 1627, 1630, 1633, 1636, 1639, 
	1642, 1646, 1649, 1652, 1655, 1658, 1661, 1664, 
	1667, 1670, 1673, 1676, 1679, 1682, 1685, 1688, 
	1691, 1694, 1697, 1700, 1703, 1706, 1709, 1712, 
	1715, 1718, 1721, 1724, 1727, 1730, 1733, 1737, 
	1740, 1743, 1746, 1749, 1752, 1755, 1758, 1761, 
	1764, 1767, 1771, 1774, 1777, 1780, 1783, 1786, 
	1789, 1792, 1795, 1798, 1801, 1804, 1807, 1810, 
	1813, 1816, 1819, 1822, 1825, 1828, 1831, 1834, 
	1837, 1839, 1841, 1843, 1845, 1847, 1849, 1851, 
	1853, 1855, 1857, 1859, 1861, 1863, 1865, 1867, 
	1876, 1888, 1891, 1894, 1898, 1901, 1904, 1907, 
	1910, 1913, 1916, 1919, 1922, 1925, 1928, 1931, 
	1934, 1937, 1940, 1943, 1946, 1949, 1952, 1955, 
	1958, 1961, 1964, 1968, 1971, 1974, 1978, 1981, 
	1984, 1987, 1990, 1993, 1996, 1999, 2002, 2005, 
	2008, 2011, 2014, 2017, 2020, 2023, 2026, 2029, 
	2032, 2035, 2038, 2041, 2044, 2047, 2050, 2053, 
	2056, 2059, 2062, 2065, 2069, 2072, 2075, 2078, 
	2081, 2084, 2087, 2090, 2093, 2096, 2099, 2102, 
	2105, 2108, 2111, 2114, 2117, 2120, 2123, 2126, 
	2129, 2132, 2135, 2138, 2141, 2145, 2148, 2151, 
	2154, 2157, 2160, 2163, 2166, 2169, 2172, 2175, 
	2178, 2181, 2184, 2188, 2191, 2194, 2197, 2200, 
	2203, 2206, 2209, 2212, 2215, 2218, 2221, 2224, 
	2227, 2230, 2233, 2236, 2239, 2242, 2245, 2248, 
	2251, 2254, 2257, 2260, 2263, 2266, 2269, 2272, 
	2275, 2278, 2281, 2284, 2287, 2290, 2293, 2296, 
	2299, 2302, 2305, 2309, 2312, 2315, 2318, 2321, 
	2324, 2327, 2330, 2333, 2336, 2339, 2342, 2346, 
	2349, 2352, 2355, 2358, 2361, 2364, 2367, 2370, 
	2373, 2376, 2379, 2382, 2385, 2388, 2391, 2394, 
	2397, 2400, 2403, 2406, 2409, 2411, 2413, 2416, 
	2418, 2420, 2422, 2424, 2426, 2428, 2430, 2432, 
	2434, 2436, 2438, 2441, 2443, 2445, 2447, 2449, 
	2451, 2453, 2455, 2457, 2459, 2461
};

static const short _lexer_trans_targs[] = {
	2, 835, 6, 6, 7, 16, 18, 3, 
	32, 35, 6, 0, 3, 41, 59, 3, 
	65, 45, 250, 323, 812, 816, 0, 4, 
	0, 0, 5, 6, 17, 5, 2, 6, 
	6, 7, 16, 18, 3, 32, 35, 6, 
	0, 8, 0, 9, 0, 10, 9, 9, 
	0, 11, 11, 12, 11, 11, 11, 11, 
	12, 11, 11, 11, 11, 13, 11, 11, 
	11, 11, 14, 11, 11, 6, 15, 15, 
	0, 6, 15, 15, 0, 6, 17, 16, 
	6, 0, 19, 0, 20, 0, 21, 0, 
	22, 0, 23, 0, 24, 0, 25, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 837, 0, 0, 0, 
	0, 0, 33, 34, 6, 34, 34, 32, 
	33, 33, 6, 34, 32, 34, 0, 35, 
	36, 35, 0, 40, 39, 38, 36, 39, 
	37, 0, 38, 36, 37, 0, 38, 37, 
	40, 39, 38, 36, 39, 37, 2, 40, 
	40, 7, 16, 18, 3, 32, 35, 40, 
	0, 42, 0, 43, 47, 0, 44, 0, 
	45, 0, 46, 0, 3, 0, 48, 0, 
	49, 0, 50, 0, 51, 0, 52, 0, 
	53, 0, 54, 0, 55, 0, 56, 0, 
	57, 0, 58, 0, 3, 0, 60, 0, 
	61, 0, 62, 0, 63, 0, 64, 0, 
	3, 0, 66, 237, 0, 67, 0, 68, 
	0, 69, 73, 0, 70, 0, 71, 0, 
	72, 0, 3, 0, 74, 0, 75, 0, 
	76, 0, 77, 0, 78, 0, 79, 0, 
	80, 0, 81, 0, 82, 0, 83, 0, 
	84, 0, 86, 85, 86, 85, 87, 86, 
	86, 6, 223, 88, 6, 86, 85, 88, 
	90, 108, 88, 114, 94, 135, 143, 202, 
	205, 86, 85, 86, 89, 85, 2, 6, 
	6, 7, 16, 18, 3, 32, 35, 6, 
	0, 91, 86, 85, 92, 96, 86, 85, 
	93, 86, 85, 94, 86, 85, 95, 86, 
	85, 88, 86, 85, 97, 86, 85, 98, 
	86, 85, 99, 86, 85, 100, 86, 85, 
	101, 86, 85, 102, 86, 85, 103, 86, 
	85, 104, 86, 85, 105, 86, 85, 106, 
	86, 85, 107, 86, 85, 88, 86, 85, 
	109, 86, 85, 110, 86, 85, 111, 86, 
	85, 112, 86, 85, 113, 86, 85, 88, 
	86, 85, 115, 86, 122, 85, 116, 86, 
	85, 117, 86, 85, 118, 86, 85, 119, 
	86, 85, 120, 86, 85, 121, 86, 85, 
	88, 86, 85, 123, 86, 85, 124, 86, 
	85, 125, 86, 85, 126, 86, 85, 127, 
	86, 85, 128, 86, 85, 129, 86, 85, 
	130, 86, 85, 86, 131, 85, 132, 86, 
	85, 133, 86, 85, 134, 86, 85, 88, 
	86, 85, 136, 86, 85, 137, 86, 85, 
	138, 86, 85, 139, 86, 85, 140, 86, 
	85, 141, 86, 85, 142, 86, 85, 88, 
	86, 85, 144, 158, 86, 85, 145, 86, 
	85, 146, 86, 85, 147, 86, 85, 148, 
	86, 85, 149, 86, 85, 150, 86, 85, 
	151, 86, 85, 152, 86, 85, 153, 86, 
	85, 154, 86, 85, 155, 86, 85, 156, 
	86, 85, 157, 86, 85, 86, 89, 85, 
	159, 190, 86, 85, 160, 86, 85, 161, 
	86, 85, 162, 86, 85, 163, 86, 85, 
	164, 86, 85, 165, 86, 85, 166, 86, 
	85, 167, 86, 85, 168, 86, 85, 169, 
	86, 85, 170, 86, 85, 171, 86, 85, 
	172, 86, 85, 173, 86, 85, 86, 174, 
	85, 175, 86, 85, 176, 86, 85, 177, 
	86, 85, 178, 86, 85, 179, 86, 85, 
	180, 86, 85, 181, 86, 85, 182, 86, 
	85, 183, 86, 85, 184, 86, 85, 185, 
	86, 85, 186, 86, 85, 187, 86, 85, 
	188, 86, 85, 189, 86, 85, 157, 86, 
	85, 191, 86, 85, 192, 86, 85, 193, 
	86, 85, 194, 86, 85, 195, 86, 85, 
	196, 86, 85, 197, 86, 85, 198, 86, 
	85, 199, 86, 85, 200, 86, 85, 201, 
	86, 85, 157, 86, 85, 203, 86, 85, 
	204, 86, 85, 117, 86, 89, 85, 206, 
	86, 85, 207, 86, 85, 208, 86, 85, 
	209, 86, 85, 210, 86, 85, 211, 86, 
	85, 212, 86, 85, 213, 86, 85, 214, 
	86, 85, 215, 86, 85, 216, 189, 86, 
	85, 217, 86, 85, 218, 86, 85, 219, 
	86, 85, 220, 86, 85, 221, 86, 85, 
	222, 86, 85, 157, 86, 85, 86, 224, 
	85, 86, 225, 85, 86, 226, 85, 86, 
	227, 85, 86, 228, 85, 86, 229, 85, 
	86, 230, 85, 86, 231, 85, 86, 232, 
	85, 86, 233, 85, 86, 234, 85, 86, 
	235, 85, 86, 236, 85, 86, 6, 85, 
	238, 0, 239, 0, 240, 0, 241, 0, 
	242, 0, 243, 0, 244, 0, 245, 0, 
	246, 0, 247, 0, 248, 0, 249, 0, 
	3, 0, 251, 0, 252, 317, 0, 253, 
	0, 254, 270, 0, 255, 0, 256, 0, 
	257, 0, 258, 0, 259, 0, 260, 0, 
	261, 0, 262, 0, 263, 0, 264, 0, 
	265, 0, 266, 0, 267, 0, 268, 0, 
	269, 0, 83, 0, 271, 0, 272, 0, 
	273, 0, 274, 0, 275, 0, 276, 0, 
	277, 0, 278, 0, 279, 0, 281, 280, 
	281, 280, 282, 281, 281, 6, 6, 281, 
	280, 283, 298, 281, 280, 284, 281, 280, 
	285, 281, 280, 286, 281, 280, 287, 281, 
	280, 288, 281, 280, 289, 281, 280, 290, 
	281, 280, 291, 281, 280, 292, 281, 280, 
	293, 281, 280, 294, 281, 280, 295, 281, 
	280, 296, 281, 280, 297, 281, 280, 281, 
	89, 280, 299, 281, 280, 300, 281, 280, 
	301, 281, 280, 302, 281, 280, 303, 281, 
	280, 304, 281, 280, 305, 281, 280, 306, 
	281, 280, 307, 281, 280, 308, 281, 280, 
	309, 316, 281, 280, 310, 281, 280, 311, 
	281, 280, 312, 281, 280, 313, 281, 280, 
	314, 281, 280, 315, 281, 280, 297, 281, 
	280, 297, 281, 280, 318, 0, 319, 0, 
	320, 0, 321, 0, 322, 0, 3, 0, 
	324, 469, 0, 325, 0, 326, 0, 327, 
	0, 328, 0, 329, 0, 330, 0, 331, 
	0, 332, 0, 333, 0, 334, 0, 335, 
	0, 336, 0, 337, 0, 338, 0, 340, 
	339, 340, 339, 341, 340, 340, 6, 455, 
	6, 340, 339, 342, 357, 385, 437, 340, 
	339, 343, 340, 339, 344, 340, 339, 345, 
	340, 339, 346, 340, 339, 347, 340, 339, 
	348, 340, 339, 349, 340, 339, 350, 340, 
	339, 351, 340, 339, 352, 340, 339, 353, 
	340, 339, 354, 340, 339, 355, 340, 339, 
	356, 340, 339, 340, 89, 339, 358, 340, 
	339, 359, 340, 339, 360, 340, 339, 361, 
	377, 340, 339, 362, 340, 339, 363, 340, 
	339, 364, 340, 339, 365, 340, 339, 366, 
	340, 339, 367, 340, 339, 368, 340, 339, 
	369, 340, 339, 370, 340, 339, 371, 340, 
	339, 372, 340, 339, 373, 340, 339, 374, 
	340, 339, 375, 340, 339, 376, 340, 339, 
	356, 340, 339, 378, 340, 339, 379, 340, 
	339, 380, 340, 339, 381, 340, 339, 382, 
	340, 339, 383, 340, 339, 384, 340, 339, 
	356, 340, 339, 386, 399, 340, 339, 387, 
	340, 339, 388, 340, 339, 389, 340, 339, 
	390, 340, 339, 391, 340, 339, 392, 340, 
	339, 393, 340, 339, 394, 340, 339, 395, 
	340, 339, 396, 340, 339, 397, 340, 339, 
	398, 340, 339, 356, 340, 339, 400, 425, 
	340, 339, 401, 340, 339, 402, 340, 339, 
	403, 340, 339, 404, 340, 339, 405, 340, 
	339, 406, 340, 339, 407, 340, 339, 408, 
	340, 339, 409, 340, 339, 410, 340, 339, 
	411, 340, 339, 412, 340, 339, 413, 340, 
	339, 414, 340, 339, 340, 415, 339, 416, 
	340, 339, 417, 340, 339, 418, 340, 339, 
	419, 340, 339, 420, 340, 339, 421, 340, 
	339, 422, 340, 339, 423, 340, 339, 424, 
	340, 339, 371, 340, 339, 426, 340, 339, 
	427, 340, 339, 428, 340, 339, 429, 340, 
	339, 430, 340, 339, 431, 340, 339, 432, 
	340, 339, 433, 340, 339, 434, 340, 339, 
	435, 340, 339, 436, 340, 339, 356, 340, 
	339, 438, 340, 339, 439, 340, 339, 440, 
	340, 339, 441, 340, 339, 442, 340, 339, 
	443, 340, 339, 444, 340, 339, 445, 340, 
	339, 446, 340, 339, 447, 340, 339, 448, 
	376, 340, 339, 449, 340, 339, 450, 340, 
	339, 451, 340, 339, 452, 340, 339, 453, 
	340, 339, 454, 340, 339, 356, 340, 339, 
	340, 456, 339, 340, 457, 339, 340, 458, 
	339, 340, 459, 339, 340, 460, 339, 340, 
	461, 339, 340, 462, 339, 340, 463, 339, 
	340, 464, 339, 340, 465, 339, 340, 466, 
	339, 340, 467, 339, 340, 468, 339, 340, 
	6, 339, 470, 624, 0, 471, 0, 472, 
	0, 473, 0, 474, 0, 475, 0, 476, 
	0, 477, 0, 478, 0, 479, 0, 480, 
	0, 481, 0, 482, 0, 483, 0, 484, 
	0, 485, 0, 486, 0, 487, 0, 488, 
	0, 489, 0, 490, 0, 491, 0, 492, 
	0, 493, 0, 494, 0, 495, 0, 496, 
	0, 497, 0, 498, 0, 499, 0, 500, 
	0, 501, 0, 502, 0, 504, 503, 504, 
	503, 505, 504, 504, 6, 610, 506, 6, 
	504, 503, 506, 507, 525, 506, 531, 511, 
	552, 560, 588, 591, 504, 503, 504, 89, 
	503, 508, 504, 503, 509, 513, 504, 503, 
	510, 504, 503, 511, 504, 503, 512, 504, 
	503, 506, 504, 503, 514, 504, 503, 515, 
	504, 503, 516, 504, 503, 517, 504, 503, 
	518, 504, 503, 519, 504, 503, 520, 504, 
	503, 521, 504, 503, 522, 504, 503, 523, 
	504, 503, 524, 504, 503, 506, 504, 503, 
	526, 504, 503, 527, 504, 503, 528, 504, 
	503, 529, 504, 503, 530, 504, 503, 506, 
	504, 503, 532, 504, 539, 503, 533, 504, 
	503, 534, 504, 503, 535, 504, 503, 536, 
	504, 503, 537, 504, 503, 538, 504, 503, 
	506, 504, 503, 540, 504, 503, 541, 504, 
	503, 542, 504, 503, 543, 504, 503, 544, 
	504, 503, 545, 504, 503, 546, 504, 503, 
	547, 504, 503, 504, 548, 503, 549, 504, 
	503, 550, 504, 503, 551, 504, 503, 506, 
	504, 503, 553, 504, 503, 554, 504, 503, 
	555, 504, 503, 556, 504, 503, 557, 504, 
	503, 558, 504, 503, 559, 504, 503, 506, 
	504, 503, 561, 575, 504, 503, 562, 504, 
	503, 563, 504, 503, 564, 504, 503, 565, 
	504, 503, 566, 504, 503, 567, 504, 503, 
	568, 504, 503, 569, 504, 503, 570, 504, 
	503, 571, 504, 503, 572, 504, 503, 573, 
	504, 503, 574, 504, 503, 504, 89, 503, 
	576, 504, 503, 577, 504, 503, 578, 504, 
	503, 579, 504, 503, 580, 504, 503, 581, 
	504, 503, 582, 504, 503, 583, 504, 503, 
	584, 504, 503, 585, 504, 503, 586, 504, 
	503, 587, 504, 503, 574, 504, 503, 589, 
	504, 503, 590, 504, 503, 534, 504, 89, 
	503, 592, 504, 503, 593, 504, 503, 594, 
	504, 503, 595, 504, 503, 596, 504, 503, 
	597, 504, 503, 598, 504, 503, 599, 504, 
	503, 600, 504, 503, 601, 504, 503, 602, 
	609, 504, 503, 603, 504, 503, 604, 504, 
	503, 605, 504, 503, 606, 504, 503, 607, 
	504, 503, 608, 504, 503, 574, 504, 503, 
	574, 504, 503, 504, 611, 503, 504, 612, 
	503, 504, 613, 503, 504, 614, 503, 504, 
	615, 503, 504, 616, 503, 504, 617, 503, 
	504, 618, 503, 504, 619, 503, 504, 620, 
	503, 504, 621, 503, 504, 622, 503, 504, 
	623, 503, 504, 6, 503, 625, 0, 626, 
	0, 627, 0, 628, 0, 629, 0, 630, 
	0, 631, 0, 632, 0, 633, 0, 634, 
	0, 635, 0, 636, 0, 637, 0, 639, 
	638, 639, 638, 640, 639, 639, 6, 798, 
	641, 6, 639, 638, 641, 642, 660, 641, 
	666, 646, 698, 724, 776, 780, 639, 638, 
	639, 89, 638, 643, 639, 638, 644, 648, 
	639, 638, 645, 639, 638, 646, 639, 638, 
	647, 639, 638, 641, 639, 638, 649, 639, 
	638, 650, 639, 638, 651, 639, 638, 652, 
	639, 638, 653, 639, 638, 654, 639, 638, 
	655, 639, 638, 656, 639, 638, 657, 639, 
	638, 658, 639, 638, 659, 639, 638, 641, 
	639, 638, 661, 639, 638, 662, 639, 638, 
	663, 639, 638, 664, 639, 638, 665, 639, 
	638, 641, 639, 638, 667, 639, 685, 638, 
	668, 639, 638, 669, 639, 638, 670, 674, 
	639, 638, 671, 639, 638, 672, 639, 638, 
	673, 639, 638, 641, 639, 638, 675, 639, 
	638, 676, 639, 638, 677, 639, 638, 678, 
	639, 638, 679, 639, 638, 680, 639, 638, 
	681, 639, 638, 682, 639, 638, 683, 639, 
	638, 684, 639, 638, 639, 89, 638, 686, 
	639, 638, 687, 639, 638, 688, 639, 638, 
	689, 639, 638, 690, 639, 638, 691, 639, 
	638, 692, 639, 638, 693, 639, 638, 639, 
	694, 638, 695, 639, 638, 696, 639, 638, 
	697, 639, 638, 641, 639, 638, 699, 639, 
	638, 700, 718, 639, 638, 701, 639, 638, 
	702, 639, 638, 703, 639, 638, 704, 639, 
	638, 705, 639, 638, 706, 639, 638, 707, 
	639, 638, 708, 639, 638, 709, 639, 638, 
	710, 639, 638, 711, 639, 638, 712, 639, 
	638, 713, 639, 638, 714, 639, 638, 715, 
	639, 638, 716, 639, 638, 717, 639, 638, 
	684, 639, 638, 719, 639, 638, 720, 639, 
	638, 721, 639, 638, 722, 639, 638, 723, 
	639, 638, 641, 639, 638, 725, 738, 639, 
	638, 726, 639, 638, 727, 639, 638, 728, 
	639, 638, 729, 639, 638, 730, 639, 638, 
	731, 639, 638, 732, 639, 638, 733, 639, 
	638, 734, 639, 638, 735, 639, 638, 736, 
	639, 638, 737, 639, 638, 684, 639, 638, 
	739, 764, 639, 638, 740, 639, 638, 741, 
	639, 638, 742, 639, 638, 743, 639, 638, 
	744, 639, 638, 745, 639, 638, 746, 639, 
	638, 747, 639, 638, 748, 639, 638, 749, 
	639, 638, 750, 639, 638, 751, 639, 638, 
	752, 639, 638, 753, 639, 638, 639, 754, 
	638, 755, 639, 638, 756, 639, 638, 757, 
	639, 638, 758, 639, 638, 759, 639, 638, 
	760, 639, 638, 761, 639, 638, 762, 639, 
	638, 763, 639, 638, 712, 639, 638, 765, 
	639, 638, 766, 639, 638, 767, 639, 638, 
	768, 639, 638, 769, 639, 638, 770, 639, 
	638, 771, 639, 638, 772, 639, 638, 773, 
	639, 638, 774, 639, 638, 775, 639, 638, 
	684, 639, 638, 777, 639, 638, 778, 639, 
	638, 779, 639, 89, 638, 670, 639, 638, 
	781, 639, 638, 782, 639, 638, 783, 639, 
	638, 784, 639, 638, 785, 639, 638, 786, 
	639, 638, 787, 639, 638, 788, 639, 638, 
	789, 639, 638, 790, 639, 638, 791, 717, 
	639, 638, 792, 639, 638, 793, 639, 638, 
	794, 639, 638, 795, 639, 638, 796, 639, 
	638, 797, 639, 638, 684, 639, 638, 639, 
	799, 638, 639, 800, 638, 639, 801, 638, 
	639, 802, 638, 639, 803, 638, 639, 804, 
	638, 639, 805, 638, 639, 806, 638, 639, 
	807, 638, 639, 808, 638, 639, 809, 638, 
	639, 810, 638, 639, 811, 638, 639, 6, 
	638, 813, 0, 814, 0, 815, 4, 0, 
	69, 0, 817, 0, 818, 0, 819, 0, 
	820, 0, 821, 0, 822, 0, 823, 0, 
	824, 0, 825, 0, 826, 0, 827, 834, 
	0, 828, 0, 829, 0, 830, 0, 831, 
	0, 832, 0, 833, 0, 337, 0, 337, 
	0, 836, 0, 6, 0, 0, 0
};

static const char _lexer_trans_actions[] = {
	25, 0, 47, 0, 5, 1, 0, 25, 
	1, 31, 0, 39, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 39, 0, 
	39, 39, 50, 99, 19, 0, 25, 47, 
	0, 5, 1, 0, 25, 1, 31, 0, 
	39, 0, 39, 0, 39, 47, 0, 0, 
	39, 119, 41, 41, 41, 3, 111, 29, 
	29, 29, 0, 111, 29, 29, 29, 0, 
	111, 29, 0, 29, 0, 95, 7, 7, 
	39, 47, 0, 0, 39, 103, 21, 0, 
	47, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 39, 39, 
	39, 39, 0, 23, 107, 23, 23, 44, 
	23, 0, 47, 0, 1, 0, 39, 0, 
	0, 0, 39, 47, 33, 33, 80, 33, 
	33, 39, 0, 35, 0, 39, 0, 0, 
	47, 0, 0, 35, 0, 0, 89, 47, 
	0, 86, 83, 37, 89, 83, 92, 0, 
	39, 0, 39, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 0, 39, 0, 39, 0, 
	39, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 124, 50, 47, 0, 77, 47, 
	0, 65, 29, 77, 65, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 47, 0, 47, 11, 0, 56, 115, 
	27, 53, 50, 27, 56, 50, 59, 27, 
	39, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 11, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 11, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 11, 0, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 0, 39, 0, 
	39, 0, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 124, 50, 
	47, 0, 77, 47, 0, 74, 74, 0, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	17, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 62, 29, 
	62, 0, 0, 0, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 9, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	9, 0, 0, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 124, 50, 47, 
	0, 77, 47, 0, 71, 29, 77, 71, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 47, 0, 47, 15, 
	0, 0, 47, 0, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 47, 15, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 15, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 15, 0, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 124, 
	50, 47, 0, 77, 47, 0, 68, 29, 
	77, 68, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 47, 0, 
	47, 13, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 47, 13, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 47, 0, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 13, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 0, 
	0, 47, 0, 0, 47, 0, 0, 47, 
	0, 0, 47, 0, 0, 47, 0, 0, 
	47, 0, 0, 47, 0, 0, 47, 13, 
	0, 0, 39, 0, 39, 0, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 39, 
	0, 39, 0, 39, 0, 39, 0, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 39, 0, 
	39, 0, 39, 0, 39, 0, 0
};

static const char _lexer_eof_actions[] = {
	0, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39, 39, 39, 
	39, 39, 39, 39, 39, 39
};

static const int lexer_start = 1;
static const int lexer_first_final = 837;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 246 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}

static void 
store_pystring_content(VALUE listener, 
          int start_col, 
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 2, con, INT2FIX(current_line));
}

static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1651 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	cs = lexer_start;
	}

#line 410 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
    
#line 1658 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 81 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 87 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 91 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 96 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));

    if (len < 0) len = 0;

    store_pystring_content(listener, lexer->start_col, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 104 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 5:
#line 108 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 6:
#line 112 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 7:
#line 116 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 8:
#line 120 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 9:
#line 124 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 10:
#line 131 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 12:
#line 141 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 13:
#line 146 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 14:
#line 150 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 15:
#line 156 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 16:
#line 163 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 17:
#line 167 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 18:
#line 173 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 19:
#line 177 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 20:
#line 191 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1934 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 21:
#line 195 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1997 "ext/gherkin_lexer_ru/gherkin_lexer_ru.c"
		}
	}
	}

	_out: {}
	}

#line 411 "/Users/ahellesoy/scm/gherkin/tasks/../ragel/i18n/ru.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_ru()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Ru", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

