# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Represents whether or not a web app is cloneable
    #
    class SiteCloneability

      include MsRestAzure

      # @return [CloneAbilityResult] Name of web app. Possible values include:
      # 'Cloneable', 'PartiallyCloneable', 'NotCloneable'
      attr_accessor :result

      # @return [Array<SiteCloneabilityCriterion>] List of features enabled on
      # web app that prevent cloning
      attr_accessor :blocking_features

      # @return [Array<SiteCloneabilityCriterion>] List of features enabled on
      # web app that are non-blocking but cannot be cloned. The web app can
      # still be cloned
      # but the features in this list will not be set up on cloned web app.
      attr_accessor :unsupported_features

      # @return [Array<SiteCloneabilityCriterion>] List of blocking application
      # characteristics
      attr_accessor :blocking_characteristics


      #
      # Mapper for SiteCloneability class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'SiteCloneability',
          type: {
            name: 'Composite',
            class_name: 'SiteCloneability',
            model_properties: {
              result: {
                required: true,
                serialized_name: 'result',
                type: {
                  name: 'Enum',
                  module: 'CloneAbilityResult'
                }
              },
              blocking_features: {
                required: false,
                serialized_name: 'blockingFeatures',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'SiteCloneabilityCriterionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SiteCloneabilityCriterion'
                      }
                  }
                }
              },
              unsupported_features: {
                required: false,
                serialized_name: 'unsupportedFeatures',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'SiteCloneabilityCriterionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SiteCloneabilityCriterion'
                      }
                  }
                }
              },
              blocking_characteristics: {
                required: false,
                serialized_name: 'blockingCharacteristics',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'SiteCloneabilityCriterionElementType',
                      type: {
                        name: 'Composite',
                        class_name: 'SiteCloneabilityCriterion'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
