//kstore.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012
 *
 *  This file is part of libroar a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  libroar is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *  NOTE for everyone want's to change something and send patches:
 *  read README and HACKING! There a addition information on
 *  the license of this document you need to read before you send
 *  any patches.
 *
 *  NOTE for uses of non-GPL (LGPL,...) software using libesd, libartsc
 *  or libpulse*:
 *  The libs libroaresd, libroararts and libroarpulse link this lib
 *  and are therefore GPL. Because of this it may be illigal to use
 *  them with any software that uses libesd, libartsc or libpulse*.
 */

#ifndef _LIBROARKSTORE_H_
#define _LIBROARKSTORE_H_

#include "libroar.h"

struct roar_kstore;

struct roar_kstore * roar_kstore_new(ssize_t len,
                                     int (*ref)(void *), int (*unref)(void *),
                                     const char * (*get_key)(void *));
int                  roar_kstore_ref(struct roar_kstore * store);
int                  roar_kstore_unref(struct roar_kstore * store);

int                  roar_kstore_add(struct roar_kstore * store, void * obj, const char * key);
void *               roar_kstore_get(struct roar_kstore * store, const char * key);
int                  roar_kstore_delete(struct roar_kstore * store, const char * key);

// aliases:
#define roar_kstore_new_connection(len) roar_kstore_new((len),                \
                                        (int (*)(void*))roar_connectionref,   \
                                        (int (*)(void*))roar_connectionunref, \
                                        (const char * (*)(void*))roar_get_connection_server)

#endif

//ll
