#ifndef _RHEO_LUMPED_MASS_H
#define _RHEO_LUMPED_MASS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
#include "rheolef/form_element.h"

namespace rheolef { 

/*Class:
NAME: @code{lumped_mass} -- lumped L2 scalar product
@bfindex lumped mass
@apindex P0
@apindex P1d
@apindex bubble
@cindex  lumped mass procedure
SYNOPSIS:
    @example
        form(const space& V, const space& V, "lumped_mass");
  	form(const space& M, const space& V, "lumped_mass");
        form (const space& V, const space& V, "lumped_mass", const domain& gamma);
        form_diag(const space& V, "mass");
    @end example
EXAMPLE:
  The use of lumped mass form write:
  @example
   	form m(V, "lumped_mass");
  @end example
  or (see also @ref{mass form}):
  @example
   	form_diag md(V, "mass");
  @end example
  The lumped procedure sums all extra-diagonal terms on the diagonal:
  let us denote M the original mass matrix, then, the lumped mass matrix
  is the diagonal matrix defined by: 
  @example
                    n
                   ----
                   \
   	M1(i,i) =  /    M(i,j)
                   ----
                    j=1
  @end example
AUTHOR: 
    LMC-IMAG, 38041 Grenoble cedex 9, France
    | Pierre.Saramito@imag.fr
End:
*/
template<class T, class M>
class lumped_mass: public form_element_rep<T,M> {
public:
    typedef form_element_rep<T,M>       base;
    typedef typename base::size_type    size_type;
    typedef typename base::geo_type     geo_type;
    typedef typename base::space_type   space_type;

    lumped_mass (const space_type& X, const space_type& Y, const geo_type& omega,
        const quadrature_option_type& qopt)
	: form_element_rep<T,M> (X,Y,omega,qopt) { base::initialize_all(); }

    void operator() (const geo_element& K, ublas::matrix<T>& m) const;
    void initialize () const;
    bool is_symmetric () const { return true; }
};

}// namespace rheolef
#endif // _RHEOLEF_MASS_H
