% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.r
\name{str_replace}
\alias{str_replace}
\alias{str_replace_all}
\title{Replace matched patterns in a string.}
\usage{
str_replace(string, pattern, replacement)

str_replace_all(string, pattern, replacement)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern, replacement}{Supply separate pattern and replacement strings
  to vectorise over the patterns. References of the form \code{\1},
  \code{\2} will be replaced with the contents of the respective matched
  group (created by \code{()}) within the pattern.

  For \code{str_replace_all} only, you can perform multiple patterns and
  replacements to each string, by passing a named character to
  \code{pattern}.}
}
\value{
A character vector.
}
\description{
Vectorised over \code{string}, \code{pattern} and \code{replacement}.
}
\examples{
fruits <- c("one apple", "two pears", "three bananas")
str_replace(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", "-")

str_replace(fruits, "([aeiou])", "")
str_replace(fruits, "([aeiou])", "\\\\1\\\\1")
str_replace(fruits, "[aeiou]", c("1", "2", "3"))
str_replace(fruits, c("a", "e", "i"), "-")

fruits <- c("one apple", "two pears", "three bananas")
str_replace(fruits, "[aeiou]", "-")
str_replace_all(fruits, "[aeiou]", "-")

str_replace_all(fruits, "([aeiou])", "")
str_replace_all(fruits, "([aeiou])", "\\\\1\\\\1")
str_replace_all(fruits, "[aeiou]", c("1", "2", "3"))
str_replace_all(fruits, c("a", "e", "i"), "-")

# If you want to apply multiple patterns and replacements to the same
# string, pass a named version to pattern.
str_replace_all(str_c(fruits, collapse = "---"),
 c("one" = 1, "two" = 2, "three" = 3))
}
\seealso{
\code{str_replace_na} to turn missing values into "NA";
  \code{\link{stri_replace}} for the underlying implementation.
}

