% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_notebook_output.R
\name{html_notebook_output}
\alias{html_notebook_output}
\alias{html_notebook_output_html}
\alias{html_notebook_output_img}
\alias{html_notebook_output_png}
\alias{html_notebook_output_code}
\title{Generate R Notebook Output}
\usage{
html_notebook_output_html(html, meta = NULL)

html_notebook_output_img(path = NULL, bytes = NULL,
  attributes = NULL, meta = NULL, format = c("png", "jpeg"))

html_notebook_output_png(path = NULL, bytes = NULL,
  attributes = NULL, meta = NULL, format = c("png", "jpeg"))

html_notebook_output_code(code, attributes = list(class = "r"),
  meta = NULL)
}
\arguments{
\item{html}{Arbitrary HTML content to insert.}

\item{meta}{An \R list of arbitrary meta-data. The data will
be converted to JSON, base64-encoded, and injected into the header comment.}

\item{path}{A path to a file. For functions accepting both \code{path}
and \code{bytes}, if \code{bytes} is \code{NULL}, the bytewise contents
will be obtained by reading the file.}

\item{bytes}{The bytewise representation of content.}

\item{attributes}{A named \R list of HTML attributes. These will be
escaped and inserted into the generated HTML as appropriate.}

\item{format}{The image format; one of \code{"png"} or \code{"jpeg"}.}

\item{code}{Source code.}
}
\description{
Utilities for generating output for the \code{html_notebook} format,
through the \code{output_source} function attached to a
\code{\link{output_format}}.
}
\details{
See the \href{https://rmarkdown.rstudio.com/r_notebook_format.html}{online
documentation} for additional details on using the \code{html_notebook}
format.
}
