% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnmf.R
\name{step_nnmf}
\alias{step_nnmf}
\alias{tidy.step_nnmf}
\title{NNMF Signal Extraction}
\usage{
step_nnmf(recipe, ..., role = "predictor", trained = FALSE,
  num_comp = 2, num_run = 30, options = list(), res = NULL,
  prefix = "NNMF", seed = sample.int(10^5, 1), skip = FALSE,
  id = rand_id("nnmf"))

\method{tidy}{step_nnmf}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables will be used to compute the components. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new component columns created by the
original variables will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{num_comp}{The number of components to retain as new
predictors. If \code{num_comp} is greater than the number of columns
or the number of possible components, a smaller value will be
used.}

\item{num_run}{A positive integer for the number of computations runs used
to obtain a consensus projection.}

\item{options}{A list of options to \code{\link[NMF:nmf]{NMF::nmf()}} by way of
\code{\link[dimRed:NNMF]{dimRed::NNMF()}}. \strong{Note} that the arguments
\code{data} and \code{ndim} should not be passed here.}

\item{res}{The \code{\link[dimRed:NNMF]{dimRed::NNMF()}} object is stored
here once this preprocessing step has be trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. See notes below.}

\item{seed}{An integer that will be used to set the seed in isolation
when computing the factorization.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_nnmf} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} (the
selectors or variables selected) and the number of components.
}
\description{
\code{step_nnmf} creates a \emph{specification} of a recipe step
that will convert numeric data into one or more non-negative
components.
}
\details{
Non-negative matrix factorization computes latent components that
have non-negative values and take into account that the original data
have non-negative values.

The argument \code{num_comp} controls the number of components that
will be retained (the original variables that are used to derive
the components are removed from the data). The new components
will have names that begin with \code{prefix} and a sequence of
numbers. The variable names are padded with zeros. For example,
if \code{num < 10}, their names will be \code{NNMF1} - \code{NNMF9}.
If \code{num = 101}, the names would be \code{NNMF001} -
\code{NNMF101}.
}
\examples{
\donttest{
data(biomass)

if (require(dimRed) & require(NMF)) {
  rec <- recipe(HHV ~ ., data = biomass) \%>\%
    update_role(sample, new_role = "id var") \%>\%
    update_role(dataset, new_role = "split variable") \%>\%
    step_nnmf(all_predictors(), num_comp = 2, seed = 473, num_run = 2) \%>\%
    prep(training = biomass, retain = TRUE)

  juice(rec)

  library(ggplot2)
  ggplot(juice(rec), aes(x = NNMF2, y = NNMF1, col = HHV)) + geom_point()
}
}
}
\seealso{
\code{\link[=step_pca]{step_pca()}}, \code{\link[=step_ica]{step_ica()}}, \code{\link[=step_kpca]{step_kpca()}},
\code{\link[=step_isomap]{step_isomap()}}, \code{\link[=recipe]{recipe()}}, \code{\link[=prep.recipe]{prep.recipe()}},
\code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{preprocessing nnmf projection_methods}
\keyword{datagen}
