% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-continuous.r
\name{scale_continuous}
\alias{scale_x_continuous}
\alias{scale_y_continuous}
\alias{scale_x_log10}
\alias{scale_y_log10}
\alias{scale_x_reverse}
\alias{scale_y_reverse}
\alias{scale_x_sqrt}
\alias{scale_y_sqrt}
\title{Position scales for continuous data (x & y)}
\usage{
scale_x_continuous(name = waiver(), breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = censor, na.value = NA_real_,
  trans = "identity", position = "bottom", sec.axis = waiver())

scale_y_continuous(name = waiver(), breaks = waiver(),
  minor_breaks = waiver(), labels = waiver(), limits = NULL,
  expand = waiver(), oob = censor, na.value = NA_real_,
  trans = "identity", position = "left", sec.axis = waiver())

scale_x_log10(...)

scale_y_log10(...)

scale_x_reverse(...)

scale_y_reverse(...)

scale_x_sqrt(...)

scale_y_sqrt(...)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
transformation object
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks.
}}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item A function that takes the breaks as input and returns labels
as output
}}

\item{limits}{A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum.}

\item{expand}{Vector of range expansion constants used to add some
padding around the data, to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[=expand_scale]{expand_scale()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}

\item{oob}{Function that handles limits outside of the scale limits
(out of bounds). The default replaces out of bounds values with \code{NA}.}

\item{na.value}{Missing values will be replaced with this value.}

\item{trans}{Either the name of a transformation object, or the
object itself. Built-in transformations include "asn", "atanh",
"boxcox", "exp", "identity", "log", "log10", "log1p", "log2",
"logit", "probability", "probit", "reciprocal", "reverse" and "sqrt".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \code{name_trans}, e.g.
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}. You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}

\item{position}{The position of the axis. "left" or "right" for vertical
scales, "top" or "bottom" for horizontal scales}

\item{sec.axis}{specify a secondary axis}

\item{...}{Other arguments passed on to \code{scale_(x|y)_continuous()}}
}
\description{
\code{scale_x_continuous()} and \code{scale_y_continuous()} are the default
scales for continuous x and y aesthetics. There are three variants
that set the \code{trans} argument for commonly used transformations:
\code{scale_*_log10()}, \code{scale_*_sqrt()} and \code{scale_*_reverse()}.
}
\details{
For simple manipulation of labels and limits, you may wish to use
\code{\link[=labs]{labs()}} and \code{\link[=lims]{lims()}} instead.
}
\examples{
p1 <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()
p1

# Manipulating the default position scales lets you:
#  * change the axis labels
p1 +
  scale_x_continuous("Engine displacement (L)") +
  scale_y_continuous("Highway MPG")

# You can also use the short-cut labs().
# Use NULL to suppress axis labels
p1 + labs(x = NULL, y = NULL)

#  * modify the axis limits
p1 + scale_x_continuous(limits = c(2, 6))
p1 + scale_x_continuous(limits = c(0, 10))

# you can also use the short hand functions `xlim()` and `ylim()`
p1 + xlim(2, 6)

#  * choose where the ticks appear
p1 + scale_x_continuous(breaks = c(2, 4, 6))

#  * choose your own labels
p1 + scale_x_continuous(
  breaks = c(2, 4, 6),
  label = c("two", "four", "six")
)

# Typically you'll pass a function to the `labels` argument.
# Some common formats are built into the scales package:
df <- data.frame(
  x = rnorm(10) * 100000,
  y = seq(0, 1, length.out = 10)
)
p2 <- ggplot(df, aes(x, y)) + geom_point()
p2 + scale_y_continuous(labels = scales::percent)
p2 + scale_y_continuous(labels = scales::dollar)
p2 + scale_x_continuous(labels = scales::comma)

# You can also override the default linear mapping by using a
# transformation. There are three shortcuts:
p1 + scale_y_log10()
p1 + scale_y_sqrt()
p1 + scale_y_reverse()

# Or you can supply a transformation in the `trans` argument:
p1 + scale_y_continuous(trans = scales::reciprocal_trans())

# You can also create your own. See ?scales::trans_new

}
\seealso{
\code{\link[=sec_axis]{sec_axis()}} for how to specify secondary axes

Other position scales: \code{\link{scale_x_date}},
  \code{\link{scale_x_discrete}}
}
\concept{position scales}
