% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{import_uparse}
\alias{import_uparse}
\title{Import \href{http://www.drive5.com/usearch/manual/opt_uparseout.html}{UPARSE file format}}
\usage{
import_uparse(upFile, omitChimeras = TRUE, countTable = TRUE,
  OTUtable = TRUE, verbose = TRUE)
}
\arguments{
\item{upFile}{(Required). A file location character string 
or \code{\link{connection}}
corresponding to the file that contains the UPARSE output table.
This is passed directly to \code{\link[data.table]{fread}}.
Please see its \code{file} argument documentation for further
links and details.}

\item{omitChimeras}{(Optional). \code{logical(1)}. 
Default is \code{TRUE}.
Whether to omit entries that correspond to sequences/OTUs
that were identified as chimeras.}

\item{countTable}{(Optional). \code{logical(1)}. 
Default is \code{TRUE}.
Whether to return the result as a wide-format table
with dimensions OTU-by-sample,
or to leave the table in its original sparse long-format
that might be more suitable for certain \code{\link{data.table}} operations.
If \code{TRUE}, entries corresponding to the same sample and OTU
have their counts summed.}

\item{OTUtable}{(Optional). \code{logical(1)}. 
Default is \code{TRUE}.
Whether to coerce the result to \code{\link{otu_table}} format,
or leave it as a \code{\link{data.table}} format.
The former is appropriate for most \code{\link{phyloseq}} operations,
the latter is useful for a lot of custom operations
and custom \code{\link[ggplot2]{ggplot}2} graphics calls.}

\item{verbose}{(Optional). A \code{\link{logical}}.
Default is \code{TRUE}. 
Should progresss messages
be \code{\link{cat}}ted to standard out?}
}
\description{
UPARSE is an algorithm for OTU-clustering implemented within usearch.
At last check, the UPARSE algortihm was accessed via the 
\code{-cluster_otu} option flag.
For details about installing and running usearch, please refer to the
\href{http://drive5.com/usearch/}{usearch website}.
For details about the output format, please refer to the
\href{http://www.drive5.com/usearch/manual/opt_uparseout.html}{uparse format definition}.
}
\details{
Because UPARSE is an external (non-R) application, there is no direct
way to continuously check that these suggested arguments and file formats will 
remain in their current state. 
If there is a problem, please verify your version of usearch,
create a small reproducible example of the problem,
and post it as an issue on the 
\href{https://github.com/joey711/phyloseq/issues}{phyloseq issues tracker}.
}
\examples{
###
}
\seealso{
\code{\link{import_usearch_uc}}
}

