% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO-methods.R
\name{export_mothur_dist}
\alias{export_mothur_dist}
\title{Export a distance object as \code{.names} and \code{.dist} files for mothur}
\usage{
export_mothur_dist(x, out=NULL, makeTrivialNamesFile=NULL)
}
\arguments{
\item{x}{(Required). A \code{"dist"} object, or a symmetric matrix.}

\item{out}{(Optional). The desired output filename for the \code{.dist} file, OR
left \code{NULL}, the default, in which case the mothur-formated distance table
is returned to \code{R} standard out.}

\item{makeTrivialNamesFile}{(Optional). Default \code{NULL}. The desired name of the \code{.names} file.
If left \code{NULL}, the file name will be a modified version of the \code{out} argument.}
}
\value{
A character vector of the different cutoff values contained in the file.
 For a given set of arguments to the \code{cluster()} command from within
 \emph{mothur}, a number of OTU-clustering results are returned in the same
 list file. The exact cutoff values used by \emph{mothur} can vary depending
 on the input data. This simple function returns the cutoffs that were actually
 included in the \emph{mothur} output. This an important extra step prior to
 importing the OTUs with the \code{import_mothur_otulist()} function.
}
\description{
The purpose of this function is to allow a user to easily export a distance object
as a pair of files that can be immediately imported by mothur for OTU clustering
and related analysis. A distance object can be created in \code{R} in a number of
ways, including via cataloguing the cophentic distances of a tree object.
}
\examples{
#
data(esophagus) 
myDistObject <- as.dist(ape::cophenetic.phylo(phy_tree(esophagus)))
export_mothur_dist(myDistObject)
}

