### =========================================================================
### Some low-level (non exported) utility functions.
### -------------------------------------------------------------------------


### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### Used by "show" methods.
###

makeClassinfoRowForCompactPrinting <- function(x, col2class)
{
    ans_names <- names(col2class)
    no_bracket <- ans_names == ""
    ans_names[no_bracket] <- col2class[no_bracket]
    left_brackets <- right_brackets <- character(length(col2class))
    left_brackets[!no_bracket] <- "<"
    right_brackets[!no_bracket] <- ">"
    ans <- paste0(left_brackets, col2class, right_brackets)
    names(ans) <- ans_names
    if (ncol(mcols(x)) > 0L) {
        tmp <- sapply(mcols(x),
                      function(xx) paste0("<", classNameForDisplay(xx), ">"))
        ans <- c(ans, `|`="|", tmp)
    }
    matrix(ans, nrow=1L, dimnames=list("", names(ans)))
}

compactPrintNamedAtomicVector <- function(x, margin="")
{
    x_len <- length(x)
    halfWidth <- (getOption("width") - nchar(margin)) %/% 2L
    first <- max(1L, halfWidth)
    showMatrix <-
      rbind(as.character(head(names(x), first)),
            as.character(head(x, first)))
    if (x_len > first) {
        last <- min(x_len - first, halfWidth)
        showMatrix <-
          cbind(showMatrix,
                rbind(as.character(tail(names(x), last)),
                      as.character(tail(x, last))))
    }
    showMatrix <- format(showMatrix, justify="right")
    cat(BiocGenerics:::labeledLine(margin, showMatrix[1L, ], count=FALSE,
                                           labelSep=""), sep="")
    cat(BiocGenerics:::labeledLine(margin, showMatrix[2L, ], count=FALSE,
                                           labelSep=""), sep="")
}

showSeqlengths <- function(object, margin="")
{
    cat(margin, "seqlengths:\n", sep="")
    compactPrintNamedAtomicVector(seqlengths(object), margin=margin)
}


### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### Used by "elementMetadata<-" methods.
###

### Try to turn 'value' into a DataFrame compatible with 'x'.
### Used in GenomicAlignments package.
normalizeMetadataColumnsReplacementValue <- function(value, x)
{
    if (is.null(value))
        return(new("DataFrame", nrows=length(x)))
    if (!is(value, "DataFrame"))
        value <- DataFrame(value)
    if (!is.null(rownames(value)))
        rownames(value) <- NULL
    n <- length(x)
    k <- nrow(value)
    if (k == n)
        return(value)
    if ((k == 0L) || (k > n) || (n %% k != 0L))
        stop(k, " rows in value to replace ", n, " rows")
    value[rep(seq_len(k), length.out=n), , drop=FALSE]
}


### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### Other stuff...
###

### Note that, strictly speaking, mergeNamedAtomicVectors() is not
### commutative, i.e., in general 'z1 <- mergeNamedAtomicVectors(x, y)' is
### not identical to 'z2 <- mergeNamedAtomicVectors(y, x)'. However 'z1' and
### 'z2' are both guaranteed to have unique names and to contain the same set
### of name/value pairs (but typically not in the same order).
mergeNamedAtomicVectors <- function(x, y, what=c("key", "values"))
{
    if (!is.atomic(x) || !is.atomic(y) || typeof(x) != typeof(y))
        stop("'x' and 'y' must be atomic vectors of the same type")
    x_names <- names(x)
    y_names <- names(y)
    if (is.null(x_names) || is.null(y_names))
        stop("'x' and 'y' must have names")
    ans_names <- union(x_names, y_names)
    if (any(ans_names %in% c(NA_character_, "")))
        stop("some names in 'x' or 'y' are NA or the empty string")
    ## Note sure why but subsetting by name is *very* slow when the character
    ## vector used as subscript contains a lot of "invalid" names. I already
    ## reported this issue twice on the R-devel mailing list (in July 2010 and
    ## May 2013) with no answer so far.
    #ans <- x[ans_names]  # very slow :-(
    ans <- x[match(ans_names, x_names)]  # much faster :-)
    ## Some of 'ans' names can be NA. This is because subsetting a named
    ## vector 'x' by a character vector 'i' returns a vector whose names
    ## are 'i' except for the values in 'i' that are not in 'names(x)'.
    ## So we need to fix this.
    names(ans) <- ans_names
    #ans2 <- y[ans_names]  # very slow :-(
    ans2 <- y[match(ans_names, y_names)]  # much faster :-)
    idx <- which(ans != ans2)
    if (length(idx) != 0L) {
        msg <- c(what[1L], ifelse(length(idx) >= 2, "s", ""), " ",
                 paste(ans_names[idx], collapse=", "), " ",
                 ifelse(length(idx) >= 2, "have", "has"),
                 " incompatible ", what[2L], ":\n  - in 'x': ",
                 paste(ans[idx], collapse=", "), "\n  - in 'y': ",
                 paste(ans2[idx], collapse=", "))
        stop(msg)
    }
    idx <- is.na(ans) & !is.na(ans2)
    ans[idx] <- ans2[idx]
    ans
}

hasHead <- function(x, h) {
  identical(head(x, length(h)), h)
}

### TODO: Use this in GenomicFeatures::transcriptLocs2refLocs() and remove
### GenomicFeatures:::.normargExonStartsOrEnds().
### Used in GenomicAlignments package.
normargListOfIntegers <- function(arg, sep, argname) 
{
    if (is.list(arg))
        return(arg)
    if (is(arg, "IntegerList"))
        return(as.list(arg))
    if (is.character(arg))
        return(strsplitAsListOfIntegerVectors(arg, sep=sep))
    stop("'", argname, "' must be a list of integer vectors, ",
        "an IntegerList object,\n  or a character vector where ",
        "each element is a comma-separated list of\n  integers")
}

