<CsoundSynthesizer>

; Id: D00_a.CSD mg (2006, rev.2009)
; author: marco gasperini (marcogsp at yahoo dot it)

; G.M. Koenig
; ESSAY (1957)

<CsOptions>
-W -f -oD00_a.wav
</CsOptions>

<CsInstruments>

sr     = 192000
kr     = 19200
ksmps  = 10
nchnls = 1

;=============================================
; SINUS TONES (S)
;=============================================
	instr 1	
iamp	= ampdb(90+p4)
ifreq	= p5

a1	oscili iamp , ifreq , 1
aenv	expseg .001 , .005, 1 , p3-.01 ,1, .005,.001

aout	= a1 * aenv

	out aout
	endin
;=============================================

;=============================================
; FILTERED NOISE (N)
;=============================================
	instr 2
iamp	= ampdb(89+p4)
ifreq	= p5
ibw	= ifreq * .05		; filtered noise's bandwidth 5% of central frequency

a1	rnd31 iamp , 1 
k1	rms a1

afilt	butterbp a1 , ifreq , ibw
afilt	butterbp afilt , ifreq , ibw

aenv	expseg .001 , .005, .8 , p3-.01 ,.8 ,.005,.001

aout	gain afilt , k1
aout	= aout * aenv 

	out aout
	endin
;=============================================

;=============================================
; FILTERED IMPULSES (I)
;=============================================
	instr 3
iamp	= ampdb(90+p4)
ifreq	= p5
ibw	= ifreq * .01		; filtered pulse's bandwidth 1% of central frequency

if1	= ifreq-(ibw/3)
if2	= ifreq+((2*ibw)/3)

				
a1	mpulse iamp , 0 

afilt	atonex a1 , if1 , 2
afilt	tonex afilt*250 , if2 , 2  
afilt	butterbp afilt*60 , ifreq , ibw*.5

aenv	linseg 1 , p3-.01, 1 , .01 , 0

aout	= afilt * aenv 

	out aout
	endin
;=============================================
</CsInstruments>
<CsScore>
;functions--------------------------------------------------
f1	0	8192	10	1	; sinusoid
;/functions--------------------------------------------------

t0	4572	; 76.2 cm/sec. tape speed (durations in cm)

;test--------------------------------------------------
;mute-------------------------------------------------
q 1 0 1
q 2 0 1
q 3 0 1
;/mute-------------------------------------------------
;/test-------------------------------------------------

;====================================================
; 140. MATERIAL D
; 141. total length: 865.7 cm, 9 sections
;
; sequence a
;
; length    sequence 	
; 197.5  cm (8)
; 39     cm (4)
; 296.3  cm (9)
; 58.5   cm (5)
; 11.6   cm (1)
; 17.3   cm (2)
; 131.7  cm (7)
; 87.7   cm (6)
; 26     cm (3)
;==================================================

;==================================141.11
; 197.5 cm 5/4
;----------------------------------------
;			p4	p5
;			iamp	ifreq	timbre
;			[dB]	[Hz]	
; x
i2	0	38	-9	1600	; R
i2	+	30.4	-9	1467    ; R
i2	+	15.6	-9	1345    ; R
i2	+	9.9	-9	1234    ; R
i2	+	47.5	-9	1131    ; R
i2	+	19.4	-9	1037    ; R
i2	+	12.4	-9	951     ; R
i2	+	24.3	-9	872     ; R
; y                                 
i2	0	38	-9	800	; R
i2	+	30.4	-9	872     ; R
i2	+	15.6	-9	951     ; R
i2	+	9.9	-9	1037    ; R
i2	+	47.5	-9	1131    ; R
i2	+	19.4	-9	1234    ; R
i2	+	12.4	-9	1345    ; R
i2	+	24.3	-9	1467    ; R
s                                   
t0	4572	
;==================================141.12
; 39 cm 9/8
;----------------------------------------
; x
i3	0	5.6	-5.5	993	; I
i2	5.6	5	-9	983     ; R
i2	+	3.5	-9	951     ; R
i2	+	7.1	-9	1015    ; R
i2	+	6.3	-9	1004    ; R
i2	+	4	-9	962     ; R
i2	+	3.1	-9	1026    ; R
i2	+	4.4	-9	972     ; R
; y                                 
i3	0	5.6	-5.5	1037	; I
i2	5.6	5	-9	1083    ; R
i2	+	3.5	-9	1131    ; R
i2	+	7.1	-9	1181    ; R
i2	+	6.3	-9	1207    ; R
i2	+	4	-9	1156    ; R
i2	+	3.1	-9	1107    ; R
i2	+	4.4	-9	1060    ; R
s                                   
t0	4572	
;==================================141.13
; 296.3 cm 4/3
;----------------------------------------
i3	0	19.5	-2	1345	; I
i3	+	14.7	-1.5	1275    ; I
i2	34.2	61.7	-5	1207    ; R
i2	+	34.7	-5	1144    ; R
i2	+	26.1	-5	1083    ; R
i2	+	82.3	-5	1026    ; R
i2	+	46.3	-5	972     ; R
i2	+	11	-5	921     ; R
s                                   
t0	4572	
;==================================141.14
; 58.5 cm 8/7
;----------------------------------------
; x
i3	0	4.4	-6.5	1234	; I
i3	+	11.1	-6.5	1207    ; I
i3	+	7.5	-6	1131    ; I
i2	23	5.7	-9	1288    ; R
i2	+	5	-9	1261    ; R
i2	+	8.5	-9	1156    ; R
i2	+	6.5	-9	1317    ; R
i2	+	9.8	-9	1181    ; R
; y                                 
i3	0	4.4	-5	951	; I
i3	+	11.1	-5	994     ; I
i3	+	7.5	-5.5	1037    ; I
i2	23	5.7	-9	1083    ; R
i2	+	5	-9	1107    ; R
i2	+	8.5	-9	1060    ; R
i2	+	6.5	-9	1015    ; R
i2	+	9.8	-9	972     ; R
s                                   
t0	4572	
;==================================141.15
; 11.6 cm 12/11
;----------------------------------------
i3	0	1.9	0	1083	; I
i3	+	1.8	0	1071    ; I
i3	+	1.4	0	1037    ; I
i3	+	1.1	-.5	1107    ; I
i2	6.2	1	-4	1095    ; R
i2	+	1.5	-4	1048    ; R
i2	+	1.3	-4	1119    ; R
i2	+	1.6	-4	1060    ; R
s                                   
t0	4572	
;==================================141.16
; 17.3 cm 11/10
;----------------------------------------
; x
i3	0	2	-4.5	911	; I
i3	+	1.8	-4.5	882     ; I
i3	+	3	-3.5	800     ; I
i3	+	2.4	-4.5	972     ; I
i3	+	2.2	-4.5	941     ; I
i2	11.4	1.5	-9	826     ; R
i2	+	2.7	-9	1004    ; R
i2	+	1.7	-9	854     ; R
; y                                 
i3	0	2	-8.5	1467	; I
i3	+	1.8	-8	1345    ; I
i3	+	3	-7.5	1234    ; I
i3	+	2.4	-6	1131    ; I
i3	+	2.2	-5.5	1083    ; I
i2	11.4	1.5	-9	1181    ; R
i2	+	2.7	-9	1288    ; R
i2	+	1.7	-9	1405    ; R
s                                   
t0	4572	
;==================================141.17
; 131.7 cm 6/5
;----------------------------------------
i3	0	9.6	1	951	; I
i3	+	8	.5	1015    ; I
i3	+	19.9	-.5	1083    ; I
i3	+	13.8	-1	1156    ; I
i3	+	11.5	-1.2	1234    ; I
i3	+	23.8	-2	1317    ; I
i2	86.6	16.5	-4	1405    ; R
i2	+	28.6	-4	1499    ; R
s                                   
t0	4572	
;==================================141.18
; 87.7 cm 7/6
;----------------------------------------
; x
i3	0	11.1	-6.5	1181	; I
i3	+	9.5	-6.5	1169    ; I
i3	+	6	-6.5	1131    ; I
i3	+	15.2	-6.5	1207    ; I
i3	+	13	-6.5	1194    ; I
i3	+	7	-6.5	1141    ; I
i3	+	17.7	-6.5	1220    ; I
i2	79.5	8.2	-9	1156    ; R
; y                                 
i3	0	11.1	-6	1119	; I
i3	+	9.5	-6	1095    ; I
i3	+	6	-6	1072    ; I
i3	+	15.2	-5.5	1049    ; I
i3	+	13	-5.5	1037    ; I
i3	+	7	-6	1060    ; I
i3	+	17.7	-5.5	1083    ; I
i2	79.5	8.2	-9	1107    ; R
s                                   
t0	4572	
;==================================141.19
; 26 cm 10/9
;----------------------------------------
; x
i3	0	4.1	-9	1600	; I
i3	+	3.7	-9	1467    ; I
i3	+	2.7	-8	1345    ; I
i3	+	2.2	-7	1234    ; I
i3	+	4.6	-7	1131    ; I
i3	+	3	-6	1037    ; I
i3	+	2.4	-5.5	951     ; I
i3	+	3.3	-4.5	872     ; I
; y                                 
i3	0	4.1	-4	800	; I
i3	+	3.7	-4.5	872     ; I
i3	+	2.7	-5.5	951     ; I
i3	+	2.2	-5	1037    ; I
i3	+	4.6	-7	1131    ; I
i3	+	3	-7.5	1234    ; I
i3	+	2.4	-8	1345    ; I
i3	+	3.3	-9	1467    ; I
                                    
; total length: 865.7 cm
e
</CsScore>
</CsoundSynthesizer>