/*
 * Copyright (C) 2014 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SharedBufferReader_h
#define SharedBufferReader_h

#include "core/CoreExport.h"
#include "wtf/Allocator.h"
#include "wtf/Forward.h"
#include "wtf/RefPtr.h"

namespace blink {

class SharedBuffer;

// Allows transfer of data in multiple chunks from a SharedBuffer to a provided buffer.
class CORE_EXPORT SharedBufferReader {
    USING_FAST_MALLOC(SharedBufferReader);
public:
    SharedBufferReader(PassRefPtr<SharedBuffer>);

    ~SharedBufferReader();

    // Returns the number of bytes that were read (i.e. written to |outputBuffer|).
    // TODO(junov): use size_t instead of int. Until then, readData uses safeCast internally.
    int readData(char* outputBuffer, int askedToRead);

private:
    RefPtr<SharedBuffer> m_buffer;
    size_t m_currentOffset;
};

} // namespace blink

#endif // SharedBufferReader_h
