// Copyright (c) 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file automatically generated by testing/generate_gmock_mutant.py.
// DO NOT EDIT.

#ifndef TESTING_GMOCK_MUTANT_H_
#define TESTING_GMOCK_MUTANT_H_

// The intention of this file is to make possible using GMock actions in
// all of its syntactic beauty. Classes and helper functions can be used as
// more generic variants of Task and Callback classes (see base/task.h)
// Mutant supports both pre-bound arguments (like Task) and call-time
// arguments (like Callback) - hence the name. :-)
//
// DispatchToMethod/Function supports two sets of arguments: pre-bound (P) and
// call-time (C). The arguments as well as the return type are templatized.
// DispatchToMethod/Function will also try to call the selected method or
// function even if provided pre-bound arguments does not match exactly with
// the function signature hence the X1, X2 ... XN parameters in CreateFunctor.
// DispatchToMethod will try to invoke method that may not belong to the
// object's class itself but to the object's class base class.
//
// Additionally you can bind the object at calltime by binding a pointer to
// pointer to the object at creation time - before including this file you
// have to #define GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING.
//
// TODO(stoyan): It's yet not clear to me should we use T& and T&* instead
// of T* and T** when we invoke CreateFunctor to match the EXPECT_CALL style.
//
//
// Sample usage with gMock:
//
// struct Mock : public ObjectDelegate {
//   MOCK_METHOD2(string, OnRequest(int n, const string& request));
//   MOCK_METHOD1(void, OnQuit(int exit_code));
//   MOCK_METHOD2(void, LogMessage(int level, const string& message));
//
//   string HandleFlowers(const string& reply, int n, const string& request) {
//     string result = SStringPrintf("In request of %d %s ", n, request);
//     for (int i = 0; i < n; ++i) result.append(reply)
//     return result;
//   }
//
//   void DoLogMessage(int level, const string& message) {
//   }
//
//   void QuitMessageLoop(int seconds) {
//     base::MessageLoop* loop = base::MessageLoop::current();
//     loop->PostDelayedTask(FROM_HERE,
//                           base::MessageLoop::QuitWhenIdleClosure(),
//                           1000 * seconds);
//   }
// };
//
// Mock mock;
// // Will invoke mock.HandleFlowers("orchids", n, request)
// // "orchids" is a pre-bound argument, and <n> and <request> are call-time
// // arguments - they are not known until the OnRequest mock is invoked.
// EXPECT_CALL(mock, OnRequest(Ge(5), base::StartsWith("flower"))
//   .Times(1)
//   .WillOnce(Invoke(CreateFunctor(&mock, &Mock::HandleFlowers,
//       string("orchids"))));
//
//
// // No pre-bound arguments, two call-time arguments passed
// // directly to DoLogMessage
// EXPECT_CALL(mock, OnLogMessage(_, _))
//   .Times(AnyNumber())
//   .WillAlways(Invoke(CreateFunctor, &mock, &Mock::DoLogMessage));
//
//
// // In this case we have a single pre-bound argument - 3. We ignore
// // all of the arguments of OnQuit.
// EXCEPT_CALL(mock, OnQuit(_))
//   .Times(1)
//   .WillOnce(InvokeWithoutArgs(CreateFunctor(
//       &mock, &Mock::QuitMessageLoop, 3)));
//
// MessageLoop loop;
// loop.Run();
//
//
//  // Here is another example of how we can set an action that invokes
//  // method of an object that is not yet created.
// struct Mock : public ObjectDelegate {
//   MOCK_METHOD1(void, DemiurgeCreated(Demiurge*));
//   MOCK_METHOD2(void, OnRequest(int count, const string&));
//
//   void StoreDemiurge(Demiurge* w) {
//     demiurge_ = w;
//   }
//
//   Demiurge* demiurge;
// }
//
// EXPECT_CALL(mock, DemiurgeCreated(_)).Times(1)
//    .WillOnce(Invoke(CreateFunctor(&mock, &Mock::StoreDemiurge)));
//
// EXPECT_CALL(mock, OnRequest(_, StrEq("Moby Dick")))
//    .Times(AnyNumber())
//    .WillAlways(WithArgs<0>(Invoke(
//        CreateFunctor(&mock->demiurge_, &Demiurge::DecreaseMonsters))));
//

#include "base/memory/linked_ptr.h"
#include "base/tuple.h"

namespace testing {

// 0 - 0
template <typename R, typename T, typename Method>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)();
}
template <typename R, typename Function>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<>& c) {
  return (*function)();
}

// 0 - 1
template <typename R, typename T, typename Method, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(c));
}
template <typename R, typename Function, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(c));
}

// 0 - 2
template <typename R, typename T, typename Method, typename C1, typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(c), base::get<1>(c));
}
template <typename R, typename Function, typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(c), base::get<1>(c));
}

// 0 - 3
template <typename R, typename T, typename Method, typename C1, typename C2,
          typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(c), base::get<1>(c), base::get<2>(c));
}
template <typename R, typename Function, typename C1, typename C2, typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(c), base::get<1>(c), base::get<2>(c));
}

// 0 - 4
template <typename R, typename T, typename Method, typename C1, typename C2,
          typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c));
}
template <typename R, typename Function, typename C1, typename C2, typename C3,
          typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c));
}

// 0 - 5
template <typename R, typename T, typename Method, typename C1, typename C2,
          typename C3, typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename C1, typename C2, typename C3,
          typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c));
}

// 0 - 6
template <typename R, typename T, typename Method, typename C1, typename C2,
          typename C3, typename C4, typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c), base::get<5>(c));
}
template <typename R, typename Function, typename C1, typename C2, typename C3,
          typename C4, typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c), base::get<5>(c));
}

// 1 - 0
template <typename R, typename T, typename Method, typename P1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p));
}
template <typename R, typename Function, typename P1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p));
}

// 1 - 1
template <typename R, typename T, typename Method, typename P1, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c));
}

// 1 - 2
template <typename R, typename T, typename Method, typename P1, typename C1,
          typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c), base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c), base::get<1>(c));
}

// 1 - 3
template <typename R, typename T, typename Method, typename P1, typename C1,
          typename C2, typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename C1, typename C2,
          typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c));
}

// 1 - 4
template <typename R, typename T, typename Method, typename P1, typename C1,
          typename C2, typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename C1, typename C2,
          typename C3, typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c));
}

// 1 - 5
template <typename R, typename T, typename Method, typename P1, typename C1,
          typename C2, typename C3, typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename C1, typename C2,
          typename C3, typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c));
}

// 1 - 6
template <typename R, typename T, typename Method, typename P1, typename C1,
          typename C2, typename C3, typename C4, typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c), base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename C1, typename C2,
          typename C3, typename C4, typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c), base::get<5>(c));
}

// 2 - 0
template <typename R, typename T, typename Method, typename P1, typename P2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p));
}
template <typename R, typename Function, typename P1, typename P2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p));
}

// 2 - 1
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c));
}

// 2 - 2
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1, typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1,
          typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c));
}

// 2 - 3
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1, typename C2, typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1,
          typename C2, typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c));
}

// 2 - 4
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1, typename C2, typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1,
          typename C2, typename C3, typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c));
}

// 2 - 5
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1, typename C2, typename C3, typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1,
          typename C2, typename C3, typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c));
}

// 2 - 6
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename C1, typename C2, typename C3, typename C4, typename C5,
          typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c),
      base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename C1,
          typename C2, typename C3, typename C4, typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c),
      base::get<5>(c));
}

// 3 - 0
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p));
}
template <typename R, typename Function, typename P1, typename P2, typename P3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p));
}

// 3 - 1
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c));
}

// 3 - 2
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1, typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c));
}

// 3 - 3
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1, typename C2, typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1, typename C2, typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c));
}

// 3 - 4
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1, typename C2, typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1, typename C2, typename C3, typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c));
}

// 3 - 5
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1, typename C2, typename C3, typename C4,
          typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c),
      base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1, typename C2, typename C3, typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c),
      base::get<4>(c));
}

// 3 - 6
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename C1, typename C2, typename C3, typename C4,
          typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c),
      base::get<4>(c), base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename C1, typename C2, typename C3, typename C4, typename C5,
          typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<0>(c), base::get<1>(c), base::get<2>(c), base::get<3>(c),
      base::get<4>(c), base::get<5>(c));
}

// 4 - 0
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p));
}

// 4 - 1
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c));
}

// 4 - 2
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1, typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c));
}

// 4 - 3
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1, typename C2, typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1, typename C2, typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c));
}

// 4 - 4
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1, typename C2, typename C3,
          typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1, typename C2, typename C3, typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c));
}

// 4 - 5
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1, typename C2, typename C3,
          typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1, typename C2, typename C3, typename C4,
          typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c));
}

// 4 - 6
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename C1, typename C2, typename C3,
          typename C4, typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c), base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename C1, typename C2, typename C3, typename C4,
          typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<0>(c), base::get<1>(c), base::get<2>(c),
      base::get<3>(c), base::get<4>(c), base::get<5>(c));
}

// 5 - 0
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p));
}

// 5 - 1
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c));
}

// 5 - 2
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1, typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c));
}

// 5 - 3
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1, typename C2,
          typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1, typename C2, typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c));
}

// 5 - 4
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1, typename C2,
          typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1, typename C2, typename C3,
          typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c));
}

// 5 - 5
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1, typename C2,
          typename C3, typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1, typename C2, typename C3,
          typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c));
}

// 5 - 6
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename C1, typename C2,
          typename C3, typename C4, typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c), base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename C1, typename C2, typename C3,
          typename C4, typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<0>(c), base::get<1>(c),
      base::get<2>(c), base::get<3>(c), base::get<4>(c), base::get<5>(c));
}

// 6 - 0
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p));
}

// 6 - 1
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c));
}

// 6 - 2
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1,
          typename C2>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1, C2>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1, typename C2>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1, C2>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c));
}

// 6 - 3
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1,
          typename C2, typename C3>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1, C2, C3>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1, typename C2,
          typename C3>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1, C2, C3>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c));
}

// 6 - 4
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1,
          typename C2, typename C3, typename C4>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1, C2, C3, C4>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1, typename C2,
          typename C3, typename C4>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1, C2, C3, C4>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c));
}

// 6 - 5
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1,
          typename C2, typename C3, typename C4, typename C5>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1, typename C2,
          typename C3, typename C4, typename C5>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1, C2, C3, C4, C5>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c));
}

// 6 - 6
template <typename R, typename T, typename Method, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename C1,
          typename C2, typename C3, typename C4, typename C5, typename C6>
inline R DispatchToMethod(T* obj, Method method,
                          const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                          const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (obj->*method)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c),
      base::get<5>(c));
}
template <typename R, typename Function, typename P1, typename P2, typename P3,
          typename P4, typename P5, typename P6, typename C1, typename C2,
          typename C3, typename C4, typename C5, typename C6>
inline R DispatchToFunction(Function function,
                            const base::Tuple<P1, P2, P3, P4, P5, P6>& p,
                            const base::Tuple<C1, C2, C3, C4, C5, C6>& c) {
  return (*function)(base::get<0>(p), base::get<1>(p), base::get<2>(p),
      base::get<3>(p), base::get<4>(p), base::get<5>(p), base::get<0>(c),
      base::get<1>(c), base::get<2>(c), base::get<3>(c), base::get<4>(c),
      base::get<5>(c));
}

// Interface that is exposed to the consumer, that does the actual calling
// of the method.
template <typename R, typename Params>
class MutantRunner {
 public:
  virtual R RunWithParams(const Params& params) = 0;
  virtual ~MutantRunner() {}
};

// Mutant holds pre-bound arguments (like Task). Like Callback
// allows call-time arguments. You bind a pointer to the object
// at creation time.
template <typename R, typename T, typename Method,
          typename PreBound, typename Params>
class Mutant : public MutantRunner<R, Params> {
 public:
  Mutant(T* obj, Method method, const PreBound& pb)
      : obj_(obj), method_(method), pb_(pb) {
  }

  // MutantRunner implementation
  virtual R RunWithParams(const Params& params) {
    return DispatchToMethod<R>(this->obj_, this->method_, pb_, params);
  }

  T* obj_;
  Method method_;
  PreBound pb_;
};

template <typename R, typename Function, typename PreBound, typename Params>
class MutantFunction : public MutantRunner<R, Params> {
 public:
  MutantFunction(Function function, const PreBound& pb)
      : function_(function), pb_(pb) {
  }

  // MutantRunner implementation
  virtual R RunWithParams(const Params& params) {
    return DispatchToFunction<R>(function_, pb_, params);
  }

  Function function_;
  PreBound pb_;
};

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
// MutantLateBind is like Mutant, but you bind a pointer to a pointer
// to the object. This way you can create actions for an object
// that is not yet created (has only storage for a pointer to it).
template <typename R, typename T, typename Method,
          typename PreBound, typename Params>
class MutantLateObjectBind : public MutantRunner<R, Params> {
 public:
  MutantLateObjectBind(T** obj, Method method, const PreBound& pb)
      : obj_(obj), method_(method), pb_(pb) {
  }

  // MutantRunner implementation.
  virtual R RunWithParams(const Params& params) {
    EXPECT_THAT(*this->obj_, testing::NotNull());
    if (NULL == *this->obj_)
      return R();
    return DispatchToMethod<R>( *this->obj_, this->method_, pb_, params);
  }

  T** obj_;
  Method method_;
  PreBound pb_;
};
#endif

// Simple MutantRunner<> wrapper acting as a functor.
// Redirects operator() to MutantRunner<Params>::Run()
template <typename R, typename Params>
struct MutantFunctor {
  explicit MutantFunctor(MutantRunner<R, Params>*  cb) : impl_(cb) {
  }

  ~MutantFunctor() {
  }

  inline R operator()() {
    return impl_->RunWithParams(base::Tuple<>());
  }

  template <typename Arg1>
  inline R operator()(const Arg1& a) {
    return impl_->RunWithParams(Params(a));
  }

  template <typename Arg1, typename Arg2>
  inline R operator()(const Arg1& a, const Arg2& b) {
    return impl_->RunWithParams(Params(a, b));
  }

  template <typename Arg1, typename Arg2, typename Arg3>
  inline R operator()(const Arg1& a, const Arg2& b, const Arg3& c) {
    return impl_->RunWithParams(Params(a, b, c));
  }

  template <typename Arg1, typename Arg2, typename Arg3, typename Arg4>
  inline R operator()(const Arg1& a, const Arg2& b, const Arg3& c,
                         const Arg4& d) {
    return impl_->RunWithParams(Params(a, b, c, d));
  }

 private:
  // We need copy constructor since MutantFunctor is copied few times
  // inside GMock machinery, hence no DISALLOW_EVIL_CONTRUCTORS
  MutantFunctor();
  linked_ptr<MutantRunner<R, Params> > impl_;
};

// 0 - 0
template <typename R, typename T, typename U>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(),
                 base::Tuple<>, base::Tuple<>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(),
                         base::Tuple<>, base::Tuple<>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(),
                 base::Tuple<>, base::Tuple<>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(),
                 base::Tuple<>, base::Tuple<>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(),
                         base::Tuple<>, base::Tuple<>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)()) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(),
                 base::Tuple<>, base::Tuple<>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 1
template <typename R, typename T, typename U, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(A1),
                 base::Tuple<>, base::Tuple<A1>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(A1),
                         base::Tuple<>, base::Tuple<A1>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1),
                 base::Tuple<>, base::Tuple<A1>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1),
                 base::Tuple<>, base::Tuple<A1>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(A1),
                         base::Tuple<>, base::Tuple<A1>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1)) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1),
                 base::Tuple<>, base::Tuple<A1>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 2
template <typename R, typename T, typename U, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(A1, A2),
                 base::Tuple<>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(A1, A2),
                         base::Tuple<>, base::Tuple<A1, A2>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1, A2),
                 base::Tuple<>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1, A2),
                 base::Tuple<>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(A1, A2),
                         base::Tuple<>, base::Tuple<A1, A2>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1, A2)) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1, A2),
                 base::Tuple<>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 3
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(A1, A2, A3),
                 base::Tuple<>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename A1, typename A2, typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(A1, A2, A3),
                         base::Tuple<>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1, A2, A3),
                 base::Tuple<>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1, A2, A3),
                 base::Tuple<>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename A1, typename A2, typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(A1, A2, A3),
                         base::Tuple<>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1, A2, A3)) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1, A2, A3),
                 base::Tuple<>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 4
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(A1, A2, A3, A4),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(A1, A2, A3, A4),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1, A2, A3, A4),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1, A2, A3, A4),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(A1, A2, A3, A4),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1, A2, A3, A4)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1, A2, A3, A4),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 5
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(A1, A2, A3, A4, A5),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4,
          typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(A1, A2, A3, A4, A5),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1, A2, A3, A4, A5),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1, A2, A3, A4, A5),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4,
          typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(A1, A2, A3, A4, A5),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1, A2, A3, A4, A5)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1, A2, A3, A4, A5),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 0 - 6
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(A1, A2, A3, A4, A5, A6),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(A1, A2, A3, A4, A5, A6),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(A1, A2, A3, A4, A5, A6),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(A1, A2, A3, A4, A5, A6),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(A1, A2, A3, A4, A5, A6),
                         base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (function, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(A1, A2, A3, A4, A5, A6)) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(A1, A2, A3, A4, A5, A6),
                 base::Tuple<>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple());
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 0
template <typename R, typename T, typename U, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1),
                 base::Tuple<P1>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1),
                         base::Tuple<P1>, base::Tuple<>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1),
                 base::Tuple<P1>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1),
                 base::Tuple<P1>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1),
                         base::Tuple<P1>, base::Tuple<>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename X1>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1), const P1& p1) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1),
                 base::Tuple<P1>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 1
template <typename R, typename T, typename U, typename P1, typename A1,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, A1),
                 base::Tuple<P1>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename A1, typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, A1),
                         base::Tuple<P1>, base::Tuple<A1>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1),
                 base::Tuple<P1>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1),
                 base::Tuple<P1>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename A1, typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1),
                         base::Tuple<P1>, base::Tuple<A1>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1), const P1& p1) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1),
                 base::Tuple<P1>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 2
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, A1, A2),
                 base::Tuple<P1>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, A1, A2),
                         base::Tuple<P1>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1, A2),
                 base::Tuple<P1>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1, A2),
                 base::Tuple<P1>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1, A2),
                         base::Tuple<P1>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1, A2), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1, A2),
                 base::Tuple<P1>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 3
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, A1, A2, A3),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, A1, A2, A3),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1, A2, A3),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1, A2, A3),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1, A2, A3),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1, A2, A3), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1, A2, A3),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 4
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, A1, A2, A3, A4), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, A1, A2, A3, A4),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, A1, A2, A3, A4), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, A1, A2, A3, A4),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, A1, A2, A3, A4), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1, A2, A3, A4),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, A1, A2, A3, A4), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1, A2, A3, A4),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 5
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, A1, A2, A3, A4, A5), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, A1, A2, A3, A4, A5),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, A1, A2, A3, A4, A5), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, A1, A2, A3, A4, A5),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, A1, A2, A3, A4, A5), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1, A2, A3, A4, A5),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4, A5),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4, A5),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, A1, A2, A3, A4, A5), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1, A2, A3, A4, A5),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4, A5),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4, A5),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 1 - 6
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, A1, A2, A3, A4, A5, A6),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, A1, A2, A3, A4, A5, A6), const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, A1, A2, A3, A4, A5, A6),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4, A5, A6),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, A1, A2, A3, A4, A5, A6),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (function, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, A1, A2, A3, A4, A5, A6),
      const P1& p1) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 0
template <typename R, typename T, typename U, typename P1, typename P2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1, X2), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1, X2),
                 base::Tuple<P1, P2>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1, X2), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1, X2),
                         base::Tuple<P1, P2>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1, X2), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2),
                 base::Tuple<P1, P2>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2),
                 base::Tuple<P1, P2>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1, X2), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2),
                         base::Tuple<P1, P2>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2),
                 base::Tuple<P1, P2>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 1
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1),
                 base::Tuple<P1, P2>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, X2, A1), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1),
                         base::Tuple<P1, P2>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1),
                 base::Tuple<P1, P2>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1),
                 base::Tuple<P1, P2>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1),
                         base::Tuple<P1, P2>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1),
                 base::Tuple<P1, P2>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 2
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1, A2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1, A2),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, X2, A1, A2), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1, A2),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1, A2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1, A2),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1, A2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1, A2),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1, A2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1, A2),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1, A2), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1, A2),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 3
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1, A2, A3), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1, A2, A3),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, X2, A1, A2, A3), const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1, A2, A3),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1, A2, A3), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1, A2, A3),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1, A2, A3), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1, A2, A3),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 4
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1, A2, A3, A4), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1, A2, A3, A4),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, X2, A1, A2, A3, A4), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1, A2, A3, A4),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1, A2, A3, A4), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1, A2, A3, A4),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1, A2, A3, A4), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1, A2, A3, A4),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 5
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, X2, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 2 - 6
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, X2, A1, A2, A3, A4, A5, A6), const P1& p1,
      const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, X2, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, X2, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (function, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 0
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3),
                 base::Tuple<P1, P2, P3>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1, X2, X3), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3),
                         base::Tuple<P1, P2, P3>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3),
                 base::Tuple<P1, P2, P3>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3),
                 base::Tuple<P1, P2, P3>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3),
                         base::Tuple<P1, P2, P3>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3),
                 base::Tuple<P1, P2, P3>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 1
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, X2, X3, A1), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 2
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1, A2), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1, A2),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, X2, X3, A1, A2), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1, A2),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1, A2), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1, A2),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1, A2), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1, A2),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 3
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1, A2, A3),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, X2, X3, A1, A2, A3), const P1& p1, const P2& p2,
      const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1, A2, A3),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1, A2, A3),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1, A2, A3),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 4
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, X2, X3, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 5
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, X2, X3, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 3 - 6
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, X2, X3, A1, A2, A3, A4, A5, A6), const P1& p1,
      const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (function, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3>, base::Tuple<A1, A2, A3, A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 0
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1, X2, X3, X4), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 1
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 2
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1, A2),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1, A2), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1, A2),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1, A2),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1, A2),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 3
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 4
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename X1,
          typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 5
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1, A2, A3, A4, A5), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4,
      A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4,
      A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 4 - 6
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4,
      A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5,
      A6),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename A1, typename A2, typename A3, typename A4, typename A5,
          typename A6, typename X1, typename X2, typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, A1, A2, A3, A4, A5,
      A6),
                         base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, A1, A2, A3, A4,
      A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, A1, A2, A3, A4, A5,
      A6),
                 base::Tuple<P1, P2, P3, P4>, base::Tuple<A1, A2, A3, A4, A5,
      A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 0
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 1
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 2
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1, A2),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1, A2),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 3
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 4
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1, A2, A3, A4), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename X1, typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 5
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4, A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename X1, typename X2, typename X3, typename X4,
          typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename X1, typename X2,
          typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4, A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 5 - 6
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5, A6),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4, A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename A1, typename A2, typename A3, typename A4,
          typename A5, typename A6, typename X1, typename X2, typename X3,
          typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5, A6),
                         base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2,
      A3, A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename A1, typename A2,
          typename A3, typename A4, typename A5, typename A6, typename X1,
          typename X2, typename X3, typename X4, typename X5>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, A1, A2, A3,
      A4, A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, A1, A2, A3, A4,
      A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5>, base::Tuple<A1, A2, A3, A4,
      A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 0
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6), const P1& p1, const P2& p2,
      const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 1
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 2
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1, A2), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1, A2),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1, A2),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 3
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1, A2, A3), const P1& p1,
      const P2& p2, const P3& p3, const P4& p4, const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 4
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename X1, typename X2, typename X3, typename X4,
          typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 5
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4,
      A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4,
      A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4, A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename X1, typename X2, typename X3,
          typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4,
      A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4, A5>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename X1,
          typename X2, typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4, A5), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

// 6 - 6
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (*function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5, A6),
      const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5,
      A6),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (U::*method)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5,
      A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4, const P5& p5,
      const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING

#if defined (OS_WIN) && !defined (ARCH_CPU_X86_64)
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T* obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4, A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new Mutant<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}

template <typename R, typename P1, typename P2, typename P3, typename P4,
          typename P5, typename P6, typename A1, typename A2, typename A3,
          typename A4, typename A5, typename A6, typename X1, typename X2,
          typename X3, typename X4, typename X5, typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(R (__stdcall *function)(X1, X2, X3, X4, X5, X6, A1, A2, A3, A4,
      A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantFunction<R, R (__stdcall *)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5, A6),
                         base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1,
      A2, A3, A4, A5, A6>>
          (function, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#ifdef GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
template <typename R, typename T, typename U, typename P1, typename P2,
          typename P3, typename P4, typename P5, typename P6, typename A1,
          typename A2, typename A3, typename A4, typename A5, typename A6,
          typename X1, typename X2, typename X3, typename X4, typename X5,
          typename X6>
inline MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>
CreateFunctor(T** obj, R (__stdcall U::*method)(X1, X2, X3, X4, X5, X6, A1, A2,
      A3, A4, A5, A6), const P1& p1, const P2& p2, const P3& p3, const P4& p4,
      const P5& p5, const P6& p6) {
  MutantRunner<R, base::Tuple<A1, A2, A3, A4, A5, A6>>* t =
      new MutantLateObjectBind<R, T, R (__stdcall U::*)(X1, X2, X3, X4, X5, X6, A1, A2, A3,
      A4, A5, A6),
                 base::Tuple<P1, P2, P3, P4, P5, P6>, base::Tuple<A1, A2, A3,
      A4, A5, A6>>
          (obj, method, base::MakeTuple(p1, p2, p3, p4, p5, p6));
  return MutantFunctor<R, base::Tuple<A1, A2, A3, A4, A5, A6>>(t);
}
#endif  // GMOCK_MUTANT_INCLUDE_LATE_OBJECT_BINDING
#endif  // defined (OS_WIN) && !defined (ARCH_CPU_X86_64)

}  // namespace testing

#endif  // TESTING_GMOCK_MUTANT_H_
