/**********************************************************************************************
    Copyright (C) 2014 Oliver Eichler oliver.eichler@gmx.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/

#ifndef CPLOTTRACK_H
#define CPLOTTRACK_H

#include <QWidget>
#include <proj_api.h>

class CGisItemTrk;

class CPlotTrack : public QWidget
{
    public:
        CPlotTrack(QWidget * parent);
        virtual ~CPlotTrack();

        void setTrack(CGisItemTrk * track, const QString &proj = "+init=epsg:3857");
        void setTrack(const QPolygonF &track, const QString &proj = "+init=epsg:3857");
        void updateData();
        void setMouseMoveFocus(qreal lon, qreal lat);

    protected:
        void resizeEvent(QResizeEvent * e);
        void paintEvent(QPaintEvent * e);


    private:
        void draw();

        projPJ  pjsrc;
        projPJ  pjtar;

        bool needsRedraw;
        CGisItemTrk * trk;
        QPolygonF coords;

        QImage buffer;

        QPointF pt1;
        QPointF pt2;
        QPointF scale;
        QPolygonF line;

        qint32 xoff;
        qint32 yoff;

        QPointF pos;
};

#endif //CPLOTTRACK_H

