# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MonthlyRetentionSchedule(Model):
    """Monthly retention schedule.

    :param retention_schedule_format_type: Retention schedule format type for
     monthly retention policy. Possible values include: 'Invalid', 'Daily',
     'Weekly'
    :type retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.models.RetentionScheduleFormat
    :param retention_schedule_daily: Daily retention format for monthly
     retention policy.
    :type retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.models.DailyRetentionFormat
    :param retention_schedule_weekly: Weekly retention format for monthly
     retention policy.
    :type retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.models.WeeklyRetentionFormat
    :param retention_times: Retention times of retention policy.
    :type retention_times: list[datetime]
    :param retention_duration: Retention duration of retention Policy.
    :type retention_duration:
     ~azure.mgmt.recoveryservicesbackup.models.RetentionDuration
    """

    _attribute_map = {
        'retention_schedule_format_type': {'key': 'retentionScheduleFormatType', 'type': 'str'},
        'retention_schedule_daily': {'key': 'retentionScheduleDaily', 'type': 'DailyRetentionFormat'},
        'retention_schedule_weekly': {'key': 'retentionScheduleWeekly', 'type': 'WeeklyRetentionFormat'},
        'retention_times': {'key': 'retentionTimes', 'type': '[iso-8601]'},
        'retention_duration': {'key': 'retentionDuration', 'type': 'RetentionDuration'},
    }

    def __init__(self, **kwargs):
        super(MonthlyRetentionSchedule, self).__init__(**kwargs)
        self.retention_schedule_format_type = kwargs.get('retention_schedule_format_type', None)
        self.retention_schedule_daily = kwargs.get('retention_schedule_daily', None)
        self.retention_schedule_weekly = kwargs.get('retention_schedule_weekly', None)
        self.retention_times = kwargs.get('retention_times', None)
        self.retention_duration = kwargs.get('retention_duration', None)
