# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SearchServiceResource(Model):
    """Describes an Azure Search service and its current state.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The resource Id of the Azure Search service.
    :vartype id: str
    :param name: The name of the Search service.
    :type name: str
    :param location: The geographic location of the Search service.
    :type location: str
    :param tags: Tags to help categorize the Search service in the Azure
     Portal.
    :type tags: dict
    :ivar properties: Properties of the Search service.
    :vartype properties: :class:`SearchServiceReadableProperties
     <azure.mgmt.search.models.SearchServiceReadableProperties>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'SearchServiceReadableProperties'},
    }

    def __init__(self, name=None, location=None, tags=None):
        self.id = None
        self.name = name
        self.location = location
        self.tags = tags
        self.properties = None
