# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class MetricDefinition(Resource):
    """Class repesenting metadata for the metrics.

    :param id: Resource Id
    :type id: str
    :param name: Resource Name
    :type name: str
    :param kind: Kind of resource
    :type kind: str
    :param location: Resource Location
    :type location: str
    :param type: Resource type
    :type type: str
    :param tags: Resource tags
    :type tags: dict
    :param metric_definition_name: Name of the metric
    :type metric_definition_name: str
    :param unit: Unit of the metric
    :type unit: str
    :param primary_aggregation_type: Primary aggregation type
    :type primary_aggregation_type: str
    :param metric_availabilities: List of time grains supported for the
     metric together with retention period
    :type metric_availabilities: list of :class:`MetricAvailabilily
     <azure.mgmt.web.models.MetricAvailabilily>`
    :param display_name: Friendly name shown in the UI
    :type display_name: str
    """ 

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'metric_definition_name': {'key': 'properties.name', 'type': 'str'},
        'unit': {'key': 'properties.unit', 'type': 'str'},
        'primary_aggregation_type': {'key': 'properties.primaryAggregationType', 'type': 'str'},
        'metric_availabilities': {'key': 'properties.metricAvailabilities', 'type': '[MetricAvailabilily]'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(self, location, id=None, name=None, kind=None, type=None, tags=None, metric_definition_name=None, unit=None, primary_aggregation_type=None, metric_availabilities=None, display_name=None):
        super(MetricDefinition, self).__init__(id=id, name=name, kind=kind, location=location, type=type, tags=tags)
        self.metric_definition_name = metric_definition_name
        self.unit = unit
        self.primary_aggregation_type = primary_aggregation_type
        self.metric_availabilities = metric_availabilities
        self.display_name = display_name
