/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.Vector;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.KeyHash;

class CardTable {
    private Vector cards;
    private KeyHash keymap;

    public CardTable(int initialCapacity, int capacityIncrement) {
        this.cards = new Vector(initialCapacity, capacityIncrement);
        this.keymap = new KeyHash();
    }

    public CardTable() {
        this(360, 180);
    }

    public final void addElement(HeaderCard card) {
        this.cards.addElement(card);
        this.keymap.add(card);
    }

    public final HeaderCard elementAt(int index) {
        return (HeaderCard)this.cards.elementAt(index);
    }

    public final int indexOf(HeaderCard card) {
        return this.cards.indexOf(card);
    }

    public final void insertElementAt(HeaderCard card, int index) {
        this.cards.insertElementAt(card, index);
        this.keymap.add(card);
    }

    public final void removeElementAt(int index) {
        HeaderCard oldCard = (HeaderCard)this.cards.elementAt(index);
        this.cards.removeElementAt(index);
        this.keymap.delete(oldCard);
    }

    public final void setElementAt(HeaderCard card, int index) {
        HeaderCard oldCard = (HeaderCard)this.cards.elementAt(index);
        this.cards.setElementAt(card, index);
        this.keymap.replace(oldCard, card);
    }

    public final int size() {
        return this.cards.size();
    }

    public final HeaderCard findKey(String key) {
        return this.keymap.find(key);
    }

    public final boolean containsKey(String key) {
        return this.keymap.contains(key);
    }
}

