/*
 * drivers/char/sparc/rconsole.h
 */
#ifndef _SPARC_RCONSOLE_H
#define _SPARC_RCONSOLE_H

typedef unsigned RC_color;        /* For arguments */

/*
 * Font
 * Our fonts are laid out effectively for the main purpose (virtual consoles).
 * Niceties are cut off.
 */

#define RF_MAXWIDTH  16
typedef unsigned short Rf_scan;        /*  __w16 to be used */

struct rfont {
  Rf_scan *body_;
  int nchars_;                 /* 128 for ASCII ...  65536 for Unicode   */
  int width_;                  /* [Pixels]. Maximum size is 16.          */
  int height_;                 /* [Pixels == scan lines].                */
};

void font_cons_1(struct rfont *p, const char *name);  /* for debugging */
void font_cons_7(struct rfont *p);
/* Fonts are permanent so we do not need a destructor yet. */

/*
 * Abstraction of a hardware or a software raster.
 *
 * Inversion on color displays is of two kinds: "display" and "color".
 * Color inversion is an operation on a pixel value. [Note1: The operation
 * must be mirroring: op(op(x)) == x. Example: op(x){return x^(-1)} ]
 * Color inversion belongs to class raster. Display inversion is a
 * swapping of foreground and background colors of an image. It belongs
 * to class screen in our case. [Note2: It's one of the rare cases when OO
 * model can be useful. ] In present we do not need a color inversion
 * and it is omitted from the class raster.
 */
struct raster {
  int depth_, width_, height_;  /* [planes], [pixels], [pixels]      */
  void *base_;                  /* Address of the first line.        */
  int loff_;                    /* Offset of the raster on the line [pixels] */
  int lsize_;                   /* Line size [pixels]                */

  unsigned *outp_;              /* __w32; output pointer.            */
  long ol_;                     /* __w32; output buffer. In theory   */
                                /* belongs to raster1 ... raster24.  */
  int sx_;                      /* output index */

  /* void (*invert_)(struct raster *, int, int, int, int); */
  void (*clear_)(  struct raster *, int y, int x, int h, int w, RC_color);
  void (*yscroll_)(struct raster *, int y, int x, int h, int w, int dy);
  void (*xscroll_)(struct raster *, int y, int x, int h, int w, int dx);
  void (*render_)( struct raster *, int y, int x, const char*, int len,
    RC_color bg, RC_color fg, const struct rfont *);
};

#define raster_qdepth(r)   ((r)->depth_)
#define raster_qwidth(r)   ((r)->width_)
#define raster_qheight(r)  ((r)->height_)
#define raster_qbase(r)    ((r)->base_)
void raster1_cons_a(struct raster *, int h, int w, char *base);
void raster8_cons_a(struct raster *, int h, int w, char *base);
void raster_cons_2(struct raster *, const struct raster *parent,
    int y, int x, int h, int w);
void raster24_cons(struct raster *, int h, int w);
void raster_dest(struct raster *);
void raster8_render(struct raster *, int y, int x, const char*, int len,
    RC_color bg, RC_color fg, const struct rfont *);
void raster1_render(struct raster *, int y, int x, const char*, int len,
    RC_color bg, RC_color fg, const struct rfont *);
void raster1_clear(struct raster *, int, int, int, int, RC_color);
void raster8_clear(struct raster *, int, int, int, int, RC_color);
void raster1_yscroll(struct raster *, int, int, int, int, int);
void raster8_yscroll(struct raster *, int, int, int, int, int);
void raster8_xscroll(struct raster *, int, int, int, int, int);


#endif /* _SPARC_RCONSOLE_H */
