/*	test_Profile

Unit test for the PIRL.Conductor.Maestro.Profile class.

PIRL CVS ID: test_Profile.java,v 1.15 2012/04/16 06:04:12 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	java.io.File;
import	java.io.FileWriter;
import	java.util.List;
import	java.util.Vector;

import	PIRL.Configuration.Configuration;
import	PIRL.Configuration.Configuration_Exception;
import	PIRL.Conductor.Maestro.Profile;
import	PIRL.Conductor.Maestro.Conductor_Definition;
import	PIRL.PVL.Parameter;
import	PIRL.PVL.PVL_Exception;
import	PIRL.PVL.Value;
import	PIRL.Messenger.Message;
import	PIRL.Utilities.Checker;

public class test_Profile
{

/** The name of the test profile file we'll be using.

	This file will be created during the testing, in the directory from
	which the testing is conducted.
*/
private static final String
	PROFILE_FILENAME			= "test_Profile.cmp";

/**	New Line seperator for this operating system.
*/
private static String 
	NL							= System.getProperty ("line.separator") ;

private static Checker
	checker 					= new Checker ();

/**	Application main.
*/
public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_Profile: " + Profile.ID);

int
	exit_status = 0;

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

try
	{

Profile 
	profile;
Conductor_Definition 
	conductor;
Vector
	conductors,
	theater,
	theaters;
Message
	message;
Parameter
	param;
Configuration
	config;
String
	expected;
Exception
	expected_exception,
	obtained_exception;

profile = new Profile ();
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add (null);
theater.add (0);
profile.Add_Theater_Definition ("host_1");
theaters.add (theater);
if (! checker.Check
	("Add_Theater_Definition (String (\"host_1\"))",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);

profile = new Profile ();
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (1);
profile.Validate_Theater_Definition (theater);
profile.Add_Theater_Definition (theater);
theaters.add (theater);
if (! checker.Check
	("Add_Theater_Definition (Vector (\"host_1:4144\", \"pipeline_1\", 1))",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);

profile = new Profile ();
conductors = new Vector ();
conductor = new Conductor_Definition ("pipeline_1");
conductors.add (conductor);
profile.Add_Conductor_Definition (conductor);
if (! checker.Check
	("Add_Conductor_Definition (Conductor_Definition (\"pipeline_1\"))",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);
	
profile = new Profile ();
theater = new Vector ();
theater.add ("host_2:4144");
theater.add ("pipeline_2");
theater.add (1);
theaters.add (theater);
profile.Validate_Theater_Definitions (theaters);
profile.Add_Theater_Definitions (theaters);
if (! checker.Check
	("Add_Theater_Definitions (Vector ("
		+ "Vector (\"host_1:4144\", \"pipeline_1\", 1), "
		+ "Vector (\"host_2:4144\", \"pipeline_2\", 1)))",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);
	
profile = new Profile ();
message = new Message ()	
	.Set ("Pipeline", "pipeline_1");
profile.Add_Conductor_Definition (message);
if (! checker.Check
	("Add_Conductor_Definition (Message ().Set (\"Pipeline\", \"pipeline_1\"))",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);

profile = new Profile ();
conductor = new Conductor_Definition ("pipeline_2");
conductors.add (conductor);
profile.Add_Conductor_Definitions (conductors);
if (! checker.Check
	("Add_Conductor_Definitions (Vector " 
		+ "(Conductor_Definition (\"pipeline_1\"), "
		+ "Conductor_Definition (\"pipeline_2\"))",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);

profile = new Profile ();
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (1);
theaters.add (theater);
conductors = new Vector ();
conductor = new Conductor_Definition ("pipeline_1");
conductors.add (conductor);
profile.Add ("host_1", conductor);
if (! checker.Check
	("Theaters via Add (String (\"host_1\"), "
		+ "Conductor_Definition (\"pipeline_1\")",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);
if (! checker.Check
	("Conductors via Add (String (\"host_1\"), "
		+ "Conductor_Definition (\"pipeline_1\")",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);
// Turn theater into a canonical theater definition
theater.set (1, conductor);
if (! checker.Check
	("Canonical Theaters via Add (String (\"host_1\"), "
		+ "Conductor_Definition (\"pipeline_1\")",
	theaters,
	profile.Canonical_Theater_Definitions ()))
	Report (1);

profile = new Profile ();
// Turn theater back into a non-canonical theater definition
theater.set (1, "pipeline_1");
profile.Add (theaters, conductors);
if (! checker.Check
	("Theaters via Add (Vector (\"host_1:4144\", \"pipeline_1\", 1), "
		+ "Vector (Conductor_Definition (\"pipeline_1\"))",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);
if (! checker.Check
	("Conductors via Add (Vector (\"host_1:4144\", \"pipeline_1\", 1), "
		+ "Vector (Conductor_Definition (\"pipeline_1\"))",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);
// Turn theater into a canonical theater definition
theater.set (1, conductor);
if (! checker.Check
	("Canonical Theaters via Add (Vector (\"host_1:4144\", \"pipeline_1\", 1), "
		+ "Vector (Conductor_Definition (\"pipeline_1\"))",
	theaters,
	profile.Canonical_Theater_Definitions ()))
	Report (1);

profile = new Profile ();
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (1);
theaters.add (theater);
theater = new Vector ();
theater.add ("host_2:4144");
theater.add ("pipeline_2");
theater.add (1);
theaters.add (theater);
theater = new Vector ();
theater.add ("host_3:4144");
theater.add ("pipeline_3");
theater.add (1);
theaters.add (theater);
profile.Validate_Theater_Definitions (theaters);
profile.Add_Theater_Definitions (theaters);
conductors = new Vector ();
conductor = new Conductor_Definition ("pipeline_1");
conductors.add (conductor);
conductor = new Conductor_Definition ("pipeline_2");
conductors.add (conductor);
conductor = new Conductor_Definition ("pipeline_3");
conductors.add (conductor);
profile.Add_Conductor_Definitions (conductors);

if (! checker.Check
	("Total_Theater_Definitions ()",
	3,
	profile.Total_Theater_Definitions ()))
	Report (1);

if (! checker.Check
	("Total_Conductor_Definitions ()",
	3,
	profile.Total_Conductor_Definitions ()))
	Report (1);

if (! checker.Check
	("Theater_Definition_index "
		+ "(profile.Theater_Definitions (), \"host_2\", \"pipeline_2\")",
	1,
	profile.Theater_Definition_Index 
		(profile.Theater_Definitions (), "host_2", "pipeline_2")))
	Report (1);

if (! checker.Check
	("Theater_Definition_index "
		+ "(profile.Theater_Definitions (), \"undefined\", \"undefined\")",
	-1,
	profile.Theater_Definition_Index 
		(profile.Theater_Definitions (), "undefined", "undefined")))
	Report (1);

if (! checker.Check
	("Next_Theater_Index (\"host_2:4144\", -1)",
	1,
	profile.Next_Theater_Index ("host_2:4144", -1)))
	Report (1);

if (! checker.Check
	("Next_Theater_Index (\"undefined\", -1)",
	-1,
	profile.Next_Theater_Index ("undefined", -1)))
	Report (1);

if (! checker.Check
	("Theater_Definition (1)",
	theaters.get (1),
	profile.Theater_Definition (1)))
	Report (1);

if (! checker.Check
	("Theater_Definition (-1)",
	null,
	profile.Theater_Definition (-1)))
	Report (1);

if (! checker.Check
	("Theater_Definition (\"host_2\", \"pipeline_2\")",
	theaters.get (1),
	profile.Theater_Definition ("host_2", "pipeline_2")))
	Report (1);

if (! checker.Check
	("Theater_Definition (\"undefined\", \"undefined\")",
	null,
	profile.Theater_Definition ("undefined", "undefined")))
	Report (1);
if (! checker.Check
	("Contains_Conductor_Definition (Conductor_Definition (\"pipeline_2\"))",
	true,
	profile.Contains_Conductor_Definition 
		(new Conductor_Definition ("pipeline_2"))))
	Report (1);

if (! checker.Check
	("Contains_Conductor_Definition (Conductor_Definition (\"undefined\"))",
	false,
	profile.Contains_Conductor_Definition 
		(new Conductor_Definition ("undefined"))))
	Report (1);

if (! checker.Check
	("Conductor_Definition_index "
		+ "(profile.Conductor_Definitions (), \"pipeline_2\")",
	1,
	profile.Conductor_Definition_Index 
		(profile.Conductor_Definitions (), "pipeline_2")))
	Report (1);

if (! checker.Check
	("Conductor_Definition_index " 
		+ "(profile.Conductor_Definitions (), \"undefined\")",
	-1,
	profile.Conductor_Definition_Index 
		(profile.Conductor_Definitions (), "undefined")))
	Report (1);

if (! checker.Check
	("Conductor_Definition (\"pipeline_2\")",
	conductors.get (1),
	profile.Conductor_Definition ("pipeline_2")))
	Report (1);

if (! checker.Check
	("Conductor_Definition (\"undefined\")",
	null,
	profile.Conductor_Definition ("undefined")))
	Report (1);

if (! checker.Check
	("Contains_Theater_Definition (\"host_2:4144\")",
	true,
	profile.Contains_Theater_Definition ("host_2:4144")))
	Report (1);

if (! checker.Check
	("Contains_Theater_Definition (\"undefined\")",
	false,
	profile.Contains_Theater_Definition ("undefined")))
	Report (1);

profile.Remove_Theater_Definition (1);
theaters.remove (1);
if (! checker.Check
	("Remove_Conductor_Definition (1)",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);

profile.Remove_Theater_Definition ("host_1", "pipeline_1");
theaters.remove (0);
if (! checker.Check
	("Remove_Conductor_Definition (\"host_1\", \"pipeline_1\")",
	theaters,
	profile.Theater_Definitions ()))
	Report (1);

profile.Remove_Conductor_Definition (1);
conductors.remove (1);
if (! checker.Check
	("Remove_Conductor_Definition (1)",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);

profile.Remove_Conductor_Definition ("pipeline_1");
conductors.remove (0);
if (! checker.Check
	("Remove_Conductor_Definition (\"pipeline_1\")",
	conductors,
	profile.Conductor_Definitions ()))
	Report (1);

profile.Clear_Theater_Definitions ();
if (! checker.Check
	("Clear_Theater_Definitions ()",
	new Vector (),
	profile.Theater_Definitions ()))
	Report (1);

profile.Clear_Conductor_Definitions ();
if (! checker.Check
	("Clear_Conductor_Definitions ()",
	new Vector (),
	profile.Conductor_Definitions ()))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (1);
theaters.add (theater);
theater = new Vector ();
theater.add ("host_2:4144");
theater.add ("pipeline_2");
theater.add (2);
theaters.add (theater);
param = new Parameter ("Theaters");
Value.Default_Array_Type (Value.SEQUENCE);
param.Value (theaters);
config.Add (param);
profile.Validate_Theater_Definitions (theaters);
profile.Add_Theater_Definitions (theaters);
conductors = new Vector ();
conductor = new Conductor_Definition ("pipeline_1");
conductors.add (conductor);
config.add (conductor);
conductor = new Conductor_Definition ("pipeline_2");
conductors.add (conductor);
config.add (conductor);
profile.Add_Conductor_Definitions (conductors);

if (! checker.Check
	("Configuration ()",
	config,
	profile.Configuration ()))
	{
	System.out.println
		("      expected Configuration -" + NL
		+ config.Description () + NL
		+"       obtained Configuration -" + NL
		+ profile.Configuration ().Description ());
	Report (1);
	}

profile = new Profile ();
profile.Read ( new Configuration (config));
if (! checker.Check
	("Read (Configuration without Theaters in Conductor Definitions)",
	config,
	profile.Configuration ()))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
conductor = new Conductor_Definition ("pipeline_1");
conductor.Set (profile.THEATERS_PARAMETER_NAME, "host_1");
config.add (conductor);
profile.Read (new Configuration (config));

config = new Configuration ((Parameter)null);
config.Name ("Profile");
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (1);
theaters.add (theater);
param = new Parameter ("Theaters");
param.Value (theaters);
config.Add (param);
conductor = new Conductor_Definition ("pipeline_1");
config.add (conductor);

if (! checker.Check
	("Read (Configuration with Theater string in Conductor Definitions)",
	config,
profile.Configuration ()))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
conductor = new Conductor_Definition ("pipeline_1");
conductor.Set (profile.THEATERS_PARAMETER_NAME, theaters);
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add (2);
theaters.add (theater);
conductor.Set (profile.THEATERS_PARAMETER_NAME, theaters);
config.add (conductor);
profile.Read (new Configuration (config));

config = new Configuration ((Parameter)null);
config.Name ("Profile");
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add (2);
theaters.add (theater);
param = new Parameter ("Theaters");
param.Value (theaters);
config.Add (param);
conductor = new Conductor_Definition ("pipeline_1");
conductors.add (conductor);
config.add (conductor);
	
if (! checker.Check
	("Read (Configuration with Theater array in Conductor Definitions)",
	config,
	profile.Configuration ()))
	Report (1);

if (! checker.Check
	("Unprocessed () is null",
	null,
	profile.Unprocessed_Source_Parameters ()))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
conductor = new Conductor_Definition ("pipeline_1");
config.add (conductor);
conductor.Set (profile.THEATERS_PARAMETER_NAME, "host_1");
conductor = new Conductor_Definition ("pipeline_2");
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_2:4144");
theater.add (2);
theaters.add (theater);
conductor.Set (profile.THEATERS_PARAMETER_NAME, theaters);
config.add (conductor);
config.add (new Parameter ("token"));
param = new Parameter ("assignment");
param.Value ("value");
config.Add (param);
profile.Read (new Configuration (config));

config = new Configuration ((Parameter)null);
config.Name ("Profile");
config.add (new Parameter ("token"));
param = new Parameter ("assignment");
param.Value ("value");
config.Add (param);

if (! checker.Check
	("Unprocessed () is not null",
	config,
	profile.Unprocessed_Source_Parameters ()))
	Report (1);
	
expected = "# Profile" + NL + 
	"Theaters = " + NL + 
	"	(" + NL + 
	"		(host_1:4144, pipeline_1, 1)," + NL + 
	"		(host_2:4144, pipeline_2, 2))" + NL + 
	"GROUP = pipeline_1" + NL + 
	"	Pipeline = pipeline_1" + NL + 
	"	Configuration = Conductor.conf" + NL + 
	"END_GROUP" + NL + 
	"GROUP = pipeline_2" + NL + 
	"	Pipeline = pipeline_2" + NL + 
	"	Configuration = Conductor.conf" + NL + 
	"END_GROUP" + NL + 
	"END" + NL;

if (! checker.Check
	("toString ()",
	expected,
	profile.toString ()))
	Report (1);

profile = new Profile ();
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Validate_Theater_Definition (theater);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Validate_Theater_Definition (theater with < 3 entries)",
	expected_exception,
	obtained_exception))
	Report (1);

theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add ("extra");
theater.add (1);
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Validate_Theater_Definition (theater);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Validate_Theater_Definition (theater with > 3 entries)",
	expected_exception,
	obtained_exception))
	Report (1);

theater = new Vector ();
theater.add (1);
theater.add ("pipeline_1");
theater.add (1);
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Validate_Theater_Definition (theater);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Validate_Theater_Definition (theater with first not string)",
	expected_exception,
	obtained_exception))
	Report (1);
	
theater = new Vector ();
theater.add ("host_1:4144");
theater.add ("pipeline_1");
theater.add ("extra");
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Validate_Theater_Definition (theater);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Validate_Theater_Definition (theater with 3 strings)",
	expected_exception,
	obtained_exception))
	Report (1);

theater = new Vector ();
theater.add ("host_1:4144");
theater.add (1);
theater.add (1);
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Validate_Theater_Definition (theater);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Validate_Theater_Definition (theater with 1 string and 2 numbers)",
	expected_exception,
	obtained_exception))
	Report (1);
	
profile = new Profile ();
conductor = new Conductor_Definition ("pipeline_1");
conductor.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME, "configuration_1");
profile.Add_Conductor_Definition (conductor);
expected_exception = null;
obtained_exception = null;
try {profile.Add_Conductor_Definition (conductor);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("No Exception - Add_Conductor_Definition (Conductor_Definition that was already added but hasn't changed)",
	expected_exception,
	obtained_exception))
	Report (1);

profile = new Profile ();
conductor = new Conductor_Definition ("pipeline_1");
conductor.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME, "configuration_1");
profile.Add_Conductor_Definition (conductor);
conductor.Set (Conductor_Definition.CONFIGURATION_PARAMETER_NAME, "configuration_2");
expected_exception = new IllegalArgumentException ();
obtained_exception = null;
try {profile.Add_Conductor_Definition (conductor);}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("IllegalArgumentException - Add_Conductor_Definition (Conductor_Definition that was already added and has different values)",
	expected_exception,
	obtained_exception))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
conductor = new Conductor_Definition ("pipeline_1");
config.add (conductor);
conductor.Set (profile.THEATERS_PARAMETER_NAME, "host_1");
conductor = new Conductor_Definition ("pipeline_2");
config.add (conductor);
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_2:4144");
Vector v = new Vector ();
v.add ("1");
v.add ("2");
theater.add (v);
theaters.add (theater);
conductor.Set (profile.THEATERS_PARAMETER_NAME, theaters);

expected_exception = new Configuration_Exception ();
obtained_exception = null;
try {profile.Read (new Configuration (config));}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("Configuration_Exception - Read (Configuration with Conductor Definition that has array in Theater definition)",
	expected_exception,
	obtained_exception))
	Report (1);

profile = new Profile ();
config = new Configuration ((Parameter)null);
config.Name ("Profile");
conductor = new Conductor_Definition ("pipeline_1");
config.add (conductor);
conductor.Set (profile.THEATERS_PARAMETER_NAME, "host_1");
conductor = new Conductor_Definition ("pipeline_2");
config.add (conductor);
theaters = new Vector ();
theater = new Vector ();
theater.add ("host_2:4144");
theater.add ("string");
theaters.add (theater);
conductor.Set (profile.THEATERS_PARAMETER_NAME, theaters);

expected_exception = new Configuration_Exception ();
obtained_exception = null;
try {profile.Read (new Configuration (config));}
catch (Exception exception) {obtained_exception = exception;}
if (! checker.Check
	("Configuration_Exception - Read (Configuration with Conductor Definition that has two strings for Theater definition",
	expected_exception,
	obtained_exception))
	Report (1);

}
catch (Exception exception)
	{
	System.out.println (exception);
	exception.printStackTrace (System.out);
	exit_status = 1;
	}
Report (exit_status);
}

private static void Report
	(
	int		exit_status
	)
{
System.out.println ("\n" +
	"Checks: " + checker.Checks_Total + '\n' +
	"Passed: " + checker.Checks_Passed);

if (exit_status == 0 &&
	checker.Checks_Total == checker.Checks_Passed)
	new File (PROFILE_FILENAME).delete ();

System.exit (exit_status);
}

}
