Name:		pekwm
Version:	0.1.14
Release:	4%{?dist}
Summary:	A small and flexible window manager

Group:		User Interface/Desktops
License:	GPLv2+
URL:		http://www.pekwm.org/
Source0:	http://www.pekwm.org/projects/pekwm/files/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	libX11-devel libpng-devel libXrandr-devel
BuildRequires:	libXft-devel libXext-devel libXinerama-devel
BuildRequires:	libXpm-devel libjpeg-devel libICE-devel libSM-devel

%description
Pekwm is a window manager that once up on a time was based on the aewm++ window
manager, but it has evolved enough that it no longer resembles aewm++ at all.
It has a much expanded feature-set, including window grouping (similar to ion,
pwm, or fluxbox), autoproperties, xinerama, keygrabber that supports keychains,
and much more.

   * Lightweight and Unobtrusive, a window manager shouldn't be noticed.
   * Very configurable, we all work and think in different ways.
   * Automatic properties, for all the lazy people, make things appear as they
should when starting applications.
   * Chainable Keygrabber, usability for everyone. 

%prep
%setup -q

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot} INSTALL="install -p"

# Create desktop file
mkdir -p %{buildroot}%{_datadir}/xsessions/
cat << EOF > %{buildroot}%{_datadir}/xsessions/%{name}.desktop
[Desktop Entry]
Name=PekWM
Comment=Very small and fast window manger
Exec=pekwm
TryExec=pekwm
Type=XSession
EOF

# Delete makefiles from contrib folder
find contrib/Makefile* -type f | xargs rm -rf || true
find contrib/lobo/Makefile* -type f | xargs rm -rf || true

# Rearrange the contents of contrib folder
mv contrib/lobo/* contrib/
rm -rf contrib/lobo

# Fix permissions to include scripts in %%doc
find contrib/pekwm_autoprop.pl -type f | xargs chmod 0644 || true
find contrib/pekwm_menu_config.pl -type f | xargs chmod 0644 || true

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog ChangeLog.aewm++ ChangeLog.until-0.1.6 LICENSE NEWS README contrib/
%{_bindir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/autoproperties
%config(noreplace) %{_sysconfdir}/%{name}/config
%config(noreplace) %{_sysconfdir}/%{name}/keys
%config(noreplace) %{_sysconfdir}/%{name}/menu
%config(noreplace) %{_sysconfdir}/%{name}/mouse
%config(noreplace) %{_sysconfdir}/%{name}/vars
%config(noreplace) %attr(755,root,root) %{_sysconfdir}/%{name}/start
%{_datadir}/%{name}/
%{_mandir}/man1/%{name}.*
%{_datadir}/xsessions/%{name}.desktop

%changelog
* Tue May 11 2010 German A. Racca <gracca@gmail.com> 0.1.12-4
- Fixed BuildRequires to compile from scratch

* Sun May 09 2010 German A. Racca <gracca@gmail.com> 0.1.12-3
- Deleted makefiles form contrib folder
- Rearranged contents in contrib folder

* Mon Apr 26 2010 German A. Racca <gracca@gmail.com> 0.1.12-2
- Added %%{dist} tag
- Fixed patch
- Added contrib stuff to docs

* Tue Apr 20 2010 German A. Racca <gracca@gmail.com> 0.1.12-1
- New version 0.1.12
- Fixed timestamp for tarball source
- Added BuildRoot tag
- Fixed BuildRequires
- Added menu patch
- Added INSTALL="install -p" to preserve timestamps
- Corrected type in xsession file
- Added ChangeLog.aewm++ and ChangeLog.until-0.1.6 to doc files
- Own directory %%{_datadir}/%%{name}
- Marqued 'start' as config file

* Sat Feb 20 2010 German A. Racca <gracca@gmail.com> 0.1.11-3
- Changed Summary
- Changed BuildRequires
- Modified desktop file
- Added exec attr to 'start' file

* Fri Jan 15 2010 German A. Racca <gracca@gmail.com> 0.1.11-2
- Added Source0 to spec file

* Thu Dec 17 2009 German A. Racca <gracca@gmail.com> 0.1.11-1
- Initial release of RPM package
