#!/usr/bin/perl
use strict;
use warnings;
use blib;
use File::Compare;
use File::Copy;
use Test::More;
use Shell;


SKIP: {
    if ($^O eq 'MSWin32' || $^O =~ /cygwin/){
        print "1..0 # Skipped not UNIX\n";
        exit;
    }
}
plan ( tests => 14 );

    
my $db = "data.dbl";
chdir("t") or die "couldn't change directory";
copy("../outputpbnj", ".");
copy("../config.yaml", ".");
copy("../data.dbl", ".");
copy("../query.yaml", ".");
#tests
is(system("perl outputpbnj -q latestinfo -t csv -f 05test1.csv"),0,"latestinfo CSV 05test1.csv from $db");
is(system("perl outputpbnj -q latestinfo -t tab -f 05test1.tab"),0,"latestinfo Tab 05test1.tab from $db");
is(system("perl outputpbnj -q sdump -t csv -f 05test2.csv"),0,"sdump Tab Output input from $db");
is(system("perl outputpbnj -q sdump -t tab -f 05test2.tab"),0,"sdump Tab Output input from $db");

is(compare("05test1.csv", "latestinfo.csv"),0,"latestinfo CSV cmp 05test1.csv latestinfo.csv");
is(compare("05test1.tab", "latestinfo.tab"),0,"latestinfo CSV cmp 05test1.tab latestinfo.tab");
is(compare("05test2.csv", "sdump.csv"),0,"sdump CSV cmp 05test2.csv sdump.csv");
is(compare("05test2.tab", "sdump.tab"),0,"sdump TAB cmp 05test2.tab sdump.tab");

is(unlink("05test1.csv"),1,"Remove test1.csv");
is(unlink("05test1.tab"),1,"Remove test1.tab");
is(unlink("05test2.tab"),1,"Remove test2.tab");
is(unlink("05test2.csv"),1,"Remove test2.tab");

is(unlink("outputpbnj"),1,"Remove outputpbnj");
is(unlink("$db"),1,"Remove DB $db");
