/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#ifndef LAUNCHPROFILE_H
#define LAUNCHPROFILE_H
#include <state_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: LaunchProfile
//
// Purpose:
//    This class contains information needed to launch a VisIt engine.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class STATE_API LaunchProfile : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    LaunchProfile();
    LaunchProfile(const LaunchProfile &obj);
protected:
    // These constructors are for objects derived from this class
    LaunchProfile(private_tmfs_t tmfs);
    LaunchProfile(const LaunchProfile &obj, private_tmfs_t tmfs);
public:
    virtual ~LaunchProfile();

    virtual LaunchProfile& operator = (const LaunchProfile &obj);
    virtual bool operator == (const LaunchProfile &obj) const;
    virtual bool operator != (const LaunchProfile &obj) const;
private:
    void Init();
    void Copy(const LaunchProfile &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectProfileName();
    void SelectPartition();
    void SelectBank();
    void SelectTimeLimit();
    void SelectLaunchMethod();
    void SelectArguments();
    void SelectLaunchArgs();
    void SelectSublaunchArgs();
    void SelectSublaunchPreCmd();
    void SelectSublaunchPostCmd();
    void SelectMachinefile();
    void SelectHwAccelPreCommand();
    void SelectHwAccelPostCommand();

    // Property setting methods
    void SetProfileName(const std::string &profileName_);
    void SetTimeout(int timeout_);
    void SetNumProcessors(int numProcessors_);
    void SetNumNodesSet(bool numNodesSet_);
    void SetNumNodes(int numNodes_);
    void SetPartitionSet(bool partitionSet_);
    void SetPartition(const std::string &partition_);
    void SetBankSet(bool bankSet_);
    void SetBank(const std::string &bank_);
    void SetTimeLimitSet(bool timeLimitSet_);
    void SetTimeLimit(const std::string &timeLimit_);
    void SetLaunchMethodSet(bool launchMethodSet_);
    void SetLaunchMethod(const std::string &launchMethod_);
    void SetForceStatic(bool forceStatic_);
    void SetForceDynamic(bool forceDynamic_);
    void SetActive(bool active_);
    void SetArguments(const stringVector &arguments_);
    void SetParallel(bool parallel_);
    void SetLaunchArgsSet(bool launchArgsSet_);
    void SetLaunchArgs(const std::string &launchArgs_);
    void SetSublaunchArgsSet(bool sublaunchArgsSet_);
    void SetSublaunchArgs(const std::string &sublaunchArgs_);
    void SetSublaunchPreCmdSet(bool sublaunchPreCmdSet_);
    void SetSublaunchPreCmd(const std::string &sublaunchPreCmd_);
    void SetSublaunchPostCmdSet(bool sublaunchPostCmdSet_);
    void SetSublaunchPostCmd(const std::string &sublaunchPostCmd_);
    void SetMachinefileSet(bool machinefileSet_);
    void SetMachinefile(const std::string &machinefile_);
    void SetVisitSetsUpEnv(bool visitSetsUpEnv_);
    void SetCanDoHWAccel(bool canDoHWAccel_);
    void SetHavePreCommand(bool havePreCommand_);
    void SetHwAccelPreCommand(const std::string &hwAccelPreCommand_);
    void SetHavePostCommand(bool havePostCommand_);
    void SetHwAccelPostCommand(const std::string &hwAccelPostCommand_);

    // Property getting methods
    const std::string  &GetProfileName() const;
          std::string  &GetProfileName();
    int                GetTimeout() const;
    int                GetNumProcessors() const;
    bool               GetNumNodesSet() const;
    int                GetNumNodes() const;
    bool               GetPartitionSet() const;
    const std::string  &GetPartition() const;
          std::string  &GetPartition();
    bool               GetBankSet() const;
    const std::string  &GetBank() const;
          std::string  &GetBank();
    bool               GetTimeLimitSet() const;
    const std::string  &GetTimeLimit() const;
          std::string  &GetTimeLimit();
    bool               GetLaunchMethodSet() const;
    const std::string  &GetLaunchMethod() const;
          std::string  &GetLaunchMethod();
    bool               GetForceStatic() const;
    bool               GetForceDynamic() const;
    bool               GetActive() const;
    const stringVector &GetArguments() const;
          stringVector &GetArguments();
    bool               GetParallel() const;
    bool               GetLaunchArgsSet() const;
    const std::string  &GetLaunchArgs() const;
          std::string  &GetLaunchArgs();
    bool               GetSublaunchArgsSet() const;
    const std::string  &GetSublaunchArgs() const;
          std::string  &GetSublaunchArgs();
    bool               GetSublaunchPreCmdSet() const;
    const std::string  &GetSublaunchPreCmd() const;
          std::string  &GetSublaunchPreCmd();
    bool               GetSublaunchPostCmdSet() const;
    const std::string  &GetSublaunchPostCmd() const;
          std::string  &GetSublaunchPostCmd();
    bool               GetMachinefileSet() const;
    const std::string  &GetMachinefile() const;
          std::string  &GetMachinefile();
    bool               GetVisitSetsUpEnv() const;
    bool               GetCanDoHWAccel() const;
    bool               GetHavePreCommand() const;
    const std::string  &GetHwAccelPreCommand() const;
          std::string  &GetHwAccelPreCommand();
    bool               GetHavePostCommand() const;
    const std::string  &GetHwAccelPostCommand() const;
          std::string  &GetHwAccelPostCommand();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    void SelectOnlyDifferingFields(LaunchProfile &other);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_profileName = 0,
        ID_timeout,
        ID_numProcessors,
        ID_numNodesSet,
        ID_numNodes,
        ID_partitionSet,
        ID_partition,
        ID_bankSet,
        ID_bank,
        ID_timeLimitSet,
        ID_timeLimit,
        ID_launchMethodSet,
        ID_launchMethod,
        ID_forceStatic,
        ID_forceDynamic,
        ID_active,
        ID_arguments,
        ID_parallel,
        ID_launchArgsSet,
        ID_launchArgs,
        ID_sublaunchArgsSet,
        ID_sublaunchArgs,
        ID_sublaunchPreCmdSet,
        ID_sublaunchPreCmd,
        ID_sublaunchPostCmdSet,
        ID_sublaunchPostCmd,
        ID_machinefileSet,
        ID_machinefile,
        ID_visitSetsUpEnv,
        ID_canDoHWAccel,
        ID_havePreCommand,
        ID_hwAccelPreCommand,
        ID_havePostCommand,
        ID_hwAccelPostCommand,
        ID__LAST
    };

private:
    std::string  profileName;
    int          timeout;
    int          numProcessors;
    bool         numNodesSet;
    int          numNodes;
    bool         partitionSet;
    std::string  partition;
    bool         bankSet;
    std::string  bank;
    bool         timeLimitSet;
    std::string  timeLimit;
    bool         launchMethodSet;
    std::string  launchMethod;
    bool         forceStatic;
    bool         forceDynamic;
    bool         active;
    stringVector arguments;
    bool         parallel;
    bool         launchArgsSet;
    std::string  launchArgs;
    bool         sublaunchArgsSet;
    std::string  sublaunchArgs;
    bool         sublaunchPreCmdSet;
    std::string  sublaunchPreCmd;
    bool         sublaunchPostCmdSet;
    std::string  sublaunchPostCmd;
    bool         machinefileSet;
    std::string  machinefile;
    bool         visitSetsUpEnv;
    bool         canDoHWAccel;
    bool         havePreCommand;
    std::string  hwAccelPreCommand;
    bool         havePostCommand;
    std::string  hwAccelPostCommand;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define LAUNCHPROFILE_TMFS "siibibsbsbsbsbbbs*bbsbsbsbsbsbbbsbs"

#endif
