//=======================================================================
// dir.cc
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#include "config.h"
#include "paco/common.h"	// XErrno
#include "dir.h"

using std::string;
using namespace Paco;


Dir::Dir(string const& path)
:
	mDir(opendir(path.c_str())),
	mDirent(NULL)
{
	if (!mDir)
		throw XErrno("opendir(\"" + path + "\")");
}


Dir::~Dir()
{
	if (mDir)
		closedir(mDir);
}


bool Dir::read(string &name)
{
	if (!(mDirent = readdir(mDir)))
		return false;
	
	name = mDirent->d_name;

	if (name == "." || name == "..")
		return read(name);

	return true;
}


void Dir::rewind()
{
	rewinddir(mDir);
}

