//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Distribution
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTDISTRIBUTION_HXX
#define OPENTURNS_OTDISTRIBUTION_HXX

#include "AliMikhailHaqCopula.hxx"
#include "AliMikhailHaqCopulaFactory.hxx"
#include "Arcsine.hxx"
#include "ArcsineFactory.hxx"
#include "ArcsineMuSigma.hxx"
#include "Bernoulli.hxx"
#include "BernoulliFactory.hxx"
#include "BernsteinCopulaFactory.hxx"
#include "Beta.hxx"
#include "BetaFactory.hxx"
#include "BetaMuSigma.hxx"
#include "Binomial.hxx"
#include "BinomialFactory.hxx"
#include "Burr.hxx"
#include "BurrFactory.hxx"
#include "ChiSquare.hxx"
#include "ChiSquareFactory.hxx"
#include "Chi.hxx"
#include "ChiFactory.hxx"
#include "ClaytonCopula.hxx"
#include "ClaytonCopulaFactory.hxx"
#include "ComposedCopula.hxx"
#include "ComposedDistribution.hxx"
#include "CompositeDistribution.hxx"
#include "ConditionalDistribution.hxx"
#include "CumulativeDistributionNetwork.hxx"
#include "BayesDistribution.hxx"
#include "Dirac.hxx"
#include "DiracFactory.hxx"
#include "Dirichlet.hxx"
#include "DirichletFactory.hxx"
#include "DistFunc.hxx"
#include "Epanechnikov.hxx"
#include "Exponential.hxx"
#include "ExponentialFactory.hxx"
#include "FarlieGumbelMorgensternCopula.hxx"
#include "FarlieGumbelMorgensternCopulaFactory.hxx"
#include "FrankCopula.hxx"
#include "FrankCopulaFactory.hxx"
#include "FisherSnedecor.hxx"
#include "FisherSnedecorFactory.hxx"
#include "Frechet.hxx"
#include "Gamma.hxx"
#include "GammaFactory.hxx"
#include "GammaMuSigma.hxx"
#include "GeneralizedPareto.hxx"
#include "GeneralizedParetoFactory.hxx"
#include "Geometric.hxx"
#include "GeometricFactory.hxx"
#include "Gumbel.hxx"
#include "GumbelCopula.hxx"
#include "GumbelCopulaFactory.hxx"
#include "GumbelFactory.hxx"
#include "GumbelAB.hxx"
#include "GumbelMuSigma.hxx"
#include "Histogram.hxx"
#include "HistogramFactory.hxx"
#include "IndependentCopula.hxx"
#include "InverseChiSquare.hxx"
#include "InverseGamma.hxx"
#include "InverseNormal.hxx"
#include "InverseNormalFactory.hxx"
#include "InverseWishart.hxx"
#include "KPermutationsDistribution.hxx"
#include "KernelMixture.hxx"
#include "KernelSmoothing.hxx"
#include "Laplace.hxx"
#include "LaplaceFactory.hxx"
#include "Logistic.hxx"
#include "LogisticFactory.hxx"
#include "LogNormal.hxx"
#include "LogNormalFactory.hxx"
#include "LogNormalMuSigma.hxx"
#include "LogNormalMuSigmaOverMu.hxx"
#include "LogUniform.hxx"
#include "LogUniformFactory.hxx"
#include "OrderStatisticsMarginalChecker.hxx"
#include "OrdinalSumCopula.hxx"
#include "MarginalDistribution.hxx"
#include "MaximumDistribution.hxx"
#include "MaximumEntropyOrderStatisticsDistribution.hxx"
#include "MaximumEntropyOrderStatisticsCopula.hxx"
#include "MaximumLikelihoodFactory.hxx"
#include "MeixnerDistribution.hxx"
#include "MeixnerDistributionFactory.hxx"
#include "MinCopula.hxx"
#include "Mixture.hxx"
#include "Multinomial.hxx"
#include "MultinomialFactory.hxx"
#include "NegativeBinomial.hxx"
#include "NegativeBinomialFactory.hxx"
#include "NonCentralChiSquare.hxx"
#include "NonCentralStudent.hxx"
#include "Normal2DCDF.hxx"
#include "Normal3DCDF.hxx"
#include "Normal.hxx"
#include "NormalCopula.hxx"
#include "NormalCopulaFactory.hxx"
#include "NormalFactory.hxx"
#include "NormalGamma.hxx"
#include "ParametrizedDistribution.hxx"
#include "Poisson.hxx"
#include "PoissonFactory.hxx"
#include "PosteriorDistribution.hxx"
#include "ProductDistribution.hxx"
#include "RandomMixture.hxx"
#include "RatioDistribution.hxx"
#include "Rayleigh.hxx"
#include "RayleighFactory.hxx"
#include "Rice.hxx"
#include "RiceFactory.hxx"
#include "Skellam.hxx"
#include "SkellamFactory.hxx"
#include "Student.hxx"
#include "StudentFunctions.hxx"
#include "StudentFactory.hxx"
#include "TracyWidomGOE.hxx"
#include "TracyWidomGSE.hxx"
#include "TracyWidomGUE.hxx"
#include "Trapezoidal.hxx"
#include "TrapezoidalFactory.hxx"
#include "Triangular.hxx"
#include "TriangularFactory.hxx"
#include "TruncatedDistribution.hxx"
#include "TruncatedNormal.hxx"
#include "TruncatedNormalFactory.hxx"
#include "Uniform.hxx"
#include "UniformFactory.hxx"
#include "UserDefined.hxx"
#include "UserDefinedPair.hxx"
#include "UserDefinedFactory.hxx"
#include "VonMises.hxx"
#include "Weibull.hxx"
#include "WeibullFactory.hxx"
#include "WeibullMuSigma.hxx"
#include "Wishart.hxx"
#include "ZipfMandelbrot.hxx"

#endif /* OPENTURNS_OTDISTRIBUTION_HXX */
