//                                               -*- C++ -*-
/**
 * @file  SVMKernelRegressionGradient.hxx
 * @brief Implementation of SVM regression gradient
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SVMKernelRegressionGradient.hxx 805 2008-05-05 06:50:15Z schueller $
 */

#ifndef OPENTURNS_SVMKERNELREGRESSIONGRADIENT_HXX
#define OPENTURNS_SVMKERNELREGRESSIONGRADIENT_HXX

#include "SVMKernel.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "SVMKernelRegressionEvaluation.hxx"
#include "NumericalSample.hxx"


BEGIN_NAMESPACE_OPENTURNS

class SVMKernelRegressionEvaluation;

/**
 * @class SVMKernelRegressionGradient
 *
 * Implementation of SVM regression gradient
 */

class SVMKernelRegressionGradient
  : public NumericalMathGradientImplementation
{
  CLASSNAME;
public:

  typedef Pointer<SVMKernelRegressionEvaluation> SVMEvaluation;

  /** Default constructor */
  SVMKernelRegressionGradient();

  /** Constructor with parameters */
  SVMKernelRegressionGradient(const SVMKernel & kernel,
                              const NumericalPoint & lagrangeMultiplier,
                              const NumericalSample & dataIn,
                              const NumericalScalar constant);

  /** Constructor from SVMKernelRegressionEvaluation */
  SVMKernelRegressionGradient(const SVMEvaluation & p_svmEvaluation);

  /** Virtual constructor */
  virtual SVMKernelRegressionGradient * clone() const;

  /** Comparison operator */
  Bool operator ==(const SVMKernelRegressionGradient & other) const;

  /** String converter */
  virtual String __repr__() const;

  /** Test for actual implementation */
  virtual Bool isActualImplementation() const;

  /** Gradient method */
  virtual Matrix gradient(const NumericalPoint & inP) const;

  /** Accessor for input point dimension */
  virtual UnsignedLong getInputDimension() const;

  /** Accessor for output point dimension */
  virtual UnsignedLong getOutputDimension() const;

private:

protected:
  SVMKernel kernel_;
  NumericalPoint lagrangeMultiplier_;
  NumericalSample dataIn_;
  NumericalScalar constant_;
  SVMEvaluation p_svmEvaluation_;

}; /* class SVMKernelRegressionGradient */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_SVMKERNELREGRESSIONGRADIENT_HXX */
