//                                               -*- C++ -*-
/**
 *  @file  Experiment.cxx
 *  @brief Abstract top-level view of an experiment plane
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-28 00:59:04 +0200 (Wed, 28 Mar 2012) $
 *  Id:      $Id: Experiment.cxx 2435 2012-03-27 22:59:04Z lebrun $
 */
#include "Experiment.hxx"
#include "Axial.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(Experiment);

/* Default constructor */
Experiment::Experiment(const String & name)
  : TypedInterfaceObject<ExperimentImplementation>(new Axial(name))
{
  // Nothing to do
}

/* Constructor from implementation pointer */
Experiment::Experiment(const Implementation & p_implementation,
                       const String & name)
  : TypedInterfaceObject<ExperimentImplementation>(p_implementation)
{
  // Nothing to do
}

/* Constructor from implementation */
Experiment::Experiment(const ExperimentImplementation & implementation,
                       const String & name)
  : TypedInterfaceObject<ExperimentImplementation>(implementation.clone())
{
  // Nothing to do
}

/* String converter */
String Experiment::__repr__() const
{
  OSS oss;
  oss << "class=" << GetClassName()
      << " name=" << getName ()
      << " implementation=" << getImplementation()->__repr__();
  return oss;
}

void Experiment::setImplementation(const Implementation & p_implementation)
{
  copyOnWrite();
  getImplementation() = p_implementation;
}

/* Sample generation */
NumericalSample Experiment::generate()
{
  return getImplementation()->generate();
}

END_NAMESPACE_OPENTURNS
