//                                               -*- C++ -*-
/**
 *  @file  OTtypes.hxx
 *  @brief The header file that declares all general types
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: OTtypes.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_OTTYPES_HXX
#define OPENTURNS_OTTYPES_HXX

#include <string>                // for std::string
#include <complex>               // for std::complex

/**
 * @namespace  OpenTURNS
 * @brief      The namespace where all Open TURNS symbols live.
 */

#define BEGIN_NAMESPACE_OPENTURNS namespace OT {
#define END_NAMESPACE_OPENTURNS   }

BEGIN_NAMESPACE_OPENTURNS

/**
 * Type Bool is an alias for the C++ standard bool type
 */
typedef bool Bool;

/**
 * Type String should store Unicode strings (for later internationalization)
 */
typedef std::string String;

/**
 * Type Id is an unique identifier number for PersistentObjects
 */
typedef unsigned long Id;

/**
 * Type NumericalScalar is a floating point number representation
 */
typedef double NumericalScalar;

/**
 * Type NumericalComplex is a complex floating point number representation
 */
typedef std::complex<NumericalScalar> NumericalComplex;

/**
 * Type FileName stores file names and pathes
 */
typedef std::string FileName;

/**
 * Type UnsignedLong stores values for that should be positive integers
 */
typedef unsigned long UnsignedLong;

/**
 * Type SizeType stores values for sizes, quantities, etc.
 */
typedef long SizeType;

/**
 * Type IndexType stores values for indexes, positions, etc.
 */
typedef long IndexType;

/**
 * Type LibraryHandle stores dynamic library pointers
 */
typedef void * LibraryHandle;

/**
 * Type LibrarySymbol stores pointers library symbols
 */
typedef void * LibrarySymbol;

/**
 * The types for utility functions
 */
typedef void (*LogFunctionPointer) (const String &);




/**
 * @fn Bool operator !=(const T & lhs, const T & rhs)
 *
 * @brief Templated inequality comparison operator
 * @param lhs The left hand side of the comparison
 * @param rhs The right hand side of the comparison
 * @return True if \em lhs is different from \em rhs
 */

template <class T> inline
Bool operator !=(const T & lhs, const T & rhs)
{
  return !(lhs == rhs);
}

END_NAMESPACE_OPENTURNS

/**
 * An alias to namespace OT.
 * @sa         OT
 */
namespace OpenTURNS = OT;


#endif /* OPENTURNS_OTTYPES_HXX */
