/*
             Common Public License Version 0.5

             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.

             1. DEFINITIONS

             "Contribution" means: 
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and 

                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;

                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.


             "Contributor" means any person or entity that distributes
             the Program.

             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program. 

             "Program" means the Contributions distributed in
             accordance with this Agreement.

             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.

             2. GRANT OF RIGHTS

                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.

                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.

                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.

                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.

             3. REQUIREMENTS

             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and

                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;

                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;

                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and

                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program. 

             Contributors may not remove or alter any copyright notices
             contained within the Program.

             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution. 


             4. COMMERCIAL DISTRIBUTION

             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.


             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.


             5. NO WARRANTY

             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations. 

             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL

             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.


             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.

             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive. 

             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.


             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation. 



*/

/* (C) COPYRIGHT Corrent Corp. 2002, 2003          */
 
/***************************************************************************
                          Change Log
                          ==========
       5/19/03    Kapil Sood (kapil@corrent.com)
                  Added support for CKA_VALUE_BITS for DH
       4/25/03    Kapil Sood (kapil@corrent.com)
                  Added DH key pair generation and DH shared key derivation
                  functions.
       8/27/02    Kapil Sood (kapil@corrent.com)
                  Added token interface for the Corrent S2000/S2010/S3500
                  PCI-X based crypto accelerator cards.
 
****************************************************************************/


#include <pthread.h>
#include <string.h>            // for memcmp() et al
#include <stdlib.h>

#include "pkcs11types.h"
#include "defs.h"
#include "host_defs.h"
#include "h_extern.h"
#include "args.h"
#include "errno.h"
#include "tok_specific.h"

#include <openssl/des.h>
#include <openssl/rand.h>
#include <openssl/rsa.h>
#include <openssl/aes.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>

#include "typhoon.h"
#include "tok_struct.h"

typedef unsigned int uint32_t;
int crfd ;

pthread_mutex_t  rngmtx = PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t  nextmutex = PTHREAD_MUTEX_INITIALIZER;
unsigned int     rnginitialized=0;

int CR_MAX_MODULUS_SIZE_BITS = 2048 ;
int CR_MAX_MODULUS_SIZE_BYTES = 256 ;

CK_CHAR manuf[] = "Corrent Corp.";
CK_CHAR model[] = "S3500/S2000" ;
CK_CHAR descr[] = "PKCS#11 Corrent token";
CK_CHAR label[] = "Linux PKCS#11   ";


CK_RV
token_specific_session(CK_SLOT_ID  slotid)
{
    return CKR_OK;
}

CK_RV
token_rng(CK_BYTE *output, CK_ULONG bytes)
{

    token  rand_num ;
    RC     rc ;

    rand_num.p_data    = (BYTE *) output ;
    rand_num.data_size = bytes ;

    rc = CR_get_random(&rand_num, (INT32) bytes) ;
    if (rc != SUCCESS) 
    {
        st_err_log(11, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }

#if 0

     int  ranfd;
     int  rlen,totallen=0;
 
     ranfd = open("/dev/urandom",O_RDONLY);
     if (ranfd >= 0 ){
 
        do {
                rlen = read(ranfd,output+totallen,bytes-totallen);
                totallen += rlen;
        } while( totallen < bytes);
        return CKR_OK;
     } else {
        return CKR_FUNCTION_FAILED;
     }

#endif /* if 0 */


}
// convert pkcs slot number to local representation
int
tok_slot2local(CK_SLOT_ID snum)
{
    return 1;  
}

CK_RV
token_specific_init(char * Correlator,CK_SLOT_ID SlotNumber)
{
    crfd = CR_init_lib(NULL, NULL);
    return CKR_OK;
}

CK_RV
token_specific_final()
{
	CR_close_lib();
	return CKR_OK;
}

CK_RV
token_specific_des_key_gen(CK_BYTE  *des_key,CK_ULONG len)
{
      
	// Nothing different to do for DES or TDES here as this is just
	// random data...  Validation handles the rest
	rng_generate(des_key,len);
        
	// we really need to validate the key for parity etc...
	// we should do that here... The caller validates the single des keys
	// against the known and suspected poor keys..
	return CKR_OK;
}

// convert from the local PKCS11 template representation to
// the underlying requirement
// returns the pointer to the local key representation
//
void * rsa_convert_public_key( OBJECT *key_obj )
{
   CK_BBOOL           rc;
   CK_ATTRIBUTE       *modulus = NULL;
   CK_ATTRIBUTE       *pub_exp = NULL;
   rsa_key            *rsa_pub_key;
   token              *t_modulus, *t_exponent ;

   rc  = template_attribute_find( key_obj->template, CKA_MODULUS,         &modulus );
   rc &= template_attribute_find( key_obj->template, CKA_PUBLIC_EXPONENT, &pub_exp );

   if (rc == FALSE) 
      return NULL;

   rsa_pub_key = (rsa_key *) create_rsa_key(modulus->ulValueLen, pub_exp->ulValueLen);
   if (rsa_pub_key == NULL) 
      return NULL;

   memcpy(rsa_pub_key->modulus->p_data, modulus->pValue, modulus->ulValueLen) ;
   memcpy(rsa_pub_key->exponent->p_data, pub_exp->pValue, pub_exp->ulValueLen) ;
   rsa_pub_key->modulus->data_size  = modulus->ulValueLen; 
   rsa_pub_key->exponent->data_size = pub_exp->ulValueLen;

   return (void *)rsa_pub_key;

}

void * rsa_convert_private_key(OBJECT *key_obj)
{
    CK_ATTRIBUTE      * modulus  = NULL;
    CK_ATTRIBUTE      * priv_exp = NULL;
    CK_ATTRIBUTE      * prime1   = NULL;
    CK_ATTRIBUTE      * prime2   = NULL;
    CK_ATTRIBUTE      * exp1     = NULL;
    CK_ATTRIBUTE      * exp2     = NULL;
    CK_ATTRIBUTE      * coeff    = NULL;
    CK_BBOOL          rc;
    rsa_crt_key       *privKey;
    rsa_key           *privKey2 ;

    rc  = template_attribute_find( key_obj->template, CKA_MODULUS,           &modulus );
    rc &= template_attribute_find( key_obj->template, CKA_PRIVATE_EXPONENT, &priv_exp );
    rc &= template_attribute_find( key_obj->template, CKA_PRIME_1,          &prime1 );
    rc &= template_attribute_find( key_obj->template, CKA_PRIME_2,          &prime2 );
    rc &= template_attribute_find( key_obj->template, CKA_EXPONENT_1,       &exp1 );
    rc &= template_attribute_find( key_obj->template, CKA_EXPONENT_2,       &exp2 );
    rc &= template_attribute_find( key_obj->template, CKA_COEFFICIENT,      &coeff );

    if ( rc == FALSE) 
        return NULL;

    /* CRT operations are faster for N>1024 operations. For all other operations, 
       perform non-CRT operations */

    if (modulus->ulValueLen > 1024)
    {
        privKey = (rsa_crt_key *) create_rsa_crt_key(prime1->ulValueLen, prime2->ulValueLen, 
                                                     exp1->ulValueLen, exp2->ulValueLen, 
                                                     coeff->ulValueLen) ;
        if (privKey != NULL)
        {
            memcpy(privKey->prime_p->p_data, prime1->pValue, prime1->ulValueLen) ;
            privKey->prime_p->data_size = prime1->ulValueLen;

            memcpy(privKey->prime_q->p_data, prime2->pValue, prime2->ulValueLen) ;
            privKey->prime_q->data_size = prime2->ulValueLen;

            memcpy(privKey->dmp1->p_data, exp1->pValue, exp1->ulValueLen) ;
            privKey->dmp1->data_size    = exp1->ulValueLen;

            memcpy(privKey->dmq1->p_data, exp2->pValue, exp2->ulValueLen) ;
            privKey->dmq1->data_size    = exp2->ulValueLen;

            memcpy(privKey->iqmp->p_data, coeff->pValue, coeff->ulValueLen) ;
            privKey->iqmp->data_size    = coeff->ulValueLen;

            return (void *) privKey ;
        } 
        else 
            return NULL;

    } 
    else
    {
        privKey2 = (rsa_key *) create_rsa_key(modulus->ulValueLen, priv_exp->ulValueLen) ;
        if (privKey2 != NULL)
        {
            memcpy(privKey2->modulus->p_data, modulus->pValue, modulus->ulValueLen) ;
            privKey2->modulus->data_size  = modulus->ulValueLen; 

            memcpy(privKey2->exponent->p_data, priv_exp->pValue, priv_exp->ulValueLen) ;
            privKey2->exponent->data_size = priv_exp->ulValueLen;
 
            return (void *) privKey2 ;
        }
        else
            return NULL ;
    }

    return NULL;

} /* end rsa_convert_private_key() */

#define RNG_BUF_SIZE 100

// This function is only required if public key cryptography
// has been selected in your variant set up.
// Set a mutex in this function and get a cache;
// using the ICA device to get random numbers a byte at a
//  time is VERY slow..  Keygen is gated by this function.

unsigned char nextRandom (void) 
{
    static unsigned char  buffer[RNG_BUF_SIZE];
    unsigned char  byte;
    static int used = (RNG_BUF_SIZE); // protected access by the mutex

    pthread_mutex_lock(&nextmutex);
    if (used >= RNG_BUF_SIZE)
    {
        rng_generate(buffer,sizeof(buffer));
        used = 0;
    }

    byte = buffer[used++];
    pthread_mutex_unlock(&nextmutex);
    return((unsigned char)byte);
}

void swapper(char *s, char *d, int size)
{
    int i=0;
    int j=size;
	
    for(i=0;i<size;i++)
        d[i]=s[--j];
}

CK_RV
os_specific_rsa_keygen(TEMPLATE *publ_tmpl, TEMPLATE *priv_tmpl)
{
	CK_ATTRIBUTE       *publ_exp = NULL;
	CK_ATTRIBUTE       *attr     = NULL;
	CK_ULONG            mod_bits;
	CK_BBOOL            flag;
	CK_RV               rc;
	CK_ULONG            BNLength;
	RSA                *rsa;
	BIGNUM             *bignum;
	CK_BYTE            *ssl_ptr;
	unsigned long      three = 3;
	unsigned char      *exp_str;
	unsigned long      exponent;

	flag = template_attribute_find( publ_tmpl, CKA_MODULUS_BITS, &attr );
	if (!flag){
		st_err_log(48, __FILE__, __LINE__);
		return CKR_TEMPLATE_INCOMPLETE;  // should never happen
        }
	mod_bits = *(CK_ULONG *)attr->pValue;

	flag = template_attribute_find( publ_tmpl, CKA_PUBLIC_EXPONENT, &publ_exp );
	if (!flag){
		st_err_log(48, __FILE__, __LINE__);
		return CKR_TEMPLATE_INCOMPLETE;
	}

	// we don't support less than 1024 bit keys in the sw
	if (mod_bits < 512 || mod_bits > 2048) {
		st_err_log(19, __FILE__, __LINE__);
		return CKR_KEY_SIZE_RANGE;
	}

	// Because of a limition of OpenSSL, this token only supports
	// 3 as an exponent in RSA key generation
	rsa = RSA_new();
	if (rsa == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		return CKR_HOST_MEMORY;
	}
	RSA_blinding_off(rsa);
	rsa = RSA_generate_key(mod_bits, three, NULL, NULL);
	if (rsa == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		return CKR_HOST_MEMORY;
	}

	// Now fill in the objects..
	//
	// modulus: n
	//
	bignum = rsa->n;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_MODULUS, ssl_ptr, BNLength, &attr ); // in bytes
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
        }
	template_update_attribute( publ_tmpl, attr );
	free(ssl_ptr);

	// Public Exponent
        bignum = rsa->e;
        BNLength = BN_num_bytes(bignum);
        ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
        BNLength = BN_bn2bin(bignum, ssl_ptr);
        rc = build_attribute( CKA_PUBLIC_EXPONENT, ssl_ptr, BNLength, &attr ); // in bytes
        if (rc != CKR_OK){
                st_err_log(84, __FILE__, __LINE__);
                goto done;
        }
        template_update_attribute( publ_tmpl, attr );
        free(ssl_ptr);

	// local = TRUE
	//
	flag = TRUE;
	rc = build_attribute( CKA_LOCAL, &flag, sizeof(CK_BBOOL), &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( publ_tmpl, attr );

	//
	// now, do the private key
	//
	// Cheat here and put the whole original key into the CKA_VALUE... remember
	// to force the system to not return this for RSA keys..

	// Add the modulus to the private key information

	bignum = rsa->n;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_MODULUS, ssl_ptr, BNLength ,&attr ); // in bytes
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	// Private Exponent

        bignum = rsa->d;
        BNLength = BN_num_bytes(bignum);
        ssl_ptr = malloc( BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
        BNLength = BN_bn2bin(bignum, ssl_ptr);
        rc = build_attribute( CKA_PRIVATE_EXPONENT, ssl_ptr, BNLength, &attr );
        if (rc != CKR_OK){
                st_err_log(84, __FILE__, __LINE__);
                goto done;
        }
        template_update_attribute( priv_tmpl, attr );
        free(ssl_ptr);

	// prime #1: p
	//
	bignum = rsa->p;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_PRIME_1, ssl_ptr, BNLength, &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	// prime #2: q
	//
	bignum = rsa->q;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_PRIME_2, ssl_ptr, BNLength, &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	// exponent 1: d mod(p-1)
	//
	bignum = rsa->dmp1;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_EXPONENT_1, ssl_ptr, BNLength, &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	// exponent 2: d mod(q-1)
	//
	bignum = rsa->dmq1;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_EXPONENT_2, ssl_ptr, BNLength, &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	// CRT coefficient:  q_inverse mod(p)
	//
	bignum = rsa->iqmp;
	BNLength = BN_num_bytes(bignum);
	ssl_ptr = malloc(BNLength);
	if (ssl_ptr == NULL) {
		st_err_log(1, __FILE__, __LINE__);
		rc = CKR_HOST_MEMORY;
		goto done;
	}
	BNLength = BN_bn2bin(bignum, ssl_ptr);
	rc = build_attribute( CKA_COEFFICIENT, ssl_ptr, BNLength, &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );
	free(ssl_ptr);

	flag = TRUE;
	rc = build_attribute( CKA_LOCAL, &flag, sizeof(CK_BBOOL), &attr );
	if (rc != CKR_OK){
		st_err_log(84, __FILE__, __LINE__);
		goto done;
	}
	template_update_attribute( priv_tmpl, attr );

done:
	RSA_free(rsa);
	return rc;
}

CK_RV
token_specific_rsa_generate_keypair( TEMPLATE  * publ_tmpl,
                                     TEMPLATE  * priv_tmpl )
{
	CK_RV                rc;

	rc = os_specific_rsa_keygen(publ_tmpl,priv_tmpl);
	if (rc != CKR_OK)
		st_err_log(91, __FILE__, __LINE__);
	return rc;
}

CK_RV token_specific_rsa_encrypt( CK_BYTE   *in_data,
                                  CK_ULONG  in_data_len,
                                  CK_BYTE   *out_data,
                                  OBJECT    *key_obj )
{
    RC              rc;
    CK_RV           ret_val ;
    rsa_key         *mexp;
    token           ciphertext, plaintext ;
    CK_ULONG        count ;

    mexp = (rsa_key *)rsa_convert_public_key(key_obj);
    if (mexp == NULL) 
          return CKR_FUNCTION_FAILED;

    /* Setup the input and output Corrent tokens */
    plaintext.p_data     = in_data ;
    plaintext.data_size  = in_data_len ;
    ciphertext.p_data    = out_data ;
    ciphertext.data_size = in_data_len ; /* will be updated by the CR lib */

    rc = CR_mod_exp_mont(&ciphertext, &plaintext, mexp->modulus, mexp->exponent) ;
    if ( rc == SUCCESS )
        ret_val = CKR_OK;
    else
        ret_val = CKR_FUNCTION_FAILED;

    /* Corrent library may return results after triming leading zeros. Insert the leading
       zeros back and adjust length below, if necessary */
    if (ciphertext.data_size < in_data_len) 
    {
        memmove(&out_data[in_data_len-ciphertext.data_size], &out_data[0], ciphertext.data_size) ;
        memset(&out_data[0], 0, in_data_len-ciphertext.data_size) ;
        ciphertext.data_size = in_data_len ;
    }

    /* Free the key storage for CR format */
    destroy_rsa_key((rsa_key *) mexp) ;

    return ret_val ;

} /* end token_specific_rsa_encrypt() */

CK_RV token_specific_rsa_decrypt( CK_BYTE   *in_data,
                                  CK_ULONG  in_data_len,
                                  CK_BYTE   *out_data,
                                  OBJECT    *key_obj )
{
    CK_ATTRIBUTE    *modulus ;
    RC              rc ;
    CK_RV           ret_val;
    rsa_crt_key     *privKey = NULL;
    rsa_key         *privKey2 = NULL;
    token           ciphertext, plaintext ;
    INT32           count ;

    rc  = template_attribute_find( key_obj->template, CKA_MODULUS, &modulus );
    if ( rc == FALSE) 
        return CKR_FUNCTION_FAILED;

    /* CRT operations are faster for N>1024 operations. For all other operations, 
       perform non-CRT operations */

    if (modulus->ulValueLen > 1024)
        privKey = (rsa_crt_key *)rsa_convert_private_key(key_obj);
    else
        privKey2 = (rsa_key *)rsa_convert_private_key(key_obj);

    if ((privKey == NULL) && (privKey2 == NULL))
       return CKR_FUNCTION_FAILED;

    memset(out_data, 0, in_data_len) ;

    /* Setup the input and output Corrent tokens */
    ciphertext.p_data     = in_data ;
    ciphertext.data_size  = in_data_len ;
    plaintext.p_data      = out_data ;
    plaintext.data_size   = in_data_len ; /* will be updated by the CR lib */
 
    /* Based on modulus size, invoke CRT or non-CRT */
    if (modulus->ulValueLen > 1024)
        rc = CR_mod_exp_crt(&plaintext, &ciphertext, privKey->prime_p, privKey->prime_q, 
                            privKey->dmp1, privKey->dmq1, privKey->iqmp) ;
    else
        rc = CR_mod_exp_mont(&plaintext, &ciphertext, privKey2->modulus, privKey2->exponent) ;

    /* Corrent library returns results after triming leading zeros. Insert the leading
       zeros back and adjust length below, if necessary */
    if (plaintext.data_size < in_data_len) 
    {
        memmove(&out_data[in_data_len-plaintext.data_size], &out_data[0], plaintext.data_size) ;
        memset(&out_data[0], 0, in_data_len-plaintext.data_size) ;
        plaintext.data_size = in_data_len ;
    }

    if ( rc == SUCCESS )
        ret_val = CKR_OK;
    else
        ret_val = CKR_FUNCTION_FAILED;

    /* Free the key storage for CR format */
    if (modulus->ulValueLen > 1024)
        destroy_rsa_crt_key((rsa_crt_key *) privKey) ;
    else
        destroy_rsa_key((rsa_key *) privKey2) ;

    return ret_val ;

} /* end token_specific_rsa_decrypt() */


CK_RV
token_specific_des_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value,
                       CK_BYTE  encrypt)
{
	CK_ULONG       rc;
	
	des_key_schedule des_key2;
   	const_des_cblock key_val_SSL, in_key_data;
	des_cblock out_key_data;
	int i,j;
   	int ret;

  	// Create the key schedule
	memcpy(&key_val_SSL, key_value, 8);
	des_set_key_unchecked(&key_val_SSL, des_key2);

	// the des decrypt will only fail if the data length is not evenly divisible
	// by 8
	if (in_data_len % 8 ){
		st_err_log(11, __FILE__, __LINE__);
		return CKR_DATA_LEN_RANGE;
	}

	// Both the encrypt and the decrypt are done 8 bytes at a time
	if (encrypt) {
		for (i=0; i<in_data_len; i=i+8) {
			memcpy(in_key_data, in_data+i, 8);
			des_ecb_encrypt(&in_key_data, &out_key_data, des_key2, DES_ENCRYPT);
			memcpy(out_data+i, out_key_data, 8);
		}

		*out_data_len = in_data_len;
		rc = CKR_OK;
	} else {
 
		for(j=0; j < in_data_len; j=j+8) {
			memcpy(in_key_data, in_data+j, 8);
			des_ecb_encrypt(&in_key_data, &out_key_data, des_key2, DES_DECRYPT);
			memcpy(out_data+j, out_key_data, 8);
		}
     
	*out_data_len = in_data_len;
	rc = CKR_OK;
	}

   return rc;
}

CK_RV
token_specific_des_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{
	CK_ULONG         rc;
	
	des_cblock ivec;
	int ret;

	des_key_schedule des_key2;
   	const_des_cblock key_val_SSL, in_key_data;
	des_cblock out_key_data;

	// Create the key schedule
	memcpy(&key_val_SSL, key_value, 8);
   	des_set_key_unchecked(&key_val_SSL, des_key2);
   
	memcpy(&ivec, init_v, 8);
	// the des decrypt will only fail if the data length is not evenly divisible
	// by 8
	if (in_data_len % 8 ){
		st_err_log(11, __FILE__, __LINE__);
		return CKR_DATA_LEN_RANGE;
	}


	if ( encrypt){
		des_ncbc_encrypt(in_data, out_data, in_data_len, des_key2, &ivec, DES_ENCRYPT);
		*out_data_len = in_data_len;
		rc = CKR_OK;
	} else {
		des_ncbc_encrypt(in_data, out_data, in_data_len, des_key2, &ivec, DES_DECRYPT);
		*out_data_len = in_data_len;
		rc = CKR_OK;
	}
	return rc;
}

CK_RV
token_specific_tdes_ecb(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value,
                       CK_BYTE  encrypt)
{
	CK_RV  rc;

	int k,j, ret;
	des_cblock out_temp;
	des_key_schedule des_key1;
	des_key_schedule des_key2;
	des_key_schedule des_key3;

   	const_des_cblock key_SSL1, key_SSL2, key_SSL3, in_key_data;
	des_cblock out_key_data;

	// The key as passed is a 24 byte long string containing three des keys
	// pick them apart and create the 3 corresponding key schedules
	memcpy(&key_SSL1, key_value, 8);
	memcpy(&key_SSL2, key_value+8, 8);
	memcpy(&key_SSL3, key_value+16, 8);
	des_set_key_unchecked(&key_SSL1, des_key1);
	des_set_key_unchecked(&key_SSL2, des_key2);
	des_set_key_unchecked(&key_SSL3, des_key3);

	// the des decrypt will only fail if the data length is not evenly divisible
	// by 8
	if (in_data_len % 8 ){
		st_err_log(11, __FILE__, __LINE__);
		return CKR_DATA_LEN_RANGE;
	}

	// the encrypt and decrypt are done 8 bytes at a time
	if (encrypt) {
		for(k=0;k<in_data_len;k=k+8){
		memcpy(in_key_data, in_data+k, 8);
		des_ecb3_encrypt(&in_key_data, 
				&out_key_data, 
				des_key1, 
				des_key2,
				des_key3,
				DES_ENCRYPT);
		memcpy(out_data+k, out_key_data, 8);
	}
	*out_data_len = in_data_len;
	rc = CKR_OK;
	} else {
		for (j=0;j<in_data_len;j=j+8){
		memcpy(in_key_data, in_data+j, 8);
		des_ecb3_encrypt(&in_key_data,
				&out_key_data, 
				des_key1,
				des_key2,
				des_key3, 
				DES_DECRYPT);
		memcpy(out_data+j, out_key_data, 8);
	}
      *out_data_len = in_data_len;
      rc = CKR_OK;
   }
   return rc;
}

CK_RV
token_specific_tdes_cbc(CK_BYTE * in_data,
                       CK_ULONG in_data_len,
                       CK_BYTE *out_data,
                       CK_ULONG *out_data_len,
                       CK_BYTE  *key_value, 
                       CK_BYTE *init_v,
                       CK_BYTE  encrypt)
{

	CK_RV rc = CKR_OK;
	des_key_schedule des_key1;
	des_key_schedule des_key2;
	des_key_schedule des_key3;

   	const_des_cblock key_SSL1, key_SSL2, key_SSL3, in_key_data;
	des_cblock ivec;

	// The key as passed in is a 24 byte string containing 3 keys
	// pick it apart and create the key schedules
	memcpy(&key_SSL1, key_value, 8);
	memcpy(&key_SSL2, key_value+8, 8);
	memcpy(&key_SSL3, key_value+16, 8);
	des_set_key_unchecked(&key_SSL1, des_key1);
	des_set_key_unchecked(&key_SSL2, des_key2);
	des_set_key_unchecked(&key_SSL3, des_key3);

	memcpy(ivec, init_v, sizeof(ivec));

	// the des decrypt will only fail if the data length is not evenly divisible
	// by 8
	if (in_data_len % 8 ){
		st_err_log(11, __FILE__, __LINE__);
		return CKR_DATA_LEN_RANGE;
	}

	// Encrypt or decrypt the data
	if (encrypt){
		des_ede3_cbc_encrypt(in_data,
			     out_data,
			     in_data_len,
			     des_key1,
			     des_key2,
			     des_key3,
			     &ivec,
			     DES_ENCRYPT);
	*out_data_len = in_data_len;
	rc = CKR_OK;
	}else {
		des_ede3_cbc_encrypt(in_data,
					out_data,
					in_data_len,
					des_key1,
					des_key2,
					des_key3,
					&ivec,
					DES_DECRYPT);

	*out_data_len = in_data_len;
	rc = CKR_OK;
	}

	return rc;
}

#ifndef NOAES
CK_RV
token_specific_aes_key_gen( CK_BYTE *key, CK_ULONG len )
{
        return rng_generate(key, len);
}

CK_RV
token_specific_aes_ecb( CK_BYTE         *in_data,
                        CK_ULONG        in_data_len,
                        CK_BYTE         *out_data,
                        CK_ULONG        *out_data_len,
                        CK_BYTE         *key_value,
                        CK_ULONG        key_len,
                        CK_BYTE         encrypt)
{
        AES_KEY         ssl_aes_key;
        int             i;
        /* There's a previous check that in_data_len % AES_BLOCK_SIZE == 0,
         * so this is fine */
        CK_ULONG        loops = (CK_ULONG)(in_data_len/AES_BLOCK_SIZE);

        memset( &ssl_aes_key, 0, sizeof(AES_KEY));

        // AES_ecb_encrypt encrypts only a single block, so we have to break up the
        // input data here
        if (encrypt) {
                AES_set_encrypt_key((unsigned char *)key_value, (key_len*8), &ssl_aes_key);
                for( i=0; i<loops; i++ ) {
                        AES_ecb_encrypt((unsigned char *)in_data + (i*AES_BLOCK_SIZE),
                                        (unsigned char *)out_data + (i*AES_BLOCK_SIZE),
                                        &ssl_aes_key,
                                        AES_ENCRYPT);
                }
        } else {
                AES_set_decrypt_key((unsigned char *)key_value, (key_len*8), &ssl_aes_key);
                for( i=0; i<loops; i++ ) {
                        AES_ecb_encrypt((unsigned char *)in_data + (i*AES_BLOCK_SIZE),
                                        (unsigned char *)out_data + (i*AES_BLOCK_SIZE),
                                        &ssl_aes_key,
                                        AES_DECRYPT);
                }
        }
        *out_data_len = in_data_len;
        return CKR_OK;
}

CK_RV
token_specific_aes_cbc( CK_BYTE         *in_data,
                        CK_ULONG        in_data_len,
                        CK_BYTE         *out_data,
                        CK_ULONG        *out_data_len,
                        CK_BYTE         *key_value,
                        CK_ULONG        key_len,
                        CK_BYTE         *init_v,
                        CK_BYTE         encrypt)
{
        AES_KEY         ssl_aes_key;
        int             i;

        memset( &ssl_aes_key, 0, sizeof(AES_KEY));

        // AES_cbc_encrypt chunks the data into AES_BLOCK_SIZE blocks, unlike
        // AES_ecb_encrypt, so no looping required.
        if (encrypt) {
                AES_set_encrypt_key((unsigned char *)key_value, (key_len*8), &ssl_aes_key);
                AES_cbc_encrypt((unsigned char *)in_data, (unsigned char *)out_data,
                                in_data_len,              &ssl_aes_key,
                                init_v,                   AES_ENCRYPT);
        } else {
                AES_set_decrypt_key((unsigned char *)key_value, (key_len*8), &ssl_aes_key);
                AES_cbc_encrypt((unsigned char *)in_data, (unsigned char *)out_data,
                                in_data_len,              &ssl_aes_key,
                                init_v,                   AES_DECRYPT);
        }
        *out_data_len = in_data_len;
        return CKR_OK;
}
#endif

// This computes DH shared secret, where:
//     Output: z is computed shared secret
//     Input:  y is other party's public key
//             x is private key
//             p is prime
// All length's are in number of bytes. All data comes in as Big Endian.

CK_RV
token_specific_dh_pkcs_derive( CK_BYTE   *z,
                               CK_ULONG  *z_len,
                               CK_BYTE   *y,
                               CK_ULONG  y_len,
                               CK_BYTE   *x,
                               CK_ULONG  x_len,
                               CK_BYTE   *p,
                               CK_ULONG  p_len)
{
     CK_RV       ret_val ;
     RC          rc ;
     token       z_tok, y_tok, x_tok, p_tok ;
 
     // Setup the tokens with values from the input params
     z_tok.p_data     = z ;
     z_tok.data_size  = p_len ;
 
     y_tok.p_data     = y ;
     y_tok.data_size  = y_len ;
     x_tok.p_data     = x ;
     x_tok.data_size  = x_len ;
     p_tok.p_data     = p ;
     p_tok.data_size  = p_len ;
 
    // Perform: z = y^x mod p
    rc = CR_mod_exp_mont(&z_tok, &y_tok, &p_tok, &x_tok) ;
    if ( rc == SUCCESS )
        ret_val = CKR_OK;
    else
    {
        ret_val = CKR_FUNCTION_FAILED;
        st_err_log(4, __FILE__, __LINE__);
    }
 
    /* Corrent library may return results after triming leading zeros. Insert the leading
       zeros back and adjust length below, if necessary */
    if (z_tok.data_size < p_len)
    {
        memmove(z+(p_len-z_tok.data_size), z, z_tok.data_size) ;
        memset(z, 0, p_len-z_tok.data_size) ;
        z_tok.data_size = p_len ;
    }

    *z_len = z_tok.data_size ;
 
    return ret_val;
 
} /* end token_specific_dh_pkcs_derive() */
 
// This computes DH key pair, where:
//     Output: priv_tmpl is generated private key
//             pub_tmpl is computed public key
//     Input:  pub_tmpl is public key (prime and generator)
// All length's are in number of bytes. All data comes in as Big Endian.
 
CK_RV
token_specific_dh_pkcs_key_pair_gen( TEMPLATE  * publ_tmpl,
                                     TEMPLATE  * priv_tmpl )
{
    RC                 rc;
    CK_ATTRIBUTE       *prime_attr = NULL;
    CK_ATTRIBUTE       *base_attr = NULL;
    CK_ATTRIBUTE       *temp_attr = NULL ;
    CK_ATTRIBUTE       *value_bits_attr = NULL;
    CK_ATTRIBUTE       *temp_value_bits_attr ;                                                                     
    CK_BYTE            *temp_byte;
    CK_ULONG           temp_bn_len, count ;
    CK_BYTE            *priv_key_value ;
    CK_ULONG           priv_key_value_len ;
    CK_BYTE            *pub_key_value ;
    CK_ULONG           pub_key_value_len ;
    CK_BYTE            *p_temp ;
 
    token              pub_key_t, priv_key_t, prime_t, base_t ;
    char               *base_p ;

    rc  = template_attribute_find( publ_tmpl, CKA_PRIME, &prime_attr );
    rc &= template_attribute_find( publ_tmpl, CKA_BASE, &base_attr );
 
    if (rc == FALSE) {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }
 
    if ((prime_attr->ulValueLen > CR_MAX_MODULUS_SIZE_BYTES) ||
        (prime_attr->ulValueLen < 64))
    {
        st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
        return CKR_FUNCTION_FAILED;
    }

    // Check if the CKA_VALUE_BITS attribute of the private key has been set.
    // If set, then check value to be less than size of prime, and use that value.
    // If not set, then use the value dependent on size of prime.
 
    rc  = template_attribute_find( priv_tmpl, CKA_VALUE_BITS, &temp_value_bits_attr );
    if (rc == FALSE)
    {
        // Randomly generate private key value
        priv_key_value_len = prime_attr->ulValueLen ;
        priv_key_value = malloc(priv_key_value_len) ;
        token_rng(priv_key_value, priv_key_value_len) ;
        // Right shift MSB of private to make it smaller than the prime
        p_temp = (CK_BYTE *)prime_attr->pValue ;
        while (p_temp[0] < priv_key_value[0])
            priv_key_value[0] = priv_key_value[0] >> 1 ;
    }
    else
    {
        // Randomly generate private key value. Round off the value of CKA_VALUE_BITS
        // to next higher byte size for added security (and convenience/speed).
        priv_key_value_len = *(CK_ULONG *)temp_value_bits_attr->pValue ;
        if (priv_key_value_len > CR_MAX_MODULUS_SIZE_BITS)
        {
            st_err_log(4, __FILE__, __LINE__, __FUNCTION__);
            return CKR_FUNCTION_FAILED;
        }
 
        // Convert to next higher Byte size
        priv_key_value_len = (priv_key_value_len/8) + 1 ;
 
        // If the value set is less than 22 (180 bits), then bump the private-key
        // value to at least 180 bits (23 bytes)...for additional security
        if (priv_key_value_len < 22)
            priv_key_value_len = 23 ;
 
        priv_key_value = malloc(priv_key_value_len) ;
        token_rng(priv_key_value, priv_key_value_len) ;
 
        // If private size is same as prime size, make sure that the private
        // value is less than prime value.
        if (priv_key_value_len == prime_attr->ulValueLen)
        {
            // Right shift MSB of private to make it smaller than the prime
            p_temp = (CK_BYTE *)prime_attr->pValue ;
            while (p_temp[0] < priv_key_value[0])
                priv_key_value[0] = priv_key_value[0] >> 1 ;
        }
    }
 
    // Calculate public key using: pub_key = base^priv_key mod prime
    // Setup the tokens with values from the input params
    pub_key_t.data_size   = CR_MAX_MODULUS_SIZE_BYTES ; 
    pub_key_value = malloc(pub_key_t.data_size) ;
    pub_key_t.p_data      = pub_key_value ;
 
    priv_key_t.p_data     = priv_key_value ;
    priv_key_t.data_size  = priv_key_value_len ;
    prime_t.p_data        = (char *)prime_attr->pValue ;
    prime_t.data_size     = prime_attr->ulValueLen ;
    base_t.p_data         = (char *)base_attr->pValue ;
    base_t.data_size      = base_attr->ulValueLen ;
 
    // Perform mod exp operation
    rc = CR_mod_exp_mont(&pub_key_t, &base_t, &prime_t, &priv_key_t) ;
    if ( rc != SUCCESS )
    {
        st_err_log(4, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED ;
    }

    /* Corrent library may return results after triming leading zeros. Insert the leading
       zeros back and adjust length below, if necessary */
    if (pub_key_t.data_size < prime_t.data_size)
    {
        memmove(pub_key_value+(prime_t.data_size-pub_key_t.data_size), pub_key_value,
                pub_key_t.data_size) ;
        memset(pub_key_value, 0, prime_t.data_size-pub_key_t.data_size) ;
        pub_key_t.data_size = prime_t.data_size ;
    }
 
    pub_key_value_len = pub_key_t.data_size ;
 
    // Insert the public key component in the publ_tmpl
    rc = build_attribute( CKA_VALUE, pub_key_value, pub_key_value_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( publ_tmpl, temp_attr );
    free(pub_key_value);
 
    // Insert the private key component in the priv_tmpl
    rc = build_attribute( CKA_VALUE, priv_key_value, priv_key_value_len, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
    free(priv_key_value);

    // Update CKA_VALUE_BITS attribute in the private key
    value_bits_attr = (CK_ATTRIBUTE *)malloc( sizeof(CK_ATTRIBUTE) + sizeof(CK_ULONG) );
    value_bits_attr->type       = CKA_VALUE_BITS;
    value_bits_attr->ulValueLen = sizeof(CK_ULONG);
    value_bits_attr->pValue     = (CK_BYTE *)value_bits_attr + sizeof(CK_ATTRIBUTE);
    *(CK_ULONG *)value_bits_attr->pValue = 8*priv_key_value_len;
    template_update_attribute( priv_tmpl, value_bits_attr );
 
    // Add prime and base to the private key template
    rc = build_attribute( CKA_PRIME,(char *)prime_attr->pValue,
                          prime_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
 
    rc = build_attribute( CKA_BASE,(char *)base_attr->pValue,
                          base_attr->ulValueLen, &temp_attr ); // in bytes
    if (rc != CKR_OK)
    {
        st_err_log(84, __FILE__, __LINE__);
        return CKR_FUNCTION_FAILED;
    }
    template_update_attribute( priv_tmpl, temp_attr );
 
    return CKR_OK ;
 
} /* end token_specific_dh_key_pair_gen() */

MECH_LIST_ELEMENT mech_list[] = {
   { CKM_RSA_PKCS_KEY_PAIR_GEN,     512, 2048, CKF_HW | CKF_GENERATE_KEY_PAIR },
#if !(NODSA)
   { CKM_DSA_KEY_PAIR_GEN,          512, 1024, CKF_HW | CKF_GENERATE_KEY_PAIR },
#endif
   { CKM_DES_KEY_GEN,                 8,    8, CKF_HW | CKF_GENERATE },
   { CKM_DES3_KEY_GEN,                24,    24, CKF_HW | CKF_GENERATE },
#if !(NOCDMF)
   { CKM_CDMF_KEY_GEN,                0,    0, CKF_HW | CKF_GENERATE },
#endif

   { CKM_RSA_PKCS,                  512, 2048, CKF_HW           |
                                               CKF_ENCRYPT      | CKF_DECRYPT |
                                               CKF_WRAP         | CKF_UNWRAP  |
                                               CKF_SIGN         | CKF_VERIFY  |
                                               CKF_SIGN_RECOVER | CKF_VERIFY_RECOVER },
#if !(NOX509)
   { CKM_RSA_X_509,                 512, 2048, CKF_HW           |
                                               CKF_ENCRYPT      | CKF_DECRYPT |
                                               CKF_WRAP         | CKF_UNWRAP  |
                                               CKF_SIGN         | CKF_VERIFY  |
                                               CKF_SIGN_RECOVER | CKF_VERIFY_RECOVER },
#endif
#if !(NOMD2)
   { CKM_MD2_RSA_PKCS,              512, 2048, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },

#endif
#if !(NOMD5)
   { CKM_MD5_RSA_PKCS,              512, 2048, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif
#if !(NOSHA1)
   { CKM_SHA1_RSA_PKCS,             512, 2048, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif


#if !(NODSA)
   { CKM_DSA,                       512, 1024, CKF_HW      |
                                               CKF_SIGN    | CKF_VERIFY },
#endif

/* Begin code contributed by Corrent corp. */
#if !(NODH)
   { CKM_DH_PKCS_DERIVE,            512, 2048, CKF_HW | CKF_DERIVE },
   { CKM_DH_PKCS_KEY_PAIR_GEN,      512, 2048, CKF_HW | CKF_GENERATE_KEY_PAIR },
#endif
/* End code contributed by Corrent corp. */

   { CKM_DES_ECB,                     8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES_CBC,                     8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES_CBC_PAD,                 8,    8, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

#if !(NOCDMF)
   { CKM_CDMF_ECB,                    0,    0, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_CDMF_CBC,                    0,    0, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },
#endif

   { CKM_DES3_ECB,                    24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES3_CBC,                    24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

   { CKM_DES3_CBC_PAD,                24,    24, CKF_HW      |
                                               CKF_ENCRYPT | CKF_DECRYPT |
                                               CKF_WRAP    | CKF_UNWRAP },

#if !(NOSHA1)
   { CKM_SHA_1,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA_1_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA_1_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA256,                       0,    0, CKF_HW | CKF_DIGEST },
   { CKM_SHA256_HMAC,                  0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SHA256_HMAC_GENERAL,          0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

#if !(NOMD2)
   { CKM_MD2,                         0,    0, CKF_HW | CKF_DIGEST },
   { CKM_MD2_HMAC,                    0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_MD2_HMAC_GENERAL,            0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

#if !(NOMD5)
   { CKM_MD5,                         0,    0, CKF_HW | CKF_DIGEST },
   { CKM_MD5_HMAC,                    0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_MD5_HMAC_GENERAL,            0,    0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif

   { CKM_SSL3_PRE_MASTER_KEY_GEN,    48,   48, CKF_HW | CKF_GENERATE },
   { CKM_SSL3_MASTER_KEY_DERIVE,     48,   48, CKF_HW | CKF_DERIVE },
   { CKM_SSL3_KEY_AND_MAC_DERIVE,    48,   48, CKF_HW | CKF_DERIVE },
   { CKM_SSL3_MD5_MAC,              384,  384, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_SSL3_SHA1_MAC,             384,  384, CKF_HW | CKF_SIGN | CKF_VERIFY },

#if !(NOAES)
   { CKM_AES_KEY_GEN,                16,   32, CKF_HW },
   { CKM_AES_ECB,                    16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
   { CKM_AES_CBC,                    16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
   { CKM_AES_MAC,                    16,   32, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_AES_MAC_GENERAL,            16,   32, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_AES_CBC_PAD,                16,   32, CKF_HW      |
   					       CKF_ENCRYPT | CKF_DECRYPT |
   					       CKF_WRAP    | CKF_UNWRAP },
#endif
	
#if !(NORIPE)
   { CKM_RIPEMD128,			0,   0, CKF_HW | CKF_DIGEST },
   { CKM_RIPEMD128_HMAC,		0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD128_HMAC_GENERAL,	0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD160,			0,   0, CKF_HW | CKF_DIGEST },
   { CKM_RIPEMD160_HMAC,		0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
   { CKM_RIPEMD160_HMAC_GENERAL,	0,   0, CKF_HW | CKF_SIGN | CKF_VERIFY },
#endif
   
};

CK_ULONG mech_list_len = (sizeof(mech_list) / sizeof(MECH_LIST_ELEMENT));

CK_RV
token_specific_get_mechanism_list(CK_MECHANISM_TYPE_PTR pMechanismList,
				  CK_ULONG_PTR pulCount)
{
	int rc;
	/* common/mech_list.c */
	rc = ock_generic_get_mechanism_list(pMechanismList, pulCount);
	return rc;
}

CK_RV
token_specific_get_mechanism_info(CK_MECHANISM_TYPE type, 
				  CK_MECHANISM_INFO_PTR pInfo)
{
	int rc;
	/* common/mech_list.c */
	rc = ock_generic_get_mechanism_info(type, pInfo);
	return rc;
}
