# -*- coding: utf-8 -*-

"""
Copyright(C) 2007-2008 INL
Written by Romain Bignon <romain AT inl.fr>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

$Id: frags.py 12192 2008-01-14 16:48:27Z romain $
"""

from sessions import getSession
import SOAPpy
import table
import graph
from nucentral.client import Service
from nevow import rend, loaders, tags, inevow
from nevow.i18n import render as i18nrender
from tools import getBacktrace, Args, args2url, trans
from nevow.i18n import _

def FragmentFactory(context, default_render, name, title, urlbase, new_args, icon='', switch=True, divid=True, save=False):
    """ Function used to create a *Fragment object from '~render' argument in url. """

    render = default_render

    args = getSession(context).fragArgs(name)

    try:
        frag = getSession(context).frags[name]
        function = frag.function
    except:
        function = name
        frag = None

    if isinstance(new_args, SOAPpy.Types.structType):
        new_args = new_args._asdict()

    args.update(new_args)

    if save:
        getSession(context).setFragArgs(name, Args(args).no_filters())

    if args.has_key('~render'):
        render = args['~render']
    try:
        title = args.pop('title')
    except: pass
    try:
        # If we get the full path, we only take the filename.
        # It works if there is only the filename.
        icon = args.pop('img').split('/')[-1]
    except: pass

    if render == 'table':
        frag = table.TableFragment(name, function, title, urlbase, args, icon, switch, frag)
    elif render == 'pie':
        frag = graph.GraphFragment(name, function, title, urlbase, args, icon, switch, frag, pie=True)
    elif render == 'histo':
        frag = graph.GraphFragment(name, function, title, urlbase, args, icon, switch, frag, pie=False)
    elif render == 'csv':
        import csv
        frag = csv.CSVFragment(name, function, title, urlbase, args, icon, switch)
    elif render == 'blank':
        return ''
    else:
        return _('Please provide a correct render!')

    if divid:
        return tags.div(_id=name, _class='frag')[frag]
    else:
        return frag

class PageContent(rend.Fragment):
    """ A page content setted by configuration.
        It loads dynamically all fragments
    """

    docFactory = loaders.stan(tags.invisible(render=tags.directive('content')))

    render_i18n = i18nrender()

    def __init__(self, conf, page):

        self.conf = conf
        self.page = page

        self.urlbase = self.conf.get('Links', 'url')

    def _state_menu(self, ctx, args):

        render = [tags.span[
                       tags.a(href=args2url(args, state=-1))[_('All')]
                   ],
                   tags.span(**{'class': 'drop'})[
                           tags.a(href=args2url(args, state=0))[_('Dropped')]
                   ]
                ]

        if (args.has_key('state') and (isinstance(args['state'], int) or isinstance(args['state'], str) and args['state'].isdigit())
            and int(args['state']) in [1,2,4]):
           render += [tags.span(**{'class': 'open'})[
                            tags.a(href=args2url(args, state=1))[_('Opened')]
                      ],
                      tags.span(**{'class': 'established'})[
                            tags.a(href=args2url(args, state=2))[_('Established')]
                      ]
                 ]
        else:
            render += [tags.span(**{'class': 'open'})[
                            tags.a(href=args2url(args, state=4))[_('Active connection tracking')]
                       ]
                    ]

        render += [tags.span(**{'class': 'close'})[
                       tags.a(href=args2url(args, state=3))[_('Closed')]
                   ]
                ]

        return tags.div(_class='statemenu', style='display: none;')[_('State:'), render]

    def get_title(self, ctx, page, args):

	title = [page.title]

	if page.link:
            try:
                link = page.link % args
                title += [' ', tags.a(href=link, target='_')[tags.img(src='img/note.gif')]]
            except:
                pass

        display = []

        display += [tags.h3(_class='header')[title]]

        if page.showstate and not args.has_key('state'):
            args['state'] = -1

        labels = Args(args).labels_dict(ctx)

        show_state_menu = False
        if labels:
            filters = []
            for key, value in labels.items():
                if filters:
                    filters += [', ']
                if key == 'state':
                    filters += [tags.a(_class='modcrit', id='changestate', href='#')[value]]
                    show_state_menu = True
                else:
                    filters += [tags.a(_class='delcrit', href=args2url(args, **Args(args).remove(key)))[value]]

            display += [tags.div(_class='filters')[[_('Active filter: ')] + filters]]

        if show_state_menu:
            display += [self._state_menu(ctx, args)]
        return display

    def render_content(self, ctx, data):

        if hasattr(self.conf, 'install_error'):
            return ctx.tag[tags.h1[_('A global error has been occured')],
                           tags.p[_('Nulog can\'t fetch data from backend. Please check your configuration file')],
                           tags.p[self.conf.install_error]
                        ]

        try:
            if not self.page:
                page = getSession(ctx).getIndexPage()
            else:
                page = getSession(ctx).pages[self.page]
            frag_list = page.frags
        except:
            print getBacktrace()
            page = None
            frag_list = []

        args = ctx.locate(inevow.IRequest).args
        args = dict((i, args[i][0]) for i in args)

        if not frag_list:
            import infopage
            return infopage.InfoPage(self.urlbase, self.page)

        if page and page.args:
            find_an_arg = 0
            for key, value in page.args.items():
                if not value:
                    if args.has_key(key):
                        find_an_arg = 1
                    elif find_an_arg == 0:
                        find_an_arg = -1
                elif not args.has_key(key):
                    args[key] = value

            if find_an_arg < 0:
                try:
                    page = getSession(ctx).getIndexPage()
                    frag_list = page.frags
                except:
                    page = None
                    frag_list = []

        i = 0
        left  = [FragmentFactory(ctx, 'table', f, None, self.urlbase, args, None, switch=True)
                 for f in frag_list[0]]
        right = [FragmentFactory(ctx, 'table', f, None, self.urlbase, args, None, switch=True)
                 for f in frag_list[1]]

        #if right:
        # We only add "badhosts" if there are two columns.
        left = [tags.div(_class='badhosts')[f] for f in left]
        right = [tags.div(_class='badhosts')[f] for f in right]

        render = []
        data = []
        if page:
            if page.args.has_key('showstate'):
                render += [tags.div(_class='state')[tags.invisible(render=tags.directive('state'))]]
            if page.title:
                title = [self.get_title(ctx, page, args)]
                data += [title]

        if len(left) == 1 and not right:
            data += [tags.div(_class='largecolumn')[left]]
        else:
            data += [tags.div(_class='column', colnum=1)[left]]
            data += [tags.div(_class='column', colnum=2)[right]]

        render = render + [tags.div(_class='data')[data]]

        return ctx.tag[render]

    def render_state(self, context, data):

        return ''

class BaseFragment(rend.Fragment):

    def __init__(self, function, urlbase, args, frag):

        self.function = function
        self.urlbase = urlbase
        self.frag = frag

        if isinstance(args, SOAPpy.Types.structType):
            args = args._asdict()
        self.args = args

    #################
    #    DATA       #
    #################

    def data_table(self, context, data):
        """ This function is called by Nevow when it
            wants request data.
            We call a service.
        """

        function = self.function

        try:
            Args(self.args).check()
            # We call a distant function with NuCentral...
            # "function" and "myargs" are the two arguments.
            # "function" is the table name.
            table = Service.callService("nulog-core", "table", function, self.args)
        except Exception, e:
            print getBacktrace()
            if e.args and not isinstance(e.args[0], str):
                self.error = e.args[0]
            else:
                self.error = ' '.join(e.args)
            return self.error

        # Errors from nucentral are strings.
        if isinstance(table, str):
            print 'BaseFrag.Error: %s' % table
            self.error = table
            return ''

        return table
