/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.dynamic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.helios.jmx.dynamic.AccessorPair;
import org.helios.jmx.dynamic.OperationNotFoundException;
import org.helios.jmx.dynamic.annotations.JMXAttribute;
import org.helios.jmx.dynamic.annotations.JMXManagedObject;
import org.helios.jmx.dynamic.annotations.JMXOperation;
import org.helios.jmx.dynamic.annotations.JMXParameter;
import org.helios.jmx.dynamic.annotations.options.AttributeMutabilityOption;
import org.helios.jmx.dynamic.container.AttributeContainer;
import org.helios.jmx.dynamic.container.OperationContainer;
import org.helios.jmx.dynamic.core.CoreExtensionManagedObject;
import org.helios.jmx.dynamic.core.DynamicMBeanCoreFunctions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectDynamicMBean
implements DynamicMBean,
MBeanRegistration,
Serializable {
    private static final long serialVersionUID = -1077748676265011430L;
    public static final String DEFAULT_DESCRIPTION = "ManagedObjectDynamicMBean";
    protected Map<String, AttributeContainer> attributes = new ConcurrentHashMap<String, AttributeContainer>();
    protected Map<String, OperationContainer> operations = new ConcurrentHashMap<String, OperationContainer>();
    protected List<MBeanNotificationInfo> notifications = Collections.synchronizedList(new ArrayList());
    protected static MBeanConstructorInfo[] constructors = new MBeanConstructorInfo[0];
    protected transient MBeanServer server = null;
    protected ObjectName objectName = null;
    protected String agentId = "";
    protected String mbeanDescription = "ManagedObjectDynamicMBean";
    protected MBeanInfo mbeanInfo = null;
    protected static final Object[] NO_ARGS = new Object[0];
    protected static final Class<?>[] NO_SIG = new Class[0];

    public ManagedObjectDynamicMBean() {
        this.addCoreFunctions();
    }

    public ManagedObjectDynamicMBean(Object ... args) {
        this();
        for (Object o : args) {
            this.reflectObject(o);
        }
        this.updateMBeanInfo();
    }

    public ManagedObjectDynamicMBean(String description, Object ... args) {
        this(args);
        this.mbeanDescription = description;
    }

    public ManagedObjectDynamicMBean(String description) {
        this();
        this.mbeanDescription = description;
    }

    public void updateMBeanInfo() {
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), this.mbeanDescription, this.getAttrInfos(), constructors, this.getOperInfos(), this.getNotificationInfos());
    }

    protected MBeanNotificationInfo[] getNotificationInfos() {
        return this.notifications.toArray(new MBeanNotificationInfo[this.notifications.size()]);
    }

    protected MBeanAttributeInfo[] getAttrInfos() {
        try {
            MBeanAttributeInfo[] arr = new MBeanAttributeInfo[this.attributes.size()];
            ArrayList<AttributeContainer> acs = new ArrayList<AttributeContainer>(this.attributes.values());
            Collections.sort(acs);
            int index = 0;
            for (AttributeContainer ac : acs) {
                arr[index] = ac.getAttributeInfo();
                ++index;
            }
            return arr;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to sort attributes", e);
        }
    }

    protected MBeanOperationInfo[] getCoreOperations() {
        ArrayList list = new ArrayList();
        return list.toArray(new MBeanOperationInfo[list.size()]);
    }

    public void addCoreFunctions() {
        DynamicMBeanCoreFunctions dcf = new DynamicMBeanCoreFunctions();
        this.reflectObject(dcf);
    }

    protected MBeanOperationInfo[] getOperInfos() {
        MBeanOperationInfo[] coreOps = this.getCoreOperations();
        MBeanOperationInfo[] arr = new MBeanOperationInfo[this.operations.size() + coreOps.length];
        int index = 0;
        for (OperationContainer oc : this.operations.values()) {
            arr[index] = oc.getOperInfo();
            ++index;
        }
        MBeanOperationInfo[] arr$ = coreOps;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            MBeanOperationInfo oper;
            arr[index] = oper = arr$[i$];
            ++index;
        }
        return arr;
    }

    public void reflectObject(Object object) {
        long start = System.currentTimeMillis();
        if (object == null) {
            return;
        }
        if (object instanceof CoreExtensionManagedObject) {
            ((CoreExtensionManagedObject)object).setManagedObjectDynamicMBean(this);
        }
        BeanInfo beanInfo = null;
        Class<?> clazz = object.getClass();
        try {
            if (clazz.isAnnotationPresent(JMXManagedObject.class)) {
                this.reflectAnnotatedObjectAttributes(object);
                this.reflectAnnotatedOperations(object);
            } else {
                beanInfo = Introspector.getBeanInfo(clazz);
                this.reflectUnAnnotatedAttributeMethods(object, beanInfo, this.arrayToSet(clazz.getMethods()), false);
                this.reflectUnAnnotatedOperations(object, beanInfo, false);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Failed to introspect object of class [" + clazz.getName() + "]", e);
        }
        this.updateMBeanInfo();
        long elapsed = System.currentTimeMillis() - start;
        ManagedObjectDynamicMBean.log("Reflect Object Elapsed Time:" + elapsed + " ms.");
    }

    protected void reflectAnnotatedObjectAttributes(Object object) {
        if (object == null) {
            return;
        }
        JMXAttribute jmxAttr = null;
        boolean declared = false;
        boolean annotated = false;
        Set<Method> methods = null;
        HashSet<Method> remove = new HashSet<Method>();
        Class<?> clazz = object.getClass();
        BeanInfo beanInfo = null;
        JMXManagedObject jmo = object.getClass().getAnnotation(JMXManagedObject.class);
        declared = jmo.declared();
        annotated = jmo.annotated();
        methods = declared ? this.arrayToSet(clazz.getDeclaredMethods()) : this.arrayToSet(clazz.getMethods());
        if (!annotated) {
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
                this.reflectUnAnnotatedAttributeMethods(object, beanInfo, methods, true);
            }
            catch (IntrospectionException e) {
                throw new RuntimeException("Failed to introspect object of class [" + clazz.getName() + "]", e);
            }
        }
        HashMap<String, AccessorPair> methodMap = new HashMap<String, AccessorPair>();
        AccessorPair ap = null;
        String attrName = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(JMXAttribute.class)) continue;
            jmxAttr = method.getAnnotation(JMXAttribute.class);
            if (!jmxAttr.expose()) {
                remove.add(method);
                continue;
            }
            attrName = jmxAttr.name();
            ap = (AccessorPair)methodMap.get(attrName);
            if (ap == null) {
                ap = new AccessorPair(attrName, object);
                methodMap.put(attrName, ap);
            }
            if (method.getParameterTypes().length == 0) {
                ap.setGetter(method);
                continue;
            }
            ap.setSetter(method);
        }
        methods.removeAll(remove);
        AttributeMutabilityOption getterMutability = null;
        AttributeMutabilityOption setterMutability = null;
        for (AccessorPair pair : methodMap.values()) {
            if (pair.getGetter() != null) {
                getterMutability = pair.getGetter().getAnnotation(JMXAttribute.class).mutability();
            }
            if (pair.getSetter() != null) {
                setterMutability = pair.getSetter().getAnnotation(JMXAttribute.class).mutability();
            }
            if (getterMutability == null) {
                pair.setMutability(setterMutability);
            }
            if (setterMutability == null) {
                pair.setMutability(getterMutability);
            }
            try {
                boolean fi = this.testForFillIn(methods, pair);
                AttributeMutabilityOption tmp = pair.getMutability();
                pair.setMutability(AttributeMutabilityOption.selectOption(getterMutability, setterMutability));
                if (pair.getMutability() == null) {
                    if (!fi) continue;
                    pair.setMutability(tmp);
                    this.attributes.put(pair.getAttributeName(), new AttributeContainer(pair));
                    continue;
                }
                this.attributes.put(pair.getAttributeName(), new AttributeContainer(pair));
            }
            catch (Exception e) {}
        }
        this.updateMBeanInfo();
    }

    protected Set<Method> arrayToSet(Method[] arr) {
        HashSet<Method> set = new HashSet<Method>(arr.length);
        for (Method m : arr) {
            set.add(m);
        }
        return set;
    }

    protected boolean testForFillIn(Set<Method> methods, AccessorPair pair) {
        block3: {
            String methodName;
            block2: {
                methodName = null;
                if (!pair.getMutability().isWritable() || pair.getSetter() != null) break block2;
                methodName = "set" + pair.getGetter().getName().replaceFirst("get", "");
                for (Method m : methods) {
                    if (!methodName.equals(m.getName()) || m.getParameterTypes().length != 1 || !m.getReturnType().equals(Void.TYPE)) continue;
                    pair.setSetter(m);
                    return true;
                }
                break block3;
            }
            if (!pair.getMutability().isReadable() || pair.getGetter() != null) break block3;
            methodName = "get" + pair.getGetter().getName().replaceFirst("set", "");
            for (Method m : methods) {
                if (!methodName.equals(m.getName()) || m.getParameterTypes().length != 0 || m.getReturnType().equals(Void.TYPE)) continue;
                pair.setGetter(m);
                return true;
            }
        }
        return false;
    }

    protected void reflectUnAnnotatedAttributeMethods(Object targetObject, BeanInfo beanInfo, Set<Method> methods, boolean isManagedObject) {
        ManagedObjectDynamicMBean.log("Reflecting UnAnnotatedAttributeMethods from [" + targetObject + "/" + targetObject.getClass().getName() + "]. Available Methods:" + methods.size());
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        Method readMethod = null;
        Method writeMethod = null;
        MBeanAttributeInfo attrInfo = null;
        AttributeContainer attrContainer = null;
        HashSet<Method> altMethods = new HashSet<Method>();
        for (Method objMethods : Object.class.getDeclaredMethods()) {
            altMethods.add(objMethods);
        }
        for (PropertyDescriptor pd : pds) {
            ManagedObjectDynamicMBean.log("\tExamining Attribute:" + pd.getName());
            readMethod = pd.getReadMethod();
            writeMethod = pd.getWriteMethod();
            if (readMethod != null && readMethod.isAnnotationPresent(JMXAttribute.class) && isManagedObject || writeMethod != null && writeMethod.isAnnotationPresent(JMXAttribute.class) && isManagedObject) continue;
            try {
                if (!methods.contains(readMethod) && !methods.contains(writeMethod) || altMethods.contains(readMethod) || altMethods.contains(writeMethod)) continue;
                attrInfo = new MBeanAttributeInfo(pd.getName(), "MBean Attribute", readMethod, writeMethod);
                attrContainer = new AttributeContainer(targetObject, attrInfo, readMethod, writeMethod);
                ManagedObjectDynamicMBean.log("\tAdding " + pd.getName() + " with [" + readMethod + "/" + writeMethod + "]");
                this.attributes.put(pd.getName(), attrContainer);
            }
            catch (javax.management.IntrospectionException e) {
                ManagedObjectDynamicMBean.elog("Hit introspection exception on " + pd.getName() + ":" + e);
            }
        }
        this.updateMBeanInfo();
    }

    protected static void log(Object message) {
    }

    protected static void elog(Object message) {
    }

    protected boolean isMethodIn(Method method, Method[] methods) {
        if (method == null || methods == null || methods.length == 0) {
            return false;
        }
        for (Method m : methods) {
            if (!m.equals(method)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMethodDeclared(Method method, Object object) {
        if (method == null) {
            return false;
        }
        return method.getDeclaringClass().equals(object.getClass());
    }

    protected void reflectUnAnnotatedOperations(Object object, BeanInfo beanInfo, boolean declared) {
        if (object == null) {
            return;
        }
        Set<Object> methods = new HashSet();
        HashSet<Method> attributeMethods = new HashSet<Method>();
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        methods = declared ? this.arrayToSet(object.getClass().getDeclaredMethods()) : this.arrayToSet(object.getClass().getMethods());
        for (PropertyDescriptor pd : propertyDescriptors) {
            if (pd.getReadMethod() != null) {
                attributeMethods.add(pd.getReadMethod());
            }
            if (pd.getWriteMethod() == null) continue;
            attributeMethods.add(pd.getWriteMethod());
        }
        for (Method method : methods) {
            if (attributeMethods.contains(method) || method.isAnnotationPresent(JMXOperation.class) || !declared && !this.isMethodDeclared(method, object)) continue;
            this.operations.put(OperationContainer.hashOperationName(method.getName(), method.getParameterTypes()), new OperationContainer(object, "MBean Operation", method));
        }
    }

    protected void reflectAnnotatedOperations(Object object) throws IntrospectionException {
        if (object == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        JMXManagedObject jmxObj = clazz.getAnnotation(JMXManagedObject.class);
        if (jmxObj == null) {
            return;
        }
        Set<Object> methods = new HashSet();
        MBeanParameterInfo[] pInfos = null;
        MBeanOperationInfo mInfo = null;
        JMXOperation jmxOper = null;
        String operName = null;
        String operDesc = null;
        methods = jmxObj.declared() ? this.arrayToSet(clazz.getDeclaredMethods()) : this.arrayToSet(clazz.getMethods());
        for (Method method : methods) {
            if (!method.isAnnotationPresent(JMXOperation.class) || !(jmxOper = method.getAnnotation(JMXOperation.class)).expose()) continue;
            if (jmxOper.introspectName()) {
                try {
                    operName = clazz.getMethod(jmxOper.name(), NO_SIG).invoke(object, NO_ARGS).toString();
                }
                catch (Exception e) {
                    operName = jmxOper.name();
                }
            } else {
                operName = jmxOper.name();
            }
            if (jmxOper.introspectDescription()) {
                try {
                    operDesc = clazz.getMethod(jmxOper.description(), NO_SIG).invoke(object, NO_ARGS).toString();
                }
                catch (Exception e) {
                    operDesc = jmxOper.description();
                }
            } else {
                operDesc = jmxOper.description();
            }
            pInfos = this.generateParamInfo(method);
            mInfo = new MBeanOperationInfo(operName, operDesc, pInfos, method.getReturnType().getName(), jmxOper.impact());
            this.operations.put(OperationContainer.hashOperationName(operName, method.getParameterTypes()), new OperationContainer(object, mInfo, method, jmxOper.async()));
        }
        if (!jmxObj.annotated()) {
            this.reflectUnAnnotatedOperations(object, Introspector.getBeanInfo(clazz), jmxObj.declared());
        }
    }

    protected MBeanParameterInfo[] generateParamInfo(Method method) {
        MBeanParameterInfo[] pInfos = new MBeanParameterInfo[method.getParameterTypes().length];
        Map<Integer, JMXParameter> paramAnns = this.getJMXParameters(method);
        int index = 0;
        JMXParameter jmxParam = null;
        MBeanParameterInfo pInfo = null;
        for (Class<?> clazz : method.getParameterTypes()) {
            jmxParam = paramAnns.get(index);
            pInfo = jmxParam == null ? new MBeanParameterInfo("p" + index, clazz.getName(), "MBean Operation Parameter") : new MBeanParameterInfo(jmxParam.name(), clazz.getName(), jmxParam.description());
            pInfos[index] = pInfo;
            ++index;
        }
        return pInfos;
    }

    protected Map<Integer, JMXParameter> getJMXParameters(Method method) {
        HashMap<Integer, JMXParameter> params = new HashMap<Integer, JMXParameter>();
        Annotation[][] pAnns = method.getParameterAnnotations();
        int index = 0;
        Annotation[][] arr$ = pAnns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] anns;
            for (Annotation ann : anns = arr$[i$]) {
                if (!(ann instanceof JMXParameter)) continue;
                params.put(index, (JMXParameter)ann);
            }
            ++index;
        }
        return params;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        AttributeContainer ac = this.attributes.get(attribute.getName());
        if (ac == null) {
            throw new AttributeNotFoundException("Attribute Not Found:" + attribute.getName());
        }
        if (ac.isWriteOnce() && ac.isWriten()) {
            throw new InvalidAttributeValueException("The attribute [" + attribute.getName() + "] is WRITE_ONCE and has already been written.");
        }
        ac.setAttributeValue(attribute.getValue());
        if (ac.isWriteOnce() && ac.isWriten()) {
            this.updateMBeanInfo();
        }
    }

    protected String generateAttributeName(Method m) {
        String methodName = m.getName();
        if (methodName.startsWith("get") || methodName.startsWith("set")) {
            return m.getName().substring(3);
        }
        if (methodName.startsWith("is")) {
            return m.getName().substring(2);
        }
        return methodName;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        AttributeContainer ac = this.attributes.get(attribute);
        if (ac == null) {
            throw new AttributeNotFoundException("Attribute " + attribute + " Not Found");
        }
        try {
            return ac.getAttributeValue();
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Failed to Invoke " + ac.getTargetGetterMethod().getName());
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String s : this.attributes.keySet()) {
            try {
                Object o = this.getAttribute(s);
                list.add(new Attribute(s, o));
            }
            catch (Exception e) {}
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        OperationContainer op = this.operations.get(OperationContainer.hashOperationName(actionName, signature));
        if (op == null) {
            throw new OperationNotFoundException(new Exception(), actionName);
        }
        try {
            return op.invokeOperation(params);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Failed to invoke operation [" + actionName + "]");
        }
    }

    protected Object internalInvoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Object ret = null;
        OperationContainer op = this.operations.get(ManagedObjectDynamicMBean.hashOperationName(actionName, signature));
        try {
            ret = op.getTargetMethod().toString().contains(" static ") ? op.getTargetMethod().invoke(null, params) : op.getTargetMethod().invoke(op.getTargetObject(), params);
            return ret;
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception Invoking Operation " + op.getTargetMethod().getName());
        }
    }

    protected static String hashOperationName(String actionName, String[] signature) {
        StringBuilder buff = new StringBuilder(actionName);
        for (String s : signature) {
            buff.append(s);
        }
        return "" + buff.toString().hashCode();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.setAttribute(attr);
                list.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean arg0) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer mbeanServer, ObjectName objectName) throws Exception {
        this.server = mbeanServer;
        this.objectName = objectName;
        return objectName;
    }

    static {
        Constructor<?>[] consts = ManagedObjectDynamicMBean.class.getConstructors();
        constructors = new MBeanConstructorInfo[consts.length];
        for (int i = 0; i < consts.length; ++i) {
            ManagedObjectDynamicMBean.constructors[i] = new MBeanConstructorInfo("Constructor #" + i + 1, consts[i]);
        }
    }
}

