/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Routines {
    private static final String UnitIndentStr = "   ";
    private static final double MATH_LOG_10 = Math.log(10.0);
    private static final double COLOR_FACTOR = 0.85;

    public static void listAllComponents(Component component, int n) {
        if (component == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(UnitIndentStr);
        }
        stringBuffer.append(component.toString());
        System.out.println(stringBuffer.toString());
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Routines.listAllComponents(componentArray[i], n + 1);
            }
        }
    }

    public static void setComponentAndChildrenCursors(Component component, Cursor cursor) {
        if (component == null) {
            return;
        }
        component.setCursor(cursor);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Routines.setComponentAndChildrenCursors(componentArray[i], cursor);
            }
        }
    }

    public static void setShortJComponentSizes(JComponent jComponent, Dimension dimension) {
        Dimension dimension2 = new Dimension(0, dimension.height);
        Dimension dimension3 = new Dimension(Short.MAX_VALUE, dimension.height);
        jComponent.setMinimumSize(dimension2);
        jComponent.setMaximumSize(dimension3);
        jComponent.setPreferredSize(dimension);
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension correctSize(Dimension dimension, Insets insets) {
        if (insets != null) {
            dimension.width += insets.left + insets.right;
            if (dimension.width > Short.MAX_VALUE) {
                dimension.width = Short.MAX_VALUE;
            }
            dimension.height += insets.top + insets.bottom;
            if (dimension.height > Short.MAX_VALUE) {
                dimension.height = Short.MAX_VALUE;
            }
        }
        return dimension;
    }

    public static int getAdjNumOfTextColumns(Component component, int n) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        int n2 = (int)Math.ceil((double)n * (double)fontMetrics.charWidth('1') / (double)fontMetrics.charWidth('m'));
        return n2;
    }

    public static double getTimeRulerIncrement(double d) {
        double d2 = d;
        double d3 = Math.ceil(Math.log(d2) / MATH_LOG_10);
        double d4 = Math.pow(10.0, d3);
        double d5 = d2 / d4;
        double d6 = d5 < 0.1125 ? 0.1 : (d5 < 0.1625 ? 0.125 : (d5 < 0.225 ? 0.2 : (d5 < 0.325 ? 0.25 : (d5 < 0.45 ? 0.4 : (d5 < 0.75 ? 0.5 : 1.0)))));
        return d6 * d4;
    }

    public static double getTimeRulerFirstMark(double d, double d2) {
        double d3 = Math.floor(d / d2);
        return d3 * d2;
    }

    public static Color getSlightBrighterColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 6;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / 0.85), 255), Math.min((int)((double)n2 / 0.85), 255), Math.min((int)((double)n3 / 0.85), 255));
    }

    public static Color getSlightDarkerColor(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.85), 0), Math.max((int)((double)color.getGreen() * 0.85), 0), Math.max((int)((double)color.getBlue() * 0.85), 0));
    }

    public static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && !mouseEvent.isControlDown();
    }

    public static boolean isRightMouseButton(MouseEvent mouseEvent) {
        return SwingUtilities.isRightMouseButton(mouseEvent) || SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown();
    }
}

