// Copyright 2010-2016, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef MOZC_GUI_BASE_SJIS_TO_UCS2_TABLE_H_
#define MOZC_GUI_BASE_SJIS_TO_UCS2_TABLE_H_

const uint16_t kSJISToUCS2Table[] = {
  0x3000,  // { 0x81, 0x40 } "　"
  0x3001,  // { 0x81, 0x41 } "、"
  0x3002,  // { 0x81, 0x42 } "。"
  0xFF0C,  // { 0x81, 0x43 } "，"
  0xFF0E,  // { 0x81, 0x44 } "．"
  0x30FB,  // { 0x81, 0x45 } "・"
  0xFF1A,  // { 0x81, 0x46 } "："
  0xFF1B,  // { 0x81, 0x47 } "；"
  0xFF1F,  // { 0x81, 0x48 } "？"
  0xFF01,  // { 0x81, 0x49 } "！"
  0x309B,  // { 0x81, 0x4A } "゛"
  0x309C,  // { 0x81, 0x4B } "゜"
  0x00B4,  // { 0x81, 0x4C } "´"
  0xFF40,  // { 0x81, 0x4D } "｀"
  0x00A8,  // { 0x81, 0x4E } "¨"
  0xFF3E,  // { 0x81, 0x4F } "＾"
  0xFFE3,  // { 0x81, 0x50 } "￣"
  0xFF3F,  // { 0x81, 0x51 } "＿"
  0x30FD,  // { 0x81, 0x52 } "ヽ"
  0x30FE,  // { 0x81, 0x53 } "ヾ"
  0x309D,  // { 0x81, 0x54 } "ゝ"
  0x309E,  // { 0x81, 0x55 } "ゞ"
  0x3003,  // { 0x81, 0x56 } "〃"
  0x4EDD,  // { 0x81, 0x57 } "仝"
  0x3005,  // { 0x81, 0x58 } "々"
  0x3006,  // { 0x81, 0x59 } "〆"
  0x3007,  // { 0x81, 0x5A } "〇"
  0x30FC,  // { 0x81, 0x5B } "ー"
  0x2015,  // { 0x81, 0x5C } "―"
  0x2010,  // { 0x81, 0x5D } "‐"
  0xFF0F,  // { 0x81, 0x5E } "／"
  0xFF3C,  // { 0x81, 0x5F } "＼"
  0xFF5E,  // { 0x81, 0x60 } "～"
  0x2225,  // { 0x81, 0x61 } "∥"
  0xFF5C,  // { 0x81, 0x62 } "｜"
  0x2026,  // { 0x81, 0x63 } "…"
  0x2025,  // { 0x81, 0x64 } "‥"
  0x2018,  // { 0x81, 0x65 } "‘"
  0x2019,  // { 0x81, 0x66 } "’"
  0x201C,  // { 0x81, 0x67 } "“"
  0x201D,  // { 0x81, 0x68 } "”"
  0xFF08,  // { 0x81, 0x69 } "（"
  0xFF09,  // { 0x81, 0x6A } "）"
  0x3014,  // { 0x81, 0x6B } "〔"
  0x3015,  // { 0x81, 0x6C } "〕"
  0xFF3B,  // { 0x81, 0x6D } "［"
  0xFF3D,  // { 0x81, 0x6E } "］"
  0xFF5B,  // { 0x81, 0x6F } "｛"
  0xFF5D,  // { 0x81, 0x70 } "｝"
  0x3008,  // { 0x81, 0x71 } "〈"
  0x3009,  // { 0x81, 0x72 } "〉"
  0x300A,  // { 0x81, 0x73 } "《"
  0x300B,  // { 0x81, 0x74 } "》"
  0x300C,  // { 0x81, 0x75 } "「"
  0x300D,  // { 0x81, 0x76 } "」"
  0x300E,  // { 0x81, 0x77 } "『"
  0x300F,  // { 0x81, 0x78 } "』"
  0x3010,  // { 0x81, 0x79 } "【"
  0x3011,  // { 0x81, 0x7A } "】"
  0xFF0B,  // { 0x81, 0x7B } "＋"
  0xFF0D,  // { 0x81, 0x7C } "－"
  0x00B1,  // { 0x81, 0x7D } "±"
  0x00D7,  // { 0x81, 0x7E } "×"
  0x00F7,  // { 0x81, 0x80 } "÷"
  0xFF1D,  // { 0x81, 0x81 } "＝"
  0x2260,  // { 0x81, 0x82 } "≠"
  0xFF1C,  // { 0x81, 0x83 } "＜"
  0xFF1E,  // { 0x81, 0x84 } "＞"
  0x2266,  // { 0x81, 0x85 } "≦"
  0x2267,  // { 0x81, 0x86 } "≧"
  0x221E,  // { 0x81, 0x87 } "∞"
  0x2234,  // { 0x81, 0x88 } "∴"
  0x2642,  // { 0x81, 0x89 } "♂"
  0x2640,  // { 0x81, 0x8A } "♀"
  0x00B0,  // { 0x81, 0x8B } "°"
  0x2032,  // { 0x81, 0x8C } "′"
  0x2033,  // { 0x81, 0x8D } "″"
  0x2103,  // { 0x81, 0x8E } "℃"
  0xFFE5,  // { 0x81, 0x8F } "￥"
  0xFF04,  // { 0x81, 0x90 } "＄"
  0xFFE0,  // { 0x81, 0x91 } "￠"
  0xFFE1,  // { 0x81, 0x92 } "￡"
  0xFF05,  // { 0x81, 0x93 } "％"
  0xFF03,  // { 0x81, 0x94 } "＃"
  0xFF06,  // { 0x81, 0x95 } "＆"
  0xFF0A,  // { 0x81, 0x96 } "＊"
  0xFF20,  // { 0x81, 0x97 } "＠"
  0x00A7,  // { 0x81, 0x98 } "§"
  0x2606,  // { 0x81, 0x99 } "☆"
  0x2605,  // { 0x81, 0x9A } "★"
  0x25CB,  // { 0x81, 0x9B } "○"
  0x25CF,  // { 0x81, 0x9C } "●"
  0x25CE,  // { 0x81, 0x9D } "◎"
  0x25C7,  // { 0x81, 0x9E } "◇"
  0x25C6,  // { 0x81, 0x9F } "◆"
  0x25A1,  // { 0x81, 0xA0 } "□"
  0x25A0,  // { 0x81, 0xA1 } "■"
  0x25B3,  // { 0x81, 0xA2 } "△"
  0x25B2,  // { 0x81, 0xA3 } "▲"
  0x25BD,  // { 0x81, 0xA4 } "▽"
  0x25BC,  // { 0x81, 0xA5 } "▼"
  0x203B,  // { 0x81, 0xA6 } "※"
  0x3012,  // { 0x81, 0xA7 } "〒"
  0x2192,  // { 0x81, 0xA8 } "→"
  0x2190,  // { 0x81, 0xA9 } "←"
  0x2191,  // { 0x81, 0xAA } "↑"
  0x2193,  // { 0x81, 0xAB } "↓"
  0x3013,  // { 0x81, 0xAC } "〓"
  0x0000,  // { 0x81, 0xAD }
  0x0000,  // { 0x81, 0xAE }
  0x0000,  // { 0x81, 0xAF }
  0x0000,  // { 0x81, 0xB0 }
  0x0000,  // { 0x81, 0xB1 }
  0x0000,  // { 0x81, 0xB2 }
  0x0000,  // { 0x81, 0xB3 }
  0x0000,  // { 0x81, 0xB4 }
  0x0000,  // { 0x81, 0xB5 }
  0x0000,  // { 0x81, 0xB6 }
  0x0000,  // { 0x81, 0xB7 }
  0x2208,  // { 0x81, 0xB8 } "∈"
  0x220B,  // { 0x81, 0xB9 } "∋"
  0x2286,  // { 0x81, 0xBA } "⊆"
  0x2287,  // { 0x81, 0xBB } "⊇"
  0x2282,  // { 0x81, 0xBC } "⊂"
  0x2283,  // { 0x81, 0xBD } "⊃"
  0x222A,  // { 0x81, 0xBE } "∪"
  0x2229,  // { 0x81, 0xBF } "∩"
  0x0000,  // { 0x81, 0xC0 }
  0x0000,  // { 0x81, 0xC1 }
  0x0000,  // { 0x81, 0xC2 }
  0x0000,  // { 0x81, 0xC3 }
  0x0000,  // { 0x81, 0xC4 }
  0x0000,  // { 0x81, 0xC5 }
  0x0000,  // { 0x81, 0xC6 }
  0x0000,  // { 0x81, 0xC7 }
  0x2227,  // { 0x81, 0xC8 } "∧"
  0x2228,  // { 0x81, 0xC9 } "∨"
  0xFFE2,  // { 0x81, 0xCA } "￢"
  0x21D2,  // { 0x81, 0xCB } "⇒"
  0x21D4,  // { 0x81, 0xCC } "⇔"
  0x2200,  // { 0x81, 0xCD } "∀"
  0x2203,  // { 0x81, 0xCE } "∃"
  0x0000,  // { 0x81, 0xCF }
  0x0000,  // { 0x81, 0xD0 }
  0x0000,  // { 0x81, 0xD1 }
  0x0000,  // { 0x81, 0xD2 }
  0x0000,  // { 0x81, 0xD3 }
  0x0000,  // { 0x81, 0xD4 }
  0x0000,  // { 0x81, 0xD5 }
  0x0000,  // { 0x81, 0xD6 }
  0x0000,  // { 0x81, 0xD7 }
  0x0000,  // { 0x81, 0xD8 }
  0x0000,  // { 0x81, 0xD9 }
  0x2220,  // { 0x81, 0xDA } "∠"
  0x22A5,  // { 0x81, 0xDB } "⊥"
  0x2312,  // { 0x81, 0xDC } "⌒"
  0x2202,  // { 0x81, 0xDD } "∂"
  0x2207,  // { 0x81, 0xDE } "∇"
  0x2261,  // { 0x81, 0xDF } "≡"
  0x2252,  // { 0x81, 0xE0 } "≒"
  0x226A,  // { 0x81, 0xE1 } "≪"
  0x226B,  // { 0x81, 0xE2 } "≫"
  0x221A,  // { 0x81, 0xE3 } "√"
  0x223D,  // { 0x81, 0xE4 } "∽"
  0x221D,  // { 0x81, 0xE5 } "∝"
  0x2235,  // { 0x81, 0xE6 } "∵"
  0x222B,  // { 0x81, 0xE7 } "∫"
  0x222C,  // { 0x81, 0xE8 } "∬"
  0x0000,  // { 0x81, 0xE9 }
  0x0000,  // { 0x81, 0xEA }
  0x0000,  // { 0x81, 0xEB }
  0x0000,  // { 0x81, 0xEC }
  0x0000,  // { 0x81, 0xED }
  0x0000,  // { 0x81, 0xEE }
  0x0000,  // { 0x81, 0xEF }
  0x212B,  // { 0x81, 0xF0 } "Å"
  0x2030,  // { 0x81, 0xF1 } "‰"
  0x266F,  // { 0x81, 0xF2 } "♯"
  0x266D,  // { 0x81, 0xF3 } "♭"
  0x266A,  // { 0x81, 0xF4 } "♪"
  0x2020,  // { 0x81, 0xF5 } "†"
  0x2021,  // { 0x81, 0xF6 } "‡"
  0x00B6,  // { 0x81, 0xF7 } "¶"
  0x0000,  // { 0x81, 0xF8 }
  0x0000,  // { 0x81, 0xF9 }
  0x0000,  // { 0x81, 0xFA }
  0x0000,  // { 0x81, 0xFB }
  0x25EF,  // { 0x81, 0xFC } "◯"
  0x0000,  // { 0x81, 0xFD }
  0x0000,  // { 0x81, 0xFE }
  0x0000,  // { 0x81, 0xFF }
  0x0000,  // { 0x82, 0x40 }
  0x0000,  // { 0x82, 0x41 }
  0x0000,  // { 0x82, 0x42 }
  0x0000,  // { 0x82, 0x43 }
  0x0000,  // { 0x82, 0x44 }
  0x0000,  // { 0x82, 0x45 }
  0x0000,  // { 0x82, 0x46 }
  0x0000,  // { 0x82, 0x47 }
  0x0000,  // { 0x82, 0x48 }
  0x0000,  // { 0x82, 0x49 }
  0x0000,  // { 0x82, 0x4A }
  0x0000,  // { 0x82, 0x4B }
  0x0000,  // { 0x82, 0x4C }
  0x0000,  // { 0x82, 0x4D }
  0x0000,  // { 0x82, 0x4E }
  0xFF10,  // { 0x82, 0x4F } "０"
  0xFF11,  // { 0x82, 0x50 } "１"
  0xFF12,  // { 0x82, 0x51 } "２"
  0xFF13,  // { 0x82, 0x52 } "３"
  0xFF14,  // { 0x82, 0x53 } "４"
  0xFF15,  // { 0x82, 0x54 } "５"
  0xFF16,  // { 0x82, 0x55 } "６"
  0xFF17,  // { 0x82, 0x56 } "７"
  0xFF18,  // { 0x82, 0x57 } "８"
  0xFF19,  // { 0x82, 0x58 } "９"
  0x0000,  // { 0x82, 0x59 }
  0x0000,  // { 0x82, 0x5A }
  0x0000,  // { 0x82, 0x5B }
  0x0000,  // { 0x82, 0x5C }
  0x0000,  // { 0x82, 0x5D }
  0x0000,  // { 0x82, 0x5E }
  0x0000,  // { 0x82, 0x5F }
  0xFF21,  // { 0x82, 0x60 } "Ａ"
  0xFF22,  // { 0x82, 0x61 } "Ｂ"
  0xFF23,  // { 0x82, 0x62 } "Ｃ"
  0xFF24,  // { 0x82, 0x63 } "Ｄ"
  0xFF25,  // { 0x82, 0x64 } "Ｅ"
  0xFF26,  // { 0x82, 0x65 } "Ｆ"
  0xFF27,  // { 0x82, 0x66 } "Ｇ"
  0xFF28,  // { 0x82, 0x67 } "Ｈ"
  0xFF29,  // { 0x82, 0x68 } "Ｉ"
  0xFF2A,  // { 0x82, 0x69 } "Ｊ"
  0xFF2B,  // { 0x82, 0x6A } "Ｋ"
  0xFF2C,  // { 0x82, 0x6B } "Ｌ"
  0xFF2D,  // { 0x82, 0x6C } "Ｍ"
  0xFF2E,  // { 0x82, 0x6D } "Ｎ"
  0xFF2F,  // { 0x82, 0x6E } "Ｏ"
  0xFF30,  // { 0x82, 0x6F } "Ｐ"
  0xFF31,  // { 0x82, 0x70 } "Ｑ"
  0xFF32,  // { 0x82, 0x71 } "Ｒ"
  0xFF33,  // { 0x82, 0x72 } "Ｓ"
  0xFF34,  // { 0x82, 0x73 } "Ｔ"
  0xFF35,  // { 0x82, 0x74 } "Ｕ"
  0xFF36,  // { 0x82, 0x75 } "Ｖ"
  0xFF37,  // { 0x82, 0x76 } "Ｗ"
  0xFF38,  // { 0x82, 0x77 } "Ｘ"
  0xFF39,  // { 0x82, 0x78 } "Ｙ"
  0xFF3A,  // { 0x82, 0x79 } "Ｚ"
  0x0000,  // { 0x82, 0x7A }
  0x0000,  // { 0x82, 0x7B }
  0x0000,  // { 0x82, 0x7C }
  0x0000,  // { 0x82, 0x7D }
  0x0000,  // { 0x82, 0x7E }
  0x0000,  // { 0x82, 0x80 }
  0xFF41,  // { 0x82, 0x81 } "ａ"
  0xFF42,  // { 0x82, 0x82 } "ｂ"
  0xFF43,  // { 0x82, 0x83 } "ｃ"
  0xFF44,  // { 0x82, 0x84 } "ｄ"
  0xFF45,  // { 0x82, 0x85 } "ｅ"
  0xFF46,  // { 0x82, 0x86 } "ｆ"
  0xFF47,  // { 0x82, 0x87 } "ｇ"
  0xFF48,  // { 0x82, 0x88 } "ｈ"
  0xFF49,  // { 0x82, 0x89 } "ｉ"
  0xFF4A,  // { 0x82, 0x8A } "ｊ"
  0xFF4B,  // { 0x82, 0x8B } "ｋ"
  0xFF4C,  // { 0x82, 0x8C } "ｌ"
  0xFF4D,  // { 0x82, 0x8D } "ｍ"
  0xFF4E,  // { 0x82, 0x8E } "ｎ"
  0xFF4F,  // { 0x82, 0x8F } "ｏ"
  0xFF50,  // { 0x82, 0x90 } "ｐ"
  0xFF51,  // { 0x82, 0x91 } "ｑ"
  0xFF52,  // { 0x82, 0x92 } "ｒ"
  0xFF53,  // { 0x82, 0x93 } "ｓ"
  0xFF54,  // { 0x82, 0x94 } "ｔ"
  0xFF55,  // { 0x82, 0x95 } "ｕ"
  0xFF56,  // { 0x82, 0x96 } "ｖ"
  0xFF57,  // { 0x82, 0x97 } "ｗ"
  0xFF58,  // { 0x82, 0x98 } "ｘ"
  0xFF59,  // { 0x82, 0x99 } "ｙ"
  0xFF5A,  // { 0x82, 0x9A } "ｚ"
  0x0000,  // { 0x82, 0x9B }
  0x0000,  // { 0x82, 0x9C }
  0x0000,  // { 0x82, 0x9D }
  0x0000,  // { 0x82, 0x9E }
  0x3041,  // { 0x82, 0x9F } "ぁ"
  0x3042,  // { 0x82, 0xA0 } "あ"
  0x3043,  // { 0x82, 0xA1 } "ぃ"
  0x3044,  // { 0x82, 0xA2 } "い"
  0x3045,  // { 0x82, 0xA3 } "ぅ"
  0x3046,  // { 0x82, 0xA4 } "う"
  0x3047,  // { 0x82, 0xA5 } "ぇ"
  0x3048,  // { 0x82, 0xA6 } "え"
  0x3049,  // { 0x82, 0xA7 } "ぉ"
  0x304A,  // { 0x82, 0xA8 } "お"
  0x304B,  // { 0x82, 0xA9 } "か"
  0x304C,  // { 0x82, 0xAA } "が"
  0x304D,  // { 0x82, 0xAB } "き"
  0x304E,  // { 0x82, 0xAC } "ぎ"
  0x304F,  // { 0x82, 0xAD } "く"
  0x3050,  // { 0x82, 0xAE } "ぐ"
  0x3051,  // { 0x82, 0xAF } "け"
  0x3052,  // { 0x82, 0xB0 } "げ"
  0x3053,  // { 0x82, 0xB1 } "こ"
  0x3054,  // { 0x82, 0xB2 } "ご"
  0x3055,  // { 0x82, 0xB3 } "さ"
  0x3056,  // { 0x82, 0xB4 } "ざ"
  0x3057,  // { 0x82, 0xB5 } "し"
  0x3058,  // { 0x82, 0xB6 } "じ"
  0x3059,  // { 0x82, 0xB7 } "す"
  0x305A,  // { 0x82, 0xB8 } "ず"
  0x305B,  // { 0x82, 0xB9 } "せ"
  0x305C,  // { 0x82, 0xBA } "ぜ"
  0x305D,  // { 0x82, 0xBB } "そ"
  0x305E,  // { 0x82, 0xBC } "ぞ"
  0x305F,  // { 0x82, 0xBD } "た"
  0x3060,  // { 0x82, 0xBE } "だ"
  0x3061,  // { 0x82, 0xBF } "ち"
  0x3062,  // { 0x82, 0xC0 } "ぢ"
  0x3063,  // { 0x82, 0xC1 } "っ"
  0x3064,  // { 0x82, 0xC2 } "つ"
  0x3065,  // { 0x82, 0xC3 } "づ"
  0x3066,  // { 0x82, 0xC4 } "て"
  0x3067,  // { 0x82, 0xC5 } "で"
  0x3068,  // { 0x82, 0xC6 } "と"
  0x3069,  // { 0x82, 0xC7 } "ど"
  0x306A,  // { 0x82, 0xC8 } "な"
  0x306B,  // { 0x82, 0xC9 } "に"
  0x306C,  // { 0x82, 0xCA } "ぬ"
  0x306D,  // { 0x82, 0xCB } "ね"
  0x306E,  // { 0x82, 0xCC } "の"
  0x306F,  // { 0x82, 0xCD } "は"
  0x3070,  // { 0x82, 0xCE } "ば"
  0x3071,  // { 0x82, 0xCF } "ぱ"
  0x3072,  // { 0x82, 0xD0 } "ひ"
  0x3073,  // { 0x82, 0xD1 } "び"
  0x3074,  // { 0x82, 0xD2 } "ぴ"
  0x3075,  // { 0x82, 0xD3 } "ふ"
  0x3076,  // { 0x82, 0xD4 } "ぶ"
  0x3077,  // { 0x82, 0xD5 } "ぷ"
  0x3078,  // { 0x82, 0xD6 } "へ"
  0x3079,  // { 0x82, 0xD7 } "べ"
  0x307A,  // { 0x82, 0xD8 } "ぺ"
  0x307B,  // { 0x82, 0xD9 } "ほ"
  0x307C,  // { 0x82, 0xDA } "ぼ"
  0x307D,  // { 0x82, 0xDB } "ぽ"
  0x307E,  // { 0x82, 0xDC } "ま"
  0x307F,  // { 0x82, 0xDD } "み"
  0x3080,  // { 0x82, 0xDE } "む"
  0x3081,  // { 0x82, 0xDF } "め"
  0x3082,  // { 0x82, 0xE0 } "も"
  0x3083,  // { 0x82, 0xE1 } "ゃ"
  0x3084,  // { 0x82, 0xE2 } "や"
  0x3085,  // { 0x82, 0xE3 } "ゅ"
  0x3086,  // { 0x82, 0xE4 } "ゆ"
  0x3087,  // { 0x82, 0xE5 } "ょ"
  0x3088,  // { 0x82, 0xE6 } "よ"
  0x3089,  // { 0x82, 0xE7 } "ら"
  0x308A,  // { 0x82, 0xE8 } "り"
  0x308B,  // { 0x82, 0xE9 } "る"
  0x308C,  // { 0x82, 0xEA } "れ"
  0x308D,  // { 0x82, 0xEB } "ろ"
  0x308E,  // { 0x82, 0xEC } "ゎ"
  0x308F,  // { 0x82, 0xED } "わ"
  0x3090,  // { 0x82, 0xEE } "ゐ"
  0x3091,  // { 0x82, 0xEF } "ゑ"
  0x3092,  // { 0x82, 0xF0 } "を"
  0x3093,  // { 0x82, 0xF1 } "ん"
  0x0000,  // { 0x82, 0xF2 }
  0x0000,  // { 0x82, 0xF3 }
  0x0000,  // { 0x82, 0xF4 }
  0x0000,  // { 0x82, 0xF5 }
  0x0000,  // { 0x82, 0xF6 }
  0x0000,  // { 0x82, 0xF7 }
  0x0000,  // { 0x82, 0xF8 }
  0x0000,  // { 0x82, 0xF9 }
  0x0000,  // { 0x82, 0xFA }
  0x0000,  // { 0x82, 0xFB }
  0x0000,  // { 0x82, 0xFC }
  0x0000,  // { 0x82, 0xFD }
  0x0000,  // { 0x82, 0xFE }
  0x0000,  // { 0x82, 0xFF }
  0x30A1,  // { 0x83, 0x40 } "ァ"
  0x30A2,  // { 0x83, 0x41 } "ア"
  0x30A3,  // { 0x83, 0x42 } "ィ"
  0x30A4,  // { 0x83, 0x43 } "イ"
  0x30A5,  // { 0x83, 0x44 } "ゥ"
  0x30A6,  // { 0x83, 0x45 } "ウ"
  0x30A7,  // { 0x83, 0x46 } "ェ"
  0x30A8,  // { 0x83, 0x47 } "エ"
  0x30A9,  // { 0x83, 0x48 } "ォ"
  0x30AA,  // { 0x83, 0x49 } "オ"
  0x30AB,  // { 0x83, 0x4A } "カ"
  0x30AC,  // { 0x83, 0x4B } "ガ"
  0x30AD,  // { 0x83, 0x4C } "キ"
  0x30AE,  // { 0x83, 0x4D } "ギ"
  0x30AF,  // { 0x83, 0x4E } "ク"
  0x30B0,  // { 0x83, 0x4F } "グ"
  0x30B1,  // { 0x83, 0x50 } "ケ"
  0x30B2,  // { 0x83, 0x51 } "ゲ"
  0x30B3,  // { 0x83, 0x52 } "コ"
  0x30B4,  // { 0x83, 0x53 } "ゴ"
  0x30B5,  // { 0x83, 0x54 } "サ"
  0x30B6,  // { 0x83, 0x55 } "ザ"
  0x30B7,  // { 0x83, 0x56 } "シ"
  0x30B8,  // { 0x83, 0x57 } "ジ"
  0x30B9,  // { 0x83, 0x58 } "ス"
  0x30BA,  // { 0x83, 0x59 } "ズ"
  0x30BB,  // { 0x83, 0x5A } "セ"
  0x30BC,  // { 0x83, 0x5B } "ゼ"
  0x30BD,  // { 0x83, 0x5C } "ソ"
  0x30BE,  // { 0x83, 0x5D } "ゾ"
  0x30BF,  // { 0x83, 0x5E } "タ"
  0x30C0,  // { 0x83, 0x5F } "ダ"
  0x30C1,  // { 0x83, 0x60 } "チ"
  0x30C2,  // { 0x83, 0x61 } "ヂ"
  0x30C3,  // { 0x83, 0x62 } "ッ"
  0x30C4,  // { 0x83, 0x63 } "ツ"
  0x30C5,  // { 0x83, 0x64 } "ヅ"
  0x30C6,  // { 0x83, 0x65 } "テ"
  0x30C7,  // { 0x83, 0x66 } "デ"
  0x30C8,  // { 0x83, 0x67 } "ト"
  0x30C9,  // { 0x83, 0x68 } "ド"
  0x30CA,  // { 0x83, 0x69 } "ナ"
  0x30CB,  // { 0x83, 0x6A } "ニ"
  0x30CC,  // { 0x83, 0x6B } "ヌ"
  0x30CD,  // { 0x83, 0x6C } "ネ"
  0x30CE,  // { 0x83, 0x6D } "ノ"
  0x30CF,  // { 0x83, 0x6E } "ハ"
  0x30D0,  // { 0x83, 0x6F } "バ"
  0x30D1,  // { 0x83, 0x70 } "パ"
  0x30D2,  // { 0x83, 0x71 } "ヒ"
  0x30D3,  // { 0x83, 0x72 } "ビ"
  0x30D4,  // { 0x83, 0x73 } "ピ"
  0x30D5,  // { 0x83, 0x74 } "フ"
  0x30D6,  // { 0x83, 0x75 } "ブ"
  0x30D7,  // { 0x83, 0x76 } "プ"
  0x30D8,  // { 0x83, 0x77 } "ヘ"
  0x30D9,  // { 0x83, 0x78 } "ベ"
  0x30DA,  // { 0x83, 0x79 } "ペ"
  0x30DB,  // { 0x83, 0x7A } "ホ"
  0x30DC,  // { 0x83, 0x7B } "ボ"
  0x30DD,  // { 0x83, 0x7C } "ポ"
  0x30DE,  // { 0x83, 0x7D } "マ"
  0x30DF,  // { 0x83, 0x7E } "ミ"
  0x30E0,  // { 0x83, 0x80 } "ム"
  0x30E1,  // { 0x83, 0x81 } "メ"
  0x30E2,  // { 0x83, 0x82 } "モ"
  0x30E3,  // { 0x83, 0x83 } "ャ"
  0x30E4,  // { 0x83, 0x84 } "ヤ"
  0x30E5,  // { 0x83, 0x85 } "ュ"
  0x30E6,  // { 0x83, 0x86 } "ユ"
  0x30E7,  // { 0x83, 0x87 } "ョ"
  0x30E8,  // { 0x83, 0x88 } "ヨ"
  0x30E9,  // { 0x83, 0x89 } "ラ"
  0x30EA,  // { 0x83, 0x8A } "リ"
  0x30EB,  // { 0x83, 0x8B } "ル"
  0x30EC,  // { 0x83, 0x8C } "レ"
  0x30ED,  // { 0x83, 0x8D } "ロ"
  0x30EE,  // { 0x83, 0x8E } "ヮ"
  0x30EF,  // { 0x83, 0x8F } "ワ"
  0x30F0,  // { 0x83, 0x90 } "ヰ"
  0x30F1,  // { 0x83, 0x91 } "ヱ"
  0x30F2,  // { 0x83, 0x92 } "ヲ"
  0x30F3,  // { 0x83, 0x93 } "ン"
  0x30F4,  // { 0x83, 0x94 } "ヴ"
  0x30F5,  // { 0x83, 0x95 } "ヵ"
  0x30F6,  // { 0x83, 0x96 } "ヶ"
  0x0000,  // { 0x83, 0x97 }
  0x0000,  // { 0x83, 0x98 }
  0x0000,  // { 0x83, 0x99 }
  0x0000,  // { 0x83, 0x9A }
  0x0000,  // { 0x83, 0x9B }
  0x0000,  // { 0x83, 0x9C }
  0x0000,  // { 0x83, 0x9D }
  0x0000,  // { 0x83, 0x9E }
  0x0391,  // { 0x83, 0x9F } "Α"
  0x0392,  // { 0x83, 0xA0 } "Β"
  0x0393,  // { 0x83, 0xA1 } "Γ"
  0x0394,  // { 0x83, 0xA2 } "Δ"
  0x0395,  // { 0x83, 0xA3 } "Ε"
  0x0396,  // { 0x83, 0xA4 } "Ζ"
  0x0397,  // { 0x83, 0xA5 } "Η"
  0x0398,  // { 0x83, 0xA6 } "Θ"
  0x0399,  // { 0x83, 0xA7 } "Ι"
  0x039A,  // { 0x83, 0xA8 } "Κ"
  0x039B,  // { 0x83, 0xA9 } "Λ"
  0x039C,  // { 0x83, 0xAA } "Μ"
  0x039D,  // { 0x83, 0xAB } "Ν"
  0x039E,  // { 0x83, 0xAC } "Ξ"
  0x039F,  // { 0x83, 0xAD } "Ο"
  0x03A0,  // { 0x83, 0xAE } "Π"
  0x03A1,  // { 0x83, 0xAF } "Ρ"
  0x03A3,  // { 0x83, 0xB0 } "Σ"
  0x03A4,  // { 0x83, 0xB1 } "Τ"
  0x03A5,  // { 0x83, 0xB2 } "Υ"
  0x03A6,  // { 0x83, 0xB3 } "Φ"
  0x03A7,  // { 0x83, 0xB4 } "Χ"
  0x03A8,  // { 0x83, 0xB5 } "Ψ"
  0x03A9,  // { 0x83, 0xB6 } "Ω"
  0x0000,  // { 0x83, 0xB7 }
  0x0000,  // { 0x83, 0xB8 }
  0x0000,  // { 0x83, 0xB9 }
  0x0000,  // { 0x83, 0xBA }
  0x0000,  // { 0x83, 0xBB }
  0x0000,  // { 0x83, 0xBC }
  0x0000,  // { 0x83, 0xBD }
  0x0000,  // { 0x83, 0xBE }
  0x03B1,  // { 0x83, 0xBF } "α"
  0x03B2,  // { 0x83, 0xC0 } "β"
  0x03B3,  // { 0x83, 0xC1 } "γ"
  0x03B4,  // { 0x83, 0xC2 } "δ"
  0x03B5,  // { 0x83, 0xC3 } "ε"
  0x03B6,  // { 0x83, 0xC4 } "ζ"
  0x03B7,  // { 0x83, 0xC5 } "η"
  0x03B8,  // { 0x83, 0xC6 } "θ"
  0x03B9,  // { 0x83, 0xC7 } "ι"
  0x03BA,  // { 0x83, 0xC8 } "κ"
  0x03BB,  // { 0x83, 0xC9 } "λ"
  0x03BC,  // { 0x83, 0xCA } "μ"
  0x03BD,  // { 0x83, 0xCB } "ν"
  0x03BE,  // { 0x83, 0xCC } "ξ"
  0x03BF,  // { 0x83, 0xCD } "ο"
  0x03C0,  // { 0x83, 0xCE } "π"
  0x03C1,  // { 0x83, 0xCF } "ρ"
  0x03C3,  // { 0x83, 0xD0 } "σ"
  0x03C4,  // { 0x83, 0xD1 } "τ"
  0x03C5,  // { 0x83, 0xD2 } "υ"
  0x03C6,  // { 0x83, 0xD3 } "φ"
  0x03C7,  // { 0x83, 0xD4 } "χ"
  0x03C8,  // { 0x83, 0xD5 } "ψ"
  0x03C9,  // { 0x83, 0xD6 } "ω"
  0x0000,  // { 0x83, 0xD7 }
  0x0000,  // { 0x83, 0xD8 }
  0x0000,  // { 0x83, 0xD9 }
  0x0000,  // { 0x83, 0xDA }
  0x0000,  // { 0x83, 0xDB }
  0x0000,  // { 0x83, 0xDC }
  0x0000,  // { 0x83, 0xDD }
  0x0000,  // { 0x83, 0xDE }
  0x0000,  // { 0x83, 0xDF }
  0x0000,  // { 0x83, 0xE0 }
  0x0000,  // { 0x83, 0xE1 }
  0x0000,  // { 0x83, 0xE2 }
  0x0000,  // { 0x83, 0xE3 }
  0x0000,  // { 0x83, 0xE4 }
  0x0000,  // { 0x83, 0xE5 }
  0x0000,  // { 0x83, 0xE6 }
  0x0000,  // { 0x83, 0xE7 }
  0x0000,  // { 0x83, 0xE8 }
  0x0000,  // { 0x83, 0xE9 }
  0x0000,  // { 0x83, 0xEA }
  0x0000,  // { 0x83, 0xEB }
  0x0000,  // { 0x83, 0xEC }
  0x0000,  // { 0x83, 0xED }
  0x0000,  // { 0x83, 0xEE }
  0x0000,  // { 0x83, 0xEF }
  0x0000,  // { 0x83, 0xF0 }
  0x0000,  // { 0x83, 0xF1 }
  0x0000,  // { 0x83, 0xF2 }
  0x0000,  // { 0x83, 0xF3 }
  0x0000,  // { 0x83, 0xF4 }
  0x0000,  // { 0x83, 0xF5 }
  0x0000,  // { 0x83, 0xF6 }
  0x0000,  // { 0x83, 0xF7 }
  0x0000,  // { 0x83, 0xF8 }
  0x0000,  // { 0x83, 0xF9 }
  0x0000,  // { 0x83, 0xFA }
  0x0000,  // { 0x83, 0xFB }
  0x0000,  // { 0x83, 0xFC }
  0x0000,  // { 0x83, 0xFD }
  0x0000,  // { 0x83, 0xFE }
  0x0000,  // { 0x83, 0xFF }
  0x0410,  // { 0x84, 0x40 } "А"
  0x0411,  // { 0x84, 0x41 } "Б"
  0x0412,  // { 0x84, 0x42 } "В"
  0x0413,  // { 0x84, 0x43 } "Г"
  0x0414,  // { 0x84, 0x44 } "Д"
  0x0415,  // { 0x84, 0x45 } "Е"
  0x0401,  // { 0x84, 0x46 } "Ё"
  0x0416,  // { 0x84, 0x47 } "Ж"
  0x0417,  // { 0x84, 0x48 } "З"
  0x0418,  // { 0x84, 0x49 } "И"
  0x0419,  // { 0x84, 0x4A } "Й"
  0x041A,  // { 0x84, 0x4B } "К"
  0x041B,  // { 0x84, 0x4C } "Л"
  0x041C,  // { 0x84, 0x4D } "М"
  0x041D,  // { 0x84, 0x4E } "Н"
  0x041E,  // { 0x84, 0x4F } "О"
  0x041F,  // { 0x84, 0x50 } "П"
  0x0420,  // { 0x84, 0x51 } "Р"
  0x0421,  // { 0x84, 0x52 } "С"
  0x0422,  // { 0x84, 0x53 } "Т"
  0x0423,  // { 0x84, 0x54 } "У"
  0x0424,  // { 0x84, 0x55 } "Ф"
  0x0425,  // { 0x84, 0x56 } "Х"
  0x0426,  // { 0x84, 0x57 } "Ц"
  0x0427,  // { 0x84, 0x58 } "Ч"
  0x0428,  // { 0x84, 0x59 } "Ш"
  0x0429,  // { 0x84, 0x5A } "Щ"
  0x042A,  // { 0x84, 0x5B } "Ъ"
  0x042B,  // { 0x84, 0x5C } "Ы"
  0x042C,  // { 0x84, 0x5D } "Ь"
  0x042D,  // { 0x84, 0x5E } "Э"
  0x042E,  // { 0x84, 0x5F } "Ю"
  0x042F,  // { 0x84, 0x60 } "Я"
  0x0000,  // { 0x84, 0x61 }
  0x0000,  // { 0x84, 0x62 }
  0x0000,  // { 0x84, 0x63 }
  0x0000,  // { 0x84, 0x64 }
  0x0000,  // { 0x84, 0x65 }
  0x0000,  // { 0x84, 0x66 }
  0x0000,  // { 0x84, 0x67 }
  0x0000,  // { 0x84, 0x68 }
  0x0000,  // { 0x84, 0x69 }
  0x0000,  // { 0x84, 0x6A }
  0x0000,  // { 0x84, 0x6B }
  0x0000,  // { 0x84, 0x6C }
  0x0000,  // { 0x84, 0x6D }
  0x0000,  // { 0x84, 0x6E }
  0x0000,  // { 0x84, 0x6F }
  0x0430,  // { 0x84, 0x70 } "а"
  0x0431,  // { 0x84, 0x71 } "б"
  0x0432,  // { 0x84, 0x72 } "в"
  0x0433,  // { 0x84, 0x73 } "г"
  0x0434,  // { 0x84, 0x74 } "д"
  0x0435,  // { 0x84, 0x75 } "е"
  0x0451,  // { 0x84, 0x76 } "ё"
  0x0436,  // { 0x84, 0x77 } "ж"
  0x0437,  // { 0x84, 0x78 } "з"
  0x0438,  // { 0x84, 0x79 } "и"
  0x0439,  // { 0x84, 0x7A } "й"
  0x043A,  // { 0x84, 0x7B } "к"
  0x043B,  // { 0x84, 0x7C } "л"
  0x043C,  // { 0x84, 0x7D } "м"
  0x043D,  // { 0x84, 0x7E } "н"
  0x043E,  // { 0x84, 0x80 } "о"
  0x043F,  // { 0x84, 0x81 } "п"
  0x0440,  // { 0x84, 0x82 } "р"
  0x0441,  // { 0x84, 0x83 } "с"
  0x0442,  // { 0x84, 0x84 } "т"
  0x0443,  // { 0x84, 0x85 } "у"
  0x0444,  // { 0x84, 0x86 } "ф"
  0x0445,  // { 0x84, 0x87 } "х"
  0x0446,  // { 0x84, 0x88 } "ц"
  0x0447,  // { 0x84, 0x89 } "ч"
  0x0448,  // { 0x84, 0x8A } "ш"
  0x0449,  // { 0x84, 0x8B } "щ"
  0x044A,  // { 0x84, 0x8C } "ъ"
  0x044B,  // { 0x84, 0x8D } "ы"
  0x044C,  // { 0x84, 0x8E } "ь"
  0x044D,  // { 0x84, 0x8F } "э"
  0x044E,  // { 0x84, 0x90 } "ю"
  0x044F,  // { 0x84, 0x91 } "я"
  0x0000,  // { 0x84, 0x92 }
  0x0000,  // { 0x84, 0x93 }
  0x0000,  // { 0x84, 0x94 }
  0x0000,  // { 0x84, 0x95 }
  0x0000,  // { 0x84, 0x96 }
  0x0000,  // { 0x84, 0x97 }
  0x0000,  // { 0x84, 0x98 }
  0x0000,  // { 0x84, 0x99 }
  0x0000,  // { 0x84, 0x9A }
  0x0000,  // { 0x84, 0x9B }
  0x0000,  // { 0x84, 0x9C }
  0x0000,  // { 0x84, 0x9D }
  0x0000,  // { 0x84, 0x9E }
  0x2500,  // { 0x84, 0x9F } "─"
  0x2502,  // { 0x84, 0xA0 } "│"
  0x250C,  // { 0x84, 0xA1 } "┌"
  0x2510,  // { 0x84, 0xA2 } "┐"
  0x2518,  // { 0x84, 0xA3 } "┘"
  0x2514,  // { 0x84, 0xA4 } "└"
  0x251C,  // { 0x84, 0xA5 } "├"
  0x252C,  // { 0x84, 0xA6 } "┬"
  0x2524,  // { 0x84, 0xA7 } "┤"
  0x2534,  // { 0x84, 0xA8 } "┴"
  0x253C,  // { 0x84, 0xA9 } "┼"
  0x2501,  // { 0x84, 0xAA } "━"
  0x2503,  // { 0x84, 0xAB } "┃"
  0x250F,  // { 0x84, 0xAC } "┏"
  0x2513,  // { 0x84, 0xAD } "┓"
  0x251B,  // { 0x84, 0xAE } "┛"
  0x2517,  // { 0x84, 0xAF } "┗"
  0x2523,  // { 0x84, 0xB0 } "┣"
  0x2533,  // { 0x84, 0xB1 } "┳"
  0x252B,  // { 0x84, 0xB2 } "┫"
  0x253B,  // { 0x84, 0xB3 } "┻"
  0x254B,  // { 0x84, 0xB4 } "╋"
  0x2520,  // { 0x84, 0xB5 } "┠"
  0x252F,  // { 0x84, 0xB6 } "┯"
  0x2528,  // { 0x84, 0xB7 } "┨"
  0x2537,  // { 0x84, 0xB8 } "┷"
  0x253F,  // { 0x84, 0xB9 } "┿"
  0x251D,  // { 0x84, 0xBA } "┝"
  0x2530,  // { 0x84, 0xBB } "┰"
  0x2525,  // { 0x84, 0xBC } "┥"
  0x2538,  // { 0x84, 0xBD } "┸"
  0x2542,  // { 0x84, 0xBE } "╂"
  0x0000,  // { 0x84, 0xBF }
  0x0000,  // { 0x84, 0xC0 }
  0x0000,  // { 0x84, 0xC1 }
  0x0000,  // { 0x84, 0xC2 }
  0x0000,  // { 0x84, 0xC3 }
  0x0000,  // { 0x84, 0xC4 }
  0x0000,  // { 0x84, 0xC5 }
  0x0000,  // { 0x84, 0xC6 }
  0x0000,  // { 0x84, 0xC7 }
  0x0000,  // { 0x84, 0xC8 }
  0x0000,  // { 0x84, 0xC9 }
  0x0000,  // { 0x84, 0xCA }
  0x0000,  // { 0x84, 0xCB }
  0x0000,  // { 0x84, 0xCC }
  0x0000,  // { 0x84, 0xCD }
  0x0000,  // { 0x84, 0xCE }
  0x0000,  // { 0x84, 0xCF }
  0x0000,  // { 0x84, 0xD0 }
  0x0000,  // { 0x84, 0xD1 }
  0x0000,  // { 0x84, 0xD2 }
  0x0000,  // { 0x84, 0xD3 }
  0x0000,  // { 0x84, 0xD4 }
  0x0000,  // { 0x84, 0xD5 }
  0x0000,  // { 0x84, 0xD6 }
  0x0000,  // { 0x84, 0xD7 }
  0x0000,  // { 0x84, 0xD8 }
  0x0000,  // { 0x84, 0xD9 }
  0x0000,  // { 0x84, 0xDA }
  0x0000,  // { 0x84, 0xDB }
  0x0000,  // { 0x84, 0xDC }
  0x0000,  // { 0x84, 0xDD }
  0x0000,  // { 0x84, 0xDE }
  0x0000,  // { 0x84, 0xDF }
  0x0000,  // { 0x84, 0xE0 }
  0x0000,  // { 0x84, 0xE1 }
  0x0000,  // { 0x84, 0xE2 }
  0x0000,  // { 0x84, 0xE3 }
  0x0000,  // { 0x84, 0xE4 }
  0x0000,  // { 0x84, 0xE5 }
  0x0000,  // { 0x84, 0xE6 }
  0x0000,  // { 0x84, 0xE7 }
  0x0000,  // { 0x84, 0xE8 }
  0x0000,  // { 0x84, 0xE9 }
  0x0000,  // { 0x84, 0xEA }
  0x0000,  // { 0x84, 0xEB }
  0x0000,  // { 0x84, 0xEC }
  0x0000,  // { 0x84, 0xED }
  0x0000,  // { 0x84, 0xEE }
  0x0000,  // { 0x84, 0xEF }
  0x0000,  // { 0x84, 0xF0 }
  0x0000,  // { 0x84, 0xF1 }
  0x0000,  // { 0x84, 0xF2 }
  0x0000,  // { 0x84, 0xF3 }
  0x0000,  // { 0x84, 0xF4 }
  0x0000,  // { 0x84, 0xF5 }
  0x0000,  // { 0x84, 0xF6 }
  0x0000,  // { 0x84, 0xF7 }
  0x0000,  // { 0x84, 0xF8 }
  0x0000,  // { 0x84, 0xF9 }
  0x0000,  // { 0x84, 0xFA }
  0x0000,  // { 0x84, 0xFB }
  0x0000,  // { 0x84, 0xFC }
  0x0000,  // { 0x84, 0xFD }
  0x0000,  // { 0x84, 0xFE }
  0x0000,  // { 0x84, 0xFF }
  0x0000,  // { 0x85, 0x40 }
  0x0000,  // { 0x85, 0x41 }
  0x0000,  // { 0x85, 0x42 }
  0x0000,  // { 0x85, 0x43 }
  0x0000,  // { 0x85, 0x44 }
  0x0000,  // { 0x85, 0x45 }
  0x0000,  // { 0x85, 0x46 }
  0x0000,  // { 0x85, 0x47 }
  0x0000,  // { 0x85, 0x48 }
  0x0000,  // { 0x85, 0x49 }
  0x0000,  // { 0x85, 0x4A }
  0x0000,  // { 0x85, 0x4B }
  0x0000,  // { 0x85, 0x4C }
  0x0000,  // { 0x85, 0x4D }
  0x0000,  // { 0x85, 0x4E }
  0x0000,  // { 0x85, 0x4F }
  0x0000,  // { 0x85, 0x50 }
  0x0000,  // { 0x85, 0x51 }
  0x0000,  // { 0x85, 0x52 }
  0x0000,  // { 0x85, 0x53 }
  0x0000,  // { 0x85, 0x54 }
  0x0000,  // { 0x85, 0x55 }
  0x0000,  // { 0x85, 0x56 }
  0x0000,  // { 0x85, 0x57 }
  0x0000,  // { 0x85, 0x58 }
  0x0000,  // { 0x85, 0x59 }
  0x0000,  // { 0x85, 0x5A }
  0x0000,  // { 0x85, 0x5B }
  0x0000,  // { 0x85, 0x5C }
  0x0000,  // { 0x85, 0x5D }
  0x0000,  // { 0x85, 0x5E }
  0x0000,  // { 0x85, 0x5F }
  0x0000,  // { 0x85, 0x60 }
  0x0000,  // { 0x85, 0x61 }
  0x0000,  // { 0x85, 0x62 }
  0x0000,  // { 0x85, 0x63 }
  0x0000,  // { 0x85, 0x64 }
  0x0000,  // { 0x85, 0x65 }
  0x0000,  // { 0x85, 0x66 }
  0x0000,  // { 0x85, 0x67 }
  0x0000,  // { 0x85, 0x68 }
  0x0000,  // { 0x85, 0x69 }
  0x0000,  // { 0x85, 0x6A }
  0x0000,  // { 0x85, 0x6B }
  0x0000,  // { 0x85, 0x6C }
  0x0000,  // { 0x85, 0x6D }
  0x0000,  // { 0x85, 0x6E }
  0x0000,  // { 0x85, 0x6F }
  0x0000,  // { 0x85, 0x70 }
  0x0000,  // { 0x85, 0x71 }
  0x0000,  // { 0x85, 0x72 }
  0x0000,  // { 0x85, 0x73 }
  0x0000,  // { 0x85, 0x74 }
  0x0000,  // { 0x85, 0x75 }
  0x0000,  // { 0x85, 0x76 }
  0x0000,  // { 0x85, 0x77 }
  0x0000,  // { 0x85, 0x78 }
  0x0000,  // { 0x85, 0x79 }
  0x0000,  // { 0x85, 0x7A }
  0x0000,  // { 0x85, 0x7B }
  0x0000,  // { 0x85, 0x7C }
  0x0000,  // { 0x85, 0x7D }
  0x0000,  // { 0x85, 0x7E }
  0x0000,  // { 0x85, 0x80 }
  0x0000,  // { 0x85, 0x81 }
  0x0000,  // { 0x85, 0x82 }
  0x0000,  // { 0x85, 0x83 }
  0x0000,  // { 0x85, 0x84 }
  0x0000,  // { 0x85, 0x85 }
  0x0000,  // { 0x85, 0x86 }
  0x0000,  // { 0x85, 0x87 }
  0x0000,  // { 0x85, 0x88 }
  0x0000,  // { 0x85, 0x89 }
  0x0000,  // { 0x85, 0x8A }
  0x0000,  // { 0x85, 0x8B }
  0x0000,  // { 0x85, 0x8C }
  0x0000,  // { 0x85, 0x8D }
  0x0000,  // { 0x85, 0x8E }
  0x0000,  // { 0x85, 0x8F }
  0x0000,  // { 0x85, 0x90 }
  0x0000,  // { 0x85, 0x91 }
  0x0000,  // { 0x85, 0x92 }
  0x0000,  // { 0x85, 0x93 }
  0x0000,  // { 0x85, 0x94 }
  0x0000,  // { 0x85, 0x95 }
  0x0000,  // { 0x85, 0x96 }
  0x0000,  // { 0x85, 0x97 }
  0x0000,  // { 0x85, 0x98 }
  0x0000,  // { 0x85, 0x99 }
  0x0000,  // { 0x85, 0x9A }
  0x0000,  // { 0x85, 0x9B }
  0x0000,  // { 0x85, 0x9C }
  0x0000,  // { 0x85, 0x9D }
  0x0000,  // { 0x85, 0x9E }
  0x0000,  // { 0x85, 0x9F }
  0x0000,  // { 0x85, 0xA0 }
  0x0000,  // { 0x85, 0xA1 }
  0x0000,  // { 0x85, 0xA2 }
  0x0000,  // { 0x85, 0xA3 }
  0x0000,  // { 0x85, 0xA4 }
  0x0000,  // { 0x85, 0xA5 }
  0x0000,  // { 0x85, 0xA6 }
  0x0000,  // { 0x85, 0xA7 }
  0x0000,  // { 0x85, 0xA8 }
  0x0000,  // { 0x85, 0xA9 }
  0x0000,  // { 0x85, 0xAA }
  0x0000,  // { 0x85, 0xAB }
  0x0000,  // { 0x85, 0xAC }
  0x0000,  // { 0x85, 0xAD }
  0x0000,  // { 0x85, 0xAE }
  0x0000,  // { 0x85, 0xAF }
  0x0000,  // { 0x85, 0xB0 }
  0x0000,  // { 0x85, 0xB1 }
  0x0000,  // { 0x85, 0xB2 }
  0x0000,  // { 0x85, 0xB3 }
  0x0000,  // { 0x85, 0xB4 }
  0x0000,  // { 0x85, 0xB5 }
  0x0000,  // { 0x85, 0xB6 }
  0x0000,  // { 0x85, 0xB7 }
  0x0000,  // { 0x85, 0xB8 }
  0x0000,  // { 0x85, 0xB9 }
  0x0000,  // { 0x85, 0xBA }
  0x0000,  // { 0x85, 0xBB }
  0x0000,  // { 0x85, 0xBC }
  0x0000,  // { 0x85, 0xBD }
  0x0000,  // { 0x85, 0xBE }
  0x0000,  // { 0x85, 0xBF }
  0x0000,  // { 0x85, 0xC0 }
  0x0000,  // { 0x85, 0xC1 }
  0x0000,  // { 0x85, 0xC2 }
  0x0000,  // { 0x85, 0xC3 }
  0x0000,  // { 0x85, 0xC4 }
  0x0000,  // { 0x85, 0xC5 }
  0x0000,  // { 0x85, 0xC6 }
  0x0000,  // { 0x85, 0xC7 }
  0x0000,  // { 0x85, 0xC8 }
  0x0000,  // { 0x85, 0xC9 }
  0x0000,  // { 0x85, 0xCA }
  0x0000,  // { 0x85, 0xCB }
  0x0000,  // { 0x85, 0xCC }
  0x0000,  // { 0x85, 0xCD }
  0x0000,  // { 0x85, 0xCE }
  0x0000,  // { 0x85, 0xCF }
  0x0000,  // { 0x85, 0xD0 }
  0x0000,  // { 0x85, 0xD1 }
  0x0000,  // { 0x85, 0xD2 }
  0x0000,  // { 0x85, 0xD3 }
  0x0000,  // { 0x85, 0xD4 }
  0x0000,  // { 0x85, 0xD5 }
  0x0000,  // { 0x85, 0xD6 }
  0x0000,  // { 0x85, 0xD7 }
  0x0000,  // { 0x85, 0xD8 }
  0x0000,  // { 0x85, 0xD9 }
  0x0000,  // { 0x85, 0xDA }
  0x0000,  // { 0x85, 0xDB }
  0x0000,  // { 0x85, 0xDC }
  0x0000,  // { 0x85, 0xDD }
  0x0000,  // { 0x85, 0xDE }
  0x0000,  // { 0x85, 0xDF }
  0x0000,  // { 0x85, 0xE0 }
  0x0000,  // { 0x85, 0xE1 }
  0x0000,  // { 0x85, 0xE2 }
  0x0000,  // { 0x85, 0xE3 }
  0x0000,  // { 0x85, 0xE4 }
  0x0000,  // { 0x85, 0xE5 }
  0x0000,  // { 0x85, 0xE6 }
  0x0000,  // { 0x85, 0xE7 }
  0x0000,  // { 0x85, 0xE8 }
  0x0000,  // { 0x85, 0xE9 }
  0x0000,  // { 0x85, 0xEA }
  0x0000,  // { 0x85, 0xEB }
  0x0000,  // { 0x85, 0xEC }
  0x0000,  // { 0x85, 0xED }
  0x0000,  // { 0x85, 0xEE }
  0x0000,  // { 0x85, 0xEF }
  0x0000,  // { 0x85, 0xF0 }
  0x0000,  // { 0x85, 0xF1 }
  0x0000,  // { 0x85, 0xF2 }
  0x0000,  // { 0x85, 0xF3 }
  0x0000,  // { 0x85, 0xF4 }
  0x0000,  // { 0x85, 0xF5 }
  0x0000,  // { 0x85, 0xF6 }
  0x0000,  // { 0x85, 0xF7 }
  0x0000,  // { 0x85, 0xF8 }
  0x0000,  // { 0x85, 0xF9 }
  0x0000,  // { 0x85, 0xFA }
  0x0000,  // { 0x85, 0xFB }
  0x0000,  // { 0x85, 0xFC }
  0x0000,  // { 0x85, 0xFD }
  0x0000,  // { 0x85, 0xFE }
  0x0000,  // { 0x85, 0xFF }
  0x0000,  // { 0x86, 0x40 }
  0x0000,  // { 0x86, 0x41 }
  0x0000,  // { 0x86, 0x42 }
  0x0000,  // { 0x86, 0x43 }
  0x0000,  // { 0x86, 0x44 }
  0x0000,  // { 0x86, 0x45 }
  0x0000,  // { 0x86, 0x46 }
  0x0000,  // { 0x86, 0x47 }
  0x0000,  // { 0x86, 0x48 }
  0x0000,  // { 0x86, 0x49 }
  0x0000,  // { 0x86, 0x4A }
  0x0000,  // { 0x86, 0x4B }
  0x0000,  // { 0x86, 0x4C }
  0x0000,  // { 0x86, 0x4D }
  0x0000,  // { 0x86, 0x4E }
  0x0000,  // { 0x86, 0x4F }
  0x0000,  // { 0x86, 0x50 }
  0x0000,  // { 0x86, 0x51 }
  0x0000,  // { 0x86, 0x52 }
  0x0000,  // { 0x86, 0x53 }
  0x0000,  // { 0x86, 0x54 }
  0x0000,  // { 0x86, 0x55 }
  0x0000,  // { 0x86, 0x56 }
  0x0000,  // { 0x86, 0x57 }
  0x0000,  // { 0x86, 0x58 }
  0x0000,  // { 0x86, 0x59 }
  0x0000,  // { 0x86, 0x5A }
  0x0000,  // { 0x86, 0x5B }
  0x0000,  // { 0x86, 0x5C }
  0x0000,  // { 0x86, 0x5D }
  0x0000,  // { 0x86, 0x5E }
  0x0000,  // { 0x86, 0x5F }
  0x0000,  // { 0x86, 0x60 }
  0x0000,  // { 0x86, 0x61 }
  0x0000,  // { 0x86, 0x62 }
  0x0000,  // { 0x86, 0x63 }
  0x0000,  // { 0x86, 0x64 }
  0x0000,  // { 0x86, 0x65 }
  0x0000,  // { 0x86, 0x66 }
  0x0000,  // { 0x86, 0x67 }
  0x0000,  // { 0x86, 0x68 }
  0x0000,  // { 0x86, 0x69 }
  0x0000,  // { 0x86, 0x6A }
  0x0000,  // { 0x86, 0x6B }
  0x0000,  // { 0x86, 0x6C }
  0x0000,  // { 0x86, 0x6D }
  0x0000,  // { 0x86, 0x6E }
  0x0000,  // { 0x86, 0x6F }
  0x0000,  // { 0x86, 0x70 }
  0x0000,  // { 0x86, 0x71 }
  0x0000,  // { 0x86, 0x72 }
  0x0000,  // { 0x86, 0x73 }
  0x0000,  // { 0x86, 0x74 }
  0x0000,  // { 0x86, 0x75 }
  0x0000,  // { 0x86, 0x76 }
  0x0000,  // { 0x86, 0x77 }
  0x0000,  // { 0x86, 0x78 }
  0x0000,  // { 0x86, 0x79 }
  0x0000,  // { 0x86, 0x7A }
  0x0000,  // { 0x86, 0x7B }
  0x0000,  // { 0x86, 0x7C }
  0x0000,  // { 0x86, 0x7D }
  0x0000,  // { 0x86, 0x7E }
  0x0000,  // { 0x86, 0x80 }
  0x0000,  // { 0x86, 0x81 }
  0x0000,  // { 0x86, 0x82 }
  0x0000,  // { 0x86, 0x83 }
  0x0000,  // { 0x86, 0x84 }
  0x0000,  // { 0x86, 0x85 }
  0x0000,  // { 0x86, 0x86 }
  0x0000,  // { 0x86, 0x87 }
  0x0000,  // { 0x86, 0x88 }
  0x0000,  // { 0x86, 0x89 }
  0x0000,  // { 0x86, 0x8A }
  0x0000,  // { 0x86, 0x8B }
  0x0000,  // { 0x86, 0x8C }
  0x0000,  // { 0x86, 0x8D }
  0x0000,  // { 0x86, 0x8E }
  0x0000,  // { 0x86, 0x8F }
  0x0000,  // { 0x86, 0x90 }
  0x0000,  // { 0x86, 0x91 }
  0x0000,  // { 0x86, 0x92 }
  0x0000,  // { 0x86, 0x93 }
  0x0000,  // { 0x86, 0x94 }
  0x0000,  // { 0x86, 0x95 }
  0x0000,  // { 0x86, 0x96 }
  0x0000,  // { 0x86, 0x97 }
  0x0000,  // { 0x86, 0x98 }
  0x0000,  // { 0x86, 0x99 }
  0x0000,  // { 0x86, 0x9A }
  0x0000,  // { 0x86, 0x9B }
  0x0000,  // { 0x86, 0x9C }
  0x0000,  // { 0x86, 0x9D }
  0x0000,  // { 0x86, 0x9E }
  0x0000,  // { 0x86, 0x9F }
  0x0000,  // { 0x86, 0xA0 }
  0x0000,  // { 0x86, 0xA1 }
  0x0000,  // { 0x86, 0xA2 }
  0x0000,  // { 0x86, 0xA3 }
  0x0000,  // { 0x86, 0xA4 }
  0x0000,  // { 0x86, 0xA5 }
  0x0000,  // { 0x86, 0xA6 }
  0x0000,  // { 0x86, 0xA7 }
  0x0000,  // { 0x86, 0xA8 }
  0x0000,  // { 0x86, 0xA9 }
  0x0000,  // { 0x86, 0xAA }
  0x0000,  // { 0x86, 0xAB }
  0x0000,  // { 0x86, 0xAC }
  0x0000,  // { 0x86, 0xAD }
  0x0000,  // { 0x86, 0xAE }
  0x0000,  // { 0x86, 0xAF }
  0x0000,  // { 0x86, 0xB0 }
  0x0000,  // { 0x86, 0xB1 }
  0x0000,  // { 0x86, 0xB2 }
  0x0000,  // { 0x86, 0xB3 }
  0x0000,  // { 0x86, 0xB4 }
  0x0000,  // { 0x86, 0xB5 }
  0x0000,  // { 0x86, 0xB6 }
  0x0000,  // { 0x86, 0xB7 }
  0x0000,  // { 0x86, 0xB8 }
  0x0000,  // { 0x86, 0xB9 }
  0x0000,  // { 0x86, 0xBA }
  0x0000,  // { 0x86, 0xBB }
  0x0000,  // { 0x86, 0xBC }
  0x0000,  // { 0x86, 0xBD }
  0x0000,  // { 0x86, 0xBE }
  0x0000,  // { 0x86, 0xBF }
  0x0000,  // { 0x86, 0xC0 }
  0x0000,  // { 0x86, 0xC1 }
  0x0000,  // { 0x86, 0xC2 }
  0x0000,  // { 0x86, 0xC3 }
  0x0000,  // { 0x86, 0xC4 }
  0x0000,  // { 0x86, 0xC5 }
  0x0000,  // { 0x86, 0xC6 }
  0x0000,  // { 0x86, 0xC7 }
  0x0000,  // { 0x86, 0xC8 }
  0x0000,  // { 0x86, 0xC9 }
  0x0000,  // { 0x86, 0xCA }
  0x0000,  // { 0x86, 0xCB }
  0x0000,  // { 0x86, 0xCC }
  0x0000,  // { 0x86, 0xCD }
  0x0000,  // { 0x86, 0xCE }
  0x0000,  // { 0x86, 0xCF }
  0x0000,  // { 0x86, 0xD0 }
  0x0000,  // { 0x86, 0xD1 }
  0x0000,  // { 0x86, 0xD2 }
  0x0000,  // { 0x86, 0xD3 }
  0x0000,  // { 0x86, 0xD4 }
  0x0000,  // { 0x86, 0xD5 }
  0x0000,  // { 0x86, 0xD6 }
  0x0000,  // { 0x86, 0xD7 }
  0x0000,  // { 0x86, 0xD8 }
  0x0000,  // { 0x86, 0xD9 }
  0x0000,  // { 0x86, 0xDA }
  0x0000,  // { 0x86, 0xDB }
  0x0000,  // { 0x86, 0xDC }
  0x0000,  // { 0x86, 0xDD }
  0x0000,  // { 0x86, 0xDE }
  0x0000,  // { 0x86, 0xDF }
  0x0000,  // { 0x86, 0xE0 }
  0x0000,  // { 0x86, 0xE1 }
  0x0000,  // { 0x86, 0xE2 }
  0x0000,  // { 0x86, 0xE3 }
  0x0000,  // { 0x86, 0xE4 }
  0x0000,  // { 0x86, 0xE5 }
  0x0000,  // { 0x86, 0xE6 }
  0x0000,  // { 0x86, 0xE7 }
  0x0000,  // { 0x86, 0xE8 }
  0x0000,  // { 0x86, 0xE9 }
  0x0000,  // { 0x86, 0xEA }
  0x0000,  // { 0x86, 0xEB }
  0x0000,  // { 0x86, 0xEC }
  0x0000,  // { 0x86, 0xED }
  0x0000,  // { 0x86, 0xEE }
  0x0000,  // { 0x86, 0xEF }
  0x0000,  // { 0x86, 0xF0 }
  0x0000,  // { 0x86, 0xF1 }
  0x0000,  // { 0x86, 0xF2 }
  0x0000,  // { 0x86, 0xF3 }
  0x0000,  // { 0x86, 0xF4 }
  0x0000,  // { 0x86, 0xF5 }
  0x0000,  // { 0x86, 0xF6 }
  0x0000,  // { 0x86, 0xF7 }
  0x0000,  // { 0x86, 0xF8 }
  0x0000,  // { 0x86, 0xF9 }
  0x0000,  // { 0x86, 0xFA }
  0x0000,  // { 0x86, 0xFB }
  0x0000,  // { 0x86, 0xFC }
  0x0000,  // { 0x86, 0xFD }
  0x0000,  // { 0x86, 0xFE }
  0x0000,  // { 0x86, 0xFF }
  0x2460,  // { 0x87, 0x40 } "①"
  0x2461,  // { 0x87, 0x41 } "②"
  0x2462,  // { 0x87, 0x42 } "③"
  0x2463,  // { 0x87, 0x43 } "④"
  0x2464,  // { 0x87, 0x44 } "⑤"
  0x2465,  // { 0x87, 0x45 } "⑥"
  0x2466,  // { 0x87, 0x46 } "⑦"
  0x2467,  // { 0x87, 0x47 } "⑧"
  0x2468,  // { 0x87, 0x48 } "⑨"
  0x2469,  // { 0x87, 0x49 } "⑩"
  0x246A,  // { 0x87, 0x4A } "⑪"
  0x246B,  // { 0x87, 0x4B } "⑫"
  0x246C,  // { 0x87, 0x4C } "⑬"
  0x246D,  // { 0x87, 0x4D } "⑭"
  0x246E,  // { 0x87, 0x4E } "⑮"
  0x246F,  // { 0x87, 0x4F } "⑯"
  0x2470,  // { 0x87, 0x50 } "⑰"
  0x2471,  // { 0x87, 0x51 } "⑱"
  0x2472,  // { 0x87, 0x52 } "⑲"
  0x2473,  // { 0x87, 0x53 } "⑳"
  0x2160,  // { 0x87, 0x54 } "Ⅰ"
  0x2161,  // { 0x87, 0x55 } "Ⅱ"
  0x2162,  // { 0x87, 0x56 } "Ⅲ"
  0x2163,  // { 0x87, 0x57 } "Ⅳ"
  0x2164,  // { 0x87, 0x58 } "Ⅴ"
  0x2165,  // { 0x87, 0x59 } "Ⅵ"
  0x2166,  // { 0x87, 0x5A } "Ⅶ"
  0x2167,  // { 0x87, 0x5B } "Ⅷ"
  0x2168,  // { 0x87, 0x5C } "Ⅸ"
  0x2169,  // { 0x87, 0x5D } "Ⅹ"
  0x0000,  // { 0x87, 0x5E }
  0x3349,  // { 0x87, 0x5F } "㍉"
  0x3314,  // { 0x87, 0x60 } "㌔"
  0x3322,  // { 0x87, 0x61 } "㌢"
  0x334D,  // { 0x87, 0x62 } "㍍"
  0x3318,  // { 0x87, 0x63 } "㌘"
  0x3327,  // { 0x87, 0x64 } "㌧"
  0x3303,  // { 0x87, 0x65 } "㌃"
  0x3336,  // { 0x87, 0x66 } "㌶"
  0x3351,  // { 0x87, 0x67 } "㍑"
  0x3357,  // { 0x87, 0x68 } "㍗"
  0x330D,  // { 0x87, 0x69 } "㌍"
  0x3326,  // { 0x87, 0x6A } "㌦"
  0x3323,  // { 0x87, 0x6B } "㌣"
  0x332B,  // { 0x87, 0x6C } "㌫"
  0x334A,  // { 0x87, 0x6D } "㍊"
  0x333B,  // { 0x87, 0x6E } "㌻"
  0x339C,  // { 0x87, 0x6F } "㎜"
  0x339D,  // { 0x87, 0x70 } "㎝"
  0x339E,  // { 0x87, 0x71 } "㎞"
  0x338E,  // { 0x87, 0x72 } "㎎"
  0x338F,  // { 0x87, 0x73 } "㎏"
  0x33C4,  // { 0x87, 0x74 } "㏄"
  0x33A1,  // { 0x87, 0x75 } "㎡"
  0x0000,  // { 0x87, 0x76 }
  0x0000,  // { 0x87, 0x77 }
  0x0000,  // { 0x87, 0x78 }
  0x0000,  // { 0x87, 0x79 }
  0x0000,  // { 0x87, 0x7A }
  0x0000,  // { 0x87, 0x7B }
  0x0000,  // { 0x87, 0x7C }
  0x0000,  // { 0x87, 0x7D }
  0x337B,  // { 0x87, 0x7E } "㍻"
  0x301D,  // { 0x87, 0x80 } "〝"
  0x301F,  // { 0x87, 0x81 } "〟"
  0x2116,  // { 0x87, 0x82 } "№"
  0x33CD,  // { 0x87, 0x83 } "㏍"
  0x2121,  // { 0x87, 0x84 } "℡"
  0x32A4,  // { 0x87, 0x85 } "㊤"
  0x32A5,  // { 0x87, 0x86 } "㊥"
  0x32A6,  // { 0x87, 0x87 } "㊦"
  0x32A7,  // { 0x87, 0x88 } "㊧"
  0x32A8,  // { 0x87, 0x89 } "㊨"
  0x3231,  // { 0x87, 0x8A } "㈱"
  0x3232,  // { 0x87, 0x8B } "㈲"
  0x3239,  // { 0x87, 0x8C } "㈹"
  0x337E,  // { 0x87, 0x8D } "㍾"
  0x337D,  // { 0x87, 0x8E } "㍽"
  0x337C,  // { 0x87, 0x8F } "㍼"
  0x2252,  // { 0x87, 0x90 } "≒"
  0x2261,  // { 0x87, 0x91 } "≡"
  0x222B,  // { 0x87, 0x92 } "∫"
  0x222E,  // { 0x87, 0x93 } "∮"
  0x2211,  // { 0x87, 0x94 } "∑"
  0x221A,  // { 0x87, 0x95 } "√"
  0x22A5,  // { 0x87, 0x96 } "⊥"
  0x2220,  // { 0x87, 0x97 } "∠"
  0x221F,  // { 0x87, 0x98 } "∟"
  0x22BF,  // { 0x87, 0x99 } "⊿"
  0x2235,  // { 0x87, 0x9A } "∵"
  0x2229,  // { 0x87, 0x9B } "∩"
  0x222A,  // { 0x87, 0x9C } "∪"
  0x0000,  // { 0x87, 0x9D }
  0x0000,  // { 0x87, 0x9E }
  0x0000,  // { 0x87, 0x9F }
  0x0000,  // { 0x87, 0xA0 }
  0x0000,  // { 0x87, 0xA1 }
  0x0000,  // { 0x87, 0xA2 }
  0x0000,  // { 0x87, 0xA3 }
  0x0000,  // { 0x87, 0xA4 }
  0x0000,  // { 0x87, 0xA5 }
  0x0000,  // { 0x87, 0xA6 }
  0x0000,  // { 0x87, 0xA7 }
  0x0000,  // { 0x87, 0xA8 }
  0x0000,  // { 0x87, 0xA9 }
  0x0000,  // { 0x87, 0xAA }
  0x0000,  // { 0x87, 0xAB }
  0x0000,  // { 0x87, 0xAC }
  0x0000,  // { 0x87, 0xAD }
  0x0000,  // { 0x87, 0xAE }
  0x0000,  // { 0x87, 0xAF }
  0x0000,  // { 0x87, 0xB0 }
  0x0000,  // { 0x87, 0xB1 }
  0x0000,  // { 0x87, 0xB2 }
  0x0000,  // { 0x87, 0xB3 }
  0x0000,  // { 0x87, 0xB4 }
  0x0000,  // { 0x87, 0xB5 }
  0x0000,  // { 0x87, 0xB6 }
  0x0000,  // { 0x87, 0xB7 }
  0x0000,  // { 0x87, 0xB8 }
  0x0000,  // { 0x87, 0xB9 }
  0x0000,  // { 0x87, 0xBA }
  0x0000,  // { 0x87, 0xBB }
  0x0000,  // { 0x87, 0xBC }
  0x0000,  // { 0x87, 0xBD }
  0x0000,  // { 0x87, 0xBE }
  0x0000,  // { 0x87, 0xBF }
  0x0000,  // { 0x87, 0xC0 }
  0x0000,  // { 0x87, 0xC1 }
  0x0000,  // { 0x87, 0xC2 }
  0x0000,  // { 0x87, 0xC3 }
  0x0000,  // { 0x87, 0xC4 }
  0x0000,  // { 0x87, 0xC5 }
  0x0000,  // { 0x87, 0xC6 }
  0x0000,  // { 0x87, 0xC7 }
  0x0000,  // { 0x87, 0xC8 }
  0x0000,  // { 0x87, 0xC9 }
  0x0000,  // { 0x87, 0xCA }
  0x0000,  // { 0x87, 0xCB }
  0x0000,  // { 0x87, 0xCC }
  0x0000,  // { 0x87, 0xCD }
  0x0000,  // { 0x87, 0xCE }
  0x0000,  // { 0x87, 0xCF }
  0x0000,  // { 0x87, 0xD0 }
  0x0000,  // { 0x87, 0xD1 }
  0x0000,  // { 0x87, 0xD2 }
  0x0000,  // { 0x87, 0xD3 }
  0x0000,  // { 0x87, 0xD4 }
  0x0000,  // { 0x87, 0xD5 }
  0x0000,  // { 0x87, 0xD6 }
  0x0000,  // { 0x87, 0xD7 }
  0x0000,  // { 0x87, 0xD8 }
  0x0000,  // { 0x87, 0xD9 }
  0x0000,  // { 0x87, 0xDA }
  0x0000,  // { 0x87, 0xDB }
  0x0000,  // { 0x87, 0xDC }
  0x0000,  // { 0x87, 0xDD }
  0x0000,  // { 0x87, 0xDE }
  0x0000,  // { 0x87, 0xDF }
  0x0000,  // { 0x87, 0xE0 }
  0x0000,  // { 0x87, 0xE1 }
  0x0000,  // { 0x87, 0xE2 }
  0x0000,  // { 0x87, 0xE3 }
  0x0000,  // { 0x87, 0xE4 }
  0x0000,  // { 0x87, 0xE5 }
  0x0000,  // { 0x87, 0xE6 }
  0x0000,  // { 0x87, 0xE7 }
  0x0000,  // { 0x87, 0xE8 }
  0x0000,  // { 0x87, 0xE9 }
  0x0000,  // { 0x87, 0xEA }
  0x0000,  // { 0x87, 0xEB }
  0x0000,  // { 0x87, 0xEC }
  0x0000,  // { 0x87, 0xED }
  0x0000,  // { 0x87, 0xEE }
  0x0000,  // { 0x87, 0xEF }
  0x0000,  // { 0x87, 0xF0 }
  0x0000,  // { 0x87, 0xF1 }
  0x0000,  // { 0x87, 0xF2 }
  0x0000,  // { 0x87, 0xF3 }
  0x0000,  // { 0x87, 0xF4 }
  0x0000,  // { 0x87, 0xF5 }
  0x0000,  // { 0x87, 0xF6 }
  0x0000,  // { 0x87, 0xF7 }
  0x0000,  // { 0x87, 0xF8 }
  0x0000,  // { 0x87, 0xF9 }
  0x0000,  // { 0x87, 0xFA }
  0x0000,  // { 0x87, 0xFB }
  0x0000,  // { 0x87, 0xFC }
  0x0000,  // { 0x87, 0xFD }
  0x0000,  // { 0x87, 0xFE }
  0x0000,  // { 0x87, 0xFF }
  0x0000,  // { 0x88, 0x40 }
  0x0000,  // { 0x88, 0x41 }
  0x0000,  // { 0x88, 0x42 }
  0x0000,  // { 0x88, 0x43 }
  0x0000,  // { 0x88, 0x44 }
  0x0000,  // { 0x88, 0x45 }
  0x0000,  // { 0x88, 0x46 }
  0x0000,  // { 0x88, 0x47 }
  0x0000,  // { 0x88, 0x48 }
  0x0000,  // { 0x88, 0x49 }
  0x0000,  // { 0x88, 0x4A }
  0x0000,  // { 0x88, 0x4B }
  0x0000,  // { 0x88, 0x4C }
  0x0000,  // { 0x88, 0x4D }
  0x0000,  // { 0x88, 0x4E }
  0x0000,  // { 0x88, 0x4F }
  0x0000,  // { 0x88, 0x50 }
  0x0000,  // { 0x88, 0x51 }
  0x0000,  // { 0x88, 0x52 }
  0x0000,  // { 0x88, 0x53 }
  0x0000,  // { 0x88, 0x54 }
  0x0000,  // { 0x88, 0x55 }
  0x0000,  // { 0x88, 0x56 }
  0x0000,  // { 0x88, 0x57 }
  0x0000,  // { 0x88, 0x58 }
  0x0000,  // { 0x88, 0x59 }
  0x0000,  // { 0x88, 0x5A }
  0x0000,  // { 0x88, 0x5B }
  0x0000,  // { 0x88, 0x5C }
  0x0000,  // { 0x88, 0x5D }
  0x0000,  // { 0x88, 0x5E }
  0x0000,  // { 0x88, 0x5F }
  0x0000,  // { 0x88, 0x60 }
  0x0000,  // { 0x88, 0x61 }
  0x0000,  // { 0x88, 0x62 }
  0x0000,  // { 0x88, 0x63 }
  0x0000,  // { 0x88, 0x64 }
  0x0000,  // { 0x88, 0x65 }
  0x0000,  // { 0x88, 0x66 }
  0x0000,  // { 0x88, 0x67 }
  0x0000,  // { 0x88, 0x68 }
  0x0000,  // { 0x88, 0x69 }
  0x0000,  // { 0x88, 0x6A }
  0x0000,  // { 0x88, 0x6B }
  0x0000,  // { 0x88, 0x6C }
  0x0000,  // { 0x88, 0x6D }
  0x0000,  // { 0x88, 0x6E }
  0x0000,  // { 0x88, 0x6F }
  0x0000,  // { 0x88, 0x70 }
  0x0000,  // { 0x88, 0x71 }
  0x0000,  // { 0x88, 0x72 }
  0x0000,  // { 0x88, 0x73 }
  0x0000,  // { 0x88, 0x74 }
  0x0000,  // { 0x88, 0x75 }
  0x0000,  // { 0x88, 0x76 }
  0x0000,  // { 0x88, 0x77 }
  0x0000,  // { 0x88, 0x78 }
  0x0000,  // { 0x88, 0x79 }
  0x0000,  // { 0x88, 0x7A }
  0x0000,  // { 0x88, 0x7B }
  0x0000,  // { 0x88, 0x7C }
  0x0000,  // { 0x88, 0x7D }
  0x0000,  // { 0x88, 0x7E }
  0x0000,  // { 0x88, 0x80 }
  0x0000,  // { 0x88, 0x81 }
  0x0000,  // { 0x88, 0x82 }
  0x0000,  // { 0x88, 0x83 }
  0x0000,  // { 0x88, 0x84 }
  0x0000,  // { 0x88, 0x85 }
  0x0000,  // { 0x88, 0x86 }
  0x0000,  // { 0x88, 0x87 }
  0x0000,  // { 0x88, 0x88 }
  0x0000,  // { 0x88, 0x89 }
  0x0000,  // { 0x88, 0x8A }
  0x0000,  // { 0x88, 0x8B }
  0x0000,  // { 0x88, 0x8C }
  0x0000,  // { 0x88, 0x8D }
  0x0000,  // { 0x88, 0x8E }
  0x0000,  // { 0x88, 0x8F }
  0x0000,  // { 0x88, 0x90 }
  0x0000,  // { 0x88, 0x91 }
  0x0000,  // { 0x88, 0x92 }
  0x0000,  // { 0x88, 0x93 }
  0x0000,  // { 0x88, 0x94 }
  0x0000,  // { 0x88, 0x95 }
  0x0000,  // { 0x88, 0x96 }
  0x0000,  // { 0x88, 0x97 }
  0x0000,  // { 0x88, 0x98 }
  0x0000,  // { 0x88, 0x99 }
  0x0000,  // { 0x88, 0x9A }
  0x0000,  // { 0x88, 0x9B }
  0x0000,  // { 0x88, 0x9C }
  0x0000,  // { 0x88, 0x9D }
  0x0000,  // { 0x88, 0x9E }
  0x4E9C,  // { 0x88, 0x9F } "亜"
  0x5516,  // { 0x88, 0xA0 } "唖"
  0x5A03,  // { 0x88, 0xA1 } "娃"
  0x963F,  // { 0x88, 0xA2 } "阿"
  0x54C0,  // { 0x88, 0xA3 } "哀"
  0x611B,  // { 0x88, 0xA4 } "愛"
  0x6328,  // { 0x88, 0xA5 } "挨"
  0x59F6,  // { 0x88, 0xA6 } "姶"
  0x9022,  // { 0x88, 0xA7 } "逢"
  0x8475,  // { 0x88, 0xA8 } "葵"
  0x831C,  // { 0x88, 0xA9 } "茜"
  0x7A50,  // { 0x88, 0xAA } "穐"
  0x60AA,  // { 0x88, 0xAB } "悪"
  0x63E1,  // { 0x88, 0xAC } "握"
  0x6E25,  // { 0x88, 0xAD } "渥"
  0x65ED,  // { 0x88, 0xAE } "旭"
  0x8466,  // { 0x88, 0xAF } "葦"
  0x82A6,  // { 0x88, 0xB0 } "芦"
  0x9BF5,  // { 0x88, 0xB1 } "鯵"
  0x6893,  // { 0x88, 0xB2 } "梓"
  0x5727,  // { 0x88, 0xB3 } "圧"
  0x65A1,  // { 0x88, 0xB4 } "斡"
  0x6271,  // { 0x88, 0xB5 } "扱"
  0x5B9B,  // { 0x88, 0xB6 } "宛"
  0x59D0,  // { 0x88, 0xB7 } "姐"
  0x867B,  // { 0x88, 0xB8 } "虻"
  0x98F4,  // { 0x88, 0xB9 } "飴"
  0x7D62,  // { 0x88, 0xBA } "絢"
  0x7DBE,  // { 0x88, 0xBB } "綾"
  0x9B8E,  // { 0x88, 0xBC } "鮎"
  0x6216,  // { 0x88, 0xBD } "或"
  0x7C9F,  // { 0x88, 0xBE } "粟"
  0x88B7,  // { 0x88, 0xBF } "袷"
  0x5B89,  // { 0x88, 0xC0 } "安"
  0x5EB5,  // { 0x88, 0xC1 } "庵"
  0x6309,  // { 0x88, 0xC2 } "按"
  0x6697,  // { 0x88, 0xC3 } "暗"
  0x6848,  // { 0x88, 0xC4 } "案"
  0x95C7,  // { 0x88, 0xC5 } "闇"
  0x978D,  // { 0x88, 0xC6 } "鞍"
  0x674F,  // { 0x88, 0xC7 } "杏"
  0x4EE5,  // { 0x88, 0xC8 } "以"
  0x4F0A,  // { 0x88, 0xC9 } "伊"
  0x4F4D,  // { 0x88, 0xCA } "位"
  0x4F9D,  // { 0x88, 0xCB } "依"
  0x5049,  // { 0x88, 0xCC } "偉"
  0x56F2,  // { 0x88, 0xCD } "囲"
  0x5937,  // { 0x88, 0xCE } "夷"
  0x59D4,  // { 0x88, 0xCF } "委"
  0x5A01,  // { 0x88, 0xD0 } "威"
  0x5C09,  // { 0x88, 0xD1 } "尉"
  0x60DF,  // { 0x88, 0xD2 } "惟"
  0x610F,  // { 0x88, 0xD3 } "意"
  0x6170,  // { 0x88, 0xD4 } "慰"
  0x6613,  // { 0x88, 0xD5 } "易"
  0x6905,  // { 0x88, 0xD6 } "椅"
  0x70BA,  // { 0x88, 0xD7 } "為"
  0x754F,  // { 0x88, 0xD8 } "畏"
  0x7570,  // { 0x88, 0xD9 } "異"
  0x79FB,  // { 0x88, 0xDA } "移"
  0x7DAD,  // { 0x88, 0xDB } "維"
  0x7DEF,  // { 0x88, 0xDC } "緯"
  0x80C3,  // { 0x88, 0xDD } "胃"
  0x840E,  // { 0x88, 0xDE } "萎"
  0x8863,  // { 0x88, 0xDF } "衣"
  0x8B02,  // { 0x88, 0xE0 } "謂"
  0x9055,  // { 0x88, 0xE1 } "違"
  0x907A,  // { 0x88, 0xE2 } "遺"
  0x533B,  // { 0x88, 0xE3 } "医"
  0x4E95,  // { 0x88, 0xE4 } "井"
  0x4EA5,  // { 0x88, 0xE5 } "亥"
  0x57DF,  // { 0x88, 0xE6 } "域"
  0x80B2,  // { 0x88, 0xE7 } "育"
  0x90C1,  // { 0x88, 0xE8 } "郁"
  0x78EF,  // { 0x88, 0xE9 } "磯"
  0x4E00,  // { 0x88, 0xEA } "一"
  0x58F1,  // { 0x88, 0xEB } "壱"
  0x6EA2,  // { 0x88, 0xEC } "溢"
  0x9038,  // { 0x88, 0xED } "逸"
  0x7A32,  // { 0x88, 0xEE } "稲"
  0x8328,  // { 0x88, 0xEF } "茨"
  0x828B,  // { 0x88, 0xF0 } "芋"
  0x9C2F,  // { 0x88, 0xF1 } "鰯"
  0x5141,  // { 0x88, 0xF2 } "允"
  0x5370,  // { 0x88, 0xF3 } "印"
  0x54BD,  // { 0x88, 0xF4 } "咽"
  0x54E1,  // { 0x88, 0xF5 } "員"
  0x56E0,  // { 0x88, 0xF6 } "因"
  0x59FB,  // { 0x88, 0xF7 } "姻"
  0x5F15,  // { 0x88, 0xF8 } "引"
  0x98F2,  // { 0x88, 0xF9 } "飲"
  0x6DEB,  // { 0x88, 0xFA } "淫"
  0x80E4,  // { 0x88, 0xFB } "胤"
  0x852D,  // { 0x88, 0xFC } "蔭"
  0x0000,  // { 0x88, 0xFD }
  0x0000,  // { 0x88, 0xFE }
  0x0000,  // { 0x88, 0xFF }
  0x9662,  // { 0x89, 0x40 } "院"
  0x9670,  // { 0x89, 0x41 } "陰"
  0x96A0,  // { 0x89, 0x42 } "隠"
  0x97FB,  // { 0x89, 0x43 } "韻"
  0x540B,  // { 0x89, 0x44 } "吋"
  0x53F3,  // { 0x89, 0x45 } "右"
  0x5B87,  // { 0x89, 0x46 } "宇"
  0x70CF,  // { 0x89, 0x47 } "烏"
  0x7FBD,  // { 0x89, 0x48 } "羽"
  0x8FC2,  // { 0x89, 0x49 } "迂"
  0x96E8,  // { 0x89, 0x4A } "雨"
  0x536F,  // { 0x89, 0x4B } "卯"
  0x9D5C,  // { 0x89, 0x4C } "鵜"
  0x7ABA,  // { 0x89, 0x4D } "窺"
  0x4E11,  // { 0x89, 0x4E } "丑"
  0x7893,  // { 0x89, 0x4F } "碓"
  0x81FC,  // { 0x89, 0x50 } "臼"
  0x6E26,  // { 0x89, 0x51 } "渦"
  0x5618,  // { 0x89, 0x52 } "嘘"
  0x5504,  // { 0x89, 0x53 } "唄"
  0x6B1D,  // { 0x89, 0x54 } "欝"
  0x851A,  // { 0x89, 0x55 } "蔚"
  0x9C3B,  // { 0x89, 0x56 } "鰻"
  0x59E5,  // { 0x89, 0x57 } "姥"
  0x53A9,  // { 0x89, 0x58 } "厩"
  0x6D66,  // { 0x89, 0x59 } "浦"
  0x74DC,  // { 0x89, 0x5A } "瓜"
  0x958F,  // { 0x89, 0x5B } "閏"
  0x5642,  // { 0x89, 0x5C } "噂"
  0x4E91,  // { 0x89, 0x5D } "云"
  0x904B,  // { 0x89, 0x5E } "運"
  0x96F2,  // { 0x89, 0x5F } "雲"
  0x834F,  // { 0x89, 0x60 } "荏"
  0x990C,  // { 0x89, 0x61 } "餌"
  0x53E1,  // { 0x89, 0x62 } "叡"
  0x55B6,  // { 0x89, 0x63 } "営"
  0x5B30,  // { 0x89, 0x64 } "嬰"
  0x5F71,  // { 0x89, 0x65 } "影"
  0x6620,  // { 0x89, 0x66 } "映"
  0x66F3,  // { 0x89, 0x67 } "曳"
  0x6804,  // { 0x89, 0x68 } "栄"
  0x6C38,  // { 0x89, 0x69 } "永"
  0x6CF3,  // { 0x89, 0x6A } "泳"
  0x6D29,  // { 0x89, 0x6B } "洩"
  0x745B,  // { 0x89, 0x6C } "瑛"
  0x76C8,  // { 0x89, 0x6D } "盈"
  0x7A4E,  // { 0x89, 0x6E } "穎"
  0x9834,  // { 0x89, 0x6F } "頴"
  0x82F1,  // { 0x89, 0x70 } "英"
  0x885B,  // { 0x89, 0x71 } "衛"
  0x8A60,  // { 0x89, 0x72 } "詠"
  0x92ED,  // { 0x89, 0x73 } "鋭"
  0x6DB2,  // { 0x89, 0x74 } "液"
  0x75AB,  // { 0x89, 0x75 } "疫"
  0x76CA,  // { 0x89, 0x76 } "益"
  0x99C5,  // { 0x89, 0x77 } "駅"
  0x60A6,  // { 0x89, 0x78 } "悦"
  0x8B01,  // { 0x89, 0x79 } "謁"
  0x8D8A,  // { 0x89, 0x7A } "越"
  0x95B2,  // { 0x89, 0x7B } "閲"
  0x698E,  // { 0x89, 0x7C } "榎"
  0x53AD,  // { 0x89, 0x7D } "厭"
  0x5186,  // { 0x89, 0x7E } "円"
  0x5712,  // { 0x89, 0x80 } "園"
  0x5830,  // { 0x89, 0x81 } "堰"
  0x5944,  // { 0x89, 0x82 } "奄"
  0x5BB4,  // { 0x89, 0x83 } "宴"
  0x5EF6,  // { 0x89, 0x84 } "延"
  0x6028,  // { 0x89, 0x85 } "怨"
  0x63A9,  // { 0x89, 0x86 } "掩"
  0x63F4,  // { 0x89, 0x87 } "援"
  0x6CBF,  // { 0x89, 0x88 } "沿"
  0x6F14,  // { 0x89, 0x89 } "演"
  0x708E,  // { 0x89, 0x8A } "炎"
  0x7114,  // { 0x89, 0x8B } "焔"
  0x7159,  // { 0x89, 0x8C } "煙"
  0x71D5,  // { 0x89, 0x8D } "燕"
  0x733F,  // { 0x89, 0x8E } "猿"
  0x7E01,  // { 0x89, 0x8F } "縁"
  0x8276,  // { 0x89, 0x90 } "艶"
  0x82D1,  // { 0x89, 0x91 } "苑"
  0x8597,  // { 0x89, 0x92 } "薗"
  0x9060,  // { 0x89, 0x93 } "遠"
  0x925B,  // { 0x89, 0x94 } "鉛"
  0x9D1B,  // { 0x89, 0x95 } "鴛"
  0x5869,  // { 0x89, 0x96 } "塩"
  0x65BC,  // { 0x89, 0x97 } "於"
  0x6C5A,  // { 0x89, 0x98 } "汚"
  0x7525,  // { 0x89, 0x99 } "甥"
  0x51F9,  // { 0x89, 0x9A } "凹"
  0x592E,  // { 0x89, 0x9B } "央"
  0x5965,  // { 0x89, 0x9C } "奥"
  0x5F80,  // { 0x89, 0x9D } "往"
  0x5FDC,  // { 0x89, 0x9E } "応"
  0x62BC,  // { 0x89, 0x9F } "押"
  0x65FA,  // { 0x89, 0xA0 } "旺"
  0x6A2A,  // { 0x89, 0xA1 } "横"
  0x6B27,  // { 0x89, 0xA2 } "欧"
  0x6BB4,  // { 0x89, 0xA3 } "殴"
  0x738B,  // { 0x89, 0xA4 } "王"
  0x7FC1,  // { 0x89, 0xA5 } "翁"
  0x8956,  // { 0x89, 0xA6 } "襖"
  0x9D2C,  // { 0x89, 0xA7 } "鴬"
  0x9D0E,  // { 0x89, 0xA8 } "鴎"
  0x9EC4,  // { 0x89, 0xA9 } "黄"
  0x5CA1,  // { 0x89, 0xAA } "岡"
  0x6C96,  // { 0x89, 0xAB } "沖"
  0x837B,  // { 0x89, 0xAC } "荻"
  0x5104,  // { 0x89, 0xAD } "億"
  0x5C4B,  // { 0x89, 0xAE } "屋"
  0x61B6,  // { 0x89, 0xAF } "憶"
  0x81C6,  // { 0x89, 0xB0 } "臆"
  0x6876,  // { 0x89, 0xB1 } "桶"
  0x7261,  // { 0x89, 0xB2 } "牡"
  0x4E59,  // { 0x89, 0xB3 } "乙"
  0x4FFA,  // { 0x89, 0xB4 } "俺"
  0x5378,  // { 0x89, 0xB5 } "卸"
  0x6069,  // { 0x89, 0xB6 } "恩"
  0x6E29,  // { 0x89, 0xB7 } "温"
  0x7A4F,  // { 0x89, 0xB8 } "穏"
  0x97F3,  // { 0x89, 0xB9 } "音"
  0x4E0B,  // { 0x89, 0xBA } "下"
  0x5316,  // { 0x89, 0xBB } "化"
  0x4EEE,  // { 0x89, 0xBC } "仮"
  0x4F55,  // { 0x89, 0xBD } "何"
  0x4F3D,  // { 0x89, 0xBE } "伽"
  0x4FA1,  // { 0x89, 0xBF } "価"
  0x4F73,  // { 0x89, 0xC0 } "佳"
  0x52A0,  // { 0x89, 0xC1 } "加"
  0x53EF,  // { 0x89, 0xC2 } "可"
  0x5609,  // { 0x89, 0xC3 } "嘉"
  0x590F,  // { 0x89, 0xC4 } "夏"
  0x5AC1,  // { 0x89, 0xC5 } "嫁"
  0x5BB6,  // { 0x89, 0xC6 } "家"
  0x5BE1,  // { 0x89, 0xC7 } "寡"
  0x79D1,  // { 0x89, 0xC8 } "科"
  0x6687,  // { 0x89, 0xC9 } "暇"
  0x679C,  // { 0x89, 0xCA } "果"
  0x67B6,  // { 0x89, 0xCB } "架"
  0x6B4C,  // { 0x89, 0xCC } "歌"
  0x6CB3,  // { 0x89, 0xCD } "河"
  0x706B,  // { 0x89, 0xCE } "火"
  0x73C2,  // { 0x89, 0xCF } "珂"
  0x798D,  // { 0x89, 0xD0 } "禍"
  0x79BE,  // { 0x89, 0xD1 } "禾"
  0x7A3C,  // { 0x89, 0xD2 } "稼"
  0x7B87,  // { 0x89, 0xD3 } "箇"
  0x82B1,  // { 0x89, 0xD4 } "花"
  0x82DB,  // { 0x89, 0xD5 } "苛"
  0x8304,  // { 0x89, 0xD6 } "茄"
  0x8377,  // { 0x89, 0xD7 } "荷"
  0x83EF,  // { 0x89, 0xD8 } "華"
  0x83D3,  // { 0x89, 0xD9 } "菓"
  0x8766,  // { 0x89, 0xDA } "蝦"
  0x8AB2,  // { 0x89, 0xDB } "課"
  0x5629,  // { 0x89, 0xDC } "嘩"
  0x8CA8,  // { 0x89, 0xDD } "貨"
  0x8FE6,  // { 0x89, 0xDE } "迦"
  0x904E,  // { 0x89, 0xDF } "過"
  0x971E,  // { 0x89, 0xE0 } "霞"
  0x868A,  // { 0x89, 0xE1 } "蚊"
  0x4FC4,  // { 0x89, 0xE2 } "俄"
  0x5CE8,  // { 0x89, 0xE3 } "峨"
  0x6211,  // { 0x89, 0xE4 } "我"
  0x7259,  // { 0x89, 0xE5 } "牙"
  0x753B,  // { 0x89, 0xE6 } "画"
  0x81E5,  // { 0x89, 0xE7 } "臥"
  0x82BD,  // { 0x89, 0xE8 } "芽"
  0x86FE,  // { 0x89, 0xE9 } "蛾"
  0x8CC0,  // { 0x89, 0xEA } "賀"
  0x96C5,  // { 0x89, 0xEB } "雅"
  0x9913,  // { 0x89, 0xEC } "餓"
  0x99D5,  // { 0x89, 0xED } "駕"
  0x4ECB,  // { 0x89, 0xEE } "介"
  0x4F1A,  // { 0x89, 0xEF } "会"
  0x89E3,  // { 0x89, 0xF0 } "解"
  0x56DE,  // { 0x89, 0xF1 } "回"
  0x584A,  // { 0x89, 0xF2 } "塊"
  0x58CA,  // { 0x89, 0xF3 } "壊"
  0x5EFB,  // { 0x89, 0xF4 } "廻"
  0x5FEB,  // { 0x89, 0xF5 } "快"
  0x602A,  // { 0x89, 0xF6 } "怪"
  0x6094,  // { 0x89, 0xF7 } "悔"
  0x6062,  // { 0x89, 0xF8 } "恢"
  0x61D0,  // { 0x89, 0xF9 } "懐"
  0x6212,  // { 0x89, 0xFA } "戒"
  0x62D0,  // { 0x89, 0xFB } "拐"
  0x6539,  // { 0x89, 0xFC } "改"
  0x0000,  // { 0x89, 0xFD }
  0x0000,  // { 0x89, 0xFE }
  0x0000,  // { 0x89, 0xFF }
  0x9B41,  // { 0x8A, 0x40 } "魁"
  0x6666,  // { 0x8A, 0x41 } "晦"
  0x68B0,  // { 0x8A, 0x42 } "械"
  0x6D77,  // { 0x8A, 0x43 } "海"
  0x7070,  // { 0x8A, 0x44 } "灰"
  0x754C,  // { 0x8A, 0x45 } "界"
  0x7686,  // { 0x8A, 0x46 } "皆"
  0x7D75,  // { 0x8A, 0x47 } "絵"
  0x82A5,  // { 0x8A, 0x48 } "芥"
  0x87F9,  // { 0x8A, 0x49 } "蟹"
  0x958B,  // { 0x8A, 0x4A } "開"
  0x968E,  // { 0x8A, 0x4B } "階"
  0x8C9D,  // { 0x8A, 0x4C } "貝"
  0x51F1,  // { 0x8A, 0x4D } "凱"
  0x52BE,  // { 0x8A, 0x4E } "劾"
  0x5916,  // { 0x8A, 0x4F } "外"
  0x54B3,  // { 0x8A, 0x50 } "咳"
  0x5BB3,  // { 0x8A, 0x51 } "害"
  0x5D16,  // { 0x8A, 0x52 } "崖"
  0x6168,  // { 0x8A, 0x53 } "慨"
  0x6982,  // { 0x8A, 0x54 } "概"
  0x6DAF,  // { 0x8A, 0x55 } "涯"
  0x788D,  // { 0x8A, 0x56 } "碍"
  0x84CB,  // { 0x8A, 0x57 } "蓋"
  0x8857,  // { 0x8A, 0x58 } "街"
  0x8A72,  // { 0x8A, 0x59 } "該"
  0x93A7,  // { 0x8A, 0x5A } "鎧"
  0x9AB8,  // { 0x8A, 0x5B } "骸"
  0x6D6C,  // { 0x8A, 0x5C } "浬"
  0x99A8,  // { 0x8A, 0x5D } "馨"
  0x86D9,  // { 0x8A, 0x5E } "蛙"
  0x57A3,  // { 0x8A, 0x5F } "垣"
  0x67FF,  // { 0x8A, 0x60 } "柿"
  0x86CE,  // { 0x8A, 0x61 } "蛎"
  0x920E,  // { 0x8A, 0x62 } "鈎"
  0x5283,  // { 0x8A, 0x63 } "劃"
  0x5687,  // { 0x8A, 0x64 } "嚇"
  0x5404,  // { 0x8A, 0x65 } "各"
  0x5ED3,  // { 0x8A, 0x66 } "廓"
  0x62E1,  // { 0x8A, 0x67 } "拡"
  0x64B9,  // { 0x8A, 0x68 } "撹"
  0x683C,  // { 0x8A, 0x69 } "格"
  0x6838,  // { 0x8A, 0x6A } "核"
  0x6BBB,  // { 0x8A, 0x6B } "殻"
  0x7372,  // { 0x8A, 0x6C } "獲"
  0x78BA,  // { 0x8A, 0x6D } "確"
  0x7A6B,  // { 0x8A, 0x6E } "穫"
  0x899A,  // { 0x8A, 0x6F } "覚"
  0x89D2,  // { 0x8A, 0x70 } "角"
  0x8D6B,  // { 0x8A, 0x71 } "赫"
  0x8F03,  // { 0x8A, 0x72 } "較"
  0x90ED,  // { 0x8A, 0x73 } "郭"
  0x95A3,  // { 0x8A, 0x74 } "閣"
  0x9694,  // { 0x8A, 0x75 } "隔"
  0x9769,  // { 0x8A, 0x76 } "革"
  0x5B66,  // { 0x8A, 0x77 } "学"
  0x5CB3,  // { 0x8A, 0x78 } "岳"
  0x697D,  // { 0x8A, 0x79 } "楽"
  0x984D,  // { 0x8A, 0x7A } "額"
  0x984E,  // { 0x8A, 0x7B } "顎"
  0x639B,  // { 0x8A, 0x7C } "掛"
  0x7B20,  // { 0x8A, 0x7D } "笠"
  0x6A2B,  // { 0x8A, 0x7E } "樫"
  0x6A7F,  // { 0x8A, 0x80 } "橿"
  0x68B6,  // { 0x8A, 0x81 } "梶"
  0x9C0D,  // { 0x8A, 0x82 } "鰍"
  0x6F5F,  // { 0x8A, 0x83 } "潟"
  0x5272,  // { 0x8A, 0x84 } "割"
  0x559D,  // { 0x8A, 0x85 } "喝"
  0x6070,  // { 0x8A, 0x86 } "恰"
  0x62EC,  // { 0x8A, 0x87 } "括"
  0x6D3B,  // { 0x8A, 0x88 } "活"
  0x6E07,  // { 0x8A, 0x89 } "渇"
  0x6ED1,  // { 0x8A, 0x8A } "滑"
  0x845B,  // { 0x8A, 0x8B } "葛"
  0x8910,  // { 0x8A, 0x8C } "褐"
  0x8F44,  // { 0x8A, 0x8D } "轄"
  0x4E14,  // { 0x8A, 0x8E } "且"
  0x9C39,  // { 0x8A, 0x8F } "鰹"
  0x53F6,  // { 0x8A, 0x90 } "叶"
  0x691B,  // { 0x8A, 0x91 } "椛"
  0x6A3A,  // { 0x8A, 0x92 } "樺"
  0x9784,  // { 0x8A, 0x93 } "鞄"
  0x682A,  // { 0x8A, 0x94 } "株"
  0x515C,  // { 0x8A, 0x95 } "兜"
  0x7AC3,  // { 0x8A, 0x96 } "竃"
  0x84B2,  // { 0x8A, 0x97 } "蒲"
  0x91DC,  // { 0x8A, 0x98 } "釜"
  0x938C,  // { 0x8A, 0x99 } "鎌"
  0x565B,  // { 0x8A, 0x9A } "噛"
  0x9D28,  // { 0x8A, 0x9B } "鴨"
  0x6822,  // { 0x8A, 0x9C } "栢"
  0x8305,  // { 0x8A, 0x9D } "茅"
  0x8431,  // { 0x8A, 0x9E } "萱"
  0x7CA5,  // { 0x8A, 0x9F } "粥"
  0x5208,  // { 0x8A, 0xA0 } "刈"
  0x82C5,  // { 0x8A, 0xA1 } "苅"
  0x74E6,  // { 0x8A, 0xA2 } "瓦"
  0x4E7E,  // { 0x8A, 0xA3 } "乾"
  0x4F83,  // { 0x8A, 0xA4 } "侃"
  0x51A0,  // { 0x8A, 0xA5 } "冠"
  0x5BD2,  // { 0x8A, 0xA6 } "寒"
  0x520A,  // { 0x8A, 0xA7 } "刊"
  0x52D8,  // { 0x8A, 0xA8 } "勘"
  0x52E7,  // { 0x8A, 0xA9 } "勧"
  0x5DFB,  // { 0x8A, 0xAA } "巻"
  0x559A,  // { 0x8A, 0xAB } "喚"
  0x582A,  // { 0x8A, 0xAC } "堪"
  0x59E6,  // { 0x8A, 0xAD } "姦"
  0x5B8C,  // { 0x8A, 0xAE } "完"
  0x5B98,  // { 0x8A, 0xAF } "官"
  0x5BDB,  // { 0x8A, 0xB0 } "寛"
  0x5E72,  // { 0x8A, 0xB1 } "干"
  0x5E79,  // { 0x8A, 0xB2 } "幹"
  0x60A3,  // { 0x8A, 0xB3 } "患"
  0x611F,  // { 0x8A, 0xB4 } "感"
  0x6163,  // { 0x8A, 0xB5 } "慣"
  0x61BE,  // { 0x8A, 0xB6 } "憾"
  0x63DB,  // { 0x8A, 0xB7 } "換"
  0x6562,  // { 0x8A, 0xB8 } "敢"
  0x67D1,  // { 0x8A, 0xB9 } "柑"
  0x6853,  // { 0x8A, 0xBA } "桓"
  0x68FA,  // { 0x8A, 0xBB } "棺"
  0x6B3E,  // { 0x8A, 0xBC } "款"
  0x6B53,  // { 0x8A, 0xBD } "歓"
  0x6C57,  // { 0x8A, 0xBE } "汗"
  0x6F22,  // { 0x8A, 0xBF } "漢"
  0x6F97,  // { 0x8A, 0xC0 } "澗"
  0x6F45,  // { 0x8A, 0xC1 } "潅"
  0x74B0,  // { 0x8A, 0xC2 } "環"
  0x7518,  // { 0x8A, 0xC3 } "甘"
  0x76E3,  // { 0x8A, 0xC4 } "監"
  0x770B,  // { 0x8A, 0xC5 } "看"
  0x7AFF,  // { 0x8A, 0xC6 } "竿"
  0x7BA1,  // { 0x8A, 0xC7 } "管"
  0x7C21,  // { 0x8A, 0xC8 } "簡"
  0x7DE9,  // { 0x8A, 0xC9 } "緩"
  0x7F36,  // { 0x8A, 0xCA } "缶"
  0x7FF0,  // { 0x8A, 0xCB } "翰"
  0x809D,  // { 0x8A, 0xCC } "肝"
  0x8266,  // { 0x8A, 0xCD } "艦"
  0x839E,  // { 0x8A, 0xCE } "莞"
  0x89B3,  // { 0x8A, 0xCF } "観"
  0x8ACC,  // { 0x8A, 0xD0 } "諌"
  0x8CAB,  // { 0x8A, 0xD1 } "貫"
  0x9084,  // { 0x8A, 0xD2 } "還"
  0x9451,  // { 0x8A, 0xD3 } "鑑"
  0x9593,  // { 0x8A, 0xD4 } "間"
  0x9591,  // { 0x8A, 0xD5 } "閑"
  0x95A2,  // { 0x8A, 0xD6 } "関"
  0x9665,  // { 0x8A, 0xD7 } "陥"
  0x97D3,  // { 0x8A, 0xD8 } "韓"
  0x9928,  // { 0x8A, 0xD9 } "館"
  0x8218,  // { 0x8A, 0xDA } "舘"
  0x4E38,  // { 0x8A, 0xDB } "丸"
  0x542B,  // { 0x8A, 0xDC } "含"
  0x5CB8,  // { 0x8A, 0xDD } "岸"
  0x5DCC,  // { 0x8A, 0xDE } "巌"
  0x73A9,  // { 0x8A, 0xDF } "玩"
  0x764C,  // { 0x8A, 0xE0 } "癌"
  0x773C,  // { 0x8A, 0xE1 } "眼"
  0x5CA9,  // { 0x8A, 0xE2 } "岩"
  0x7FEB,  // { 0x8A, 0xE3 } "翫"
  0x8D0B,  // { 0x8A, 0xE4 } "贋"
  0x96C1,  // { 0x8A, 0xE5 } "雁"
  0x9811,  // { 0x8A, 0xE6 } "頑"
  0x9854,  // { 0x8A, 0xE7 } "顔"
  0x9858,  // { 0x8A, 0xE8 } "願"
  0x4F01,  // { 0x8A, 0xE9 } "企"
  0x4F0E,  // { 0x8A, 0xEA } "伎"
  0x5371,  // { 0x8A, 0xEB } "危"
  0x559C,  // { 0x8A, 0xEC } "喜"
  0x5668,  // { 0x8A, 0xED } "器"
  0x57FA,  // { 0x8A, 0xEE } "基"
  0x5947,  // { 0x8A, 0xEF } "奇"
  0x5B09,  // { 0x8A, 0xF0 } "嬉"
  0x5BC4,  // { 0x8A, 0xF1 } "寄"
  0x5C90,  // { 0x8A, 0xF2 } "岐"
  0x5E0C,  // { 0x8A, 0xF3 } "希"
  0x5E7E,  // { 0x8A, 0xF4 } "幾"
  0x5FCC,  // { 0x8A, 0xF5 } "忌"
  0x63EE,  // { 0x8A, 0xF6 } "揮"
  0x673A,  // { 0x8A, 0xF7 } "机"
  0x65D7,  // { 0x8A, 0xF8 } "旗"
  0x65E2,  // { 0x8A, 0xF9 } "既"
  0x671F,  // { 0x8A, 0xFA } "期"
  0x68CB,  // { 0x8A, 0xFB } "棋"
  0x68C4,  // { 0x8A, 0xFC } "棄"
  0x0000,  // { 0x8A, 0xFD }
  0x0000,  // { 0x8A, 0xFE }
  0x0000,  // { 0x8A, 0xFF }
  0x6A5F,  // { 0x8B, 0x40 } "機"
  0x5E30,  // { 0x8B, 0x41 } "帰"
  0x6BC5,  // { 0x8B, 0x42 } "毅"
  0x6C17,  // { 0x8B, 0x43 } "気"
  0x6C7D,  // { 0x8B, 0x44 } "汽"
  0x757F,  // { 0x8B, 0x45 } "畿"
  0x7948,  // { 0x8B, 0x46 } "祈"
  0x5B63,  // { 0x8B, 0x47 } "季"
  0x7A00,  // { 0x8B, 0x48 } "稀"
  0x7D00,  // { 0x8B, 0x49 } "紀"
  0x5FBD,  // { 0x8B, 0x4A } "徽"
  0x898F,  // { 0x8B, 0x4B } "規"
  0x8A18,  // { 0x8B, 0x4C } "記"
  0x8CB4,  // { 0x8B, 0x4D } "貴"
  0x8D77,  // { 0x8B, 0x4E } "起"
  0x8ECC,  // { 0x8B, 0x4F } "軌"
  0x8F1D,  // { 0x8B, 0x50 } "輝"
  0x98E2,  // { 0x8B, 0x51 } "飢"
  0x9A0E,  // { 0x8B, 0x52 } "騎"
  0x9B3C,  // { 0x8B, 0x53 } "鬼"
  0x4E80,  // { 0x8B, 0x54 } "亀"
  0x507D,  // { 0x8B, 0x55 } "偽"
  0x5100,  // { 0x8B, 0x56 } "儀"
  0x5993,  // { 0x8B, 0x57 } "妓"
  0x5B9C,  // { 0x8B, 0x58 } "宜"
  0x622F,  // { 0x8B, 0x59 } "戯"
  0x6280,  // { 0x8B, 0x5A } "技"
  0x64EC,  // { 0x8B, 0x5B } "擬"
  0x6B3A,  // { 0x8B, 0x5C } "欺"
  0x72A0,  // { 0x8B, 0x5D } "犠"
  0x7591,  // { 0x8B, 0x5E } "疑"
  0x7947,  // { 0x8B, 0x5F } "祇"
  0x7FA9,  // { 0x8B, 0x60 } "義"
  0x87FB,  // { 0x8B, 0x61 } "蟻"
  0x8ABC,  // { 0x8B, 0x62 } "誼"
  0x8B70,  // { 0x8B, 0x63 } "議"
  0x63AC,  // { 0x8B, 0x64 } "掬"
  0x83CA,  // { 0x8B, 0x65 } "菊"
  0x97A0,  // { 0x8B, 0x66 } "鞠"
  0x5409,  // { 0x8B, 0x67 } "吉"
  0x5403,  // { 0x8B, 0x68 } "吃"
  0x55AB,  // { 0x8B, 0x69 } "喫"
  0x6854,  // { 0x8B, 0x6A } "桔"
  0x6A58,  // { 0x8B, 0x6B } "橘"
  0x8A70,  // { 0x8B, 0x6C } "詰"
  0x7827,  // { 0x8B, 0x6D } "砧"
  0x6775,  // { 0x8B, 0x6E } "杵"
  0x9ECD,  // { 0x8B, 0x6F } "黍"
  0x5374,  // { 0x8B, 0x70 } "却"
  0x5BA2,  // { 0x8B, 0x71 } "客"
  0x811A,  // { 0x8B, 0x72 } "脚"
  0x8650,  // { 0x8B, 0x73 } "虐"
  0x9006,  // { 0x8B, 0x74 } "逆"
  0x4E18,  // { 0x8B, 0x75 } "丘"
  0x4E45,  // { 0x8B, 0x76 } "久"
  0x4EC7,  // { 0x8B, 0x77 } "仇"
  0x4F11,  // { 0x8B, 0x78 } "休"
  0x53CA,  // { 0x8B, 0x79 } "及"
  0x5438,  // { 0x8B, 0x7A } "吸"
  0x5BAE,  // { 0x8B, 0x7B } "宮"
  0x5F13,  // { 0x8B, 0x7C } "弓"
  0x6025,  // { 0x8B, 0x7D } "急"
  0x6551,  // { 0x8B, 0x7E } "救"
  0x673D,  // { 0x8B, 0x80 } "朽"
  0x6C42,  // { 0x8B, 0x81 } "求"
  0x6C72,  // { 0x8B, 0x82 } "汲"
  0x6CE3,  // { 0x8B, 0x83 } "泣"
  0x7078,  // { 0x8B, 0x84 } "灸"
  0x7403,  // { 0x8B, 0x85 } "球"
  0x7A76,  // { 0x8B, 0x86 } "究"
  0x7AAE,  // { 0x8B, 0x87 } "窮"
  0x7B08,  // { 0x8B, 0x88 } "笈"
  0x7D1A,  // { 0x8B, 0x89 } "級"
  0x7CFE,  // { 0x8B, 0x8A } "糾"
  0x7D66,  // { 0x8B, 0x8B } "給"
  0x65E7,  // { 0x8B, 0x8C } "旧"
  0x725B,  // { 0x8B, 0x8D } "牛"
  0x53BB,  // { 0x8B, 0x8E } "去"
  0x5C45,  // { 0x8B, 0x8F } "居"
  0x5DE8,  // { 0x8B, 0x90 } "巨"
  0x62D2,  // { 0x8B, 0x91 } "拒"
  0x62E0,  // { 0x8B, 0x92 } "拠"
  0x6319,  // { 0x8B, 0x93 } "挙"
  0x6E20,  // { 0x8B, 0x94 } "渠"
  0x865A,  // { 0x8B, 0x95 } "虚"
  0x8A31,  // { 0x8B, 0x96 } "許"
  0x8DDD,  // { 0x8B, 0x97 } "距"
  0x92F8,  // { 0x8B, 0x98 } "鋸"
  0x6F01,  // { 0x8B, 0x99 } "漁"
  0x79A6,  // { 0x8B, 0x9A } "禦"
  0x9B5A,  // { 0x8B, 0x9B } "魚"
  0x4EA8,  // { 0x8B, 0x9C } "亨"
  0x4EAB,  // { 0x8B, 0x9D } "享"
  0x4EAC,  // { 0x8B, 0x9E } "京"
  0x4F9B,  // { 0x8B, 0x9F } "供"
  0x4FA0,  // { 0x8B, 0xA0 } "侠"
  0x50D1,  // { 0x8B, 0xA1 } "僑"
  0x5147,  // { 0x8B, 0xA2 } "兇"
  0x7AF6,  // { 0x8B, 0xA3 } "競"
  0x5171,  // { 0x8B, 0xA4 } "共"
  0x51F6,  // { 0x8B, 0xA5 } "凶"
  0x5354,  // { 0x8B, 0xA6 } "協"
  0x5321,  // { 0x8B, 0xA7 } "匡"
  0x537F,  // { 0x8B, 0xA8 } "卿"
  0x53EB,  // { 0x8B, 0xA9 } "叫"
  0x55AC,  // { 0x8B, 0xAA } "喬"
  0x5883,  // { 0x8B, 0xAB } "境"
  0x5CE1,  // { 0x8B, 0xAC } "峡"
  0x5F37,  // { 0x8B, 0xAD } "強"
  0x5F4A,  // { 0x8B, 0xAE } "彊"
  0x602F,  // { 0x8B, 0xAF } "怯"
  0x6050,  // { 0x8B, 0xB0 } "恐"
  0x606D,  // { 0x8B, 0xB1 } "恭"
  0x631F,  // { 0x8B, 0xB2 } "挟"
  0x6559,  // { 0x8B, 0xB3 } "教"
  0x6A4B,  // { 0x8B, 0xB4 } "橋"
  0x6CC1,  // { 0x8B, 0xB5 } "況"
  0x72C2,  // { 0x8B, 0xB6 } "狂"
  0x72ED,  // { 0x8B, 0xB7 } "狭"
  0x77EF,  // { 0x8B, 0xB8 } "矯"
  0x80F8,  // { 0x8B, 0xB9 } "胸"
  0x8105,  // { 0x8B, 0xBA } "脅"
  0x8208,  // { 0x8B, 0xBB } "興"
  0x854E,  // { 0x8B, 0xBC } "蕎"
  0x90F7,  // { 0x8B, 0xBD } "郷"
  0x93E1,  // { 0x8B, 0xBE } "鏡"
  0x97FF,  // { 0x8B, 0xBF } "響"
  0x9957,  // { 0x8B, 0xC0 } "饗"
  0x9A5A,  // { 0x8B, 0xC1 } "驚"
  0x4EF0,  // { 0x8B, 0xC2 } "仰"
  0x51DD,  // { 0x8B, 0xC3 } "凝"
  0x5C2D,  // { 0x8B, 0xC4 } "尭"
  0x6681,  // { 0x8B, 0xC5 } "暁"
  0x696D,  // { 0x8B, 0xC6 } "業"
  0x5C40,  // { 0x8B, 0xC7 } "局"
  0x66F2,  // { 0x8B, 0xC8 } "曲"
  0x6975,  // { 0x8B, 0xC9 } "極"
  0x7389,  // { 0x8B, 0xCA } "玉"
  0x6850,  // { 0x8B, 0xCB } "桐"
  0x7C81,  // { 0x8B, 0xCC } "粁"
  0x50C5,  // { 0x8B, 0xCD } "僅"
  0x52E4,  // { 0x8B, 0xCE } "勤"
  0x5747,  // { 0x8B, 0xCF } "均"
  0x5DFE,  // { 0x8B, 0xD0 } "巾"
  0x9326,  // { 0x8B, 0xD1 } "錦"
  0x65A4,  // { 0x8B, 0xD2 } "斤"
  0x6B23,  // { 0x8B, 0xD3 } "欣"
  0x6B3D,  // { 0x8B, 0xD4 } "欽"
  0x7434,  // { 0x8B, 0xD5 } "琴"
  0x7981,  // { 0x8B, 0xD6 } "禁"
  0x79BD,  // { 0x8B, 0xD7 } "禽"
  0x7B4B,  // { 0x8B, 0xD8 } "筋"
  0x7DCA,  // { 0x8B, 0xD9 } "緊"
  0x82B9,  // { 0x8B, 0xDA } "芹"
  0x83CC,  // { 0x8B, 0xDB } "菌"
  0x887F,  // { 0x8B, 0xDC } "衿"
  0x895F,  // { 0x8B, 0xDD } "襟"
  0x8B39,  // { 0x8B, 0xDE } "謹"
  0x8FD1,  // { 0x8B, 0xDF } "近"
  0x91D1,  // { 0x8B, 0xE0 } "金"
  0x541F,  // { 0x8B, 0xE1 } "吟"
  0x9280,  // { 0x8B, 0xE2 } "銀"
  0x4E5D,  // { 0x8B, 0xE3 } "九"
  0x5036,  // { 0x8B, 0xE4 } "倶"
  0x53E5,  // { 0x8B, 0xE5 } "句"
  0x533A,  // { 0x8B, 0xE6 } "区"
  0x72D7,  // { 0x8B, 0xE7 } "狗"
  0x7396,  // { 0x8B, 0xE8 } "玖"
  0x77E9,  // { 0x8B, 0xE9 } "矩"
  0x82E6,  // { 0x8B, 0xEA } "苦"
  0x8EAF,  // { 0x8B, 0xEB } "躯"
  0x99C6,  // { 0x8B, 0xEC } "駆"
  0x99C8,  // { 0x8B, 0xED } "駈"
  0x99D2,  // { 0x8B, 0xEE } "駒"
  0x5177,  // { 0x8B, 0xEF } "具"
  0x611A,  // { 0x8B, 0xF0 } "愚"
  0x865E,  // { 0x8B, 0xF1 } "虞"
  0x55B0,  // { 0x8B, 0xF2 } "喰"
  0x7A7A,  // { 0x8B, 0xF3 } "空"
  0x5076,  // { 0x8B, 0xF4 } "偶"
  0x5BD3,  // { 0x8B, 0xF5 } "寓"
  0x9047,  // { 0x8B, 0xF6 } "遇"
  0x9685,  // { 0x8B, 0xF7 } "隅"
  0x4E32,  // { 0x8B, 0xF8 } "串"
  0x6ADB,  // { 0x8B, 0xF9 } "櫛"
  0x91E7,  // { 0x8B, 0xFA } "釧"
  0x5C51,  // { 0x8B, 0xFB } "屑"
  0x5C48,  // { 0x8B, 0xFC } "屈"
  0x0000,  // { 0x8B, 0xFD }
  0x0000,  // { 0x8B, 0xFE }
  0x0000,  // { 0x8B, 0xFF }
  0x6398,  // { 0x8C, 0x40 } "掘"
  0x7A9F,  // { 0x8C, 0x41 } "窟"
  0x6C93,  // { 0x8C, 0x42 } "沓"
  0x9774,  // { 0x8C, 0x43 } "靴"
  0x8F61,  // { 0x8C, 0x44 } "轡"
  0x7AAA,  // { 0x8C, 0x45 } "窪"
  0x718A,  // { 0x8C, 0x46 } "熊"
  0x9688,  // { 0x8C, 0x47 } "隈"
  0x7C82,  // { 0x8C, 0x48 } "粂"
  0x6817,  // { 0x8C, 0x49 } "栗"
  0x7E70,  // { 0x8C, 0x4A } "繰"
  0x6851,  // { 0x8C, 0x4B } "桑"
  0x936C,  // { 0x8C, 0x4C } "鍬"
  0x52F2,  // { 0x8C, 0x4D } "勲"
  0x541B,  // { 0x8C, 0x4E } "君"
  0x85AB,  // { 0x8C, 0x4F } "薫"
  0x8A13,  // { 0x8C, 0x50 } "訓"
  0x7FA4,  // { 0x8C, 0x51 } "群"
  0x8ECD,  // { 0x8C, 0x52 } "軍"
  0x90E1,  // { 0x8C, 0x53 } "郡"
  0x5366,  // { 0x8C, 0x54 } "卦"
  0x8888,  // { 0x8C, 0x55 } "袈"
  0x7941,  // { 0x8C, 0x56 } "祁"
  0x4FC2,  // { 0x8C, 0x57 } "係"
  0x50BE,  // { 0x8C, 0x58 } "傾"
  0x5211,  // { 0x8C, 0x59 } "刑"
  0x5144,  // { 0x8C, 0x5A } "兄"
  0x5553,  // { 0x8C, 0x5B } "啓"
  0x572D,  // { 0x8C, 0x5C } "圭"
  0x73EA,  // { 0x8C, 0x5D } "珪"
  0x578B,  // { 0x8C, 0x5E } "型"
  0x5951,  // { 0x8C, 0x5F } "契"
  0x5F62,  // { 0x8C, 0x60 } "形"
  0x5F84,  // { 0x8C, 0x61 } "径"
  0x6075,  // { 0x8C, 0x62 } "恵"
  0x6176,  // { 0x8C, 0x63 } "慶"
  0x6167,  // { 0x8C, 0x64 } "慧"
  0x61A9,  // { 0x8C, 0x65 } "憩"
  0x63B2,  // { 0x8C, 0x66 } "掲"
  0x643A,  // { 0x8C, 0x67 } "携"
  0x656C,  // { 0x8C, 0x68 } "敬"
  0x666F,  // { 0x8C, 0x69 } "景"
  0x6842,  // { 0x8C, 0x6A } "桂"
  0x6E13,  // { 0x8C, 0x6B } "渓"
  0x7566,  // { 0x8C, 0x6C } "畦"
  0x7A3D,  // { 0x8C, 0x6D } "稽"
  0x7CFB,  // { 0x8C, 0x6E } "系"
  0x7D4C,  // { 0x8C, 0x6F } "経"
  0x7D99,  // { 0x8C, 0x70 } "継"
  0x7E4B,  // { 0x8C, 0x71 } "繋"
  0x7F6B,  // { 0x8C, 0x72 } "罫"
  0x830E,  // { 0x8C, 0x73 } "茎"
  0x834A,  // { 0x8C, 0x74 } "荊"
  0x86CD,  // { 0x8C, 0x75 } "蛍"
  0x8A08,  // { 0x8C, 0x76 } "計"
  0x8A63,  // { 0x8C, 0x77 } "詣"
  0x8B66,  // { 0x8C, 0x78 } "警"
  0x8EFD,  // { 0x8C, 0x79 } "軽"
  0x981A,  // { 0x8C, 0x7A } "頚"
  0x9D8F,  // { 0x8C, 0x7B } "鶏"
  0x82B8,  // { 0x8C, 0x7C } "芸"
  0x8FCE,  // { 0x8C, 0x7D } "迎"
  0x9BE8,  // { 0x8C, 0x7E } "鯨"
  0x5287,  // { 0x8C, 0x80 } "劇"
  0x621F,  // { 0x8C, 0x81 } "戟"
  0x6483,  // { 0x8C, 0x82 } "撃"
  0x6FC0,  // { 0x8C, 0x83 } "激"
  0x9699,  // { 0x8C, 0x84 } "隙"
  0x6841,  // { 0x8C, 0x85 } "桁"
  0x5091,  // { 0x8C, 0x86 } "傑"
  0x6B20,  // { 0x8C, 0x87 } "欠"
  0x6C7A,  // { 0x8C, 0x88 } "決"
  0x6F54,  // { 0x8C, 0x89 } "潔"
  0x7A74,  // { 0x8C, 0x8A } "穴"
  0x7D50,  // { 0x8C, 0x8B } "結"
  0x8840,  // { 0x8C, 0x8C } "血"
  0x8A23,  // { 0x8C, 0x8D } "訣"
  0x6708,  // { 0x8C, 0x8E } "月"
  0x4EF6,  // { 0x8C, 0x8F } "件"
  0x5039,  // { 0x8C, 0x90 } "倹"
  0x5026,  // { 0x8C, 0x91 } "倦"
  0x5065,  // { 0x8C, 0x92 } "健"
  0x517C,  // { 0x8C, 0x93 } "兼"
  0x5238,  // { 0x8C, 0x94 } "券"
  0x5263,  // { 0x8C, 0x95 } "剣"
  0x55A7,  // { 0x8C, 0x96 } "喧"
  0x570F,  // { 0x8C, 0x97 } "圏"
  0x5805,  // { 0x8C, 0x98 } "堅"
  0x5ACC,  // { 0x8C, 0x99 } "嫌"
  0x5EFA,  // { 0x8C, 0x9A } "建"
  0x61B2,  // { 0x8C, 0x9B } "憲"
  0x61F8,  // { 0x8C, 0x9C } "懸"
  0x62F3,  // { 0x8C, 0x9D } "拳"
  0x6372,  // { 0x8C, 0x9E } "捲"
  0x691C,  // { 0x8C, 0x9F } "検"
  0x6A29,  // { 0x8C, 0xA0 } "権"
  0x727D,  // { 0x8C, 0xA1 } "牽"
  0x72AC,  // { 0x8C, 0xA2 } "犬"
  0x732E,  // { 0x8C, 0xA3 } "献"
  0x7814,  // { 0x8C, 0xA4 } "研"
  0x786F,  // { 0x8C, 0xA5 } "硯"
  0x7D79,  // { 0x8C, 0xA6 } "絹"
  0x770C,  // { 0x8C, 0xA7 } "県"
  0x80A9,  // { 0x8C, 0xA8 } "肩"
  0x898B,  // { 0x8C, 0xA9 } "見"
  0x8B19,  // { 0x8C, 0xAA } "謙"
  0x8CE2,  // { 0x8C, 0xAB } "賢"
  0x8ED2,  // { 0x8C, 0xAC } "軒"
  0x9063,  // { 0x8C, 0xAD } "遣"
  0x9375,  // { 0x8C, 0xAE } "鍵"
  0x967A,  // { 0x8C, 0xAF } "険"
  0x9855,  // { 0x8C, 0xB0 } "顕"
  0x9A13,  // { 0x8C, 0xB1 } "験"
  0x9E78,  // { 0x8C, 0xB2 } "鹸"
  0x5143,  // { 0x8C, 0xB3 } "元"
  0x539F,  // { 0x8C, 0xB4 } "原"
  0x53B3,  // { 0x8C, 0xB5 } "厳"
  0x5E7B,  // { 0x8C, 0xB6 } "幻"
  0x5F26,  // { 0x8C, 0xB7 } "弦"
  0x6E1B,  // { 0x8C, 0xB8 } "減"
  0x6E90,  // { 0x8C, 0xB9 } "源"
  0x7384,  // { 0x8C, 0xBA } "玄"
  0x73FE,  // { 0x8C, 0xBB } "現"
  0x7D43,  // { 0x8C, 0xBC } "絃"
  0x8237,  // { 0x8C, 0xBD } "舷"
  0x8A00,  // { 0x8C, 0xBE } "言"
  0x8AFA,  // { 0x8C, 0xBF } "諺"
  0x9650,  // { 0x8C, 0xC0 } "限"
  0x4E4E,  // { 0x8C, 0xC1 } "乎"
  0x500B,  // { 0x8C, 0xC2 } "個"
  0x53E4,  // { 0x8C, 0xC3 } "古"
  0x547C,  // { 0x8C, 0xC4 } "呼"
  0x56FA,  // { 0x8C, 0xC5 } "固"
  0x59D1,  // { 0x8C, 0xC6 } "姑"
  0x5B64,  // { 0x8C, 0xC7 } "孤"
  0x5DF1,  // { 0x8C, 0xC8 } "己"
  0x5EAB,  // { 0x8C, 0xC9 } "庫"
  0x5F27,  // { 0x8C, 0xCA } "弧"
  0x6238,  // { 0x8C, 0xCB } "戸"
  0x6545,  // { 0x8C, 0xCC } "故"
  0x67AF,  // { 0x8C, 0xCD } "枯"
  0x6E56,  // { 0x8C, 0xCE } "湖"
  0x72D0,  // { 0x8C, 0xCF } "狐"
  0x7CCA,  // { 0x8C, 0xD0 } "糊"
  0x88B4,  // { 0x8C, 0xD1 } "袴"
  0x80A1,  // { 0x8C, 0xD2 } "股"
  0x80E1,  // { 0x8C, 0xD3 } "胡"
  0x83F0,  // { 0x8C, 0xD4 } "菰"
  0x864E,  // { 0x8C, 0xD5 } "虎"
  0x8A87,  // { 0x8C, 0xD6 } "誇"
  0x8DE8,  // { 0x8C, 0xD7 } "跨"
  0x9237,  // { 0x8C, 0xD8 } "鈷"
  0x96C7,  // { 0x8C, 0xD9 } "雇"
  0x9867,  // { 0x8C, 0xDA } "顧"
  0x9F13,  // { 0x8C, 0xDB } "鼓"
  0x4E94,  // { 0x8C, 0xDC } "五"
  0x4E92,  // { 0x8C, 0xDD } "互"
  0x4F0D,  // { 0x8C, 0xDE } "伍"
  0x5348,  // { 0x8C, 0xDF } "午"
  0x5449,  // { 0x8C, 0xE0 } "呉"
  0x543E,  // { 0x8C, 0xE1 } "吾"
  0x5A2F,  // { 0x8C, 0xE2 } "娯"
  0x5F8C,  // { 0x8C, 0xE3 } "後"
  0x5FA1,  // { 0x8C, 0xE4 } "御"
  0x609F,  // { 0x8C, 0xE5 } "悟"
  0x68A7,  // { 0x8C, 0xE6 } "梧"
  0x6A8E,  // { 0x8C, 0xE7 } "檎"
  0x745A,  // { 0x8C, 0xE8 } "瑚"
  0x7881,  // { 0x8C, 0xE9 } "碁"
  0x8A9E,  // { 0x8C, 0xEA } "語"
  0x8AA4,  // { 0x8C, 0xEB } "誤"
  0x8B77,  // { 0x8C, 0xEC } "護"
  0x9190,  // { 0x8C, 0xED } "醐"
  0x4E5E,  // { 0x8C, 0xEE } "乞"
  0x9BC9,  // { 0x8C, 0xEF } "鯉"
  0x4EA4,  // { 0x8C, 0xF0 } "交"
  0x4F7C,  // { 0x8C, 0xF1 } "佼"
  0x4FAF,  // { 0x8C, 0xF2 } "侯"
  0x5019,  // { 0x8C, 0xF3 } "候"
  0x5016,  // { 0x8C, 0xF4 } "倖"
  0x5149,  // { 0x8C, 0xF5 } "光"
  0x516C,  // { 0x8C, 0xF6 } "公"
  0x529F,  // { 0x8C, 0xF7 } "功"
  0x52B9,  // { 0x8C, 0xF8 } "効"
  0x52FE,  // { 0x8C, 0xF9 } "勾"
  0x539A,  // { 0x8C, 0xFA } "厚"
  0x53E3,  // { 0x8C, 0xFB } "口"
  0x5411,  // { 0x8C, 0xFC } "向"
  0x0000,  // { 0x8C, 0xFD }
  0x0000,  // { 0x8C, 0xFE }
  0x0000,  // { 0x8C, 0xFF }
  0x540E,  // { 0x8D, 0x40 } "后"
  0x5589,  // { 0x8D, 0x41 } "喉"
  0x5751,  // { 0x8D, 0x42 } "坑"
  0x57A2,  // { 0x8D, 0x43 } "垢"
  0x597D,  // { 0x8D, 0x44 } "好"
  0x5B54,  // { 0x8D, 0x45 } "孔"
  0x5B5D,  // { 0x8D, 0x46 } "孝"
  0x5B8F,  // { 0x8D, 0x47 } "宏"
  0x5DE5,  // { 0x8D, 0x48 } "工"
  0x5DE7,  // { 0x8D, 0x49 } "巧"
  0x5DF7,  // { 0x8D, 0x4A } "巷"
  0x5E78,  // { 0x8D, 0x4B } "幸"
  0x5E83,  // { 0x8D, 0x4C } "広"
  0x5E9A,  // { 0x8D, 0x4D } "庚"
  0x5EB7,  // { 0x8D, 0x4E } "康"
  0x5F18,  // { 0x8D, 0x4F } "弘"
  0x6052,  // { 0x8D, 0x50 } "恒"
  0x614C,  // { 0x8D, 0x51 } "慌"
  0x6297,  // { 0x8D, 0x52 } "抗"
  0x62D8,  // { 0x8D, 0x53 } "拘"
  0x63A7,  // { 0x8D, 0x54 } "控"
  0x653B,  // { 0x8D, 0x55 } "攻"
  0x6602,  // { 0x8D, 0x56 } "昂"
  0x6643,  // { 0x8D, 0x57 } "晃"
  0x66F4,  // { 0x8D, 0x58 } "更"
  0x676D,  // { 0x8D, 0x59 } "杭"
  0x6821,  // { 0x8D, 0x5A } "校"
  0x6897,  // { 0x8D, 0x5B } "梗"
  0x69CB,  // { 0x8D, 0x5C } "構"
  0x6C5F,  // { 0x8D, 0x5D } "江"
  0x6D2A,  // { 0x8D, 0x5E } "洪"
  0x6D69,  // { 0x8D, 0x5F } "浩"
  0x6E2F,  // { 0x8D, 0x60 } "港"
  0x6E9D,  // { 0x8D, 0x61 } "溝"
  0x7532,  // { 0x8D, 0x62 } "甲"
  0x7687,  // { 0x8D, 0x63 } "皇"
  0x786C,  // { 0x8D, 0x64 } "硬"
  0x7A3F,  // { 0x8D, 0x65 } "稿"
  0x7CE0,  // { 0x8D, 0x66 } "糠"
  0x7D05,  // { 0x8D, 0x67 } "紅"
  0x7D18,  // { 0x8D, 0x68 } "紘"
  0x7D5E,  // { 0x8D, 0x69 } "絞"
  0x7DB1,  // { 0x8D, 0x6A } "綱"
  0x8015,  // { 0x8D, 0x6B } "耕"
  0x8003,  // { 0x8D, 0x6C } "考"
  0x80AF,  // { 0x8D, 0x6D } "肯"
  0x80B1,  // { 0x8D, 0x6E } "肱"
  0x8154,  // { 0x8D, 0x6F } "腔"
  0x818F,  // { 0x8D, 0x70 } "膏"
  0x822A,  // { 0x8D, 0x71 } "航"
  0x8352,  // { 0x8D, 0x72 } "荒"
  0x884C,  // { 0x8D, 0x73 } "行"
  0x8861,  // { 0x8D, 0x74 } "衡"
  0x8B1B,  // { 0x8D, 0x75 } "講"
  0x8CA2,  // { 0x8D, 0x76 } "貢"
  0x8CFC,  // { 0x8D, 0x77 } "購"
  0x90CA,  // { 0x8D, 0x78 } "郊"
  0x9175,  // { 0x8D, 0x79 } "酵"
  0x9271,  // { 0x8D, 0x7A } "鉱"
  0x783F,  // { 0x8D, 0x7B } "砿"
  0x92FC,  // { 0x8D, 0x7C } "鋼"
  0x95A4,  // { 0x8D, 0x7D } "閤"
  0x964D,  // { 0x8D, 0x7E } "降"
  0x9805,  // { 0x8D, 0x80 } "項"
  0x9999,  // { 0x8D, 0x81 } "香"
  0x9AD8,  // { 0x8D, 0x82 } "高"
  0x9D3B,  // { 0x8D, 0x83 } "鴻"
  0x525B,  // { 0x8D, 0x84 } "剛"
  0x52AB,  // { 0x8D, 0x85 } "劫"
  0x53F7,  // { 0x8D, 0x86 } "号"
  0x5408,  // { 0x8D, 0x87 } "合"
  0x58D5,  // { 0x8D, 0x88 } "壕"
  0x62F7,  // { 0x8D, 0x89 } "拷"
  0x6FE0,  // { 0x8D, 0x8A } "濠"
  0x8C6A,  // { 0x8D, 0x8B } "豪"
  0x8F5F,  // { 0x8D, 0x8C } "轟"
  0x9EB9,  // { 0x8D, 0x8D } "麹"
  0x514B,  // { 0x8D, 0x8E } "克"
  0x523B,  // { 0x8D, 0x8F } "刻"
  0x544A,  // { 0x8D, 0x90 } "告"
  0x56FD,  // { 0x8D, 0x91 } "国"
  0x7A40,  // { 0x8D, 0x92 } "穀"
  0x9177,  // { 0x8D, 0x93 } "酷"
  0x9D60,  // { 0x8D, 0x94 } "鵠"
  0x9ED2,  // { 0x8D, 0x95 } "黒"
  0x7344,  // { 0x8D, 0x96 } "獄"
  0x6F09,  // { 0x8D, 0x97 } "漉"
  0x8170,  // { 0x8D, 0x98 } "腰"
  0x7511,  // { 0x8D, 0x99 } "甑"
  0x5FFD,  // { 0x8D, 0x9A } "忽"
  0x60DA,  // { 0x8D, 0x9B } "惚"
  0x9AA8,  // { 0x8D, 0x9C } "骨"
  0x72DB,  // { 0x8D, 0x9D } "狛"
  0x8FBC,  // { 0x8D, 0x9E } "込"
  0x6B64,  // { 0x8D, 0x9F } "此"
  0x9803,  // { 0x8D, 0xA0 } "頃"
  0x4ECA,  // { 0x8D, 0xA1 } "今"
  0x56F0,  // { 0x8D, 0xA2 } "困"
  0x5764,  // { 0x8D, 0xA3 } "坤"
  0x58BE,  // { 0x8D, 0xA4 } "墾"
  0x5A5A,  // { 0x8D, 0xA5 } "婚"
  0x6068,  // { 0x8D, 0xA6 } "恨"
  0x61C7,  // { 0x8D, 0xA7 } "懇"
  0x660F,  // { 0x8D, 0xA8 } "昏"
  0x6606,  // { 0x8D, 0xA9 } "昆"
  0x6839,  // { 0x8D, 0xAA } "根"
  0x68B1,  // { 0x8D, 0xAB } "梱"
  0x6DF7,  // { 0x8D, 0xAC } "混"
  0x75D5,  // { 0x8D, 0xAD } "痕"
  0x7D3A,  // { 0x8D, 0xAE } "紺"
  0x826E,  // { 0x8D, 0xAF } "艮"
  0x9B42,  // { 0x8D, 0xB0 } "魂"
  0x4E9B,  // { 0x8D, 0xB1 } "些"
  0x4F50,  // { 0x8D, 0xB2 } "佐"
  0x53C9,  // { 0x8D, 0xB3 } "叉"
  0x5506,  // { 0x8D, 0xB4 } "唆"
  0x5D6F,  // { 0x8D, 0xB5 } "嵯"
  0x5DE6,  // { 0x8D, 0xB6 } "左"
  0x5DEE,  // { 0x8D, 0xB7 } "差"
  0x67FB,  // { 0x8D, 0xB8 } "査"
  0x6C99,  // { 0x8D, 0xB9 } "沙"
  0x7473,  // { 0x8D, 0xBA } "瑳"
  0x7802,  // { 0x8D, 0xBB } "砂"
  0x8A50,  // { 0x8D, 0xBC } "詐"
  0x9396,  // { 0x8D, 0xBD } "鎖"
  0x88DF,  // { 0x8D, 0xBE } "裟"
  0x5750,  // { 0x8D, 0xBF } "坐"
  0x5EA7,  // { 0x8D, 0xC0 } "座"
  0x632B,  // { 0x8D, 0xC1 } "挫"
  0x50B5,  // { 0x8D, 0xC2 } "債"
  0x50AC,  // { 0x8D, 0xC3 } "催"
  0x518D,  // { 0x8D, 0xC4 } "再"
  0x6700,  // { 0x8D, 0xC5 } "最"
  0x54C9,  // { 0x8D, 0xC6 } "哉"
  0x585E,  // { 0x8D, 0xC7 } "塞"
  0x59BB,  // { 0x8D, 0xC8 } "妻"
  0x5BB0,  // { 0x8D, 0xC9 } "宰"
  0x5F69,  // { 0x8D, 0xCA } "彩"
  0x624D,  // { 0x8D, 0xCB } "才"
  0x63A1,  // { 0x8D, 0xCC } "採"
  0x683D,  // { 0x8D, 0xCD } "栽"
  0x6B73,  // { 0x8D, 0xCE } "歳"
  0x6E08,  // { 0x8D, 0xCF } "済"
  0x707D,  // { 0x8D, 0xD0 } "災"
  0x91C7,  // { 0x8D, 0xD1 } "采"
  0x7280,  // { 0x8D, 0xD2 } "犀"
  0x7815,  // { 0x8D, 0xD3 } "砕"
  0x7826,  // { 0x8D, 0xD4 } "砦"
  0x796D,  // { 0x8D, 0xD5 } "祭"
  0x658E,  // { 0x8D, 0xD6 } "斎"
  0x7D30,  // { 0x8D, 0xD7 } "細"
  0x83DC,  // { 0x8D, 0xD8 } "菜"
  0x88C1,  // { 0x8D, 0xD9 } "裁"
  0x8F09,  // { 0x8D, 0xDA } "載"
  0x969B,  // { 0x8D, 0xDB } "際"
  0x5264,  // { 0x8D, 0xDC } "剤"
  0x5728,  // { 0x8D, 0xDD } "在"
  0x6750,  // { 0x8D, 0xDE } "材"
  0x7F6A,  // { 0x8D, 0xDF } "罪"
  0x8CA1,  // { 0x8D, 0xE0 } "財"
  0x51B4,  // { 0x8D, 0xE1 } "冴"
  0x5742,  // { 0x8D, 0xE2 } "坂"
  0x962A,  // { 0x8D, 0xE3 } "阪"
  0x583A,  // { 0x8D, 0xE4 } "堺"
  0x698A,  // { 0x8D, 0xE5 } "榊"
  0x80B4,  // { 0x8D, 0xE6 } "肴"
  0x54B2,  // { 0x8D, 0xE7 } "咲"
  0x5D0E,  // { 0x8D, 0xE8 } "崎"
  0x57FC,  // { 0x8D, 0xE9 } "埼"
  0x7895,  // { 0x8D, 0xEA } "碕"
  0x9DFA,  // { 0x8D, 0xEB } "鷺"
  0x4F5C,  // { 0x8D, 0xEC } "作"
  0x524A,  // { 0x8D, 0xED } "削"
  0x548B,  // { 0x8D, 0xEE } "咋"
  0x643E,  // { 0x8D, 0xEF } "搾"
  0x6628,  // { 0x8D, 0xF0 } "昨"
  0x6714,  // { 0x8D, 0xF1 } "朔"
  0x67F5,  // { 0x8D, 0xF2 } "柵"
  0x7A84,  // { 0x8D, 0xF3 } "窄"
  0x7B56,  // { 0x8D, 0xF4 } "策"
  0x7D22,  // { 0x8D, 0xF5 } "索"
  0x932F,  // { 0x8D, 0xF6 } "錯"
  0x685C,  // { 0x8D, 0xF7 } "桜"
  0x9BAD,  // { 0x8D, 0xF8 } "鮭"
  0x7B39,  // { 0x8D, 0xF9 } "笹"
  0x5319,  // { 0x8D, 0xFA } "匙"
  0x518A,  // { 0x8D, 0xFB } "冊"
  0x5237,  // { 0x8D, 0xFC } "刷"
  0x0000,  // { 0x8D, 0xFD }
  0x0000,  // { 0x8D, 0xFE }
  0x0000,  // { 0x8D, 0xFF }
  0x5BDF,  // { 0x8E, 0x40 } "察"
  0x62F6,  // { 0x8E, 0x41 } "拶"
  0x64AE,  // { 0x8E, 0x42 } "撮"
  0x64E6,  // { 0x8E, 0x43 } "擦"
  0x672D,  // { 0x8E, 0x44 } "札"
  0x6BBA,  // { 0x8E, 0x45 } "殺"
  0x85A9,  // { 0x8E, 0x46 } "薩"
  0x96D1,  // { 0x8E, 0x47 } "雑"
  0x7690,  // { 0x8E, 0x48 } "皐"
  0x9BD6,  // { 0x8E, 0x49 } "鯖"
  0x634C,  // { 0x8E, 0x4A } "捌"
  0x9306,  // { 0x8E, 0x4B } "錆"
  0x9BAB,  // { 0x8E, 0x4C } "鮫"
  0x76BF,  // { 0x8E, 0x4D } "皿"
  0x6652,  // { 0x8E, 0x4E } "晒"
  0x4E09,  // { 0x8E, 0x4F } "三"
  0x5098,  // { 0x8E, 0x50 } "傘"
  0x53C2,  // { 0x8E, 0x51 } "参"
  0x5C71,  // { 0x8E, 0x52 } "山"
  0x60E8,  // { 0x8E, 0x53 } "惨"
  0x6492,  // { 0x8E, 0x54 } "撒"
  0x6563,  // { 0x8E, 0x55 } "散"
  0x685F,  // { 0x8E, 0x56 } "桟"
  0x71E6,  // { 0x8E, 0x57 } "燦"
  0x73CA,  // { 0x8E, 0x58 } "珊"
  0x7523,  // { 0x8E, 0x59 } "産"
  0x7B97,  // { 0x8E, 0x5A } "算"
  0x7E82,  // { 0x8E, 0x5B } "纂"
  0x8695,  // { 0x8E, 0x5C } "蚕"
  0x8B83,  // { 0x8E, 0x5D } "讃"
  0x8CDB,  // { 0x8E, 0x5E } "賛"
  0x9178,  // { 0x8E, 0x5F } "酸"
  0x9910,  // { 0x8E, 0x60 } "餐"
  0x65AC,  // { 0x8E, 0x61 } "斬"
  0x66AB,  // { 0x8E, 0x62 } "暫"
  0x6B8B,  // { 0x8E, 0x63 } "残"
  0x4ED5,  // { 0x8E, 0x64 } "仕"
  0x4ED4,  // { 0x8E, 0x65 } "仔"
  0x4F3A,  // { 0x8E, 0x66 } "伺"
  0x4F7F,  // { 0x8E, 0x67 } "使"
  0x523A,  // { 0x8E, 0x68 } "刺"
  0x53F8,  // { 0x8E, 0x69 } "司"
  0x53F2,  // { 0x8E, 0x6A } "史"
  0x55E3,  // { 0x8E, 0x6B } "嗣"
  0x56DB,  // { 0x8E, 0x6C } "四"
  0x58EB,  // { 0x8E, 0x6D } "士"
  0x59CB,  // { 0x8E, 0x6E } "始"
  0x59C9,  // { 0x8E, 0x6F } "姉"
  0x59FF,  // { 0x8E, 0x70 } "姿"
  0x5B50,  // { 0x8E, 0x71 } "子"
  0x5C4D,  // { 0x8E, 0x72 } "屍"
  0x5E02,  // { 0x8E, 0x73 } "市"
  0x5E2B,  // { 0x8E, 0x74 } "師"
  0x5FD7,  // { 0x8E, 0x75 } "志"
  0x601D,  // { 0x8E, 0x76 } "思"
  0x6307,  // { 0x8E, 0x77 } "指"
  0x652F,  // { 0x8E, 0x78 } "支"
  0x5B5C,  // { 0x8E, 0x79 } "孜"
  0x65AF,  // { 0x8E, 0x7A } "斯"
  0x65BD,  // { 0x8E, 0x7B } "施"
  0x65E8,  // { 0x8E, 0x7C } "旨"
  0x679D,  // { 0x8E, 0x7D } "枝"
  0x6B62,  // { 0x8E, 0x7E } "止"
  0x6B7B,  // { 0x8E, 0x80 } "死"
  0x6C0F,  // { 0x8E, 0x81 } "氏"
  0x7345,  // { 0x8E, 0x82 } "獅"
  0x7949,  // { 0x8E, 0x83 } "祉"
  0x79C1,  // { 0x8E, 0x84 } "私"
  0x7CF8,  // { 0x8E, 0x85 } "糸"
  0x7D19,  // { 0x8E, 0x86 } "紙"
  0x7D2B,  // { 0x8E, 0x87 } "紫"
  0x80A2,  // { 0x8E, 0x88 } "肢"
  0x8102,  // { 0x8E, 0x89 } "脂"
  0x81F3,  // { 0x8E, 0x8A } "至"
  0x8996,  // { 0x8E, 0x8B } "視"
  0x8A5E,  // { 0x8E, 0x8C } "詞"
  0x8A69,  // { 0x8E, 0x8D } "詩"
  0x8A66,  // { 0x8E, 0x8E } "試"
  0x8A8C,  // { 0x8E, 0x8F } "誌"
  0x8AEE,  // { 0x8E, 0x90 } "諮"
  0x8CC7,  // { 0x8E, 0x91 } "資"
  0x8CDC,  // { 0x8E, 0x92 } "賜"
  0x96CC,  // { 0x8E, 0x93 } "雌"
  0x98FC,  // { 0x8E, 0x94 } "飼"
  0x6B6F,  // { 0x8E, 0x95 } "歯"
  0x4E8B,  // { 0x8E, 0x96 } "事"
  0x4F3C,  // { 0x8E, 0x97 } "似"
  0x4F8D,  // { 0x8E, 0x98 } "侍"
  0x5150,  // { 0x8E, 0x99 } "児"
  0x5B57,  // { 0x8E, 0x9A } "字"
  0x5BFA,  // { 0x8E, 0x9B } "寺"
  0x6148,  // { 0x8E, 0x9C } "慈"
  0x6301,  // { 0x8E, 0x9D } "持"
  0x6642,  // { 0x8E, 0x9E } "時"
  0x6B21,  // { 0x8E, 0x9F } "次"
  0x6ECB,  // { 0x8E, 0xA0 } "滋"
  0x6CBB,  // { 0x8E, 0xA1 } "治"
  0x723E,  // { 0x8E, 0xA2 } "爾"
  0x74BD,  // { 0x8E, 0xA3 } "璽"
  0x75D4,  // { 0x8E, 0xA4 } "痔"
  0x78C1,  // { 0x8E, 0xA5 } "磁"
  0x793A,  // { 0x8E, 0xA6 } "示"
  0x800C,  // { 0x8E, 0xA7 } "而"
  0x8033,  // { 0x8E, 0xA8 } "耳"
  0x81EA,  // { 0x8E, 0xA9 } "自"
  0x8494,  // { 0x8E, 0xAA } "蒔"
  0x8F9E,  // { 0x8E, 0xAB } "辞"
  0x6C50,  // { 0x8E, 0xAC } "汐"
  0x9E7F,  // { 0x8E, 0xAD } "鹿"
  0x5F0F,  // { 0x8E, 0xAE } "式"
  0x8B58,  // { 0x8E, 0xAF } "識"
  0x9D2B,  // { 0x8E, 0xB0 } "鴫"
  0x7AFA,  // { 0x8E, 0xB1 } "竺"
  0x8EF8,  // { 0x8E, 0xB2 } "軸"
  0x5B8D,  // { 0x8E, 0xB3 } "宍"
  0x96EB,  // { 0x8E, 0xB4 } "雫"
  0x4E03,  // { 0x8E, 0xB5 } "七"
  0x53F1,  // { 0x8E, 0xB6 } "叱"
  0x57F7,  // { 0x8E, 0xB7 } "執"
  0x5931,  // { 0x8E, 0xB8 } "失"
  0x5AC9,  // { 0x8E, 0xB9 } "嫉"
  0x5BA4,  // { 0x8E, 0xBA } "室"
  0x6089,  // { 0x8E, 0xBB } "悉"
  0x6E7F,  // { 0x8E, 0xBC } "湿"
  0x6F06,  // { 0x8E, 0xBD } "漆"
  0x75BE,  // { 0x8E, 0xBE } "疾"
  0x8CEA,  // { 0x8E, 0xBF } "質"
  0x5B9F,  // { 0x8E, 0xC0 } "実"
  0x8500,  // { 0x8E, 0xC1 } "蔀"
  0x7BE0,  // { 0x8E, 0xC2 } "篠"
  0x5072,  // { 0x8E, 0xC3 } "偲"
  0x67F4,  // { 0x8E, 0xC4 } "柴"
  0x829D,  // { 0x8E, 0xC5 } "芝"
  0x5C61,  // { 0x8E, 0xC6 } "屡"
  0x854A,  // { 0x8E, 0xC7 } "蕊"
  0x7E1E,  // { 0x8E, 0xC8 } "縞"
  0x820E,  // { 0x8E, 0xC9 } "舎"
  0x5199,  // { 0x8E, 0xCA } "写"
  0x5C04,  // { 0x8E, 0xCB } "射"
  0x6368,  // { 0x8E, 0xCC } "捨"
  0x8D66,  // { 0x8E, 0xCD } "赦"
  0x659C,  // { 0x8E, 0xCE } "斜"
  0x716E,  // { 0x8E, 0xCF } "煮"
  0x793E,  // { 0x8E, 0xD0 } "社"
  0x7D17,  // { 0x8E, 0xD1 } "紗"
  0x8005,  // { 0x8E, 0xD2 } "者"
  0x8B1D,  // { 0x8E, 0xD3 } "謝"
  0x8ECA,  // { 0x8E, 0xD4 } "車"
  0x906E,  // { 0x8E, 0xD5 } "遮"
  0x86C7,  // { 0x8E, 0xD6 } "蛇"
  0x90AA,  // { 0x8E, 0xD7 } "邪"
  0x501F,  // { 0x8E, 0xD8 } "借"
  0x52FA,  // { 0x8E, 0xD9 } "勺"
  0x5C3A,  // { 0x8E, 0xDA } "尺"
  0x6753,  // { 0x8E, 0xDB } "杓"
  0x707C,  // { 0x8E, 0xDC } "灼"
  0x7235,  // { 0x8E, 0xDD } "爵"
  0x914C,  // { 0x8E, 0xDE } "酌"
  0x91C8,  // { 0x8E, 0xDF } "釈"
  0x932B,  // { 0x8E, 0xE0 } "錫"
  0x82E5,  // { 0x8E, 0xE1 } "若"
  0x5BC2,  // { 0x8E, 0xE2 } "寂"
  0x5F31,  // { 0x8E, 0xE3 } "弱"
  0x60F9,  // { 0x8E, 0xE4 } "惹"
  0x4E3B,  // { 0x8E, 0xE5 } "主"
  0x53D6,  // { 0x8E, 0xE6 } "取"
  0x5B88,  // { 0x8E, 0xE7 } "守"
  0x624B,  // { 0x8E, 0xE8 } "手"
  0x6731,  // { 0x8E, 0xE9 } "朱"
  0x6B8A,  // { 0x8E, 0xEA } "殊"
  0x72E9,  // { 0x8E, 0xEB } "狩"
  0x73E0,  // { 0x8E, 0xEC } "珠"
  0x7A2E,  // { 0x8E, 0xED } "種"
  0x816B,  // { 0x8E, 0xEE } "腫"
  0x8DA3,  // { 0x8E, 0xEF } "趣"
  0x9152,  // { 0x8E, 0xF0 } "酒"
  0x9996,  // { 0x8E, 0xF1 } "首"
  0x5112,  // { 0x8E, 0xF2 } "儒"
  0x53D7,  // { 0x8E, 0xF3 } "受"
  0x546A,  // { 0x8E, 0xF4 } "呪"
  0x5BFF,  // { 0x8E, 0xF5 } "寿"
  0x6388,  // { 0x8E, 0xF6 } "授"
  0x6A39,  // { 0x8E, 0xF7 } "樹"
  0x7DAC,  // { 0x8E, 0xF8 } "綬"
  0x9700,  // { 0x8E, 0xF9 } "需"
  0x56DA,  // { 0x8E, 0xFA } "囚"
  0x53CE,  // { 0x8E, 0xFB } "収"
  0x5468,  // { 0x8E, 0xFC } "周"
  0x0000,  // { 0x8E, 0xFD }
  0x0000,  // { 0x8E, 0xFE }
  0x0000,  // { 0x8E, 0xFF }
  0x5B97,  // { 0x8F, 0x40 } "宗"
  0x5C31,  // { 0x8F, 0x41 } "就"
  0x5DDE,  // { 0x8F, 0x42 } "州"
  0x4FEE,  // { 0x8F, 0x43 } "修"
  0x6101,  // { 0x8F, 0x44 } "愁"
  0x62FE,  // { 0x8F, 0x45 } "拾"
  0x6D32,  // { 0x8F, 0x46 } "洲"
  0x79C0,  // { 0x8F, 0x47 } "秀"
  0x79CB,  // { 0x8F, 0x48 } "秋"
  0x7D42,  // { 0x8F, 0x49 } "終"
  0x7E4D,  // { 0x8F, 0x4A } "繍"
  0x7FD2,  // { 0x8F, 0x4B } "習"
  0x81ED,  // { 0x8F, 0x4C } "臭"
  0x821F,  // { 0x8F, 0x4D } "舟"
  0x8490,  // { 0x8F, 0x4E } "蒐"
  0x8846,  // { 0x8F, 0x4F } "衆"
  0x8972,  // { 0x8F, 0x50 } "襲"
  0x8B90,  // { 0x8F, 0x51 } "讐"
  0x8E74,  // { 0x8F, 0x52 } "蹴"
  0x8F2F,  // { 0x8F, 0x53 } "輯"
  0x9031,  // { 0x8F, 0x54 } "週"
  0x914B,  // { 0x8F, 0x55 } "酋"
  0x916C,  // { 0x8F, 0x56 } "酬"
  0x96C6,  // { 0x8F, 0x57 } "集"
  0x919C,  // { 0x8F, 0x58 } "醜"
  0x4EC0,  // { 0x8F, 0x59 } "什"
  0x4F4F,  // { 0x8F, 0x5A } "住"
  0x5145,  // { 0x8F, 0x5B } "充"
  0x5341,  // { 0x8F, 0x5C } "十"
  0x5F93,  // { 0x8F, 0x5D } "従"
  0x620E,  // { 0x8F, 0x5E } "戎"
  0x67D4,  // { 0x8F, 0x5F } "柔"
  0x6C41,  // { 0x8F, 0x60 } "汁"
  0x6E0B,  // { 0x8F, 0x61 } "渋"
  0x7363,  // { 0x8F, 0x62 } "獣"
  0x7E26,  // { 0x8F, 0x63 } "縦"
  0x91CD,  // { 0x8F, 0x64 } "重"
  0x9283,  // { 0x8F, 0x65 } "銃"
  0x53D4,  // { 0x8F, 0x66 } "叔"
  0x5919,  // { 0x8F, 0x67 } "夙"
  0x5BBF,  // { 0x8F, 0x68 } "宿"
  0x6DD1,  // { 0x8F, 0x69 } "淑"
  0x795D,  // { 0x8F, 0x6A } "祝"
  0x7E2E,  // { 0x8F, 0x6B } "縮"
  0x7C9B,  // { 0x8F, 0x6C } "粛"
  0x587E,  // { 0x8F, 0x6D } "塾"
  0x719F,  // { 0x8F, 0x6E } "熟"
  0x51FA,  // { 0x8F, 0x6F } "出"
  0x8853,  // { 0x8F, 0x70 } "術"
  0x8FF0,  // { 0x8F, 0x71 } "述"
  0x4FCA,  // { 0x8F, 0x72 } "俊"
  0x5CFB,  // { 0x8F, 0x73 } "峻"
  0x6625,  // { 0x8F, 0x74 } "春"
  0x77AC,  // { 0x8F, 0x75 } "瞬"
  0x7AE3,  // { 0x8F, 0x76 } "竣"
  0x821C,  // { 0x8F, 0x77 } "舜"
  0x99FF,  // { 0x8F, 0x78 } "駿"
  0x51C6,  // { 0x8F, 0x79 } "准"
  0x5FAA,  // { 0x8F, 0x7A } "循"
  0x65EC,  // { 0x8F, 0x7B } "旬"
  0x696F,  // { 0x8F, 0x7C } "楯"
  0x6B89,  // { 0x8F, 0x7D } "殉"
  0x6DF3,  // { 0x8F, 0x7E } "淳"
  0x6E96,  // { 0x8F, 0x80 } "準"
  0x6F64,  // { 0x8F, 0x81 } "潤"
  0x76FE,  // { 0x8F, 0x82 } "盾"
  0x7D14,  // { 0x8F, 0x83 } "純"
  0x5DE1,  // { 0x8F, 0x84 } "巡"
  0x9075,  // { 0x8F, 0x85 } "遵"
  0x9187,  // { 0x8F, 0x86 } "醇"
  0x9806,  // { 0x8F, 0x87 } "順"
  0x51E6,  // { 0x8F, 0x88 } "処"
  0x521D,  // { 0x8F, 0x89 } "初"
  0x6240,  // { 0x8F, 0x8A } "所"
  0x6691,  // { 0x8F, 0x8B } "暑"
  0x66D9,  // { 0x8F, 0x8C } "曙"
  0x6E1A,  // { 0x8F, 0x8D } "渚"
  0x5EB6,  // { 0x8F, 0x8E } "庶"
  0x7DD2,  // { 0x8F, 0x8F } "緒"
  0x7F72,  // { 0x8F, 0x90 } "署"
  0x66F8,  // { 0x8F, 0x91 } "書"
  0x85AF,  // { 0x8F, 0x92 } "薯"
  0x85F7,  // { 0x8F, 0x93 } "藷"
  0x8AF8,  // { 0x8F, 0x94 } "諸"
  0x52A9,  // { 0x8F, 0x95 } "助"
  0x53D9,  // { 0x8F, 0x96 } "叙"
  0x5973,  // { 0x8F, 0x97 } "女"
  0x5E8F,  // { 0x8F, 0x98 } "序"
  0x5F90,  // { 0x8F, 0x99 } "徐"
  0x6055,  // { 0x8F, 0x9A } "恕"
  0x92E4,  // { 0x8F, 0x9B } "鋤"
  0x9664,  // { 0x8F, 0x9C } "除"
  0x50B7,  // { 0x8F, 0x9D } "傷"
  0x511F,  // { 0x8F, 0x9E } "償"
  0x52DD,  // { 0x8F, 0x9F } "勝"
  0x5320,  // { 0x8F, 0xA0 } "匠"
  0x5347,  // { 0x8F, 0xA1 } "升"
  0x53EC,  // { 0x8F, 0xA2 } "召"
  0x54E8,  // { 0x8F, 0xA3 } "哨"
  0x5546,  // { 0x8F, 0xA4 } "商"
  0x5531,  // { 0x8F, 0xA5 } "唱"
  0x5617,  // { 0x8F, 0xA6 } "嘗"
  0x5968,  // { 0x8F, 0xA7 } "奨"
  0x59BE,  // { 0x8F, 0xA8 } "妾"
  0x5A3C,  // { 0x8F, 0xA9 } "娼"
  0x5BB5,  // { 0x8F, 0xAA } "宵"
  0x5C06,  // { 0x8F, 0xAB } "将"
  0x5C0F,  // { 0x8F, 0xAC } "小"
  0x5C11,  // { 0x8F, 0xAD } "少"
  0x5C1A,  // { 0x8F, 0xAE } "尚"
  0x5E84,  // { 0x8F, 0xAF } "庄"
  0x5E8A,  // { 0x8F, 0xB0 } "床"
  0x5EE0,  // { 0x8F, 0xB1 } "廠"
  0x5F70,  // { 0x8F, 0xB2 } "彰"
  0x627F,  // { 0x8F, 0xB3 } "承"
  0x6284,  // { 0x8F, 0xB4 } "抄"
  0x62DB,  // { 0x8F, 0xB5 } "招"
  0x638C,  // { 0x8F, 0xB6 } "掌"
  0x6377,  // { 0x8F, 0xB7 } "捷"
  0x6607,  // { 0x8F, 0xB8 } "昇"
  0x660C,  // { 0x8F, 0xB9 } "昌"
  0x662D,  // { 0x8F, 0xBA } "昭"
  0x6676,  // { 0x8F, 0xBB } "晶"
  0x677E,  // { 0x8F, 0xBC } "松"
  0x68A2,  // { 0x8F, 0xBD } "梢"
  0x6A1F,  // { 0x8F, 0xBE } "樟"
  0x6A35,  // { 0x8F, 0xBF } "樵"
  0x6CBC,  // { 0x8F, 0xC0 } "沼"
  0x6D88,  // { 0x8F, 0xC1 } "消"
  0x6E09,  // { 0x8F, 0xC2 } "渉"
  0x6E58,  // { 0x8F, 0xC3 } "湘"
  0x713C,  // { 0x8F, 0xC4 } "焼"
  0x7126,  // { 0x8F, 0xC5 } "焦"
  0x7167,  // { 0x8F, 0xC6 } "照"
  0x75C7,  // { 0x8F, 0xC7 } "症"
  0x7701,  // { 0x8F, 0xC8 } "省"
  0x785D,  // { 0x8F, 0xC9 } "硝"
  0x7901,  // { 0x8F, 0xCA } "礁"
  0x7965,  // { 0x8F, 0xCB } "祥"
  0x79F0,  // { 0x8F, 0xCC } "称"
  0x7AE0,  // { 0x8F, 0xCD } "章"
  0x7B11,  // { 0x8F, 0xCE } "笑"
  0x7CA7,  // { 0x8F, 0xCF } "粧"
  0x7D39,  // { 0x8F, 0xD0 } "紹"
  0x8096,  // { 0x8F, 0xD1 } "肖"
  0x83D6,  // { 0x8F, 0xD2 } "菖"
  0x848B,  // { 0x8F, 0xD3 } "蒋"
  0x8549,  // { 0x8F, 0xD4 } "蕉"
  0x885D,  // { 0x8F, 0xD5 } "衝"
  0x88F3,  // { 0x8F, 0xD6 } "裳"
  0x8A1F,  // { 0x8F, 0xD7 } "訟"
  0x8A3C,  // { 0x8F, 0xD8 } "証"
  0x8A54,  // { 0x8F, 0xD9 } "詔"
  0x8A73,  // { 0x8F, 0xDA } "詳"
  0x8C61,  // { 0x8F, 0xDB } "象"
  0x8CDE,  // { 0x8F, 0xDC } "賞"
  0x91A4,  // { 0x8F, 0xDD } "醤"
  0x9266,  // { 0x8F, 0xDE } "鉦"
  0x937E,  // { 0x8F, 0xDF } "鍾"
  0x9418,  // { 0x8F, 0xE0 } "鐘"
  0x969C,  // { 0x8F, 0xE1 } "障"
  0x9798,  // { 0x8F, 0xE2 } "鞘"
  0x4E0A,  // { 0x8F, 0xE3 } "上"
  0x4E08,  // { 0x8F, 0xE4 } "丈"
  0x4E1E,  // { 0x8F, 0xE5 } "丞"
  0x4E57,  // { 0x8F, 0xE6 } "乗"
  0x5197,  // { 0x8F, 0xE7 } "冗"
  0x5270,  // { 0x8F, 0xE8 } "剰"
  0x57CE,  // { 0x8F, 0xE9 } "城"
  0x5834,  // { 0x8F, 0xEA } "場"
  0x58CC,  // { 0x8F, 0xEB } "壌"
  0x5B22,  // { 0x8F, 0xEC } "嬢"
  0x5E38,  // { 0x8F, 0xED } "常"
  0x60C5,  // { 0x8F, 0xEE } "情"
  0x64FE,  // { 0x8F, 0xEF } "擾"
  0x6761,  // { 0x8F, 0xF0 } "条"
  0x6756,  // { 0x8F, 0xF1 } "杖"
  0x6D44,  // { 0x8F, 0xF2 } "浄"
  0x72B6,  // { 0x8F, 0xF3 } "状"
  0x7573,  // { 0x8F, 0xF4 } "畳"
  0x7A63,  // { 0x8F, 0xF5 } "穣"
  0x84B8,  // { 0x8F, 0xF6 } "蒸"
  0x8B72,  // { 0x8F, 0xF7 } "譲"
  0x91B8,  // { 0x8F, 0xF8 } "醸"
  0x9320,  // { 0x8F, 0xF9 } "錠"
  0x5631,  // { 0x8F, 0xFA } "嘱"
  0x57F4,  // { 0x8F, 0xFB } "埴"
  0x98FE,  // { 0x8F, 0xFC } "飾"
  0x0000,  // { 0x8F, 0xFD }
  0x0000,  // { 0x8F, 0xFE }
  0x0000,  // { 0x8F, 0xFF }
  0x62ED,  // { 0x90, 0x40 } "拭"
  0x690D,  // { 0x90, 0x41 } "植"
  0x6B96,  // { 0x90, 0x42 } "殖"
  0x71ED,  // { 0x90, 0x43 } "燭"
  0x7E54,  // { 0x90, 0x44 } "織"
  0x8077,  // { 0x90, 0x45 } "職"
  0x8272,  // { 0x90, 0x46 } "色"
  0x89E6,  // { 0x90, 0x47 } "触"
  0x98DF,  // { 0x90, 0x48 } "食"
  0x8755,  // { 0x90, 0x49 } "蝕"
  0x8FB1,  // { 0x90, 0x4A } "辱"
  0x5C3B,  // { 0x90, 0x4B } "尻"
  0x4F38,  // { 0x90, 0x4C } "伸"
  0x4FE1,  // { 0x90, 0x4D } "信"
  0x4FB5,  // { 0x90, 0x4E } "侵"
  0x5507,  // { 0x90, 0x4F } "唇"
  0x5A20,  // { 0x90, 0x50 } "娠"
  0x5BDD,  // { 0x90, 0x51 } "寝"
  0x5BE9,  // { 0x90, 0x52 } "審"
  0x5FC3,  // { 0x90, 0x53 } "心"
  0x614E,  // { 0x90, 0x54 } "慎"
  0x632F,  // { 0x90, 0x55 } "振"
  0x65B0,  // { 0x90, 0x56 } "新"
  0x664B,  // { 0x90, 0x57 } "晋"
  0x68EE,  // { 0x90, 0x58 } "森"
  0x699B,  // { 0x90, 0x59 } "榛"
  0x6D78,  // { 0x90, 0x5A } "浸"
  0x6DF1,  // { 0x90, 0x5B } "深"
  0x7533,  // { 0x90, 0x5C } "申"
  0x75B9,  // { 0x90, 0x5D } "疹"
  0x771F,  // { 0x90, 0x5E } "真"
  0x795E,  // { 0x90, 0x5F } "神"
  0x79E6,  // { 0x90, 0x60 } "秦"
  0x7D33,  // { 0x90, 0x61 } "紳"
  0x81E3,  // { 0x90, 0x62 } "臣"
  0x82AF,  // { 0x90, 0x63 } "芯"
  0x85AA,  // { 0x90, 0x64 } "薪"
  0x89AA,  // { 0x90, 0x65 } "親"
  0x8A3A,  // { 0x90, 0x66 } "診"
  0x8EAB,  // { 0x90, 0x67 } "身"
  0x8F9B,  // { 0x90, 0x68 } "辛"
  0x9032,  // { 0x90, 0x69 } "進"
  0x91DD,  // { 0x90, 0x6A } "針"
  0x9707,  // { 0x90, 0x6B } "震"
  0x4EBA,  // { 0x90, 0x6C } "人"
  0x4EC1,  // { 0x90, 0x6D } "仁"
  0x5203,  // { 0x90, 0x6E } "刃"
  0x5875,  // { 0x90, 0x6F } "塵"
  0x58EC,  // { 0x90, 0x70 } "壬"
  0x5C0B,  // { 0x90, 0x71 } "尋"
  0x751A,  // { 0x90, 0x72 } "甚"
  0x5C3D,  // { 0x90, 0x73 } "尽"
  0x814E,  // { 0x90, 0x74 } "腎"
  0x8A0A,  // { 0x90, 0x75 } "訊"
  0x8FC5,  // { 0x90, 0x76 } "迅"
  0x9663,  // { 0x90, 0x77 } "陣"
  0x976D,  // { 0x90, 0x78 } "靭"
  0x7B25,  // { 0x90, 0x79 } "笥"
  0x8ACF,  // { 0x90, 0x7A } "諏"
  0x9808,  // { 0x90, 0x7B } "須"
  0x9162,  // { 0x90, 0x7C } "酢"
  0x56F3,  // { 0x90, 0x7D } "図"
  0x53A8,  // { 0x90, 0x7E } "厨"
  0x9017,  // { 0x90, 0x80 } "逗"
  0x5439,  // { 0x90, 0x81 } "吹"
  0x5782,  // { 0x90, 0x82 } "垂"
  0x5E25,  // { 0x90, 0x83 } "帥"
  0x63A8,  // { 0x90, 0x84 } "推"
  0x6C34,  // { 0x90, 0x85 } "水"
  0x708A,  // { 0x90, 0x86 } "炊"
  0x7761,  // { 0x90, 0x87 } "睡"
  0x7C8B,  // { 0x90, 0x88 } "粋"
  0x7FE0,  // { 0x90, 0x89 } "翠"
  0x8870,  // { 0x90, 0x8A } "衰"
  0x9042,  // { 0x90, 0x8B } "遂"
  0x9154,  // { 0x90, 0x8C } "酔"
  0x9310,  // { 0x90, 0x8D } "錐"
  0x9318,  // { 0x90, 0x8E } "錘"
  0x968F,  // { 0x90, 0x8F } "随"
  0x745E,  // { 0x90, 0x90 } "瑞"
  0x9AC4,  // { 0x90, 0x91 } "髄"
  0x5D07,  // { 0x90, 0x92 } "崇"
  0x5D69,  // { 0x90, 0x93 } "嵩"
  0x6570,  // { 0x90, 0x94 } "数"
  0x67A2,  // { 0x90, 0x95 } "枢"
  0x8DA8,  // { 0x90, 0x96 } "趨"
  0x96DB,  // { 0x90, 0x97 } "雛"
  0x636E,  // { 0x90, 0x98 } "据"
  0x6749,  // { 0x90, 0x99 } "杉"
  0x6919,  // { 0x90, 0x9A } "椙"
  0x83C5,  // { 0x90, 0x9B } "菅"
  0x9817,  // { 0x90, 0x9C } "頗"
  0x96C0,  // { 0x90, 0x9D } "雀"
  0x88FE,  // { 0x90, 0x9E } "裾"
  0x6F84,  // { 0x90, 0x9F } "澄"
  0x647A,  // { 0x90, 0xA0 } "摺"
  0x5BF8,  // { 0x90, 0xA1 } "寸"
  0x4E16,  // { 0x90, 0xA2 } "世"
  0x702C,  // { 0x90, 0xA3 } "瀬"
  0x755D,  // { 0x90, 0xA4 } "畝"
  0x662F,  // { 0x90, 0xA5 } "是"
  0x51C4,  // { 0x90, 0xA6 } "凄"
  0x5236,  // { 0x90, 0xA7 } "制"
  0x52E2,  // { 0x90, 0xA8 } "勢"
  0x59D3,  // { 0x90, 0xA9 } "姓"
  0x5F81,  // { 0x90, 0xAA } "征"
  0x6027,  // { 0x90, 0xAB } "性"
  0x6210,  // { 0x90, 0xAC } "成"
  0x653F,  // { 0x90, 0xAD } "政"
  0x6574,  // { 0x90, 0xAE } "整"
  0x661F,  // { 0x90, 0xAF } "星"
  0x6674,  // { 0x90, 0xB0 } "晴"
  0x68F2,  // { 0x90, 0xB1 } "棲"
  0x6816,  // { 0x90, 0xB2 } "栖"
  0x6B63,  // { 0x90, 0xB3 } "正"
  0x6E05,  // { 0x90, 0xB4 } "清"
  0x7272,  // { 0x90, 0xB5 } "牲"
  0x751F,  // { 0x90, 0xB6 } "生"
  0x76DB,  // { 0x90, 0xB7 } "盛"
  0x7CBE,  // { 0x90, 0xB8 } "精"
  0x8056,  // { 0x90, 0xB9 } "聖"
  0x58F0,  // { 0x90, 0xBA } "声"
  0x88FD,  // { 0x90, 0xBB } "製"
  0x897F,  // { 0x90, 0xBC } "西"
  0x8AA0,  // { 0x90, 0xBD } "誠"
  0x8A93,  // { 0x90, 0xBE } "誓"
  0x8ACB,  // { 0x90, 0xBF } "請"
  0x901D,  // { 0x90, 0xC0 } "逝"
  0x9192,  // { 0x90, 0xC1 } "醒"
  0x9752,  // { 0x90, 0xC2 } "青"
  0x9759,  // { 0x90, 0xC3 } "静"
  0x6589,  // { 0x90, 0xC4 } "斉"
  0x7A0E,  // { 0x90, 0xC5 } "税"
  0x8106,  // { 0x90, 0xC6 } "脆"
  0x96BB,  // { 0x90, 0xC7 } "隻"
  0x5E2D,  // { 0x90, 0xC8 } "席"
  0x60DC,  // { 0x90, 0xC9 } "惜"
  0x621A,  // { 0x90, 0xCA } "戚"
  0x65A5,  // { 0x90, 0xCB } "斥"
  0x6614,  // { 0x90, 0xCC } "昔"
  0x6790,  // { 0x90, 0xCD } "析"
  0x77F3,  // { 0x90, 0xCE } "石"
  0x7A4D,  // { 0x90, 0xCF } "積"
  0x7C4D,  // { 0x90, 0xD0 } "籍"
  0x7E3E,  // { 0x90, 0xD1 } "績"
  0x810A,  // { 0x90, 0xD2 } "脊"
  0x8CAC,  // { 0x90, 0xD3 } "責"
  0x8D64,  // { 0x90, 0xD4 } "赤"
  0x8DE1,  // { 0x90, 0xD5 } "跡"
  0x8E5F,  // { 0x90, 0xD6 } "蹟"
  0x78A9,  // { 0x90, 0xD7 } "碩"
  0x5207,  // { 0x90, 0xD8 } "切"
  0x62D9,  // { 0x90, 0xD9 } "拙"
  0x63A5,  // { 0x90, 0xDA } "接"
  0x6442,  // { 0x90, 0xDB } "摂"
  0x6298,  // { 0x90, 0xDC } "折"
  0x8A2D,  // { 0x90, 0xDD } "設"
  0x7A83,  // { 0x90, 0xDE } "窃"
  0x7BC0,  // { 0x90, 0xDF } "節"
  0x8AAC,  // { 0x90, 0xE0 } "説"
  0x96EA,  // { 0x90, 0xE1 } "雪"
  0x7D76,  // { 0x90, 0xE2 } "絶"
  0x820C,  // { 0x90, 0xE3 } "舌"
  0x8749,  // { 0x90, 0xE4 } "蝉"
  0x4ED9,  // { 0x90, 0xE5 } "仙"
  0x5148,  // { 0x90, 0xE6 } "先"
  0x5343,  // { 0x90, 0xE7 } "千"
  0x5360,  // { 0x90, 0xE8 } "占"
  0x5BA3,  // { 0x90, 0xE9 } "宣"
  0x5C02,  // { 0x90, 0xEA } "専"
  0x5C16,  // { 0x90, 0xEB } "尖"
  0x5DDD,  // { 0x90, 0xEC } "川"
  0x6226,  // { 0x90, 0xED } "戦"
  0x6247,  // { 0x90, 0xEE } "扇"
  0x64B0,  // { 0x90, 0xEF } "撰"
  0x6813,  // { 0x90, 0xF0 } "栓"
  0x6834,  // { 0x90, 0xF1 } "栴"
  0x6CC9,  // { 0x90, 0xF2 } "泉"
  0x6D45,  // { 0x90, 0xF3 } "浅"
  0x6D17,  // { 0x90, 0xF4 } "洗"
  0x67D3,  // { 0x90, 0xF5 } "染"
  0x6F5C,  // { 0x90, 0xF6 } "潜"
  0x714E,  // { 0x90, 0xF7 } "煎"
  0x717D,  // { 0x90, 0xF8 } "煽"
  0x65CB,  // { 0x90, 0xF9 } "旋"
  0x7A7F,  // { 0x90, 0xFA } "穿"
  0x7BAD,  // { 0x90, 0xFB } "箭"
  0x7DDA,  // { 0x90, 0xFC } "線"
  0x0000,  // { 0x90, 0xFD }
  0x0000,  // { 0x90, 0xFE }
  0x0000,  // { 0x90, 0xFF }
  0x7E4A,  // { 0x91, 0x40 } "繊"
  0x7FA8,  // { 0x91, 0x41 } "羨"
  0x817A,  // { 0x91, 0x42 } "腺"
  0x821B,  // { 0x91, 0x43 } "舛"
  0x8239,  // { 0x91, 0x44 } "船"
  0x85A6,  // { 0x91, 0x45 } "薦"
  0x8A6E,  // { 0x91, 0x46 } "詮"
  0x8CCE,  // { 0x91, 0x47 } "賎"
  0x8DF5,  // { 0x91, 0x48 } "践"
  0x9078,  // { 0x91, 0x49 } "選"
  0x9077,  // { 0x91, 0x4A } "遷"
  0x92AD,  // { 0x91, 0x4B } "銭"
  0x9291,  // { 0x91, 0x4C } "銑"
  0x9583,  // { 0x91, 0x4D } "閃"
  0x9BAE,  // { 0x91, 0x4E } "鮮"
  0x524D,  // { 0x91, 0x4F } "前"
  0x5584,  // { 0x91, 0x50 } "善"
  0x6F38,  // { 0x91, 0x51 } "漸"
  0x7136,  // { 0x91, 0x52 } "然"
  0x5168,  // { 0x91, 0x53 } "全"
  0x7985,  // { 0x91, 0x54 } "禅"
  0x7E55,  // { 0x91, 0x55 } "繕"
  0x81B3,  // { 0x91, 0x56 } "膳"
  0x7CCE,  // { 0x91, 0x57 } "糎"
  0x564C,  // { 0x91, 0x58 } "噌"
  0x5851,  // { 0x91, 0x59 } "塑"
  0x5CA8,  // { 0x91, 0x5A } "岨"
  0x63AA,  // { 0x91, 0x5B } "措"
  0x66FE,  // { 0x91, 0x5C } "曾"
  0x66FD,  // { 0x91, 0x5D } "曽"
  0x695A,  // { 0x91, 0x5E } "楚"
  0x72D9,  // { 0x91, 0x5F } "狙"
  0x758F,  // { 0x91, 0x60 } "疏"
  0x758E,  // { 0x91, 0x61 } "疎"
  0x790E,  // { 0x91, 0x62 } "礎"
  0x7956,  // { 0x91, 0x63 } "祖"
  0x79DF,  // { 0x91, 0x64 } "租"
  0x7C97,  // { 0x91, 0x65 } "粗"
  0x7D20,  // { 0x91, 0x66 } "素"
  0x7D44,  // { 0x91, 0x67 } "組"
  0x8607,  // { 0x91, 0x68 } "蘇"
  0x8A34,  // { 0x91, 0x69 } "訴"
  0x963B,  // { 0x91, 0x6A } "阻"
  0x9061,  // { 0x91, 0x6B } "遡"
  0x9F20,  // { 0x91, 0x6C } "鼠"
  0x50E7,  // { 0x91, 0x6D } "僧"
  0x5275,  // { 0x91, 0x6E } "創"
  0x53CC,  // { 0x91, 0x6F } "双"
  0x53E2,  // { 0x91, 0x70 } "叢"
  0x5009,  // { 0x91, 0x71 } "倉"
  0x55AA,  // { 0x91, 0x72 } "喪"
  0x58EE,  // { 0x91, 0x73 } "壮"
  0x594F,  // { 0x91, 0x74 } "奏"
  0x723D,  // { 0x91, 0x75 } "爽"
  0x5B8B,  // { 0x91, 0x76 } "宋"
  0x5C64,  // { 0x91, 0x77 } "層"
  0x531D,  // { 0x91, 0x78 } "匝"
  0x60E3,  // { 0x91, 0x79 } "惣"
  0x60F3,  // { 0x91, 0x7A } "想"
  0x635C,  // { 0x91, 0x7B } "捜"
  0x6383,  // { 0x91, 0x7C } "掃"
  0x633F,  // { 0x91, 0x7D } "挿"
  0x63BB,  // { 0x91, 0x7E } "掻"
  0x64CD,  // { 0x91, 0x80 } "操"
  0x65E9,  // { 0x91, 0x81 } "早"
  0x66F9,  // { 0x91, 0x82 } "曹"
  0x5DE3,  // { 0x91, 0x83 } "巣"
  0x69CD,  // { 0x91, 0x84 } "槍"
  0x69FD,  // { 0x91, 0x85 } "槽"
  0x6F15,  // { 0x91, 0x86 } "漕"
  0x71E5,  // { 0x91, 0x87 } "燥"
  0x4E89,  // { 0x91, 0x88 } "争"
  0x75E9,  // { 0x91, 0x89 } "痩"
  0x76F8,  // { 0x91, 0x8A } "相"
  0x7A93,  // { 0x91, 0x8B } "窓"
  0x7CDF,  // { 0x91, 0x8C } "糟"
  0x7DCF,  // { 0x91, 0x8D } "総"
  0x7D9C,  // { 0x91, 0x8E } "綜"
  0x8061,  // { 0x91, 0x8F } "聡"
  0x8349,  // { 0x91, 0x90 } "草"
  0x8358,  // { 0x91, 0x91 } "荘"
  0x846C,  // { 0x91, 0x92 } "葬"
  0x84BC,  // { 0x91, 0x93 } "蒼"
  0x85FB,  // { 0x91, 0x94 } "藻"
  0x88C5,  // { 0x91, 0x95 } "装"
  0x8D70,  // { 0x91, 0x96 } "走"
  0x9001,  // { 0x91, 0x97 } "送"
  0x906D,  // { 0x91, 0x98 } "遭"
  0x9397,  // { 0x91, 0x99 } "鎗"
  0x971C,  // { 0x91, 0x9A } "霜"
  0x9A12,  // { 0x91, 0x9B } "騒"
  0x50CF,  // { 0x91, 0x9C } "像"
  0x5897,  // { 0x91, 0x9D } "増"
  0x618E,  // { 0x91, 0x9E } "憎"
  0x81D3,  // { 0x91, 0x9F } "臓"
  0x8535,  // { 0x91, 0xA0 } "蔵"
  0x8D08,  // { 0x91, 0xA1 } "贈"
  0x9020,  // { 0x91, 0xA2 } "造"
  0x4FC3,  // { 0x91, 0xA3 } "促"
  0x5074,  // { 0x91, 0xA4 } "側"
  0x5247,  // { 0x91, 0xA5 } "則"
  0x5373,  // { 0x91, 0xA6 } "即"
  0x606F,  // { 0x91, 0xA7 } "息"
  0x6349,  // { 0x91, 0xA8 } "捉"
  0x675F,  // { 0x91, 0xA9 } "束"
  0x6E2C,  // { 0x91, 0xAA } "測"
  0x8DB3,  // { 0x91, 0xAB } "足"
  0x901F,  // { 0x91, 0xAC } "速"
  0x4FD7,  // { 0x91, 0xAD } "俗"
  0x5C5E,  // { 0x91, 0xAE } "属"
  0x8CCA,  // { 0x91, 0xAF } "賊"
  0x65CF,  // { 0x91, 0xB0 } "族"
  0x7D9A,  // { 0x91, 0xB1 } "続"
  0x5352,  // { 0x91, 0xB2 } "卒"
  0x8896,  // { 0x91, 0xB3 } "袖"
  0x5176,  // { 0x91, 0xB4 } "其"
  0x63C3,  // { 0x91, 0xB5 } "揃"
  0x5B58,  // { 0x91, 0xB6 } "存"
  0x5B6B,  // { 0x91, 0xB7 } "孫"
  0x5C0A,  // { 0x91, 0xB8 } "尊"
  0x640D,  // { 0x91, 0xB9 } "損"
  0x6751,  // { 0x91, 0xBA } "村"
  0x905C,  // { 0x91, 0xBB } "遜"
  0x4ED6,  // { 0x91, 0xBC } "他"
  0x591A,  // { 0x91, 0xBD } "多"
  0x592A,  // { 0x91, 0xBE } "太"
  0x6C70,  // { 0x91, 0xBF } "汰"
  0x8A51,  // { 0x91, 0xC0 } "詑"
  0x553E,  // { 0x91, 0xC1 } "唾"
  0x5815,  // { 0x91, 0xC2 } "堕"
  0x59A5,  // { 0x91, 0xC3 } "妥"
  0x60F0,  // { 0x91, 0xC4 } "惰"
  0x6253,  // { 0x91, 0xC5 } "打"
  0x67C1,  // { 0x91, 0xC6 } "柁"
  0x8235,  // { 0x91, 0xC7 } "舵"
  0x6955,  // { 0x91, 0xC8 } "楕"
  0x9640,  // { 0x91, 0xC9 } "陀"
  0x99C4,  // { 0x91, 0xCA } "駄"
  0x9A28,  // { 0x91, 0xCB } "騨"
  0x4F53,  // { 0x91, 0xCC } "体"
  0x5806,  // { 0x91, 0xCD } "堆"
  0x5BFE,  // { 0x91, 0xCE } "対"
  0x8010,  // { 0x91, 0xCF } "耐"
  0x5CB1,  // { 0x91, 0xD0 } "岱"
  0x5E2F,  // { 0x91, 0xD1 } "帯"
  0x5F85,  // { 0x91, 0xD2 } "待"
  0x6020,  // { 0x91, 0xD3 } "怠"
  0x614B,  // { 0x91, 0xD4 } "態"
  0x6234,  // { 0x91, 0xD5 } "戴"
  0x66FF,  // { 0x91, 0xD6 } "替"
  0x6CF0,  // { 0x91, 0xD7 } "泰"
  0x6EDE,  // { 0x91, 0xD8 } "滞"
  0x80CE,  // { 0x91, 0xD9 } "胎"
  0x817F,  // { 0x91, 0xDA } "腿"
  0x82D4,  // { 0x91, 0xDB } "苔"
  0x888B,  // { 0x91, 0xDC } "袋"
  0x8CB8,  // { 0x91, 0xDD } "貸"
  0x9000,  // { 0x91, 0xDE } "退"
  0x902E,  // { 0x91, 0xDF } "逮"
  0x968A,  // { 0x91, 0xE0 } "隊"
  0x9EDB,  // { 0x91, 0xE1 } "黛"
  0x9BDB,  // { 0x91, 0xE2 } "鯛"
  0x4EE3,  // { 0x91, 0xE3 } "代"
  0x53F0,  // { 0x91, 0xE4 } "台"
  0x5927,  // { 0x91, 0xE5 } "大"
  0x7B2C,  // { 0x91, 0xE6 } "第"
  0x918D,  // { 0x91, 0xE7 } "醍"
  0x984C,  // { 0x91, 0xE8 } "題"
  0x9DF9,  // { 0x91, 0xE9 } "鷹"
  0x6EDD,  // { 0x91, 0xEA } "滝"
  0x7027,  // { 0x91, 0xEB } "瀧"
  0x5353,  // { 0x91, 0xEC } "卓"
  0x5544,  // { 0x91, 0xED } "啄"
  0x5B85,  // { 0x91, 0xEE } "宅"
  0x6258,  // { 0x91, 0xEF } "托"
  0x629E,  // { 0x91, 0xF0 } "択"
  0x62D3,  // { 0x91, 0xF1 } "拓"
  0x6CA2,  // { 0x91, 0xF2 } "沢"
  0x6FEF,  // { 0x91, 0xF3 } "濯"
  0x7422,  // { 0x91, 0xF4 } "琢"
  0x8A17,  // { 0x91, 0xF5 } "託"
  0x9438,  // { 0x91, 0xF6 } "鐸"
  0x6FC1,  // { 0x91, 0xF7 } "濁"
  0x8AFE,  // { 0x91, 0xF8 } "諾"
  0x8338,  // { 0x91, 0xF9 } "茸"
  0x51E7,  // { 0x91, 0xFA } "凧"
  0x86F8,  // { 0x91, 0xFB } "蛸"
  0x53EA,  // { 0x91, 0xFC } "只"
  0x0000,  // { 0x91, 0xFD }
  0x0000,  // { 0x91, 0xFE }
  0x0000,  // { 0x91, 0xFF }
  0x53E9,  // { 0x92, 0x40 } "叩"
  0x4F46,  // { 0x92, 0x41 } "但"
  0x9054,  // { 0x92, 0x42 } "達"
  0x8FB0,  // { 0x92, 0x43 } "辰"
  0x596A,  // { 0x92, 0x44 } "奪"
  0x8131,  // { 0x92, 0x45 } "脱"
  0x5DFD,  // { 0x92, 0x46 } "巽"
  0x7AEA,  // { 0x92, 0x47 } "竪"
  0x8FBF,  // { 0x92, 0x48 } "辿"
  0x68DA,  // { 0x92, 0x49 } "棚"
  0x8C37,  // { 0x92, 0x4A } "谷"
  0x72F8,  // { 0x92, 0x4B } "狸"
  0x9C48,  // { 0x92, 0x4C } "鱈"
  0x6A3D,  // { 0x92, 0x4D } "樽"
  0x8AB0,  // { 0x92, 0x4E } "誰"
  0x4E39,  // { 0x92, 0x4F } "丹"
  0x5358,  // { 0x92, 0x50 } "単"
  0x5606,  // { 0x92, 0x51 } "嘆"
  0x5766,  // { 0x92, 0x52 } "坦"
  0x62C5,  // { 0x92, 0x53 } "担"
  0x63A2,  // { 0x92, 0x54 } "探"
  0x65E6,  // { 0x92, 0x55 } "旦"
  0x6B4E,  // { 0x92, 0x56 } "歎"
  0x6DE1,  // { 0x92, 0x57 } "淡"
  0x6E5B,  // { 0x92, 0x58 } "湛"
  0x70AD,  // { 0x92, 0x59 } "炭"
  0x77ED,  // { 0x92, 0x5A } "短"
  0x7AEF,  // { 0x92, 0x5B } "端"
  0x7BAA,  // { 0x92, 0x5C } "箪"
  0x7DBB,  // { 0x92, 0x5D } "綻"
  0x803D,  // { 0x92, 0x5E } "耽"
  0x80C6,  // { 0x92, 0x5F } "胆"
  0x86CB,  // { 0x92, 0x60 } "蛋"
  0x8A95,  // { 0x92, 0x61 } "誕"
  0x935B,  // { 0x92, 0x62 } "鍛"
  0x56E3,  // { 0x92, 0x63 } "団"
  0x58C7,  // { 0x92, 0x64 } "壇"
  0x5F3E,  // { 0x92, 0x65 } "弾"
  0x65AD,  // { 0x92, 0x66 } "断"
  0x6696,  // { 0x92, 0x67 } "暖"
  0x6A80,  // { 0x92, 0x68 } "檀"
  0x6BB5,  // { 0x92, 0x69 } "段"
  0x7537,  // { 0x92, 0x6A } "男"
  0x8AC7,  // { 0x92, 0x6B } "談"
  0x5024,  // { 0x92, 0x6C } "値"
  0x77E5,  // { 0x92, 0x6D } "知"
  0x5730,  // { 0x92, 0x6E } "地"
  0x5F1B,  // { 0x92, 0x6F } "弛"
  0x6065,  // { 0x92, 0x70 } "恥"
  0x667A,  // { 0x92, 0x71 } "智"
  0x6C60,  // { 0x92, 0x72 } "池"
  0x75F4,  // { 0x92, 0x73 } "痴"
  0x7A1A,  // { 0x92, 0x74 } "稚"
  0x7F6E,  // { 0x92, 0x75 } "置"
  0x81F4,  // { 0x92, 0x76 } "致"
  0x8718,  // { 0x92, 0x77 } "蜘"
  0x9045,  // { 0x92, 0x78 } "遅"
  0x99B3,  // { 0x92, 0x79 } "馳"
  0x7BC9,  // { 0x92, 0x7A } "築"
  0x755C,  // { 0x92, 0x7B } "畜"
  0x7AF9,  // { 0x92, 0x7C } "竹"
  0x7B51,  // { 0x92, 0x7D } "筑"
  0x84C4,  // { 0x92, 0x7E } "蓄"
  0x9010,  // { 0x92, 0x80 } "逐"
  0x79E9,  // { 0x92, 0x81 } "秩"
  0x7A92,  // { 0x92, 0x82 } "窒"
  0x8336,  // { 0x92, 0x83 } "茶"
  0x5AE1,  // { 0x92, 0x84 } "嫡"
  0x7740,  // { 0x92, 0x85 } "着"
  0x4E2D,  // { 0x92, 0x86 } "中"
  0x4EF2,  // { 0x92, 0x87 } "仲"
  0x5B99,  // { 0x92, 0x88 } "宙"
  0x5FE0,  // { 0x92, 0x89 } "忠"
  0x62BD,  // { 0x92, 0x8A } "抽"
  0x663C,  // { 0x92, 0x8B } "昼"
  0x67F1,  // { 0x92, 0x8C } "柱"
  0x6CE8,  // { 0x92, 0x8D } "注"
  0x866B,  // { 0x92, 0x8E } "虫"
  0x8877,  // { 0x92, 0x8F } "衷"
  0x8A3B,  // { 0x92, 0x90 } "註"
  0x914E,  // { 0x92, 0x91 } "酎"
  0x92F3,  // { 0x92, 0x92 } "鋳"
  0x99D0,  // { 0x92, 0x93 } "駐"
  0x6A17,  // { 0x92, 0x94 } "樗"
  0x7026,  // { 0x92, 0x95 } "瀦"
  0x732A,  // { 0x92, 0x96 } "猪"
  0x82E7,  // { 0x92, 0x97 } "苧"
  0x8457,  // { 0x92, 0x98 } "著"
  0x8CAF,  // { 0x92, 0x99 } "貯"
  0x4E01,  // { 0x92, 0x9A } "丁"
  0x5146,  // { 0x92, 0x9B } "兆"
  0x51CB,  // { 0x92, 0x9C } "凋"
  0x558B,  // { 0x92, 0x9D } "喋"
  0x5BF5,  // { 0x92, 0x9E } "寵"
  0x5E16,  // { 0x92, 0x9F } "帖"
  0x5E33,  // { 0x92, 0xA0 } "帳"
  0x5E81,  // { 0x92, 0xA1 } "庁"
  0x5F14,  // { 0x92, 0xA2 } "弔"
  0x5F35,  // { 0x92, 0xA3 } "張"
  0x5F6B,  // { 0x92, 0xA4 } "彫"
  0x5FB4,  // { 0x92, 0xA5 } "徴"
  0x61F2,  // { 0x92, 0xA6 } "懲"
  0x6311,  // { 0x92, 0xA7 } "挑"
  0x66A2,  // { 0x92, 0xA8 } "暢"
  0x671D,  // { 0x92, 0xA9 } "朝"
  0x6F6E,  // { 0x92, 0xAA } "潮"
  0x7252,  // { 0x92, 0xAB } "牒"
  0x753A,  // { 0x92, 0xAC } "町"
  0x773A,  // { 0x92, 0xAD } "眺"
  0x8074,  // { 0x92, 0xAE } "聴"
  0x8139,  // { 0x92, 0xAF } "脹"
  0x8178,  // { 0x92, 0xB0 } "腸"
  0x8776,  // { 0x92, 0xB1 } "蝶"
  0x8ABF,  // { 0x92, 0xB2 } "調"
  0x8ADC,  // { 0x92, 0xB3 } "諜"
  0x8D85,  // { 0x92, 0xB4 } "超"
  0x8DF3,  // { 0x92, 0xB5 } "跳"
  0x929A,  // { 0x92, 0xB6 } "銚"
  0x9577,  // { 0x92, 0xB7 } "長"
  0x9802,  // { 0x92, 0xB8 } "頂"
  0x9CE5,  // { 0x92, 0xB9 } "鳥"
  0x52C5,  // { 0x92, 0xBA } "勅"
  0x6357,  // { 0x92, 0xBB } "捗"
  0x76F4,  // { 0x92, 0xBC } "直"
  0x6715,  // { 0x92, 0xBD } "朕"
  0x6C88,  // { 0x92, 0xBE } "沈"
  0x73CD,  // { 0x92, 0xBF } "珍"
  0x8CC3,  // { 0x92, 0xC0 } "賃"
  0x93AE,  // { 0x92, 0xC1 } "鎮"
  0x9673,  // { 0x92, 0xC2 } "陳"
  0x6D25,  // { 0x92, 0xC3 } "津"
  0x589C,  // { 0x92, 0xC4 } "墜"
  0x690E,  // { 0x92, 0xC5 } "椎"
  0x69CC,  // { 0x92, 0xC6 } "槌"
  0x8FFD,  // { 0x92, 0xC7 } "追"
  0x939A,  // { 0x92, 0xC8 } "鎚"
  0x75DB,  // { 0x92, 0xC9 } "痛"
  0x901A,  // { 0x92, 0xCA } "通"
  0x585A,  // { 0x92, 0xCB } "塚"
  0x6802,  // { 0x92, 0xCC } "栂"
  0x63B4,  // { 0x92, 0xCD } "掴"
  0x69FB,  // { 0x92, 0xCE } "槻"
  0x4F43,  // { 0x92, 0xCF } "佃"
  0x6F2C,  // { 0x92, 0xD0 } "漬"
  0x67D8,  // { 0x92, 0xD1 } "柘"
  0x8FBB,  // { 0x92, 0xD2 } "辻"
  0x8526,  // { 0x92, 0xD3 } "蔦"
  0x7DB4,  // { 0x92, 0xD4 } "綴"
  0x9354,  // { 0x92, 0xD5 } "鍔"
  0x693F,  // { 0x92, 0xD6 } "椿"
  0x6F70,  // { 0x92, 0xD7 } "潰"
  0x576A,  // { 0x92, 0xD8 } "坪"
  0x58F7,  // { 0x92, 0xD9 } "壷"
  0x5B2C,  // { 0x92, 0xDA } "嬬"
  0x7D2C,  // { 0x92, 0xDB } "紬"
  0x722A,  // { 0x92, 0xDC } "爪"
  0x540A,  // { 0x92, 0xDD } "吊"
  0x91E3,  // { 0x92, 0xDE } "釣"
  0x9DB4,  // { 0x92, 0xDF } "鶴"
  0x4EAD,  // { 0x92, 0xE0 } "亭"
  0x4F4E,  // { 0x92, 0xE1 } "低"
  0x505C,  // { 0x92, 0xE2 } "停"
  0x5075,  // { 0x92, 0xE3 } "偵"
  0x5243,  // { 0x92, 0xE4 } "剃"
  0x8C9E,  // { 0x92, 0xE5 } "貞"
  0x5448,  // { 0x92, 0xE6 } "呈"
  0x5824,  // { 0x92, 0xE7 } "堤"
  0x5B9A,  // { 0x92, 0xE8 } "定"
  0x5E1D,  // { 0x92, 0xE9 } "帝"
  0x5E95,  // { 0x92, 0xEA } "底"
  0x5EAD,  // { 0x92, 0xEB } "庭"
  0x5EF7,  // { 0x92, 0xEC } "廷"
  0x5F1F,  // { 0x92, 0xED } "弟"
  0x608C,  // { 0x92, 0xEE } "悌"
  0x62B5,  // { 0x92, 0xEF } "抵"
  0x633A,  // { 0x92, 0xF0 } "挺"
  0x63D0,  // { 0x92, 0xF1 } "提"
  0x68AF,  // { 0x92, 0xF2 } "梯"
  0x6C40,  // { 0x92, 0xF3 } "汀"
  0x7887,  // { 0x92, 0xF4 } "碇"
  0x798E,  // { 0x92, 0xF5 } "禎"
  0x7A0B,  // { 0x92, 0xF6 } "程"
  0x7DE0,  // { 0x92, 0xF7 } "締"
  0x8247,  // { 0x92, 0xF8 } "艇"
  0x8A02,  // { 0x92, 0xF9 } "訂"
  0x8AE6,  // { 0x92, 0xFA } "諦"
  0x8E44,  // { 0x92, 0xFB } "蹄"
  0x9013,  // { 0x92, 0xFC } "逓"
  0x0000,  // { 0x92, 0xFD }
  0x0000,  // { 0x92, 0xFE }
  0x0000,  // { 0x92, 0xFF }
  0x90B8,  // { 0x93, 0x40 } "邸"
  0x912D,  // { 0x93, 0x41 } "鄭"
  0x91D8,  // { 0x93, 0x42 } "釘"
  0x9F0E,  // { 0x93, 0x43 } "鼎"
  0x6CE5,  // { 0x93, 0x44 } "泥"
  0x6458,  // { 0x93, 0x45 } "摘"
  0x64E2,  // { 0x93, 0x46 } "擢"
  0x6575,  // { 0x93, 0x47 } "敵"
  0x6EF4,  // { 0x93, 0x48 } "滴"
  0x7684,  // { 0x93, 0x49 } "的"
  0x7B1B,  // { 0x93, 0x4A } "笛"
  0x9069,  // { 0x93, 0x4B } "適"
  0x93D1,  // { 0x93, 0x4C } "鏑"
  0x6EBA,  // { 0x93, 0x4D } "溺"
  0x54F2,  // { 0x93, 0x4E } "哲"
  0x5FB9,  // { 0x93, 0x4F } "徹"
  0x64A4,  // { 0x93, 0x50 } "撤"
  0x8F4D,  // { 0x93, 0x51 } "轍"
  0x8FED,  // { 0x93, 0x52 } "迭"
  0x9244,  // { 0x93, 0x53 } "鉄"
  0x5178,  // { 0x93, 0x54 } "典"
  0x586B,  // { 0x93, 0x55 } "填"
  0x5929,  // { 0x93, 0x56 } "天"
  0x5C55,  // { 0x93, 0x57 } "展"
  0x5E97,  // { 0x93, 0x58 } "店"
  0x6DFB,  // { 0x93, 0x59 } "添"
  0x7E8F,  // { 0x93, 0x5A } "纏"
  0x751C,  // { 0x93, 0x5B } "甜"
  0x8CBC,  // { 0x93, 0x5C } "貼"
  0x8EE2,  // { 0x93, 0x5D } "転"
  0x985B,  // { 0x93, 0x5E } "顛"
  0x70B9,  // { 0x93, 0x5F } "点"
  0x4F1D,  // { 0x93, 0x60 } "伝"
  0x6BBF,  // { 0x93, 0x61 } "殿"
  0x6FB1,  // { 0x93, 0x62 } "澱"
  0x7530,  // { 0x93, 0x63 } "田"
  0x96FB,  // { 0x93, 0x64 } "電"
  0x514E,  // { 0x93, 0x65 } "兎"
  0x5410,  // { 0x93, 0x66 } "吐"
  0x5835,  // { 0x93, 0x67 } "堵"
  0x5857,  // { 0x93, 0x68 } "塗"
  0x59AC,  // { 0x93, 0x69 } "妬"
  0x5C60,  // { 0x93, 0x6A } "屠"
  0x5F92,  // { 0x93, 0x6B } "徒"
  0x6597,  // { 0x93, 0x6C } "斗"
  0x675C,  // { 0x93, 0x6D } "杜"
  0x6E21,  // { 0x93, 0x6E } "渡"
  0x767B,  // { 0x93, 0x6F } "登"
  0x83DF,  // { 0x93, 0x70 } "菟"
  0x8CED,  // { 0x93, 0x71 } "賭"
  0x9014,  // { 0x93, 0x72 } "途"
  0x90FD,  // { 0x93, 0x73 } "都"
  0x934D,  // { 0x93, 0x74 } "鍍"
  0x7825,  // { 0x93, 0x75 } "砥"
  0x783A,  // { 0x93, 0x76 } "砺"
  0x52AA,  // { 0x93, 0x77 } "努"
  0x5EA6,  // { 0x93, 0x78 } "度"
  0x571F,  // { 0x93, 0x79 } "土"
  0x5974,  // { 0x93, 0x7A } "奴"
  0x6012,  // { 0x93, 0x7B } "怒"
  0x5012,  // { 0x93, 0x7C } "倒"
  0x515A,  // { 0x93, 0x7D } "党"
  0x51AC,  // { 0x93, 0x7E } "冬"
  0x51CD,  // { 0x93, 0x80 } "凍"
  0x5200,  // { 0x93, 0x81 } "刀"
  0x5510,  // { 0x93, 0x82 } "唐"
  0x5854,  // { 0x93, 0x83 } "塔"
  0x5858,  // { 0x93, 0x84 } "塘"
  0x5957,  // { 0x93, 0x85 } "套"
  0x5B95,  // { 0x93, 0x86 } "宕"
  0x5CF6,  // { 0x93, 0x87 } "島"
  0x5D8B,  // { 0x93, 0x88 } "嶋"
  0x60BC,  // { 0x93, 0x89 } "悼"
  0x6295,  // { 0x93, 0x8A } "投"
  0x642D,  // { 0x93, 0x8B } "搭"
  0x6771,  // { 0x93, 0x8C } "東"
  0x6843,  // { 0x93, 0x8D } "桃"
  0x68BC,  // { 0x93, 0x8E } "梼"
  0x68DF,  // { 0x93, 0x8F } "棟"
  0x76D7,  // { 0x93, 0x90 } "盗"
  0x6DD8,  // { 0x93, 0x91 } "淘"
  0x6E6F,  // { 0x93, 0x92 } "湯"
  0x6D9B,  // { 0x93, 0x93 } "涛"
  0x706F,  // { 0x93, 0x94 } "灯"
  0x71C8,  // { 0x93, 0x95 } "燈"
  0x5F53,  // { 0x93, 0x96 } "当"
  0x75D8,  // { 0x93, 0x97 } "痘"
  0x7977,  // { 0x93, 0x98 } "祷"
  0x7B49,  // { 0x93, 0x99 } "等"
  0x7B54,  // { 0x93, 0x9A } "答"
  0x7B52,  // { 0x93, 0x9B } "筒"
  0x7CD6,  // { 0x93, 0x9C } "糖"
  0x7D71,  // { 0x93, 0x9D } "統"
  0x5230,  // { 0x93, 0x9E } "到"
  0x8463,  // { 0x93, 0x9F } "董"
  0x8569,  // { 0x93, 0xA0 } "蕩"
  0x85E4,  // { 0x93, 0xA1 } "藤"
  0x8A0E,  // { 0x93, 0xA2 } "討"
  0x8B04,  // { 0x93, 0xA3 } "謄"
  0x8C46,  // { 0x93, 0xA4 } "豆"
  0x8E0F,  // { 0x93, 0xA5 } "踏"
  0x9003,  // { 0x93, 0xA6 } "逃"
  0x900F,  // { 0x93, 0xA7 } "透"
  0x9419,  // { 0x93, 0xA8 } "鐙"
  0x9676,  // { 0x93, 0xA9 } "陶"
  0x982D,  // { 0x93, 0xAA } "頭"
  0x9A30,  // { 0x93, 0xAB } "騰"
  0x95D8,  // { 0x93, 0xAC } "闘"
  0x50CD,  // { 0x93, 0xAD } "働"
  0x52D5,  // { 0x93, 0xAE } "動"
  0x540C,  // { 0x93, 0xAF } "同"
  0x5802,  // { 0x93, 0xB0 } "堂"
  0x5C0E,  // { 0x93, 0xB1 } "導"
  0x61A7,  // { 0x93, 0xB2 } "憧"
  0x649E,  // { 0x93, 0xB3 } "撞"
  0x6D1E,  // { 0x93, 0xB4 } "洞"
  0x77B3,  // { 0x93, 0xB5 } "瞳"
  0x7AE5,  // { 0x93, 0xB6 } "童"
  0x80F4,  // { 0x93, 0xB7 } "胴"
  0x8404,  // { 0x93, 0xB8 } "萄"
  0x9053,  // { 0x93, 0xB9 } "道"
  0x9285,  // { 0x93, 0xBA } "銅"
  0x5CE0,  // { 0x93, 0xBB } "峠"
  0x9D07,  // { 0x93, 0xBC } "鴇"
  0x533F,  // { 0x93, 0xBD } "匿"
  0x5F97,  // { 0x93, 0xBE } "得"
  0x5FB3,  // { 0x93, 0xBF } "徳"
  0x6D9C,  // { 0x93, 0xC0 } "涜"
  0x7279,  // { 0x93, 0xC1 } "特"
  0x7763,  // { 0x93, 0xC2 } "督"
  0x79BF,  // { 0x93, 0xC3 } "禿"
  0x7BE4,  // { 0x93, 0xC4 } "篤"
  0x6BD2,  // { 0x93, 0xC5 } "毒"
  0x72EC,  // { 0x93, 0xC6 } "独"
  0x8AAD,  // { 0x93, 0xC7 } "読"
  0x6803,  // { 0x93, 0xC8 } "栃"
  0x6A61,  // { 0x93, 0xC9 } "橡"
  0x51F8,  // { 0x93, 0xCA } "凸"
  0x7A81,  // { 0x93, 0xCB } "突"
  0x6934,  // { 0x93, 0xCC } "椴"
  0x5C4A,  // { 0x93, 0xCD } "届"
  0x9CF6,  // { 0x93, 0xCE } "鳶"
  0x82EB,  // { 0x93, 0xCF } "苫"
  0x5BC5,  // { 0x93, 0xD0 } "寅"
  0x9149,  // { 0x93, 0xD1 } "酉"
  0x701E,  // { 0x93, 0xD2 } "瀞"
  0x5678,  // { 0x93, 0xD3 } "噸"
  0x5C6F,  // { 0x93, 0xD4 } "屯"
  0x60C7,  // { 0x93, 0xD5 } "惇"
  0x6566,  // { 0x93, 0xD6 } "敦"
  0x6C8C,  // { 0x93, 0xD7 } "沌"
  0x8C5A,  // { 0x93, 0xD8 } "豚"
  0x9041,  // { 0x93, 0xD9 } "遁"
  0x9813,  // { 0x93, 0xDA } "頓"
  0x5451,  // { 0x93, 0xDB } "呑"
  0x66C7,  // { 0x93, 0xDC } "曇"
  0x920D,  // { 0x93, 0xDD } "鈍"
  0x5948,  // { 0x93, 0xDE } "奈"
  0x90A3,  // { 0x93, 0xDF } "那"
  0x5185,  // { 0x93, 0xE0 } "内"
  0x4E4D,  // { 0x93, 0xE1 } "乍"
  0x51EA,  // { 0x93, 0xE2 } "凪"
  0x8599,  // { 0x93, 0xE3 } "薙"
  0x8B0E,  // { 0x93, 0xE4 } "謎"
  0x7058,  // { 0x93, 0xE5 } "灘"
  0x637A,  // { 0x93, 0xE6 } "捺"
  0x934B,  // { 0x93, 0xE7 } "鍋"
  0x6962,  // { 0x93, 0xE8 } "楢"
  0x99B4,  // { 0x93, 0xE9 } "馴"
  0x7E04,  // { 0x93, 0xEA } "縄"
  0x7577,  // { 0x93, 0xEB } "畷"
  0x5357,  // { 0x93, 0xEC } "南"
  0x6960,  // { 0x93, 0xED } "楠"
  0x8EDF,  // { 0x93, 0xEE } "軟"
  0x96E3,  // { 0x93, 0xEF } "難"
  0x6C5D,  // { 0x93, 0xF0 } "汝"
  0x4E8C,  // { 0x93, 0xF1 } "二"
  0x5C3C,  // { 0x93, 0xF2 } "尼"
  0x5F10,  // { 0x93, 0xF3 } "弐"
  0x8FE9,  // { 0x93, 0xF4 } "迩"
  0x5302,  // { 0x93, 0xF5 } "匂"
  0x8CD1,  // { 0x93, 0xF6 } "賑"
  0x8089,  // { 0x93, 0xF7 } "肉"
  0x8679,  // { 0x93, 0xF8 } "虹"
  0x5EFF,  // { 0x93, 0xF9 } "廿"
  0x65E5,  // { 0x93, 0xFA } "日"
  0x4E73,  // { 0x93, 0xFB } "乳"
  0x5165,  // { 0x93, 0xFC } "入"
  0x0000,  // { 0x93, 0xFD }
  0x0000,  // { 0x93, 0xFE }
  0x0000,  // { 0x93, 0xFF }
  0x5982,  // { 0x94, 0x40 } "如"
  0x5C3F,  // { 0x94, 0x41 } "尿"
  0x97EE,  // { 0x94, 0x42 } "韮"
  0x4EFB,  // { 0x94, 0x43 } "任"
  0x598A,  // { 0x94, 0x44 } "妊"
  0x5FCD,  // { 0x94, 0x45 } "忍"
  0x8A8D,  // { 0x94, 0x46 } "認"
  0x6FE1,  // { 0x94, 0x47 } "濡"
  0x79B0,  // { 0x94, 0x48 } "禰"
  0x7962,  // { 0x94, 0x49 } "祢"
  0x5BE7,  // { 0x94, 0x4A } "寧"
  0x8471,  // { 0x94, 0x4B } "葱"
  0x732B,  // { 0x94, 0x4C } "猫"
  0x71B1,  // { 0x94, 0x4D } "熱"
  0x5E74,  // { 0x94, 0x4E } "年"
  0x5FF5,  // { 0x94, 0x4F } "念"
  0x637B,  // { 0x94, 0x50 } "捻"
  0x649A,  // { 0x94, 0x51 } "撚"
  0x71C3,  // { 0x94, 0x52 } "燃"
  0x7C98,  // { 0x94, 0x53 } "粘"
  0x4E43,  // { 0x94, 0x54 } "乃"
  0x5EFC,  // { 0x94, 0x55 } "廼"
  0x4E4B,  // { 0x94, 0x56 } "之"
  0x57DC,  // { 0x94, 0x57 } "埜"
  0x56A2,  // { 0x94, 0x58 } "嚢"
  0x60A9,  // { 0x94, 0x59 } "悩"
  0x6FC3,  // { 0x94, 0x5A } "濃"
  0x7D0D,  // { 0x94, 0x5B } "納"
  0x80FD,  // { 0x94, 0x5C } "能"
  0x8133,  // { 0x94, 0x5D } "脳"
  0x81BF,  // { 0x94, 0x5E } "膿"
  0x8FB2,  // { 0x94, 0x5F } "農"
  0x8997,  // { 0x94, 0x60 } "覗"
  0x86A4,  // { 0x94, 0x61 } "蚤"
  0x5DF4,  // { 0x94, 0x62 } "巴"
  0x628A,  // { 0x94, 0x63 } "把"
  0x64AD,  // { 0x94, 0x64 } "播"
  0x8987,  // { 0x94, 0x65 } "覇"
  0x6777,  // { 0x94, 0x66 } "杷"
  0x6CE2,  // { 0x94, 0x67 } "波"
  0x6D3E,  // { 0x94, 0x68 } "派"
  0x7436,  // { 0x94, 0x69 } "琶"
  0x7834,  // { 0x94, 0x6A } "破"
  0x5A46,  // { 0x94, 0x6B } "婆"
  0x7F75,  // { 0x94, 0x6C } "罵"
  0x82AD,  // { 0x94, 0x6D } "芭"
  0x99AC,  // { 0x94, 0x6E } "馬"
  0x4FF3,  // { 0x94, 0x6F } "俳"
  0x5EC3,  // { 0x94, 0x70 } "廃"
  0x62DD,  // { 0x94, 0x71 } "拝"
  0x6392,  // { 0x94, 0x72 } "排"
  0x6557,  // { 0x94, 0x73 } "敗"
  0x676F,  // { 0x94, 0x74 } "杯"
  0x76C3,  // { 0x94, 0x75 } "盃"
  0x724C,  // { 0x94, 0x76 } "牌"
  0x80CC,  // { 0x94, 0x77 } "背"
  0x80BA,  // { 0x94, 0x78 } "肺"
  0x8F29,  // { 0x94, 0x79 } "輩"
  0x914D,  // { 0x94, 0x7A } "配"
  0x500D,  // { 0x94, 0x7B } "倍"
  0x57F9,  // { 0x94, 0x7C } "培"
  0x5A92,  // { 0x94, 0x7D } "媒"
  0x6885,  // { 0x94, 0x7E } "梅"
  0x6973,  // { 0x94, 0x80 } "楳"
  0x7164,  // { 0x94, 0x81 } "煤"
  0x72FD,  // { 0x94, 0x82 } "狽"
  0x8CB7,  // { 0x94, 0x83 } "買"
  0x58F2,  // { 0x94, 0x84 } "売"
  0x8CE0,  // { 0x94, 0x85 } "賠"
  0x966A,  // { 0x94, 0x86 } "陪"
  0x9019,  // { 0x94, 0x87 } "這"
  0x877F,  // { 0x94, 0x88 } "蝿"
  0x79E4,  // { 0x94, 0x89 } "秤"
  0x77E7,  // { 0x94, 0x8A } "矧"
  0x8429,  // { 0x94, 0x8B } "萩"
  0x4F2F,  // { 0x94, 0x8C } "伯"
  0x5265,  // { 0x94, 0x8D } "剥"
  0x535A,  // { 0x94, 0x8E } "博"
  0x62CD,  // { 0x94, 0x8F } "拍"
  0x67CF,  // { 0x94, 0x90 } "柏"
  0x6CCA,  // { 0x94, 0x91 } "泊"
  0x767D,  // { 0x94, 0x92 } "白"
  0x7B94,  // { 0x94, 0x93 } "箔"
  0x7C95,  // { 0x94, 0x94 } "粕"
  0x8236,  // { 0x94, 0x95 } "舶"
  0x8584,  // { 0x94, 0x96 } "薄"
  0x8FEB,  // { 0x94, 0x97 } "迫"
  0x66DD,  // { 0x94, 0x98 } "曝"
  0x6F20,  // { 0x94, 0x99 } "漠"
  0x7206,  // { 0x94, 0x9A } "爆"
  0x7E1B,  // { 0x94, 0x9B } "縛"
  0x83AB,  // { 0x94, 0x9C } "莫"
  0x99C1,  // { 0x94, 0x9D } "駁"
  0x9EA6,  // { 0x94, 0x9E } "麦"
  0x51FD,  // { 0x94, 0x9F } "函"
  0x7BB1,  // { 0x94, 0xA0 } "箱"
  0x7872,  // { 0x94, 0xA1 } "硲"
  0x7BB8,  // { 0x94, 0xA2 } "箸"
  0x8087,  // { 0x94, 0xA3 } "肇"
  0x7B48,  // { 0x94, 0xA4 } "筈"
  0x6AE8,  // { 0x94, 0xA5 } "櫨"
  0x5E61,  // { 0x94, 0xA6 } "幡"
  0x808C,  // { 0x94, 0xA7 } "肌"
  0x7551,  // { 0x94, 0xA8 } "畑"
  0x7560,  // { 0x94, 0xA9 } "畠"
  0x516B,  // { 0x94, 0xAA } "八"
  0x9262,  // { 0x94, 0xAB } "鉢"
  0x6E8C,  // { 0x94, 0xAC } "溌"
  0x767A,  // { 0x94, 0xAD } "発"
  0x9197,  // { 0x94, 0xAE } "醗"
  0x9AEA,  // { 0x94, 0xAF } "髪"
  0x4F10,  // { 0x94, 0xB0 } "伐"
  0x7F70,  // { 0x94, 0xB1 } "罰"
  0x629C,  // { 0x94, 0xB2 } "抜"
  0x7B4F,  // { 0x94, 0xB3 } "筏"
  0x95A5,  // { 0x94, 0xB4 } "閥"
  0x9CE9,  // { 0x94, 0xB5 } "鳩"
  0x567A,  // { 0x94, 0xB6 } "噺"
  0x5859,  // { 0x94, 0xB7 } "塙"
  0x86E4,  // { 0x94, 0xB8 } "蛤"
  0x96BC,  // { 0x94, 0xB9 } "隼"
  0x4F34,  // { 0x94, 0xBA } "伴"
  0x5224,  // { 0x94, 0xBB } "判"
  0x534A,  // { 0x94, 0xBC } "半"
  0x53CD,  // { 0x94, 0xBD } "反"
  0x53DB,  // { 0x94, 0xBE } "叛"
  0x5E06,  // { 0x94, 0xBF } "帆"
  0x642C,  // { 0x94, 0xC0 } "搬"
  0x6591,  // { 0x94, 0xC1 } "斑"
  0x677F,  // { 0x94, 0xC2 } "板"
  0x6C3E,  // { 0x94, 0xC3 } "氾"
  0x6C4E,  // { 0x94, 0xC4 } "汎"
  0x7248,  // { 0x94, 0xC5 } "版"
  0x72AF,  // { 0x94, 0xC6 } "犯"
  0x73ED,  // { 0x94, 0xC7 } "班"
  0x7554,  // { 0x94, 0xC8 } "畔"
  0x7E41,  // { 0x94, 0xC9 } "繁"
  0x822C,  // { 0x94, 0xCA } "般"
  0x85E9,  // { 0x94, 0xCB } "藩"
  0x8CA9,  // { 0x94, 0xCC } "販"
  0x7BC4,  // { 0x94, 0xCD } "範"
  0x91C6,  // { 0x94, 0xCE } "釆"
  0x7169,  // { 0x94, 0xCF } "煩"
  0x9812,  // { 0x94, 0xD0 } "頒"
  0x98EF,  // { 0x94, 0xD1 } "飯"
  0x633D,  // { 0x94, 0xD2 } "挽"
  0x6669,  // { 0x94, 0xD3 } "晩"
  0x756A,  // { 0x94, 0xD4 } "番"
  0x76E4,  // { 0x94, 0xD5 } "盤"
  0x78D0,  // { 0x94, 0xD6 } "磐"
  0x8543,  // { 0x94, 0xD7 } "蕃"
  0x86EE,  // { 0x94, 0xD8 } "蛮"
  0x532A,  // { 0x94, 0xD9 } "匪"
  0x5351,  // { 0x94, 0xDA } "卑"
  0x5426,  // { 0x94, 0xDB } "否"
  0x5983,  // { 0x94, 0xDC } "妃"
  0x5E87,  // { 0x94, 0xDD } "庇"
  0x5F7C,  // { 0x94, 0xDE } "彼"
  0x60B2,  // { 0x94, 0xDF } "悲"
  0x6249,  // { 0x94, 0xE0 } "扉"
  0x6279,  // { 0x94, 0xE1 } "批"
  0x62AB,  // { 0x94, 0xE2 } "披"
  0x6590,  // { 0x94, 0xE3 } "斐"
  0x6BD4,  // { 0x94, 0xE4 } "比"
  0x6CCC,  // { 0x94, 0xE5 } "泌"
  0x75B2,  // { 0x94, 0xE6 } "疲"
  0x76AE,  // { 0x94, 0xE7 } "皮"
  0x7891,  // { 0x94, 0xE8 } "碑"
  0x79D8,  // { 0x94, 0xE9 } "秘"
  0x7DCB,  // { 0x94, 0xEA } "緋"
  0x7F77,  // { 0x94, 0xEB } "罷"
  0x80A5,  // { 0x94, 0xEC } "肥"
  0x88AB,  // { 0x94, 0xED } "被"
  0x8AB9,  // { 0x94, 0xEE } "誹"
  0x8CBB,  // { 0x94, 0xEF } "費"
  0x907F,  // { 0x94, 0xF0 } "避"
  0x975E,  // { 0x94, 0xF1 } "非"
  0x98DB,  // { 0x94, 0xF2 } "飛"
  0x6A0B,  // { 0x94, 0xF3 } "樋"
  0x7C38,  // { 0x94, 0xF4 } "簸"
  0x5099,  // { 0x94, 0xF5 } "備"
  0x5C3E,  // { 0x94, 0xF6 } "尾"
  0x5FAE,  // { 0x94, 0xF7 } "微"
  0x6787,  // { 0x94, 0xF8 } "枇"
  0x6BD8,  // { 0x94, 0xF9 } "毘"
  0x7435,  // { 0x94, 0xFA } "琵"
  0x7709,  // { 0x94, 0xFB } "眉"
  0x7F8E,  // { 0x94, 0xFC } "美"
  0x0000,  // { 0x94, 0xFD }
  0x0000,  // { 0x94, 0xFE }
  0x0000,  // { 0x94, 0xFF }
  0x9F3B,  // { 0x95, 0x40 } "鼻"
  0x67CA,  // { 0x95, 0x41 } "柊"
  0x7A17,  // { 0x95, 0x42 } "稗"
  0x5339,  // { 0x95, 0x43 } "匹"
  0x758B,  // { 0x95, 0x44 } "疋"
  0x9AED,  // { 0x95, 0x45 } "髭"
  0x5F66,  // { 0x95, 0x46 } "彦"
  0x819D,  // { 0x95, 0x47 } "膝"
  0x83F1,  // { 0x95, 0x48 } "菱"
  0x8098,  // { 0x95, 0x49 } "肘"
  0x5F3C,  // { 0x95, 0x4A } "弼"
  0x5FC5,  // { 0x95, 0x4B } "必"
  0x7562,  // { 0x95, 0x4C } "畢"
  0x7B46,  // { 0x95, 0x4D } "筆"
  0x903C,  // { 0x95, 0x4E } "逼"
  0x6867,  // { 0x95, 0x4F } "桧"
  0x59EB,  // { 0x95, 0x50 } "姫"
  0x5A9B,  // { 0x95, 0x51 } "媛"
  0x7D10,  // { 0x95, 0x52 } "紐"
  0x767E,  // { 0x95, 0x53 } "百"
  0x8B2C,  // { 0x95, 0x54 } "謬"
  0x4FF5,  // { 0x95, 0x55 } "俵"
  0x5F6A,  // { 0x95, 0x56 } "彪"
  0x6A19,  // { 0x95, 0x57 } "標"
  0x6C37,  // { 0x95, 0x58 } "氷"
  0x6F02,  // { 0x95, 0x59 } "漂"
  0x74E2,  // { 0x95, 0x5A } "瓢"
  0x7968,  // { 0x95, 0x5B } "票"
  0x8868,  // { 0x95, 0x5C } "表"
  0x8A55,  // { 0x95, 0x5D } "評"
  0x8C79,  // { 0x95, 0x5E } "豹"
  0x5EDF,  // { 0x95, 0x5F } "廟"
  0x63CF,  // { 0x95, 0x60 } "描"
  0x75C5,  // { 0x95, 0x61 } "病"
  0x79D2,  // { 0x95, 0x62 } "秒"
  0x82D7,  // { 0x95, 0x63 } "苗"
  0x9328,  // { 0x95, 0x64 } "錨"
  0x92F2,  // { 0x95, 0x65 } "鋲"
  0x849C,  // { 0x95, 0x66 } "蒜"
  0x86ED,  // { 0x95, 0x67 } "蛭"
  0x9C2D,  // { 0x95, 0x68 } "鰭"
  0x54C1,  // { 0x95, 0x69 } "品"
  0x5F6C,  // { 0x95, 0x6A } "彬"
  0x658C,  // { 0x95, 0x6B } "斌"
  0x6D5C,  // { 0x95, 0x6C } "浜"
  0x7015,  // { 0x95, 0x6D } "瀕"
  0x8CA7,  // { 0x95, 0x6E } "貧"
  0x8CD3,  // { 0x95, 0x6F } "賓"
  0x983B,  // { 0x95, 0x70 } "頻"
  0x654F,  // { 0x95, 0x71 } "敏"
  0x74F6,  // { 0x95, 0x72 } "瓶"
  0x4E0D,  // { 0x95, 0x73 } "不"
  0x4ED8,  // { 0x95, 0x74 } "付"
  0x57E0,  // { 0x95, 0x75 } "埠"
  0x592B,  // { 0x95, 0x76 } "夫"
  0x5A66,  // { 0x95, 0x77 } "婦"
  0x5BCC,  // { 0x95, 0x78 } "富"
  0x51A8,  // { 0x95, 0x79 } "冨"
  0x5E03,  // { 0x95, 0x7A } "布"
  0x5E9C,  // { 0x95, 0x7B } "府"
  0x6016,  // { 0x95, 0x7C } "怖"
  0x6276,  // { 0x95, 0x7D } "扶"
  0x6577,  // { 0x95, 0x7E } "敷"
  0x65A7,  // { 0x95, 0x80 } "斧"
  0x666E,  // { 0x95, 0x81 } "普"
  0x6D6E,  // { 0x95, 0x82 } "浮"
  0x7236,  // { 0x95, 0x83 } "父"
  0x7B26,  // { 0x95, 0x84 } "符"
  0x8150,  // { 0x95, 0x85 } "腐"
  0x819A,  // { 0x95, 0x86 } "膚"
  0x8299,  // { 0x95, 0x87 } "芙"
  0x8B5C,  // { 0x95, 0x88 } "譜"
  0x8CA0,  // { 0x95, 0x89 } "負"
  0x8CE6,  // { 0x95, 0x8A } "賦"
  0x8D74,  // { 0x95, 0x8B } "赴"
  0x961C,  // { 0x95, 0x8C } "阜"
  0x9644,  // { 0x95, 0x8D } "附"
  0x4FAE,  // { 0x95, 0x8E } "侮"
  0x64AB,  // { 0x95, 0x8F } "撫"
  0x6B66,  // { 0x95, 0x90 } "武"
  0x821E,  // { 0x95, 0x91 } "舞"
  0x8461,  // { 0x95, 0x92 } "葡"
  0x856A,  // { 0x95, 0x93 } "蕪"
  0x90E8,  // { 0x95, 0x94 } "部"
  0x5C01,  // { 0x95, 0x95 } "封"
  0x6953,  // { 0x95, 0x96 } "楓"
  0x98A8,  // { 0x95, 0x97 } "風"
  0x847A,  // { 0x95, 0x98 } "葺"
  0x8557,  // { 0x95, 0x99 } "蕗"
  0x4F0F,  // { 0x95, 0x9A } "伏"
  0x526F,  // { 0x95, 0x9B } "副"
  0x5FA9,  // { 0x95, 0x9C } "復"
  0x5E45,  // { 0x95, 0x9D } "幅"
  0x670D,  // { 0x95, 0x9E } "服"
  0x798F,  // { 0x95, 0x9F } "福"
  0x8179,  // { 0x95, 0xA0 } "腹"
  0x8907,  // { 0x95, 0xA1 } "複"
  0x8986,  // { 0x95, 0xA2 } "覆"
  0x6DF5,  // { 0x95, 0xA3 } "淵"
  0x5F17,  // { 0x95, 0xA4 } "弗"
  0x6255,  // { 0x95, 0xA5 } "払"
  0x6CB8,  // { 0x95, 0xA6 } "沸"
  0x4ECF,  // { 0x95, 0xA7 } "仏"
  0x7269,  // { 0x95, 0xA8 } "物"
  0x9B92,  // { 0x95, 0xA9 } "鮒"
  0x5206,  // { 0x95, 0xAA } "分"
  0x543B,  // { 0x95, 0xAB } "吻"
  0x5674,  // { 0x95, 0xAC } "噴"
  0x58B3,  // { 0x95, 0xAD } "墳"
  0x61A4,  // { 0x95, 0xAE } "憤"
  0x626E,  // { 0x95, 0xAF } "扮"
  0x711A,  // { 0x95, 0xB0 } "焚"
  0x596E,  // { 0x95, 0xB1 } "奮"
  0x7C89,  // { 0x95, 0xB2 } "粉"
  0x7CDE,  // { 0x95, 0xB3 } "糞"
  0x7D1B,  // { 0x95, 0xB4 } "紛"
  0x96F0,  // { 0x95, 0xB5 } "雰"
  0x6587,  // { 0x95, 0xB6 } "文"
  0x805E,  // { 0x95, 0xB7 } "聞"
  0x4E19,  // { 0x95, 0xB8 } "丙"
  0x4F75,  // { 0x95, 0xB9 } "併"
  0x5175,  // { 0x95, 0xBA } "兵"
  0x5840,  // { 0x95, 0xBB } "塀"
  0x5E63,  // { 0x95, 0xBC } "幣"
  0x5E73,  // { 0x95, 0xBD } "平"
  0x5F0A,  // { 0x95, 0xBE } "弊"
  0x67C4,  // { 0x95, 0xBF } "柄"
  0x4E26,  // { 0x95, 0xC0 } "並"
  0x853D,  // { 0x95, 0xC1 } "蔽"
  0x9589,  // { 0x95, 0xC2 } "閉"
  0x965B,  // { 0x95, 0xC3 } "陛"
  0x7C73,  // { 0x95, 0xC4 } "米"
  0x9801,  // { 0x95, 0xC5 } "頁"
  0x50FB,  // { 0x95, 0xC6 } "僻"
  0x58C1,  // { 0x95, 0xC7 } "壁"
  0x7656,  // { 0x95, 0xC8 } "癖"
  0x78A7,  // { 0x95, 0xC9 } "碧"
  0x5225,  // { 0x95, 0xCA } "別"
  0x77A5,  // { 0x95, 0xCB } "瞥"
  0x8511,  // { 0x95, 0xCC } "蔑"
  0x7B86,  // { 0x95, 0xCD } "箆"
  0x504F,  // { 0x95, 0xCE } "偏"
  0x5909,  // { 0x95, 0xCF } "変"
  0x7247,  // { 0x95, 0xD0 } "片"
  0x7BC7,  // { 0x95, 0xD1 } "篇"
  0x7DE8,  // { 0x95, 0xD2 } "編"
  0x8FBA,  // { 0x95, 0xD3 } "辺"
  0x8FD4,  // { 0x95, 0xD4 } "返"
  0x904D,  // { 0x95, 0xD5 } "遍"
  0x4FBF,  // { 0x95, 0xD6 } "便"
  0x52C9,  // { 0x95, 0xD7 } "勉"
  0x5A29,  // { 0x95, 0xD8 } "娩"
  0x5F01,  // { 0x95, 0xD9 } "弁"
  0x97AD,  // { 0x95, 0xDA } "鞭"
  0x4FDD,  // { 0x95, 0xDB } "保"
  0x8217,  // { 0x95, 0xDC } "舗"
  0x92EA,  // { 0x95, 0xDD } "鋪"
  0x5703,  // { 0x95, 0xDE } "圃"
  0x6355,  // { 0x95, 0xDF } "捕"
  0x6B69,  // { 0x95, 0xE0 } "歩"
  0x752B,  // { 0x95, 0xE1 } "甫"
  0x88DC,  // { 0x95, 0xE2 } "補"
  0x8F14,  // { 0x95, 0xE3 } "輔"
  0x7A42,  // { 0x95, 0xE4 } "穂"
  0x52DF,  // { 0x95, 0xE5 } "募"
  0x5893,  // { 0x95, 0xE6 } "墓"
  0x6155,  // { 0x95, 0xE7 } "慕"
  0x620A,  // { 0x95, 0xE8 } "戊"
  0x66AE,  // { 0x95, 0xE9 } "暮"
  0x6BCD,  // { 0x95, 0xEA } "母"
  0x7C3F,  // { 0x95, 0xEB } "簿"
  0x83E9,  // { 0x95, 0xEC } "菩"
  0x5023,  // { 0x95, 0xED } "倣"
  0x4FF8,  // { 0x95, 0xEE } "俸"
  0x5305,  // { 0x95, 0xEF } "包"
  0x5446,  // { 0x95, 0xF0 } "呆"
  0x5831,  // { 0x95, 0xF1 } "報"
  0x5949,  // { 0x95, 0xF2 } "奉"
  0x5B9D,  // { 0x95, 0xF3 } "宝"
  0x5CF0,  // { 0x95, 0xF4 } "峰"
  0x5CEF,  // { 0x95, 0xF5 } "峯"
  0x5D29,  // { 0x95, 0xF6 } "崩"
  0x5E96,  // { 0x95, 0xF7 } "庖"
  0x62B1,  // { 0x95, 0xF8 } "抱"
  0x6367,  // { 0x95, 0xF9 } "捧"
  0x653E,  // { 0x95, 0xFA } "放"
  0x65B9,  // { 0x95, 0xFB } "方"
  0x670B,  // { 0x95, 0xFC } "朋"
  0x0000,  // { 0x95, 0xFD }
  0x0000,  // { 0x95, 0xFE }
  0x0000,  // { 0x95, 0xFF }
  0x6CD5,  // { 0x96, 0x40 } "法"
  0x6CE1,  // { 0x96, 0x41 } "泡"
  0x70F9,  // { 0x96, 0x42 } "烹"
  0x7832,  // { 0x96, 0x43 } "砲"
  0x7E2B,  // { 0x96, 0x44 } "縫"
  0x80DE,  // { 0x96, 0x45 } "胞"
  0x82B3,  // { 0x96, 0x46 } "芳"
  0x840C,  // { 0x96, 0x47 } "萌"
  0x84EC,  // { 0x96, 0x48 } "蓬"
  0x8702,  // { 0x96, 0x49 } "蜂"
  0x8912,  // { 0x96, 0x4A } "褒"
  0x8A2A,  // { 0x96, 0x4B } "訪"
  0x8C4A,  // { 0x96, 0x4C } "豊"
  0x90A6,  // { 0x96, 0x4D } "邦"
  0x92D2,  // { 0x96, 0x4E } "鋒"
  0x98FD,  // { 0x96, 0x4F } "飽"
  0x9CF3,  // { 0x96, 0x50 } "鳳"
  0x9D6C,  // { 0x96, 0x51 } "鵬"
  0x4E4F,  // { 0x96, 0x52 } "乏"
  0x4EA1,  // { 0x96, 0x53 } "亡"
  0x508D,  // { 0x96, 0x54 } "傍"
  0x5256,  // { 0x96, 0x55 } "剖"
  0x574A,  // { 0x96, 0x56 } "坊"
  0x59A8,  // { 0x96, 0x57 } "妨"
  0x5E3D,  // { 0x96, 0x58 } "帽"
  0x5FD8,  // { 0x96, 0x59 } "忘"
  0x5FD9,  // { 0x96, 0x5A } "忙"
  0x623F,  // { 0x96, 0x5B } "房"
  0x66B4,  // { 0x96, 0x5C } "暴"
  0x671B,  // { 0x96, 0x5D } "望"
  0x67D0,  // { 0x96, 0x5E } "某"
  0x68D2,  // { 0x96, 0x5F } "棒"
  0x5192,  // { 0x96, 0x60 } "冒"
  0x7D21,  // { 0x96, 0x61 } "紡"
  0x80AA,  // { 0x96, 0x62 } "肪"
  0x81A8,  // { 0x96, 0x63 } "膨"
  0x8B00,  // { 0x96, 0x64 } "謀"
  0x8C8C,  // { 0x96, 0x65 } "貌"
  0x8CBF,  // { 0x96, 0x66 } "貿"
  0x927E,  // { 0x96, 0x67 } "鉾"
  0x9632,  // { 0x96, 0x68 } "防"
  0x5420,  // { 0x96, 0x69 } "吠"
  0x982C,  // { 0x96, 0x6A } "頬"
  0x5317,  // { 0x96, 0x6B } "北"
  0x50D5,  // { 0x96, 0x6C } "僕"
  0x535C,  // { 0x96, 0x6D } "卜"
  0x58A8,  // { 0x96, 0x6E } "墨"
  0x64B2,  // { 0x96, 0x6F } "撲"
  0x6734,  // { 0x96, 0x70 } "朴"
  0x7267,  // { 0x96, 0x71 } "牧"
  0x7766,  // { 0x96, 0x72 } "睦"
  0x7A46,  // { 0x96, 0x73 } "穆"
  0x91E6,  // { 0x96, 0x74 } "釦"
  0x52C3,  // { 0x96, 0x75 } "勃"
  0x6CA1,  // { 0x96, 0x76 } "没"
  0x6B86,  // { 0x96, 0x77 } "殆"
  0x5800,  // { 0x96, 0x78 } "堀"
  0x5E4C,  // { 0x96, 0x79 } "幌"
  0x5954,  // { 0x96, 0x7A } "奔"
  0x672C,  // { 0x96, 0x7B } "本"
  0x7FFB,  // { 0x96, 0x7C } "翻"
  0x51E1,  // { 0x96, 0x7D } "凡"
  0x76C6,  // { 0x96, 0x7E } "盆"
  0x6469,  // { 0x96, 0x80 } "摩"
  0x78E8,  // { 0x96, 0x81 } "磨"
  0x9B54,  // { 0x96, 0x82 } "魔"
  0x9EBB,  // { 0x96, 0x83 } "麻"
  0x57CB,  // { 0x96, 0x84 } "埋"
  0x59B9,  // { 0x96, 0x85 } "妹"
  0x6627,  // { 0x96, 0x86 } "昧"
  0x679A,  // { 0x96, 0x87 } "枚"
  0x6BCE,  // { 0x96, 0x88 } "毎"
  0x54E9,  // { 0x96, 0x89 } "哩"
  0x69D9,  // { 0x96, 0x8A } "槙"
  0x5E55,  // { 0x96, 0x8B } "幕"
  0x819C,  // { 0x96, 0x8C } "膜"
  0x6795,  // { 0x96, 0x8D } "枕"
  0x9BAA,  // { 0x96, 0x8E } "鮪"
  0x67FE,  // { 0x96, 0x8F } "柾"
  0x9C52,  // { 0x96, 0x90 } "鱒"
  0x685D,  // { 0x96, 0x91 } "桝"
  0x4EA6,  // { 0x96, 0x92 } "亦"
  0x4FE3,  // { 0x96, 0x93 } "俣"
  0x53C8,  // { 0x96, 0x94 } "又"
  0x62B9,  // { 0x96, 0x95 } "抹"
  0x672B,  // { 0x96, 0x96 } "末"
  0x6CAB,  // { 0x96, 0x97 } "沫"
  0x8FC4,  // { 0x96, 0x98 } "迄"
  0x4FAD,  // { 0x96, 0x99 } "侭"
  0x7E6D,  // { 0x96, 0x9A } "繭"
  0x9EBF,  // { 0x96, 0x9B } "麿"
  0x4E07,  // { 0x96, 0x9C } "万"
  0x6162,  // { 0x96, 0x9D } "慢"
  0x6E80,  // { 0x96, 0x9E } "満"
  0x6F2B,  // { 0x96, 0x9F } "漫"
  0x8513,  // { 0x96, 0xA0 } "蔓"
  0x5473,  // { 0x96, 0xA1 } "味"
  0x672A,  // { 0x96, 0xA2 } "未"
  0x9B45,  // { 0x96, 0xA3 } "魅"
  0x5DF3,  // { 0x96, 0xA4 } "巳"
  0x7B95,  // { 0x96, 0xA5 } "箕"
  0x5CAC,  // { 0x96, 0xA6 } "岬"
  0x5BC6,  // { 0x96, 0xA7 } "密"
  0x871C,  // { 0x96, 0xA8 } "蜜"
  0x6E4A,  // { 0x96, 0xA9 } "湊"
  0x84D1,  // { 0x96, 0xAA } "蓑"
  0x7A14,  // { 0x96, 0xAB } "稔"
  0x8108,  // { 0x96, 0xAC } "脈"
  0x5999,  // { 0x96, 0xAD } "妙"
  0x7C8D,  // { 0x96, 0xAE } "粍"
  0x6C11,  // { 0x96, 0xAF } "民"
  0x7720,  // { 0x96, 0xB0 } "眠"
  0x52D9,  // { 0x96, 0xB1 } "務"
  0x5922,  // { 0x96, 0xB2 } "夢"
  0x7121,  // { 0x96, 0xB3 } "無"
  0x725F,  // { 0x96, 0xB4 } "牟"
  0x77DB,  // { 0x96, 0xB5 } "矛"
  0x9727,  // { 0x96, 0xB6 } "霧"
  0x9D61,  // { 0x96, 0xB7 } "鵡"
  0x690B,  // { 0x96, 0xB8 } "椋"
  0x5A7F,  // { 0x96, 0xB9 } "婿"
  0x5A18,  // { 0x96, 0xBA } "娘"
  0x51A5,  // { 0x96, 0xBB } "冥"
  0x540D,  // { 0x96, 0xBC } "名"
  0x547D,  // { 0x96, 0xBD } "命"
  0x660E,  // { 0x96, 0xBE } "明"
  0x76DF,  // { 0x96, 0xBF } "盟"
  0x8FF7,  // { 0x96, 0xC0 } "迷"
  0x9298,  // { 0x96, 0xC1 } "銘"
  0x9CF4,  // { 0x96, 0xC2 } "鳴"
  0x59EA,  // { 0x96, 0xC3 } "姪"
  0x725D,  // { 0x96, 0xC4 } "牝"
  0x6EC5,  // { 0x96, 0xC5 } "滅"
  0x514D,  // { 0x96, 0xC6 } "免"
  0x68C9,  // { 0x96, 0xC7 } "棉"
  0x7DBF,  // { 0x96, 0xC8 } "綿"
  0x7DEC,  // { 0x96, 0xC9 } "緬"
  0x9762,  // { 0x96, 0xCA } "面"
  0x9EBA,  // { 0x96, 0xCB } "麺"
  0x6478,  // { 0x96, 0xCC } "摸"
  0x6A21,  // { 0x96, 0xCD } "模"
  0x8302,  // { 0x96, 0xCE } "茂"
  0x5984,  // { 0x96, 0xCF } "妄"
  0x5B5F,  // { 0x96, 0xD0 } "孟"
  0x6BDB,  // { 0x96, 0xD1 } "毛"
  0x731B,  // { 0x96, 0xD2 } "猛"
  0x76F2,  // { 0x96, 0xD3 } "盲"
  0x7DB2,  // { 0x96, 0xD4 } "網"
  0x8017,  // { 0x96, 0xD5 } "耗"
  0x8499,  // { 0x96, 0xD6 } "蒙"
  0x5132,  // { 0x96, 0xD7 } "儲"
  0x6728,  // { 0x96, 0xD8 } "木"
  0x9ED9,  // { 0x96, 0xD9 } "黙"
  0x76EE,  // { 0x96, 0xDA } "目"
  0x6762,  // { 0x96, 0xDB } "杢"
  0x52FF,  // { 0x96, 0xDC } "勿"
  0x9905,  // { 0x96, 0xDD } "餅"
  0x5C24,  // { 0x96, 0xDE } "尤"
  0x623B,  // { 0x96, 0xDF } "戻"
  0x7C7E,  // { 0x96, 0xE0 } "籾"
  0x8CB0,  // { 0x96, 0xE1 } "貰"
  0x554F,  // { 0x96, 0xE2 } "問"
  0x60B6,  // { 0x96, 0xE3 } "悶"
  0x7D0B,  // { 0x96, 0xE4 } "紋"
  0x9580,  // { 0x96, 0xE5 } "門"
  0x5301,  // { 0x96, 0xE6 } "匁"
  0x4E5F,  // { 0x96, 0xE7 } "也"
  0x51B6,  // { 0x96, 0xE8 } "冶"
  0x591C,  // { 0x96, 0xE9 } "夜"
  0x723A,  // { 0x96, 0xEA } "爺"
  0x8036,  // { 0x96, 0xEB } "耶"
  0x91CE,  // { 0x96, 0xEC } "野"
  0x5F25,  // { 0x96, 0xED } "弥"
  0x77E2,  // { 0x96, 0xEE } "矢"
  0x5384,  // { 0x96, 0xEF } "厄"
  0x5F79,  // { 0x96, 0xF0 } "役"
  0x7D04,  // { 0x96, 0xF1 } "約"
  0x85AC,  // { 0x96, 0xF2 } "薬"
  0x8A33,  // { 0x96, 0xF3 } "訳"
  0x8E8D,  // { 0x96, 0xF4 } "躍"
  0x9756,  // { 0x96, 0xF5 } "靖"
  0x67F3,  // { 0x96, 0xF6 } "柳"
  0x85AE,  // { 0x96, 0xF7 } "薮"
  0x9453,  // { 0x96, 0xF8 } "鑓"
  0x6109,  // { 0x96, 0xF9 } "愉"
  0x6108,  // { 0x96, 0xFA } "愈"
  0x6CB9,  // { 0x96, 0xFB } "油"
  0x7652,  // { 0x96, 0xFC } "癒"
  0x0000,  // { 0x96, 0xFD }
  0x0000,  // { 0x96, 0xFE }
  0x0000,  // { 0x96, 0xFF }
  0x8AED,  // { 0x97, 0x40 } "諭"
  0x8F38,  // { 0x97, 0x41 } "輸"
  0x552F,  // { 0x97, 0x42 } "唯"
  0x4F51,  // { 0x97, 0x43 } "佑"
  0x512A,  // { 0x97, 0x44 } "優"
  0x52C7,  // { 0x97, 0x45 } "勇"
  0x53CB,  // { 0x97, 0x46 } "友"
  0x5BA5,  // { 0x97, 0x47 } "宥"
  0x5E7D,  // { 0x97, 0x48 } "幽"
  0x60A0,  // { 0x97, 0x49 } "悠"
  0x6182,  // { 0x97, 0x4A } "憂"
  0x63D6,  // { 0x97, 0x4B } "揖"
  0x6709,  // { 0x97, 0x4C } "有"
  0x67DA,  // { 0x97, 0x4D } "柚"
  0x6E67,  // { 0x97, 0x4E } "湧"
  0x6D8C,  // { 0x97, 0x4F } "涌"
  0x7336,  // { 0x97, 0x50 } "猶"
  0x7337,  // { 0x97, 0x51 } "猷"
  0x7531,  // { 0x97, 0x52 } "由"
  0x7950,  // { 0x97, 0x53 } "祐"
  0x88D5,  // { 0x97, 0x54 } "裕"
  0x8A98,  // { 0x97, 0x55 } "誘"
  0x904A,  // { 0x97, 0x56 } "遊"
  0x9091,  // { 0x97, 0x57 } "邑"
  0x90F5,  // { 0x97, 0x58 } "郵"
  0x96C4,  // { 0x97, 0x59 } "雄"
  0x878D,  // { 0x97, 0x5A } "融"
  0x5915,  // { 0x97, 0x5B } "夕"
  0x4E88,  // { 0x97, 0x5C } "予"
  0x4F59,  // { 0x97, 0x5D } "余"
  0x4E0E,  // { 0x97, 0x5E } "与"
  0x8A89,  // { 0x97, 0x5F } "誉"
  0x8F3F,  // { 0x97, 0x60 } "輿"
  0x9810,  // { 0x97, 0x61 } "預"
  0x50AD,  // { 0x97, 0x62 } "傭"
  0x5E7C,  // { 0x97, 0x63 } "幼"
  0x5996,  // { 0x97, 0x64 } "妖"
  0x5BB9,  // { 0x97, 0x65 } "容"
  0x5EB8,  // { 0x97, 0x66 } "庸"
  0x63DA,  // { 0x97, 0x67 } "揚"
  0x63FA,  // { 0x97, 0x68 } "揺"
  0x64C1,  // { 0x97, 0x69 } "擁"
  0x66DC,  // { 0x97, 0x6A } "曜"
  0x694A,  // { 0x97, 0x6B } "楊"
  0x69D8,  // { 0x97, 0x6C } "様"
  0x6D0B,  // { 0x97, 0x6D } "洋"
  0x6EB6,  // { 0x97, 0x6E } "溶"
  0x7194,  // { 0x97, 0x6F } "熔"
  0x7528,  // { 0x97, 0x70 } "用"
  0x7AAF,  // { 0x97, 0x71 } "窯"
  0x7F8A,  // { 0x97, 0x72 } "羊"
  0x8000,  // { 0x97, 0x73 } "耀"
  0x8449,  // { 0x97, 0x74 } "葉"
  0x84C9,  // { 0x97, 0x75 } "蓉"
  0x8981,  // { 0x97, 0x76 } "要"
  0x8B21,  // { 0x97, 0x77 } "謡"
  0x8E0A,  // { 0x97, 0x78 } "踊"
  0x9065,  // { 0x97, 0x79 } "遥"
  0x967D,  // { 0x97, 0x7A } "陽"
  0x990A,  // { 0x97, 0x7B } "養"
  0x617E,  // { 0x97, 0x7C } "慾"
  0x6291,  // { 0x97, 0x7D } "抑"
  0x6B32,  // { 0x97, 0x7E } "欲"
  0x6C83,  // { 0x97, 0x80 } "沃"
  0x6D74,  // { 0x97, 0x81 } "浴"
  0x7FCC,  // { 0x97, 0x82 } "翌"
  0x7FFC,  // { 0x97, 0x83 } "翼"
  0x6DC0,  // { 0x97, 0x84 } "淀"
  0x7F85,  // { 0x97, 0x85 } "羅"
  0x87BA,  // { 0x97, 0x86 } "螺"
  0x88F8,  // { 0x97, 0x87 } "裸"
  0x6765,  // { 0x97, 0x88 } "来"
  0x83B1,  // { 0x97, 0x89 } "莱"
  0x983C,  // { 0x97, 0x8A } "頼"
  0x96F7,  // { 0x97, 0x8B } "雷"
  0x6D1B,  // { 0x97, 0x8C } "洛"
  0x7D61,  // { 0x97, 0x8D } "絡"
  0x843D,  // { 0x97, 0x8E } "落"
  0x916A,  // { 0x97, 0x8F } "酪"
  0x4E71,  // { 0x97, 0x90 } "乱"
  0x5375,  // { 0x97, 0x91 } "卵"
  0x5D50,  // { 0x97, 0x92 } "嵐"
  0x6B04,  // { 0x97, 0x93 } "欄"
  0x6FEB,  // { 0x97, 0x94 } "濫"
  0x85CD,  // { 0x97, 0x95 } "藍"
  0x862D,  // { 0x97, 0x96 } "蘭"
  0x89A7,  // { 0x97, 0x97 } "覧"
  0x5229,  // { 0x97, 0x98 } "利"
  0x540F,  // { 0x97, 0x99 } "吏"
  0x5C65,  // { 0x97, 0x9A } "履"
  0x674E,  // { 0x97, 0x9B } "李"
  0x68A8,  // { 0x97, 0x9C } "梨"
  0x7406,  // { 0x97, 0x9D } "理"
  0x7483,  // { 0x97, 0x9E } "璃"
  0x75E2,  // { 0x97, 0x9F } "痢"
  0x88CF,  // { 0x97, 0xA0 } "裏"
  0x88E1,  // { 0x97, 0xA1 } "裡"
  0x91CC,  // { 0x97, 0xA2 } "里"
  0x96E2,  // { 0x97, 0xA3 } "離"
  0x9678,  // { 0x97, 0xA4 } "陸"
  0x5F8B,  // { 0x97, 0xA5 } "律"
  0x7387,  // { 0x97, 0xA6 } "率"
  0x7ACB,  // { 0x97, 0xA7 } "立"
  0x844E,  // { 0x97, 0xA8 } "葎"
  0x63A0,  // { 0x97, 0xA9 } "掠"
  0x7565,  // { 0x97, 0xAA } "略"
  0x5289,  // { 0x97, 0xAB } "劉"
  0x6D41,  // { 0x97, 0xAC } "流"
  0x6E9C,  // { 0x97, 0xAD } "溜"
  0x7409,  // { 0x97, 0xAE } "琉"
  0x7559,  // { 0x97, 0xAF } "留"
  0x786B,  // { 0x97, 0xB0 } "硫"
  0x7C92,  // { 0x97, 0xB1 } "粒"
  0x9686,  // { 0x97, 0xB2 } "隆"
  0x7ADC,  // { 0x97, 0xB3 } "竜"
  0x9F8D,  // { 0x97, 0xB4 } "龍"
  0x4FB6,  // { 0x97, 0xB5 } "侶"
  0x616E,  // { 0x97, 0xB6 } "慮"
  0x65C5,  // { 0x97, 0xB7 } "旅"
  0x865C,  // { 0x97, 0xB8 } "虜"
  0x4E86,  // { 0x97, 0xB9 } "了"
  0x4EAE,  // { 0x97, 0xBA } "亮"
  0x50DA,  // { 0x97, 0xBB } "僚"
  0x4E21,  // { 0x97, 0xBC } "両"
  0x51CC,  // { 0x97, 0xBD } "凌"
  0x5BEE,  // { 0x97, 0xBE } "寮"
  0x6599,  // { 0x97, 0xBF } "料"
  0x6881,  // { 0x97, 0xC0 } "梁"
  0x6DBC,  // { 0x97, 0xC1 } "涼"
  0x731F,  // { 0x97, 0xC2 } "猟"
  0x7642,  // { 0x97, 0xC3 } "療"
  0x77AD,  // { 0x97, 0xC4 } "瞭"
  0x7A1C,  // { 0x97, 0xC5 } "稜"
  0x7CE7,  // { 0x97, 0xC6 } "糧"
  0x826F,  // { 0x97, 0xC7 } "良"
  0x8AD2,  // { 0x97, 0xC8 } "諒"
  0x907C,  // { 0x97, 0xC9 } "遼"
  0x91CF,  // { 0x97, 0xCA } "量"
  0x9675,  // { 0x97, 0xCB } "陵"
  0x9818,  // { 0x97, 0xCC } "領"
  0x529B,  // { 0x97, 0xCD } "力"
  0x7DD1,  // { 0x97, 0xCE } "緑"
  0x502B,  // { 0x97, 0xCF } "倫"
  0x5398,  // { 0x97, 0xD0 } "厘"
  0x6797,  // { 0x97, 0xD1 } "林"
  0x6DCB,  // { 0x97, 0xD2 } "淋"
  0x71D0,  // { 0x97, 0xD3 } "燐"
  0x7433,  // { 0x97, 0xD4 } "琳"
  0x81E8,  // { 0x97, 0xD5 } "臨"
  0x8F2A,  // { 0x97, 0xD6 } "輪"
  0x96A3,  // { 0x97, 0xD7 } "隣"
  0x9C57,  // { 0x97, 0xD8 } "鱗"
  0x9E9F,  // { 0x97, 0xD9 } "麟"
  0x7460,  // { 0x97, 0xDA } "瑠"
  0x5841,  // { 0x97, 0xDB } "塁"
  0x6D99,  // { 0x97, 0xDC } "涙"
  0x7D2F,  // { 0x97, 0xDD } "累"
  0x985E,  // { 0x97, 0xDE } "類"
  0x4EE4,  // { 0x97, 0xDF } "令"
  0x4F36,  // { 0x97, 0xE0 } "伶"
  0x4F8B,  // { 0x97, 0xE1 } "例"
  0x51B7,  // { 0x97, 0xE2 } "冷"
  0x52B1,  // { 0x97, 0xE3 } "励"
  0x5DBA,  // { 0x97, 0xE4 } "嶺"
  0x601C,  // { 0x97, 0xE5 } "怜"
  0x73B2,  // { 0x97, 0xE6 } "玲"
  0x793C,  // { 0x97, 0xE7 } "礼"
  0x82D3,  // { 0x97, 0xE8 } "苓"
  0x9234,  // { 0x97, 0xE9 } "鈴"
  0x96B7,  // { 0x97, 0xEA } "隷"
  0x96F6,  // { 0x97, 0xEB } "零"
  0x970A,  // { 0x97, 0xEC } "霊"
  0x9E97,  // { 0x97, 0xED } "麗"
  0x9F62,  // { 0x97, 0xEE } "齢"
  0x66A6,  // { 0x97, 0xEF } "暦"
  0x6B74,  // { 0x97, 0xF0 } "歴"
  0x5217,  // { 0x97, 0xF1 } "列"
  0x52A3,  // { 0x97, 0xF2 } "劣"
  0x70C8,  // { 0x97, 0xF3 } "烈"
  0x88C2,  // { 0x97, 0xF4 } "裂"
  0x5EC9,  // { 0x97, 0xF5 } "廉"
  0x604B,  // { 0x97, 0xF6 } "恋"
  0x6190,  // { 0x97, 0xF7 } "憐"
  0x6F23,  // { 0x97, 0xF8 } "漣"
  0x7149,  // { 0x97, 0xF9 } "煉"
  0x7C3E,  // { 0x97, 0xFA } "簾"
  0x7DF4,  // { 0x97, 0xFB } "練"
  0x806F,  // { 0x97, 0xFC } "聯"
  0x0000,  // { 0x97, 0xFD }
  0x0000,  // { 0x97, 0xFE }
  0x0000,  // { 0x97, 0xFF }
  0x84EE,  // { 0x98, 0x40 } "蓮"
  0x9023,  // { 0x98, 0x41 } "連"
  0x932C,  // { 0x98, 0x42 } "錬"
  0x5442,  // { 0x98, 0x43 } "呂"
  0x9B6F,  // { 0x98, 0x44 } "魯"
  0x6AD3,  // { 0x98, 0x45 } "櫓"
  0x7089,  // { 0x98, 0x46 } "炉"
  0x8CC2,  // { 0x98, 0x47 } "賂"
  0x8DEF,  // { 0x98, 0x48 } "路"
  0x9732,  // { 0x98, 0x49 } "露"
  0x52B4,  // { 0x98, 0x4A } "労"
  0x5A41,  // { 0x98, 0x4B } "婁"
  0x5ECA,  // { 0x98, 0x4C } "廊"
  0x5F04,  // { 0x98, 0x4D } "弄"
  0x6717,  // { 0x98, 0x4E } "朗"
  0x697C,  // { 0x98, 0x4F } "楼"
  0x6994,  // { 0x98, 0x50 } "榔"
  0x6D6A,  // { 0x98, 0x51 } "浪"
  0x6F0F,  // { 0x98, 0x52 } "漏"
  0x7262,  // { 0x98, 0x53 } "牢"
  0x72FC,  // { 0x98, 0x54 } "狼"
  0x7BED,  // { 0x98, 0x55 } "篭"
  0x8001,  // { 0x98, 0x56 } "老"
  0x807E,  // { 0x98, 0x57 } "聾"
  0x874B,  // { 0x98, 0x58 } "蝋"
  0x90CE,  // { 0x98, 0x59 } "郎"
  0x516D,  // { 0x98, 0x5A } "六"
  0x9E93,  // { 0x98, 0x5B } "麓"
  0x7984,  // { 0x98, 0x5C } "禄"
  0x808B,  // { 0x98, 0x5D } "肋"
  0x9332,  // { 0x98, 0x5E } "録"
  0x8AD6,  // { 0x98, 0x5F } "論"
  0x502D,  // { 0x98, 0x60 } "倭"
  0x548C,  // { 0x98, 0x61 } "和"
  0x8A71,  // { 0x98, 0x62 } "話"
  0x6B6A,  // { 0x98, 0x63 } "歪"
  0x8CC4,  // { 0x98, 0x64 } "賄"
  0x8107,  // { 0x98, 0x65 } "脇"
  0x60D1,  // { 0x98, 0x66 } "惑"
  0x67A0,  // { 0x98, 0x67 } "枠"
  0x9DF2,  // { 0x98, 0x68 } "鷲"
  0x4E99,  // { 0x98, 0x69 } "亙"
  0x4E98,  // { 0x98, 0x6A } "亘"
  0x9C10,  // { 0x98, 0x6B } "鰐"
  0x8A6B,  // { 0x98, 0x6C } "詫"
  0x85C1,  // { 0x98, 0x6D } "藁"
  0x8568,  // { 0x98, 0x6E } "蕨"
  0x6900,  // { 0x98, 0x6F } "椀"
  0x6E7E,  // { 0x98, 0x70 } "湾"
  0x7897,  // { 0x98, 0x71 } "碗"
  0x8155,  // { 0x98, 0x72 } "腕"
  0x0000,  // { 0x98, 0x73 }
  0x0000,  // { 0x98, 0x74 }
  0x0000,  // { 0x98, 0x75 }
  0x0000,  // { 0x98, 0x76 }
  0x0000,  // { 0x98, 0x77 }
  0x0000,  // { 0x98, 0x78 }
  0x0000,  // { 0x98, 0x79 }
  0x0000,  // { 0x98, 0x7A }
  0x0000,  // { 0x98, 0x7B }
  0x0000,  // { 0x98, 0x7C }
  0x0000,  // { 0x98, 0x7D }
  0x0000,  // { 0x98, 0x7E }
  0x0000,  // { 0x98, 0x80 }
  0x0000,  // { 0x98, 0x81 }
  0x0000,  // { 0x98, 0x82 }
  0x0000,  // { 0x98, 0x83 }
  0x0000,  // { 0x98, 0x84 }
  0x0000,  // { 0x98, 0x85 }
  0x0000,  // { 0x98, 0x86 }
  0x0000,  // { 0x98, 0x87 }
  0x0000,  // { 0x98, 0x88 }
  0x0000,  // { 0x98, 0x89 }
  0x0000,  // { 0x98, 0x8A }
  0x0000,  // { 0x98, 0x8B }
  0x0000,  // { 0x98, 0x8C }
  0x0000,  // { 0x98, 0x8D }
  0x0000,  // { 0x98, 0x8E }
  0x0000,  // { 0x98, 0x8F }
  0x0000,  // { 0x98, 0x90 }
  0x0000,  // { 0x98, 0x91 }
  0x0000,  // { 0x98, 0x92 }
  0x0000,  // { 0x98, 0x93 }
  0x0000,  // { 0x98, 0x94 }
  0x0000,  // { 0x98, 0x95 }
  0x0000,  // { 0x98, 0x96 }
  0x0000,  // { 0x98, 0x97 }
  0x0000,  // { 0x98, 0x98 }
  0x0000,  // { 0x98, 0x99 }
  0x0000,  // { 0x98, 0x9A }
  0x0000,  // { 0x98, 0x9B }
  0x0000,  // { 0x98, 0x9C }
  0x0000,  // { 0x98, 0x9D }
  0x0000,  // { 0x98, 0x9E }
  0x5F0C,  // { 0x98, 0x9F } "弌"
  0x4E10,  // { 0x98, 0xA0 } "丐"
  0x4E15,  // { 0x98, 0xA1 } "丕"
  0x4E2A,  // { 0x98, 0xA2 } "个"
  0x4E31,  // { 0x98, 0xA3 } "丱"
  0x4E36,  // { 0x98, 0xA4 } "丶"
  0x4E3C,  // { 0x98, 0xA5 } "丼"
  0x4E3F,  // { 0x98, 0xA6 } "丿"
  0x4E42,  // { 0x98, 0xA7 } "乂"
  0x4E56,  // { 0x98, 0xA8 } "乖"
  0x4E58,  // { 0x98, 0xA9 } "乘"
  0x4E82,  // { 0x98, 0xAA } "亂"
  0x4E85,  // { 0x98, 0xAB } "亅"
  0x8C6B,  // { 0x98, 0xAC } "豫"
  0x4E8A,  // { 0x98, 0xAD } "亊"
  0x8212,  // { 0x98, 0xAE } "舒"
  0x5F0D,  // { 0x98, 0xAF } "弍"
  0x4E8E,  // { 0x98, 0xB0 } "于"
  0x4E9E,  // { 0x98, 0xB1 } "亞"
  0x4E9F,  // { 0x98, 0xB2 } "亟"
  0x4EA0,  // { 0x98, 0xB3 } "亠"
  0x4EA2,  // { 0x98, 0xB4 } "亢"
  0x4EB0,  // { 0x98, 0xB5 } "亰"
  0x4EB3,  // { 0x98, 0xB6 } "亳"
  0x4EB6,  // { 0x98, 0xB7 } "亶"
  0x4ECE,  // { 0x98, 0xB8 } "从"
  0x4ECD,  // { 0x98, 0xB9 } "仍"
  0x4EC4,  // { 0x98, 0xBA } "仄"
  0x4EC6,  // { 0x98, 0xBB } "仆"
  0x4EC2,  // { 0x98, 0xBC } "仂"
  0x4ED7,  // { 0x98, 0xBD } "仗"
  0x4EDE,  // { 0x98, 0xBE } "仞"
  0x4EED,  // { 0x98, 0xBF } "仭"
  0x4EDF,  // { 0x98, 0xC0 } "仟"
  0x4EF7,  // { 0x98, 0xC1 } "价"
  0x4F09,  // { 0x98, 0xC2 } "伉"
  0x4F5A,  // { 0x98, 0xC3 } "佚"
  0x4F30,  // { 0x98, 0xC4 } "估"
  0x4F5B,  // { 0x98, 0xC5 } "佛"
  0x4F5D,  // { 0x98, 0xC6 } "佝"
  0x4F57,  // { 0x98, 0xC7 } "佗"
  0x4F47,  // { 0x98, 0xC8 } "佇"
  0x4F76,  // { 0x98, 0xC9 } "佶"
  0x4F88,  // { 0x98, 0xCA } "侈"
  0x4F8F,  // { 0x98, 0xCB } "侏"
  0x4F98,  // { 0x98, 0xCC } "侘"
  0x4F7B,  // { 0x98, 0xCD } "佻"
  0x4F69,  // { 0x98, 0xCE } "佩"
  0x4F70,  // { 0x98, 0xCF } "佰"
  0x4F91,  // { 0x98, 0xD0 } "侑"
  0x4F6F,  // { 0x98, 0xD1 } "佯"
  0x4F86,  // { 0x98, 0xD2 } "來"
  0x4F96,  // { 0x98, 0xD3 } "侖"
  0x5118,  // { 0x98, 0xD4 } "儘"
  0x4FD4,  // { 0x98, 0xD5 } "俔"
  0x4FDF,  // { 0x98, 0xD6 } "俟"
  0x4FCE,  // { 0x98, 0xD7 } "俎"
  0x4FD8,  // { 0x98, 0xD8 } "俘"
  0x4FDB,  // { 0x98, 0xD9 } "俛"
  0x4FD1,  // { 0x98, 0xDA } "俑"
  0x4FDA,  // { 0x98, 0xDB } "俚"
  0x4FD0,  // { 0x98, 0xDC } "俐"
  0x4FE4,  // { 0x98, 0xDD } "俤"
  0x4FE5,  // { 0x98, 0xDE } "俥"
  0x501A,  // { 0x98, 0xDF } "倚"
  0x5028,  // { 0x98, 0xE0 } "倨"
  0x5014,  // { 0x98, 0xE1 } "倔"
  0x502A,  // { 0x98, 0xE2 } "倪"
  0x5025,  // { 0x98, 0xE3 } "倥"
  0x5005,  // { 0x98, 0xE4 } "倅"
  0x4F1C,  // { 0x98, 0xE5 } "伜"
  0x4FF6,  // { 0x98, 0xE6 } "俶"
  0x5021,  // { 0x98, 0xE7 } "倡"
  0x5029,  // { 0x98, 0xE8 } "倩"
  0x502C,  // { 0x98, 0xE9 } "倬"
  0x4FFE,  // { 0x98, 0xEA } "俾"
  0x4FEF,  // { 0x98, 0xEB } "俯"
  0x5011,  // { 0x98, 0xEC } "們"
  0x5006,  // { 0x98, 0xED } "倆"
  0x5043,  // { 0x98, 0xEE } "偃"
  0x5047,  // { 0x98, 0xEF } "假"
  0x6703,  // { 0x98, 0xF0 } "會"
  0x5055,  // { 0x98, 0xF1 } "偕"
  0x5050,  // { 0x98, 0xF2 } "偐"
  0x5048,  // { 0x98, 0xF3 } "偈"
  0x505A,  // { 0x98, 0xF4 } "做"
  0x5056,  // { 0x98, 0xF5 } "偖"
  0x506C,  // { 0x98, 0xF6 } "偬"
  0x5078,  // { 0x98, 0xF7 } "偸"
  0x5080,  // { 0x98, 0xF8 } "傀"
  0x509A,  // { 0x98, 0xF9 } "傚"
  0x5085,  // { 0x98, 0xFA } "傅"
  0x50B4,  // { 0x98, 0xFB } "傴"
  0x50B2,  // { 0x98, 0xFC } "傲"
  0x0000,  // { 0x98, 0xFD }
  0x0000,  // { 0x98, 0xFE }
  0x0000,  // { 0x98, 0xFF }
  0x50C9,  // { 0x99, 0x40 } "僉"
  0x50CA,  // { 0x99, 0x41 } "僊"
  0x50B3,  // { 0x99, 0x42 } "傳"
  0x50C2,  // { 0x99, 0x43 } "僂"
  0x50D6,  // { 0x99, 0x44 } "僖"
  0x50DE,  // { 0x99, 0x45 } "僞"
  0x50E5,  // { 0x99, 0x46 } "僥"
  0x50ED,  // { 0x99, 0x47 } "僭"
  0x50E3,  // { 0x99, 0x48 } "僣"
  0x50EE,  // { 0x99, 0x49 } "僮"
  0x50F9,  // { 0x99, 0x4A } "價"
  0x50F5,  // { 0x99, 0x4B } "僵"
  0x5109,  // { 0x99, 0x4C } "儉"
  0x5101,  // { 0x99, 0x4D } "儁"
  0x5102,  // { 0x99, 0x4E } "儂"
  0x5116,  // { 0x99, 0x4F } "儖"
  0x5115,  // { 0x99, 0x50 } "儕"
  0x5114,  // { 0x99, 0x51 } "儔"
  0x511A,  // { 0x99, 0x52 } "儚"
  0x5121,  // { 0x99, 0x53 } "儡"
  0x513A,  // { 0x99, 0x54 } "儺"
  0x5137,  // { 0x99, 0x55 } "儷"
  0x513C,  // { 0x99, 0x56 } "儼"
  0x513B,  // { 0x99, 0x57 } "儻"
  0x513F,  // { 0x99, 0x58 } "儿"
  0x5140,  // { 0x99, 0x59 } "兀"
  0x5152,  // { 0x99, 0x5A } "兒"
  0x514C,  // { 0x99, 0x5B } "兌"
  0x5154,  // { 0x99, 0x5C } "兔"
  0x5162,  // { 0x99, 0x5D } "兢"
  0x7AF8,  // { 0x99, 0x5E } "竸"
  0x5169,  // { 0x99, 0x5F } "兩"
  0x516A,  // { 0x99, 0x60 } "兪"
  0x516E,  // { 0x99, 0x61 } "兮"
  0x5180,  // { 0x99, 0x62 } "冀"
  0x5182,  // { 0x99, 0x63 } "冂"
  0x56D8,  // { 0x99, 0x64 } "囘"
  0x518C,  // { 0x99, 0x65 } "册"
  0x5189,  // { 0x99, 0x66 } "冉"
  0x518F,  // { 0x99, 0x67 } "冏"
  0x5191,  // { 0x99, 0x68 } "冑"
  0x5193,  // { 0x99, 0x69 } "冓"
  0x5195,  // { 0x99, 0x6A } "冕"
  0x5196,  // { 0x99, 0x6B } "冖"
  0x51A4,  // { 0x99, 0x6C } "冤"
  0x51A6,  // { 0x99, 0x6D } "冦"
  0x51A2,  // { 0x99, 0x6E } "冢"
  0x51A9,  // { 0x99, 0x6F } "冩"
  0x51AA,  // { 0x99, 0x70 } "冪"
  0x51AB,  // { 0x99, 0x71 } "冫"
  0x51B3,  // { 0x99, 0x72 } "决"
  0x51B1,  // { 0x99, 0x73 } "冱"
  0x51B2,  // { 0x99, 0x74 } "冲"
  0x51B0,  // { 0x99, 0x75 } "冰"
  0x51B5,  // { 0x99, 0x76 } "况"
  0x51BD,  // { 0x99, 0x77 } "冽"
  0x51C5,  // { 0x99, 0x78 } "凅"
  0x51C9,  // { 0x99, 0x79 } "凉"
  0x51DB,  // { 0x99, 0x7A } "凛"
  0x51E0,  // { 0x99, 0x7B } "几"
  0x8655,  // { 0x99, 0x7C } "處"
  0x51E9,  // { 0x99, 0x7D } "凩"
  0x51ED,  // { 0x99, 0x7E } "凭"
  0x51F0,  // { 0x99, 0x80 } "凰"
  0x51F5,  // { 0x99, 0x81 } "凵"
  0x51FE,  // { 0x99, 0x82 } "凾"
  0x5204,  // { 0x99, 0x83 } "刄"
  0x520B,  // { 0x99, 0x84 } "刋"
  0x5214,  // { 0x99, 0x85 } "刔"
  0x520E,  // { 0x99, 0x86 } "刎"
  0x5227,  // { 0x99, 0x87 } "刧"
  0x522A,  // { 0x99, 0x88 } "刪"
  0x522E,  // { 0x99, 0x89 } "刮"
  0x5233,  // { 0x99, 0x8A } "刳"
  0x5239,  // { 0x99, 0x8B } "刹"
  0x524F,  // { 0x99, 0x8C } "剏"
  0x5244,  // { 0x99, 0x8D } "剄"
  0x524B,  // { 0x99, 0x8E } "剋"
  0x524C,  // { 0x99, 0x8F } "剌"
  0x525E,  // { 0x99, 0x90 } "剞"
  0x5254,  // { 0x99, 0x91 } "剔"
  0x526A,  // { 0x99, 0x92 } "剪"
  0x5274,  // { 0x99, 0x93 } "剴"
  0x5269,  // { 0x99, 0x94 } "剩"
  0x5273,  // { 0x99, 0x95 } "剳"
  0x527F,  // { 0x99, 0x96 } "剿"
  0x527D,  // { 0x99, 0x97 } "剽"
  0x528D,  // { 0x99, 0x98 } "劍"
  0x5294,  // { 0x99, 0x99 } "劔"
  0x5292,  // { 0x99, 0x9A } "劒"
  0x5271,  // { 0x99, 0x9B } "剱"
  0x5288,  // { 0x99, 0x9C } "劈"
  0x5291,  // { 0x99, 0x9D } "劑"
  0x8FA8,  // { 0x99, 0x9E } "辨"
  0x8FA7,  // { 0x99, 0x9F } "辧"
  0x52AC,  // { 0x99, 0xA0 } "劬"
  0x52AD,  // { 0x99, 0xA1 } "劭"
  0x52BC,  // { 0x99, 0xA2 } "劼"
  0x52B5,  // { 0x99, 0xA3 } "劵"
  0x52C1,  // { 0x99, 0xA4 } "勁"
  0x52CD,  // { 0x99, 0xA5 } "勍"
  0x52D7,  // { 0x99, 0xA6 } "勗"
  0x52DE,  // { 0x99, 0xA7 } "勞"
  0x52E3,  // { 0x99, 0xA8 } "勣"
  0x52E6,  // { 0x99, 0xA9 } "勦"
  0x98ED,  // { 0x99, 0xAA } "飭"
  0x52E0,  // { 0x99, 0xAB } "勠"
  0x52F3,  // { 0x99, 0xAC } "勳"
  0x52F5,  // { 0x99, 0xAD } "勵"
  0x52F8,  // { 0x99, 0xAE } "勸"
  0x52F9,  // { 0x99, 0xAF } "勹"
  0x5306,  // { 0x99, 0xB0 } "匆"
  0x5308,  // { 0x99, 0xB1 } "匈"
  0x7538,  // { 0x99, 0xB2 } "甸"
  0x530D,  // { 0x99, 0xB3 } "匍"
  0x5310,  // { 0x99, 0xB4 } "匐"
  0x530F,  // { 0x99, 0xB5 } "匏"
  0x5315,  // { 0x99, 0xB6 } "匕"
  0x531A,  // { 0x99, 0xB7 } "匚"
  0x5323,  // { 0x99, 0xB8 } "匣"
  0x532F,  // { 0x99, 0xB9 } "匯"
  0x5331,  // { 0x99, 0xBA } "匱"
  0x5333,  // { 0x99, 0xBB } "匳"
  0x5338,  // { 0x99, 0xBC } "匸"
  0x5340,  // { 0x99, 0xBD } "區"
  0x5346,  // { 0x99, 0xBE } "卆"
  0x5345,  // { 0x99, 0xBF } "卅"
  0x4E17,  // { 0x99, 0xC0 } "丗"
  0x5349,  // { 0x99, 0xC1 } "卉"
  0x534D,  // { 0x99, 0xC2 } "卍"
  0x51D6,  // { 0x99, 0xC3 } "凖"
  0x535E,  // { 0x99, 0xC4 } "卞"
  0x5369,  // { 0x99, 0xC5 } "卩"
  0x536E,  // { 0x99, 0xC6 } "卮"
  0x5918,  // { 0x99, 0xC7 } "夘"
  0x537B,  // { 0x99, 0xC8 } "卻"
  0x5377,  // { 0x99, 0xC9 } "卷"
  0x5382,  // { 0x99, 0xCA } "厂"
  0x5396,  // { 0x99, 0xCB } "厖"
  0x53A0,  // { 0x99, 0xCC } "厠"
  0x53A6,  // { 0x99, 0xCD } "厦"
  0x53A5,  // { 0x99, 0xCE } "厥"
  0x53AE,  // { 0x99, 0xCF } "厮"
  0x53B0,  // { 0x99, 0xD0 } "厰"
  0x53B6,  // { 0x99, 0xD1 } "厶"
  0x53C3,  // { 0x99, 0xD2 } "參"
  0x7C12,  // { 0x99, 0xD3 } "簒"
  0x96D9,  // { 0x99, 0xD4 } "雙"
  0x53DF,  // { 0x99, 0xD5 } "叟"
  0x66FC,  // { 0x99, 0xD6 } "曼"
  0x71EE,  // { 0x99, 0xD7 } "燮"
  0x53EE,  // { 0x99, 0xD8 } "叮"
  0x53E8,  // { 0x99, 0xD9 } "叨"
  0x53ED,  // { 0x99, 0xDA } "叭"
  0x53FA,  // { 0x99, 0xDB } "叺"
  0x5401,  // { 0x99, 0xDC } "吁"
  0x543D,  // { 0x99, 0xDD } "吽"
  0x5440,  // { 0x99, 0xDE } "呀"
  0x542C,  // { 0x99, 0xDF } "听"
  0x542D,  // { 0x99, 0xE0 } "吭"
  0x543C,  // { 0x99, 0xE1 } "吼"
  0x542E,  // { 0x99, 0xE2 } "吮"
  0x5436,  // { 0x99, 0xE3 } "吶"
  0x5429,  // { 0x99, 0xE4 } "吩"
  0x541D,  // { 0x99, 0xE5 } "吝"
  0x544E,  // { 0x99, 0xE6 } "呎"
  0x548F,  // { 0x99, 0xE7 } "咏"
  0x5475,  // { 0x99, 0xE8 } "呵"
  0x548E,  // { 0x99, 0xE9 } "咎"
  0x545F,  // { 0x99, 0xEA } "呟"
  0x5471,  // { 0x99, 0xEB } "呱"
  0x5477,  // { 0x99, 0xEC } "呷"
  0x5470,  // { 0x99, 0xED } "呰"
  0x5492,  // { 0x99, 0xEE } "咒"
  0x547B,  // { 0x99, 0xEF } "呻"
  0x5480,  // { 0x99, 0xF0 } "咀"
  0x5476,  // { 0x99, 0xF1 } "呶"
  0x5484,  // { 0x99, 0xF2 } "咄"
  0x5490,  // { 0x99, 0xF3 } "咐"
  0x5486,  // { 0x99, 0xF4 } "咆"
  0x54C7,  // { 0x99, 0xF5 } "哇"
  0x54A2,  // { 0x99, 0xF6 } "咢"
  0x54B8,  // { 0x99, 0xF7 } "咸"
  0x54A5,  // { 0x99, 0xF8 } "咥"
  0x54AC,  // { 0x99, 0xF9 } "咬"
  0x54C4,  // { 0x99, 0xFA } "哄"
  0x54C8,  // { 0x99, 0xFB } "哈"
  0x54A8,  // { 0x99, 0xFC } "咨"
  0x0000,  // { 0x99, 0xFD }
  0x0000,  // { 0x99, 0xFE }
  0x0000,  // { 0x99, 0xFF }
  0x54AB,  // { 0x9A, 0x40 } "咫"
  0x54C2,  // { 0x9A, 0x41 } "哂"
  0x54A4,  // { 0x9A, 0x42 } "咤"
  0x54BE,  // { 0x9A, 0x43 } "咾"
  0x54BC,  // { 0x9A, 0x44 } "咼"
  0x54D8,  // { 0x9A, 0x45 } "哘"
  0x54E5,  // { 0x9A, 0x46 } "哥"
  0x54E6,  // { 0x9A, 0x47 } "哦"
  0x550F,  // { 0x9A, 0x48 } "唏"
  0x5514,  // { 0x9A, 0x49 } "唔"
  0x54FD,  // { 0x9A, 0x4A } "哽"
  0x54EE,  // { 0x9A, 0x4B } "哮"
  0x54ED,  // { 0x9A, 0x4C } "哭"
  0x54FA,  // { 0x9A, 0x4D } "哺"
  0x54E2,  // { 0x9A, 0x4E } "哢"
  0x5539,  // { 0x9A, 0x4F } "唹"
  0x5540,  // { 0x9A, 0x50 } "啀"
  0x5563,  // { 0x9A, 0x51 } "啣"
  0x554C,  // { 0x9A, 0x52 } "啌"
  0x552E,  // { 0x9A, 0x53 } "售"
  0x555C,  // { 0x9A, 0x54 } "啜"
  0x5545,  // { 0x9A, 0x55 } "啅"
  0x5556,  // { 0x9A, 0x56 } "啖"
  0x5557,  // { 0x9A, 0x57 } "啗"
  0x5538,  // { 0x9A, 0x58 } "唸"
  0x5533,  // { 0x9A, 0x59 } "唳"
  0x555D,  // { 0x9A, 0x5A } "啝"
  0x5599,  // { 0x9A, 0x5B } "喙"
  0x5580,  // { 0x9A, 0x5C } "喀"
  0x54AF,  // { 0x9A, 0x5D } "咯"
  0x558A,  // { 0x9A, 0x5E } "喊"
  0x559F,  // { 0x9A, 0x5F } "喟"
  0x557B,  // { 0x9A, 0x60 } "啻"
  0x557E,  // { 0x9A, 0x61 } "啾"
  0x5598,  // { 0x9A, 0x62 } "喘"
  0x559E,  // { 0x9A, 0x63 } "喞"
  0x55AE,  // { 0x9A, 0x64 } "單"
  0x557C,  // { 0x9A, 0x65 } "啼"
  0x5583,  // { 0x9A, 0x66 } "喃"
  0x55A9,  // { 0x9A, 0x67 } "喩"
  0x5587,  // { 0x9A, 0x68 } "喇"
  0x55A8,  // { 0x9A, 0x69 } "喨"
  0x55DA,  // { 0x9A, 0x6A } "嗚"
  0x55C5,  // { 0x9A, 0x6B } "嗅"
  0x55DF,  // { 0x9A, 0x6C } "嗟"
  0x55C4,  // { 0x9A, 0x6D } "嗄"
  0x55DC,  // { 0x9A, 0x6E } "嗜"
  0x55E4,  // { 0x9A, 0x6F } "嗤"
  0x55D4,  // { 0x9A, 0x70 } "嗔"
  0x5614,  // { 0x9A, 0x71 } "嘔"
  0x55F7,  // { 0x9A, 0x72 } "嗷"
  0x5616,  // { 0x9A, 0x73 } "嘖"
  0x55FE,  // { 0x9A, 0x74 } "嗾"
  0x55FD,  // { 0x9A, 0x75 } "嗽"
  0x561B,  // { 0x9A, 0x76 } "嘛"
  0x55F9,  // { 0x9A, 0x77 } "嗹"
  0x564E,  // { 0x9A, 0x78 } "噎"
  0x5650,  // { 0x9A, 0x79 } "噐"
  0x71DF,  // { 0x9A, 0x7A } "營"
  0x5634,  // { 0x9A, 0x7B } "嘴"
  0x5636,  // { 0x9A, 0x7C } "嘶"
  0x5632,  // { 0x9A, 0x7D } "嘲"
  0x5638,  // { 0x9A, 0x7E } "嘸"
  0x566B,  // { 0x9A, 0x80 } "噫"
  0x5664,  // { 0x9A, 0x81 } "噤"
  0x562F,  // { 0x9A, 0x82 } "嘯"
  0x566C,  // { 0x9A, 0x83 } "噬"
  0x566A,  // { 0x9A, 0x84 } "噪"
  0x5686,  // { 0x9A, 0x85 } "嚆"
  0x5680,  // { 0x9A, 0x86 } "嚀"
  0x568A,  // { 0x9A, 0x87 } "嚊"
  0x56A0,  // { 0x9A, 0x88 } "嚠"
  0x5694,  // { 0x9A, 0x89 } "嚔"
  0x568F,  // { 0x9A, 0x8A } "嚏"
  0x56A5,  // { 0x9A, 0x8B } "嚥"
  0x56AE,  // { 0x9A, 0x8C } "嚮"
  0x56B6,  // { 0x9A, 0x8D } "嚶"
  0x56B4,  // { 0x9A, 0x8E } "嚴"
  0x56C2,  // { 0x9A, 0x8F } "囂"
  0x56BC,  // { 0x9A, 0x90 } "嚼"
  0x56C1,  // { 0x9A, 0x91 } "囁"
  0x56C3,  // { 0x9A, 0x92 } "囃"
  0x56C0,  // { 0x9A, 0x93 } "囀"
  0x56C8,  // { 0x9A, 0x94 } "囈"
  0x56CE,  // { 0x9A, 0x95 } "囎"
  0x56D1,  // { 0x9A, 0x96 } "囑"
  0x56D3,  // { 0x9A, 0x97 } "囓"
  0x56D7,  // { 0x9A, 0x98 } "囗"
  0x56EE,  // { 0x9A, 0x99 } "囮"
  0x56F9,  // { 0x9A, 0x9A } "囹"
  0x5700,  // { 0x9A, 0x9B } "圀"
  0x56FF,  // { 0x9A, 0x9C } "囿"
  0x5704,  // { 0x9A, 0x9D } "圄"
  0x5709,  // { 0x9A, 0x9E } "圉"
  0x5708,  // { 0x9A, 0x9F } "圈"
  0x570B,  // { 0x9A, 0xA0 } "國"
  0x570D,  // { 0x9A, 0xA1 } "圍"
  0x5713,  // { 0x9A, 0xA2 } "圓"
  0x5718,  // { 0x9A, 0xA3 } "團"
  0x5716,  // { 0x9A, 0xA4 } "圖"
  0x55C7,  // { 0x9A, 0xA5 } "嗇"
  0x571C,  // { 0x9A, 0xA6 } "圜"
  0x5726,  // { 0x9A, 0xA7 } "圦"
  0x5737,  // { 0x9A, 0xA8 } "圷"
  0x5738,  // { 0x9A, 0xA9 } "圸"
  0x574E,  // { 0x9A, 0xAA } "坎"
  0x573B,  // { 0x9A, 0xAB } "圻"
  0x5740,  // { 0x9A, 0xAC } "址"
  0x574F,  // { 0x9A, 0xAD } "坏"
  0x5769,  // { 0x9A, 0xAE } "坩"
  0x57C0,  // { 0x9A, 0xAF } "埀"
  0x5788,  // { 0x9A, 0xB0 } "垈"
  0x5761,  // { 0x9A, 0xB1 } "坡"
  0x577F,  // { 0x9A, 0xB2 } "坿"
  0x5789,  // { 0x9A, 0xB3 } "垉"
  0x5793,  // { 0x9A, 0xB4 } "垓"
  0x57A0,  // { 0x9A, 0xB5 } "垠"
  0x57B3,  // { 0x9A, 0xB6 } "垳"
  0x57A4,  // { 0x9A, 0xB7 } "垤"
  0x57AA,  // { 0x9A, 0xB8 } "垪"
  0x57B0,  // { 0x9A, 0xB9 } "垰"
  0x57C3,  // { 0x9A, 0xBA } "埃"
  0x57C6,  // { 0x9A, 0xBB } "埆"
  0x57D4,  // { 0x9A, 0xBC } "埔"
  0x57D2,  // { 0x9A, 0xBD } "埒"
  0x57D3,  // { 0x9A, 0xBE } "埓"
  0x580A,  // { 0x9A, 0xBF } "堊"
  0x57D6,  // { 0x9A, 0xC0 } "埖"
  0x57E3,  // { 0x9A, 0xC1 } "埣"
  0x580B,  // { 0x9A, 0xC2 } "堋"
  0x5819,  // { 0x9A, 0xC3 } "堙"
  0x581D,  // { 0x9A, 0xC4 } "堝"
  0x5872,  // { 0x9A, 0xC5 } "塲"
  0x5821,  // { 0x9A, 0xC6 } "堡"
  0x5862,  // { 0x9A, 0xC7 } "塢"
  0x584B,  // { 0x9A, 0xC8 } "塋"
  0x5870,  // { 0x9A, 0xC9 } "塰"
  0x6BC0,  // { 0x9A, 0xCA } "毀"
  0x5852,  // { 0x9A, 0xCB } "塒"
  0x583D,  // { 0x9A, 0xCC } "堽"
  0x5879,  // { 0x9A, 0xCD } "塹"
  0x5885,  // { 0x9A, 0xCE } "墅"
  0x58B9,  // { 0x9A, 0xCF } "墹"
  0x589F,  // { 0x9A, 0xD0 } "墟"
  0x58AB,  // { 0x9A, 0xD1 } "墫"
  0x58BA,  // { 0x9A, 0xD2 } "墺"
  0x58DE,  // { 0x9A, 0xD3 } "壞"
  0x58BB,  // { 0x9A, 0xD4 } "墻"
  0x58B8,  // { 0x9A, 0xD5 } "墸"
  0x58AE,  // { 0x9A, 0xD6 } "墮"
  0x58C5,  // { 0x9A, 0xD7 } "壅"
  0x58D3,  // { 0x9A, 0xD8 } "壓"
  0x58D1,  // { 0x9A, 0xD9 } "壑"
  0x58D7,  // { 0x9A, 0xDA } "壗"
  0x58D9,  // { 0x9A, 0xDB } "壙"
  0x58D8,  // { 0x9A, 0xDC } "壘"
  0x58E5,  // { 0x9A, 0xDD } "壥"
  0x58DC,  // { 0x9A, 0xDE } "壜"
  0x58E4,  // { 0x9A, 0xDF } "壤"
  0x58DF,  // { 0x9A, 0xE0 } "壟"
  0x58EF,  // { 0x9A, 0xE1 } "壯"
  0x58FA,  // { 0x9A, 0xE2 } "壺"
  0x58F9,  // { 0x9A, 0xE3 } "壹"
  0x58FB,  // { 0x9A, 0xE4 } "壻"
  0x58FC,  // { 0x9A, 0xE5 } "壼"
  0x58FD,  // { 0x9A, 0xE6 } "壽"
  0x5902,  // { 0x9A, 0xE7 } "夂"
  0x590A,  // { 0x9A, 0xE8 } "夊"
  0x5910,  // { 0x9A, 0xE9 } "夐"
  0x591B,  // { 0x9A, 0xEA } "夛"
  0x68A6,  // { 0x9A, 0xEB } "梦"
  0x5925,  // { 0x9A, 0xEC } "夥"
  0x592C,  // { 0x9A, 0xED } "夬"
  0x592D,  // { 0x9A, 0xEE } "夭"
  0x5932,  // { 0x9A, 0xEF } "夲"
  0x5938,  // { 0x9A, 0xF0 } "夸"
  0x593E,  // { 0x9A, 0xF1 } "夾"
  0x7AD2,  // { 0x9A, 0xF2 } "竒"
  0x5955,  // { 0x9A, 0xF3 } "奕"
  0x5950,  // { 0x9A, 0xF4 } "奐"
  0x594E,  // { 0x9A, 0xF5 } "奎"
  0x595A,  // { 0x9A, 0xF6 } "奚"
  0x5958,  // { 0x9A, 0xF7 } "奘"
  0x5962,  // { 0x9A, 0xF8 } "奢"
  0x5960,  // { 0x9A, 0xF9 } "奠"
  0x5967,  // { 0x9A, 0xFA } "奧"
  0x596C,  // { 0x9A, 0xFB } "奬"
  0x5969,  // { 0x9A, 0xFC } "奩"
  0x0000,  // { 0x9A, 0xFD }
  0x0000,  // { 0x9A, 0xFE }
  0x0000,  // { 0x9A, 0xFF }
  0x5978,  // { 0x9B, 0x40 } "奸"
  0x5981,  // { 0x9B, 0x41 } "妁"
  0x599D,  // { 0x9B, 0x42 } "妝"
  0x4F5E,  // { 0x9B, 0x43 } "佞"
  0x4FAB,  // { 0x9B, 0x44 } "侫"
  0x59A3,  // { 0x9B, 0x45 } "妣"
  0x59B2,  // { 0x9B, 0x46 } "妲"
  0x59C6,  // { 0x9B, 0x47 } "姆"
  0x59E8,  // { 0x9B, 0x48 } "姨"
  0x59DC,  // { 0x9B, 0x49 } "姜"
  0x598D,  // { 0x9B, 0x4A } "妍"
  0x59D9,  // { 0x9B, 0x4B } "姙"
  0x59DA,  // { 0x9B, 0x4C } "姚"
  0x5A25,  // { 0x9B, 0x4D } "娥"
  0x5A1F,  // { 0x9B, 0x4E } "娟"
  0x5A11,  // { 0x9B, 0x4F } "娑"
  0x5A1C,  // { 0x9B, 0x50 } "娜"
  0x5A09,  // { 0x9B, 0x51 } "娉"
  0x5A1A,  // { 0x9B, 0x52 } "娚"
  0x5A40,  // { 0x9B, 0x53 } "婀"
  0x5A6C,  // { 0x9B, 0x54 } "婬"
  0x5A49,  // { 0x9B, 0x55 } "婉"
  0x5A35,  // { 0x9B, 0x56 } "娵"
  0x5A36,  // { 0x9B, 0x57 } "娶"
  0x5A62,  // { 0x9B, 0x58 } "婢"
  0x5A6A,  // { 0x9B, 0x59 } "婪"
  0x5A9A,  // { 0x9B, 0x5A } "媚"
  0x5ABC,  // { 0x9B, 0x5B } "媼"
  0x5ABE,  // { 0x9B, 0x5C } "媾"
  0x5ACB,  // { 0x9B, 0x5D } "嫋"
  0x5AC2,  // { 0x9B, 0x5E } "嫂"
  0x5ABD,  // { 0x9B, 0x5F } "媽"
  0x5AE3,  // { 0x9B, 0x60 } "嫣"
  0x5AD7,  // { 0x9B, 0x61 } "嫗"
  0x5AE6,  // { 0x9B, 0x62 } "嫦"
  0x5AE9,  // { 0x9B, 0x63 } "嫩"
  0x5AD6,  // { 0x9B, 0x64 } "嫖"
  0x5AFA,  // { 0x9B, 0x65 } "嫺"
  0x5AFB,  // { 0x9B, 0x66 } "嫻"
  0x5B0C,  // { 0x9B, 0x67 } "嬌"
  0x5B0B,  // { 0x9B, 0x68 } "嬋"
  0x5B16,  // { 0x9B, 0x69 } "嬖"
  0x5B32,  // { 0x9B, 0x6A } "嬲"
  0x5AD0,  // { 0x9B, 0x6B } "嫐"
  0x5B2A,  // { 0x9B, 0x6C } "嬪"
  0x5B36,  // { 0x9B, 0x6D } "嬶"
  0x5B3E,  // { 0x9B, 0x6E } "嬾"
  0x5B43,  // { 0x9B, 0x6F } "孃"
  0x5B45,  // { 0x9B, 0x70 } "孅"
  0x5B40,  // { 0x9B, 0x71 } "孀"
  0x5B51,  // { 0x9B, 0x72 } "孑"
  0x5B55,  // { 0x9B, 0x73 } "孕"
  0x5B5A,  // { 0x9B, 0x74 } "孚"
  0x5B5B,  // { 0x9B, 0x75 } "孛"
  0x5B65,  // { 0x9B, 0x76 } "孥"
  0x5B69,  // { 0x9B, 0x77 } "孩"
  0x5B70,  // { 0x9B, 0x78 } "孰"
  0x5B73,  // { 0x9B, 0x79 } "孳"
  0x5B75,  // { 0x9B, 0x7A } "孵"
  0x5B78,  // { 0x9B, 0x7B } "學"
  0x6588,  // { 0x9B, 0x7C } "斈"
  0x5B7A,  // { 0x9B, 0x7D } "孺"
  0x5B80,  // { 0x9B, 0x7E } "宀"
  0x5B83,  // { 0x9B, 0x80 } "它"
  0x5BA6,  // { 0x9B, 0x81 } "宦"
  0x5BB8,  // { 0x9B, 0x82 } "宸"
  0x5BC3,  // { 0x9B, 0x83 } "寃"
  0x5BC7,  // { 0x9B, 0x84 } "寇"
  0x5BC9,  // { 0x9B, 0x85 } "寉"
  0x5BD4,  // { 0x9B, 0x86 } "寔"
  0x5BD0,  // { 0x9B, 0x87 } "寐"
  0x5BE4,  // { 0x9B, 0x88 } "寤"
  0x5BE6,  // { 0x9B, 0x89 } "實"
  0x5BE2,  // { 0x9B, 0x8A } "寢"
  0x5BDE,  // { 0x9B, 0x8B } "寞"
  0x5BE5,  // { 0x9B, 0x8C } "寥"
  0x5BEB,  // { 0x9B, 0x8D } "寫"
  0x5BF0,  // { 0x9B, 0x8E } "寰"
  0x5BF6,  // { 0x9B, 0x8F } "寶"
  0x5BF3,  // { 0x9B, 0x90 } "寳"
  0x5C05,  // { 0x9B, 0x91 } "尅"
  0x5C07,  // { 0x9B, 0x92 } "將"
  0x5C08,  // { 0x9B, 0x93 } "專"
  0x5C0D,  // { 0x9B, 0x94 } "對"
  0x5C13,  // { 0x9B, 0x95 } "尓"
  0x5C20,  // { 0x9B, 0x96 } "尠"
  0x5C22,  // { 0x9B, 0x97 } "尢"
  0x5C28,  // { 0x9B, 0x98 } "尨"
  0x5C38,  // { 0x9B, 0x99 } "尸"
  0x5C39,  // { 0x9B, 0x9A } "尹"
  0x5C41,  // { 0x9B, 0x9B } "屁"
  0x5C46,  // { 0x9B, 0x9C } "屆"
  0x5C4E,  // { 0x9B, 0x9D } "屎"
  0x5C53,  // { 0x9B, 0x9E } "屓"
  0x5C50,  // { 0x9B, 0x9F } "屐"
  0x5C4F,  // { 0x9B, 0xA0 } "屏"
  0x5B71,  // { 0x9B, 0xA1 } "孱"
  0x5C6C,  // { 0x9B, 0xA2 } "屬"
  0x5C6E,  // { 0x9B, 0xA3 } "屮"
  0x4E62,  // { 0x9B, 0xA4 } "乢"
  0x5C76,  // { 0x9B, 0xA5 } "屶"
  0x5C79,  // { 0x9B, 0xA6 } "屹"
  0x5C8C,  // { 0x9B, 0xA7 } "岌"
  0x5C91,  // { 0x9B, 0xA8 } "岑"
  0x5C94,  // { 0x9B, 0xA9 } "岔"
  0x599B,  // { 0x9B, 0xAA } "妛"
  0x5CAB,  // { 0x9B, 0xAB } "岫"
  0x5CBB,  // { 0x9B, 0xAC } "岻"
  0x5CB6,  // { 0x9B, 0xAD } "岶"
  0x5CBC,  // { 0x9B, 0xAE } "岼"
  0x5CB7,  // { 0x9B, 0xAF } "岷"
  0x5CC5,  // { 0x9B, 0xB0 } "峅"
  0x5CBE,  // { 0x9B, 0xB1 } "岾"
  0x5CC7,  // { 0x9B, 0xB2 } "峇"
  0x5CD9,  // { 0x9B, 0xB3 } "峙"
  0x5CE9,  // { 0x9B, 0xB4 } "峩"
  0x5CFD,  // { 0x9B, 0xB5 } "峽"
  0x5CFA,  // { 0x9B, 0xB6 } "峺"
  0x5CED,  // { 0x9B, 0xB7 } "峭"
  0x5D8C,  // { 0x9B, 0xB8 } "嶌"
  0x5CEA,  // { 0x9B, 0xB9 } "峪"
  0x5D0B,  // { 0x9B, 0xBA } "崋"
  0x5D15,  // { 0x9B, 0xBB } "崕"
  0x5D17,  // { 0x9B, 0xBC } "崗"
  0x5D5C,  // { 0x9B, 0xBD } "嵜"
  0x5D1F,  // { 0x9B, 0xBE } "崟"
  0x5D1B,  // { 0x9B, 0xBF } "崛"
  0x5D11,  // { 0x9B, 0xC0 } "崑"
  0x5D14,  // { 0x9B, 0xC1 } "崔"
  0x5D22,  // { 0x9B, 0xC2 } "崢"
  0x5D1A,  // { 0x9B, 0xC3 } "崚"
  0x5D19,  // { 0x9B, 0xC4 } "崙"
  0x5D18,  // { 0x9B, 0xC5 } "崘"
  0x5D4C,  // { 0x9B, 0xC6 } "嵌"
  0x5D52,  // { 0x9B, 0xC7 } "嵒"
  0x5D4E,  // { 0x9B, 0xC8 } "嵎"
  0x5D4B,  // { 0x9B, 0xC9 } "嵋"
  0x5D6C,  // { 0x9B, 0xCA } "嵬"
  0x5D73,  // { 0x9B, 0xCB } "嵳"
  0x5D76,  // { 0x9B, 0xCC } "嵶"
  0x5D87,  // { 0x9B, 0xCD } "嶇"
  0x5D84,  // { 0x9B, 0xCE } "嶄"
  0x5D82,  // { 0x9B, 0xCF } "嶂"
  0x5DA2,  // { 0x9B, 0xD0 } "嶢"
  0x5D9D,  // { 0x9B, 0xD1 } "嶝"
  0x5DAC,  // { 0x9B, 0xD2 } "嶬"
  0x5DAE,  // { 0x9B, 0xD3 } "嶮"
  0x5DBD,  // { 0x9B, 0xD4 } "嶽"
  0x5D90,  // { 0x9B, 0xD5 } "嶐"
  0x5DB7,  // { 0x9B, 0xD6 } "嶷"
  0x5DBC,  // { 0x9B, 0xD7 } "嶼"
  0x5DC9,  // { 0x9B, 0xD8 } "巉"
  0x5DCD,  // { 0x9B, 0xD9 } "巍"
  0x5DD3,  // { 0x9B, 0xDA } "巓"
  0x5DD2,  // { 0x9B, 0xDB } "巒"
  0x5DD6,  // { 0x9B, 0xDC } "巖"
  0x5DDB,  // { 0x9B, 0xDD } "巛"
  0x5DEB,  // { 0x9B, 0xDE } "巫"
  0x5DF2,  // { 0x9B, 0xDF } "已"
  0x5DF5,  // { 0x9B, 0xE0 } "巵"
  0x5E0B,  // { 0x9B, 0xE1 } "帋"
  0x5E1A,  // { 0x9B, 0xE2 } "帚"
  0x5E19,  // { 0x9B, 0xE3 } "帙"
  0x5E11,  // { 0x9B, 0xE4 } "帑"
  0x5E1B,  // { 0x9B, 0xE5 } "帛"
  0x5E36,  // { 0x9B, 0xE6 } "帶"
  0x5E37,  // { 0x9B, 0xE7 } "帷"
  0x5E44,  // { 0x9B, 0xE8 } "幄"
  0x5E43,  // { 0x9B, 0xE9 } "幃"
  0x5E40,  // { 0x9B, 0xEA } "幀"
  0x5E4E,  // { 0x9B, 0xEB } "幎"
  0x5E57,  // { 0x9B, 0xEC } "幗"
  0x5E54,  // { 0x9B, 0xED } "幔"
  0x5E5F,  // { 0x9B, 0xEE } "幟"
  0x5E62,  // { 0x9B, 0xEF } "幢"
  0x5E64,  // { 0x9B, 0xF0 } "幤"
  0x5E47,  // { 0x9B, 0xF1 } "幇"
  0x5E75,  // { 0x9B, 0xF2 } "幵"
  0x5E76,  // { 0x9B, 0xF3 } "并"
  0x5E7A,  // { 0x9B, 0xF4 } "幺"
  0x9EBC,  // { 0x9B, 0xF5 } "麼"
  0x5E7F,  // { 0x9B, 0xF6 } "广"
  0x5EA0,  // { 0x9B, 0xF7 } "庠"
  0x5EC1,  // { 0x9B, 0xF8 } "廁"
  0x5EC2,  // { 0x9B, 0xF9 } "廂"
  0x5EC8,  // { 0x9B, 0xFA } "廈"
  0x5ED0,  // { 0x9B, 0xFB } "廐"
  0x5ECF,  // { 0x9B, 0xFC } "廏"
  0x0000,  // { 0x9B, 0xFD }
  0x0000,  // { 0x9B, 0xFE }
  0x0000,  // { 0x9B, 0xFF }
  0x5ED6,  // { 0x9C, 0x40 } "廖"
  0x5EE3,  // { 0x9C, 0x41 } "廣"
  0x5EDD,  // { 0x9C, 0x42 } "廝"
  0x5EDA,  // { 0x9C, 0x43 } "廚"
  0x5EDB,  // { 0x9C, 0x44 } "廛"
  0x5EE2,  // { 0x9C, 0x45 } "廢"
  0x5EE1,  // { 0x9C, 0x46 } "廡"
  0x5EE8,  // { 0x9C, 0x47 } "廨"
  0x5EE9,  // { 0x9C, 0x48 } "廩"
  0x5EEC,  // { 0x9C, 0x49 } "廬"
  0x5EF1,  // { 0x9C, 0x4A } "廱"
  0x5EF3,  // { 0x9C, 0x4B } "廳"
  0x5EF0,  // { 0x9C, 0x4C } "廰"
  0x5EF4,  // { 0x9C, 0x4D } "廴"
  0x5EF8,  // { 0x9C, 0x4E } "廸"
  0x5EFE,  // { 0x9C, 0x4F } "廾"
  0x5F03,  // { 0x9C, 0x50 } "弃"
  0x5F09,  // { 0x9C, 0x51 } "弉"
  0x5F5D,  // { 0x9C, 0x52 } "彝"
  0x5F5C,  // { 0x9C, 0x53 } "彜"
  0x5F0B,  // { 0x9C, 0x54 } "弋"
  0x5F11,  // { 0x9C, 0x55 } "弑"
  0x5F16,  // { 0x9C, 0x56 } "弖"
  0x5F29,  // { 0x9C, 0x57 } "弩"
  0x5F2D,  // { 0x9C, 0x58 } "弭"
  0x5F38,  // { 0x9C, 0x59 } "弸"
  0x5F41,  // { 0x9C, 0x5A } "彁"
  0x5F48,  // { 0x9C, 0x5B } "彈"
  0x5F4C,  // { 0x9C, 0x5C } "彌"
  0x5F4E,  // { 0x9C, 0x5D } "彎"
  0x5F2F,  // { 0x9C, 0x5E } "弯"
  0x5F51,  // { 0x9C, 0x5F } "彑"
  0x5F56,  // { 0x9C, 0x60 } "彖"
  0x5F57,  // { 0x9C, 0x61 } "彗"
  0x5F59,  // { 0x9C, 0x62 } "彙"
  0x5F61,  // { 0x9C, 0x63 } "彡"
  0x5F6D,  // { 0x9C, 0x64 } "彭"
  0x5F73,  // { 0x9C, 0x65 } "彳"
  0x5F77,  // { 0x9C, 0x66 } "彷"
  0x5F83,  // { 0x9C, 0x67 } "徃"
  0x5F82,  // { 0x9C, 0x68 } "徂"
  0x5F7F,  // { 0x9C, 0x69 } "彿"
  0x5F8A,  // { 0x9C, 0x6A } "徊"
  0x5F88,  // { 0x9C, 0x6B } "很"
  0x5F91,  // { 0x9C, 0x6C } "徑"
  0x5F87,  // { 0x9C, 0x6D } "徇"
  0x5F9E,  // { 0x9C, 0x6E } "從"
  0x5F99,  // { 0x9C, 0x6F } "徙"
  0x5F98,  // { 0x9C, 0x70 } "徘"
  0x5FA0,  // { 0x9C, 0x71 } "徠"
  0x5FA8,  // { 0x9C, 0x72 } "徨"
  0x5FAD,  // { 0x9C, 0x73 } "徭"
  0x5FBC,  // { 0x9C, 0x74 } "徼"
  0x5FD6,  // { 0x9C, 0x75 } "忖"
  0x5FFB,  // { 0x9C, 0x76 } "忻"
  0x5FE4,  // { 0x9C, 0x77 } "忤"
  0x5FF8,  // { 0x9C, 0x78 } "忸"
  0x5FF1,  // { 0x9C, 0x79 } "忱"
  0x5FDD,  // { 0x9C, 0x7A } "忝"
  0x60B3,  // { 0x9C, 0x7B } "悳"
  0x5FFF,  // { 0x9C, 0x7C } "忿"
  0x6021,  // { 0x9C, 0x7D } "怡"
  0x6060,  // { 0x9C, 0x7E } "恠"
  0x6019,  // { 0x9C, 0x80 } "怙"
  0x6010,  // { 0x9C, 0x81 } "怐"
  0x6029,  // { 0x9C, 0x82 } "怩"
  0x600E,  // { 0x9C, 0x83 } "怎"
  0x6031,  // { 0x9C, 0x84 } "怱"
  0x601B,  // { 0x9C, 0x85 } "怛"
  0x6015,  // { 0x9C, 0x86 } "怕"
  0x602B,  // { 0x9C, 0x87 } "怫"
  0x6026,  // { 0x9C, 0x88 } "怦"
  0x600F,  // { 0x9C, 0x89 } "怏"
  0x603A,  // { 0x9C, 0x8A } "怺"
  0x605A,  // { 0x9C, 0x8B } "恚"
  0x6041,  // { 0x9C, 0x8C } "恁"
  0x606A,  // { 0x9C, 0x8D } "恪"
  0x6077,  // { 0x9C, 0x8E } "恷"
  0x605F,  // { 0x9C, 0x8F } "恟"
  0x604A,  // { 0x9C, 0x90 } "恊"
  0x6046,  // { 0x9C, 0x91 } "恆"
  0x604D,  // { 0x9C, 0x92 } "恍"
  0x6063,  // { 0x9C, 0x93 } "恣"
  0x6043,  // { 0x9C, 0x94 } "恃"
  0x6064,  // { 0x9C, 0x95 } "恤"
  0x6042,  // { 0x9C, 0x96 } "恂"
  0x606C,  // { 0x9C, 0x97 } "恬"
  0x606B,  // { 0x9C, 0x98 } "恫"
  0x6059,  // { 0x9C, 0x99 } "恙"
  0x6081,  // { 0x9C, 0x9A } "悁"
  0x608D,  // { 0x9C, 0x9B } "悍"
  0x60E7,  // { 0x9C, 0x9C } "惧"
  0x6083,  // { 0x9C, 0x9D } "悃"
  0x609A,  // { 0x9C, 0x9E } "悚"
  0x6084,  // { 0x9C, 0x9F } "悄"
  0x609B,  // { 0x9C, 0xA0 } "悛"
  0x6096,  // { 0x9C, 0xA1 } "悖"
  0x6097,  // { 0x9C, 0xA2 } "悗"
  0x6092,  // { 0x9C, 0xA3 } "悒"
  0x60A7,  // { 0x9C, 0xA4 } "悧"
  0x608B,  // { 0x9C, 0xA5 } "悋"
  0x60E1,  // { 0x9C, 0xA6 } "惡"
  0x60B8,  // { 0x9C, 0xA7 } "悸"
  0x60E0,  // { 0x9C, 0xA8 } "惠"
  0x60D3,  // { 0x9C, 0xA9 } "惓"
  0x60B4,  // { 0x9C, 0xAA } "悴"
  0x5FF0,  // { 0x9C, 0xAB } "忰"
  0x60BD,  // { 0x9C, 0xAC } "悽"
  0x60C6,  // { 0x9C, 0xAD } "惆"
  0x60B5,  // { 0x9C, 0xAE } "悵"
  0x60D8,  // { 0x9C, 0xAF } "惘"
  0x614D,  // { 0x9C, 0xB0 } "慍"
  0x6115,  // { 0x9C, 0xB1 } "愕"
  0x6106,  // { 0x9C, 0xB2 } "愆"
  0x60F6,  // { 0x9C, 0xB3 } "惶"
  0x60F7,  // { 0x9C, 0xB4 } "惷"
  0x6100,  // { 0x9C, 0xB5 } "愀"
  0x60F4,  // { 0x9C, 0xB6 } "惴"
  0x60FA,  // { 0x9C, 0xB7 } "惺"
  0x6103,  // { 0x9C, 0xB8 } "愃"
  0x6121,  // { 0x9C, 0xB9 } "愡"
  0x60FB,  // { 0x9C, 0xBA } "惻"
  0x60F1,  // { 0x9C, 0xBB } "惱"
  0x610D,  // { 0x9C, 0xBC } "愍"
  0x610E,  // { 0x9C, 0xBD } "愎"
  0x6147,  // { 0x9C, 0xBE } "慇"
  0x613E,  // { 0x9C, 0xBF } "愾"
  0x6128,  // { 0x9C, 0xC0 } "愨"
  0x6127,  // { 0x9C, 0xC1 } "愧"
  0x614A,  // { 0x9C, 0xC2 } "慊"
  0x613F,  // { 0x9C, 0xC3 } "愿"
  0x613C,  // { 0x9C, 0xC4 } "愼"
  0x612C,  // { 0x9C, 0xC5 } "愬"
  0x6134,  // { 0x9C, 0xC6 } "愴"
  0x613D,  // { 0x9C, 0xC7 } "愽"
  0x6142,  // { 0x9C, 0xC8 } "慂"
  0x6144,  // { 0x9C, 0xC9 } "慄"
  0x6173,  // { 0x9C, 0xCA } "慳"
  0x6177,  // { 0x9C, 0xCB } "慷"
  0x6158,  // { 0x9C, 0xCC } "慘"
  0x6159,  // { 0x9C, 0xCD } "慙"
  0x615A,  // { 0x9C, 0xCE } "慚"
  0x616B,  // { 0x9C, 0xCF } "慫"
  0x6174,  // { 0x9C, 0xD0 } "慴"
  0x616F,  // { 0x9C, 0xD1 } "慯"
  0x6165,  // { 0x9C, 0xD2 } "慥"
  0x6171,  // { 0x9C, 0xD3 } "慱"
  0x615F,  // { 0x9C, 0xD4 } "慟"
  0x615D,  // { 0x9C, 0xD5 } "慝"
  0x6153,  // { 0x9C, 0xD6 } "慓"
  0x6175,  // { 0x9C, 0xD7 } "慵"
  0x6199,  // { 0x9C, 0xD8 } "憙"
  0x6196,  // { 0x9C, 0xD9 } "憖"
  0x6187,  // { 0x9C, 0xDA } "憇"
  0x61AC,  // { 0x9C, 0xDB } "憬"
  0x6194,  // { 0x9C, 0xDC } "憔"
  0x619A,  // { 0x9C, 0xDD } "憚"
  0x618A,  // { 0x9C, 0xDE } "憊"
  0x6191,  // { 0x9C, 0xDF } "憑"
  0x61AB,  // { 0x9C, 0xE0 } "憫"
  0x61AE,  // { 0x9C, 0xE1 } "憮"
  0x61CC,  // { 0x9C, 0xE2 } "懌"
  0x61CA,  // { 0x9C, 0xE3 } "懊"
  0x61C9,  // { 0x9C, 0xE4 } "應"
  0x61F7,  // { 0x9C, 0xE5 } "懷"
  0x61C8,  // { 0x9C, 0xE6 } "懈"
  0x61C3,  // { 0x9C, 0xE7 } "懃"
  0x61C6,  // { 0x9C, 0xE8 } "懆"
  0x61BA,  // { 0x9C, 0xE9 } "憺"
  0x61CB,  // { 0x9C, 0xEA } "懋"
  0x7F79,  // { 0x9C, 0xEB } "罹"
  0x61CD,  // { 0x9C, 0xEC } "懍"
  0x61E6,  // { 0x9C, 0xED } "懦"
  0x61E3,  // { 0x9C, 0xEE } "懣"
  0x61F6,  // { 0x9C, 0xEF } "懶"
  0x61FA,  // { 0x9C, 0xF0 } "懺"
  0x61F4,  // { 0x9C, 0xF1 } "懴"
  0x61FF,  // { 0x9C, 0xF2 } "懿"
  0x61FD,  // { 0x9C, 0xF3 } "懽"
  0x61FC,  // { 0x9C, 0xF4 } "懼"
  0x61FE,  // { 0x9C, 0xF5 } "懾"
  0x6200,  // { 0x9C, 0xF6 } "戀"
  0x6208,  // { 0x9C, 0xF7 } "戈"
  0x6209,  // { 0x9C, 0xF8 } "戉"
  0x620D,  // { 0x9C, 0xF9 } "戍"
  0x620C,  // { 0x9C, 0xFA } "戌"
  0x6214,  // { 0x9C, 0xFB } "戔"
  0x621B,  // { 0x9C, 0xFC } "戛"
  0x0000,  // { 0x9C, 0xFD }
  0x0000,  // { 0x9C, 0xFE }
  0x0000,  // { 0x9C, 0xFF }
  0x621E,  // { 0x9D, 0x40 } "戞"
  0x6221,  // { 0x9D, 0x41 } "戡"
  0x622A,  // { 0x9D, 0x42 } "截"
  0x622E,  // { 0x9D, 0x43 } "戮"
  0x6230,  // { 0x9D, 0x44 } "戰"
  0x6232,  // { 0x9D, 0x45 } "戲"
  0x6233,  // { 0x9D, 0x46 } "戳"
  0x6241,  // { 0x9D, 0x47 } "扁"
  0x624E,  // { 0x9D, 0x48 } "扎"
  0x625E,  // { 0x9D, 0x49 } "扞"
  0x6263,  // { 0x9D, 0x4A } "扣"
  0x625B,  // { 0x9D, 0x4B } "扛"
  0x6260,  // { 0x9D, 0x4C } "扠"
  0x6268,  // { 0x9D, 0x4D } "扨"
  0x627C,  // { 0x9D, 0x4E } "扼"
  0x6282,  // { 0x9D, 0x4F } "抂"
  0x6289,  // { 0x9D, 0x50 } "抉"
  0x627E,  // { 0x9D, 0x51 } "找"
  0x6292,  // { 0x9D, 0x52 } "抒"
  0x6293,  // { 0x9D, 0x53 } "抓"
  0x6296,  // { 0x9D, 0x54 } "抖"
  0x62D4,  // { 0x9D, 0x55 } "拔"
  0x6283,  // { 0x9D, 0x56 } "抃"
  0x6294,  // { 0x9D, 0x57 } "抔"
  0x62D7,  // { 0x9D, 0x58 } "拗"
  0x62D1,  // { 0x9D, 0x59 } "拑"
  0x62BB,  // { 0x9D, 0x5A } "抻"
  0x62CF,  // { 0x9D, 0x5B } "拏"
  0x62FF,  // { 0x9D, 0x5C } "拿"
  0x62C6,  // { 0x9D, 0x5D } "拆"
  0x64D4,  // { 0x9D, 0x5E } "擔"
  0x62C8,  // { 0x9D, 0x5F } "拈"
  0x62DC,  // { 0x9D, 0x60 } "拜"
  0x62CC,  // { 0x9D, 0x61 } "拌"
  0x62CA,  // { 0x9D, 0x62 } "拊"
  0x62C2,  // { 0x9D, 0x63 } "拂"
  0x62C7,  // { 0x9D, 0x64 } "拇"
  0x629B,  // { 0x9D, 0x65 } "抛"
  0x62C9,  // { 0x9D, 0x66 } "拉"
  0x630C,  // { 0x9D, 0x67 } "挌"
  0x62EE,  // { 0x9D, 0x68 } "拮"
  0x62F1,  // { 0x9D, 0x69 } "拱"
  0x6327,  // { 0x9D, 0x6A } "挧"
  0x6302,  // { 0x9D, 0x6B } "挂"
  0x6308,  // { 0x9D, 0x6C } "挈"
  0x62EF,  // { 0x9D, 0x6D } "拯"
  0x62F5,  // { 0x9D, 0x6E } "拵"
  0x6350,  // { 0x9D, 0x6F } "捐"
  0x633E,  // { 0x9D, 0x70 } "挾"
  0x634D,  // { 0x9D, 0x71 } "捍"
  0x641C,  // { 0x9D, 0x72 } "搜"
  0x634F,  // { 0x9D, 0x73 } "捏"
  0x6396,  // { 0x9D, 0x74 } "掖"
  0x638E,  // { 0x9D, 0x75 } "掎"
  0x6380,  // { 0x9D, 0x76 } "掀"
  0x63AB,  // { 0x9D, 0x77 } "掫"
  0x6376,  // { 0x9D, 0x78 } "捶"
  0x63A3,  // { 0x9D, 0x79 } "掣"
  0x638F,  // { 0x9D, 0x7A } "掏"
  0x6389,  // { 0x9D, 0x7B } "掉"
  0x639F,  // { 0x9D, 0x7C } "掟"
  0x63B5,  // { 0x9D, 0x7D } "掵"
  0x636B,  // { 0x9D, 0x7E } "捫"
  0x6369,  // { 0x9D, 0x80 } "捩"
  0x63BE,  // { 0x9D, 0x81 } "掾"
  0x63E9,  // { 0x9D, 0x82 } "揩"
  0x63C0,  // { 0x9D, 0x83 } "揀"
  0x63C6,  // { 0x9D, 0x84 } "揆"
  0x63E3,  // { 0x9D, 0x85 } "揣"
  0x63C9,  // { 0x9D, 0x86 } "揉"
  0x63D2,  // { 0x9D, 0x87 } "插"
  0x63F6,  // { 0x9D, 0x88 } "揶"
  0x63C4,  // { 0x9D, 0x89 } "揄"
  0x6416,  // { 0x9D, 0x8A } "搖"
  0x6434,  // { 0x9D, 0x8B } "搴"
  0x6406,  // { 0x9D, 0x8C } "搆"
  0x6413,  // { 0x9D, 0x8D } "搓"
  0x6426,  // { 0x9D, 0x8E } "搦"
  0x6436,  // { 0x9D, 0x8F } "搶"
  0x651D,  // { 0x9D, 0x90 } "攝"
  0x6417,  // { 0x9D, 0x91 } "搗"
  0x6428,  // { 0x9D, 0x92 } "搨"
  0x640F,  // { 0x9D, 0x93 } "搏"
  0x6467,  // { 0x9D, 0x94 } "摧"
  0x646F,  // { 0x9D, 0x95 } "摯"
  0x6476,  // { 0x9D, 0x96 } "摶"
  0x644E,  // { 0x9D, 0x97 } "摎"
  0x652A,  // { 0x9D, 0x98 } "攪"
  0x6495,  // { 0x9D, 0x99 } "撕"
  0x6493,  // { 0x9D, 0x9A } "撓"
  0x64A5,  // { 0x9D, 0x9B } "撥"
  0x64A9,  // { 0x9D, 0x9C } "撩"
  0x6488,  // { 0x9D, 0x9D } "撈"
  0x64BC,  // { 0x9D, 0x9E } "撼"
  0x64DA,  // { 0x9D, 0x9F } "據"
  0x64D2,  // { 0x9D, 0xA0 } "擒"
  0x64C5,  // { 0x9D, 0xA1 } "擅"
  0x64C7,  // { 0x9D, 0xA2 } "擇"
  0x64BB,  // { 0x9D, 0xA3 } "撻"
  0x64D8,  // { 0x9D, 0xA4 } "擘"
  0x64C2,  // { 0x9D, 0xA5 } "擂"
  0x64F1,  // { 0x9D, 0xA6 } "擱"
  0x64E7,  // { 0x9D, 0xA7 } "擧"
  0x8209,  // { 0x9D, 0xA8 } "舉"
  0x64E0,  // { 0x9D, 0xA9 } "擠"
  0x64E1,  // { 0x9D, 0xAA } "擡"
  0x62AC,  // { 0x9D, 0xAB } "抬"
  0x64E3,  // { 0x9D, 0xAC } "擣"
  0x64EF,  // { 0x9D, 0xAD } "擯"
  0x652C,  // { 0x9D, 0xAE } "攬"
  0x64F6,  // { 0x9D, 0xAF } "擶"
  0x64F4,  // { 0x9D, 0xB0 } "擴"
  0x64F2,  // { 0x9D, 0xB1 } "擲"
  0x64FA,  // { 0x9D, 0xB2 } "擺"
  0x6500,  // { 0x9D, 0xB3 } "攀"
  0x64FD,  // { 0x9D, 0xB4 } "擽"
  0x6518,  // { 0x9D, 0xB5 } "攘"
  0x651C,  // { 0x9D, 0xB6 } "攜"
  0x6505,  // { 0x9D, 0xB7 } "攅"
  0x6524,  // { 0x9D, 0xB8 } "攤"
  0x6523,  // { 0x9D, 0xB9 } "攣"
  0x652B,  // { 0x9D, 0xBA } "攫"
  0x6534,  // { 0x9D, 0xBB } "攴"
  0x6535,  // { 0x9D, 0xBC } "攵"
  0x6537,  // { 0x9D, 0xBD } "攷"
  0x6536,  // { 0x9D, 0xBE } "收"
  0x6538,  // { 0x9D, 0xBF } "攸"
  0x754B,  // { 0x9D, 0xC0 } "畋"
  0x6548,  // { 0x9D, 0xC1 } "效"
  0x6556,  // { 0x9D, 0xC2 } "敖"
  0x6555,  // { 0x9D, 0xC3 } "敕"
  0x654D,  // { 0x9D, 0xC4 } "敍"
  0x6558,  // { 0x9D, 0xC5 } "敘"
  0x655E,  // { 0x9D, 0xC6 } "敞"
  0x655D,  // { 0x9D, 0xC7 } "敝"
  0x6572,  // { 0x9D, 0xC8 } "敲"
  0x6578,  // { 0x9D, 0xC9 } "數"
  0x6582,  // { 0x9D, 0xCA } "斂"
  0x6583,  // { 0x9D, 0xCB } "斃"
  0x8B8A,  // { 0x9D, 0xCC } "變"
  0x659B,  // { 0x9D, 0xCD } "斛"
  0x659F,  // { 0x9D, 0xCE } "斟"
  0x65AB,  // { 0x9D, 0xCF } "斫"
  0x65B7,  // { 0x9D, 0xD0 } "斷"
  0x65C3,  // { 0x9D, 0xD1 } "旃"
  0x65C6,  // { 0x9D, 0xD2 } "旆"
  0x65C1,  // { 0x9D, 0xD3 } "旁"
  0x65C4,  // { 0x9D, 0xD4 } "旄"
  0x65CC,  // { 0x9D, 0xD5 } "旌"
  0x65D2,  // { 0x9D, 0xD6 } "旒"
  0x65DB,  // { 0x9D, 0xD7 } "旛"
  0x65D9,  // { 0x9D, 0xD8 } "旙"
  0x65E0,  // { 0x9D, 0xD9 } "无"
  0x65E1,  // { 0x9D, 0xDA } "旡"
  0x65F1,  // { 0x9D, 0xDB } "旱"
  0x6772,  // { 0x9D, 0xDC } "杲"
  0x660A,  // { 0x9D, 0xDD } "昊"
  0x6603,  // { 0x9D, 0xDE } "昃"
  0x65FB,  // { 0x9D, 0xDF } "旻"
  0x6773,  // { 0x9D, 0xE0 } "杳"
  0x6635,  // { 0x9D, 0xE1 } "昵"
  0x6636,  // { 0x9D, 0xE2 } "昶"
  0x6634,  // { 0x9D, 0xE3 } "昴"
  0x661C,  // { 0x9D, 0xE4 } "昜"
  0x664F,  // { 0x9D, 0xE5 } "晏"
  0x6644,  // { 0x9D, 0xE6 } "晄"
  0x6649,  // { 0x9D, 0xE7 } "晉"
  0x6641,  // { 0x9D, 0xE8 } "晁"
  0x665E,  // { 0x9D, 0xE9 } "晞"
  0x665D,  // { 0x9D, 0xEA } "晝"
  0x6664,  // { 0x9D, 0xEB } "晤"
  0x6667,  // { 0x9D, 0xEC } "晧"
  0x6668,  // { 0x9D, 0xED } "晨"
  0x665F,  // { 0x9D, 0xEE } "晟"
  0x6662,  // { 0x9D, 0xEF } "晢"
  0x6670,  // { 0x9D, 0xF0 } "晰"
  0x6683,  // { 0x9D, 0xF1 } "暃"
  0x6688,  // { 0x9D, 0xF2 } "暈"
  0x668E,  // { 0x9D, 0xF3 } "暎"
  0x6689,  // { 0x9D, 0xF4 } "暉"
  0x6684,  // { 0x9D, 0xF5 } "暄"
  0x6698,  // { 0x9D, 0xF6 } "暘"
  0x669D,  // { 0x9D, 0xF7 } "暝"
  0x66C1,  // { 0x9D, 0xF8 } "曁"
  0x66B9,  // { 0x9D, 0xF9 } "暹"
  0x66C9,  // { 0x9D, 0xFA } "曉"
  0x66BE,  // { 0x9D, 0xFB } "暾"
  0x66BC,  // { 0x9D, 0xFC } "暼"
  0x0000,  // { 0x9D, 0xFD }
  0x0000,  // { 0x9D, 0xFE }
  0x0000,  // { 0x9D, 0xFF }
  0x66C4,  // { 0x9E, 0x40 } "曄"
  0x66B8,  // { 0x9E, 0x41 } "暸"
  0x66D6,  // { 0x9E, 0x42 } "曖"
  0x66DA,  // { 0x9E, 0x43 } "曚"
  0x66E0,  // { 0x9E, 0x44 } "曠"
  0x663F,  // { 0x9E, 0x45 } "昿"
  0x66E6,  // { 0x9E, 0x46 } "曦"
  0x66E9,  // { 0x9E, 0x47 } "曩"
  0x66F0,  // { 0x9E, 0x48 } "曰"
  0x66F5,  // { 0x9E, 0x49 } "曵"
  0x66F7,  // { 0x9E, 0x4A } "曷"
  0x670F,  // { 0x9E, 0x4B } "朏"
  0x6716,  // { 0x9E, 0x4C } "朖"
  0x671E,  // { 0x9E, 0x4D } "朞"
  0x6726,  // { 0x9E, 0x4E } "朦"
  0x6727,  // { 0x9E, 0x4F } "朧"
  0x9738,  // { 0x9E, 0x50 } "霸"
  0x672E,  // { 0x9E, 0x51 } "朮"
  0x673F,  // { 0x9E, 0x52 } "朿"
  0x6736,  // { 0x9E, 0x53 } "朶"
  0x6741,  // { 0x9E, 0x54 } "杁"
  0x6738,  // { 0x9E, 0x55 } "朸"
  0x6737,  // { 0x9E, 0x56 } "朷"
  0x6746,  // { 0x9E, 0x57 } "杆"
  0x675E,  // { 0x9E, 0x58 } "杞"
  0x6760,  // { 0x9E, 0x59 } "杠"
  0x6759,  // { 0x9E, 0x5A } "杙"
  0x6763,  // { 0x9E, 0x5B } "杣"
  0x6764,  // { 0x9E, 0x5C } "杤"
  0x6789,  // { 0x9E, 0x5D } "枉"
  0x6770,  // { 0x9E, 0x5E } "杰"
  0x67A9,  // { 0x9E, 0x5F } "枩"
  0x677C,  // { 0x9E, 0x60 } "杼"
  0x676A,  // { 0x9E, 0x61 } "杪"
  0x678C,  // { 0x9E, 0x62 } "枌"
  0x678B,  // { 0x9E, 0x63 } "枋"
  0x67A6,  // { 0x9E, 0x64 } "枦"
  0x67A1,  // { 0x9E, 0x65 } "枡"
  0x6785,  // { 0x9E, 0x66 } "枅"
  0x67B7,  // { 0x9E, 0x67 } "枷"
  0x67EF,  // { 0x9E, 0x68 } "柯"
  0x67B4,  // { 0x9E, 0x69 } "枴"
  0x67EC,  // { 0x9E, 0x6A } "柬"
  0x67B3,  // { 0x9E, 0x6B } "枳"
  0x67E9,  // { 0x9E, 0x6C } "柩"
  0x67B8,  // { 0x9E, 0x6D } "枸"
  0x67E4,  // { 0x9E, 0x6E } "柤"
  0x67DE,  // { 0x9E, 0x6F } "柞"
  0x67DD,  // { 0x9E, 0x70 } "柝"
  0x67E2,  // { 0x9E, 0x71 } "柢"
  0x67EE,  // { 0x9E, 0x72 } "柮"
  0x67B9,  // { 0x9E, 0x73 } "枹"
  0x67CE,  // { 0x9E, 0x74 } "柎"
  0x67C6,  // { 0x9E, 0x75 } "柆"
  0x67E7,  // { 0x9E, 0x76 } "柧"
  0x6A9C,  // { 0x9E, 0x77 } "檜"
  0x681E,  // { 0x9E, 0x78 } "栞"
  0x6846,  // { 0x9E, 0x79 } "框"
  0x6829,  // { 0x9E, 0x7A } "栩"
  0x6840,  // { 0x9E, 0x7B } "桀"
  0x684D,  // { 0x9E, 0x7C } "桍"
  0x6832,  // { 0x9E, 0x7D } "栲"
  0x684E,  // { 0x9E, 0x7E } "桎"
  0x68B3,  // { 0x9E, 0x80 } "梳"
  0x682B,  // { 0x9E, 0x81 } "栫"
  0x6859,  // { 0x9E, 0x82 } "桙"
  0x6863,  // { 0x9E, 0x83 } "档"
  0x6877,  // { 0x9E, 0x84 } "桷"
  0x687F,  // { 0x9E, 0x85 } "桿"
  0x689F,  // { 0x9E, 0x86 } "梟"
  0x688F,  // { 0x9E, 0x87 } "梏"
  0x68AD,  // { 0x9E, 0x88 } "梭"
  0x6894,  // { 0x9E, 0x89 } "梔"
  0x689D,  // { 0x9E, 0x8A } "條"
  0x689B,  // { 0x9E, 0x8B } "梛"
  0x6883,  // { 0x9E, 0x8C } "梃"
  0x6AAE,  // { 0x9E, 0x8D } "檮"
  0x68B9,  // { 0x9E, 0x8E } "梹"
  0x6874,  // { 0x9E, 0x8F } "桴"
  0x68B5,  // { 0x9E, 0x90 } "梵"
  0x68A0,  // { 0x9E, 0x91 } "梠"
  0x68BA,  // { 0x9E, 0x92 } "梺"
  0x690F,  // { 0x9E, 0x93 } "椏"
  0x688D,  // { 0x9E, 0x94 } "梍"
  0x687E,  // { 0x9E, 0x95 } "桾"
  0x6901,  // { 0x9E, 0x96 } "椁"
  0x68CA,  // { 0x9E, 0x97 } "棊"
  0x6908,  // { 0x9E, 0x98 } "椈"
  0x68D8,  // { 0x9E, 0x99 } "棘"
  0x6922,  // { 0x9E, 0x9A } "椢"
  0x6926,  // { 0x9E, 0x9B } "椦"
  0x68E1,  // { 0x9E, 0x9C } "棡"
  0x690C,  // { 0x9E, 0x9D } "椌"
  0x68CD,  // { 0x9E, 0x9E } "棍"
  0x68D4,  // { 0x9E, 0x9F } "棔"
  0x68E7,  // { 0x9E, 0xA0 } "棧"
  0x68D5,  // { 0x9E, 0xA1 } "棕"
  0x6936,  // { 0x9E, 0xA2 } "椶"
  0x6912,  // { 0x9E, 0xA3 } "椒"
  0x6904,  // { 0x9E, 0xA4 } "椄"
  0x68D7,  // { 0x9E, 0xA5 } "棗"
  0x68E3,  // { 0x9E, 0xA6 } "棣"
  0x6925,  // { 0x9E, 0xA7 } "椥"
  0x68F9,  // { 0x9E, 0xA8 } "棹"
  0x68E0,  // { 0x9E, 0xA9 } "棠"
  0x68EF,  // { 0x9E, 0xAA } "棯"
  0x6928,  // { 0x9E, 0xAB } "椨"
  0x692A,  // { 0x9E, 0xAC } "椪"
  0x691A,  // { 0x9E, 0xAD } "椚"
  0x6923,  // { 0x9E, 0xAE } "椣"
  0x6921,  // { 0x9E, 0xAF } "椡"
  0x68C6,  // { 0x9E, 0xB0 } "棆"
  0x6979,  // { 0x9E, 0xB1 } "楹"
  0x6977,  // { 0x9E, 0xB2 } "楷"
  0x695C,  // { 0x9E, 0xB3 } "楜"
  0x6978,  // { 0x9E, 0xB4 } "楸"
  0x696B,  // { 0x9E, 0xB5 } "楫"
  0x6954,  // { 0x9E, 0xB6 } "楔"
  0x697E,  // { 0x9E, 0xB7 } "楾"
  0x696E,  // { 0x9E, 0xB8 } "楮"
  0x6939,  // { 0x9E, 0xB9 } "椹"
  0x6974,  // { 0x9E, 0xBA } "楴"
  0x693D,  // { 0x9E, 0xBB } "椽"
  0x6959,  // { 0x9E, 0xBC } "楙"
  0x6930,  // { 0x9E, 0xBD } "椰"
  0x6961,  // { 0x9E, 0xBE } "楡"
  0x695E,  // { 0x9E, 0xBF } "楞"
  0x695D,  // { 0x9E, 0xC0 } "楝"
  0x6981,  // { 0x9E, 0xC1 } "榁"
  0x696A,  // { 0x9E, 0xC2 } "楪"
  0x69B2,  // { 0x9E, 0xC3 } "榲"
  0x69AE,  // { 0x9E, 0xC4 } "榮"
  0x69D0,  // { 0x9E, 0xC5 } "槐"
  0x69BF,  // { 0x9E, 0xC6 } "榿"
  0x69C1,  // { 0x9E, 0xC7 } "槁"
  0x69D3,  // { 0x9E, 0xC8 } "槓"
  0x69BE,  // { 0x9E, 0xC9 } "榾"
  0x69CE,  // { 0x9E, 0xCA } "槎"
  0x5BE8,  // { 0x9E, 0xCB } "寨"
  0x69CA,  // { 0x9E, 0xCC } "槊"
  0x69DD,  // { 0x9E, 0xCD } "槝"
  0x69BB,  // { 0x9E, 0xCE } "榻"
  0x69C3,  // { 0x9E, 0xCF } "槃"
  0x69A7,  // { 0x9E, 0xD0 } "榧"
  0x6A2E,  // { 0x9E, 0xD1 } "樮"
  0x6991,  // { 0x9E, 0xD2 } "榑"
  0x69A0,  // { 0x9E, 0xD3 } "榠"
  0x699C,  // { 0x9E, 0xD4 } "榜"
  0x6995,  // { 0x9E, 0xD5 } "榕"
  0x69B4,  // { 0x9E, 0xD6 } "榴"
  0x69DE,  // { 0x9E, 0xD7 } "槞"
  0x69E8,  // { 0x9E, 0xD8 } "槨"
  0x6A02,  // { 0x9E, 0xD9 } "樂"
  0x6A1B,  // { 0x9E, 0xDA } "樛"
  0x69FF,  // { 0x9E, 0xDB } "槿"
  0x6B0A,  // { 0x9E, 0xDC } "權"
  0x69F9,  // { 0x9E, 0xDD } "槹"
  0x69F2,  // { 0x9E, 0xDE } "槲"
  0x69E7,  // { 0x9E, 0xDF } "槧"
  0x6A05,  // { 0x9E, 0xE0 } "樅"
  0x69B1,  // { 0x9E, 0xE1 } "榱"
  0x6A1E,  // { 0x9E, 0xE2 } "樞"
  0x69ED,  // { 0x9E, 0xE3 } "槭"
  0x6A14,  // { 0x9E, 0xE4 } "樔"
  0x69EB,  // { 0x9E, 0xE5 } "槫"
  0x6A0A,  // { 0x9E, 0xE6 } "樊"
  0x6A12,  // { 0x9E, 0xE7 } "樒"
  0x6AC1,  // { 0x9E, 0xE8 } "櫁"
  0x6A23,  // { 0x9E, 0xE9 } "樣"
  0x6A13,  // { 0x9E, 0xEA } "樓"
  0x6A44,  // { 0x9E, 0xEB } "橄"
  0x6A0C,  // { 0x9E, 0xEC } "樌"
  0x6A72,  // { 0x9E, 0xED } "橲"
  0x6A36,  // { 0x9E, 0xEE } "樶"
  0x6A78,  // { 0x9E, 0xEF } "橸"
  0x6A47,  // { 0x9E, 0xF0 } "橇"
  0x6A62,  // { 0x9E, 0xF1 } "橢"
  0x6A59,  // { 0x9E, 0xF2 } "橙"
  0x6A66,  // { 0x9E, 0xF3 } "橦"
  0x6A48,  // { 0x9E, 0xF4 } "橈"
  0x6A38,  // { 0x9E, 0xF5 } "樸"
  0x6A22,  // { 0x9E, 0xF6 } "樢"
  0x6A90,  // { 0x9E, 0xF7 } "檐"
  0x6A8D,  // { 0x9E, 0xF8 } "檍"
  0x6AA0,  // { 0x9E, 0xF9 } "檠"
  0x6A84,  // { 0x9E, 0xFA } "檄"
  0x6AA2,  // { 0x9E, 0xFB } "檢"
  0x6AA3,  // { 0x9E, 0xFC } "檣"
  0x0000,  // { 0x9E, 0xFD }
  0x0000,  // { 0x9E, 0xFE }
  0x0000,  // { 0x9E, 0xFF }
  0x6A97,  // { 0x9F, 0x40 } "檗"
  0x8617,  // { 0x9F, 0x41 } "蘗"
  0x6ABB,  // { 0x9F, 0x42 } "檻"
  0x6AC3,  // { 0x9F, 0x43 } "櫃"
  0x6AC2,  // { 0x9F, 0x44 } "櫂"
  0x6AB8,  // { 0x9F, 0x45 } "檸"
  0x6AB3,  // { 0x9F, 0x46 } "檳"
  0x6AAC,  // { 0x9F, 0x47 } "檬"
  0x6ADE,  // { 0x9F, 0x48 } "櫞"
  0x6AD1,  // { 0x9F, 0x49 } "櫑"
  0x6ADF,  // { 0x9F, 0x4A } "櫟"
  0x6AAA,  // { 0x9F, 0x4B } "檪"
  0x6ADA,  // { 0x9F, 0x4C } "櫚"
  0x6AEA,  // { 0x9F, 0x4D } "櫪"
  0x6AFB,  // { 0x9F, 0x4E } "櫻"
  0x6B05,  // { 0x9F, 0x4F } "欅"
  0x8616,  // { 0x9F, 0x50 } "蘖"
  0x6AFA,  // { 0x9F, 0x51 } "櫺"
  0x6B12,  // { 0x9F, 0x52 } "欒"
  0x6B16,  // { 0x9F, 0x53 } "欖"
  0x9B31,  // { 0x9F, 0x54 } "鬱"
  0x6B1F,  // { 0x9F, 0x55 } "欟"
  0x6B38,  // { 0x9F, 0x56 } "欸"
  0x6B37,  // { 0x9F, 0x57 } "欷"
  0x76DC,  // { 0x9F, 0x58 } "盜"
  0x6B39,  // { 0x9F, 0x59 } "欹"
  0x98EE,  // { 0x9F, 0x5A } "飮"
  0x6B47,  // { 0x9F, 0x5B } "歇"
  0x6B43,  // { 0x9F, 0x5C } "歃"
  0x6B49,  // { 0x9F, 0x5D } "歉"
  0x6B50,  // { 0x9F, 0x5E } "歐"
  0x6B59,  // { 0x9F, 0x5F } "歙"
  0x6B54,  // { 0x9F, 0x60 } "歔"
  0x6B5B,  // { 0x9F, 0x61 } "歛"
  0x6B5F,  // { 0x9F, 0x62 } "歟"
  0x6B61,  // { 0x9F, 0x63 } "歡"
  0x6B78,  // { 0x9F, 0x64 } "歸"
  0x6B79,  // { 0x9F, 0x65 } "歹"
  0x6B7F,  // { 0x9F, 0x66 } "歿"
  0x6B80,  // { 0x9F, 0x67 } "殀"
  0x6B84,  // { 0x9F, 0x68 } "殄"
  0x6B83,  // { 0x9F, 0x69 } "殃"
  0x6B8D,  // { 0x9F, 0x6A } "殍"
  0x6B98,  // { 0x9F, 0x6B } "殘"
  0x6B95,  // { 0x9F, 0x6C } "殕"
  0x6B9E,  // { 0x9F, 0x6D } "殞"
  0x6BA4,  // { 0x9F, 0x6E } "殤"
  0x6BAA,  // { 0x9F, 0x6F } "殪"
  0x6BAB,  // { 0x9F, 0x70 } "殫"
  0x6BAF,  // { 0x9F, 0x71 } "殯"
  0x6BB2,  // { 0x9F, 0x72 } "殲"
  0x6BB1,  // { 0x9F, 0x73 } "殱"
  0x6BB3,  // { 0x9F, 0x74 } "殳"
  0x6BB7,  // { 0x9F, 0x75 } "殷"
  0x6BBC,  // { 0x9F, 0x76 } "殼"
  0x6BC6,  // { 0x9F, 0x77 } "毆"
  0x6BCB,  // { 0x9F, 0x78 } "毋"
  0x6BD3,  // { 0x9F, 0x79 } "毓"
  0x6BDF,  // { 0x9F, 0x7A } "毟"
  0x6BEC,  // { 0x9F, 0x7B } "毬"
  0x6BEB,  // { 0x9F, 0x7C } "毫"
  0x6BF3,  // { 0x9F, 0x7D } "毳"
  0x6BEF,  // { 0x9F, 0x7E } "毯"
  0x9EBE,  // { 0x9F, 0x80 } "麾"
  0x6C08,  // { 0x9F, 0x81 } "氈"
  0x6C13,  // { 0x9F, 0x82 } "氓"
  0x6C14,  // { 0x9F, 0x83 } "气"
  0x6C1B,  // { 0x9F, 0x84 } "氛"
  0x6C24,  // { 0x9F, 0x85 } "氤"
  0x6C23,  // { 0x9F, 0x86 } "氣"
  0x6C5E,  // { 0x9F, 0x87 } "汞"
  0x6C55,  // { 0x9F, 0x88 } "汕"
  0x6C62,  // { 0x9F, 0x89 } "汢"
  0x6C6A,  // { 0x9F, 0x8A } "汪"
  0x6C82,  // { 0x9F, 0x8B } "沂"
  0x6C8D,  // { 0x9F, 0x8C } "沍"
  0x6C9A,  // { 0x9F, 0x8D } "沚"
  0x6C81,  // { 0x9F, 0x8E } "沁"
  0x6C9B,  // { 0x9F, 0x8F } "沛"
  0x6C7E,  // { 0x9F, 0x90 } "汾"
  0x6C68,  // { 0x9F, 0x91 } "汨"
  0x6C73,  // { 0x9F, 0x92 } "汳"
  0x6C92,  // { 0x9F, 0x93 } "沒"
  0x6C90,  // { 0x9F, 0x94 } "沐"
  0x6CC4,  // { 0x9F, 0x95 } "泄"
  0x6CF1,  // { 0x9F, 0x96 } "泱"
  0x6CD3,  // { 0x9F, 0x97 } "泓"
  0x6CBD,  // { 0x9F, 0x98 } "沽"
  0x6CD7,  // { 0x9F, 0x99 } "泗"
  0x6CC5,  // { 0x9F, 0x9A } "泅"
  0x6CDD,  // { 0x9F, 0x9B } "泝"
  0x6CAE,  // { 0x9F, 0x9C } "沮"
  0x6CB1,  // { 0x9F, 0x9D } "沱"
  0x6CBE,  // { 0x9F, 0x9E } "沾"
  0x6CBA,  // { 0x9F, 0x9F } "沺"
  0x6CDB,  // { 0x9F, 0xA0 } "泛"
  0x6CEF,  // { 0x9F, 0xA1 } "泯"
  0x6CD9,  // { 0x9F, 0xA2 } "泙"
  0x6CEA,  // { 0x9F, 0xA3 } "泪"
  0x6D1F,  // { 0x9F, 0xA4 } "洟"
  0x884D,  // { 0x9F, 0xA5 } "衍"
  0x6D36,  // { 0x9F, 0xA6 } "洶"
  0x6D2B,  // { 0x9F, 0xA7 } "洫"
  0x6D3D,  // { 0x9F, 0xA8 } "洽"
  0x6D38,  // { 0x9F, 0xA9 } "洸"
  0x6D19,  // { 0x9F, 0xAA } "洙"
  0x6D35,  // { 0x9F, 0xAB } "洵"
  0x6D33,  // { 0x9F, 0xAC } "洳"
  0x6D12,  // { 0x9F, 0xAD } "洒"
  0x6D0C,  // { 0x9F, 0xAE } "洌"
  0x6D63,  // { 0x9F, 0xAF } "浣"
  0x6D93,  // { 0x9F, 0xB0 } "涓"
  0x6D64,  // { 0x9F, 0xB1 } "浤"
  0x6D5A,  // { 0x9F, 0xB2 } "浚"
  0x6D79,  // { 0x9F, 0xB3 } "浹"
  0x6D59,  // { 0x9F, 0xB4 } "浙"
  0x6D8E,  // { 0x9F, 0xB5 } "涎"
  0x6D95,  // { 0x9F, 0xB6 } "涕"
  0x6FE4,  // { 0x9F, 0xB7 } "濤"
  0x6D85,  // { 0x9F, 0xB8 } "涅"
  0x6DF9,  // { 0x9F, 0xB9 } "淹"
  0x6E15,  // { 0x9F, 0xBA } "渕"
  0x6E0A,  // { 0x9F, 0xBB } "渊"
  0x6DB5,  // { 0x9F, 0xBC } "涵"
  0x6DC7,  // { 0x9F, 0xBD } "淇"
  0x6DE6,  // { 0x9F, 0xBE } "淦"
  0x6DB8,  // { 0x9F, 0xBF } "涸"
  0x6DC6,  // { 0x9F, 0xC0 } "淆"
  0x6DEC,  // { 0x9F, 0xC1 } "淬"
  0x6DDE,  // { 0x9F, 0xC2 } "淞"
  0x6DCC,  // { 0x9F, 0xC3 } "淌"
  0x6DE8,  // { 0x9F, 0xC4 } "淨"
  0x6DD2,  // { 0x9F, 0xC5 } "淒"
  0x6DC5,  // { 0x9F, 0xC6 } "淅"
  0x6DFA,  // { 0x9F, 0xC7 } "淺"
  0x6DD9,  // { 0x9F, 0xC8 } "淙"
  0x6DE4,  // { 0x9F, 0xC9 } "淤"
  0x6DD5,  // { 0x9F, 0xCA } "淕"
  0x6DEA,  // { 0x9F, 0xCB } "淪"
  0x6DEE,  // { 0x9F, 0xCC } "淮"
  0x6E2D,  // { 0x9F, 0xCD } "渭"
  0x6E6E,  // { 0x9F, 0xCE } "湮"
  0x6E2E,  // { 0x9F, 0xCF } "渮"
  0x6E19,  // { 0x9F, 0xD0 } "渙"
  0x6E72,  // { 0x9F, 0xD1 } "湲"
  0x6E5F,  // { 0x9F, 0xD2 } "湟"
  0x6E3E,  // { 0x9F, 0xD3 } "渾"
  0x6E23,  // { 0x9F, 0xD4 } "渣"
  0x6E6B,  // { 0x9F, 0xD5 } "湫"
  0x6E2B,  // { 0x9F, 0xD6 } "渫"
  0x6E76,  // { 0x9F, 0xD7 } "湶"
  0x6E4D,  // { 0x9F, 0xD8 } "湍"
  0x6E1F,  // { 0x9F, 0xD9 } "渟"
  0x6E43,  // { 0x9F, 0xDA } "湃"
  0x6E3A,  // { 0x9F, 0xDB } "渺"
  0x6E4E,  // { 0x9F, 0xDC } "湎"
  0x6E24,  // { 0x9F, 0xDD } "渤"
  0x6EFF,  // { 0x9F, 0xDE } "滿"
  0x6E1D,  // { 0x9F, 0xDF } "渝"
  0x6E38,  // { 0x9F, 0xE0 } "游"
  0x6E82,  // { 0x9F, 0xE1 } "溂"
  0x6EAA,  // { 0x9F, 0xE2 } "溪"
  0x6E98,  // { 0x9F, 0xE3 } "溘"
  0x6EC9,  // { 0x9F, 0xE4 } "滉"
  0x6EB7,  // { 0x9F, 0xE5 } "溷"
  0x6ED3,  // { 0x9F, 0xE6 } "滓"
  0x6EBD,  // { 0x9F, 0xE7 } "溽"
  0x6EAF,  // { 0x9F, 0xE8 } "溯"
  0x6EC4,  // { 0x9F, 0xE9 } "滄"
  0x6EB2,  // { 0x9F, 0xEA } "溲"
  0x6ED4,  // { 0x9F, 0xEB } "滔"
  0x6ED5,  // { 0x9F, 0xEC } "滕"
  0x6E8F,  // { 0x9F, 0xED } "溏"
  0x6EA5,  // { 0x9F, 0xEE } "溥"
  0x6EC2,  // { 0x9F, 0xEF } "滂"
  0x6E9F,  // { 0x9F, 0xF0 } "溟"
  0x6F41,  // { 0x9F, 0xF1 } "潁"
  0x6F11,  // { 0x9F, 0xF2 } "漑"
  0x704C,  // { 0x9F, 0xF3 } "灌"
  0x6EEC,  // { 0x9F, 0xF4 } "滬"
  0x6EF8,  // { 0x9F, 0xF5 } "滸"
  0x6EFE,  // { 0x9F, 0xF6 } "滾"
  0x6F3F,  // { 0x9F, 0xF7 } "漿"
  0x6EF2,  // { 0x9F, 0xF8 } "滲"
  0x6F31,  // { 0x9F, 0xF9 } "漱"
  0x6EEF,  // { 0x9F, 0xFA } "滯"
  0x6F32,  // { 0x9F, 0xFB } "漲"
  0x6ECC,  // { 0x9F, 0xFC } "滌"
  0x0000,  // { 0x9F, 0xFD }
  0x0000,  // { 0x9F, 0xFE }
  0x0000,  // { 0x9F, 0xFF }
  0x6F3E,  // { 0xE0, 0x40 } "漾"
  0x6F13,  // { 0xE0, 0x41 } "漓"
  0x6EF7,  // { 0xE0, 0x42 } "滷"
  0x6F86,  // { 0xE0, 0x43 } "澆"
  0x6F7A,  // { 0xE0, 0x44 } "潺"
  0x6F78,  // { 0xE0, 0x45 } "潸"
  0x6F81,  // { 0xE0, 0x46 } "澁"
  0x6F80,  // { 0xE0, 0x47 } "澀"
  0x6F6F,  // { 0xE0, 0x48 } "潯"
  0x6F5B,  // { 0xE0, 0x49 } "潛"
  0x6FF3,  // { 0xE0, 0x4A } "濳"
  0x6F6D,  // { 0xE0, 0x4B } "潭"
  0x6F82,  // { 0xE0, 0x4C } "澂"
  0x6F7C,  // { 0xE0, 0x4D } "潼"
  0x6F58,  // { 0xE0, 0x4E } "潘"
  0x6F8E,  // { 0xE0, 0x4F } "澎"
  0x6F91,  // { 0xE0, 0x50 } "澑"
  0x6FC2,  // { 0xE0, 0x51 } "濂"
  0x6F66,  // { 0xE0, 0x52 } "潦"
  0x6FB3,  // { 0xE0, 0x53 } "澳"
  0x6FA3,  // { 0xE0, 0x54 } "澣"
  0x6FA1,  // { 0xE0, 0x55 } "澡"
  0x6FA4,  // { 0xE0, 0x56 } "澤"
  0x6FB9,  // { 0xE0, 0x57 } "澹"
  0x6FC6,  // { 0xE0, 0x58 } "濆"
  0x6FAA,  // { 0xE0, 0x59 } "澪"
  0x6FDF,  // { 0xE0, 0x5A } "濟"
  0x6FD5,  // { 0xE0, 0x5B } "濕"
  0x6FEC,  // { 0xE0, 0x5C } "濬"
  0x6FD4,  // { 0xE0, 0x5D } "濔"
  0x6FD8,  // { 0xE0, 0x5E } "濘"
  0x6FF1,  // { 0xE0, 0x5F } "濱"
  0x6FEE,  // { 0xE0, 0x60 } "濮"
  0x6FDB,  // { 0xE0, 0x61 } "濛"
  0x7009,  // { 0xE0, 0x62 } "瀉"
  0x700B,  // { 0xE0, 0x63 } "瀋"
  0x6FFA,  // { 0xE0, 0x64 } "濺"
  0x7011,  // { 0xE0, 0x65 } "瀑"
  0x7001,  // { 0xE0, 0x66 } "瀁"
  0x700F,  // { 0xE0, 0x67 } "瀏"
  0x6FFE,  // { 0xE0, 0x68 } "濾"
  0x701B,  // { 0xE0, 0x69 } "瀛"
  0x701A,  // { 0xE0, 0x6A } "瀚"
  0x6F74,  // { 0xE0, 0x6B } "潴"
  0x701D,  // { 0xE0, 0x6C } "瀝"
  0x7018,  // { 0xE0, 0x6D } "瀘"
  0x701F,  // { 0xE0, 0x6E } "瀟"
  0x7030,  // { 0xE0, 0x6F } "瀰"
  0x703E,  // { 0xE0, 0x70 } "瀾"
  0x7032,  // { 0xE0, 0x71 } "瀲"
  0x7051,  // { 0xE0, 0x72 } "灑"
  0x7063,  // { 0xE0, 0x73 } "灣"
  0x7099,  // { 0xE0, 0x74 } "炙"
  0x7092,  // { 0xE0, 0x75 } "炒"
  0x70AF,  // { 0xE0, 0x76 } "炯"
  0x70F1,  // { 0xE0, 0x77 } "烱"
  0x70AC,  // { 0xE0, 0x78 } "炬"
  0x70B8,  // { 0xE0, 0x79 } "炸"
  0x70B3,  // { 0xE0, 0x7A } "炳"
  0x70AE,  // { 0xE0, 0x7B } "炮"
  0x70DF,  // { 0xE0, 0x7C } "烟"
  0x70CB,  // { 0xE0, 0x7D } "烋"
  0x70DD,  // { 0xE0, 0x7E } "烝"
  0x70D9,  // { 0xE0, 0x80 } "烙"
  0x7109,  // { 0xE0, 0x81 } "焉"
  0x70FD,  // { 0xE0, 0x82 } "烽"
  0x711C,  // { 0xE0, 0x83 } "焜"
  0x7119,  // { 0xE0, 0x84 } "焙"
  0x7165,  // { 0xE0, 0x85 } "煥"
  0x7155,  // { 0xE0, 0x86 } "煕"
  0x7188,  // { 0xE0, 0x87 } "熈"
  0x7166,  // { 0xE0, 0x88 } "煦"
  0x7162,  // { 0xE0, 0x89 } "煢"
  0x714C,  // { 0xE0, 0x8A } "煌"
  0x7156,  // { 0xE0, 0x8B } "煖"
  0x716C,  // { 0xE0, 0x8C } "煬"
  0x718F,  // { 0xE0, 0x8D } "熏"
  0x71FB,  // { 0xE0, 0x8E } "燻"
  0x7184,  // { 0xE0, 0x8F } "熄"
  0x7195,  // { 0xE0, 0x90 } "熕"
  0x71A8,  // { 0xE0, 0x91 } "熨"
  0x71AC,  // { 0xE0, 0x92 } "熬"
  0x71D7,  // { 0xE0, 0x93 } "燗"
  0x71B9,  // { 0xE0, 0x94 } "熹"
  0x71BE,  // { 0xE0, 0x95 } "熾"
  0x71D2,  // { 0xE0, 0x96 } "燒"
  0x71C9,  // { 0xE0, 0x97 } "燉"
  0x71D4,  // { 0xE0, 0x98 } "燔"
  0x71CE,  // { 0xE0, 0x99 } "燎"
  0x71E0,  // { 0xE0, 0x9A } "燠"
  0x71EC,  // { 0xE0, 0x9B } "燬"
  0x71E7,  // { 0xE0, 0x9C } "燧"
  0x71F5,  // { 0xE0, 0x9D } "燵"
  0x71FC,  // { 0xE0, 0x9E } "燼"
  0x71F9,  // { 0xE0, 0x9F } "燹"
  0x71FF,  // { 0xE0, 0xA0 } "燿"
  0x720D,  // { 0xE0, 0xA1 } "爍"
  0x7210,  // { 0xE0, 0xA2 } "爐"
  0x721B,  // { 0xE0, 0xA3 } "爛"
  0x7228,  // { 0xE0, 0xA4 } "爨"
  0x722D,  // { 0xE0, 0xA5 } "爭"
  0x722C,  // { 0xE0, 0xA6 } "爬"
  0x7230,  // { 0xE0, 0xA7 } "爰"
  0x7232,  // { 0xE0, 0xA8 } "爲"
  0x723B,  // { 0xE0, 0xA9 } "爻"
  0x723C,  // { 0xE0, 0xAA } "爼"
  0x723F,  // { 0xE0, 0xAB } "爿"
  0x7240,  // { 0xE0, 0xAC } "牀"
  0x7246,  // { 0xE0, 0xAD } "牆"
  0x724B,  // { 0xE0, 0xAE } "牋"
  0x7258,  // { 0xE0, 0xAF } "牘"
  0x7274,  // { 0xE0, 0xB0 } "牴"
  0x727E,  // { 0xE0, 0xB1 } "牾"
  0x7282,  // { 0xE0, 0xB2 } "犂"
  0x7281,  // { 0xE0, 0xB3 } "犁"
  0x7287,  // { 0xE0, 0xB4 } "犇"
  0x7292,  // { 0xE0, 0xB5 } "犒"
  0x7296,  // { 0xE0, 0xB6 } "犖"
  0x72A2,  // { 0xE0, 0xB7 } "犢"
  0x72A7,  // { 0xE0, 0xB8 } "犧"
  0x72B9,  // { 0xE0, 0xB9 } "犹"
  0x72B2,  // { 0xE0, 0xBA } "犲"
  0x72C3,  // { 0xE0, 0xBB } "狃"
  0x72C6,  // { 0xE0, 0xBC } "狆"
  0x72C4,  // { 0xE0, 0xBD } "狄"
  0x72CE,  // { 0xE0, 0xBE } "狎"
  0x72D2,  // { 0xE0, 0xBF } "狒"
  0x72E2,  // { 0xE0, 0xC0 } "狢"
  0x72E0,  // { 0xE0, 0xC1 } "狠"
  0x72E1,  // { 0xE0, 0xC2 } "狡"
  0x72F9,  // { 0xE0, 0xC3 } "狹"
  0x72F7,  // { 0xE0, 0xC4 } "狷"
  0x500F,  // { 0xE0, 0xC5 } "倏"
  0x7317,  // { 0xE0, 0xC6 } "猗"
  0x730A,  // { 0xE0, 0xC7 } "猊"
  0x731C,  // { 0xE0, 0xC8 } "猜"
  0x7316,  // { 0xE0, 0xC9 } "猖"
  0x731D,  // { 0xE0, 0xCA } "猝"
  0x7334,  // { 0xE0, 0xCB } "猴"
  0x732F,  // { 0xE0, 0xCC } "猯"
  0x7329,  // { 0xE0, 0xCD } "猩"
  0x7325,  // { 0xE0, 0xCE } "猥"
  0x733E,  // { 0xE0, 0xCF } "猾"
  0x734E,  // { 0xE0, 0xD0 } "獎"
  0x734F,  // { 0xE0, 0xD1 } "獏"
  0x9ED8,  // { 0xE0, 0xD2 } "默"
  0x7357,  // { 0xE0, 0xD3 } "獗"
  0x736A,  // { 0xE0, 0xD4 } "獪"
  0x7368,  // { 0xE0, 0xD5 } "獨"
  0x7370,  // { 0xE0, 0xD6 } "獰"
  0x7378,  // { 0xE0, 0xD7 } "獸"
  0x7375,  // { 0xE0, 0xD8 } "獵"
  0x737B,  // { 0xE0, 0xD9 } "獻"
  0x737A,  // { 0xE0, 0xDA } "獺"
  0x73C8,  // { 0xE0, 0xDB } "珈"
  0x73B3,  // { 0xE0, 0xDC } "玳"
  0x73CE,  // { 0xE0, 0xDD } "珎"
  0x73BB,  // { 0xE0, 0xDE } "玻"
  0x73C0,  // { 0xE0, 0xDF } "珀"
  0x73E5,  // { 0xE0, 0xE0 } "珥"
  0x73EE,  // { 0xE0, 0xE1 } "珮"
  0x73DE,  // { 0xE0, 0xE2 } "珞"
  0x74A2,  // { 0xE0, 0xE3 } "璢"
  0x7405,  // { 0xE0, 0xE4 } "琅"
  0x746F,  // { 0xE0, 0xE5 } "瑯"
  0x7425,  // { 0xE0, 0xE6 } "琥"
  0x73F8,  // { 0xE0, 0xE7 } "珸"
  0x7432,  // { 0xE0, 0xE8 } "琲"
  0x743A,  // { 0xE0, 0xE9 } "琺"
  0x7455,  // { 0xE0, 0xEA } "瑕"
  0x743F,  // { 0xE0, 0xEB } "琿"
  0x745F,  // { 0xE0, 0xEC } "瑟"
  0x7459,  // { 0xE0, 0xED } "瑙"
  0x7441,  // { 0xE0, 0xEE } "瑁"
  0x745C,  // { 0xE0, 0xEF } "瑜"
  0x7469,  // { 0xE0, 0xF0 } "瑩"
  0x7470,  // { 0xE0, 0xF1 } "瑰"
  0x7463,  // { 0xE0, 0xF2 } "瑣"
  0x746A,  // { 0xE0, 0xF3 } "瑪"
  0x7476,  // { 0xE0, 0xF4 } "瑶"
  0x747E,  // { 0xE0, 0xF5 } "瑾"
  0x748B,  // { 0xE0, 0xF6 } "璋"
  0x749E,  // { 0xE0, 0xF7 } "璞"
  0x74A7,  // { 0xE0, 0xF8 } "璧"
  0x74CA,  // { 0xE0, 0xF9 } "瓊"
  0x74CF,  // { 0xE0, 0xFA } "瓏"
  0x74D4,  // { 0xE0, 0xFB } "瓔"
  0x73F1,  // { 0xE0, 0xFC } "珱"
  0x0000,  // { 0xE0, 0xFD }
  0x0000,  // { 0xE0, 0xFE }
  0x0000,  // { 0xE0, 0xFF }
  0x74E0,  // { 0xE1, 0x40 } "瓠"
  0x74E3,  // { 0xE1, 0x41 } "瓣"
  0x74E7,  // { 0xE1, 0x42 } "瓧"
  0x74E9,  // { 0xE1, 0x43 } "瓩"
  0x74EE,  // { 0xE1, 0x44 } "瓮"
  0x74F2,  // { 0xE1, 0x45 } "瓲"
  0x74F0,  // { 0xE1, 0x46 } "瓰"
  0x74F1,  // { 0xE1, 0x47 } "瓱"
  0x74F8,  // { 0xE1, 0x48 } "瓸"
  0x74F7,  // { 0xE1, 0x49 } "瓷"
  0x7504,  // { 0xE1, 0x4A } "甄"
  0x7503,  // { 0xE1, 0x4B } "甃"
  0x7505,  // { 0xE1, 0x4C } "甅"
  0x750C,  // { 0xE1, 0x4D } "甌"
  0x750E,  // { 0xE1, 0x4E } "甎"
  0x750D,  // { 0xE1, 0x4F } "甍"
  0x7515,  // { 0xE1, 0x50 } "甕"
  0x7513,  // { 0xE1, 0x51 } "甓"
  0x751E,  // { 0xE1, 0x52 } "甞"
  0x7526,  // { 0xE1, 0x53 } "甦"
  0x752C,  // { 0xE1, 0x54 } "甬"
  0x753C,  // { 0xE1, 0x55 } "甼"
  0x7544,  // { 0xE1, 0x56 } "畄"
  0x754D,  // { 0xE1, 0x57 } "畍"
  0x754A,  // { 0xE1, 0x58 } "畊"
  0x7549,  // { 0xE1, 0x59 } "畉"
  0x755B,  // { 0xE1, 0x5A } "畛"
  0x7546,  // { 0xE1, 0x5B } "畆"
  0x755A,  // { 0xE1, 0x5C } "畚"
  0x7569,  // { 0xE1, 0x5D } "畩"
  0x7564,  // { 0xE1, 0x5E } "畤"
  0x7567,  // { 0xE1, 0x5F } "畧"
  0x756B,  // { 0xE1, 0x60 } "畫"
  0x756D,  // { 0xE1, 0x61 } "畭"
  0x7578,  // { 0xE1, 0x62 } "畸"
  0x7576,  // { 0xE1, 0x63 } "當"
  0x7586,  // { 0xE1, 0x64 } "疆"
  0x7587,  // { 0xE1, 0x65 } "疇"
  0x7574,  // { 0xE1, 0x66 } "畴"
  0x758A,  // { 0xE1, 0x67 } "疊"
  0x7589,  // { 0xE1, 0x68 } "疉"
  0x7582,  // { 0xE1, 0x69 } "疂"
  0x7594,  // { 0xE1, 0x6A } "疔"
  0x759A,  // { 0xE1, 0x6B } "疚"
  0x759D,  // { 0xE1, 0x6C } "疝"
  0x75A5,  // { 0xE1, 0x6D } "疥"
  0x75A3,  // { 0xE1, 0x6E } "疣"
  0x75C2,  // { 0xE1, 0x6F } "痂"
  0x75B3,  // { 0xE1, 0x70 } "疳"
  0x75C3,  // { 0xE1, 0x71 } "痃"
  0x75B5,  // { 0xE1, 0x72 } "疵"
  0x75BD,  // { 0xE1, 0x73 } "疽"
  0x75B8,  // { 0xE1, 0x74 } "疸"
  0x75BC,  // { 0xE1, 0x75 } "疼"
  0x75B1,  // { 0xE1, 0x76 } "疱"
  0x75CD,  // { 0xE1, 0x77 } "痍"
  0x75CA,  // { 0xE1, 0x78 } "痊"
  0x75D2,  // { 0xE1, 0x79 } "痒"
  0x75D9,  // { 0xE1, 0x7A } "痙"
  0x75E3,  // { 0xE1, 0x7B } "痣"
  0x75DE,  // { 0xE1, 0x7C } "痞"
  0x75FE,  // { 0xE1, 0x7D } "痾"
  0x75FF,  // { 0xE1, 0x7E } "痿"
  0x75FC,  // { 0xE1, 0x80 } "痼"
  0x7601,  // { 0xE1, 0x81 } "瘁"
  0x75F0,  // { 0xE1, 0x82 } "痰"
  0x75FA,  // { 0xE1, 0x83 } "痺"
  0x75F2,  // { 0xE1, 0x84 } "痲"
  0x75F3,  // { 0xE1, 0x85 } "痳"
  0x760B,  // { 0xE1, 0x86 } "瘋"
  0x760D,  // { 0xE1, 0x87 } "瘍"
  0x7609,  // { 0xE1, 0x88 } "瘉"
  0x761F,  // { 0xE1, 0x89 } "瘟"
  0x7627,  // { 0xE1, 0x8A } "瘧"
  0x7620,  // { 0xE1, 0x8B } "瘠"
  0x7621,  // { 0xE1, 0x8C } "瘡"
  0x7622,  // { 0xE1, 0x8D } "瘢"
  0x7624,  // { 0xE1, 0x8E } "瘤"
  0x7634,  // { 0xE1, 0x8F } "瘴"
  0x7630,  // { 0xE1, 0x90 } "瘰"
  0x763B,  // { 0xE1, 0x91 } "瘻"
  0x7647,  // { 0xE1, 0x92 } "癇"
  0x7648,  // { 0xE1, 0x93 } "癈"
  0x7646,  // { 0xE1, 0x94 } "癆"
  0x765C,  // { 0xE1, 0x95 } "癜"
  0x7658,  // { 0xE1, 0x96 } "癘"
  0x7661,  // { 0xE1, 0x97 } "癡"
  0x7662,  // { 0xE1, 0x98 } "癢"
  0x7668,  // { 0xE1, 0x99 } "癨"
  0x7669,  // { 0xE1, 0x9A } "癩"
  0x766A,  // { 0xE1, 0x9B } "癪"
  0x7667,  // { 0xE1, 0x9C } "癧"
  0x766C,  // { 0xE1, 0x9D } "癬"
  0x7670,  // { 0xE1, 0x9E } "癰"
  0x7672,  // { 0xE1, 0x9F } "癲"
  0x7676,  // { 0xE1, 0xA0 } "癶"
  0x7678,  // { 0xE1, 0xA1 } "癸"
  0x767C,  // { 0xE1, 0xA2 } "發"
  0x7680,  // { 0xE1, 0xA3 } "皀"
  0x7683,  // { 0xE1, 0xA4 } "皃"
  0x7688,  // { 0xE1, 0xA5 } "皈"
  0x768B,  // { 0xE1, 0xA6 } "皋"
  0x768E,  // { 0xE1, 0xA7 } "皎"
  0x7696,  // { 0xE1, 0xA8 } "皖"
  0x7693,  // { 0xE1, 0xA9 } "皓"
  0x7699,  // { 0xE1, 0xAA } "皙"
  0x769A,  // { 0xE1, 0xAB } "皚"
  0x76B0,  // { 0xE1, 0xAC } "皰"
  0x76B4,  // { 0xE1, 0xAD } "皴"
  0x76B8,  // { 0xE1, 0xAE } "皸"
  0x76B9,  // { 0xE1, 0xAF } "皹"
  0x76BA,  // { 0xE1, 0xB0 } "皺"
  0x76C2,  // { 0xE1, 0xB1 } "盂"
  0x76CD,  // { 0xE1, 0xB2 } "盍"
  0x76D6,  // { 0xE1, 0xB3 } "盖"
  0x76D2,  // { 0xE1, 0xB4 } "盒"
  0x76DE,  // { 0xE1, 0xB5 } "盞"
  0x76E1,  // { 0xE1, 0xB6 } "盡"
  0x76E5,  // { 0xE1, 0xB7 } "盥"
  0x76E7,  // { 0xE1, 0xB8 } "盧"
  0x76EA,  // { 0xE1, 0xB9 } "盪"
  0x862F,  // { 0xE1, 0xBA } "蘯"
  0x76FB,  // { 0xE1, 0xBB } "盻"
  0x7708,  // { 0xE1, 0xBC } "眈"
  0x7707,  // { 0xE1, 0xBD } "眇"
  0x7704,  // { 0xE1, 0xBE } "眄"
  0x7729,  // { 0xE1, 0xBF } "眩"
  0x7724,  // { 0xE1, 0xC0 } "眤"
  0x771E,  // { 0xE1, 0xC1 } "眞"
  0x7725,  // { 0xE1, 0xC2 } "眥"
  0x7726,  // { 0xE1, 0xC3 } "眦"
  0x771B,  // { 0xE1, 0xC4 } "眛"
  0x7737,  // { 0xE1, 0xC5 } "眷"
  0x7738,  // { 0xE1, 0xC6 } "眸"
  0x7747,  // { 0xE1, 0xC7 } "睇"
  0x775A,  // { 0xE1, 0xC8 } "睚"
  0x7768,  // { 0xE1, 0xC9 } "睨"
  0x776B,  // { 0xE1, 0xCA } "睫"
  0x775B,  // { 0xE1, 0xCB } "睛"
  0x7765,  // { 0xE1, 0xCC } "睥"
  0x777F,  // { 0xE1, 0xCD } "睿"
  0x777E,  // { 0xE1, 0xCE } "睾"
  0x7779,  // { 0xE1, 0xCF } "睹"
  0x778E,  // { 0xE1, 0xD0 } "瞎"
  0x778B,  // { 0xE1, 0xD1 } "瞋"
  0x7791,  // { 0xE1, 0xD2 } "瞑"
  0x77A0,  // { 0xE1, 0xD3 } "瞠"
  0x779E,  // { 0xE1, 0xD4 } "瞞"
  0x77B0,  // { 0xE1, 0xD5 } "瞰"
  0x77B6,  // { 0xE1, 0xD6 } "瞶"
  0x77B9,  // { 0xE1, 0xD7 } "瞹"
  0x77BF,  // { 0xE1, 0xD8 } "瞿"
  0x77BC,  // { 0xE1, 0xD9 } "瞼"
  0x77BD,  // { 0xE1, 0xDA } "瞽"
  0x77BB,  // { 0xE1, 0xDB } "瞻"
  0x77C7,  // { 0xE1, 0xDC } "矇"
  0x77CD,  // { 0xE1, 0xDD } "矍"
  0x77D7,  // { 0xE1, 0xDE } "矗"
  0x77DA,  // { 0xE1, 0xDF } "矚"
  0x77DC,  // { 0xE1, 0xE0 } "矜"
  0x77E3,  // { 0xE1, 0xE1 } "矣"
  0x77EE,  // { 0xE1, 0xE2 } "矮"
  0x77FC,  // { 0xE1, 0xE3 } "矼"
  0x780C,  // { 0xE1, 0xE4 } "砌"
  0x7812,  // { 0xE1, 0xE5 } "砒"
  0x7926,  // { 0xE1, 0xE6 } "礦"
  0x7820,  // { 0xE1, 0xE7 } "砠"
  0x792A,  // { 0xE1, 0xE8 } "礪"
  0x7845,  // { 0xE1, 0xE9 } "硅"
  0x788E,  // { 0xE1, 0xEA } "碎"
  0x7874,  // { 0xE1, 0xEB } "硴"
  0x7886,  // { 0xE1, 0xEC } "碆"
  0x787C,  // { 0xE1, 0xED } "硼"
  0x789A,  // { 0xE1, 0xEE } "碚"
  0x788C,  // { 0xE1, 0xEF } "碌"
  0x78A3,  // { 0xE1, 0xF0 } "碣"
  0x78B5,  // { 0xE1, 0xF1 } "碵"
  0x78AA,  // { 0xE1, 0xF2 } "碪"
  0x78AF,  // { 0xE1, 0xF3 } "碯"
  0x78D1,  // { 0xE1, 0xF4 } "磑"
  0x78C6,  // { 0xE1, 0xF5 } "磆"
  0x78CB,  // { 0xE1, 0xF6 } "磋"
  0x78D4,  // { 0xE1, 0xF7 } "磔"
  0x78BE,  // { 0xE1, 0xF8 } "碾"
  0x78BC,  // { 0xE1, 0xF9 } "碼"
  0x78C5,  // { 0xE1, 0xFA } "磅"
  0x78CA,  // { 0xE1, 0xFB } "磊"
  0x78EC,  // { 0xE1, 0xFC } "磬"
  0x0000,  // { 0xE1, 0xFD }
  0x0000,  // { 0xE1, 0xFE }
  0x0000,  // { 0xE1, 0xFF }
  0x78E7,  // { 0xE2, 0x40 } "磧"
  0x78DA,  // { 0xE2, 0x41 } "磚"
  0x78FD,  // { 0xE2, 0x42 } "磽"
  0x78F4,  // { 0xE2, 0x43 } "磴"
  0x7907,  // { 0xE2, 0x44 } "礇"
  0x7912,  // { 0xE2, 0x45 } "礒"
  0x7911,  // { 0xE2, 0x46 } "礑"
  0x7919,  // { 0xE2, 0x47 } "礙"
  0x792C,  // { 0xE2, 0x48 } "礬"
  0x792B,  // { 0xE2, 0x49 } "礫"
  0x7940,  // { 0xE2, 0x4A } "祀"
  0x7960,  // { 0xE2, 0x4B } "祠"
  0x7957,  // { 0xE2, 0x4C } "祗"
  0x795F,  // { 0xE2, 0x4D } "祟"
  0x795A,  // { 0xE2, 0x4E } "祚"
  0x7955,  // { 0xE2, 0x4F } "祕"
  0x7953,  // { 0xE2, 0x50 } "祓"
  0x797A,  // { 0xE2, 0x51 } "祺"
  0x797F,  // { 0xE2, 0x52 } "祿"
  0x798A,  // { 0xE2, 0x53 } "禊"
  0x799D,  // { 0xE2, 0x54 } "禝"
  0x79A7,  // { 0xE2, 0x55 } "禧"
  0x9F4B,  // { 0xE2, 0x56 } "齋"
  0x79AA,  // { 0xE2, 0x57 } "禪"
  0x79AE,  // { 0xE2, 0x58 } "禮"
  0x79B3,  // { 0xE2, 0x59 } "禳"
  0x79B9,  // { 0xE2, 0x5A } "禹"
  0x79BA,  // { 0xE2, 0x5B } "禺"
  0x79C9,  // { 0xE2, 0x5C } "秉"
  0x79D5,  // { 0xE2, 0x5D } "秕"
  0x79E7,  // { 0xE2, 0x5E } "秧"
  0x79EC,  // { 0xE2, 0x5F } "秬"
  0x79E1,  // { 0xE2, 0x60 } "秡"
  0x79E3,  // { 0xE2, 0x61 } "秣"
  0x7A08,  // { 0xE2, 0x62 } "稈"
  0x7A0D,  // { 0xE2, 0x63 } "稍"
  0x7A18,  // { 0xE2, 0x64 } "稘"
  0x7A19,  // { 0xE2, 0x65 } "稙"
  0x7A20,  // { 0xE2, 0x66 } "稠"
  0x7A1F,  // { 0xE2, 0x67 } "稟"
  0x7980,  // { 0xE2, 0x68 } "禀"
  0x7A31,  // { 0xE2, 0x69 } "稱"
  0x7A3B,  // { 0xE2, 0x6A } "稻"
  0x7A3E,  // { 0xE2, 0x6B } "稾"
  0x7A37,  // { 0xE2, 0x6C } "稷"
  0x7A43,  // { 0xE2, 0x6D } "穃"
  0x7A57,  // { 0xE2, 0x6E } "穗"
  0x7A49,  // { 0xE2, 0x6F } "穉"
  0x7A61,  // { 0xE2, 0x70 } "穡"
  0x7A62,  // { 0xE2, 0x71 } "穢"
  0x7A69,  // { 0xE2, 0x72 } "穩"
  0x9F9D,  // { 0xE2, 0x73 } "龝"
  0x7A70,  // { 0xE2, 0x74 } "穰"
  0x7A79,  // { 0xE2, 0x75 } "穹"
  0x7A7D,  // { 0xE2, 0x76 } "穽"
  0x7A88,  // { 0xE2, 0x77 } "窈"
  0x7A97,  // { 0xE2, 0x78 } "窗"
  0x7A95,  // { 0xE2, 0x79 } "窕"
  0x7A98,  // { 0xE2, 0x7A } "窘"
  0x7A96,  // { 0xE2, 0x7B } "窖"
  0x7AA9,  // { 0xE2, 0x7C } "窩"
  0x7AC8,  // { 0xE2, 0x7D } "竈"
  0x7AB0,  // { 0xE2, 0x7E } "窰"
  0x7AB6,  // { 0xE2, 0x80 } "窶"
  0x7AC5,  // { 0xE2, 0x81 } "竅"
  0x7AC4,  // { 0xE2, 0x82 } "竄"
  0x7ABF,  // { 0xE2, 0x83 } "窿"
  0x9083,  // { 0xE2, 0x84 } "邃"
  0x7AC7,  // { 0xE2, 0x85 } "竇"
  0x7ACA,  // { 0xE2, 0x86 } "竊"
  0x7ACD,  // { 0xE2, 0x87 } "竍"
  0x7ACF,  // { 0xE2, 0x88 } "竏"
  0x7AD5,  // { 0xE2, 0x89 } "竕"
  0x7AD3,  // { 0xE2, 0x8A } "竓"
  0x7AD9,  // { 0xE2, 0x8B } "站"
  0x7ADA,  // { 0xE2, 0x8C } "竚"
  0x7ADD,  // { 0xE2, 0x8D } "竝"
  0x7AE1,  // { 0xE2, 0x8E } "竡"
  0x7AE2,  // { 0xE2, 0x8F } "竢"
  0x7AE6,  // { 0xE2, 0x90 } "竦"
  0x7AED,  // { 0xE2, 0x91 } "竭"
  0x7AF0,  // { 0xE2, 0x92 } "竰"
  0x7B02,  // { 0xE2, 0x93 } "笂"
  0x7B0F,  // { 0xE2, 0x94 } "笏"
  0x7B0A,  // { 0xE2, 0x95 } "笊"
  0x7B06,  // { 0xE2, 0x96 } "笆"
  0x7B33,  // { 0xE2, 0x97 } "笳"
  0x7B18,  // { 0xE2, 0x98 } "笘"
  0x7B19,  // { 0xE2, 0x99 } "笙"
  0x7B1E,  // { 0xE2, 0x9A } "笞"
  0x7B35,  // { 0xE2, 0x9B } "笵"
  0x7B28,  // { 0xE2, 0x9C } "笨"
  0x7B36,  // { 0xE2, 0x9D } "笶"
  0x7B50,  // { 0xE2, 0x9E } "筐"
  0x7B7A,  // { 0xE2, 0x9F } "筺"
  0x7B04,  // { 0xE2, 0xA0 } "笄"
  0x7B4D,  // { 0xE2, 0xA1 } "筍"
  0x7B0B,  // { 0xE2, 0xA2 } "笋"
  0x7B4C,  // { 0xE2, 0xA3 } "筌"
  0x7B45,  // { 0xE2, 0xA4 } "筅"
  0x7B75,  // { 0xE2, 0xA5 } "筵"
  0x7B65,  // { 0xE2, 0xA6 } "筥"
  0x7B74,  // { 0xE2, 0xA7 } "筴"
  0x7B67,  // { 0xE2, 0xA8 } "筧"
  0x7B70,  // { 0xE2, 0xA9 } "筰"
  0x7B71,  // { 0xE2, 0xAA } "筱"
  0x7B6C,  // { 0xE2, 0xAB } "筬"
  0x7B6E,  // { 0xE2, 0xAC } "筮"
  0x7B9D,  // { 0xE2, 0xAD } "箝"
  0x7B98,  // { 0xE2, 0xAE } "箘"
  0x7B9F,  // { 0xE2, 0xAF } "箟"
  0x7B8D,  // { 0xE2, 0xB0 } "箍"
  0x7B9C,  // { 0xE2, 0xB1 } "箜"
  0x7B9A,  // { 0xE2, 0xB2 } "箚"
  0x7B8B,  // { 0xE2, 0xB3 } "箋"
  0x7B92,  // { 0xE2, 0xB4 } "箒"
  0x7B8F,  // { 0xE2, 0xB5 } "箏"
  0x7B5D,  // { 0xE2, 0xB6 } "筝"
  0x7B99,  // { 0xE2, 0xB7 } "箙"
  0x7BCB,  // { 0xE2, 0xB8 } "篋"
  0x7BC1,  // { 0xE2, 0xB9 } "篁"
  0x7BCC,  // { 0xE2, 0xBA } "篌"
  0x7BCF,  // { 0xE2, 0xBB } "篏"
  0x7BB4,  // { 0xE2, 0xBC } "箴"
  0x7BC6,  // { 0xE2, 0xBD } "篆"
  0x7BDD,  // { 0xE2, 0xBE } "篝"
  0x7BE9,  // { 0xE2, 0xBF } "篩"
  0x7C11,  // { 0xE2, 0xC0 } "簑"
  0x7C14,  // { 0xE2, 0xC1 } "簔"
  0x7BE6,  // { 0xE2, 0xC2 } "篦"
  0x7BE5,  // { 0xE2, 0xC3 } "篥"
  0x7C60,  // { 0xE2, 0xC4 } "籠"
  0x7C00,  // { 0xE2, 0xC5 } "簀"
  0x7C07,  // { 0xE2, 0xC6 } "簇"
  0x7C13,  // { 0xE2, 0xC7 } "簓"
  0x7BF3,  // { 0xE2, 0xC8 } "篳"
  0x7BF7,  // { 0xE2, 0xC9 } "篷"
  0x7C17,  // { 0xE2, 0xCA } "簗"
  0x7C0D,  // { 0xE2, 0xCB } "簍"
  0x7BF6,  // { 0xE2, 0xCC } "篶"
  0x7C23,  // { 0xE2, 0xCD } "簣"
  0x7C27,  // { 0xE2, 0xCE } "簧"
  0x7C2A,  // { 0xE2, 0xCF } "簪"
  0x7C1F,  // { 0xE2, 0xD0 } "簟"
  0x7C37,  // { 0xE2, 0xD1 } "簷"
  0x7C2B,  // { 0xE2, 0xD2 } "簫"
  0x7C3D,  // { 0xE2, 0xD3 } "簽"
  0x7C4C,  // { 0xE2, 0xD4 } "籌"
  0x7C43,  // { 0xE2, 0xD5 } "籃"
  0x7C54,  // { 0xE2, 0xD6 } "籔"
  0x7C4F,  // { 0xE2, 0xD7 } "籏"
  0x7C40,  // { 0xE2, 0xD8 } "籀"
  0x7C50,  // { 0xE2, 0xD9 } "籐"
  0x7C58,  // { 0xE2, 0xDA } "籘"
  0x7C5F,  // { 0xE2, 0xDB } "籟"
  0x7C64,  // { 0xE2, 0xDC } "籤"
  0x7C56,  // { 0xE2, 0xDD } "籖"
  0x7C65,  // { 0xE2, 0xDE } "籥"
  0x7C6C,  // { 0xE2, 0xDF } "籬"
  0x7C75,  // { 0xE2, 0xE0 } "籵"
  0x7C83,  // { 0xE2, 0xE1 } "粃"
  0x7C90,  // { 0xE2, 0xE2 } "粐"
  0x7CA4,  // { 0xE2, 0xE3 } "粤"
  0x7CAD,  // { 0xE2, 0xE4 } "粭"
  0x7CA2,  // { 0xE2, 0xE5 } "粢"
  0x7CAB,  // { 0xE2, 0xE6 } "粫"
  0x7CA1,  // { 0xE2, 0xE7 } "粡"
  0x7CA8,  // { 0xE2, 0xE8 } "粨"
  0x7CB3,  // { 0xE2, 0xE9 } "粳"
  0x7CB2,  // { 0xE2, 0xEA } "粲"
  0x7CB1,  // { 0xE2, 0xEB } "粱"
  0x7CAE,  // { 0xE2, 0xEC } "粮"
  0x7CB9,  // { 0xE2, 0xED } "粹"
  0x7CBD,  // { 0xE2, 0xEE } "粽"
  0x7CC0,  // { 0xE2, 0xEF } "糀"
  0x7CC5,  // { 0xE2, 0xF0 } "糅"
  0x7CC2,  // { 0xE2, 0xF1 } "糂"
  0x7CD8,  // { 0xE2, 0xF2 } "糘"
  0x7CD2,  // { 0xE2, 0xF3 } "糒"
  0x7CDC,  // { 0xE2, 0xF4 } "糜"
  0x7CE2,  // { 0xE2, 0xF5 } "糢"
  0x9B3B,  // { 0xE2, 0xF6 } "鬻"
  0x7CEF,  // { 0xE2, 0xF7 } "糯"
  0x7CF2,  // { 0xE2, 0xF8 } "糲"
  0x7CF4,  // { 0xE2, 0xF9 } "糴"
  0x7CF6,  // { 0xE2, 0xFA } "糶"
  0x7CFA,  // { 0xE2, 0xFB } "糺"
  0x7D06,  // { 0xE2, 0xFC } "紆"
  0x0000,  // { 0xE2, 0xFD }
  0x0000,  // { 0xE2, 0xFE }
  0x0000,  // { 0xE2, 0xFF }
  0x7D02,  // { 0xE3, 0x40 } "紂"
  0x7D1C,  // { 0xE3, 0x41 } "紜"
  0x7D15,  // { 0xE3, 0x42 } "紕"
  0x7D0A,  // { 0xE3, 0x43 } "紊"
  0x7D45,  // { 0xE3, 0x44 } "絅"
  0x7D4B,  // { 0xE3, 0x45 } "絋"
  0x7D2E,  // { 0xE3, 0x46 } "紮"
  0x7D32,  // { 0xE3, 0x47 } "紲"
  0x7D3F,  // { 0xE3, 0x48 } "紿"
  0x7D35,  // { 0xE3, 0x49 } "紵"
  0x7D46,  // { 0xE3, 0x4A } "絆"
  0x7D73,  // { 0xE3, 0x4B } "絳"
  0x7D56,  // { 0xE3, 0x4C } "絖"
  0x7D4E,  // { 0xE3, 0x4D } "絎"
  0x7D72,  // { 0xE3, 0x4E } "絲"
  0x7D68,  // { 0xE3, 0x4F } "絨"
  0x7D6E,  // { 0xE3, 0x50 } "絮"
  0x7D4F,  // { 0xE3, 0x51 } "絏"
  0x7D63,  // { 0xE3, 0x52 } "絣"
  0x7D93,  // { 0xE3, 0x53 } "經"
  0x7D89,  // { 0xE3, 0x54 } "綉"
  0x7D5B,  // { 0xE3, 0x55 } "絛"
  0x7D8F,  // { 0xE3, 0x56 } "綏"
  0x7D7D,  // { 0xE3, 0x57 } "絽"
  0x7D9B,  // { 0xE3, 0x58 } "綛"
  0x7DBA,  // { 0xE3, 0x59 } "綺"
  0x7DAE,  // { 0xE3, 0x5A } "綮"
  0x7DA3,  // { 0xE3, 0x5B } "綣"
  0x7DB5,  // { 0xE3, 0x5C } "綵"
  0x7DC7,  // { 0xE3, 0x5D } "緇"
  0x7DBD,  // { 0xE3, 0x5E } "綽"
  0x7DAB,  // { 0xE3, 0x5F } "綫"
  0x7E3D,  // { 0xE3, 0x60 } "總"
  0x7DA2,  // { 0xE3, 0x61 } "綢"
  0x7DAF,  // { 0xE3, 0x62 } "綯"
  0x7DDC,  // { 0xE3, 0x63 } "緜"
  0x7DB8,  // { 0xE3, 0x64 } "綸"
  0x7D9F,  // { 0xE3, 0x65 } "綟"
  0x7DB0,  // { 0xE3, 0x66 } "綰"
  0x7DD8,  // { 0xE3, 0x67 } "緘"
  0x7DDD,  // { 0xE3, 0x68 } "緝"
  0x7DE4,  // { 0xE3, 0x69 } "緤"
  0x7DDE,  // { 0xE3, 0x6A } "緞"
  0x7DFB,  // { 0xE3, 0x6B } "緻"
  0x7DF2,  // { 0xE3, 0x6C } "緲"
  0x7DE1,  // { 0xE3, 0x6D } "緡"
  0x7E05,  // { 0xE3, 0x6E } "縅"
  0x7E0A,  // { 0xE3, 0x6F } "縊"
  0x7E23,  // { 0xE3, 0x70 } "縣"
  0x7E21,  // { 0xE3, 0x71 } "縡"
  0x7E12,  // { 0xE3, 0x72 } "縒"
  0x7E31,  // { 0xE3, 0x73 } "縱"
  0x7E1F,  // { 0xE3, 0x74 } "縟"
  0x7E09,  // { 0xE3, 0x75 } "縉"
  0x7E0B,  // { 0xE3, 0x76 } "縋"
  0x7E22,  // { 0xE3, 0x77 } "縢"
  0x7E46,  // { 0xE3, 0x78 } "繆"
  0x7E66,  // { 0xE3, 0x79 } "繦"
  0x7E3B,  // { 0xE3, 0x7A } "縻"
  0x7E35,  // { 0xE3, 0x7B } "縵"
  0x7E39,  // { 0xE3, 0x7C } "縹"
  0x7E43,  // { 0xE3, 0x7D } "繃"
  0x7E37,  // { 0xE3, 0x7E } "縷"
  0x7E32,  // { 0xE3, 0x80 } "縲"
  0x7E3A,  // { 0xE3, 0x81 } "縺"
  0x7E67,  // { 0xE3, 0x82 } "繧"
  0x7E5D,  // { 0xE3, 0x83 } "繝"
  0x7E56,  // { 0xE3, 0x84 } "繖"
  0x7E5E,  // { 0xE3, 0x85 } "繞"
  0x7E59,  // { 0xE3, 0x86 } "繙"
  0x7E5A,  // { 0xE3, 0x87 } "繚"
  0x7E79,  // { 0xE3, 0x88 } "繹"
  0x7E6A,  // { 0xE3, 0x89 } "繪"
  0x7E69,  // { 0xE3, 0x8A } "繩"
  0x7E7C,  // { 0xE3, 0x8B } "繼"
  0x7E7B,  // { 0xE3, 0x8C } "繻"
  0x7E83,  // { 0xE3, 0x8D } "纃"
  0x7DD5,  // { 0xE3, 0x8E } "緕"
  0x7E7D,  // { 0xE3, 0x8F } "繽"
  0x8FAE,  // { 0xE3, 0x90 } "辮"
  0x7E7F,  // { 0xE3, 0x91 } "繿"
  0x7E88,  // { 0xE3, 0x92 } "纈"
  0x7E89,  // { 0xE3, 0x93 } "纉"
  0x7E8C,  // { 0xE3, 0x94 } "續"
  0x7E92,  // { 0xE3, 0x95 } "纒"
  0x7E90,  // { 0xE3, 0x96 } "纐"
  0x7E93,  // { 0xE3, 0x97 } "纓"
  0x7E94,  // { 0xE3, 0x98 } "纔"
  0x7E96,  // { 0xE3, 0x99 } "纖"
  0x7E8E,  // { 0xE3, 0x9A } "纎"
  0x7E9B,  // { 0xE3, 0x9B } "纛"
  0x7E9C,  // { 0xE3, 0x9C } "纜"
  0x7F38,  // { 0xE3, 0x9D } "缸"
  0x7F3A,  // { 0xE3, 0x9E } "缺"
  0x7F45,  // { 0xE3, 0x9F } "罅"
  0x7F4C,  // { 0xE3, 0xA0 } "罌"
  0x7F4D,  // { 0xE3, 0xA1 } "罍"
  0x7F4E,  // { 0xE3, 0xA2 } "罎"
  0x7F50,  // { 0xE3, 0xA3 } "罐"
  0x7F51,  // { 0xE3, 0xA4 } "网"
  0x7F55,  // { 0xE3, 0xA5 } "罕"
  0x7F54,  // { 0xE3, 0xA6 } "罔"
  0x7F58,  // { 0xE3, 0xA7 } "罘"
  0x7F5F,  // { 0xE3, 0xA8 } "罟"
  0x7F60,  // { 0xE3, 0xA9 } "罠"
  0x7F68,  // { 0xE3, 0xAA } "罨"
  0x7F69,  // { 0xE3, 0xAB } "罩"
  0x7F67,  // { 0xE3, 0xAC } "罧"
  0x7F78,  // { 0xE3, 0xAD } "罸"
  0x7F82,  // { 0xE3, 0xAE } "羂"
  0x7F86,  // { 0xE3, 0xAF } "羆"
  0x7F83,  // { 0xE3, 0xB0 } "羃"
  0x7F88,  // { 0xE3, 0xB1 } "羈"
  0x7F87,  // { 0xE3, 0xB2 } "羇"
  0x7F8C,  // { 0xE3, 0xB3 } "羌"
  0x7F94,  // { 0xE3, 0xB4 } "羔"
  0x7F9E,  // { 0xE3, 0xB5 } "羞"
  0x7F9D,  // { 0xE3, 0xB6 } "羝"
  0x7F9A,  // { 0xE3, 0xB7 } "羚"
  0x7FA3,  // { 0xE3, 0xB8 } "羣"
  0x7FAF,  // { 0xE3, 0xB9 } "羯"
  0x7FB2,  // { 0xE3, 0xBA } "羲"
  0x7FB9,  // { 0xE3, 0xBB } "羹"
  0x7FAE,  // { 0xE3, 0xBC } "羮"
  0x7FB6,  // { 0xE3, 0xBD } "羶"
  0x7FB8,  // { 0xE3, 0xBE } "羸"
  0x8B71,  // { 0xE3, 0xBF } "譱"
  0x7FC5,  // { 0xE3, 0xC0 } "翅"
  0x7FC6,  // { 0xE3, 0xC1 } "翆"
  0x7FCA,  // { 0xE3, 0xC2 } "翊"
  0x7FD5,  // { 0xE3, 0xC3 } "翕"
  0x7FD4,  // { 0xE3, 0xC4 } "翔"
  0x7FE1,  // { 0xE3, 0xC5 } "翡"
  0x7FE6,  // { 0xE3, 0xC6 } "翦"
  0x7FE9,  // { 0xE3, 0xC7 } "翩"
  0x7FF3,  // { 0xE3, 0xC8 } "翳"
  0x7FF9,  // { 0xE3, 0xC9 } "翹"
  0x98DC,  // { 0xE3, 0xCA } "飜"
  0x8006,  // { 0xE3, 0xCB } "耆"
  0x8004,  // { 0xE3, 0xCC } "耄"
  0x800B,  // { 0xE3, 0xCD } "耋"
  0x8012,  // { 0xE3, 0xCE } "耒"
  0x8018,  // { 0xE3, 0xCF } "耘"
  0x8019,  // { 0xE3, 0xD0 } "耙"
  0x801C,  // { 0xE3, 0xD1 } "耜"
  0x8021,  // { 0xE3, 0xD2 } "耡"
  0x8028,  // { 0xE3, 0xD3 } "耨"
  0x803F,  // { 0xE3, 0xD4 } "耿"
  0x803B,  // { 0xE3, 0xD5 } "耻"
  0x804A,  // { 0xE3, 0xD6 } "聊"
  0x8046,  // { 0xE3, 0xD7 } "聆"
  0x8052,  // { 0xE3, 0xD8 } "聒"
  0x8058,  // { 0xE3, 0xD9 } "聘"
  0x805A,  // { 0xE3, 0xDA } "聚"
  0x805F,  // { 0xE3, 0xDB } "聟"
  0x8062,  // { 0xE3, 0xDC } "聢"
  0x8068,  // { 0xE3, 0xDD } "聨"
  0x8073,  // { 0xE3, 0xDE } "聳"
  0x8072,  // { 0xE3, 0xDF } "聲"
  0x8070,  // { 0xE3, 0xE0 } "聰"
  0x8076,  // { 0xE3, 0xE1 } "聶"
  0x8079,  // { 0xE3, 0xE2 } "聹"
  0x807D,  // { 0xE3, 0xE3 } "聽"
  0x807F,  // { 0xE3, 0xE4 } "聿"
  0x8084,  // { 0xE3, 0xE5 } "肄"
  0x8086,  // { 0xE3, 0xE6 } "肆"
  0x8085,  // { 0xE3, 0xE7 } "肅"
  0x809B,  // { 0xE3, 0xE8 } "肛"
  0x8093,  // { 0xE3, 0xE9 } "肓"
  0x809A,  // { 0xE3, 0xEA } "肚"
  0x80AD,  // { 0xE3, 0xEB } "肭"
  0x5190,  // { 0xE3, 0xEC } "冐"
  0x80AC,  // { 0xE3, 0xED } "肬"
  0x80DB,  // { 0xE3, 0xEE } "胛"
  0x80E5,  // { 0xE3, 0xEF } "胥"
  0x80D9,  // { 0xE3, 0xF0 } "胙"
  0x80DD,  // { 0xE3, 0xF1 } "胝"
  0x80C4,  // { 0xE3, 0xF2 } "胄"
  0x80DA,  // { 0xE3, 0xF3 } "胚"
  0x80D6,  // { 0xE3, 0xF4 } "胖"
  0x8109,  // { 0xE3, 0xF5 } "脉"
  0x80EF,  // { 0xE3, 0xF6 } "胯"
  0x80F1,  // { 0xE3, 0xF7 } "胱"
  0x811B,  // { 0xE3, 0xF8 } "脛"
  0x8129,  // { 0xE3, 0xF9 } "脩"
  0x8123,  // { 0xE3, 0xFA } "脣"
  0x812F,  // { 0xE3, 0xFB } "脯"
  0x814B,  // { 0xE3, 0xFC } "腋"
  0x0000,  // { 0xE3, 0xFD }
  0x0000,  // { 0xE3, 0xFE }
  0x0000,  // { 0xE3, 0xFF }
  0x968B,  // { 0xE4, 0x40 } "隋"
  0x8146,  // { 0xE4, 0x41 } "腆"
  0x813E,  // { 0xE4, 0x42 } "脾"
  0x8153,  // { 0xE4, 0x43 } "腓"
  0x8151,  // { 0xE4, 0x44 } "腑"
  0x80FC,  // { 0xE4, 0x45 } "胼"
  0x8171,  // { 0xE4, 0x46 } "腱"
  0x816E,  // { 0xE4, 0x47 } "腮"
  0x8165,  // { 0xE4, 0x48 } "腥"
  0x8166,  // { 0xE4, 0x49 } "腦"
  0x8174,  // { 0xE4, 0x4A } "腴"
  0x8183,  // { 0xE4, 0x4B } "膃"
  0x8188,  // { 0xE4, 0x4C } "膈"
  0x818A,  // { 0xE4, 0x4D } "膊"
  0x8180,  // { 0xE4, 0x4E } "膀"
  0x8182,  // { 0xE4, 0x4F } "膂"
  0x81A0,  // { 0xE4, 0x50 } "膠"
  0x8195,  // { 0xE4, 0x51 } "膕"
  0x81A4,  // { 0xE4, 0x52 } "膤"
  0x81A3,  // { 0xE4, 0x53 } "膣"
  0x815F,  // { 0xE4, 0x54 } "腟"
  0x8193,  // { 0xE4, 0x55 } "膓"
  0x81A9,  // { 0xE4, 0x56 } "膩"
  0x81B0,  // { 0xE4, 0x57 } "膰"
  0x81B5,  // { 0xE4, 0x58 } "膵"
  0x81BE,  // { 0xE4, 0x59 } "膾"
  0x81B8,  // { 0xE4, 0x5A } "膸"
  0x81BD,  // { 0xE4, 0x5B } "膽"
  0x81C0,  // { 0xE4, 0x5C } "臀"
  0x81C2,  // { 0xE4, 0x5D } "臂"
  0x81BA,  // { 0xE4, 0x5E } "膺"
  0x81C9,  // { 0xE4, 0x5F } "臉"
  0x81CD,  // { 0xE4, 0x60 } "臍"
  0x81D1,  // { 0xE4, 0x61 } "臑"
  0x81D9,  // { 0xE4, 0x62 } "臙"
  0x81D8,  // { 0xE4, 0x63 } "臘"
  0x81C8,  // { 0xE4, 0x64 } "臈"
  0x81DA,  // { 0xE4, 0x65 } "臚"
  0x81DF,  // { 0xE4, 0x66 } "臟"
  0x81E0,  // { 0xE4, 0x67 } "臠"
  0x81E7,  // { 0xE4, 0x68 } "臧"
  0x81FA,  // { 0xE4, 0x69 } "臺"
  0x81FB,  // { 0xE4, 0x6A } "臻"
  0x81FE,  // { 0xE4, 0x6B } "臾"
  0x8201,  // { 0xE4, 0x6C } "舁"
  0x8202,  // { 0xE4, 0x6D } "舂"
  0x8205,  // { 0xE4, 0x6E } "舅"
  0x8207,  // { 0xE4, 0x6F } "與"
  0x820A,  // { 0xE4, 0x70 } "舊"
  0x820D,  // { 0xE4, 0x71 } "舍"
  0x8210,  // { 0xE4, 0x72 } "舐"
  0x8216,  // { 0xE4, 0x73 } "舖"
  0x8229,  // { 0xE4, 0x74 } "舩"
  0x822B,  // { 0xE4, 0x75 } "舫"
  0x8238,  // { 0xE4, 0x76 } "舸"
  0x8233,  // { 0xE4, 0x77 } "舳"
  0x8240,  // { 0xE4, 0x78 } "艀"
  0x8259,  // { 0xE4, 0x79 } "艙"
  0x8258,  // { 0xE4, 0x7A } "艘"
  0x825D,  // { 0xE4, 0x7B } "艝"
  0x825A,  // { 0xE4, 0x7C } "艚"
  0x825F,  // { 0xE4, 0x7D } "艟"
  0x8264,  // { 0xE4, 0x7E } "艤"
  0x8262,  // { 0xE4, 0x80 } "艢"
  0x8268,  // { 0xE4, 0x81 } "艨"
  0x826A,  // { 0xE4, 0x82 } "艪"
  0x826B,  // { 0xE4, 0x83 } "艫"
  0x822E,  // { 0xE4, 0x84 } "舮"
  0x8271,  // { 0xE4, 0x85 } "艱"
  0x8277,  // { 0xE4, 0x86 } "艷"
  0x8278,  // { 0xE4, 0x87 } "艸"
  0x827E,  // { 0xE4, 0x88 } "艾"
  0x828D,  // { 0xE4, 0x89 } "芍"
  0x8292,  // { 0xE4, 0x8A } "芒"
  0x82AB,  // { 0xE4, 0x8B } "芫"
  0x829F,  // { 0xE4, 0x8C } "芟"
  0x82BB,  // { 0xE4, 0x8D } "芻"
  0x82AC,  // { 0xE4, 0x8E } "芬"
  0x82E1,  // { 0xE4, 0x8F } "苡"
  0x82E3,  // { 0xE4, 0x90 } "苣"
  0x82DF,  // { 0xE4, 0x91 } "苟"
  0x82D2,  // { 0xE4, 0x92 } "苒"
  0x82F4,  // { 0xE4, 0x93 } "苴"
  0x82F3,  // { 0xE4, 0x94 } "苳"
  0x82FA,  // { 0xE4, 0x95 } "苺"
  0x8393,  // { 0xE4, 0x96 } "莓"
  0x8303,  // { 0xE4, 0x97 } "范"
  0x82FB,  // { 0xE4, 0x98 } "苻"
  0x82F9,  // { 0xE4, 0x99 } "苹"
  0x82DE,  // { 0xE4, 0x9A } "苞"
  0x8306,  // { 0xE4, 0x9B } "茆"
  0x82DC,  // { 0xE4, 0x9C } "苜"
  0x8309,  // { 0xE4, 0x9D } "茉"
  0x82D9,  // { 0xE4, 0x9E } "苙"
  0x8335,  // { 0xE4, 0x9F } "茵"
  0x8334,  // { 0xE4, 0xA0 } "茴"
  0x8316,  // { 0xE4, 0xA1 } "茖"
  0x8332,  // { 0xE4, 0xA2 } "茲"
  0x8331,  // { 0xE4, 0xA3 } "茱"
  0x8340,  // { 0xE4, 0xA4 } "荀"
  0x8339,  // { 0xE4, 0xA5 } "茹"
  0x8350,  // { 0xE4, 0xA6 } "荐"
  0x8345,  // { 0xE4, 0xA7 } "荅"
  0x832F,  // { 0xE4, 0xA8 } "茯"
  0x832B,  // { 0xE4, 0xA9 } "茫"
  0x8317,  // { 0xE4, 0xAA } "茗"
  0x8318,  // { 0xE4, 0xAB } "茘"
  0x8385,  // { 0xE4, 0xAC } "莅"
  0x839A,  // { 0xE4, 0xAD } "莚"
  0x83AA,  // { 0xE4, 0xAE } "莪"
  0x839F,  // { 0xE4, 0xAF } "莟"
  0x83A2,  // { 0xE4, 0xB0 } "莢"
  0x8396,  // { 0xE4, 0xB1 } "莖"
  0x8323,  // { 0xE4, 0xB2 } "茣"
  0x838E,  // { 0xE4, 0xB3 } "莎"
  0x8387,  // { 0xE4, 0xB4 } "莇"
  0x838A,  // { 0xE4, 0xB5 } "莊"
  0x837C,  // { 0xE4, 0xB6 } "荼"
  0x83B5,  // { 0xE4, 0xB7 } "莵"
  0x8373,  // { 0xE4, 0xB8 } "荳"
  0x8375,  // { 0xE4, 0xB9 } "荵"
  0x83A0,  // { 0xE4, 0xBA } "莠"
  0x8389,  // { 0xE4, 0xBB } "莉"
  0x83A8,  // { 0xE4, 0xBC } "莨"
  0x83F4,  // { 0xE4, 0xBD } "菴"
  0x8413,  // { 0xE4, 0xBE } "萓"
  0x83EB,  // { 0xE4, 0xBF } "菫"
  0x83CE,  // { 0xE4, 0xC0 } "菎"
  0x83FD,  // { 0xE4, 0xC1 } "菽"
  0x8403,  // { 0xE4, 0xC2 } "萃"
  0x83D8,  // { 0xE4, 0xC3 } "菘"
  0x840B,  // { 0xE4, 0xC4 } "萋"
  0x83C1,  // { 0xE4, 0xC5 } "菁"
  0x83F7,  // { 0xE4, 0xC6 } "菷"
  0x8407,  // { 0xE4, 0xC7 } "萇"
  0x83E0,  // { 0xE4, 0xC8 } "菠"
  0x83F2,  // { 0xE4, 0xC9 } "菲"
  0x840D,  // { 0xE4, 0xCA } "萍"
  0x8422,  // { 0xE4, 0xCB } "萢"
  0x8420,  // { 0xE4, 0xCC } "萠"
  0x83BD,  // { 0xE4, 0xCD } "莽"
  0x8438,  // { 0xE4, 0xCE } "萸"
  0x8506,  // { 0xE4, 0xCF } "蔆"
  0x83FB,  // { 0xE4, 0xD0 } "菻"
  0x846D,  // { 0xE4, 0xD1 } "葭"
  0x842A,  // { 0xE4, 0xD2 } "萪"
  0x843C,  // { 0xE4, 0xD3 } "萼"
  0x855A,  // { 0xE4, 0xD4 } "蕚"
  0x8484,  // { 0xE4, 0xD5 } "蒄"
  0x8477,  // { 0xE4, 0xD6 } "葷"
  0x846B,  // { 0xE4, 0xD7 } "葫"
  0x84AD,  // { 0xE4, 0xD8 } "蒭"
  0x846E,  // { 0xE4, 0xD9 } "葮"
  0x8482,  // { 0xE4, 0xDA } "蒂"
  0x8469,  // { 0xE4, 0xDB } "葩"
  0x8446,  // { 0xE4, 0xDC } "葆"
  0x842C,  // { 0xE4, 0xDD } "萬"
  0x846F,  // { 0xE4, 0xDE } "葯"
  0x8479,  // { 0xE4, 0xDF } "葹"
  0x8435,  // { 0xE4, 0xE0 } "萵"
  0x84CA,  // { 0xE4, 0xE1 } "蓊"
  0x8462,  // { 0xE4, 0xE2 } "葢"
  0x84B9,  // { 0xE4, 0xE3 } "蒹"
  0x84BF,  // { 0xE4, 0xE4 } "蒿"
  0x849F,  // { 0xE4, 0xE5 } "蒟"
  0x84D9,  // { 0xE4, 0xE6 } "蓙"
  0x84CD,  // { 0xE4, 0xE7 } "蓍"
  0x84BB,  // { 0xE4, 0xE8 } "蒻"
  0x84DA,  // { 0xE4, 0xE9 } "蓚"
  0x84D0,  // { 0xE4, 0xEA } "蓐"
  0x84C1,  // { 0xE4, 0xEB } "蓁"
  0x84C6,  // { 0xE4, 0xEC } "蓆"
  0x84D6,  // { 0xE4, 0xED } "蓖"
  0x84A1,  // { 0xE4, 0xEE } "蒡"
  0x8521,  // { 0xE4, 0xEF } "蔡"
  0x84FF,  // { 0xE4, 0xF0 } "蓿"
  0x84F4,  // { 0xE4, 0xF1 } "蓴"
  0x8517,  // { 0xE4, 0xF2 } "蔗"
  0x8518,  // { 0xE4, 0xF3 } "蔘"
  0x852C,  // { 0xE4, 0xF4 } "蔬"
  0x851F,  // { 0xE4, 0xF5 } "蔟"
  0x8515,  // { 0xE4, 0xF6 } "蔕"
  0x8514,  // { 0xE4, 0xF7 } "蔔"
  0x84FC,  // { 0xE4, 0xF8 } "蓼"
  0x8540,  // { 0xE4, 0xF9 } "蕀"
  0x8563,  // { 0xE4, 0xFA } "蕣"
  0x8558,  // { 0xE4, 0xFB } "蕘"
  0x8548,  // { 0xE4, 0xFC } "蕈"
  0x0000,  // { 0xE4, 0xFD }
  0x0000,  // { 0xE4, 0xFE }
  0x0000,  // { 0xE4, 0xFF }
  0x8541,  // { 0xE5, 0x40 } "蕁"
  0x8602,  // { 0xE5, 0x41 } "蘂"
  0x854B,  // { 0xE5, 0x42 } "蕋"
  0x8555,  // { 0xE5, 0x43 } "蕕"
  0x8580,  // { 0xE5, 0x44 } "薀"
  0x85A4,  // { 0xE5, 0x45 } "薤"
  0x8588,  // { 0xE5, 0x46 } "薈"
  0x8591,  // { 0xE5, 0x47 } "薑"
  0x858A,  // { 0xE5, 0x48 } "薊"
  0x85A8,  // { 0xE5, 0x49 } "薨"
  0x856D,  // { 0xE5, 0x4A } "蕭"
  0x8594,  // { 0xE5, 0x4B } "薔"
  0x859B,  // { 0xE5, 0x4C } "薛"
  0x85EA,  // { 0xE5, 0x4D } "藪"
  0x8587,  // { 0xE5, 0x4E } "薇"
  0x859C,  // { 0xE5, 0x4F } "薜"
  0x8577,  // { 0xE5, 0x50 } "蕷"
  0x857E,  // { 0xE5, 0x51 } "蕾"
  0x8590,  // { 0xE5, 0x52 } "薐"
  0x85C9,  // { 0xE5, 0x53 } "藉"
  0x85BA,  // { 0xE5, 0x54 } "薺"
  0x85CF,  // { 0xE5, 0x55 } "藏"
  0x85B9,  // { 0xE5, 0x56 } "薹"
  0x85D0,  // { 0xE5, 0x57 } "藐"
  0x85D5,  // { 0xE5, 0x58 } "藕"
  0x85DD,  // { 0xE5, 0x59 } "藝"
  0x85E5,  // { 0xE5, 0x5A } "藥"
  0x85DC,  // { 0xE5, 0x5B } "藜"
  0x85F9,  // { 0xE5, 0x5C } "藹"
  0x860A,  // { 0xE5, 0x5D } "蘊"
  0x8613,  // { 0xE5, 0x5E } "蘓"
  0x860B,  // { 0xE5, 0x5F } "蘋"
  0x85FE,  // { 0xE5, 0x60 } "藾"
  0x85FA,  // { 0xE5, 0x61 } "藺"
  0x8606,  // { 0xE5, 0x62 } "蘆"
  0x8622,  // { 0xE5, 0x63 } "蘢"
  0x861A,  // { 0xE5, 0x64 } "蘚"
  0x8630,  // { 0xE5, 0x65 } "蘰"
  0x863F,  // { 0xE5, 0x66 } "蘿"
  0x864D,  // { 0xE5, 0x67 } "虍"
  0x4E55,  // { 0xE5, 0x68 } "乕"
  0x8654,  // { 0xE5, 0x69 } "虔"
  0x865F,  // { 0xE5, 0x6A } "號"
  0x8667,  // { 0xE5, 0x6B } "虧"
  0x8671,  // { 0xE5, 0x6C } "虱"
  0x8693,  // { 0xE5, 0x6D } "蚓"
  0x86A3,  // { 0xE5, 0x6E } "蚣"
  0x86A9,  // { 0xE5, 0x6F } "蚩"
  0x86AA,  // { 0xE5, 0x70 } "蚪"
  0x868B,  // { 0xE5, 0x71 } "蚋"
  0x868C,  // { 0xE5, 0x72 } "蚌"
  0x86B6,  // { 0xE5, 0x73 } "蚶"
  0x86AF,  // { 0xE5, 0x74 } "蚯"
  0x86C4,  // { 0xE5, 0x75 } "蛄"
  0x86C6,  // { 0xE5, 0x76 } "蛆"
  0x86B0,  // { 0xE5, 0x77 } "蚰"
  0x86C9,  // { 0xE5, 0x78 } "蛉"
  0x8823,  // { 0xE5, 0x79 } "蠣"
  0x86AB,  // { 0xE5, 0x7A } "蚫"
  0x86D4,  // { 0xE5, 0x7B } "蛔"
  0x86DE,  // { 0xE5, 0x7C } "蛞"
  0x86E9,  // { 0xE5, 0x7D } "蛩"
  0x86EC,  // { 0xE5, 0x7E } "蛬"
  0x86DF,  // { 0xE5, 0x80 } "蛟"
  0x86DB,  // { 0xE5, 0x81 } "蛛"
  0x86EF,  // { 0xE5, 0x82 } "蛯"
  0x8712,  // { 0xE5, 0x83 } "蜒"
  0x8706,  // { 0xE5, 0x84 } "蜆"
  0x8708,  // { 0xE5, 0x85 } "蜈"
  0x8700,  // { 0xE5, 0x86 } "蜀"
  0x8703,  // { 0xE5, 0x87 } "蜃"
  0x86FB,  // { 0xE5, 0x88 } "蛻"
  0x8711,  // { 0xE5, 0x89 } "蜑"
  0x8709,  // { 0xE5, 0x8A } "蜉"
  0x870D,  // { 0xE5, 0x8B } "蜍"
  0x86F9,  // { 0xE5, 0x8C } "蛹"
  0x870A,  // { 0xE5, 0x8D } "蜊"
  0x8734,  // { 0xE5, 0x8E } "蜴"
  0x873F,  // { 0xE5, 0x8F } "蜿"
  0x8737,  // { 0xE5, 0x90 } "蜷"
  0x873B,  // { 0xE5, 0x91 } "蜻"
  0x8725,  // { 0xE5, 0x92 } "蜥"
  0x8729,  // { 0xE5, 0x93 } "蜩"
  0x871A,  // { 0xE5, 0x94 } "蜚"
  0x8760,  // { 0xE5, 0x95 } "蝠"
  0x875F,  // { 0xE5, 0x96 } "蝟"
  0x8778,  // { 0xE5, 0x97 } "蝸"
  0x874C,  // { 0xE5, 0x98 } "蝌"
  0x874E,  // { 0xE5, 0x99 } "蝎"
  0x8774,  // { 0xE5, 0x9A } "蝴"
  0x8757,  // { 0xE5, 0x9B } "蝗"
  0x8768,  // { 0xE5, 0x9C } "蝨"
  0x876E,  // { 0xE5, 0x9D } "蝮"
  0x8759,  // { 0xE5, 0x9E } "蝙"
  0x8753,  // { 0xE5, 0x9F } "蝓"
  0x8763,  // { 0xE5, 0xA0 } "蝣"
  0x876A,  // { 0xE5, 0xA1 } "蝪"
  0x8805,  // { 0xE5, 0xA2 } "蠅"
  0x87A2,  // { 0xE5, 0xA3 } "螢"
  0x879F,  // { 0xE5, 0xA4 } "螟"
  0x8782,  // { 0xE5, 0xA5 } "螂"
  0x87AF,  // { 0xE5, 0xA6 } "螯"
  0x87CB,  // { 0xE5, 0xA7 } "蟋"
  0x87BD,  // { 0xE5, 0xA8 } "螽"
  0x87C0,  // { 0xE5, 0xA9 } "蟀"
  0x87D0,  // { 0xE5, 0xAA } "蟐"
  0x96D6,  // { 0xE5, 0xAB } "雖"
  0x87AB,  // { 0xE5, 0xAC } "螫"
  0x87C4,  // { 0xE5, 0xAD } "蟄"
  0x87B3,  // { 0xE5, 0xAE } "螳"
  0x87C7,  // { 0xE5, 0xAF } "蟇"
  0x87C6,  // { 0xE5, 0xB0 } "蟆"
  0x87BB,  // { 0xE5, 0xB1 } "螻"
  0x87EF,  // { 0xE5, 0xB2 } "蟯"
  0x87F2,  // { 0xE5, 0xB3 } "蟲"
  0x87E0,  // { 0xE5, 0xB4 } "蟠"
  0x880F,  // { 0xE5, 0xB5 } "蠏"
  0x880D,  // { 0xE5, 0xB6 } "蠍"
  0x87FE,  // { 0xE5, 0xB7 } "蟾"
  0x87F6,  // { 0xE5, 0xB8 } "蟶"
  0x87F7,  // { 0xE5, 0xB9 } "蟷"
  0x880E,  // { 0xE5, 0xBA } "蠎"
  0x87D2,  // { 0xE5, 0xBB } "蟒"
  0x8811,  // { 0xE5, 0xBC } "蠑"
  0x8816,  // { 0xE5, 0xBD } "蠖"
  0x8815,  // { 0xE5, 0xBE } "蠕"
  0x8822,  // { 0xE5, 0xBF } "蠢"
  0x8821,  // { 0xE5, 0xC0 } "蠡"
  0x8831,  // { 0xE5, 0xC1 } "蠱"
  0x8836,  // { 0xE5, 0xC2 } "蠶"
  0x8839,  // { 0xE5, 0xC3 } "蠹"
  0x8827,  // { 0xE5, 0xC4 } "蠧"
  0x883B,  // { 0xE5, 0xC5 } "蠻"
  0x8844,  // { 0xE5, 0xC6 } "衄"
  0x8842,  // { 0xE5, 0xC7 } "衂"
  0x8852,  // { 0xE5, 0xC8 } "衒"
  0x8859,  // { 0xE5, 0xC9 } "衙"
  0x885E,  // { 0xE5, 0xCA } "衞"
  0x8862,  // { 0xE5, 0xCB } "衢"
  0x886B,  // { 0xE5, 0xCC } "衫"
  0x8881,  // { 0xE5, 0xCD } "袁"
  0x887E,  // { 0xE5, 0xCE } "衾"
  0x889E,  // { 0xE5, 0xCF } "袞"
  0x8875,  // { 0xE5, 0xD0 } "衵"
  0x887D,  // { 0xE5, 0xD1 } "衽"
  0x88B5,  // { 0xE5, 0xD2 } "袵"
  0x8872,  // { 0xE5, 0xD3 } "衲"
  0x8882,  // { 0xE5, 0xD4 } "袂"
  0x8897,  // { 0xE5, 0xD5 } "袗"
  0x8892,  // { 0xE5, 0xD6 } "袒"
  0x88AE,  // { 0xE5, 0xD7 } "袮"
  0x8899,  // { 0xE5, 0xD8 } "袙"
  0x88A2,  // { 0xE5, 0xD9 } "袢"
  0x888D,  // { 0xE5, 0xDA } "袍"
  0x88A4,  // { 0xE5, 0xDB } "袤"
  0x88B0,  // { 0xE5, 0xDC } "袰"
  0x88BF,  // { 0xE5, 0xDD } "袿"
  0x88B1,  // { 0xE5, 0xDE } "袱"
  0x88C3,  // { 0xE5, 0xDF } "裃"
  0x88C4,  // { 0xE5, 0xE0 } "裄"
  0x88D4,  // { 0xE5, 0xE1 } "裔"
  0x88D8,  // { 0xE5, 0xE2 } "裘"
  0x88D9,  // { 0xE5, 0xE3 } "裙"
  0x88DD,  // { 0xE5, 0xE4 } "裝"
  0x88F9,  // { 0xE5, 0xE5 } "裹"
  0x8902,  // { 0xE5, 0xE6 } "褂"
  0x88FC,  // { 0xE5, 0xE7 } "裼"
  0x88F4,  // { 0xE5, 0xE8 } "裴"
  0x88E8,  // { 0xE5, 0xE9 } "裨"
  0x88F2,  // { 0xE5, 0xEA } "裲"
  0x8904,  // { 0xE5, 0xEB } "褄"
  0x890C,  // { 0xE5, 0xEC } "褌"
  0x890A,  // { 0xE5, 0xED } "褊"
  0x8913,  // { 0xE5, 0xEE } "褓"
  0x8943,  // { 0xE5, 0xEF } "襃"
  0x891E,  // { 0xE5, 0xF0 } "褞"
  0x8925,  // { 0xE5, 0xF1 } "褥"
  0x892A,  // { 0xE5, 0xF2 } "褪"
  0x892B,  // { 0xE5, 0xF3 } "褫"
  0x8941,  // { 0xE5, 0xF4 } "襁"
  0x8944,  // { 0xE5, 0xF5 } "襄"
  0x893B,  // { 0xE5, 0xF6 } "褻"
  0x8936,  // { 0xE5, 0xF7 } "褶"
  0x8938,  // { 0xE5, 0xF8 } "褸"
  0x894C,  // { 0xE5, 0xF9 } "襌"
  0x891D,  // { 0xE5, 0xFA } "褝"
  0x8960,  // { 0xE5, 0xFB } "襠"
  0x895E,  // { 0xE5, 0xFC } "襞"
  0x0000,  // { 0xE5, 0xFD }
  0x0000,  // { 0xE5, 0xFE }
  0x0000,  // { 0xE5, 0xFF }
  0x8966,  // { 0xE6, 0x40 } "襦"
  0x8964,  // { 0xE6, 0x41 } "襤"
  0x896D,  // { 0xE6, 0x42 } "襭"
  0x896A,  // { 0xE6, 0x43 } "襪"
  0x896F,  // { 0xE6, 0x44 } "襯"
  0x8974,  // { 0xE6, 0x45 } "襴"
  0x8977,  // { 0xE6, 0x46 } "襷"
  0x897E,  // { 0xE6, 0x47 } "襾"
  0x8983,  // { 0xE6, 0x48 } "覃"
  0x8988,  // { 0xE6, 0x49 } "覈"
  0x898A,  // { 0xE6, 0x4A } "覊"
  0x8993,  // { 0xE6, 0x4B } "覓"
  0x8998,  // { 0xE6, 0x4C } "覘"
  0x89A1,  // { 0xE6, 0x4D } "覡"
  0x89A9,  // { 0xE6, 0x4E } "覩"
  0x89A6,  // { 0xE6, 0x4F } "覦"
  0x89AC,  // { 0xE6, 0x50 } "覬"
  0x89AF,  // { 0xE6, 0x51 } "覯"
  0x89B2,  // { 0xE6, 0x52 } "覲"
  0x89BA,  // { 0xE6, 0x53 } "覺"
  0x89BD,  // { 0xE6, 0x54 } "覽"
  0x89BF,  // { 0xE6, 0x55 } "覿"
  0x89C0,  // { 0xE6, 0x56 } "觀"
  0x89DA,  // { 0xE6, 0x57 } "觚"
  0x89DC,  // { 0xE6, 0x58 } "觜"
  0x89DD,  // { 0xE6, 0x59 } "觝"
  0x89E7,  // { 0xE6, 0x5A } "觧"
  0x89F4,  // { 0xE6, 0x5B } "觴"
  0x89F8,  // { 0xE6, 0x5C } "觸"
  0x8A03,  // { 0xE6, 0x5D } "訃"
  0x8A16,  // { 0xE6, 0x5E } "訖"
  0x8A10,  // { 0xE6, 0x5F } "訐"
  0x8A0C,  // { 0xE6, 0x60 } "訌"
  0x8A1B,  // { 0xE6, 0x61 } "訛"
  0x8A1D,  // { 0xE6, 0x62 } "訝"
  0x8A25,  // { 0xE6, 0x63 } "訥"
  0x8A36,  // { 0xE6, 0x64 } "訶"
  0x8A41,  // { 0xE6, 0x65 } "詁"
  0x8A5B,  // { 0xE6, 0x66 } "詛"
  0x8A52,  // { 0xE6, 0x67 } "詒"
  0x8A46,  // { 0xE6, 0x68 } "詆"
  0x8A48,  // { 0xE6, 0x69 } "詈"
  0x8A7C,  // { 0xE6, 0x6A } "詼"
  0x8A6D,  // { 0xE6, 0x6B } "詭"
  0x8A6C,  // { 0xE6, 0x6C } "詬"
  0x8A62,  // { 0xE6, 0x6D } "詢"
  0x8A85,  // { 0xE6, 0x6E } "誅"
  0x8A82,  // { 0xE6, 0x6F } "誂"
  0x8A84,  // { 0xE6, 0x70 } "誄"
  0x8AA8,  // { 0xE6, 0x71 } "誨"
  0x8AA1,  // { 0xE6, 0x72 } "誡"
  0x8A91,  // { 0xE6, 0x73 } "誑"
  0x8AA5,  // { 0xE6, 0x74 } "誥"
  0x8AA6,  // { 0xE6, 0x75 } "誦"
  0x8A9A,  // { 0xE6, 0x76 } "誚"
  0x8AA3,  // { 0xE6, 0x77 } "誣"
  0x8AC4,  // { 0xE6, 0x78 } "諄"
  0x8ACD,  // { 0xE6, 0x79 } "諍"
  0x8AC2,  // { 0xE6, 0x7A } "諂"
  0x8ADA,  // { 0xE6, 0x7B } "諚"
  0x8AEB,  // { 0xE6, 0x7C } "諫"
  0x8AF3,  // { 0xE6, 0x7D } "諳"
  0x8AE7,  // { 0xE6, 0x7E } "諧"
  0x8AE4,  // { 0xE6, 0x80 } "諤"
  0x8AF1,  // { 0xE6, 0x81 } "諱"
  0x8B14,  // { 0xE6, 0x82 } "謔"
  0x8AE0,  // { 0xE6, 0x83 } "諠"
  0x8AE2,  // { 0xE6, 0x84 } "諢"
  0x8AF7,  // { 0xE6, 0x85 } "諷"
  0x8ADE,  // { 0xE6, 0x86 } "諞"
  0x8ADB,  // { 0xE6, 0x87 } "諛"
  0x8B0C,  // { 0xE6, 0x88 } "謌"
  0x8B07,  // { 0xE6, 0x89 } "謇"
  0x8B1A,  // { 0xE6, 0x8A } "謚"
  0x8AE1,  // { 0xE6, 0x8B } "諡"
  0x8B16,  // { 0xE6, 0x8C } "謖"
  0x8B10,  // { 0xE6, 0x8D } "謐"
  0x8B17,  // { 0xE6, 0x8E } "謗"
  0x8B20,  // { 0xE6, 0x8F } "謠"
  0x8B33,  // { 0xE6, 0x90 } "謳"
  0x97AB,  // { 0xE6, 0x91 } "鞫"
  0x8B26,  // { 0xE6, 0x92 } "謦"
  0x8B2B,  // { 0xE6, 0x93 } "謫"
  0x8B3E,  // { 0xE6, 0x94 } "謾"
  0x8B28,  // { 0xE6, 0x95 } "謨"
  0x8B41,  // { 0xE6, 0x96 } "譁"
  0x8B4C,  // { 0xE6, 0x97 } "譌"
  0x8B4F,  // { 0xE6, 0x98 } "譏"
  0x8B4E,  // { 0xE6, 0x99 } "譎"
  0x8B49,  // { 0xE6, 0x9A } "證"
  0x8B56,  // { 0xE6, 0x9B } "譖"
  0x8B5B,  // { 0xE6, 0x9C } "譛"
  0x8B5A,  // { 0xE6, 0x9D } "譚"
  0x8B6B,  // { 0xE6, 0x9E } "譫"
  0x8B5F,  // { 0xE6, 0x9F } "譟"
  0x8B6C,  // { 0xE6, 0xA0 } "譬"
  0x8B6F,  // { 0xE6, 0xA1 } "譯"
  0x8B74,  // { 0xE6, 0xA2 } "譴"
  0x8B7D,  // { 0xE6, 0xA3 } "譽"
  0x8B80,  // { 0xE6, 0xA4 } "讀"
  0x8B8C,  // { 0xE6, 0xA5 } "讌"
  0x8B8E,  // { 0xE6, 0xA6 } "讎"
  0x8B92,  // { 0xE6, 0xA7 } "讒"
  0x8B93,  // { 0xE6, 0xA8 } "讓"
  0x8B96,  // { 0xE6, 0xA9 } "讖"
  0x8B99,  // { 0xE6, 0xAA } "讙"
  0x8B9A,  // { 0xE6, 0xAB } "讚"
  0x8C3A,  // { 0xE6, 0xAC } "谺"
  0x8C41,  // { 0xE6, 0xAD } "豁"
  0x8C3F,  // { 0xE6, 0xAE } "谿"
  0x8C48,  // { 0xE6, 0xAF } "豈"
  0x8C4C,  // { 0xE6, 0xB0 } "豌"
  0x8C4E,  // { 0xE6, 0xB1 } "豎"
  0x8C50,  // { 0xE6, 0xB2 } "豐"
  0x8C55,  // { 0xE6, 0xB3 } "豕"
  0x8C62,  // { 0xE6, 0xB4 } "豢"
  0x8C6C,  // { 0xE6, 0xB5 } "豬"
  0x8C78,  // { 0xE6, 0xB6 } "豸"
  0x8C7A,  // { 0xE6, 0xB7 } "豺"
  0x8C82,  // { 0xE6, 0xB8 } "貂"
  0x8C89,  // { 0xE6, 0xB9 } "貉"
  0x8C85,  // { 0xE6, 0xBA } "貅"
  0x8C8A,  // { 0xE6, 0xBB } "貊"
  0x8C8D,  // { 0xE6, 0xBC } "貍"
  0x8C8E,  // { 0xE6, 0xBD } "貎"
  0x8C94,  // { 0xE6, 0xBE } "貔"
  0x8C7C,  // { 0xE6, 0xBF } "豼"
  0x8C98,  // { 0xE6, 0xC0 } "貘"
  0x621D,  // { 0xE6, 0xC1 } "戝"
  0x8CAD,  // { 0xE6, 0xC2 } "貭"
  0x8CAA,  // { 0xE6, 0xC3 } "貪"
  0x8CBD,  // { 0xE6, 0xC4 } "貽"
  0x8CB2,  // { 0xE6, 0xC5 } "貲"
  0x8CB3,  // { 0xE6, 0xC6 } "貳"
  0x8CAE,  // { 0xE6, 0xC7 } "貮"
  0x8CB6,  // { 0xE6, 0xC8 } "貶"
  0x8CC8,  // { 0xE6, 0xC9 } "賈"
  0x8CC1,  // { 0xE6, 0xCA } "賁"
  0x8CE4,  // { 0xE6, 0xCB } "賤"
  0x8CE3,  // { 0xE6, 0xCC } "賣"
  0x8CDA,  // { 0xE6, 0xCD } "賚"
  0x8CFD,  // { 0xE6, 0xCE } "賽"
  0x8CFA,  // { 0xE6, 0xCF } "賺"
  0x8CFB,  // { 0xE6, 0xD0 } "賻"
  0x8D04,  // { 0xE6, 0xD1 } "贄"
  0x8D05,  // { 0xE6, 0xD2 } "贅"
  0x8D0A,  // { 0xE6, 0xD3 } "贊"
  0x8D07,  // { 0xE6, 0xD4 } "贇"
  0x8D0F,  // { 0xE6, 0xD5 } "贏"
  0x8D0D,  // { 0xE6, 0xD6 } "贍"
  0x8D10,  // { 0xE6, 0xD7 } "贐"
  0x9F4E,  // { 0xE6, 0xD8 } "齎"
  0x8D13,  // { 0xE6, 0xD9 } "贓"
  0x8CCD,  // { 0xE6, 0xDA } "賍"
  0x8D14,  // { 0xE6, 0xDB } "贔"
  0x8D16,  // { 0xE6, 0xDC } "贖"
  0x8D67,  // { 0xE6, 0xDD } "赧"
  0x8D6D,  // { 0xE6, 0xDE } "赭"
  0x8D71,  // { 0xE6, 0xDF } "赱"
  0x8D73,  // { 0xE6, 0xE0 } "赳"
  0x8D81,  // { 0xE6, 0xE1 } "趁"
  0x8D99,  // { 0xE6, 0xE2 } "趙"
  0x8DC2,  // { 0xE6, 0xE3 } "跂"
  0x8DBE,  // { 0xE6, 0xE4 } "趾"
  0x8DBA,  // { 0xE6, 0xE5 } "趺"
  0x8DCF,  // { 0xE6, 0xE6 } "跏"
  0x8DDA,  // { 0xE6, 0xE7 } "跚"
  0x8DD6,  // { 0xE6, 0xE8 } "跖"
  0x8DCC,  // { 0xE6, 0xE9 } "跌"
  0x8DDB,  // { 0xE6, 0xEA } "跛"
  0x8DCB,  // { 0xE6, 0xEB } "跋"
  0x8DEA,  // { 0xE6, 0xEC } "跪"
  0x8DEB,  // { 0xE6, 0xED } "跫"
  0x8DDF,  // { 0xE6, 0xEE } "跟"
  0x8DE3,  // { 0xE6, 0xEF } "跣"
  0x8DFC,  // { 0xE6, 0xF0 } "跼"
  0x8E08,  // { 0xE6, 0xF1 } "踈"
  0x8E09,  // { 0xE6, 0xF2 } "踉"
  0x8DFF,  // { 0xE6, 0xF3 } "跿"
  0x8E1D,  // { 0xE6, 0xF4 } "踝"
  0x8E1E,  // { 0xE6, 0xF5 } "踞"
  0x8E10,  // { 0xE6, 0xF6 } "踐"
  0x8E1F,  // { 0xE6, 0xF7 } "踟"
  0x8E42,  // { 0xE6, 0xF8 } "蹂"
  0x8E35,  // { 0xE6, 0xF9 } "踵"
  0x8E30,  // { 0xE6, 0xFA } "踰"
  0x8E34,  // { 0xE6, 0xFB } "踴"
  0x8E4A,  // { 0xE6, 0xFC } "蹊"
  0x0000,  // { 0xE6, 0xFD }
  0x0000,  // { 0xE6, 0xFE }
  0x0000,  // { 0xE6, 0xFF }
  0x8E47,  // { 0xE7, 0x40 } "蹇"
  0x8E49,  // { 0xE7, 0x41 } "蹉"
  0x8E4C,  // { 0xE7, 0x42 } "蹌"
  0x8E50,  // { 0xE7, 0x43 } "蹐"
  0x8E48,  // { 0xE7, 0x44 } "蹈"
  0x8E59,  // { 0xE7, 0x45 } "蹙"
  0x8E64,  // { 0xE7, 0x46 } "蹤"
  0x8E60,  // { 0xE7, 0x47 } "蹠"
  0x8E2A,  // { 0xE7, 0x48 } "踪"
  0x8E63,  // { 0xE7, 0x49 } "蹣"
  0x8E55,  // { 0xE7, 0x4A } "蹕"
  0x8E76,  // { 0xE7, 0x4B } "蹶"
  0x8E72,  // { 0xE7, 0x4C } "蹲"
  0x8E7C,  // { 0xE7, 0x4D } "蹼"
  0x8E81,  // { 0xE7, 0x4E } "躁"
  0x8E87,  // { 0xE7, 0x4F } "躇"
  0x8E85,  // { 0xE7, 0x50 } "躅"
  0x8E84,  // { 0xE7, 0x51 } "躄"
  0x8E8B,  // { 0xE7, 0x52 } "躋"
  0x8E8A,  // { 0xE7, 0x53 } "躊"
  0x8E93,  // { 0xE7, 0x54 } "躓"
  0x8E91,  // { 0xE7, 0x55 } "躑"
  0x8E94,  // { 0xE7, 0x56 } "躔"
  0x8E99,  // { 0xE7, 0x57 } "躙"
  0x8EAA,  // { 0xE7, 0x58 } "躪"
  0x8EA1,  // { 0xE7, 0x59 } "躡"
  0x8EAC,  // { 0xE7, 0x5A } "躬"
  0x8EB0,  // { 0xE7, 0x5B } "躰"
  0x8EC6,  // { 0xE7, 0x5C } "軆"
  0x8EB1,  // { 0xE7, 0x5D } "躱"
  0x8EBE,  // { 0xE7, 0x5E } "躾"
  0x8EC5,  // { 0xE7, 0x5F } "軅"
  0x8EC8,  // { 0xE7, 0x60 } "軈"
  0x8ECB,  // { 0xE7, 0x61 } "軋"
  0x8EDB,  // { 0xE7, 0x62 } "軛"
  0x8EE3,  // { 0xE7, 0x63 } "軣"
  0x8EFC,  // { 0xE7, 0x64 } "軼"
  0x8EFB,  // { 0xE7, 0x65 } "軻"
  0x8EEB,  // { 0xE7, 0x66 } "軫"
  0x8EFE,  // { 0xE7, 0x67 } "軾"
  0x8F0A,  // { 0xE7, 0x68 } "輊"
  0x8F05,  // { 0xE7, 0x69 } "輅"
  0x8F15,  // { 0xE7, 0x6A } "輕"
  0x8F12,  // { 0xE7, 0x6B } "輒"
  0x8F19,  // { 0xE7, 0x6C } "輙"
  0x8F13,  // { 0xE7, 0x6D } "輓"
  0x8F1C,  // { 0xE7, 0x6E } "輜"
  0x8F1F,  // { 0xE7, 0x6F } "輟"
  0x8F1B,  // { 0xE7, 0x70 } "輛"
  0x8F0C,  // { 0xE7, 0x71 } "輌"
  0x8F26,  // { 0xE7, 0x72 } "輦"
  0x8F33,  // { 0xE7, 0x73 } "輳"
  0x8F3B,  // { 0xE7, 0x74 } "輻"
  0x8F39,  // { 0xE7, 0x75 } "輹"
  0x8F45,  // { 0xE7, 0x76 } "轅"
  0x8F42,  // { 0xE7, 0x77 } "轂"
  0x8F3E,  // { 0xE7, 0x78 } "輾"
  0x8F4C,  // { 0xE7, 0x79 } "轌"
  0x8F49,  // { 0xE7, 0x7A } "轉"
  0x8F46,  // { 0xE7, 0x7B } "轆"
  0x8F4E,  // { 0xE7, 0x7C } "轎"
  0x8F57,  // { 0xE7, 0x7D } "轗"
  0x8F5C,  // { 0xE7, 0x7E } "轜"
  0x8F62,  // { 0xE7, 0x80 } "轢"
  0x8F63,  // { 0xE7, 0x81 } "轣"
  0x8F64,  // { 0xE7, 0x82 } "轤"
  0x8F9C,  // { 0xE7, 0x83 } "辜"
  0x8F9F,  // { 0xE7, 0x84 } "辟"
  0x8FA3,  // { 0xE7, 0x85 } "辣"
  0x8FAD,  // { 0xE7, 0x86 } "辭"
  0x8FAF,  // { 0xE7, 0x87 } "辯"
  0x8FB7,  // { 0xE7, 0x88 } "辷"
  0x8FDA,  // { 0xE7, 0x89 } "迚"
  0x8FE5,  // { 0xE7, 0x8A } "迥"
  0x8FE2,  // { 0xE7, 0x8B } "迢"
  0x8FEA,  // { 0xE7, 0x8C } "迪"
  0x8FEF,  // { 0xE7, 0x8D } "迯"
  0x9087,  // { 0xE7, 0x8E } "邇"
  0x8FF4,  // { 0xE7, 0x8F } "迴"
  0x9005,  // { 0xE7, 0x90 } "逅"
  0x8FF9,  // { 0xE7, 0x91 } "迹"
  0x8FFA,  // { 0xE7, 0x92 } "迺"
  0x9011,  // { 0xE7, 0x93 } "逑"
  0x9015,  // { 0xE7, 0x94 } "逕"
  0x9021,  // { 0xE7, 0x95 } "逡"
  0x900D,  // { 0xE7, 0x96 } "逍"
  0x901E,  // { 0xE7, 0x97 } "逞"
  0x9016,  // { 0xE7, 0x98 } "逖"
  0x900B,  // { 0xE7, 0x99 } "逋"
  0x9027,  // { 0xE7, 0x9A } "逧"
  0x9036,  // { 0xE7, 0x9B } "逶"
  0x9035,  // { 0xE7, 0x9C } "逵"
  0x9039,  // { 0xE7, 0x9D } "逹"
  0x8FF8,  // { 0xE7, 0x9E } "迸"
  0x904F,  // { 0xE7, 0x9F } "遏"
  0x9050,  // { 0xE7, 0xA0 } "遐"
  0x9051,  // { 0xE7, 0xA1 } "遑"
  0x9052,  // { 0xE7, 0xA2 } "遒"
  0x900E,  // { 0xE7, 0xA3 } "逎"
  0x9049,  // { 0xE7, 0xA4 } "遉"
  0x903E,  // { 0xE7, 0xA5 } "逾"
  0x9056,  // { 0xE7, 0xA6 } "遖"
  0x9058,  // { 0xE7, 0xA7 } "遘"
  0x905E,  // { 0xE7, 0xA8 } "遞"
  0x9068,  // { 0xE7, 0xA9 } "遨"
  0x906F,  // { 0xE7, 0xAA } "遯"
  0x9076,  // { 0xE7, 0xAB } "遶"
  0x96A8,  // { 0xE7, 0xAC } "隨"
  0x9072,  // { 0xE7, 0xAD } "遲"
  0x9082,  // { 0xE7, 0xAE } "邂"
  0x907D,  // { 0xE7, 0xAF } "遽"
  0x9081,  // { 0xE7, 0xB0 } "邁"
  0x9080,  // { 0xE7, 0xB1 } "邀"
  0x908A,  // { 0xE7, 0xB2 } "邊"
  0x9089,  // { 0xE7, 0xB3 } "邉"
  0x908F,  // { 0xE7, 0xB4 } "邏"
  0x90A8,  // { 0xE7, 0xB5 } "邨"
  0x90AF,  // { 0xE7, 0xB6 } "邯"
  0x90B1,  // { 0xE7, 0xB7 } "邱"
  0x90B5,  // { 0xE7, 0xB8 } "邵"
  0x90E2,  // { 0xE7, 0xB9 } "郢"
  0x90E4,  // { 0xE7, 0xBA } "郤"
  0x6248,  // { 0xE7, 0xBB } "扈"
  0x90DB,  // { 0xE7, 0xBC } "郛"
  0x9102,  // { 0xE7, 0xBD } "鄂"
  0x9112,  // { 0xE7, 0xBE } "鄒"
  0x9119,  // { 0xE7, 0xBF } "鄙"
  0x9132,  // { 0xE7, 0xC0 } "鄲"
  0x9130,  // { 0xE7, 0xC1 } "鄰"
  0x914A,  // { 0xE7, 0xC2 } "酊"
  0x9156,  // { 0xE7, 0xC3 } "酖"
  0x9158,  // { 0xE7, 0xC4 } "酘"
  0x9163,  // { 0xE7, 0xC5 } "酣"
  0x9165,  // { 0xE7, 0xC6 } "酥"
  0x9169,  // { 0xE7, 0xC7 } "酩"
  0x9173,  // { 0xE7, 0xC8 } "酳"
  0x9172,  // { 0xE7, 0xC9 } "酲"
  0x918B,  // { 0xE7, 0xCA } "醋"
  0x9189,  // { 0xE7, 0xCB } "醉"
  0x9182,  // { 0xE7, 0xCC } "醂"
  0x91A2,  // { 0xE7, 0xCD } "醢"
  0x91AB,  // { 0xE7, 0xCE } "醫"
  0x91AF,  // { 0xE7, 0xCF } "醯"
  0x91AA,  // { 0xE7, 0xD0 } "醪"
  0x91B5,  // { 0xE7, 0xD1 } "醵"
  0x91B4,  // { 0xE7, 0xD2 } "醴"
  0x91BA,  // { 0xE7, 0xD3 } "醺"
  0x91C0,  // { 0xE7, 0xD4 } "釀"
  0x91C1,  // { 0xE7, 0xD5 } "釁"
  0x91C9,  // { 0xE7, 0xD6 } "釉"
  0x91CB,  // { 0xE7, 0xD7 } "釋"
  0x91D0,  // { 0xE7, 0xD8 } "釐"
  0x91D6,  // { 0xE7, 0xD9 } "釖"
  0x91DF,  // { 0xE7, 0xDA } "釟"
  0x91E1,  // { 0xE7, 0xDB } "釡"
  0x91DB,  // { 0xE7, 0xDC } "釛"
  0x91FC,  // { 0xE7, 0xDD } "釼"
  0x91F5,  // { 0xE7, 0xDE } "釵"
  0x91F6,  // { 0xE7, 0xDF } "釶"
  0x921E,  // { 0xE7, 0xE0 } "鈞"
  0x91FF,  // { 0xE7, 0xE1 } "釿"
  0x9214,  // { 0xE7, 0xE2 } "鈔"
  0x922C,  // { 0xE7, 0xE3 } "鈬"
  0x9215,  // { 0xE7, 0xE4 } "鈕"
  0x9211,  // { 0xE7, 0xE5 } "鈑"
  0x925E,  // { 0xE7, 0xE6 } "鉞"
  0x9257,  // { 0xE7, 0xE7 } "鉗"
  0x9245,  // { 0xE7, 0xE8 } "鉅"
  0x9249,  // { 0xE7, 0xE9 } "鉉"
  0x9264,  // { 0xE7, 0xEA } "鉤"
  0x9248,  // { 0xE7, 0xEB } "鉈"
  0x9295,  // { 0xE7, 0xEC } "銕"
  0x923F,  // { 0xE7, 0xED } "鈿"
  0x924B,  // { 0xE7, 0xEE } "鉋"
  0x9250,  // { 0xE7, 0xEF } "鉐"
  0x929C,  // { 0xE7, 0xF0 } "銜"
  0x9296,  // { 0xE7, 0xF1 } "銖"
  0x9293,  // { 0xE7, 0xF2 } "銓"
  0x929B,  // { 0xE7, 0xF3 } "銛"
  0x925A,  // { 0xE7, 0xF4 } "鉚"
  0x92CF,  // { 0xE7, 0xF5 } "鋏"
  0x92B9,  // { 0xE7, 0xF6 } "銹"
  0x92B7,  // { 0xE7, 0xF7 } "銷"
  0x92E9,  // { 0xE7, 0xF8 } "鋩"
  0x930F,  // { 0xE7, 0xF9 } "錏"
  0x92FA,  // { 0xE7, 0xFA } "鋺"
  0x9344,  // { 0xE7, 0xFB } "鍄"
  0x932E,  // { 0xE7, 0xFC } "錮"
  0x0000,  // { 0xE7, 0xFD }
  0x0000,  // { 0xE7, 0xFE }
  0x0000,  // { 0xE7, 0xFF }
  0x9319,  // { 0xE8, 0x40 } "錙"
  0x9322,  // { 0xE8, 0x41 } "錢"
  0x931A,  // { 0xE8, 0x42 } "錚"
  0x9323,  // { 0xE8, 0x43 } "錣"
  0x933A,  // { 0xE8, 0x44 } "錺"
  0x9335,  // { 0xE8, 0x45 } "錵"
  0x933B,  // { 0xE8, 0x46 } "錻"
  0x935C,  // { 0xE8, 0x47 } "鍜"
  0x9360,  // { 0xE8, 0x48 } "鍠"
  0x937C,  // { 0xE8, 0x49 } "鍼"
  0x936E,  // { 0xE8, 0x4A } "鍮"
  0x9356,  // { 0xE8, 0x4B } "鍖"
  0x93B0,  // { 0xE8, 0x4C } "鎰"
  0x93AC,  // { 0xE8, 0x4D } "鎬"
  0x93AD,  // { 0xE8, 0x4E } "鎭"
  0x9394,  // { 0xE8, 0x4F } "鎔"
  0x93B9,  // { 0xE8, 0x50 } "鎹"
  0x93D6,  // { 0xE8, 0x51 } "鏖"
  0x93D7,  // { 0xE8, 0x52 } "鏗"
  0x93E8,  // { 0xE8, 0x53 } "鏨"
  0x93E5,  // { 0xE8, 0x54 } "鏥"
  0x93D8,  // { 0xE8, 0x55 } "鏘"
  0x93C3,  // { 0xE8, 0x56 } "鏃"
  0x93DD,  // { 0xE8, 0x57 } "鏝"
  0x93D0,  // { 0xE8, 0x58 } "鏐"
  0x93C8,  // { 0xE8, 0x59 } "鏈"
  0x93E4,  // { 0xE8, 0x5A } "鏤"
  0x941A,  // { 0xE8, 0x5B } "鐚"
  0x9414,  // { 0xE8, 0x5C } "鐔"
  0x9413,  // { 0xE8, 0x5D } "鐓"
  0x9403,  // { 0xE8, 0x5E } "鐃"
  0x9407,  // { 0xE8, 0x5F } "鐇"
  0x9410,  // { 0xE8, 0x60 } "鐐"
  0x9436,  // { 0xE8, 0x61 } "鐶"
  0x942B,  // { 0xE8, 0x62 } "鐫"
  0x9435,  // { 0xE8, 0x63 } "鐵"
  0x9421,  // { 0xE8, 0x64 } "鐡"
  0x943A,  // { 0xE8, 0x65 } "鐺"
  0x9441,  // { 0xE8, 0x66 } "鑁"
  0x9452,  // { 0xE8, 0x67 } "鑒"
  0x9444,  // { 0xE8, 0x68 } "鑄"
  0x945B,  // { 0xE8, 0x69 } "鑛"
  0x9460,  // { 0xE8, 0x6A } "鑠"
  0x9462,  // { 0xE8, 0x6B } "鑢"
  0x945E,  // { 0xE8, 0x6C } "鑞"
  0x946A,  // { 0xE8, 0x6D } "鑪"
  0x9229,  // { 0xE8, 0x6E } "鈩"
  0x9470,  // { 0xE8, 0x6F } "鑰"
  0x9475,  // { 0xE8, 0x70 } "鑵"
  0x9477,  // { 0xE8, 0x71 } "鑷"
  0x947D,  // { 0xE8, 0x72 } "鑽"
  0x945A,  // { 0xE8, 0x73 } "鑚"
  0x947C,  // { 0xE8, 0x74 } "鑼"
  0x947E,  // { 0xE8, 0x75 } "鑾"
  0x9481,  // { 0xE8, 0x76 } "钁"
  0x947F,  // { 0xE8, 0x77 } "鑿"
  0x9582,  // { 0xE8, 0x78 } "閂"
  0x9587,  // { 0xE8, 0x79 } "閇"
  0x958A,  // { 0xE8, 0x7A } "閊"
  0x9594,  // { 0xE8, 0x7B } "閔"
  0x9596,  // { 0xE8, 0x7C } "閖"
  0x9598,  // { 0xE8, 0x7D } "閘"
  0x9599,  // { 0xE8, 0x7E } "閙"
  0x95A0,  // { 0xE8, 0x80 } "閠"
  0x95A8,  // { 0xE8, 0x81 } "閨"
  0x95A7,  // { 0xE8, 0x82 } "閧"
  0x95AD,  // { 0xE8, 0x83 } "閭"
  0x95BC,  // { 0xE8, 0x84 } "閼"
  0x95BB,  // { 0xE8, 0x85 } "閻"
  0x95B9,  // { 0xE8, 0x86 } "閹"
  0x95BE,  // { 0xE8, 0x87 } "閾"
  0x95CA,  // { 0xE8, 0x88 } "闊"
  0x6FF6,  // { 0xE8, 0x89 } "濶"
  0x95C3,  // { 0xE8, 0x8A } "闃"
  0x95CD,  // { 0xE8, 0x8B } "闍"
  0x95CC,  // { 0xE8, 0x8C } "闌"
  0x95D5,  // { 0xE8, 0x8D } "闕"
  0x95D4,  // { 0xE8, 0x8E } "闔"
  0x95D6,  // { 0xE8, 0x8F } "闖"
  0x95DC,  // { 0xE8, 0x90 } "關"
  0x95E1,  // { 0xE8, 0x91 } "闡"
  0x95E5,  // { 0xE8, 0x92 } "闥"
  0x95E2,  // { 0xE8, 0x93 } "闢"
  0x9621,  // { 0xE8, 0x94 } "阡"
  0x9628,  // { 0xE8, 0x95 } "阨"
  0x962E,  // { 0xE8, 0x96 } "阮"
  0x962F,  // { 0xE8, 0x97 } "阯"
  0x9642,  // { 0xE8, 0x98 } "陂"
  0x964C,  // { 0xE8, 0x99 } "陌"
  0x964F,  // { 0xE8, 0x9A } "陏"
  0x964B,  // { 0xE8, 0x9B } "陋"
  0x9677,  // { 0xE8, 0x9C } "陷"
  0x965C,  // { 0xE8, 0x9D } "陜"
  0x965E,  // { 0xE8, 0x9E } "陞"
  0x965D,  // { 0xE8, 0x9F } "陝"
  0x965F,  // { 0xE8, 0xA0 } "陟"
  0x9666,  // { 0xE8, 0xA1 } "陦"
  0x9672,  // { 0xE8, 0xA2 } "陲"
  0x966C,  // { 0xE8, 0xA3 } "陬"
  0x968D,  // { 0xE8, 0xA4 } "隍"
  0x9698,  // { 0xE8, 0xA5 } "隘"
  0x9695,  // { 0xE8, 0xA6 } "隕"
  0x9697,  // { 0xE8, 0xA7 } "隗"
  0x96AA,  // { 0xE8, 0xA8 } "險"
  0x96A7,  // { 0xE8, 0xA9 } "隧"
  0x96B1,  // { 0xE8, 0xAA } "隱"
  0x96B2,  // { 0xE8, 0xAB } "隲"
  0x96B0,  // { 0xE8, 0xAC } "隰"
  0x96B4,  // { 0xE8, 0xAD } "隴"
  0x96B6,  // { 0xE8, 0xAE } "隶"
  0x96B8,  // { 0xE8, 0xAF } "隸"
  0x96B9,  // { 0xE8, 0xB0 } "隹"
  0x96CE,  // { 0xE8, 0xB1 } "雎"
  0x96CB,  // { 0xE8, 0xB2 } "雋"
  0x96C9,  // { 0xE8, 0xB3 } "雉"
  0x96CD,  // { 0xE8, 0xB4 } "雍"
  0x894D,  // { 0xE8, 0xB5 } "襍"
  0x96DC,  // { 0xE8, 0xB6 } "雜"
  0x970D,  // { 0xE8, 0xB7 } "霍"
  0x96D5,  // { 0xE8, 0xB8 } "雕"
  0x96F9,  // { 0xE8, 0xB9 } "雹"
  0x9704,  // { 0xE8, 0xBA } "霄"
  0x9706,  // { 0xE8, 0xBB } "霆"
  0x9708,  // { 0xE8, 0xBC } "霈"
  0x9713,  // { 0xE8, 0xBD } "霓"
  0x970E,  // { 0xE8, 0xBE } "霎"
  0x9711,  // { 0xE8, 0xBF } "霑"
  0x970F,  // { 0xE8, 0xC0 } "霏"
  0x9716,  // { 0xE8, 0xC1 } "霖"
  0x9719,  // { 0xE8, 0xC2 } "霙"
  0x9724,  // { 0xE8, 0xC3 } "霤"
  0x972A,  // { 0xE8, 0xC4 } "霪"
  0x9730,  // { 0xE8, 0xC5 } "霰"
  0x9739,  // { 0xE8, 0xC6 } "霹"
  0x973D,  // { 0xE8, 0xC7 } "霽"
  0x973E,  // { 0xE8, 0xC8 } "霾"
  0x9744,  // { 0xE8, 0xC9 } "靄"
  0x9746,  // { 0xE8, 0xCA } "靆"
  0x9748,  // { 0xE8, 0xCB } "靈"
  0x9742,  // { 0xE8, 0xCC } "靂"
  0x9749,  // { 0xE8, 0xCD } "靉"
  0x975C,  // { 0xE8, 0xCE } "靜"
  0x9760,  // { 0xE8, 0xCF } "靠"
  0x9764,  // { 0xE8, 0xD0 } "靤"
  0x9766,  // { 0xE8, 0xD1 } "靦"
  0x9768,  // { 0xE8, 0xD2 } "靨"
  0x52D2,  // { 0xE8, 0xD3 } "勒"
  0x976B,  // { 0xE8, 0xD4 } "靫"
  0x9771,  // { 0xE8, 0xD5 } "靱"
  0x9779,  // { 0xE8, 0xD6 } "靹"
  0x9785,  // { 0xE8, 0xD7 } "鞅"
  0x977C,  // { 0xE8, 0xD8 } "靼"
  0x9781,  // { 0xE8, 0xD9 } "鞁"
  0x977A,  // { 0xE8, 0xDA } "靺"
  0x9786,  // { 0xE8, 0xDB } "鞆"
  0x978B,  // { 0xE8, 0xDC } "鞋"
  0x978F,  // { 0xE8, 0xDD } "鞏"
  0x9790,  // { 0xE8, 0xDE } "鞐"
  0x979C,  // { 0xE8, 0xDF } "鞜"
  0x97A8,  // { 0xE8, 0xE0 } "鞨"
  0x97A6,  // { 0xE8, 0xE1 } "鞦"
  0x97A3,  // { 0xE8, 0xE2 } "鞣"
  0x97B3,  // { 0xE8, 0xE3 } "鞳"
  0x97B4,  // { 0xE8, 0xE4 } "鞴"
  0x97C3,  // { 0xE8, 0xE5 } "韃"
  0x97C6,  // { 0xE8, 0xE6 } "韆"
  0x97C8,  // { 0xE8, 0xE7 } "韈"
  0x97CB,  // { 0xE8, 0xE8 } "韋"
  0x97DC,  // { 0xE8, 0xE9 } "韜"
  0x97ED,  // { 0xE8, 0xEA } "韭"
  0x9F4F,  // { 0xE8, 0xEB } "齏"
  0x97F2,  // { 0xE8, 0xEC } "韲"
  0x7ADF,  // { 0xE8, 0xED } "竟"
  0x97F6,  // { 0xE8, 0xEE } "韶"
  0x97F5,  // { 0xE8, 0xEF } "韵"
  0x980F,  // { 0xE8, 0xF0 } "頏"
  0x980C,  // { 0xE8, 0xF1 } "頌"
  0x9838,  // { 0xE8, 0xF2 } "頸"
  0x9824,  // { 0xE8, 0xF3 } "頤"
  0x9821,  // { 0xE8, 0xF4 } "頡"
  0x9837,  // { 0xE8, 0xF5 } "頷"
  0x983D,  // { 0xE8, 0xF6 } "頽"
  0x9846,  // { 0xE8, 0xF7 } "顆"
  0x984F,  // { 0xE8, 0xF8 } "顏"
  0x984B,  // { 0xE8, 0xF9 } "顋"
  0x986B,  // { 0xE8, 0xFA } "顫"
  0x986F,  // { 0xE8, 0xFB } "顯"
  0x9870,  // { 0xE8, 0xFC } "顰"
  0x0000,  // { 0xE8, 0xFD }
  0x0000,  // { 0xE8, 0xFE }
  0x0000,  // { 0xE8, 0xFF }
  0x9871,  // { 0xE9, 0x40 } "顱"
  0x9874,  // { 0xE9, 0x41 } "顴"
  0x9873,  // { 0xE9, 0x42 } "顳"
  0x98AA,  // { 0xE9, 0x43 } "颪"
  0x98AF,  // { 0xE9, 0x44 } "颯"
  0x98B1,  // { 0xE9, 0x45 } "颱"
  0x98B6,  // { 0xE9, 0x46 } "颶"
  0x98C4,  // { 0xE9, 0x47 } "飄"
  0x98C3,  // { 0xE9, 0x48 } "飃"
  0x98C6,  // { 0xE9, 0x49 } "飆"
  0x98E9,  // { 0xE9, 0x4A } "飩"
  0x98EB,  // { 0xE9, 0x4B } "飫"
  0x9903,  // { 0xE9, 0x4C } "餃"
  0x9909,  // { 0xE9, 0x4D } "餉"
  0x9912,  // { 0xE9, 0x4E } "餒"
  0x9914,  // { 0xE9, 0x4F } "餔"
  0x9918,  // { 0xE9, 0x50 } "餘"
  0x9921,  // { 0xE9, 0x51 } "餡"
  0x991D,  // { 0xE9, 0x52 } "餝"
  0x991E,  // { 0xE9, 0x53 } "餞"
  0x9924,  // { 0xE9, 0x54 } "餤"
  0x9920,  // { 0xE9, 0x55 } "餠"
  0x992C,  // { 0xE9, 0x56 } "餬"
  0x992E,  // { 0xE9, 0x57 } "餮"
  0x993D,  // { 0xE9, 0x58 } "餽"
  0x993E,  // { 0xE9, 0x59 } "餾"
  0x9942,  // { 0xE9, 0x5A } "饂"
  0x9949,  // { 0xE9, 0x5B } "饉"
  0x9945,  // { 0xE9, 0x5C } "饅"
  0x9950,  // { 0xE9, 0x5D } "饐"
  0x994B,  // { 0xE9, 0x5E } "饋"
  0x9951,  // { 0xE9, 0x5F } "饑"
  0x9952,  // { 0xE9, 0x60 } "饒"
  0x994C,  // { 0xE9, 0x61 } "饌"
  0x9955,  // { 0xE9, 0x62 } "饕"
  0x9997,  // { 0xE9, 0x63 } "馗"
  0x9998,  // { 0xE9, 0x64 } "馘"
  0x99A5,  // { 0xE9, 0x65 } "馥"
  0x99AD,  // { 0xE9, 0x66 } "馭"
  0x99AE,  // { 0xE9, 0x67 } "馮"
  0x99BC,  // { 0xE9, 0x68 } "馼"
  0x99DF,  // { 0xE9, 0x69 } "駟"
  0x99DB,  // { 0xE9, 0x6A } "駛"
  0x99DD,  // { 0xE9, 0x6B } "駝"
  0x99D8,  // { 0xE9, 0x6C } "駘"
  0x99D1,  // { 0xE9, 0x6D } "駑"
  0x99ED,  // { 0xE9, 0x6E } "駭"
  0x99EE,  // { 0xE9, 0x6F } "駮"
  0x99F1,  // { 0xE9, 0x70 } "駱"
  0x99F2,  // { 0xE9, 0x71 } "駲"
  0x99FB,  // { 0xE9, 0x72 } "駻"
  0x99F8,  // { 0xE9, 0x73 } "駸"
  0x9A01,  // { 0xE9, 0x74 } "騁"
  0x9A0F,  // { 0xE9, 0x75 } "騏"
  0x9A05,  // { 0xE9, 0x76 } "騅"
  0x99E2,  // { 0xE9, 0x77 } "駢"
  0x9A19,  // { 0xE9, 0x78 } "騙"
  0x9A2B,  // { 0xE9, 0x79 } "騫"
  0x9A37,  // { 0xE9, 0x7A } "騷"
  0x9A45,  // { 0xE9, 0x7B } "驅"
  0x9A42,  // { 0xE9, 0x7C } "驂"
  0x9A40,  // { 0xE9, 0x7D } "驀"
  0x9A43,  // { 0xE9, 0x7E } "驃"
  0x9A3E,  // { 0xE9, 0x80 } "騾"
  0x9A55,  // { 0xE9, 0x81 } "驕"
  0x9A4D,  // { 0xE9, 0x82 } "驍"
  0x9A5B,  // { 0xE9, 0x83 } "驛"
  0x9A57,  // { 0xE9, 0x84 } "驗"
  0x9A5F,  // { 0xE9, 0x85 } "驟"
  0x9A62,  // { 0xE9, 0x86 } "驢"
  0x9A65,  // { 0xE9, 0x87 } "驥"
  0x9A64,  // { 0xE9, 0x88 } "驤"
  0x9A69,  // { 0xE9, 0x89 } "驩"
  0x9A6B,  // { 0xE9, 0x8A } "驫"
  0x9A6A,  // { 0xE9, 0x8B } "驪"
  0x9AAD,  // { 0xE9, 0x8C } "骭"
  0x9AB0,  // { 0xE9, 0x8D } "骰"
  0x9ABC,  // { 0xE9, 0x8E } "骼"
  0x9AC0,  // { 0xE9, 0x8F } "髀"
  0x9ACF,  // { 0xE9, 0x90 } "髏"
  0x9AD1,  // { 0xE9, 0x91 } "髑"
  0x9AD3,  // { 0xE9, 0x92 } "髓"
  0x9AD4,  // { 0xE9, 0x93 } "體"
  0x9ADE,  // { 0xE9, 0x94 } "髞"
  0x9ADF,  // { 0xE9, 0x95 } "髟"
  0x9AE2,  // { 0xE9, 0x96 } "髢"
  0x9AE3,  // { 0xE9, 0x97 } "髣"
  0x9AE6,  // { 0xE9, 0x98 } "髦"
  0x9AEF,  // { 0xE9, 0x99 } "髯"
  0x9AEB,  // { 0xE9, 0x9A } "髫"
  0x9AEE,  // { 0xE9, 0x9B } "髮"
  0x9AF4,  // { 0xE9, 0x9C } "髴"
  0x9AF1,  // { 0xE9, 0x9D } "髱"
  0x9AF7,  // { 0xE9, 0x9E } "髷"
  0x9AFB,  // { 0xE9, 0x9F } "髻"
  0x9B06,  // { 0xE9, 0xA0 } "鬆"
  0x9B18,  // { 0xE9, 0xA1 } "鬘"
  0x9B1A,  // { 0xE9, 0xA2 } "鬚"
  0x9B1F,  // { 0xE9, 0xA3 } "鬟"
  0x9B22,  // { 0xE9, 0xA4 } "鬢"
  0x9B23,  // { 0xE9, 0xA5 } "鬣"
  0x9B25,  // { 0xE9, 0xA6 } "鬥"
  0x9B27,  // { 0xE9, 0xA7 } "鬧"
  0x9B28,  // { 0xE9, 0xA8 } "鬨"
  0x9B29,  // { 0xE9, 0xA9 } "鬩"
  0x9B2A,  // { 0xE9, 0xAA } "鬪"
  0x9B2E,  // { 0xE9, 0xAB } "鬮"
  0x9B2F,  // { 0xE9, 0xAC } "鬯"
  0x9B32,  // { 0xE9, 0xAD } "鬲"
  0x9B44,  // { 0xE9, 0xAE } "魄"
  0x9B43,  // { 0xE9, 0xAF } "魃"
  0x9B4F,  // { 0xE9, 0xB0 } "魏"
  0x9B4D,  // { 0xE9, 0xB1 } "魍"
  0x9B4E,  // { 0xE9, 0xB2 } "魎"
  0x9B51,  // { 0xE9, 0xB3 } "魑"
  0x9B58,  // { 0xE9, 0xB4 } "魘"
  0x9B74,  // { 0xE9, 0xB5 } "魴"
  0x9B93,  // { 0xE9, 0xB6 } "鮓"
  0x9B83,  // { 0xE9, 0xB7 } "鮃"
  0x9B91,  // { 0xE9, 0xB8 } "鮑"
  0x9B96,  // { 0xE9, 0xB9 } "鮖"
  0x9B97,  // { 0xE9, 0xBA } "鮗"
  0x9B9F,  // { 0xE9, 0xBB } "鮟"
  0x9BA0,  // { 0xE9, 0xBC } "鮠"
  0x9BA8,  // { 0xE9, 0xBD } "鮨"
  0x9BB4,  // { 0xE9, 0xBE } "鮴"
  0x9BC0,  // { 0xE9, 0xBF } "鯀"
  0x9BCA,  // { 0xE9, 0xC0 } "鯊"
  0x9BB9,  // { 0xE9, 0xC1 } "鮹"
  0x9BC6,  // { 0xE9, 0xC2 } "鯆"
  0x9BCF,  // { 0xE9, 0xC3 } "鯏"
  0x9BD1,  // { 0xE9, 0xC4 } "鯑"
  0x9BD2,  // { 0xE9, 0xC5 } "鯒"
  0x9BE3,  // { 0xE9, 0xC6 } "鯣"
  0x9BE2,  // { 0xE9, 0xC7 } "鯢"
  0x9BE4,  // { 0xE9, 0xC8 } "鯤"
  0x9BD4,  // { 0xE9, 0xC9 } "鯔"
  0x9BE1,  // { 0xE9, 0xCA } "鯡"
  0x9C3A,  // { 0xE9, 0xCB } "鰺"
  0x9BF2,  // { 0xE9, 0xCC } "鯲"
  0x9BF1,  // { 0xE9, 0xCD } "鯱"
  0x9BF0,  // { 0xE9, 0xCE } "鯰"
  0x9C15,  // { 0xE9, 0xCF } "鰕"
  0x9C14,  // { 0xE9, 0xD0 } "鰔"
  0x9C09,  // { 0xE9, 0xD1 } "鰉"
  0x9C13,  // { 0xE9, 0xD2 } "鰓"
  0x9C0C,  // { 0xE9, 0xD3 } "鰌"
  0x9C06,  // { 0xE9, 0xD4 } "鰆"
  0x9C08,  // { 0xE9, 0xD5 } "鰈"
  0x9C12,  // { 0xE9, 0xD6 } "鰒"
  0x9C0A,  // { 0xE9, 0xD7 } "鰊"
  0x9C04,  // { 0xE9, 0xD8 } "鰄"
  0x9C2E,  // { 0xE9, 0xD9 } "鰮"
  0x9C1B,  // { 0xE9, 0xDA } "鰛"
  0x9C25,  // { 0xE9, 0xDB } "鰥"
  0x9C24,  // { 0xE9, 0xDC } "鰤"
  0x9C21,  // { 0xE9, 0xDD } "鰡"
  0x9C30,  // { 0xE9, 0xDE } "鰰"
  0x9C47,  // { 0xE9, 0xDF } "鱇"
  0x9C32,  // { 0xE9, 0xE0 } "鰲"
  0x9C46,  // { 0xE9, 0xE1 } "鱆"
  0x9C3E,  // { 0xE9, 0xE2 } "鰾"
  0x9C5A,  // { 0xE9, 0xE3 } "鱚"
  0x9C60,  // { 0xE9, 0xE4 } "鱠"
  0x9C67,  // { 0xE9, 0xE5 } "鱧"
  0x9C76,  // { 0xE9, 0xE6 } "鱶"
  0x9C78,  // { 0xE9, 0xE7 } "鱸"
  0x9CE7,  // { 0xE9, 0xE8 } "鳧"
  0x9CEC,  // { 0xE9, 0xE9 } "鳬"
  0x9CF0,  // { 0xE9, 0xEA } "鳰"
  0x9D09,  // { 0xE9, 0xEB } "鴉"
  0x9D08,  // { 0xE9, 0xEC } "鴈"
  0x9CEB,  // { 0xE9, 0xED } "鳫"
  0x9D03,  // { 0xE9, 0xEE } "鴃"
  0x9D06,  // { 0xE9, 0xEF } "鴆"
  0x9D2A,  // { 0xE9, 0xF0 } "鴪"
  0x9D26,  // { 0xE9, 0xF1 } "鴦"
  0x9DAF,  // { 0xE9, 0xF2 } "鶯"
  0x9D23,  // { 0xE9, 0xF3 } "鴣"
  0x9D1F,  // { 0xE9, 0xF4 } "鴟"
  0x9D44,  // { 0xE9, 0xF5 } "鵄"
  0x9D15,  // { 0xE9, 0xF6 } "鴕"
  0x9D12,  // { 0xE9, 0xF7 } "鴒"
  0x9D41,  // { 0xE9, 0xF8 } "鵁"
  0x9D3F,  // { 0xE9, 0xF9 } "鴿"
  0x9D3E,  // { 0xE9, 0xFA } "鴾"
  0x9D46,  // { 0xE9, 0xFB } "鵆"
  0x9D48,  // { 0xE9, 0xFC } "鵈"
  0x0000,  // { 0xE9, 0xFD }
  0x0000,  // { 0xE9, 0xFE }
  0x0000,  // { 0xE9, 0xFF }
  0x9D5D,  // { 0xEA, 0x40 } "鵝"
  0x9D5E,  // { 0xEA, 0x41 } "鵞"
  0x9D64,  // { 0xEA, 0x42 } "鵤"
  0x9D51,  // { 0xEA, 0x43 } "鵑"
  0x9D50,  // { 0xEA, 0x44 } "鵐"
  0x9D59,  // { 0xEA, 0x45 } "鵙"
  0x9D72,  // { 0xEA, 0x46 } "鵲"
  0x9D89,  // { 0xEA, 0x47 } "鶉"
  0x9D87,  // { 0xEA, 0x48 } "鶇"
  0x9DAB,  // { 0xEA, 0x49 } "鶫"
  0x9D6F,  // { 0xEA, 0x4A } "鵯"
  0x9D7A,  // { 0xEA, 0x4B } "鵺"
  0x9D9A,  // { 0xEA, 0x4C } "鶚"
  0x9DA4,  // { 0xEA, 0x4D } "鶤"
  0x9DA9,  // { 0xEA, 0x4E } "鶩"
  0x9DB2,  // { 0xEA, 0x4F } "鶲"
  0x9DC4,  // { 0xEA, 0x50 } "鷄"
  0x9DC1,  // { 0xEA, 0x51 } "鷁"
  0x9DBB,  // { 0xEA, 0x52 } "鶻"
  0x9DB8,  // { 0xEA, 0x53 } "鶸"
  0x9DBA,  // { 0xEA, 0x54 } "鶺"
  0x9DC6,  // { 0xEA, 0x55 } "鷆"
  0x9DCF,  // { 0xEA, 0x56 } "鷏"
  0x9DC2,  // { 0xEA, 0x57 } "鷂"
  0x9DD9,  // { 0xEA, 0x58 } "鷙"
  0x9DD3,  // { 0xEA, 0x59 } "鷓"
  0x9DF8,  // { 0xEA, 0x5A } "鷸"
  0x9DE6,  // { 0xEA, 0x5B } "鷦"
  0x9DED,  // { 0xEA, 0x5C } "鷭"
  0x9DEF,  // { 0xEA, 0x5D } "鷯"
  0x9DFD,  // { 0xEA, 0x5E } "鷽"
  0x9E1A,  // { 0xEA, 0x5F } "鸚"
  0x9E1B,  // { 0xEA, 0x60 } "鸛"
  0x9E1E,  // { 0xEA, 0x61 } "鸞"
  0x9E75,  // { 0xEA, 0x62 } "鹵"
  0x9E79,  // { 0xEA, 0x63 } "鹹"
  0x9E7D,  // { 0xEA, 0x64 } "鹽"
  0x9E81,  // { 0xEA, 0x65 } "麁"
  0x9E88,  // { 0xEA, 0x66 } "麈"
  0x9E8B,  // { 0xEA, 0x67 } "麋"
  0x9E8C,  // { 0xEA, 0x68 } "麌"
  0x9E92,  // { 0xEA, 0x69 } "麒"
  0x9E95,  // { 0xEA, 0x6A } "麕"
  0x9E91,  // { 0xEA, 0x6B } "麑"
  0x9E9D,  // { 0xEA, 0x6C } "麝"
  0x9EA5,  // { 0xEA, 0x6D } "麥"
  0x9EA9,  // { 0xEA, 0x6E } "麩"
  0x9EB8,  // { 0xEA, 0x6F } "麸"
  0x9EAA,  // { 0xEA, 0x70 } "麪"
  0x9EAD,  // { 0xEA, 0x71 } "麭"
  0x9761,  // { 0xEA, 0x72 } "靡"
  0x9ECC,  // { 0xEA, 0x73 } "黌"
  0x9ECE,  // { 0xEA, 0x74 } "黎"
  0x9ECF,  // { 0xEA, 0x75 } "黏"
  0x9ED0,  // { 0xEA, 0x76 } "黐"
  0x9ED4,  // { 0xEA, 0x77 } "黔"
  0x9EDC,  // { 0xEA, 0x78 } "黜"
  0x9EDE,  // { 0xEA, 0x79 } "點"
  0x9EDD,  // { 0xEA, 0x7A } "黝"
  0x9EE0,  // { 0xEA, 0x7B } "黠"
  0x9EE5,  // { 0xEA, 0x7C } "黥"
  0x9EE8,  // { 0xEA, 0x7D } "黨"
  0x9EEF,  // { 0xEA, 0x7E } "黯"
  0x9EF4,  // { 0xEA, 0x80 } "黴"
  0x9EF6,  // { 0xEA, 0x81 } "黶"
  0x9EF7,  // { 0xEA, 0x82 } "黷"
  0x9EF9,  // { 0xEA, 0x83 } "黹"
  0x9EFB,  // { 0xEA, 0x84 } "黻"
  0x9EFC,  // { 0xEA, 0x85 } "黼"
  0x9EFD,  // { 0xEA, 0x86 } "黽"
  0x9F07,  // { 0xEA, 0x87 } "鼇"
  0x9F08,  // { 0xEA, 0x88 } "鼈"
  0x76B7,  // { 0xEA, 0x89 } "皷"
  0x9F15,  // { 0xEA, 0x8A } "鼕"
  0x9F21,  // { 0xEA, 0x8B } "鼡"
  0x9F2C,  // { 0xEA, 0x8C } "鼬"
  0x9F3E,  // { 0xEA, 0x8D } "鼾"
  0x9F4A,  // { 0xEA, 0x8E } "齊"
  0x9F52,  // { 0xEA, 0x8F } "齒"
  0x9F54,  // { 0xEA, 0x90 } "齔"
  0x9F63,  // { 0xEA, 0x91 } "齣"
  0x9F5F,  // { 0xEA, 0x92 } "齟"
  0x9F60,  // { 0xEA, 0x93 } "齠"
  0x9F61,  // { 0xEA, 0x94 } "齡"
  0x9F66,  // { 0xEA, 0x95 } "齦"
  0x9F67,  // { 0xEA, 0x96 } "齧"
  0x9F6C,  // { 0xEA, 0x97 } "齬"
  0x9F6A,  // { 0xEA, 0x98 } "齪"
  0x9F77,  // { 0xEA, 0x99 } "齷"
  0x9F72,  // { 0xEA, 0x9A } "齲"
  0x9F76,  // { 0xEA, 0x9B } "齶"
  0x9F95,  // { 0xEA, 0x9C } "龕"
  0x9F9C,  // { 0xEA, 0x9D } "龜"
  0x9FA0,  // { 0xEA, 0x9E } "龠"
  0x582F,  // { 0xEA, 0x9F } "堯"
  0x69C7,  // { 0xEA, 0xA0 } "槇"
  0x9059,  // { 0xEA, 0xA1 } "遙"
  0x7464,  // { 0xEA, 0xA2 } "瑤"
  0x51DC,  // { 0xEA, 0xA3 } "凜"
  0x7199,  // { 0xEA, 0xA4 } "熙"
  0x0000,  // { 0xEA, 0xA5 }
  0x0000,  // { 0xEA, 0xA6 }
  0x0000,  // { 0xEA, 0xA7 }
  0x0000,  // { 0xEA, 0xA8 }
  0x0000,  // { 0xEA, 0xA9 }
  0x0000,  // { 0xEA, 0xAA }
  0x0000,  // { 0xEA, 0xAB }
  0x0000,  // { 0xEA, 0xAC }
  0x0000,  // { 0xEA, 0xAD }
  0x0000,  // { 0xEA, 0xAE }
  0x0000,  // { 0xEA, 0xAF }
  0x0000,  // { 0xEA, 0xB0 }
  0x0000,  // { 0xEA, 0xB1 }
  0x0000,  // { 0xEA, 0xB2 }
  0x0000,  // { 0xEA, 0xB3 }
  0x0000,  // { 0xEA, 0xB4 }
  0x0000,  // { 0xEA, 0xB5 }
  0x0000,  // { 0xEA, 0xB6 }
  0x0000,  // { 0xEA, 0xB7 }
  0x0000,  // { 0xEA, 0xB8 }
  0x0000,  // { 0xEA, 0xB9 }
  0x0000,  // { 0xEA, 0xBA }
  0x0000,  // { 0xEA, 0xBB }
  0x0000,  // { 0xEA, 0xBC }
  0x0000,  // { 0xEA, 0xBD }
  0x0000,  // { 0xEA, 0xBE }
  0x0000,  // { 0xEA, 0xBF }
  0x0000,  // { 0xEA, 0xC0 }
  0x0000,  // { 0xEA, 0xC1 }
  0x0000,  // { 0xEA, 0xC2 }
  0x0000,  // { 0xEA, 0xC3 }
  0x0000,  // { 0xEA, 0xC4 }
  0x0000,  // { 0xEA, 0xC5 }
  0x0000,  // { 0xEA, 0xC6 }
  0x0000,  // { 0xEA, 0xC7 }
  0x0000,  // { 0xEA, 0xC8 }
  0x0000,  // { 0xEA, 0xC9 }
  0x0000,  // { 0xEA, 0xCA }
  0x0000,  // { 0xEA, 0xCB }
  0x0000,  // { 0xEA, 0xCC }
  0x0000,  // { 0xEA, 0xCD }
  0x0000,  // { 0xEA, 0xCE }
  0x0000,  // { 0xEA, 0xCF }
  0x0000,  // { 0xEA, 0xD0 }
  0x0000,  // { 0xEA, 0xD1 }
  0x0000,  // { 0xEA, 0xD2 }
  0x0000,  // { 0xEA, 0xD3 }
  0x0000,  // { 0xEA, 0xD4 }
  0x0000,  // { 0xEA, 0xD5 }
  0x0000,  // { 0xEA, 0xD6 }
  0x0000,  // { 0xEA, 0xD7 }
  0x0000,  // { 0xEA, 0xD8 }
  0x0000,  // { 0xEA, 0xD9 }
  0x0000,  // { 0xEA, 0xDA }
  0x0000,  // { 0xEA, 0xDB }
  0x0000,  // { 0xEA, 0xDC }
  0x0000,  // { 0xEA, 0xDD }
  0x0000,  // { 0xEA, 0xDE }
  0x0000,  // { 0xEA, 0xDF }
  0x0000,  // { 0xEA, 0xE0 }
  0x0000,  // { 0xEA, 0xE1 }
  0x0000,  // { 0xEA, 0xE2 }
  0x0000,  // { 0xEA, 0xE3 }
  0x0000,  // { 0xEA, 0xE4 }
  0x0000,  // { 0xEA, 0xE5 }
  0x0000,  // { 0xEA, 0xE6 }
  0x0000,  // { 0xEA, 0xE7 }
  0x0000,  // { 0xEA, 0xE8 }
  0x0000,  // { 0xEA, 0xE9 }
  0x0000,  // { 0xEA, 0xEA }
  0x0000,  // { 0xEA, 0xEB }
  0x0000,  // { 0xEA, 0xEC }
  0x0000,  // { 0xEA, 0xED }
  0x0000,  // { 0xEA, 0xEE }
  0x0000,  // { 0xEA, 0xEF }
  0x0000,  // { 0xEA, 0xF0 }
  0x0000,  // { 0xEA, 0xF1 }
  0x0000,  // { 0xEA, 0xF2 }
  0x0000,  // { 0xEA, 0xF3 }
  0x0000,  // { 0xEA, 0xF4 }
  0x0000,  // { 0xEA, 0xF5 }
  0x0000,  // { 0xEA, 0xF6 }
  0x0000,  // { 0xEA, 0xF7 }
  0x0000,  // { 0xEA, 0xF8 }
  0x0000,  // { 0xEA, 0xF9 }
  0x0000,  // { 0xEA, 0xFA }
  0x0000,  // { 0xEA, 0xFB }
  0x0000,  // { 0xEA, 0xFC }
  0x0000,  // { 0xEA, 0xFD }
  0x0000,  // { 0xEA, 0xFE }
  0x0000,  // { 0xEA, 0xFF }
  0x0000,  // { 0xEB, 0x40 }
  0x0000,  // { 0xEB, 0x41 }
  0x0000,  // { 0xEB, 0x42 }
  0x0000,  // { 0xEB, 0x43 }
  0x0000,  // { 0xEB, 0x44 }
  0x0000,  // { 0xEB, 0x45 }
  0x0000,  // { 0xEB, 0x46 }
  0x0000,  // { 0xEB, 0x47 }
  0x0000,  // { 0xEB, 0x48 }
  0x0000,  // { 0xEB, 0x49 }
  0x0000,  // { 0xEB, 0x4A }
  0x0000,  // { 0xEB, 0x4B }
  0x0000,  // { 0xEB, 0x4C }
  0x0000,  // { 0xEB, 0x4D }
  0x0000,  // { 0xEB, 0x4E }
  0x0000,  // { 0xEB, 0x4F }
  0x0000,  // { 0xEB, 0x50 }
  0x0000,  // { 0xEB, 0x51 }
  0x0000,  // { 0xEB, 0x52 }
  0x0000,  // { 0xEB, 0x53 }
  0x0000,  // { 0xEB, 0x54 }
  0x0000,  // { 0xEB, 0x55 }
  0x0000,  // { 0xEB, 0x56 }
  0x0000,  // { 0xEB, 0x57 }
  0x0000,  // { 0xEB, 0x58 }
  0x0000,  // { 0xEB, 0x59 }
  0x0000,  // { 0xEB, 0x5A }
  0x0000,  // { 0xEB, 0x5B }
  0x0000,  // { 0xEB, 0x5C }
  0x0000,  // { 0xEB, 0x5D }
  0x0000,  // { 0xEB, 0x5E }
  0x0000,  // { 0xEB, 0x5F }
  0x0000,  // { 0xEB, 0x60 }
  0x0000,  // { 0xEB, 0x61 }
  0x0000,  // { 0xEB, 0x62 }
  0x0000,  // { 0xEB, 0x63 }
  0x0000,  // { 0xEB, 0x64 }
  0x0000,  // { 0xEB, 0x65 }
  0x0000,  // { 0xEB, 0x66 }
  0x0000,  // { 0xEB, 0x67 }
  0x0000,  // { 0xEB, 0x68 }
  0x0000,  // { 0xEB, 0x69 }
  0x0000,  // { 0xEB, 0x6A }
  0x0000,  // { 0xEB, 0x6B }
  0x0000,  // { 0xEB, 0x6C }
  0x0000,  // { 0xEB, 0x6D }
  0x0000,  // { 0xEB, 0x6E }
  0x0000,  // { 0xEB, 0x6F }
  0x0000,  // { 0xEB, 0x70 }
  0x0000,  // { 0xEB, 0x71 }
  0x0000,  // { 0xEB, 0x72 }
  0x0000,  // { 0xEB, 0x73 }
  0x0000,  // { 0xEB, 0x74 }
  0x0000,  // { 0xEB, 0x75 }
  0x0000,  // { 0xEB, 0x76 }
  0x0000,  // { 0xEB, 0x77 }
  0x0000,  // { 0xEB, 0x78 }
  0x0000,  // { 0xEB, 0x79 }
  0x0000,  // { 0xEB, 0x7A }
  0x0000,  // { 0xEB, 0x7B }
  0x0000,  // { 0xEB, 0x7C }
  0x0000,  // { 0xEB, 0x7D }
  0x0000,  // { 0xEB, 0x7E }
  0x0000,  // { 0xEB, 0x80 }
  0x0000,  // { 0xEB, 0x81 }
  0x0000,  // { 0xEB, 0x82 }
  0x0000,  // { 0xEB, 0x83 }
  0x0000,  // { 0xEB, 0x84 }
  0x0000,  // { 0xEB, 0x85 }
  0x0000,  // { 0xEB, 0x86 }
  0x0000,  // { 0xEB, 0x87 }
  0x0000,  // { 0xEB, 0x88 }
  0x0000,  // { 0xEB, 0x89 }
  0x0000,  // { 0xEB, 0x8A }
  0x0000,  // { 0xEB, 0x8B }
  0x0000,  // { 0xEB, 0x8C }
  0x0000,  // { 0xEB, 0x8D }
  0x0000,  // { 0xEB, 0x8E }
  0x0000,  // { 0xEB, 0x8F }
  0x0000,  // { 0xEB, 0x90 }
  0x0000,  // { 0xEB, 0x91 }
  0x0000,  // { 0xEB, 0x92 }
  0x0000,  // { 0xEB, 0x93 }
  0x0000,  // { 0xEB, 0x94 }
  0x0000,  // { 0xEB, 0x95 }
  0x0000,  // { 0xEB, 0x96 }
  0x0000,  // { 0xEB, 0x97 }
  0x0000,  // { 0xEB, 0x98 }
  0x0000,  // { 0xEB, 0x99 }
  0x0000,  // { 0xEB, 0x9A }
  0x0000,  // { 0xEB, 0x9B }
  0x0000,  // { 0xEB, 0x9C }
  0x0000,  // { 0xEB, 0x9D }
  0x0000,  // { 0xEB, 0x9E }
  0x0000,  // { 0xEB, 0x9F }
  0x0000,  // { 0xEB, 0xA0 }
  0x0000,  // { 0xEB, 0xA1 }
  0x0000,  // { 0xEB, 0xA2 }
  0x0000,  // { 0xEB, 0xA3 }
  0x0000,  // { 0xEB, 0xA4 }
  0x0000,  // { 0xEB, 0xA5 }
  0x0000,  // { 0xEB, 0xA6 }
  0x0000,  // { 0xEB, 0xA7 }
  0x0000,  // { 0xEB, 0xA8 }
  0x0000,  // { 0xEB, 0xA9 }
  0x0000,  // { 0xEB, 0xAA }
  0x0000,  // { 0xEB, 0xAB }
  0x0000,  // { 0xEB, 0xAC }
  0x0000,  // { 0xEB, 0xAD }
  0x0000,  // { 0xEB, 0xAE }
  0x0000,  // { 0xEB, 0xAF }
  0x0000,  // { 0xEB, 0xB0 }
  0x0000,  // { 0xEB, 0xB1 }
  0x0000,  // { 0xEB, 0xB2 }
  0x0000,  // { 0xEB, 0xB3 }
  0x0000,  // { 0xEB, 0xB4 }
  0x0000,  // { 0xEB, 0xB5 }
  0x0000,  // { 0xEB, 0xB6 }
  0x0000,  // { 0xEB, 0xB7 }
  0x0000,  // { 0xEB, 0xB8 }
  0x0000,  // { 0xEB, 0xB9 }
  0x0000,  // { 0xEB, 0xBA }
  0x0000,  // { 0xEB, 0xBB }
  0x0000,  // { 0xEB, 0xBC }
  0x0000,  // { 0xEB, 0xBD }
  0x0000,  // { 0xEB, 0xBE }
  0x0000,  // { 0xEB, 0xBF }
  0x0000,  // { 0xEB, 0xC0 }
  0x0000,  // { 0xEB, 0xC1 }
  0x0000,  // { 0xEB, 0xC2 }
  0x0000,  // { 0xEB, 0xC3 }
  0x0000,  // { 0xEB, 0xC4 }
  0x0000,  // { 0xEB, 0xC5 }
  0x0000,  // { 0xEB, 0xC6 }
  0x0000,  // { 0xEB, 0xC7 }
  0x0000,  // { 0xEB, 0xC8 }
  0x0000,  // { 0xEB, 0xC9 }
  0x0000,  // { 0xEB, 0xCA }
  0x0000,  // { 0xEB, 0xCB }
  0x0000,  // { 0xEB, 0xCC }
  0x0000,  // { 0xEB, 0xCD }
  0x0000,  // { 0xEB, 0xCE }
  0x0000,  // { 0xEB, 0xCF }
  0x0000,  // { 0xEB, 0xD0 }
  0x0000,  // { 0xEB, 0xD1 }
  0x0000,  // { 0xEB, 0xD2 }
  0x0000,  // { 0xEB, 0xD3 }
  0x0000,  // { 0xEB, 0xD4 }
  0x0000,  // { 0xEB, 0xD5 }
  0x0000,  // { 0xEB, 0xD6 }
  0x0000,  // { 0xEB, 0xD7 }
  0x0000,  // { 0xEB, 0xD8 }
  0x0000,  // { 0xEB, 0xD9 }
  0x0000,  // { 0xEB, 0xDA }
  0x0000,  // { 0xEB, 0xDB }
  0x0000,  // { 0xEB, 0xDC }
  0x0000,  // { 0xEB, 0xDD }
  0x0000,  // { 0xEB, 0xDE }
  0x0000,  // { 0xEB, 0xDF }
  0x0000,  // { 0xEB, 0xE0 }
  0x0000,  // { 0xEB, 0xE1 }
  0x0000,  // { 0xEB, 0xE2 }
  0x0000,  // { 0xEB, 0xE3 }
  0x0000,  // { 0xEB, 0xE4 }
  0x0000,  // { 0xEB, 0xE5 }
  0x0000,  // { 0xEB, 0xE6 }
  0x0000,  // { 0xEB, 0xE7 }
  0x0000,  // { 0xEB, 0xE8 }
  0x0000,  // { 0xEB, 0xE9 }
  0x0000,  // { 0xEB, 0xEA }
  0x0000,  // { 0xEB, 0xEB }
  0x0000,  // { 0xEB, 0xEC }
  0x0000,  // { 0xEB, 0xED }
  0x0000,  // { 0xEB, 0xEE }
  0x0000,  // { 0xEB, 0xEF }
  0x0000,  // { 0xEB, 0xF0 }
  0x0000,  // { 0xEB, 0xF1 }
  0x0000,  // { 0xEB, 0xF2 }
  0x0000,  // { 0xEB, 0xF3 }
  0x0000,  // { 0xEB, 0xF4 }
  0x0000,  // { 0xEB, 0xF5 }
  0x0000,  // { 0xEB, 0xF6 }
  0x0000,  // { 0xEB, 0xF7 }
  0x0000,  // { 0xEB, 0xF8 }
  0x0000,  // { 0xEB, 0xF9 }
  0x0000,  // { 0xEB, 0xFA }
  0x0000,  // { 0xEB, 0xFB }
  0x0000,  // { 0xEB, 0xFC }
  0x0000,  // { 0xEB, 0xFD }
  0x0000,  // { 0xEB, 0xFE }
  0x0000,  // { 0xEB, 0xFF }
  0x0000,  // { 0xEC, 0x40 }
  0x0000,  // { 0xEC, 0x41 }
  0x0000,  // { 0xEC, 0x42 }
  0x0000,  // { 0xEC, 0x43 }
  0x0000,  // { 0xEC, 0x44 }
  0x0000,  // { 0xEC, 0x45 }
  0x0000,  // { 0xEC, 0x46 }
  0x0000,  // { 0xEC, 0x47 }
  0x0000,  // { 0xEC, 0x48 }
  0x0000,  // { 0xEC, 0x49 }
  0x0000,  // { 0xEC, 0x4A }
  0x0000,  // { 0xEC, 0x4B }
  0x0000,  // { 0xEC, 0x4C }
  0x0000,  // { 0xEC, 0x4D }
  0x0000,  // { 0xEC, 0x4E }
  0x0000,  // { 0xEC, 0x4F }
  0x0000,  // { 0xEC, 0x50 }
  0x0000,  // { 0xEC, 0x51 }
  0x0000,  // { 0xEC, 0x52 }
  0x0000,  // { 0xEC, 0x53 }
  0x0000,  // { 0xEC, 0x54 }
  0x0000,  // { 0xEC, 0x55 }
  0x0000,  // { 0xEC, 0x56 }
  0x0000,  // { 0xEC, 0x57 }
  0x0000,  // { 0xEC, 0x58 }
  0x0000,  // { 0xEC, 0x59 }
  0x0000,  // { 0xEC, 0x5A }
  0x0000,  // { 0xEC, 0x5B }
  0x0000,  // { 0xEC, 0x5C }
  0x0000,  // { 0xEC, 0x5D }
  0x0000,  // { 0xEC, 0x5E }
  0x0000,  // { 0xEC, 0x5F }
  0x0000,  // { 0xEC, 0x60 }
  0x0000,  // { 0xEC, 0x61 }
  0x0000,  // { 0xEC, 0x62 }
  0x0000,  // { 0xEC, 0x63 }
  0x0000,  // { 0xEC, 0x64 }
  0x0000,  // { 0xEC, 0x65 }
  0x0000,  // { 0xEC, 0x66 }
  0x0000,  // { 0xEC, 0x67 }
  0x0000,  // { 0xEC, 0x68 }
  0x0000,  // { 0xEC, 0x69 }
  0x0000,  // { 0xEC, 0x6A }
  0x0000,  // { 0xEC, 0x6B }
  0x0000,  // { 0xEC, 0x6C }
  0x0000,  // { 0xEC, 0x6D }
  0x0000,  // { 0xEC, 0x6E }
  0x0000,  // { 0xEC, 0x6F }
  0x0000,  // { 0xEC, 0x70 }
  0x0000,  // { 0xEC, 0x71 }
  0x0000,  // { 0xEC, 0x72 }
  0x0000,  // { 0xEC, 0x73 }
  0x0000,  // { 0xEC, 0x74 }
  0x0000,  // { 0xEC, 0x75 }
  0x0000,  // { 0xEC, 0x76 }
  0x0000,  // { 0xEC, 0x77 }
  0x0000,  // { 0xEC, 0x78 }
  0x0000,  // { 0xEC, 0x79 }
  0x0000,  // { 0xEC, 0x7A }
  0x0000,  // { 0xEC, 0x7B }
  0x0000,  // { 0xEC, 0x7C }
  0x0000,  // { 0xEC, 0x7D }
  0x0000,  // { 0xEC, 0x7E }
  0x0000,  // { 0xEC, 0x80 }
  0x0000,  // { 0xEC, 0x81 }
  0x0000,  // { 0xEC, 0x82 }
  0x0000,  // { 0xEC, 0x83 }
  0x0000,  // { 0xEC, 0x84 }
  0x0000,  // { 0xEC, 0x85 }
  0x0000,  // { 0xEC, 0x86 }
  0x0000,  // { 0xEC, 0x87 }
  0x0000,  // { 0xEC, 0x88 }
  0x0000,  // { 0xEC, 0x89 }
  0x0000,  // { 0xEC, 0x8A }
  0x0000,  // { 0xEC, 0x8B }
  0x0000,  // { 0xEC, 0x8C }
  0x0000,  // { 0xEC, 0x8D }
  0x0000,  // { 0xEC, 0x8E }
  0x0000,  // { 0xEC, 0x8F }
  0x0000,  // { 0xEC, 0x90 }
  0x0000,  // { 0xEC, 0x91 }
  0x0000,  // { 0xEC, 0x92 }
  0x0000,  // { 0xEC, 0x93 }
  0x0000,  // { 0xEC, 0x94 }
  0x0000,  // { 0xEC, 0x95 }
  0x0000,  // { 0xEC, 0x96 }
  0x0000,  // { 0xEC, 0x97 }
  0x0000,  // { 0xEC, 0x98 }
  0x0000,  // { 0xEC, 0x99 }
  0x0000,  // { 0xEC, 0x9A }
  0x0000,  // { 0xEC, 0x9B }
  0x0000,  // { 0xEC, 0x9C }
  0x0000,  // { 0xEC, 0x9D }
  0x0000,  // { 0xEC, 0x9E }
  0x0000,  // { 0xEC, 0x9F }
  0x0000,  // { 0xEC, 0xA0 }
  0x0000,  // { 0xEC, 0xA1 }
  0x0000,  // { 0xEC, 0xA2 }
  0x0000,  // { 0xEC, 0xA3 }
  0x0000,  // { 0xEC, 0xA4 }
  0x0000,  // { 0xEC, 0xA5 }
  0x0000,  // { 0xEC, 0xA6 }
  0x0000,  // { 0xEC, 0xA7 }
  0x0000,  // { 0xEC, 0xA8 }
  0x0000,  // { 0xEC, 0xA9 }
  0x0000,  // { 0xEC, 0xAA }
  0x0000,  // { 0xEC, 0xAB }
  0x0000,  // { 0xEC, 0xAC }
  0x0000,  // { 0xEC, 0xAD }
  0x0000,  // { 0xEC, 0xAE }
  0x0000,  // { 0xEC, 0xAF }
  0x0000,  // { 0xEC, 0xB0 }
  0x0000,  // { 0xEC, 0xB1 }
  0x0000,  // { 0xEC, 0xB2 }
  0x0000,  // { 0xEC, 0xB3 }
  0x0000,  // { 0xEC, 0xB4 }
  0x0000,  // { 0xEC, 0xB5 }
  0x0000,  // { 0xEC, 0xB6 }
  0x0000,  // { 0xEC, 0xB7 }
  0x0000,  // { 0xEC, 0xB8 }
  0x0000,  // { 0xEC, 0xB9 }
  0x0000,  // { 0xEC, 0xBA }
  0x0000,  // { 0xEC, 0xBB }
  0x0000,  // { 0xEC, 0xBC }
  0x0000,  // { 0xEC, 0xBD }
  0x0000,  // { 0xEC, 0xBE }
  0x0000,  // { 0xEC, 0xBF }
  0x0000,  // { 0xEC, 0xC0 }
  0x0000,  // { 0xEC, 0xC1 }
  0x0000,  // { 0xEC, 0xC2 }
  0x0000,  // { 0xEC, 0xC3 }
  0x0000,  // { 0xEC, 0xC4 }
  0x0000,  // { 0xEC, 0xC5 }
  0x0000,  // { 0xEC, 0xC6 }
  0x0000,  // { 0xEC, 0xC7 }
  0x0000,  // { 0xEC, 0xC8 }
  0x0000,  // { 0xEC, 0xC9 }
  0x0000,  // { 0xEC, 0xCA }
  0x0000,  // { 0xEC, 0xCB }
  0x0000,  // { 0xEC, 0xCC }
  0x0000,  // { 0xEC, 0xCD }
  0x0000,  // { 0xEC, 0xCE }
  0x0000,  // { 0xEC, 0xCF }
  0x0000,  // { 0xEC, 0xD0 }
  0x0000,  // { 0xEC, 0xD1 }
  0x0000,  // { 0xEC, 0xD2 }
  0x0000,  // { 0xEC, 0xD3 }
  0x0000,  // { 0xEC, 0xD4 }
  0x0000,  // { 0xEC, 0xD5 }
  0x0000,  // { 0xEC, 0xD6 }
  0x0000,  // { 0xEC, 0xD7 }
  0x0000,  // { 0xEC, 0xD8 }
  0x0000,  // { 0xEC, 0xD9 }
  0x0000,  // { 0xEC, 0xDA }
  0x0000,  // { 0xEC, 0xDB }
  0x0000,  // { 0xEC, 0xDC }
  0x0000,  // { 0xEC, 0xDD }
  0x0000,  // { 0xEC, 0xDE }
  0x0000,  // { 0xEC, 0xDF }
  0x0000,  // { 0xEC, 0xE0 }
  0x0000,  // { 0xEC, 0xE1 }
  0x0000,  // { 0xEC, 0xE2 }
  0x0000,  // { 0xEC, 0xE3 }
  0x0000,  // { 0xEC, 0xE4 }
  0x0000,  // { 0xEC, 0xE5 }
  0x0000,  // { 0xEC, 0xE6 }
  0x0000,  // { 0xEC, 0xE7 }
  0x0000,  // { 0xEC, 0xE8 }
  0x0000,  // { 0xEC, 0xE9 }
  0x0000,  // { 0xEC, 0xEA }
  0x0000,  // { 0xEC, 0xEB }
  0x0000,  // { 0xEC, 0xEC }
  0x0000,  // { 0xEC, 0xED }
  0x0000,  // { 0xEC, 0xEE }
  0x0000,  // { 0xEC, 0xEF }
  0x0000,  // { 0xEC, 0xF0 }
  0x0000,  // { 0xEC, 0xF1 }
  0x0000,  // { 0xEC, 0xF2 }
  0x0000,  // { 0xEC, 0xF3 }
  0x0000,  // { 0xEC, 0xF4 }
  0x0000,  // { 0xEC, 0xF5 }
  0x0000,  // { 0xEC, 0xF6 }
  0x0000,  // { 0xEC, 0xF7 }
  0x0000,  // { 0xEC, 0xF8 }
  0x0000,  // { 0xEC, 0xF9 }
  0x0000,  // { 0xEC, 0xFA }
  0x0000,  // { 0xEC, 0xFB }
  0x0000,  // { 0xEC, 0xFC }
  0x0000,  // { 0xEC, 0xFD }
  0x0000,  // { 0xEC, 0xFE }
  0x0000,  // { 0xEC, 0xFF }
  0x7E8A,  // { 0xED, 0x40 } "纊"
  0x891C,  // { 0xED, 0x41 } "褜"
  0x9348,  // { 0xED, 0x42 } "鍈"
  0x9288,  // { 0xED, 0x43 } "銈"
  0x84DC,  // { 0xED, 0x44 } "蓜"
  0x4FC9,  // { 0xED, 0x45 } "俉"
  0x70BB,  // { 0xED, 0x46 } "炻"
  0x6631,  // { 0xED, 0x47 } "昱"
  0x68C8,  // { 0xED, 0x48 } "棈"
  0x92F9,  // { 0xED, 0x49 } "鋹"
  0x66FB,  // { 0xED, 0x4A } "曻"
  0x5F45,  // { 0xED, 0x4B } "彅"
  0x4E28,  // { 0xED, 0x4C } "丨"
  0x4EE1,  // { 0xED, 0x4D } "仡"
  0x4EFC,  // { 0xED, 0x4E } "仼"
  0x4F00,  // { 0xED, 0x4F } "伀"
  0x4F03,  // { 0xED, 0x50 } "伃"
  0x4F39,  // { 0xED, 0x51 } "伹"
  0x4F56,  // { 0xED, 0x52 } "佖"
  0x4F92,  // { 0xED, 0x53 } "侒"
  0x4F8A,  // { 0xED, 0x54 } "侊"
  0x4F9A,  // { 0xED, 0x55 } "侚"
  0x4F94,  // { 0xED, 0x56 } "侔"
  0x4FCD,  // { 0xED, 0x57 } "俍"
  0x5040,  // { 0xED, 0x58 } "偀"
  0x5022,  // { 0xED, 0x59 } "倢"
  0x4FFF,  // { 0xED, 0x5A } "俿"
  0x501E,  // { 0xED, 0x5B } "倞"
  0x5046,  // { 0xED, 0x5C } "偆"
  0x5070,  // { 0xED, 0x5D } "偰"
  0x5042,  // { 0xED, 0x5E } "偂"
  0x5094,  // { 0xED, 0x5F } "傔"
  0x50F4,  // { 0xED, 0x60 } "僴"
  0x50D8,  // { 0xED, 0x61 } "僘"
  0x514A,  // { 0xED, 0x62 } "兊"
  0x5164,  // { 0xED, 0x63 } "兤"
  0x519D,  // { 0xED, 0x64 } "冝"
  0x51BE,  // { 0xED, 0x65 } "冾"
  0x51EC,  // { 0xED, 0x66 } "凬"
  0x5215,  // { 0xED, 0x67 } "刕"
  0x529C,  // { 0xED, 0x68 } "劜"
  0x52A6,  // { 0xED, 0x69 } "劦"
  0x52C0,  // { 0xED, 0x6A } "勀"
  0x52DB,  // { 0xED, 0x6B } "勛"
  0x5300,  // { 0xED, 0x6C } "匀"
  0x5307,  // { 0xED, 0x6D } "匇"
  0x5324,  // { 0xED, 0x6E } "匤"
  0x5372,  // { 0xED, 0x6F } "卲"
  0x5393,  // { 0xED, 0x70 } "厓"
  0x53B2,  // { 0xED, 0x71 } "厲"
  0x53DD,  // { 0xED, 0x72 } "叝"
  0xFA0E,  // { 0xED, 0x73 } "﨎"
  0x549C,  // { 0xED, 0x74 } "咜"
  0x548A,  // { 0xED, 0x75 } "咊"
  0x54A9,  // { 0xED, 0x76 } "咩"
  0x54FF,  // { 0xED, 0x77 } "哿"
  0x5586,  // { 0xED, 0x78 } "喆"
  0x5759,  // { 0xED, 0x79 } "坙"
  0x5765,  // { 0xED, 0x7A } "坥"
  0x57AC,  // { 0xED, 0x7B } "垬"
  0x57C8,  // { 0xED, 0x7C } "埈"
  0x57C7,  // { 0xED, 0x7D } "埇"
  0xFA0F,  // { 0xED, 0x7E } "﨏"
  0xFA10,  // { 0xED, 0x80 } "塚"
  0x589E,  // { 0xED, 0x81 } "增"
  0x58B2,  // { 0xED, 0x82 } "墲"
  0x590B,  // { 0xED, 0x83 } "夋"
  0x5953,  // { 0xED, 0x84 } "奓"
  0x595B,  // { 0xED, 0x85 } "奛"
  0x595D,  // { 0xED, 0x86 } "奝"
  0x5963,  // { 0xED, 0x87 } "奣"
  0x59A4,  // { 0xED, 0x88 } "妤"
  0x59BA,  // { 0xED, 0x89 } "妺"
  0x5B56,  // { 0xED, 0x8A } "孖"
  0x5BC0,  // { 0xED, 0x8B } "寀"
  0x752F,  // { 0xED, 0x8C } "甯"
  0x5BD8,  // { 0xED, 0x8D } "寘"
  0x5BEC,  // { 0xED, 0x8E } "寬"
  0x5C1E,  // { 0xED, 0x8F } "尞"
  0x5CA6,  // { 0xED, 0x90 } "岦"
  0x5CBA,  // { 0xED, 0x91 } "岺"
  0x5CF5,  // { 0xED, 0x92 } "峵"
  0x5D27,  // { 0xED, 0x93 } "崧"
  0x5D53,  // { 0xED, 0x94 } "嵓"
  0xFA11,  // { 0xED, 0x95 } "﨑"
  0x5D42,  // { 0xED, 0x96 } "嵂"
  0x5D6D,  // { 0xED, 0x97 } "嵭"
  0x5DB8,  // { 0xED, 0x98 } "嶸"
  0x5DB9,  // { 0xED, 0x99 } "嶹"
  0x5DD0,  // { 0xED, 0x9A } "巐"
  0x5F21,  // { 0xED, 0x9B } "弡"
  0x5F34,  // { 0xED, 0x9C } "弴"
  0x5F67,  // { 0xED, 0x9D } "彧"
  0x5FB7,  // { 0xED, 0x9E } "德"
  0x5FDE,  // { 0xED, 0x9F } "忞"
  0x605D,  // { 0xED, 0xA0 } "恝"
  0x6085,  // { 0xED, 0xA1 } "悅"
  0x608A,  // { 0xED, 0xA2 } "悊"
  0x60DE,  // { 0xED, 0xA3 } "惞"
  0x60D5,  // { 0xED, 0xA4 } "惕"
  0x6120,  // { 0xED, 0xA5 } "愠"
  0x60F2,  // { 0xED, 0xA6 } "惲"
  0x6111,  // { 0xED, 0xA7 } "愑"
  0x6137,  // { 0xED, 0xA8 } "愷"
  0x6130,  // { 0xED, 0xA9 } "愰"
  0x6198,  // { 0xED, 0xAA } "憘"
  0x6213,  // { 0xED, 0xAB } "戓"
  0x62A6,  // { 0xED, 0xAC } "抦"
  0x63F5,  // { 0xED, 0xAD } "揵"
  0x6460,  // { 0xED, 0xAE } "摠"
  0x649D,  // { 0xED, 0xAF } "撝"
  0x64CE,  // { 0xED, 0xB0 } "擎"
  0x654E,  // { 0xED, 0xB1 } "敎"
  0x6600,  // { 0xED, 0xB2 } "昀"
  0x6615,  // { 0xED, 0xB3 } "昕"
  0x663B,  // { 0xED, 0xB4 } "昻"
  0x6609,  // { 0xED, 0xB5 } "昉"
  0x662E,  // { 0xED, 0xB6 } "昮"
  0x661E,  // { 0xED, 0xB7 } "昞"
  0x6624,  // { 0xED, 0xB8 } "昤"
  0x6665,  // { 0xED, 0xB9 } "晥"
  0x6657,  // { 0xED, 0xBA } "晗"
  0x6659,  // { 0xED, 0xBB } "晙"
  0xFA12,  // { 0xED, 0xBC } "晴"
  0x6673,  // { 0xED, 0xBD } "晳"
  0x6699,  // { 0xED, 0xBE } "暙"
  0x66A0,  // { 0xED, 0xBF } "暠"
  0x66B2,  // { 0xED, 0xC0 } "暲"
  0x66BF,  // { 0xED, 0xC1 } "暿"
  0x66FA,  // { 0xED, 0xC2 } "曺"
  0x670E,  // { 0xED, 0xC3 } "朎"
  0xF929,  // { 0xED, 0xC4 } "朗"
  0x6766,  // { 0xED, 0xC5 } "杦"
  0x67BB,  // { 0xED, 0xC6 } "枻"
  0x6852,  // { 0xED, 0xC7 } "桒"
  0x67C0,  // { 0xED, 0xC8 } "柀"
  0x6801,  // { 0xED, 0xC9 } "栁"
  0x6844,  // { 0xED, 0xCA } "桄"
  0x68CF,  // { 0xED, 0xCB } "棏"
  0xFA13,  // { 0xED, 0xCC } "﨓"
  0x6968,  // { 0xED, 0xCD } "楨"
  0xFA14,  // { 0xED, 0xCE } "﨔"
  0x6998,  // { 0xED, 0xCF } "榘"
  0x69E2,  // { 0xED, 0xD0 } "槢"
  0x6A30,  // { 0xED, 0xD1 } "樰"
  0x6A6B,  // { 0xED, 0xD2 } "橫"
  0x6A46,  // { 0xED, 0xD3 } "橆"
  0x6A73,  // { 0xED, 0xD4 } "橳"
  0x6A7E,  // { 0xED, 0xD5 } "橾"
  0x6AE2,  // { 0xED, 0xD6 } "櫢"
  0x6AE4,  // { 0xED, 0xD7 } "櫤"
  0x6BD6,  // { 0xED, 0xD8 } "毖"
  0x6C3F,  // { 0xED, 0xD9 } "氿"
  0x6C5C,  // { 0xED, 0xDA } "汜"
  0x6C86,  // { 0xED, 0xDB } "沆"
  0x6C6F,  // { 0xED, 0xDC } "汯"
  0x6CDA,  // { 0xED, 0xDD } "泚"
  0x6D04,  // { 0xED, 0xDE } "洄"
  0x6D87,  // { 0xED, 0xDF } "涇"
  0x6D6F,  // { 0xED, 0xE0 } "浯"
  0x6D96,  // { 0xED, 0xE1 } "涖"
  0x6DAC,  // { 0xED, 0xE2 } "涬"
  0x6DCF,  // { 0xED, 0xE3 } "淏"
  0x6DF8,  // { 0xED, 0xE4 } "淸"
  0x6DF2,  // { 0xED, 0xE5 } "淲"
  0x6DFC,  // { 0xED, 0xE6 } "淼"
  0x6E39,  // { 0xED, 0xE7 } "渹"
  0x6E5C,  // { 0xED, 0xE8 } "湜"
  0x6E27,  // { 0xED, 0xE9 } "渧"
  0x6E3C,  // { 0xED, 0xEA } "渼"
  0x6EBF,  // { 0xED, 0xEB } "溿"
  0x6F88,  // { 0xED, 0xEC } "澈"
  0x6FB5,  // { 0xED, 0xED } "澵"
  0x6FF5,  // { 0xED, 0xEE } "濵"
  0x7005,  // { 0xED, 0xEF } "瀅"
  0x7007,  // { 0xED, 0xF0 } "瀇"
  0x7028,  // { 0xED, 0xF1 } "瀨"
  0x7085,  // { 0xED, 0xF2 } "炅"
  0x70AB,  // { 0xED, 0xF3 } "炫"
  0x710F,  // { 0xED, 0xF4 } "焏"
  0x7104,  // { 0xED, 0xF5 } "焄"
  0x715C,  // { 0xED, 0xF6 } "煜"
  0x7146,  // { 0xED, 0xF7 } "煆"
  0x7147,  // { 0xED, 0xF8 } "煇"
  0xFA15,  // { 0xED, 0xF9 } "凞"
  0x71C1,  // { 0xED, 0xFA } "燁"
  0x71FE,  // { 0xED, 0xFB } "燾"
  0x72B1,  // { 0xED, 0xFC } "犱"
  0x0000,  // { 0xED, 0xFD }
  0x0000,  // { 0xED, 0xFE }
  0x0000,  // { 0xED, 0xFF }
  0x72BE,  // { 0xEE, 0x40 } "犾"
  0x7324,  // { 0xEE, 0x41 } "猤"
  0xFA16,  // { 0xEE, 0x42 } "猪"
  0x7377,  // { 0xEE, 0x43 } "獷"
  0x73BD,  // { 0xEE, 0x44 } "玽"
  0x73C9,  // { 0xEE, 0x45 } "珉"
  0x73D6,  // { 0xEE, 0x46 } "珖"
  0x73E3,  // { 0xEE, 0x47 } "珣"
  0x73D2,  // { 0xEE, 0x48 } "珒"
  0x7407,  // { 0xEE, 0x49 } "琇"
  0x73F5,  // { 0xEE, 0x4A } "珵"
  0x7426,  // { 0xEE, 0x4B } "琦"
  0x742A,  // { 0xEE, 0x4C } "琪"
  0x7429,  // { 0xEE, 0x4D } "琩"
  0x742E,  // { 0xEE, 0x4E } "琮"
  0x7462,  // { 0xEE, 0x4F } "瑢"
  0x7489,  // { 0xEE, 0x50 } "璉"
  0x749F,  // { 0xEE, 0x51 } "璟"
  0x7501,  // { 0xEE, 0x52 } "甁"
  0x756F,  // { 0xEE, 0x53 } "畯"
  0x7682,  // { 0xEE, 0x54 } "皂"
  0x769C,  // { 0xEE, 0x55 } "皜"
  0x769E,  // { 0xEE, 0x56 } "皞"
  0x769B,  // { 0xEE, 0x57 } "皛"
  0x76A6,  // { 0xEE, 0x58 } "皦"
  0xFA17,  // { 0xEE, 0x59 } "益"
  0x7746,  // { 0xEE, 0x5A } "睆"
  0x52AF,  // { 0xEE, 0x5B } "劯"
  0x7821,  // { 0xEE, 0x5C } "砡"
  0x784E,  // { 0xEE, 0x5D } "硎"
  0x7864,  // { 0xEE, 0x5E } "硤"
  0x787A,  // { 0xEE, 0x5F } "硺"
  0x7930,  // { 0xEE, 0x60 } "礰"
  0xFA18,  // { 0xEE, 0x61 } "礼"
  0xFA19,  // { 0xEE, 0x62 } "神"
  0xFA1A,  // { 0xEE, 0x63 } "祥"
  0x7994,  // { 0xEE, 0x64 } "禔"
  0xFA1B,  // { 0xEE, 0x65 } "福"
  0x799B,  // { 0xEE, 0x66 } "禛"
  0x7AD1,  // { 0xEE, 0x67 } "竑"
  0x7AE7,  // { 0xEE, 0x68 } "竧"
  0xFA1C,  // { 0xEE, 0x69 } "靖"
  0x7AEB,  // { 0xEE, 0x6A } "竫"
  0x7B9E,  // { 0xEE, 0x6B } "箞"
  0xFA1D,  // { 0xEE, 0x6C } "精"
  0x7D48,  // { 0xEE, 0x6D } "絈"
  0x7D5C,  // { 0xEE, 0x6E } "絜"
  0x7DB7,  // { 0xEE, 0x6F } "綷"
  0x7DA0,  // { 0xEE, 0x70 } "綠"
  0x7DD6,  // { 0xEE, 0x71 } "緖"
  0x7E52,  // { 0xEE, 0x72 } "繒"
  0x7F47,  // { 0xEE, 0x73 } "罇"
  0x7FA1,  // { 0xEE, 0x74 } "羡"
  0xFA1E,  // { 0xEE, 0x75 } "羽"
  0x8301,  // { 0xEE, 0x76 } "茁"
  0x8362,  // { 0xEE, 0x77 } "荢"
  0x837F,  // { 0xEE, 0x78 } "荿"
  0x83C7,  // { 0xEE, 0x79 } "菇"
  0x83F6,  // { 0xEE, 0x7A } "菶"
  0x8448,  // { 0xEE, 0x7B } "葈"
  0x84B4,  // { 0xEE, 0x7C } "蒴"
  0x8553,  // { 0xEE, 0x7D } "蕓"
  0x8559,  // { 0xEE, 0x7E } "蕙"
  0x856B,  // { 0xEE, 0x80 } "蕫"
  0xFA1F,  // { 0xEE, 0x81 } "﨟"
  0x85B0,  // { 0xEE, 0x82 } "薰"
  0xFA20,  // { 0xEE, 0x83 } "蘒"
  0xFA21,  // { 0xEE, 0x84 } "﨡"
  0x8807,  // { 0xEE, 0x85 } "蠇"
  0x88F5,  // { 0xEE, 0x86 } "裵"
  0x8A12,  // { 0xEE, 0x87 } "訒"
  0x8A37,  // { 0xEE, 0x88 } "訷"
  0x8A79,  // { 0xEE, 0x89 } "詹"
  0x8AA7,  // { 0xEE, 0x8A } "誧"
  0x8ABE,  // { 0xEE, 0x8B } "誾"
  0x8ADF,  // { 0xEE, 0x8C } "諟"
  0xFA22,  // { 0xEE, 0x8D } "諸"
  0x8AF6,  // { 0xEE, 0x8E } "諶"
  0x8B53,  // { 0xEE, 0x8F } "譓"
  0x8B7F,  // { 0xEE, 0x90 } "譿"
  0x8CF0,  // { 0xEE, 0x91 } "賰"
  0x8CF4,  // { 0xEE, 0x92 } "賴"
  0x8D12,  // { 0xEE, 0x93 } "贒"
  0x8D76,  // { 0xEE, 0x94 } "赶"
  0xFA23,  // { 0xEE, 0x95 } "﨣"
  0x8ECF,  // { 0xEE, 0x96 } "軏"
  0xFA24,  // { 0xEE, 0x97 } "﨤"
  0xFA25,  // { 0xEE, 0x98 } "逸"
  0x9067,  // { 0xEE, 0x99 } "遧"
  0x90DE,  // { 0xEE, 0x9A } "郞"
  0xFA26,  // { 0xEE, 0x9B } "都"
  0x9115,  // { 0xEE, 0x9C } "鄕"
  0x9127,  // { 0xEE, 0x9D } "鄧"
  0x91DA,  // { 0xEE, 0x9E } "釚"
  0x91D7,  // { 0xEE, 0x9F } "釗"
  0x91DE,  // { 0xEE, 0xA0 } "釞"
  0x91ED,  // { 0xEE, 0xA1 } "釭"
  0x91EE,  // { 0xEE, 0xA2 } "釮"
  0x91E4,  // { 0xEE, 0xA3 } "釤"
  0x91E5,  // { 0xEE, 0xA4 } "釥"
  0x9206,  // { 0xEE, 0xA5 } "鈆"
  0x9210,  // { 0xEE, 0xA6 } "鈐"
  0x920A,  // { 0xEE, 0xA7 } "鈊"
  0x923A,  // { 0xEE, 0xA8 } "鈺"
  0x9240,  // { 0xEE, 0xA9 } "鉀"
  0x923C,  // { 0xEE, 0xAA } "鈼"
  0x924E,  // { 0xEE, 0xAB } "鉎"
  0x9259,  // { 0xEE, 0xAC } "鉙"
  0x9251,  // { 0xEE, 0xAD } "鉑"
  0x9239,  // { 0xEE, 0xAE } "鈹"
  0x9267,  // { 0xEE, 0xAF } "鉧"
  0x92A7,  // { 0xEE, 0xB0 } "銧"
  0x9277,  // { 0xEE, 0xB1 } "鉷"
  0x9278,  // { 0xEE, 0xB2 } "鉸"
  0x92E7,  // { 0xEE, 0xB3 } "鋧"
  0x92D7,  // { 0xEE, 0xB4 } "鋗"
  0x92D9,  // { 0xEE, 0xB5 } "鋙"
  0x92D0,  // { 0xEE, 0xB6 } "鋐"
  0xFA27,  // { 0xEE, 0xB7 } "﨧"
  0x92D5,  // { 0xEE, 0xB8 } "鋕"
  0x92E0,  // { 0xEE, 0xB9 } "鋠"
  0x92D3,  // { 0xEE, 0xBA } "鋓"
  0x9325,  // { 0xEE, 0xBB } "錥"
  0x9321,  // { 0xEE, 0xBC } "錡"
  0x92FB,  // { 0xEE, 0xBD } "鋻"
  0xFA28,  // { 0xEE, 0xBE } "﨨"
  0x931E,  // { 0xEE, 0xBF } "錞"
  0x92FF,  // { 0xEE, 0xC0 } "鋿"
  0x931D,  // { 0xEE, 0xC1 } "錝"
  0x9302,  // { 0xEE, 0xC2 } "錂"
  0x9370,  // { 0xEE, 0xC3 } "鍰"
  0x9357,  // { 0xEE, 0xC4 } "鍗"
  0x93A4,  // { 0xEE, 0xC5 } "鎤"
  0x93C6,  // { 0xEE, 0xC6 } "鏆"
  0x93DE,  // { 0xEE, 0xC7 } "鏞"
  0x93F8,  // { 0xEE, 0xC8 } "鏸"
  0x9431,  // { 0xEE, 0xC9 } "鐱"
  0x9445,  // { 0xEE, 0xCA } "鑅"
  0x9448,  // { 0xEE, 0xCB } "鑈"
  0x9592,  // { 0xEE, 0xCC } "閒"
  0xF9DC,  // { 0xEE, 0xCD } "隆"
  0xFA29,  // { 0xEE, 0xCE } "﨩"
  0x969D,  // { 0xEE, 0xCF } "隝"
  0x96AF,  // { 0xEE, 0xD0 } "隯"
  0x9733,  // { 0xEE, 0xD1 } "霳"
  0x973B,  // { 0xEE, 0xD2 } "霻"
  0x9743,  // { 0xEE, 0xD3 } "靃"
  0x974D,  // { 0xEE, 0xD4 } "靍"
  0x974F,  // { 0xEE, 0xD5 } "靏"
  0x9751,  // { 0xEE, 0xD6 } "靑"
  0x9755,  // { 0xEE, 0xD7 } "靕"
  0x9857,  // { 0xEE, 0xD8 } "顗"
  0x9865,  // { 0xEE, 0xD9 } "顥"
  0xFA2A,  // { 0xEE, 0xDA } "飯"
  0xFA2B,  // { 0xEE, 0xDB } "飼"
  0x9927,  // { 0xEE, 0xDC } "餧"
  0xFA2C,  // { 0xEE, 0xDD } "館"
  0x999E,  // { 0xEE, 0xDE } "馞"
  0x9A4E,  // { 0xEE, 0xDF } "驎"
  0x9AD9,  // { 0xEE, 0xE0 } "髙"
  0x9ADC,  // { 0xEE, 0xE1 } "髜"
  0x9B75,  // { 0xEE, 0xE2 } "魵"
  0x9B72,  // { 0xEE, 0xE3 } "魲"
  0x9B8F,  // { 0xEE, 0xE4 } "鮏"
  0x9BB1,  // { 0xEE, 0xE5 } "鮱"
  0x9BBB,  // { 0xEE, 0xE6 } "鮻"
  0x9C00,  // { 0xEE, 0xE7 } "鰀"
  0x9D70,  // { 0xEE, 0xE8 } "鵰"
  0x9D6B,  // { 0xEE, 0xE9 } "鵫"
  0xFA2D,  // { 0xEE, 0xEA } "鶴"
  0x9E19,  // { 0xEE, 0xEB } "鸙"
  0x9ED1,  // { 0xEE, 0xEC } "黑"
  0x0000,  // { 0xEE, 0xED }
  0x0000,  // { 0xEE, 0xEE }
  0x2170,  // { 0xEE, 0xEF } "ⅰ"
  0x2171,  // { 0xEE, 0xF0 } "ⅱ"
  0x2172,  // { 0xEE, 0xF1 } "ⅲ"
  0x2173,  // { 0xEE, 0xF2 } "ⅳ"
  0x2174,  // { 0xEE, 0xF3 } "ⅴ"
  0x2175,  // { 0xEE, 0xF4 } "ⅵ"
  0x2176,  // { 0xEE, 0xF5 } "ⅶ"
  0x2177,  // { 0xEE, 0xF6 } "ⅷ"
  0x2178,  // { 0xEE, 0xF7 } "ⅸ"
  0x2179,  // { 0xEE, 0xF8 } "ⅹ"
  0xFFE2,  // { 0xEE, 0xF9 } "￢"
  0xFFE4,  // { 0xEE, 0xFA } "￤"
  0xFF07,  // { 0xEE, 0xFB } "＇"
  0xFF02,  // { 0xEE, 0xFC } "＂"
  0x0000,  // { 0xEE, 0xFD }
  0x0000,  // { 0xEE, 0xFE }
  0x0000,  // { 0xEE, 0xFF }
  0x0000,  // { 0xEF, 0x40 }
  0x0000,  // { 0xEF, 0x41 }
  0x0000,  // { 0xEF, 0x42 }
  0x0000,  // { 0xEF, 0x43 }
  0x0000,  // { 0xEF, 0x44 }
  0x0000,  // { 0xEF, 0x45 }
  0x0000,  // { 0xEF, 0x46 }
  0x0000,  // { 0xEF, 0x47 }
  0x0000,  // { 0xEF, 0x48 }
  0x0000,  // { 0xEF, 0x49 }
  0x0000,  // { 0xEF, 0x4A }
  0x0000,  // { 0xEF, 0x4B }
  0x0000,  // { 0xEF, 0x4C }
  0x0000,  // { 0xEF, 0x4D }
  0x0000,  // { 0xEF, 0x4E }
  0x0000,  // { 0xEF, 0x4F }
  0x0000,  // { 0xEF, 0x50 }
  0x0000,  // { 0xEF, 0x51 }
  0x0000,  // { 0xEF, 0x52 }
  0x0000,  // { 0xEF, 0x53 }
  0x0000,  // { 0xEF, 0x54 }
  0x0000,  // { 0xEF, 0x55 }
  0x0000,  // { 0xEF, 0x56 }
  0x0000,  // { 0xEF, 0x57 }
  0x0000,  // { 0xEF, 0x58 }
  0x0000,  // { 0xEF, 0x59 }
  0x0000,  // { 0xEF, 0x5A }
  0x0000,  // { 0xEF, 0x5B }
  0x0000,  // { 0xEF, 0x5C }
  0x0000,  // { 0xEF, 0x5D }
  0x0000,  // { 0xEF, 0x5E }
  0x0000,  // { 0xEF, 0x5F }
  0x0000,  // { 0xEF, 0x60 }
  0x0000,  // { 0xEF, 0x61 }
  0x0000,  // { 0xEF, 0x62 }
  0x0000,  // { 0xEF, 0x63 }
  0x0000,  // { 0xEF, 0x64 }
  0x0000,  // { 0xEF, 0x65 }
  0x0000,  // { 0xEF, 0x66 }
  0x0000,  // { 0xEF, 0x67 }
  0x0000,  // { 0xEF, 0x68 }
  0x0000,  // { 0xEF, 0x69 }
  0x0000,  // { 0xEF, 0x6A }
  0x0000,  // { 0xEF, 0x6B }
  0x0000,  // { 0xEF, 0x6C }
  0x0000,  // { 0xEF, 0x6D }
  0x0000,  // { 0xEF, 0x6E }
  0x0000,  // { 0xEF, 0x6F }
  0x0000,  // { 0xEF, 0x70 }
  0x0000,  // { 0xEF, 0x71 }
  0x0000,  // { 0xEF, 0x72 }
  0x0000,  // { 0xEF, 0x73 }
  0x0000,  // { 0xEF, 0x74 }
  0x0000,  // { 0xEF, 0x75 }
  0x0000,  // { 0xEF, 0x76 }
  0x0000,  // { 0xEF, 0x77 }
  0x0000,  // { 0xEF, 0x78 }
  0x0000,  // { 0xEF, 0x79 }
  0x0000,  // { 0xEF, 0x7A }
  0x0000,  // { 0xEF, 0x7B }
  0x0000,  // { 0xEF, 0x7C }
  0x0000,  // { 0xEF, 0x7D }
  0x0000,  // { 0xEF, 0x7E }
  0x0000,  // { 0xEF, 0x80 }
  0x0000,  // { 0xEF, 0x81 }
  0x0000,  // { 0xEF, 0x82 }
  0x0000,  // { 0xEF, 0x83 }
  0x0000,  // { 0xEF, 0x84 }
  0x0000,  // { 0xEF, 0x85 }
  0x0000,  // { 0xEF, 0x86 }
  0x0000,  // { 0xEF, 0x87 }
  0x0000,  // { 0xEF, 0x88 }
  0x0000,  // { 0xEF, 0x89 }
  0x0000,  // { 0xEF, 0x8A }
  0x0000,  // { 0xEF, 0x8B }
  0x0000,  // { 0xEF, 0x8C }
  0x0000,  // { 0xEF, 0x8D }
  0x0000,  // { 0xEF, 0x8E }
  0x0000,  // { 0xEF, 0x8F }
  0x0000,  // { 0xEF, 0x90 }
  0x0000,  // { 0xEF, 0x91 }
  0x0000,  // { 0xEF, 0x92 }
  0x0000,  // { 0xEF, 0x93 }
  0x0000,  // { 0xEF, 0x94 }
  0x0000,  // { 0xEF, 0x95 }
  0x0000,  // { 0xEF, 0x96 }
  0x0000,  // { 0xEF, 0x97 }
  0x0000,  // { 0xEF, 0x98 }
  0x0000,  // { 0xEF, 0x99 }
  0x0000,  // { 0xEF, 0x9A }
  0x0000,  // { 0xEF, 0x9B }
  0x0000,  // { 0xEF, 0x9C }
  0x0000,  // { 0xEF, 0x9D }
  0x0000,  // { 0xEF, 0x9E }
  0x0000,  // { 0xEF, 0x9F }
  0x0000,  // { 0xEF, 0xA0 }
  0x0000,  // { 0xEF, 0xA1 }
  0x0000,  // { 0xEF, 0xA2 }
  0x0000,  // { 0xEF, 0xA3 }
  0x0000,  // { 0xEF, 0xA4 }
  0x0000,  // { 0xEF, 0xA5 }
  0x0000,  // { 0xEF, 0xA6 }
  0x0000,  // { 0xEF, 0xA7 }
  0x0000,  // { 0xEF, 0xA8 }
  0x0000,  // { 0xEF, 0xA9 }
  0x0000,  // { 0xEF, 0xAA }
  0x0000,  // { 0xEF, 0xAB }
  0x0000,  // { 0xEF, 0xAC }
  0x0000,  // { 0xEF, 0xAD }
  0x0000,  // { 0xEF, 0xAE }
  0x0000,  // { 0xEF, 0xAF }
  0x0000,  // { 0xEF, 0xB0 }
  0x0000,  // { 0xEF, 0xB1 }
  0x0000,  // { 0xEF, 0xB2 }
  0x0000,  // { 0xEF, 0xB3 }
  0x0000,  // { 0xEF, 0xB4 }
  0x0000,  // { 0xEF, 0xB5 }
  0x0000,  // { 0xEF, 0xB6 }
  0x0000,  // { 0xEF, 0xB7 }
  0x0000,  // { 0xEF, 0xB8 }
  0x0000,  // { 0xEF, 0xB9 }
  0x0000,  // { 0xEF, 0xBA }
  0x0000,  // { 0xEF, 0xBB }
  0x0000,  // { 0xEF, 0xBC }
  0x0000,  // { 0xEF, 0xBD }
  0x0000,  // { 0xEF, 0xBE }
  0x0000,  // { 0xEF, 0xBF }
  0x0000,  // { 0xEF, 0xC0 }
  0x0000,  // { 0xEF, 0xC1 }
  0x0000,  // { 0xEF, 0xC2 }
  0x0000,  // { 0xEF, 0xC3 }
  0x0000,  // { 0xEF, 0xC4 }
  0x0000,  // { 0xEF, 0xC5 }
  0x0000,  // { 0xEF, 0xC6 }
  0x0000,  // { 0xEF, 0xC7 }
  0x0000,  // { 0xEF, 0xC8 }
  0x0000,  // { 0xEF, 0xC9 }
  0x0000,  // { 0xEF, 0xCA }
  0x0000,  // { 0xEF, 0xCB }
  0x0000,  // { 0xEF, 0xCC }
  0x0000,  // { 0xEF, 0xCD }
  0x0000,  // { 0xEF, 0xCE }
  0x0000,  // { 0xEF, 0xCF }
  0x0000,  // { 0xEF, 0xD0 }
  0x0000,  // { 0xEF, 0xD1 }
  0x0000,  // { 0xEF, 0xD2 }
  0x0000,  // { 0xEF, 0xD3 }
  0x0000,  // { 0xEF, 0xD4 }
  0x0000,  // { 0xEF, 0xD5 }
  0x0000,  // { 0xEF, 0xD6 }
  0x0000,  // { 0xEF, 0xD7 }
  0x0000,  // { 0xEF, 0xD8 }
  0x0000,  // { 0xEF, 0xD9 }
  0x0000,  // { 0xEF, 0xDA }
  0x0000,  // { 0xEF, 0xDB }
  0x0000,  // { 0xEF, 0xDC }
  0x0000,  // { 0xEF, 0xDD }
  0x0000,  // { 0xEF, 0xDE }
  0x0000,  // { 0xEF, 0xDF }
  0x0000,  // { 0xEF, 0xE0 }
  0x0000,  // { 0xEF, 0xE1 }
  0x0000,  // { 0xEF, 0xE2 }
  0x0000,  // { 0xEF, 0xE3 }
  0x0000,  // { 0xEF, 0xE4 }
  0x0000,  // { 0xEF, 0xE5 }
  0x0000,  // { 0xEF, 0xE6 }
  0x0000,  // { 0xEF, 0xE7 }
  0x0000,  // { 0xEF, 0xE8 }
  0x0000,  // { 0xEF, 0xE9 }
  0x0000,  // { 0xEF, 0xEA }
  0x0000,  // { 0xEF, 0xEB }
  0x0000,  // { 0xEF, 0xEC }
  0x0000,  // { 0xEF, 0xED }
  0x0000,  // { 0xEF, 0xEE }
  0x0000,  // { 0xEF, 0xEF }
  0x0000,  // { 0xEF, 0xF0 }
  0x0000,  // { 0xEF, 0xF1 }
  0x0000,  // { 0xEF, 0xF2 }
  0x0000,  // { 0xEF, 0xF3 }
  0x0000,  // { 0xEF, 0xF4 }
  0x0000,  // { 0xEF, 0xF5 }
  0x0000,  // { 0xEF, 0xF6 }
  0x0000,  // { 0xEF, 0xF7 }
  0x0000,  // { 0xEF, 0xF8 }
  0x0000,  // { 0xEF, 0xF9 }
  0x0000,  // { 0xEF, 0xFA }
  0x0000,  // { 0xEF, 0xFB }
  0x0000,  // { 0xEF, 0xFC }
  0x0000,  // { 0xEF, 0xFD }
  0x0000,  // { 0xEF, 0xFE }
  0x0000,  // { 0xEF, 0xFF }
  0xE000,  // { 0xF0, 0x40 } PUA
  0xE001,  // { 0xF0, 0x41 } PUA
  0xE002,  // { 0xF0, 0x42 } PUA
  0xE003,  // { 0xF0, 0x43 } PUA
  0xE004,  // { 0xF0, 0x44 } PUA
  0xE005,  // { 0xF0, 0x45 } PUA
  0xE006,  // { 0xF0, 0x46 } PUA
  0xE007,  // { 0xF0, 0x47 } PUA
  0xE008,  // { 0xF0, 0x48 } PUA
  0xE009,  // { 0xF0, 0x49 } PUA
  0xE00A,  // { 0xF0, 0x4A } PUA
  0xE00B,  // { 0xF0, 0x4B } PUA
  0xE00C,  // { 0xF0, 0x4C } PUA
  0xE00D,  // { 0xF0, 0x4D } PUA
  0xE00E,  // { 0xF0, 0x4E } PUA
  0xE00F,  // { 0xF0, 0x4F } PUA
  0xE010,  // { 0xF0, 0x50 } PUA
  0xE011,  // { 0xF0, 0x51 } PUA
  0xE012,  // { 0xF0, 0x52 } PUA
  0xE013,  // { 0xF0, 0x53 } PUA
  0xE014,  // { 0xF0, 0x54 } PUA
  0xE015,  // { 0xF0, 0x55 } PUA
  0xE016,  // { 0xF0, 0x56 } PUA
  0xE017,  // { 0xF0, 0x57 } PUA
  0xE018,  // { 0xF0, 0x58 } PUA
  0xE019,  // { 0xF0, 0x59 } PUA
  0xE01A,  // { 0xF0, 0x5A } PUA
  0xE01B,  // { 0xF0, 0x5B } PUA
  0xE01C,  // { 0xF0, 0x5C } PUA
  0xE01D,  // { 0xF0, 0x5D } PUA
  0xE01E,  // { 0xF0, 0x5E } PUA
  0xE01F,  // { 0xF0, 0x5F } PUA
  0xE020,  // { 0xF0, 0x60 } PUA
  0xE021,  // { 0xF0, 0x61 } PUA
  0xE022,  // { 0xF0, 0x62 } PUA
  0xE023,  // { 0xF0, 0x63 } PUA
  0xE024,  // { 0xF0, 0x64 } PUA
  0xE025,  // { 0xF0, 0x65 } PUA
  0xE026,  // { 0xF0, 0x66 } PUA
  0xE027,  // { 0xF0, 0x67 } PUA
  0xE028,  // { 0xF0, 0x68 } PUA
  0xE029,  // { 0xF0, 0x69 } PUA
  0xE02A,  // { 0xF0, 0x6A } PUA
  0xE02B,  // { 0xF0, 0x6B } PUA
  0xE02C,  // { 0xF0, 0x6C } PUA
  0xE02D,  // { 0xF0, 0x6D } PUA
  0xE02E,  // { 0xF0, 0x6E } PUA
  0xE02F,  // { 0xF0, 0x6F } PUA
  0xE030,  // { 0xF0, 0x70 } PUA
  0xE031,  // { 0xF0, 0x71 } PUA
  0xE032,  // { 0xF0, 0x72 } PUA
  0xE033,  // { 0xF0, 0x73 } PUA
  0xE034,  // { 0xF0, 0x74 } PUA
  0xE035,  // { 0xF0, 0x75 } PUA
  0xE036,  // { 0xF0, 0x76 } PUA
  0xE037,  // { 0xF0, 0x77 } PUA
  0xE038,  // { 0xF0, 0x78 } PUA
  0xE039,  // { 0xF0, 0x79 } PUA
  0xE03A,  // { 0xF0, 0x7A } PUA
  0xE03B,  // { 0xF0, 0x7B } PUA
  0xE03C,  // { 0xF0, 0x7C } PUA
  0xE03D,  // { 0xF0, 0x7D } PUA
  0xE03E,  // { 0xF0, 0x7E } PUA
  0xE03F,  // { 0xF0, 0x80 } PUA
  0xE040,  // { 0xF0, 0x81 } PUA
  0xE041,  // { 0xF0, 0x82 } PUA
  0xE042,  // { 0xF0, 0x83 } PUA
  0xE043,  // { 0xF0, 0x84 } PUA
  0xE044,  // { 0xF0, 0x85 } PUA
  0xE045,  // { 0xF0, 0x86 } PUA
  0xE046,  // { 0xF0, 0x87 } PUA
  0xE047,  // { 0xF0, 0x88 } PUA
  0xE048,  // { 0xF0, 0x89 } PUA
  0xE049,  // { 0xF0, 0x8A } PUA
  0xE04A,  // { 0xF0, 0x8B } PUA
  0xE04B,  // { 0xF0, 0x8C } PUA
  0xE04C,  // { 0xF0, 0x8D } PUA
  0xE04D,  // { 0xF0, 0x8E } PUA
  0xE04E,  // { 0xF0, 0x8F } PUA
  0xE04F,  // { 0xF0, 0x90 } PUA
  0xE050,  // { 0xF0, 0x91 } PUA
  0xE051,  // { 0xF0, 0x92 } PUA
  0xE052,  // { 0xF0, 0x93 } PUA
  0xE053,  // { 0xF0, 0x94 } PUA
  0xE054,  // { 0xF0, 0x95 } PUA
  0xE055,  // { 0xF0, 0x96 } PUA
  0xE056,  // { 0xF0, 0x97 } PUA
  0xE057,  // { 0xF0, 0x98 } PUA
  0xE058,  // { 0xF0, 0x99 } PUA
  0xE059,  // { 0xF0, 0x9A } PUA
  0xE05A,  // { 0xF0, 0x9B } PUA
  0xE05B,  // { 0xF0, 0x9C } PUA
  0xE05C,  // { 0xF0, 0x9D } PUA
  0xE05D,  // { 0xF0, 0x9E } PUA
  0xE05E,  // { 0xF0, 0x9F } PUA
  0xE05F,  // { 0xF0, 0xA0 } PUA
  0xE060,  // { 0xF0, 0xA1 } PUA
  0xE061,  // { 0xF0, 0xA2 } PUA
  0xE062,  // { 0xF0, 0xA3 } PUA
  0xE063,  // { 0xF0, 0xA4 } PUA
  0xE064,  // { 0xF0, 0xA5 } PUA
  0xE065,  // { 0xF0, 0xA6 } PUA
  0xE066,  // { 0xF0, 0xA7 } PUA
  0xE067,  // { 0xF0, 0xA8 } PUA
  0xE068,  // { 0xF0, 0xA9 } PUA
  0xE069,  // { 0xF0, 0xAA } PUA
  0xE06A,  // { 0xF0, 0xAB } PUA
  0xE06B,  // { 0xF0, 0xAC } PUA
  0xE06C,  // { 0xF0, 0xAD } PUA
  0xE06D,  // { 0xF0, 0xAE } PUA
  0xE06E,  // { 0xF0, 0xAF } PUA
  0xE06F,  // { 0xF0, 0xB0 } PUA
  0xE070,  // { 0xF0, 0xB1 } PUA
  0xE071,  // { 0xF0, 0xB2 } PUA
  0xE072,  // { 0xF0, 0xB3 } PUA
  0xE073,  // { 0xF0, 0xB4 } PUA
  0xE074,  // { 0xF0, 0xB5 } PUA
  0xE075,  // { 0xF0, 0xB6 } PUA
  0xE076,  // { 0xF0, 0xB7 } PUA
  0xE077,  // { 0xF0, 0xB8 } PUA
  0xE078,  // { 0xF0, 0xB9 } PUA
  0xE079,  // { 0xF0, 0xBA } PUA
  0xE07A,  // { 0xF0, 0xBB } PUA
  0xE07B,  // { 0xF0, 0xBC } PUA
  0xE07C,  // { 0xF0, 0xBD } PUA
  0xE07D,  // { 0xF0, 0xBE } PUA
  0xE07E,  // { 0xF0, 0xBF } PUA
  0xE07F,  // { 0xF0, 0xC0 } PUA
  0xE080,  // { 0xF0, 0xC1 } PUA
  0xE081,  // { 0xF0, 0xC2 } PUA
  0xE082,  // { 0xF0, 0xC3 } PUA
  0xE083,  // { 0xF0, 0xC4 } PUA
  0xE084,  // { 0xF0, 0xC5 } PUA
  0xE085,  // { 0xF0, 0xC6 } PUA
  0xE086,  // { 0xF0, 0xC7 } PUA
  0xE087,  // { 0xF0, 0xC8 } PUA
  0xE088,  // { 0xF0, 0xC9 } PUA
  0xE089,  // { 0xF0, 0xCA } PUA
  0xE08A,  // { 0xF0, 0xCB } PUA
  0xE08B,  // { 0xF0, 0xCC } PUA
  0xE08C,  // { 0xF0, 0xCD } PUA
  0xE08D,  // { 0xF0, 0xCE } PUA
  0xE08E,  // { 0xF0, 0xCF } PUA
  0xE08F,  // { 0xF0, 0xD0 } PUA
  0xE090,  // { 0xF0, 0xD1 } PUA
  0xE091,  // { 0xF0, 0xD2 } PUA
  0xE092,  // { 0xF0, 0xD3 } PUA
  0xE093,  // { 0xF0, 0xD4 } PUA
  0xE094,  // { 0xF0, 0xD5 } PUA
  0xE095,  // { 0xF0, 0xD6 } PUA
  0xE096,  // { 0xF0, 0xD7 } PUA
  0xE097,  // { 0xF0, 0xD8 } PUA
  0xE098,  // { 0xF0, 0xD9 } PUA
  0xE099,  // { 0xF0, 0xDA } PUA
  0xE09A,  // { 0xF0, 0xDB } PUA
  0xE09B,  // { 0xF0, 0xDC } PUA
  0xE09C,  // { 0xF0, 0xDD } PUA
  0xE09D,  // { 0xF0, 0xDE } PUA
  0xE09E,  // { 0xF0, 0xDF } PUA
  0xE09F,  // { 0xF0, 0xE0 } PUA
  0xE0A0,  // { 0xF0, 0xE1 } PUA
  0xE0A1,  // { 0xF0, 0xE2 } PUA
  0xE0A2,  // { 0xF0, 0xE3 } PUA
  0xE0A3,  // { 0xF0, 0xE4 } PUA
  0xE0A4,  // { 0xF0, 0xE5 } PUA
  0xE0A5,  // { 0xF0, 0xE6 } PUA
  0xE0A6,  // { 0xF0, 0xE7 } PUA
  0xE0A7,  // { 0xF0, 0xE8 } PUA
  0xE0A8,  // { 0xF0, 0xE9 } PUA
  0xE0A9,  // { 0xF0, 0xEA } PUA
  0xE0AA,  // { 0xF0, 0xEB } PUA
  0xE0AB,  // { 0xF0, 0xEC } PUA
  0xE0AC,  // { 0xF0, 0xED } PUA
  0xE0AD,  // { 0xF0, 0xEE } PUA
  0xE0AE,  // { 0xF0, 0xEF } PUA
  0xE0AF,  // { 0xF0, 0xF0 } PUA
  0xE0B0,  // { 0xF0, 0xF1 } PUA
  0xE0B1,  // { 0xF0, 0xF2 } PUA
  0xE0B2,  // { 0xF0, 0xF3 } PUA
  0xE0B3,  // { 0xF0, 0xF4 } PUA
  0xE0B4,  // { 0xF0, 0xF5 } PUA
  0xE0B5,  // { 0xF0, 0xF6 } PUA
  0xE0B6,  // { 0xF0, 0xF7 } PUA
  0xE0B7,  // { 0xF0, 0xF8 } PUA
  0xE0B8,  // { 0xF0, 0xF9 } PUA
  0xE0B9,  // { 0xF0, 0xFA } PUA
  0xE0BA,  // { 0xF0, 0xFB } PUA
  0xE0BB,  // { 0xF0, 0xFC } PUA
  0x0000,  // { 0xF0, 0xFD }
  0x0000,  // { 0xF0, 0xFE }
  0x0000,  // { 0xF0, 0xFF }
  0xE0BC,  // { 0xF1, 0x40 } PUA
  0xE0BD,  // { 0xF1, 0x41 } PUA
  0xE0BE,  // { 0xF1, 0x42 } PUA
  0xE0BF,  // { 0xF1, 0x43 } PUA
  0xE0C0,  // { 0xF1, 0x44 } PUA
  0xE0C1,  // { 0xF1, 0x45 } PUA
  0xE0C2,  // { 0xF1, 0x46 } PUA
  0xE0C3,  // { 0xF1, 0x47 } PUA
  0xE0C4,  // { 0xF1, 0x48 } PUA
  0xE0C5,  // { 0xF1, 0x49 } PUA
  0xE0C6,  // { 0xF1, 0x4A } PUA
  0xE0C7,  // { 0xF1, 0x4B } PUA
  0xE0C8,  // { 0xF1, 0x4C } PUA
  0xE0C9,  // { 0xF1, 0x4D } PUA
  0xE0CA,  // { 0xF1, 0x4E } PUA
  0xE0CB,  // { 0xF1, 0x4F } PUA
  0xE0CC,  // { 0xF1, 0x50 } PUA
  0xE0CD,  // { 0xF1, 0x51 } PUA
  0xE0CE,  // { 0xF1, 0x52 } PUA
  0xE0CF,  // { 0xF1, 0x53 } PUA
  0xE0D0,  // { 0xF1, 0x54 } PUA
  0xE0D1,  // { 0xF1, 0x55 } PUA
  0xE0D2,  // { 0xF1, 0x56 } PUA
  0xE0D3,  // { 0xF1, 0x57 } PUA
  0xE0D4,  // { 0xF1, 0x58 } PUA
  0xE0D5,  // { 0xF1, 0x59 } PUA
  0xE0D6,  // { 0xF1, 0x5A } PUA
  0xE0D7,  // { 0xF1, 0x5B } PUA
  0xE0D8,  // { 0xF1, 0x5C } PUA
  0xE0D9,  // { 0xF1, 0x5D } PUA
  0xE0DA,  // { 0xF1, 0x5E } PUA
  0xE0DB,  // { 0xF1, 0x5F } PUA
  0xE0DC,  // { 0xF1, 0x60 } PUA
  0xE0DD,  // { 0xF1, 0x61 } PUA
  0xE0DE,  // { 0xF1, 0x62 } PUA
  0xE0DF,  // { 0xF1, 0x63 } PUA
  0xE0E0,  // { 0xF1, 0x64 } PUA
  0xE0E1,  // { 0xF1, 0x65 } PUA
  0xE0E2,  // { 0xF1, 0x66 } PUA
  0xE0E3,  // { 0xF1, 0x67 } PUA
  0xE0E4,  // { 0xF1, 0x68 } PUA
  0xE0E5,  // { 0xF1, 0x69 } PUA
  0xE0E6,  // { 0xF1, 0x6A } PUA
  0xE0E7,  // { 0xF1, 0x6B } PUA
  0xE0E8,  // { 0xF1, 0x6C } PUA
  0xE0E9,  // { 0xF1, 0x6D } PUA
  0xE0EA,  // { 0xF1, 0x6E } PUA
  0xE0EB,  // { 0xF1, 0x6F } PUA
  0xE0EC,  // { 0xF1, 0x70 } PUA
  0xE0ED,  // { 0xF1, 0x71 } PUA
  0xE0EE,  // { 0xF1, 0x72 } PUA
  0xE0EF,  // { 0xF1, 0x73 } PUA
  0xE0F0,  // { 0xF1, 0x74 } PUA
  0xE0F1,  // { 0xF1, 0x75 } PUA
  0xE0F2,  // { 0xF1, 0x76 } PUA
  0xE0F3,  // { 0xF1, 0x77 } PUA
  0xE0F4,  // { 0xF1, 0x78 } PUA
  0xE0F5,  // { 0xF1, 0x79 } PUA
  0xE0F6,  // { 0xF1, 0x7A } PUA
  0xE0F7,  // { 0xF1, 0x7B } PUA
  0xE0F8,  // { 0xF1, 0x7C } PUA
  0xE0F9,  // { 0xF1, 0x7D } PUA
  0xE0FA,  // { 0xF1, 0x7E } PUA
  0xE0FB,  // { 0xF1, 0x80 } PUA
  0xE0FC,  // { 0xF1, 0x81 } PUA
  0xE0FD,  // { 0xF1, 0x82 } PUA
  0xE0FE,  // { 0xF1, 0x83 } PUA
  0xE0FF,  // { 0xF1, 0x84 } PUA
  0xE100,  // { 0xF1, 0x85 } PUA
  0xE101,  // { 0xF1, 0x86 } PUA
  0xE102,  // { 0xF1, 0x87 } PUA
  0xE103,  // { 0xF1, 0x88 } PUA
  0xE104,  // { 0xF1, 0x89 } PUA
  0xE105,  // { 0xF1, 0x8A } PUA
  0xE106,  // { 0xF1, 0x8B } PUA
  0xE107,  // { 0xF1, 0x8C } PUA
  0xE108,  // { 0xF1, 0x8D } PUA
  0xE109,  // { 0xF1, 0x8E } PUA
  0xE10A,  // { 0xF1, 0x8F } PUA
  0xE10B,  // { 0xF1, 0x90 } PUA
  0xE10C,  // { 0xF1, 0x91 } PUA
  0xE10D,  // { 0xF1, 0x92 } PUA
  0xE10E,  // { 0xF1, 0x93 } PUA
  0xE10F,  // { 0xF1, 0x94 } PUA
  0xE110,  // { 0xF1, 0x95 } PUA
  0xE111,  // { 0xF1, 0x96 } PUA
  0xE112,  // { 0xF1, 0x97 } PUA
  0xE113,  // { 0xF1, 0x98 } PUA
  0xE114,  // { 0xF1, 0x99 } PUA
  0xE115,  // { 0xF1, 0x9A } PUA
  0xE116,  // { 0xF1, 0x9B } PUA
  0xE117,  // { 0xF1, 0x9C } PUA
  0xE118,  // { 0xF1, 0x9D } PUA
  0xE119,  // { 0xF1, 0x9E } PUA
  0xE11A,  // { 0xF1, 0x9F } PUA
  0xE11B,  // { 0xF1, 0xA0 } PUA
  0xE11C,  // { 0xF1, 0xA1 } PUA
  0xE11D,  // { 0xF1, 0xA2 } PUA
  0xE11E,  // { 0xF1, 0xA3 } PUA
  0xE11F,  // { 0xF1, 0xA4 } PUA
  0xE120,  // { 0xF1, 0xA5 } PUA
  0xE121,  // { 0xF1, 0xA6 } PUA
  0xE122,  // { 0xF1, 0xA7 } PUA
  0xE123,  // { 0xF1, 0xA8 } PUA
  0xE124,  // { 0xF1, 0xA9 } PUA
  0xE125,  // { 0xF1, 0xAA } PUA
  0xE126,  // { 0xF1, 0xAB } PUA
  0xE127,  // { 0xF1, 0xAC } PUA
  0xE128,  // { 0xF1, 0xAD } PUA
  0xE129,  // { 0xF1, 0xAE } PUA
  0xE12A,  // { 0xF1, 0xAF } PUA
  0xE12B,  // { 0xF1, 0xB0 } PUA
  0xE12C,  // { 0xF1, 0xB1 } PUA
  0xE12D,  // { 0xF1, 0xB2 } PUA
  0xE12E,  // { 0xF1, 0xB3 } PUA
  0xE12F,  // { 0xF1, 0xB4 } PUA
  0xE130,  // { 0xF1, 0xB5 } PUA
  0xE131,  // { 0xF1, 0xB6 } PUA
  0xE132,  // { 0xF1, 0xB7 } PUA
  0xE133,  // { 0xF1, 0xB8 } PUA
  0xE134,  // { 0xF1, 0xB9 } PUA
  0xE135,  // { 0xF1, 0xBA } PUA
  0xE136,  // { 0xF1, 0xBB } PUA
  0xE137,  // { 0xF1, 0xBC } PUA
  0xE138,  // { 0xF1, 0xBD } PUA
  0xE139,  // { 0xF1, 0xBE } PUA
  0xE13A,  // { 0xF1, 0xBF } PUA
  0xE13B,  // { 0xF1, 0xC0 } PUA
  0xE13C,  // { 0xF1, 0xC1 } PUA
  0xE13D,  // { 0xF1, 0xC2 } PUA
  0xE13E,  // { 0xF1, 0xC3 } PUA
  0xE13F,  // { 0xF1, 0xC4 } PUA
  0xE140,  // { 0xF1, 0xC5 } PUA
  0xE141,  // { 0xF1, 0xC6 } PUA
  0xE142,  // { 0xF1, 0xC7 } PUA
  0xE143,  // { 0xF1, 0xC8 } PUA
  0xE144,  // { 0xF1, 0xC9 } PUA
  0xE145,  // { 0xF1, 0xCA } PUA
  0xE146,  // { 0xF1, 0xCB } PUA
  0xE147,  // { 0xF1, 0xCC } PUA
  0xE148,  // { 0xF1, 0xCD } PUA
  0xE149,  // { 0xF1, 0xCE } PUA
  0xE14A,  // { 0xF1, 0xCF } PUA
  0xE14B,  // { 0xF1, 0xD0 } PUA
  0xE14C,  // { 0xF1, 0xD1 } PUA
  0xE14D,  // { 0xF1, 0xD2 } PUA
  0xE14E,  // { 0xF1, 0xD3 } PUA
  0xE14F,  // { 0xF1, 0xD4 } PUA
  0xE150,  // { 0xF1, 0xD5 } PUA
  0xE151,  // { 0xF1, 0xD6 } PUA
  0xE152,  // { 0xF1, 0xD7 } PUA
  0xE153,  // { 0xF1, 0xD8 } PUA
  0xE154,  // { 0xF1, 0xD9 } PUA
  0xE155,  // { 0xF1, 0xDA } PUA
  0xE156,  // { 0xF1, 0xDB } PUA
  0xE157,  // { 0xF1, 0xDC } PUA
  0xE158,  // { 0xF1, 0xDD } PUA
  0xE159,  // { 0xF1, 0xDE } PUA
  0xE15A,  // { 0xF1, 0xDF } PUA
  0xE15B,  // { 0xF1, 0xE0 } PUA
  0xE15C,  // { 0xF1, 0xE1 } PUA
  0xE15D,  // { 0xF1, 0xE2 } PUA
  0xE15E,  // { 0xF1, 0xE3 } PUA
  0xE15F,  // { 0xF1, 0xE4 } PUA
  0xE160,  // { 0xF1, 0xE5 } PUA
  0xE161,  // { 0xF1, 0xE6 } PUA
  0xE162,  // { 0xF1, 0xE7 } PUA
  0xE163,  // { 0xF1, 0xE8 } PUA
  0xE164,  // { 0xF1, 0xE9 } PUA
  0xE165,  // { 0xF1, 0xEA } PUA
  0xE166,  // { 0xF1, 0xEB } PUA
  0xE167,  // { 0xF1, 0xEC } PUA
  0xE168,  // { 0xF1, 0xED } PUA
  0xE169,  // { 0xF1, 0xEE } PUA
  0xE16A,  // { 0xF1, 0xEF } PUA
  0xE16B,  // { 0xF1, 0xF0 } PUA
  0xE16C,  // { 0xF1, 0xF1 } PUA
  0xE16D,  // { 0xF1, 0xF2 } PUA
  0xE16E,  // { 0xF1, 0xF3 } PUA
  0xE16F,  // { 0xF1, 0xF4 } PUA
  0xE170,  // { 0xF1, 0xF5 } PUA
  0xE171,  // { 0xF1, 0xF6 } PUA
  0xE172,  // { 0xF1, 0xF7 } PUA
  0xE173,  // { 0xF1, 0xF8 } PUA
  0xE174,  // { 0xF1, 0xF9 } PUA
  0xE175,  // { 0xF1, 0xFA } PUA
  0xE176,  // { 0xF1, 0xFB } PUA
  0xE177,  // { 0xF1, 0xFC } PUA
  0x0000,  // { 0xF1, 0xFD }
  0x0000,  // { 0xF1, 0xFE }
  0x0000,  // { 0xF1, 0xFF }
  0xE178,  // { 0xF2, 0x40 } PUA
  0xE179,  // { 0xF2, 0x41 } PUA
  0xE17A,  // { 0xF2, 0x42 } PUA
  0xE17B,  // { 0xF2, 0x43 } PUA
  0xE17C,  // { 0xF2, 0x44 } PUA
  0xE17D,  // { 0xF2, 0x45 } PUA
  0xE17E,  // { 0xF2, 0x46 } PUA
  0xE17F,  // { 0xF2, 0x47 } PUA
  0xE180,  // { 0xF2, 0x48 } PUA
  0xE181,  // { 0xF2, 0x49 } PUA
  0xE182,  // { 0xF2, 0x4A } PUA
  0xE183,  // { 0xF2, 0x4B } PUA
  0xE184,  // { 0xF2, 0x4C } PUA
  0xE185,  // { 0xF2, 0x4D } PUA
  0xE186,  // { 0xF2, 0x4E } PUA
  0xE187,  // { 0xF2, 0x4F } PUA
  0xE188,  // { 0xF2, 0x50 } PUA
  0xE189,  // { 0xF2, 0x51 } PUA
  0xE18A,  // { 0xF2, 0x52 } PUA
  0xE18B,  // { 0xF2, 0x53 } PUA
  0xE18C,  // { 0xF2, 0x54 } PUA
  0xE18D,  // { 0xF2, 0x55 } PUA
  0xE18E,  // { 0xF2, 0x56 } PUA
  0xE18F,  // { 0xF2, 0x57 } PUA
  0xE190,  // { 0xF2, 0x58 } PUA
  0xE191,  // { 0xF2, 0x59 } PUA
  0xE192,  // { 0xF2, 0x5A } PUA
  0xE193,  // { 0xF2, 0x5B } PUA
  0xE194,  // { 0xF2, 0x5C } PUA
  0xE195,  // { 0xF2, 0x5D } PUA
  0xE196,  // { 0xF2, 0x5E } PUA
  0xE197,  // { 0xF2, 0x5F } PUA
  0xE198,  // { 0xF2, 0x60 } PUA
  0xE199,  // { 0xF2, 0x61 } PUA
  0xE19A,  // { 0xF2, 0x62 } PUA
  0xE19B,  // { 0xF2, 0x63 } PUA
  0xE19C,  // { 0xF2, 0x64 } PUA
  0xE19D,  // { 0xF2, 0x65 } PUA
  0xE19E,  // { 0xF2, 0x66 } PUA
  0xE19F,  // { 0xF2, 0x67 } PUA
  0xE1A0,  // { 0xF2, 0x68 } PUA
  0xE1A1,  // { 0xF2, 0x69 } PUA
  0xE1A2,  // { 0xF2, 0x6A } PUA
  0xE1A3,  // { 0xF2, 0x6B } PUA
  0xE1A4,  // { 0xF2, 0x6C } PUA
  0xE1A5,  // { 0xF2, 0x6D } PUA
  0xE1A6,  // { 0xF2, 0x6E } PUA
  0xE1A7,  // { 0xF2, 0x6F } PUA
  0xE1A8,  // { 0xF2, 0x70 } PUA
  0xE1A9,  // { 0xF2, 0x71 } PUA
  0xE1AA,  // { 0xF2, 0x72 } PUA
  0xE1AB,  // { 0xF2, 0x73 } PUA
  0xE1AC,  // { 0xF2, 0x74 } PUA
  0xE1AD,  // { 0xF2, 0x75 } PUA
  0xE1AE,  // { 0xF2, 0x76 } PUA
  0xE1AF,  // { 0xF2, 0x77 } PUA
  0xE1B0,  // { 0xF2, 0x78 } PUA
  0xE1B1,  // { 0xF2, 0x79 } PUA
  0xE1B2,  // { 0xF2, 0x7A } PUA
  0xE1B3,  // { 0xF2, 0x7B } PUA
  0xE1B4,  // { 0xF2, 0x7C } PUA
  0xE1B5,  // { 0xF2, 0x7D } PUA
  0xE1B6,  // { 0xF2, 0x7E } PUA
  0xE1B7,  // { 0xF2, 0x80 } PUA
  0xE1B8,  // { 0xF2, 0x81 } PUA
  0xE1B9,  // { 0xF2, 0x82 } PUA
  0xE1BA,  // { 0xF2, 0x83 } PUA
  0xE1BB,  // { 0xF2, 0x84 } PUA
  0xE1BC,  // { 0xF2, 0x85 } PUA
  0xE1BD,  // { 0xF2, 0x86 } PUA
  0xE1BE,  // { 0xF2, 0x87 } PUA
  0xE1BF,  // { 0xF2, 0x88 } PUA
  0xE1C0,  // { 0xF2, 0x89 } PUA
  0xE1C1,  // { 0xF2, 0x8A } PUA
  0xE1C2,  // { 0xF2, 0x8B } PUA
  0xE1C3,  // { 0xF2, 0x8C } PUA
  0xE1C4,  // { 0xF2, 0x8D } PUA
  0xE1C5,  // { 0xF2, 0x8E } PUA
  0xE1C6,  // { 0xF2, 0x8F } PUA
  0xE1C7,  // { 0xF2, 0x90 } PUA
  0xE1C8,  // { 0xF2, 0x91 } PUA
  0xE1C9,  // { 0xF2, 0x92 } PUA
  0xE1CA,  // { 0xF2, 0x93 } PUA
  0xE1CB,  // { 0xF2, 0x94 } PUA
  0xE1CC,  // { 0xF2, 0x95 } PUA
  0xE1CD,  // { 0xF2, 0x96 } PUA
  0xE1CE,  // { 0xF2, 0x97 } PUA
  0xE1CF,  // { 0xF2, 0x98 } PUA
  0xE1D0,  // { 0xF2, 0x99 } PUA
  0xE1D1,  // { 0xF2, 0x9A } PUA
  0xE1D2,  // { 0xF2, 0x9B } PUA
  0xE1D3,  // { 0xF2, 0x9C } PUA
  0xE1D4,  // { 0xF2, 0x9D } PUA
  0xE1D5,  // { 0xF2, 0x9E } PUA
  0xE1D6,  // { 0xF2, 0x9F } PUA
  0xE1D7,  // { 0xF2, 0xA0 } PUA
  0xE1D8,  // { 0xF2, 0xA1 } PUA
  0xE1D9,  // { 0xF2, 0xA2 } PUA
  0xE1DA,  // { 0xF2, 0xA3 } PUA
  0xE1DB,  // { 0xF2, 0xA4 } PUA
  0xE1DC,  // { 0xF2, 0xA5 } PUA
  0xE1DD,  // { 0xF2, 0xA6 } PUA
  0xE1DE,  // { 0xF2, 0xA7 } PUA
  0xE1DF,  // { 0xF2, 0xA8 } PUA
  0xE1E0,  // { 0xF2, 0xA9 } PUA
  0xE1E1,  // { 0xF2, 0xAA } PUA
  0xE1E2,  // { 0xF2, 0xAB } PUA
  0xE1E3,  // { 0xF2, 0xAC } PUA
  0xE1E4,  // { 0xF2, 0xAD } PUA
  0xE1E5,  // { 0xF2, 0xAE } PUA
  0xE1E6,  // { 0xF2, 0xAF } PUA
  0xE1E7,  // { 0xF2, 0xB0 } PUA
  0xE1E8,  // { 0xF2, 0xB1 } PUA
  0xE1E9,  // { 0xF2, 0xB2 } PUA
  0xE1EA,  // { 0xF2, 0xB3 } PUA
  0xE1EB,  // { 0xF2, 0xB4 } PUA
  0xE1EC,  // { 0xF2, 0xB5 } PUA
  0xE1ED,  // { 0xF2, 0xB6 } PUA
  0xE1EE,  // { 0xF2, 0xB7 } PUA
  0xE1EF,  // { 0xF2, 0xB8 } PUA
  0xE1F0,  // { 0xF2, 0xB9 } PUA
  0xE1F1,  // { 0xF2, 0xBA } PUA
  0xE1F2,  // { 0xF2, 0xBB } PUA
  0xE1F3,  // { 0xF2, 0xBC } PUA
  0xE1F4,  // { 0xF2, 0xBD } PUA
  0xE1F5,  // { 0xF2, 0xBE } PUA
  0xE1F6,  // { 0xF2, 0xBF } PUA
  0xE1F7,  // { 0xF2, 0xC0 } PUA
  0xE1F8,  // { 0xF2, 0xC1 } PUA
  0xE1F9,  // { 0xF2, 0xC2 } PUA
  0xE1FA,  // { 0xF2, 0xC3 } PUA
  0xE1FB,  // { 0xF2, 0xC4 } PUA
  0xE1FC,  // { 0xF2, 0xC5 } PUA
  0xE1FD,  // { 0xF2, 0xC6 } PUA
  0xE1FE,  // { 0xF2, 0xC7 } PUA
  0xE1FF,  // { 0xF2, 0xC8 } PUA
  0xE200,  // { 0xF2, 0xC9 } PUA
  0xE201,  // { 0xF2, 0xCA } PUA
  0xE202,  // { 0xF2, 0xCB } PUA
  0xE203,  // { 0xF2, 0xCC } PUA
  0xE204,  // { 0xF2, 0xCD } PUA
  0xE205,  // { 0xF2, 0xCE } PUA
  0xE206,  // { 0xF2, 0xCF } PUA
  0xE207,  // { 0xF2, 0xD0 } PUA
  0xE208,  // { 0xF2, 0xD1 } PUA
  0xE209,  // { 0xF2, 0xD2 } PUA
  0xE20A,  // { 0xF2, 0xD3 } PUA
  0xE20B,  // { 0xF2, 0xD4 } PUA
  0xE20C,  // { 0xF2, 0xD5 } PUA
  0xE20D,  // { 0xF2, 0xD6 } PUA
  0xE20E,  // { 0xF2, 0xD7 } PUA
  0xE20F,  // { 0xF2, 0xD8 } PUA
  0xE210,  // { 0xF2, 0xD9 } PUA
  0xE211,  // { 0xF2, 0xDA } PUA
  0xE212,  // { 0xF2, 0xDB } PUA
  0xE213,  // { 0xF2, 0xDC } PUA
  0xE214,  // { 0xF2, 0xDD } PUA
  0xE215,  // { 0xF2, 0xDE } PUA
  0xE216,  // { 0xF2, 0xDF } PUA
  0xE217,  // { 0xF2, 0xE0 } PUA
  0xE218,  // { 0xF2, 0xE1 } PUA
  0xE219,  // { 0xF2, 0xE2 } PUA
  0xE21A,  // { 0xF2, 0xE3 } PUA
  0xE21B,  // { 0xF2, 0xE4 } PUA
  0xE21C,  // { 0xF2, 0xE5 } PUA
  0xE21D,  // { 0xF2, 0xE6 } PUA
  0xE21E,  // { 0xF2, 0xE7 } PUA
  0xE21F,  // { 0xF2, 0xE8 } PUA
  0xE220,  // { 0xF2, 0xE9 } PUA
  0xE221,  // { 0xF2, 0xEA } PUA
  0xE222,  // { 0xF2, 0xEB } PUA
  0xE223,  // { 0xF2, 0xEC } PUA
  0xE224,  // { 0xF2, 0xED } PUA
  0xE225,  // { 0xF2, 0xEE } PUA
  0xE226,  // { 0xF2, 0xEF } PUA
  0xE227,  // { 0xF2, 0xF0 } PUA
  0xE228,  // { 0xF2, 0xF1 } PUA
  0xE229,  // { 0xF2, 0xF2 } PUA
  0xE22A,  // { 0xF2, 0xF3 } PUA
  0xE22B,  // { 0xF2, 0xF4 } PUA
  0xE22C,  // { 0xF2, 0xF5 } PUA
  0xE22D,  // { 0xF2, 0xF6 } PUA
  0xE22E,  // { 0xF2, 0xF7 } PUA
  0xE22F,  // { 0xF2, 0xF8 } PUA
  0xE230,  // { 0xF2, 0xF9 } PUA
  0xE231,  // { 0xF2, 0xFA } PUA
  0xE232,  // { 0xF2, 0xFB } PUA
  0xE233,  // { 0xF2, 0xFC } PUA
  0x0000,  // { 0xF2, 0xFD }
  0x0000,  // { 0xF2, 0xFE }
  0x0000,  // { 0xF2, 0xFF }
  0xE234,  // { 0xF3, 0x40 } PUA
  0xE235,  // { 0xF3, 0x41 } PUA
  0xE236,  // { 0xF3, 0x42 } PUA
  0xE237,  // { 0xF3, 0x43 } PUA
  0xE238,  // { 0xF3, 0x44 } PUA
  0xE239,  // { 0xF3, 0x45 } PUA
  0xE23A,  // { 0xF3, 0x46 } PUA
  0xE23B,  // { 0xF3, 0x47 } PUA
  0xE23C,  // { 0xF3, 0x48 } PUA
  0xE23D,  // { 0xF3, 0x49 } PUA
  0xE23E,  // { 0xF3, 0x4A } PUA
  0xE23F,  // { 0xF3, 0x4B } PUA
  0xE240,  // { 0xF3, 0x4C } PUA
  0xE241,  // { 0xF3, 0x4D } PUA
  0xE242,  // { 0xF3, 0x4E } PUA
  0xE243,  // { 0xF3, 0x4F } PUA
  0xE244,  // { 0xF3, 0x50 } PUA
  0xE245,  // { 0xF3, 0x51 } PUA
  0xE246,  // { 0xF3, 0x52 } PUA
  0xE247,  // { 0xF3, 0x53 } PUA
  0xE248,  // { 0xF3, 0x54 } PUA
  0xE249,  // { 0xF3, 0x55 } PUA
  0xE24A,  // { 0xF3, 0x56 } PUA
  0xE24B,  // { 0xF3, 0x57 } PUA
  0xE24C,  // { 0xF3, 0x58 } PUA
  0xE24D,  // { 0xF3, 0x59 } PUA
  0xE24E,  // { 0xF3, 0x5A } PUA
  0xE24F,  // { 0xF3, 0x5B } PUA
  0xE250,  // { 0xF3, 0x5C } PUA
  0xE251,  // { 0xF3, 0x5D } PUA
  0xE252,  // { 0xF3, 0x5E } PUA
  0xE253,  // { 0xF3, 0x5F } PUA
  0xE254,  // { 0xF3, 0x60 } PUA
  0xE255,  // { 0xF3, 0x61 } PUA
  0xE256,  // { 0xF3, 0x62 } PUA
  0xE257,  // { 0xF3, 0x63 } PUA
  0xE258,  // { 0xF3, 0x64 } PUA
  0xE259,  // { 0xF3, 0x65 } PUA
  0xE25A,  // { 0xF3, 0x66 } PUA
  0xE25B,  // { 0xF3, 0x67 } PUA
  0xE25C,  // { 0xF3, 0x68 } PUA
  0xE25D,  // { 0xF3, 0x69 } PUA
  0xE25E,  // { 0xF3, 0x6A } PUA
  0xE25F,  // { 0xF3, 0x6B } PUA
  0xE260,  // { 0xF3, 0x6C } PUA
  0xE261,  // { 0xF3, 0x6D } PUA
  0xE262,  // { 0xF3, 0x6E } PUA
  0xE263,  // { 0xF3, 0x6F } PUA
  0xE264,  // { 0xF3, 0x70 } PUA
  0xE265,  // { 0xF3, 0x71 } PUA
  0xE266,  // { 0xF3, 0x72 } PUA
  0xE267,  // { 0xF3, 0x73 } PUA
  0xE268,  // { 0xF3, 0x74 } PUA
  0xE269,  // { 0xF3, 0x75 } PUA
  0xE26A,  // { 0xF3, 0x76 } PUA
  0xE26B,  // { 0xF3, 0x77 } PUA
  0xE26C,  // { 0xF3, 0x78 } PUA
  0xE26D,  // { 0xF3, 0x79 } PUA
  0xE26E,  // { 0xF3, 0x7A } PUA
  0xE26F,  // { 0xF3, 0x7B } PUA
  0xE270,  // { 0xF3, 0x7C } PUA
  0xE271,  // { 0xF3, 0x7D } PUA
  0xE272,  // { 0xF3, 0x7E } PUA
  0xE273,  // { 0xF3, 0x80 } PUA
  0xE274,  // { 0xF3, 0x81 } PUA
  0xE275,  // { 0xF3, 0x82 } PUA
  0xE276,  // { 0xF3, 0x83 } PUA
  0xE277,  // { 0xF3, 0x84 } PUA
  0xE278,  // { 0xF3, 0x85 } PUA
  0xE279,  // { 0xF3, 0x86 } PUA
  0xE27A,  // { 0xF3, 0x87 } PUA
  0xE27B,  // { 0xF3, 0x88 } PUA
  0xE27C,  // { 0xF3, 0x89 } PUA
  0xE27D,  // { 0xF3, 0x8A } PUA
  0xE27E,  // { 0xF3, 0x8B } PUA
  0xE27F,  // { 0xF3, 0x8C } PUA
  0xE280,  // { 0xF3, 0x8D } PUA
  0xE281,  // { 0xF3, 0x8E } PUA
  0xE282,  // { 0xF3, 0x8F } PUA
  0xE283,  // { 0xF3, 0x90 } PUA
  0xE284,  // { 0xF3, 0x91 } PUA
  0xE285,  // { 0xF3, 0x92 } PUA
  0xE286,  // { 0xF3, 0x93 } PUA
  0xE287,  // { 0xF3, 0x94 } PUA
  0xE288,  // { 0xF3, 0x95 } PUA
  0xE289,  // { 0xF3, 0x96 } PUA
  0xE28A,  // { 0xF3, 0x97 } PUA
  0xE28B,  // { 0xF3, 0x98 } PUA
  0xE28C,  // { 0xF3, 0x99 } PUA
  0xE28D,  // { 0xF3, 0x9A } PUA
  0xE28E,  // { 0xF3, 0x9B } PUA
  0xE28F,  // { 0xF3, 0x9C } PUA
  0xE290,  // { 0xF3, 0x9D } PUA
  0xE291,  // { 0xF3, 0x9E } PUA
  0xE292,  // { 0xF3, 0x9F } PUA
  0xE293,  // { 0xF3, 0xA0 } PUA
  0xE294,  // { 0xF3, 0xA1 } PUA
  0xE295,  // { 0xF3, 0xA2 } PUA
  0xE296,  // { 0xF3, 0xA3 } PUA
  0xE297,  // { 0xF3, 0xA4 } PUA
  0xE298,  // { 0xF3, 0xA5 } PUA
  0xE299,  // { 0xF3, 0xA6 } PUA
  0xE29A,  // { 0xF3, 0xA7 } PUA
  0xE29B,  // { 0xF3, 0xA8 } PUA
  0xE29C,  // { 0xF3, 0xA9 } PUA
  0xE29D,  // { 0xF3, 0xAA } PUA
  0xE29E,  // { 0xF3, 0xAB } PUA
  0xE29F,  // { 0xF3, 0xAC } PUA
  0xE2A0,  // { 0xF3, 0xAD } PUA
  0xE2A1,  // { 0xF3, 0xAE } PUA
  0xE2A2,  // { 0xF3, 0xAF } PUA
  0xE2A3,  // { 0xF3, 0xB0 } PUA
  0xE2A4,  // { 0xF3, 0xB1 } PUA
  0xE2A5,  // { 0xF3, 0xB2 } PUA
  0xE2A6,  // { 0xF3, 0xB3 } PUA
  0xE2A7,  // { 0xF3, 0xB4 } PUA
  0xE2A8,  // { 0xF3, 0xB5 } PUA
  0xE2A9,  // { 0xF3, 0xB6 } PUA
  0xE2AA,  // { 0xF3, 0xB7 } PUA
  0xE2AB,  // { 0xF3, 0xB8 } PUA
  0xE2AC,  // { 0xF3, 0xB9 } PUA
  0xE2AD,  // { 0xF3, 0xBA } PUA
  0xE2AE,  // { 0xF3, 0xBB } PUA
  0xE2AF,  // { 0xF3, 0xBC } PUA
  0xE2B0,  // { 0xF3, 0xBD } PUA
  0xE2B1,  // { 0xF3, 0xBE } PUA
  0xE2B2,  // { 0xF3, 0xBF } PUA
  0xE2B3,  // { 0xF3, 0xC0 } PUA
  0xE2B4,  // { 0xF3, 0xC1 } PUA
  0xE2B5,  // { 0xF3, 0xC2 } PUA
  0xE2B6,  // { 0xF3, 0xC3 } PUA
  0xE2B7,  // { 0xF3, 0xC4 } PUA
  0xE2B8,  // { 0xF3, 0xC5 } PUA
  0xE2B9,  // { 0xF3, 0xC6 } PUA
  0xE2BA,  // { 0xF3, 0xC7 } PUA
  0xE2BB,  // { 0xF3, 0xC8 } PUA
  0xE2BC,  // { 0xF3, 0xC9 } PUA
  0xE2BD,  // { 0xF3, 0xCA } PUA
  0xE2BE,  // { 0xF3, 0xCB } PUA
  0xE2BF,  // { 0xF3, 0xCC } PUA
  0xE2C0,  // { 0xF3, 0xCD } PUA
  0xE2C1,  // { 0xF3, 0xCE } PUA
  0xE2C2,  // { 0xF3, 0xCF } PUA
  0xE2C3,  // { 0xF3, 0xD0 } PUA
  0xE2C4,  // { 0xF3, 0xD1 } PUA
  0xE2C5,  // { 0xF3, 0xD2 } PUA
  0xE2C6,  // { 0xF3, 0xD3 } PUA
  0xE2C7,  // { 0xF3, 0xD4 } PUA
  0xE2C8,  // { 0xF3, 0xD5 } PUA
  0xE2C9,  // { 0xF3, 0xD6 } PUA
  0xE2CA,  // { 0xF3, 0xD7 } PUA
  0xE2CB,  // { 0xF3, 0xD8 } PUA
  0xE2CC,  // { 0xF3, 0xD9 } PUA
  0xE2CD,  // { 0xF3, 0xDA } PUA
  0xE2CE,  // { 0xF3, 0xDB } PUA
  0xE2CF,  // { 0xF3, 0xDC } PUA
  0xE2D0,  // { 0xF3, 0xDD } PUA
  0xE2D1,  // { 0xF3, 0xDE } PUA
  0xE2D2,  // { 0xF3, 0xDF } PUA
  0xE2D3,  // { 0xF3, 0xE0 } PUA
  0xE2D4,  // { 0xF3, 0xE1 } PUA
  0xE2D5,  // { 0xF3, 0xE2 } PUA
  0xE2D6,  // { 0xF3, 0xE3 } PUA
  0xE2D7,  // { 0xF3, 0xE4 } PUA
  0xE2D8,  // { 0xF3, 0xE5 } PUA
  0xE2D9,  // { 0xF3, 0xE6 } PUA
  0xE2DA,  // { 0xF3, 0xE7 } PUA
  0xE2DB,  // { 0xF3, 0xE8 } PUA
  0xE2DC,  // { 0xF3, 0xE9 } PUA
  0xE2DD,  // { 0xF3, 0xEA } PUA
  0xE2DE,  // { 0xF3, 0xEB } PUA
  0xE2DF,  // { 0xF3, 0xEC } PUA
  0xE2E0,  // { 0xF3, 0xED } PUA
  0xE2E1,  // { 0xF3, 0xEE } PUA
  0xE2E2,  // { 0xF3, 0xEF } PUA
  0xE2E3,  // { 0xF3, 0xF0 } PUA
  0xE2E4,  // { 0xF3, 0xF1 } PUA
  0xE2E5,  // { 0xF3, 0xF2 } PUA
  0xE2E6,  // { 0xF3, 0xF3 } PUA
  0xE2E7,  // { 0xF3, 0xF4 } PUA
  0xE2E8,  // { 0xF3, 0xF5 } PUA
  0xE2E9,  // { 0xF3, 0xF6 } PUA
  0xE2EA,  // { 0xF3, 0xF7 } PUA
  0xE2EB,  // { 0xF3, 0xF8 } PUA
  0xE2EC,  // { 0xF3, 0xF9 } PUA
  0xE2ED,  // { 0xF3, 0xFA } PUA
  0xE2EE,  // { 0xF3, 0xFB } PUA
  0xE2EF,  // { 0xF3, 0xFC } PUA
  0x0000,  // { 0xF3, 0xFD }
  0x0000,  // { 0xF3, 0xFE }
  0x0000,  // { 0xF3, 0xFF }
  0xE2F0,  // { 0xF4, 0x40 } PUA
  0xE2F1,  // { 0xF4, 0x41 } PUA
  0xE2F2,  // { 0xF4, 0x42 } PUA
  0xE2F3,  // { 0xF4, 0x43 } PUA
  0xE2F4,  // { 0xF4, 0x44 } PUA
  0xE2F5,  // { 0xF4, 0x45 } PUA
  0xE2F6,  // { 0xF4, 0x46 } PUA
  0xE2F7,  // { 0xF4, 0x47 } PUA
  0xE2F8,  // { 0xF4, 0x48 } PUA
  0xE2F9,  // { 0xF4, 0x49 } PUA
  0xE2FA,  // { 0xF4, 0x4A } PUA
  0xE2FB,  // { 0xF4, 0x4B } PUA
  0xE2FC,  // { 0xF4, 0x4C } PUA
  0xE2FD,  // { 0xF4, 0x4D } PUA
  0xE2FE,  // { 0xF4, 0x4E } PUA
  0xE2FF,  // { 0xF4, 0x4F } PUA
  0xE300,  // { 0xF4, 0x50 } PUA
  0xE301,  // { 0xF4, 0x51 } PUA
  0xE302,  // { 0xF4, 0x52 } PUA
  0xE303,  // { 0xF4, 0x53 } PUA
  0xE304,  // { 0xF4, 0x54 } PUA
  0xE305,  // { 0xF4, 0x55 } PUA
  0xE306,  // { 0xF4, 0x56 } PUA
  0xE307,  // { 0xF4, 0x57 } PUA
  0xE308,  // { 0xF4, 0x58 } PUA
  0xE309,  // { 0xF4, 0x59 } PUA
  0xE30A,  // { 0xF4, 0x5A } PUA
  0xE30B,  // { 0xF4, 0x5B } PUA
  0xE30C,  // { 0xF4, 0x5C } PUA
  0xE30D,  // { 0xF4, 0x5D } PUA
  0xE30E,  // { 0xF4, 0x5E } PUA
  0xE30F,  // { 0xF4, 0x5F } PUA
  0xE310,  // { 0xF4, 0x60 } PUA
  0xE311,  // { 0xF4, 0x61 } PUA
  0xE312,  // { 0xF4, 0x62 } PUA
  0xE313,  // { 0xF4, 0x63 } PUA
  0xE314,  // { 0xF4, 0x64 } PUA
  0xE315,  // { 0xF4, 0x65 } PUA
  0xE316,  // { 0xF4, 0x66 } PUA
  0xE317,  // { 0xF4, 0x67 } PUA
  0xE318,  // { 0xF4, 0x68 } PUA
  0xE319,  // { 0xF4, 0x69 } PUA
  0xE31A,  // { 0xF4, 0x6A } PUA
  0xE31B,  // { 0xF4, 0x6B } PUA
  0xE31C,  // { 0xF4, 0x6C } PUA
  0xE31D,  // { 0xF4, 0x6D } PUA
  0xE31E,  // { 0xF4, 0x6E } PUA
  0xE31F,  // { 0xF4, 0x6F } PUA
  0xE320,  // { 0xF4, 0x70 } PUA
  0xE321,  // { 0xF4, 0x71 } PUA
  0xE322,  // { 0xF4, 0x72 } PUA
  0xE323,  // { 0xF4, 0x73 } PUA
  0xE324,  // { 0xF4, 0x74 } PUA
  0xE325,  // { 0xF4, 0x75 } PUA
  0xE326,  // { 0xF4, 0x76 } PUA
  0xE327,  // { 0xF4, 0x77 } PUA
  0xE328,  // { 0xF4, 0x78 } PUA
  0xE329,  // { 0xF4, 0x79 } PUA
  0xE32A,  // { 0xF4, 0x7A } PUA
  0xE32B,  // { 0xF4, 0x7B } PUA
  0xE32C,  // { 0xF4, 0x7C } PUA
  0xE32D,  // { 0xF4, 0x7D } PUA
  0xE32E,  // { 0xF4, 0x7E } PUA
  0xE32F,  // { 0xF4, 0x80 } PUA
  0xE330,  // { 0xF4, 0x81 } PUA
  0xE331,  // { 0xF4, 0x82 } PUA
  0xE332,  // { 0xF4, 0x83 } PUA
  0xE333,  // { 0xF4, 0x84 } PUA
  0xE334,  // { 0xF4, 0x85 } PUA
  0xE335,  // { 0xF4, 0x86 } PUA
  0xE336,  // { 0xF4, 0x87 } PUA
  0xE337,  // { 0xF4, 0x88 } PUA
  0xE338,  // { 0xF4, 0x89 } PUA
  0xE339,  // { 0xF4, 0x8A } PUA
  0xE33A,  // { 0xF4, 0x8B } PUA
  0xE33B,  // { 0xF4, 0x8C } PUA
  0xE33C,  // { 0xF4, 0x8D } PUA
  0xE33D,  // { 0xF4, 0x8E } PUA
  0xE33E,  // { 0xF4, 0x8F } PUA
  0xE33F,  // { 0xF4, 0x90 } PUA
  0xE340,  // { 0xF4, 0x91 } PUA
  0xE341,  // { 0xF4, 0x92 } PUA
  0xE342,  // { 0xF4, 0x93 } PUA
  0xE343,  // { 0xF4, 0x94 } PUA
  0xE344,  // { 0xF4, 0x95 } PUA
  0xE345,  // { 0xF4, 0x96 } PUA
  0xE346,  // { 0xF4, 0x97 } PUA
  0xE347,  // { 0xF4, 0x98 } PUA
  0xE348,  // { 0xF4, 0x99 } PUA
  0xE349,  // { 0xF4, 0x9A } PUA
  0xE34A,  // { 0xF4, 0x9B } PUA
  0xE34B,  // { 0xF4, 0x9C } PUA
  0xE34C,  // { 0xF4, 0x9D } PUA
  0xE34D,  // { 0xF4, 0x9E } PUA
  0xE34E,  // { 0xF4, 0x9F } PUA
  0xE34F,  // { 0xF4, 0xA0 } PUA
  0xE350,  // { 0xF4, 0xA1 } PUA
  0xE351,  // { 0xF4, 0xA2 } PUA
  0xE352,  // { 0xF4, 0xA3 } PUA
  0xE353,  // { 0xF4, 0xA4 } PUA
  0xE354,  // { 0xF4, 0xA5 } PUA
  0xE355,  // { 0xF4, 0xA6 } PUA
  0xE356,  // { 0xF4, 0xA7 } PUA
  0xE357,  // { 0xF4, 0xA8 } PUA
  0xE358,  // { 0xF4, 0xA9 } PUA
  0xE359,  // { 0xF4, 0xAA } PUA
  0xE35A,  // { 0xF4, 0xAB } PUA
  0xE35B,  // { 0xF4, 0xAC } PUA
  0xE35C,  // { 0xF4, 0xAD } PUA
  0xE35D,  // { 0xF4, 0xAE } PUA
  0xE35E,  // { 0xF4, 0xAF } PUA
  0xE35F,  // { 0xF4, 0xB0 } PUA
  0xE360,  // { 0xF4, 0xB1 } PUA
  0xE361,  // { 0xF4, 0xB2 } PUA
  0xE362,  // { 0xF4, 0xB3 } PUA
  0xE363,  // { 0xF4, 0xB4 } PUA
  0xE364,  // { 0xF4, 0xB5 } PUA
  0xE365,  // { 0xF4, 0xB6 } PUA
  0xE366,  // { 0xF4, 0xB7 } PUA
  0xE367,  // { 0xF4, 0xB8 } PUA
  0xE368,  // { 0xF4, 0xB9 } PUA
  0xE369,  // { 0xF4, 0xBA } PUA
  0xE36A,  // { 0xF4, 0xBB } PUA
  0xE36B,  // { 0xF4, 0xBC } PUA
  0xE36C,  // { 0xF4, 0xBD } PUA
  0xE36D,  // { 0xF4, 0xBE } PUA
  0xE36E,  // { 0xF4, 0xBF } PUA
  0xE36F,  // { 0xF4, 0xC0 } PUA
  0xE370,  // { 0xF4, 0xC1 } PUA
  0xE371,  // { 0xF4, 0xC2 } PUA
  0xE372,  // { 0xF4, 0xC3 } PUA
  0xE373,  // { 0xF4, 0xC4 } PUA
  0xE374,  // { 0xF4, 0xC5 } PUA
  0xE375,  // { 0xF4, 0xC6 } PUA
  0xE376,  // { 0xF4, 0xC7 } PUA
  0xE377,  // { 0xF4, 0xC8 } PUA
  0xE378,  // { 0xF4, 0xC9 } PUA
  0xE379,  // { 0xF4, 0xCA } PUA
  0xE37A,  // { 0xF4, 0xCB } PUA
  0xE37B,  // { 0xF4, 0xCC } PUA
  0xE37C,  // { 0xF4, 0xCD } PUA
  0xE37D,  // { 0xF4, 0xCE } PUA
  0xE37E,  // { 0xF4, 0xCF } PUA
  0xE37F,  // { 0xF4, 0xD0 } PUA
  0xE380,  // { 0xF4, 0xD1 } PUA
  0xE381,  // { 0xF4, 0xD2 } PUA
  0xE382,  // { 0xF4, 0xD3 } PUA
  0xE383,  // { 0xF4, 0xD4 } PUA
  0xE384,  // { 0xF4, 0xD5 } PUA
  0xE385,  // { 0xF4, 0xD6 } PUA
  0xE386,  // { 0xF4, 0xD7 } PUA
  0xE387,  // { 0xF4, 0xD8 } PUA
  0xE388,  // { 0xF4, 0xD9 } PUA
  0xE389,  // { 0xF4, 0xDA } PUA
  0xE38A,  // { 0xF4, 0xDB } PUA
  0xE38B,  // { 0xF4, 0xDC } PUA
  0xE38C,  // { 0xF4, 0xDD } PUA
  0xE38D,  // { 0xF4, 0xDE } PUA
  0xE38E,  // { 0xF4, 0xDF } PUA
  0xE38F,  // { 0xF4, 0xE0 } PUA
  0xE390,  // { 0xF4, 0xE1 } PUA
  0xE391,  // { 0xF4, 0xE2 } PUA
  0xE392,  // { 0xF4, 0xE3 } PUA
  0xE393,  // { 0xF4, 0xE4 } PUA
  0xE394,  // { 0xF4, 0xE5 } PUA
  0xE395,  // { 0xF4, 0xE6 } PUA
  0xE396,  // { 0xF4, 0xE7 } PUA
  0xE397,  // { 0xF4, 0xE8 } PUA
  0xE398,  // { 0xF4, 0xE9 } PUA
  0xE399,  // { 0xF4, 0xEA } PUA
  0xE39A,  // { 0xF4, 0xEB } PUA
  0xE39B,  // { 0xF4, 0xEC } PUA
  0xE39C,  // { 0xF4, 0xED } PUA
  0xE39D,  // { 0xF4, 0xEE } PUA
  0xE39E,  // { 0xF4, 0xEF } PUA
  0xE39F,  // { 0xF4, 0xF0 } PUA
  0xE3A0,  // { 0xF4, 0xF1 } PUA
  0xE3A1,  // { 0xF4, 0xF2 } PUA
  0xE3A2,  // { 0xF4, 0xF3 } PUA
  0xE3A3,  // { 0xF4, 0xF4 } PUA
  0xE3A4,  // { 0xF4, 0xF5 } PUA
  0xE3A5,  // { 0xF4, 0xF6 } PUA
  0xE3A6,  // { 0xF4, 0xF7 } PUA
  0xE3A7,  // { 0xF4, 0xF8 } PUA
  0xE3A8,  // { 0xF4, 0xF9 } PUA
  0xE3A9,  // { 0xF4, 0xFA } PUA
  0xE3AA,  // { 0xF4, 0xFB } PUA
  0xE3AB,  // { 0xF4, 0xFC } PUA
  0x0000,  // { 0xF4, 0xFD }
  0x0000,  // { 0xF4, 0xFE }
  0x0000,  // { 0xF4, 0xFF }
  0xE3AC,  // { 0xF5, 0x40 } PUA
  0xE3AD,  // { 0xF5, 0x41 } PUA
  0xE3AE,  // { 0xF5, 0x42 } PUA
  0xE3AF,  // { 0xF5, 0x43 } PUA
  0xE3B0,  // { 0xF5, 0x44 } PUA
  0xE3B1,  // { 0xF5, 0x45 } PUA
  0xE3B2,  // { 0xF5, 0x46 } PUA
  0xE3B3,  // { 0xF5, 0x47 } PUA
  0xE3B4,  // { 0xF5, 0x48 } PUA
  0xE3B5,  // { 0xF5, 0x49 } PUA
  0xE3B6,  // { 0xF5, 0x4A } PUA
  0xE3B7,  // { 0xF5, 0x4B } PUA
  0xE3B8,  // { 0xF5, 0x4C } PUA
  0xE3B9,  // { 0xF5, 0x4D } PUA
  0xE3BA,  // { 0xF5, 0x4E } PUA
  0xE3BB,  // { 0xF5, 0x4F } PUA
  0xE3BC,  // { 0xF5, 0x50 } PUA
  0xE3BD,  // { 0xF5, 0x51 } PUA
  0xE3BE,  // { 0xF5, 0x52 } PUA
  0xE3BF,  // { 0xF5, 0x53 } PUA
  0xE3C0,  // { 0xF5, 0x54 } PUA
  0xE3C1,  // { 0xF5, 0x55 } PUA
  0xE3C2,  // { 0xF5, 0x56 } PUA
  0xE3C3,  // { 0xF5, 0x57 } PUA
  0xE3C4,  // { 0xF5, 0x58 } PUA
  0xE3C5,  // { 0xF5, 0x59 } PUA
  0xE3C6,  // { 0xF5, 0x5A } PUA
  0xE3C7,  // { 0xF5, 0x5B } PUA
  0xE3C8,  // { 0xF5, 0x5C } PUA
  0xE3C9,  // { 0xF5, 0x5D } PUA
  0xE3CA,  // { 0xF5, 0x5E } PUA
  0xE3CB,  // { 0xF5, 0x5F } PUA
  0xE3CC,  // { 0xF5, 0x60 } PUA
  0xE3CD,  // { 0xF5, 0x61 } PUA
  0xE3CE,  // { 0xF5, 0x62 } PUA
  0xE3CF,  // { 0xF5, 0x63 } PUA
  0xE3D0,  // { 0xF5, 0x64 } PUA
  0xE3D1,  // { 0xF5, 0x65 } PUA
  0xE3D2,  // { 0xF5, 0x66 } PUA
  0xE3D3,  // { 0xF5, 0x67 } PUA
  0xE3D4,  // { 0xF5, 0x68 } PUA
  0xE3D5,  // { 0xF5, 0x69 } PUA
  0xE3D6,  // { 0xF5, 0x6A } PUA
  0xE3D7,  // { 0xF5, 0x6B } PUA
  0xE3D8,  // { 0xF5, 0x6C } PUA
  0xE3D9,  // { 0xF5, 0x6D } PUA
  0xE3DA,  // { 0xF5, 0x6E } PUA
  0xE3DB,  // { 0xF5, 0x6F } PUA
  0xE3DC,  // { 0xF5, 0x70 } PUA
  0xE3DD,  // { 0xF5, 0x71 } PUA
  0xE3DE,  // { 0xF5, 0x72 } PUA
  0xE3DF,  // { 0xF5, 0x73 } PUA
  0xE3E0,  // { 0xF5, 0x74 } PUA
  0xE3E1,  // { 0xF5, 0x75 } PUA
  0xE3E2,  // { 0xF5, 0x76 } PUA
  0xE3E3,  // { 0xF5, 0x77 } PUA
  0xE3E4,  // { 0xF5, 0x78 } PUA
  0xE3E5,  // { 0xF5, 0x79 } PUA
  0xE3E6,  // { 0xF5, 0x7A } PUA
  0xE3E7,  // { 0xF5, 0x7B } PUA
  0xE3E8,  // { 0xF5, 0x7C } PUA
  0xE3E9,  // { 0xF5, 0x7D } PUA
  0xE3EA,  // { 0xF5, 0x7E } PUA
  0xE3EB,  // { 0xF5, 0x80 } PUA
  0xE3EC,  // { 0xF5, 0x81 } PUA
  0xE3ED,  // { 0xF5, 0x82 } PUA
  0xE3EE,  // { 0xF5, 0x83 } PUA
  0xE3EF,  // { 0xF5, 0x84 } PUA
  0xE3F0,  // { 0xF5, 0x85 } PUA
  0xE3F1,  // { 0xF5, 0x86 } PUA
  0xE3F2,  // { 0xF5, 0x87 } PUA
  0xE3F3,  // { 0xF5, 0x88 } PUA
  0xE3F4,  // { 0xF5, 0x89 } PUA
  0xE3F5,  // { 0xF5, 0x8A } PUA
  0xE3F6,  // { 0xF5, 0x8B } PUA
  0xE3F7,  // { 0xF5, 0x8C } PUA
  0xE3F8,  // { 0xF5, 0x8D } PUA
  0xE3F9,  // { 0xF5, 0x8E } PUA
  0xE3FA,  // { 0xF5, 0x8F } PUA
  0xE3FB,  // { 0xF5, 0x90 } PUA
  0xE3FC,  // { 0xF5, 0x91 } PUA
  0xE3FD,  // { 0xF5, 0x92 } PUA
  0xE3FE,  // { 0xF5, 0x93 } PUA
  0xE3FF,  // { 0xF5, 0x94 } PUA
  0xE400,  // { 0xF5, 0x95 } PUA
  0xE401,  // { 0xF5, 0x96 } PUA
  0xE402,  // { 0xF5, 0x97 } PUA
  0xE403,  // { 0xF5, 0x98 } PUA
  0xE404,  // { 0xF5, 0x99 } PUA
  0xE405,  // { 0xF5, 0x9A } PUA
  0xE406,  // { 0xF5, 0x9B } PUA
  0xE407,  // { 0xF5, 0x9C } PUA
  0xE408,  // { 0xF5, 0x9D } PUA
  0xE409,  // { 0xF5, 0x9E } PUA
  0xE40A,  // { 0xF5, 0x9F } PUA
  0xE40B,  // { 0xF5, 0xA0 } PUA
  0xE40C,  // { 0xF5, 0xA1 } PUA
  0xE40D,  // { 0xF5, 0xA2 } PUA
  0xE40E,  // { 0xF5, 0xA3 } PUA
  0xE40F,  // { 0xF5, 0xA4 } PUA
  0xE410,  // { 0xF5, 0xA5 } PUA
  0xE411,  // { 0xF5, 0xA6 } PUA
  0xE412,  // { 0xF5, 0xA7 } PUA
  0xE413,  // { 0xF5, 0xA8 } PUA
  0xE414,  // { 0xF5, 0xA9 } PUA
  0xE415,  // { 0xF5, 0xAA } PUA
  0xE416,  // { 0xF5, 0xAB } PUA
  0xE417,  // { 0xF5, 0xAC } PUA
  0xE418,  // { 0xF5, 0xAD } PUA
  0xE419,  // { 0xF5, 0xAE } PUA
  0xE41A,  // { 0xF5, 0xAF } PUA
  0xE41B,  // { 0xF5, 0xB0 } PUA
  0xE41C,  // { 0xF5, 0xB1 } PUA
  0xE41D,  // { 0xF5, 0xB2 } PUA
  0xE41E,  // { 0xF5, 0xB3 } PUA
  0xE41F,  // { 0xF5, 0xB4 } PUA
  0xE420,  // { 0xF5, 0xB5 } PUA
  0xE421,  // { 0xF5, 0xB6 } PUA
  0xE422,  // { 0xF5, 0xB7 } PUA
  0xE423,  // { 0xF5, 0xB8 } PUA
  0xE424,  // { 0xF5, 0xB9 } PUA
  0xE425,  // { 0xF5, 0xBA } PUA
  0xE426,  // { 0xF5, 0xBB } PUA
  0xE427,  // { 0xF5, 0xBC } PUA
  0xE428,  // { 0xF5, 0xBD } PUA
  0xE429,  // { 0xF5, 0xBE } PUA
  0xE42A,  // { 0xF5, 0xBF } PUA
  0xE42B,  // { 0xF5, 0xC0 } PUA
  0xE42C,  // { 0xF5, 0xC1 } PUA
  0xE42D,  // { 0xF5, 0xC2 } PUA
  0xE42E,  // { 0xF5, 0xC3 } PUA
  0xE42F,  // { 0xF5, 0xC4 } PUA
  0xE430,  // { 0xF5, 0xC5 } PUA
  0xE431,  // { 0xF5, 0xC6 } PUA
  0xE432,  // { 0xF5, 0xC7 } PUA
  0xE433,  // { 0xF5, 0xC8 } PUA
  0xE434,  // { 0xF5, 0xC9 } PUA
  0xE435,  // { 0xF5, 0xCA } PUA
  0xE436,  // { 0xF5, 0xCB } PUA
  0xE437,  // { 0xF5, 0xCC } PUA
  0xE438,  // { 0xF5, 0xCD } PUA
  0xE439,  // { 0xF5, 0xCE } PUA
  0xE43A,  // { 0xF5, 0xCF } PUA
  0xE43B,  // { 0xF5, 0xD0 } PUA
  0xE43C,  // { 0xF5, 0xD1 } PUA
  0xE43D,  // { 0xF5, 0xD2 } PUA
  0xE43E,  // { 0xF5, 0xD3 } PUA
  0xE43F,  // { 0xF5, 0xD4 } PUA
  0xE440,  // { 0xF5, 0xD5 } PUA
  0xE441,  // { 0xF5, 0xD6 } PUA
  0xE442,  // { 0xF5, 0xD7 } PUA
  0xE443,  // { 0xF5, 0xD8 } PUA
  0xE444,  // { 0xF5, 0xD9 } PUA
  0xE445,  // { 0xF5, 0xDA } PUA
  0xE446,  // { 0xF5, 0xDB } PUA
  0xE447,  // { 0xF5, 0xDC } PUA
  0xE448,  // { 0xF5, 0xDD } PUA
  0xE449,  // { 0xF5, 0xDE } PUA
  0xE44A,  // { 0xF5, 0xDF } PUA
  0xE44B,  // { 0xF5, 0xE0 } PUA
  0xE44C,  // { 0xF5, 0xE1 } PUA
  0xE44D,  // { 0xF5, 0xE2 } PUA
  0xE44E,  // { 0xF5, 0xE3 } PUA
  0xE44F,  // { 0xF5, 0xE4 } PUA
  0xE450,  // { 0xF5, 0xE5 } PUA
  0xE451,  // { 0xF5, 0xE6 } PUA
  0xE452,  // { 0xF5, 0xE7 } PUA
  0xE453,  // { 0xF5, 0xE8 } PUA
  0xE454,  // { 0xF5, 0xE9 } PUA
  0xE455,  // { 0xF5, 0xEA } PUA
  0xE456,  // { 0xF5, 0xEB } PUA
  0xE457,  // { 0xF5, 0xEC } PUA
  0xE458,  // { 0xF5, 0xED } PUA
  0xE459,  // { 0xF5, 0xEE } PUA
  0xE45A,  // { 0xF5, 0xEF } PUA
  0xE45B,  // { 0xF5, 0xF0 } PUA
  0xE45C,  // { 0xF5, 0xF1 } PUA
  0xE45D,  // { 0xF5, 0xF2 } PUA
  0xE45E,  // { 0xF5, 0xF3 } PUA
  0xE45F,  // { 0xF5, 0xF4 } PUA
  0xE460,  // { 0xF5, 0xF5 } PUA
  0xE461,  // { 0xF5, 0xF6 } PUA
  0xE462,  // { 0xF5, 0xF7 } PUA
  0xE463,  // { 0xF5, 0xF8 } PUA
  0xE464,  // { 0xF5, 0xF9 } PUA
  0xE465,  // { 0xF5, 0xFA } PUA
  0xE466,  // { 0xF5, 0xFB } PUA
  0xE467,  // { 0xF5, 0xFC } PUA
  0x0000,  // { 0xF5, 0xFD }
  0x0000,  // { 0xF5, 0xFE }
  0x0000,  // { 0xF5, 0xFF }
  0xE468,  // { 0xF6, 0x40 } PUA
  0xE469,  // { 0xF6, 0x41 } PUA
  0xE46A,  // { 0xF6, 0x42 } PUA
  0xE46B,  // { 0xF6, 0x43 } PUA
  0xE46C,  // { 0xF6, 0x44 } PUA
  0xE46D,  // { 0xF6, 0x45 } PUA
  0xE46E,  // { 0xF6, 0x46 } PUA
  0xE46F,  // { 0xF6, 0x47 } PUA
  0xE470,  // { 0xF6, 0x48 } PUA
  0xE471,  // { 0xF6, 0x49 } PUA
  0xE472,  // { 0xF6, 0x4A } PUA
  0xE473,  // { 0xF6, 0x4B } PUA
  0xE474,  // { 0xF6, 0x4C } PUA
  0xE475,  // { 0xF6, 0x4D } PUA
  0xE476,  // { 0xF6, 0x4E } PUA
  0xE477,  // { 0xF6, 0x4F } PUA
  0xE478,  // { 0xF6, 0x50 } PUA
  0xE479,  // { 0xF6, 0x51 } PUA
  0xE47A,  // { 0xF6, 0x52 } PUA
  0xE47B,  // { 0xF6, 0x53 } PUA
  0xE47C,  // { 0xF6, 0x54 } PUA
  0xE47D,  // { 0xF6, 0x55 } PUA
  0xE47E,  // { 0xF6, 0x56 } PUA
  0xE47F,  // { 0xF6, 0x57 } PUA
  0xE480,  // { 0xF6, 0x58 } PUA
  0xE481,  // { 0xF6, 0x59 } PUA
  0xE482,  // { 0xF6, 0x5A } PUA
  0xE483,  // { 0xF6, 0x5B } PUA
  0xE484,  // { 0xF6, 0x5C } PUA
  0xE485,  // { 0xF6, 0x5D } PUA
  0xE486,  // { 0xF6, 0x5E } PUA
  0xE487,  // { 0xF6, 0x5F } PUA
  0xE488,  // { 0xF6, 0x60 } PUA
  0xE489,  // { 0xF6, 0x61 } PUA
  0xE48A,  // { 0xF6, 0x62 } PUA
  0xE48B,  // { 0xF6, 0x63 } PUA
  0xE48C,  // { 0xF6, 0x64 } PUA
  0xE48D,  // { 0xF6, 0x65 } PUA
  0xE48E,  // { 0xF6, 0x66 } PUA
  0xE48F,  // { 0xF6, 0x67 } PUA
  0xE490,  // { 0xF6, 0x68 } PUA
  0xE491,  // { 0xF6, 0x69 } PUA
  0xE492,  // { 0xF6, 0x6A } PUA
  0xE493,  // { 0xF6, 0x6B } PUA
  0xE494,  // { 0xF6, 0x6C } PUA
  0xE495,  // { 0xF6, 0x6D } PUA
  0xE496,  // { 0xF6, 0x6E } PUA
  0xE497,  // { 0xF6, 0x6F } PUA
  0xE498,  // { 0xF6, 0x70 } PUA
  0xE499,  // { 0xF6, 0x71 } PUA
  0xE49A,  // { 0xF6, 0x72 } PUA
  0xE49B,  // { 0xF6, 0x73 } PUA
  0xE49C,  // { 0xF6, 0x74 } PUA
  0xE49D,  // { 0xF6, 0x75 } PUA
  0xE49E,  // { 0xF6, 0x76 } PUA
  0xE49F,  // { 0xF6, 0x77 } PUA
  0xE4A0,  // { 0xF6, 0x78 } PUA
  0xE4A1,  // { 0xF6, 0x79 } PUA
  0xE4A2,  // { 0xF6, 0x7A } PUA
  0xE4A3,  // { 0xF6, 0x7B } PUA
  0xE4A4,  // { 0xF6, 0x7C } PUA
  0xE4A5,  // { 0xF6, 0x7D } PUA
  0xE4A6,  // { 0xF6, 0x7E } PUA
  0xE4A7,  // { 0xF6, 0x80 } PUA
  0xE4A8,  // { 0xF6, 0x81 } PUA
  0xE4A9,  // { 0xF6, 0x82 } PUA
  0xE4AA,  // { 0xF6, 0x83 } PUA
  0xE4AB,  // { 0xF6, 0x84 } PUA
  0xE4AC,  // { 0xF6, 0x85 } PUA
  0xE4AD,  // { 0xF6, 0x86 } PUA
  0xE4AE,  // { 0xF6, 0x87 } PUA
  0xE4AF,  // { 0xF6, 0x88 } PUA
  0xE4B0,  // { 0xF6, 0x89 } PUA
  0xE4B1,  // { 0xF6, 0x8A } PUA
  0xE4B2,  // { 0xF6, 0x8B } PUA
  0xE4B3,  // { 0xF6, 0x8C } PUA
  0xE4B4,  // { 0xF6, 0x8D } PUA
  0xE4B5,  // { 0xF6, 0x8E } PUA
  0xE4B6,  // { 0xF6, 0x8F } PUA
  0xE4B7,  // { 0xF6, 0x90 } PUA
  0xE4B8,  // { 0xF6, 0x91 } PUA
  0xE4B9,  // { 0xF6, 0x92 } PUA
  0xE4BA,  // { 0xF6, 0x93 } PUA
  0xE4BB,  // { 0xF6, 0x94 } PUA
  0xE4BC,  // { 0xF6, 0x95 } PUA
  0xE4BD,  // { 0xF6, 0x96 } PUA
  0xE4BE,  // { 0xF6, 0x97 } PUA
  0xE4BF,  // { 0xF6, 0x98 } PUA
  0xE4C0,  // { 0xF6, 0x99 } PUA
  0xE4C1,  // { 0xF6, 0x9A } PUA
  0xE4C2,  // { 0xF6, 0x9B } PUA
  0xE4C3,  // { 0xF6, 0x9C } PUA
  0xE4C4,  // { 0xF6, 0x9D } PUA
  0xE4C5,  // { 0xF6, 0x9E } PUA
  0xE4C6,  // { 0xF6, 0x9F } PUA
  0xE4C7,  // { 0xF6, 0xA0 } PUA
  0xE4C8,  // { 0xF6, 0xA1 } PUA
  0xE4C9,  // { 0xF6, 0xA2 } PUA
  0xE4CA,  // { 0xF6, 0xA3 } PUA
  0xE4CB,  // { 0xF6, 0xA4 } PUA
  0xE4CC,  // { 0xF6, 0xA5 } PUA
  0xE4CD,  // { 0xF6, 0xA6 } PUA
  0xE4CE,  // { 0xF6, 0xA7 } PUA
  0xE4CF,  // { 0xF6, 0xA8 } PUA
  0xE4D0,  // { 0xF6, 0xA9 } PUA
  0xE4D1,  // { 0xF6, 0xAA } PUA
  0xE4D2,  // { 0xF6, 0xAB } PUA
  0xE4D3,  // { 0xF6, 0xAC } PUA
  0xE4D4,  // { 0xF6, 0xAD } PUA
  0xE4D5,  // { 0xF6, 0xAE } PUA
  0xE4D6,  // { 0xF6, 0xAF } PUA
  0xE4D7,  // { 0xF6, 0xB0 } PUA
  0xE4D8,  // { 0xF6, 0xB1 } PUA
  0xE4D9,  // { 0xF6, 0xB2 } PUA
  0xE4DA,  // { 0xF6, 0xB3 } PUA
  0xE4DB,  // { 0xF6, 0xB4 } PUA
  0xE4DC,  // { 0xF6, 0xB5 } PUA
  0xE4DD,  // { 0xF6, 0xB6 } PUA
  0xE4DE,  // { 0xF6, 0xB7 } PUA
  0xE4DF,  // { 0xF6, 0xB8 } PUA
  0xE4E0,  // { 0xF6, 0xB9 } PUA
  0xE4E1,  // { 0xF6, 0xBA } PUA
  0xE4E2,  // { 0xF6, 0xBB } PUA
  0xE4E3,  // { 0xF6, 0xBC } PUA
  0xE4E4,  // { 0xF6, 0xBD } PUA
  0xE4E5,  // { 0xF6, 0xBE } PUA
  0xE4E6,  // { 0xF6, 0xBF } PUA
  0xE4E7,  // { 0xF6, 0xC0 } PUA
  0xE4E8,  // { 0xF6, 0xC1 } PUA
  0xE4E9,  // { 0xF6, 0xC2 } PUA
  0xE4EA,  // { 0xF6, 0xC3 } PUA
  0xE4EB,  // { 0xF6, 0xC4 } PUA
  0xE4EC,  // { 0xF6, 0xC5 } PUA
  0xE4ED,  // { 0xF6, 0xC6 } PUA
  0xE4EE,  // { 0xF6, 0xC7 } PUA
  0xE4EF,  // { 0xF6, 0xC8 } PUA
  0xE4F0,  // { 0xF6, 0xC9 } PUA
  0xE4F1,  // { 0xF6, 0xCA } PUA
  0xE4F2,  // { 0xF6, 0xCB } PUA
  0xE4F3,  // { 0xF6, 0xCC } PUA
  0xE4F4,  // { 0xF6, 0xCD } PUA
  0xE4F5,  // { 0xF6, 0xCE } PUA
  0xE4F6,  // { 0xF6, 0xCF } PUA
  0xE4F7,  // { 0xF6, 0xD0 } PUA
  0xE4F8,  // { 0xF6, 0xD1 } PUA
  0xE4F9,  // { 0xF6, 0xD2 } PUA
  0xE4FA,  // { 0xF6, 0xD3 } PUA
  0xE4FB,  // { 0xF6, 0xD4 } PUA
  0xE4FC,  // { 0xF6, 0xD5 } PUA
  0xE4FD,  // { 0xF6, 0xD6 } PUA
  0xE4FE,  // { 0xF6, 0xD7 } PUA
  0xE4FF,  // { 0xF6, 0xD8 } PUA
  0xE500,  // { 0xF6, 0xD9 } PUA
  0xE501,  // { 0xF6, 0xDA } PUA
  0xE502,  // { 0xF6, 0xDB } PUA
  0xE503,  // { 0xF6, 0xDC } PUA
  0xE504,  // { 0xF6, 0xDD } PUA
  0xE505,  // { 0xF6, 0xDE } PUA
  0xE506,  // { 0xF6, 0xDF } PUA
  0xE507,  // { 0xF6, 0xE0 } PUA
  0xE508,  // { 0xF6, 0xE1 } PUA
  0xE509,  // { 0xF6, 0xE2 } PUA
  0xE50A,  // { 0xF6, 0xE3 } PUA
  0xE50B,  // { 0xF6, 0xE4 } PUA
  0xE50C,  // { 0xF6, 0xE5 } PUA
  0xE50D,  // { 0xF6, 0xE6 } PUA
  0xE50E,  // { 0xF6, 0xE7 } PUA
  0xE50F,  // { 0xF6, 0xE8 } PUA
  0xE510,  // { 0xF6, 0xE9 } PUA
  0xE511,  // { 0xF6, 0xEA } PUA
  0xE512,  // { 0xF6, 0xEB } PUA
  0xE513,  // { 0xF6, 0xEC } PUA
  0xE514,  // { 0xF6, 0xED } PUA
  0xE515,  // { 0xF6, 0xEE } PUA
  0xE516,  // { 0xF6, 0xEF } PUA
  0xE517,  // { 0xF6, 0xF0 } PUA
  0xE518,  // { 0xF6, 0xF1 } PUA
  0xE519,  // { 0xF6, 0xF2 } PUA
  0xE51A,  // { 0xF6, 0xF3 } PUA
  0xE51B,  // { 0xF6, 0xF4 } PUA
  0xE51C,  // { 0xF6, 0xF5 } PUA
  0xE51D,  // { 0xF6, 0xF6 } PUA
  0xE51E,  // { 0xF6, 0xF7 } PUA
  0xE51F,  // { 0xF6, 0xF8 } PUA
  0xE520,  // { 0xF6, 0xF9 } PUA
  0xE521,  // { 0xF6, 0xFA } PUA
  0xE522,  // { 0xF6, 0xFB } PUA
  0xE523,  // { 0xF6, 0xFC } PUA
  0x0000,  // { 0xF6, 0xFD }
  0x0000,  // { 0xF6, 0xFE }
  0x0000,  // { 0xF6, 0xFF }
  0xE524,  // { 0xF7, 0x40 } PUA
  0xE525,  // { 0xF7, 0x41 } PUA
  0xE526,  // { 0xF7, 0x42 } PUA
  0xE527,  // { 0xF7, 0x43 } PUA
  0xE528,  // { 0xF7, 0x44 } PUA
  0xE529,  // { 0xF7, 0x45 } PUA
  0xE52A,  // { 0xF7, 0x46 } PUA
  0xE52B,  // { 0xF7, 0x47 } PUA
  0xE52C,  // { 0xF7, 0x48 } PUA
  0xE52D,  // { 0xF7, 0x49 } PUA
  0xE52E,  // { 0xF7, 0x4A } PUA
  0xE52F,  // { 0xF7, 0x4B } PUA
  0xE530,  // { 0xF7, 0x4C } PUA
  0xE531,  // { 0xF7, 0x4D } PUA
  0xE532,  // { 0xF7, 0x4E } PUA
  0xE533,  // { 0xF7, 0x4F } PUA
  0xE534,  // { 0xF7, 0x50 } PUA
  0xE535,  // { 0xF7, 0x51 } PUA
  0xE536,  // { 0xF7, 0x52 } PUA
  0xE537,  // { 0xF7, 0x53 } PUA
  0xE538,  // { 0xF7, 0x54 } PUA
  0xE539,  // { 0xF7, 0x55 } PUA
  0xE53A,  // { 0xF7, 0x56 } PUA
  0xE53B,  // { 0xF7, 0x57 } PUA
  0xE53C,  // { 0xF7, 0x58 } PUA
  0xE53D,  // { 0xF7, 0x59 } PUA
  0xE53E,  // { 0xF7, 0x5A } PUA
  0xE53F,  // { 0xF7, 0x5B } PUA
  0xE540,  // { 0xF7, 0x5C } PUA
  0xE541,  // { 0xF7, 0x5D } PUA
  0xE542,  // { 0xF7, 0x5E } PUA
  0xE543,  // { 0xF7, 0x5F } PUA
  0xE544,  // { 0xF7, 0x60 } PUA
  0xE545,  // { 0xF7, 0x61 } PUA
  0xE546,  // { 0xF7, 0x62 } PUA
  0xE547,  // { 0xF7, 0x63 } PUA
  0xE548,  // { 0xF7, 0x64 } PUA
  0xE549,  // { 0xF7, 0x65 } PUA
  0xE54A,  // { 0xF7, 0x66 } PUA
  0xE54B,  // { 0xF7, 0x67 } PUA
  0xE54C,  // { 0xF7, 0x68 } PUA
  0xE54D,  // { 0xF7, 0x69 } PUA
  0xE54E,  // { 0xF7, 0x6A } PUA
  0xE54F,  // { 0xF7, 0x6B } PUA
  0xE550,  // { 0xF7, 0x6C } PUA
  0xE551,  // { 0xF7, 0x6D } PUA
  0xE552,  // { 0xF7, 0x6E } PUA
  0xE553,  // { 0xF7, 0x6F } PUA
  0xE554,  // { 0xF7, 0x70 } PUA
  0xE555,  // { 0xF7, 0x71 } PUA
  0xE556,  // { 0xF7, 0x72 } PUA
  0xE557,  // { 0xF7, 0x73 } PUA
  0xE558,  // { 0xF7, 0x74 } PUA
  0xE559,  // { 0xF7, 0x75 } PUA
  0xE55A,  // { 0xF7, 0x76 } PUA
  0xE55B,  // { 0xF7, 0x77 } PUA
  0xE55C,  // { 0xF7, 0x78 } PUA
  0xE55D,  // { 0xF7, 0x79 } PUA
  0xE55E,  // { 0xF7, 0x7A } PUA
  0xE55F,  // { 0xF7, 0x7B } PUA
  0xE560,  // { 0xF7, 0x7C } PUA
  0xE561,  // { 0xF7, 0x7D } PUA
  0xE562,  // { 0xF7, 0x7E } PUA
  0xE563,  // { 0xF7, 0x80 } PUA
  0xE564,  // { 0xF7, 0x81 } PUA
  0xE565,  // { 0xF7, 0x82 } PUA
  0xE566,  // { 0xF7, 0x83 } PUA
  0xE567,  // { 0xF7, 0x84 } PUA
  0xE568,  // { 0xF7, 0x85 } PUA
  0xE569,  // { 0xF7, 0x86 } PUA
  0xE56A,  // { 0xF7, 0x87 } PUA
  0xE56B,  // { 0xF7, 0x88 } PUA
  0xE56C,  // { 0xF7, 0x89 } PUA
  0xE56D,  // { 0xF7, 0x8A } PUA
  0xE56E,  // { 0xF7, 0x8B } PUA
  0xE56F,  // { 0xF7, 0x8C } PUA
  0xE570,  // { 0xF7, 0x8D } PUA
  0xE571,  // { 0xF7, 0x8E } PUA
  0xE572,  // { 0xF7, 0x8F } PUA
  0xE573,  // { 0xF7, 0x90 } PUA
  0xE574,  // { 0xF7, 0x91 } PUA
  0xE575,  // { 0xF7, 0x92 } PUA
  0xE576,  // { 0xF7, 0x93 } PUA
  0xE577,  // { 0xF7, 0x94 } PUA
  0xE578,  // { 0xF7, 0x95 } PUA
  0xE579,  // { 0xF7, 0x96 } PUA
  0xE57A,  // { 0xF7, 0x97 } PUA
  0xE57B,  // { 0xF7, 0x98 } PUA
  0xE57C,  // { 0xF7, 0x99 } PUA
  0xE57D,  // { 0xF7, 0x9A } PUA
  0xE57E,  // { 0xF7, 0x9B } PUA
  0xE57F,  // { 0xF7, 0x9C } PUA
  0xE580,  // { 0xF7, 0x9D } PUA
  0xE581,  // { 0xF7, 0x9E } PUA
  0xE582,  // { 0xF7, 0x9F } PUA
  0xE583,  // { 0xF7, 0xA0 } PUA
  0xE584,  // { 0xF7, 0xA1 } PUA
  0xE585,  // { 0xF7, 0xA2 } PUA
  0xE586,  // { 0xF7, 0xA3 } PUA
  0xE587,  // { 0xF7, 0xA4 } PUA
  0xE588,  // { 0xF7, 0xA5 } PUA
  0xE589,  // { 0xF7, 0xA6 } PUA
  0xE58A,  // { 0xF7, 0xA7 } PUA
  0xE58B,  // { 0xF7, 0xA8 } PUA
  0xE58C,  // { 0xF7, 0xA9 } PUA
  0xE58D,  // { 0xF7, 0xAA } PUA
  0xE58E,  // { 0xF7, 0xAB } PUA
  0xE58F,  // { 0xF7, 0xAC } PUA
  0xE590,  // { 0xF7, 0xAD } PUA
  0xE591,  // { 0xF7, 0xAE } PUA
  0xE592,  // { 0xF7, 0xAF } PUA
  0xE593,  // { 0xF7, 0xB0 } PUA
  0xE594,  // { 0xF7, 0xB1 } PUA
  0xE595,  // { 0xF7, 0xB2 } PUA
  0xE596,  // { 0xF7, 0xB3 } PUA
  0xE597,  // { 0xF7, 0xB4 } PUA
  0xE598,  // { 0xF7, 0xB5 } PUA
  0xE599,  // { 0xF7, 0xB6 } PUA
  0xE59A,  // { 0xF7, 0xB7 } PUA
  0xE59B,  // { 0xF7, 0xB8 } PUA
  0xE59C,  // { 0xF7, 0xB9 } PUA
  0xE59D,  // { 0xF7, 0xBA } PUA
  0xE59E,  // { 0xF7, 0xBB } PUA
  0xE59F,  // { 0xF7, 0xBC } PUA
  0xE5A0,  // { 0xF7, 0xBD } PUA
  0xE5A1,  // { 0xF7, 0xBE } PUA
  0xE5A2,  // { 0xF7, 0xBF } PUA
  0xE5A3,  // { 0xF7, 0xC0 } PUA
  0xE5A4,  // { 0xF7, 0xC1 } PUA
  0xE5A5,  // { 0xF7, 0xC2 } PUA
  0xE5A6,  // { 0xF7, 0xC3 } PUA
  0xE5A7,  // { 0xF7, 0xC4 } PUA
  0xE5A8,  // { 0xF7, 0xC5 } PUA
  0xE5A9,  // { 0xF7, 0xC6 } PUA
  0xE5AA,  // { 0xF7, 0xC7 } PUA
  0xE5AB,  // { 0xF7, 0xC8 } PUA
  0xE5AC,  // { 0xF7, 0xC9 } PUA
  0xE5AD,  // { 0xF7, 0xCA } PUA
  0xE5AE,  // { 0xF7, 0xCB } PUA
  0xE5AF,  // { 0xF7, 0xCC } PUA
  0xE5B0,  // { 0xF7, 0xCD } PUA
  0xE5B1,  // { 0xF7, 0xCE } PUA
  0xE5B2,  // { 0xF7, 0xCF } PUA
  0xE5B3,  // { 0xF7, 0xD0 } PUA
  0xE5B4,  // { 0xF7, 0xD1 } PUA
  0xE5B5,  // { 0xF7, 0xD2 } PUA
  0xE5B6,  // { 0xF7, 0xD3 } PUA
  0xE5B7,  // { 0xF7, 0xD4 } PUA
  0xE5B8,  // { 0xF7, 0xD5 } PUA
  0xE5B9,  // { 0xF7, 0xD6 } PUA
  0xE5BA,  // { 0xF7, 0xD7 } PUA
  0xE5BB,  // { 0xF7, 0xD8 } PUA
  0xE5BC,  // { 0xF7, 0xD9 } PUA
  0xE5BD,  // { 0xF7, 0xDA } PUA
  0xE5BE,  // { 0xF7, 0xDB } PUA
  0xE5BF,  // { 0xF7, 0xDC } PUA
  0xE5C0,  // { 0xF7, 0xDD } PUA
  0xE5C1,  // { 0xF7, 0xDE } PUA
  0xE5C2,  // { 0xF7, 0xDF } PUA
  0xE5C3,  // { 0xF7, 0xE0 } PUA
  0xE5C4,  // { 0xF7, 0xE1 } PUA
  0xE5C5,  // { 0xF7, 0xE2 } PUA
  0xE5C6,  // { 0xF7, 0xE3 } PUA
  0xE5C7,  // { 0xF7, 0xE4 } PUA
  0xE5C8,  // { 0xF7, 0xE5 } PUA
  0xE5C9,  // { 0xF7, 0xE6 } PUA
  0xE5CA,  // { 0xF7, 0xE7 } PUA
  0xE5CB,  // { 0xF7, 0xE8 } PUA
  0xE5CC,  // { 0xF7, 0xE9 } PUA
  0xE5CD,  // { 0xF7, 0xEA } PUA
  0xE5CE,  // { 0xF7, 0xEB } PUA
  0xE5CF,  // { 0xF7, 0xEC } PUA
  0xE5D0,  // { 0xF7, 0xED } PUA
  0xE5D1,  // { 0xF7, 0xEE } PUA
  0xE5D2,  // { 0xF7, 0xEF } PUA
  0xE5D3,  // { 0xF7, 0xF0 } PUA
  0xE5D4,  // { 0xF7, 0xF1 } PUA
  0xE5D5,  // { 0xF7, 0xF2 } PUA
  0xE5D6,  // { 0xF7, 0xF3 } PUA
  0xE5D7,  // { 0xF7, 0xF4 } PUA
  0xE5D8,  // { 0xF7, 0xF5 } PUA
  0xE5D9,  // { 0xF7, 0xF6 } PUA
  0xE5DA,  // { 0xF7, 0xF7 } PUA
  0xE5DB,  // { 0xF7, 0xF8 } PUA
  0xE5DC,  // { 0xF7, 0xF9 } PUA
  0xE5DD,  // { 0xF7, 0xFA } PUA
  0xE5DE,  // { 0xF7, 0xFB } PUA
  0xE5DF,  // { 0xF7, 0xFC } PUA
  0x0000,  // { 0xF7, 0xFD }
  0x0000,  // { 0xF7, 0xFE }
  0x0000,  // { 0xF7, 0xFF }
  0xE5E0,  // { 0xF8, 0x40 } PUA
  0xE5E1,  // { 0xF8, 0x41 } PUA
  0xE5E2,  // { 0xF8, 0x42 } PUA
  0xE5E3,  // { 0xF8, 0x43 } PUA
  0xE5E4,  // { 0xF8, 0x44 } PUA
  0xE5E5,  // { 0xF8, 0x45 } PUA
  0xE5E6,  // { 0xF8, 0x46 } PUA
  0xE5E7,  // { 0xF8, 0x47 } PUA
  0xE5E8,  // { 0xF8, 0x48 } PUA
  0xE5E9,  // { 0xF8, 0x49 } PUA
  0xE5EA,  // { 0xF8, 0x4A } PUA
  0xE5EB,  // { 0xF8, 0x4B } PUA
  0xE5EC,  // { 0xF8, 0x4C } PUA
  0xE5ED,  // { 0xF8, 0x4D } PUA
  0xE5EE,  // { 0xF8, 0x4E } PUA
  0xE5EF,  // { 0xF8, 0x4F } PUA
  0xE5F0,  // { 0xF8, 0x50 } PUA
  0xE5F1,  // { 0xF8, 0x51 } PUA
  0xE5F2,  // { 0xF8, 0x52 } PUA
  0xE5F3,  // { 0xF8, 0x53 } PUA
  0xE5F4,  // { 0xF8, 0x54 } PUA
  0xE5F5,  // { 0xF8, 0x55 } PUA
  0xE5F6,  // { 0xF8, 0x56 } PUA
  0xE5F7,  // { 0xF8, 0x57 } PUA
  0xE5F8,  // { 0xF8, 0x58 } PUA
  0xE5F9,  // { 0xF8, 0x59 } PUA
  0xE5FA,  // { 0xF8, 0x5A } PUA
  0xE5FB,  // { 0xF8, 0x5B } PUA
  0xE5FC,  // { 0xF8, 0x5C } PUA
  0xE5FD,  // { 0xF8, 0x5D } PUA
  0xE5FE,  // { 0xF8, 0x5E } PUA
  0xE5FF,  // { 0xF8, 0x5F } PUA
  0xE600,  // { 0xF8, 0x60 } PUA
  0xE601,  // { 0xF8, 0x61 } PUA
  0xE602,  // { 0xF8, 0x62 } PUA
  0xE603,  // { 0xF8, 0x63 } PUA
  0xE604,  // { 0xF8, 0x64 } PUA
  0xE605,  // { 0xF8, 0x65 } PUA
  0xE606,  // { 0xF8, 0x66 } PUA
  0xE607,  // { 0xF8, 0x67 } PUA
  0xE608,  // { 0xF8, 0x68 } PUA
  0xE609,  // { 0xF8, 0x69 } PUA
  0xE60A,  // { 0xF8, 0x6A } PUA
  0xE60B,  // { 0xF8, 0x6B } PUA
  0xE60C,  // { 0xF8, 0x6C } PUA
  0xE60D,  // { 0xF8, 0x6D } PUA
  0xE60E,  // { 0xF8, 0x6E } PUA
  0xE60F,  // { 0xF8, 0x6F } PUA
  0xE610,  // { 0xF8, 0x70 } PUA
  0xE611,  // { 0xF8, 0x71 } PUA
  0xE612,  // { 0xF8, 0x72 } PUA
  0xE613,  // { 0xF8, 0x73 } PUA
  0xE614,  // { 0xF8, 0x74 } PUA
  0xE615,  // { 0xF8, 0x75 } PUA
  0xE616,  // { 0xF8, 0x76 } PUA
  0xE617,  // { 0xF8, 0x77 } PUA
  0xE618,  // { 0xF8, 0x78 } PUA
  0xE619,  // { 0xF8, 0x79 } PUA
  0xE61A,  // { 0xF8, 0x7A } PUA
  0xE61B,  // { 0xF8, 0x7B } PUA
  0xE61C,  // { 0xF8, 0x7C } PUA
  0xE61D,  // { 0xF8, 0x7D } PUA
  0xE61E,  // { 0xF8, 0x7E } PUA
  0xE61F,  // { 0xF8, 0x80 } PUA
  0xE620,  // { 0xF8, 0x81 } PUA
  0xE621,  // { 0xF8, 0x82 } PUA
  0xE622,  // { 0xF8, 0x83 } PUA
  0xE623,  // { 0xF8, 0x84 } PUA
  0xE624,  // { 0xF8, 0x85 } PUA
  0xE625,  // { 0xF8, 0x86 } PUA
  0xE626,  // { 0xF8, 0x87 } PUA
  0xE627,  // { 0xF8, 0x88 } PUA
  0xE628,  // { 0xF8, 0x89 } PUA
  0xE629,  // { 0xF8, 0x8A } PUA
  0xE62A,  // { 0xF8, 0x8B } PUA
  0xE62B,  // { 0xF8, 0x8C } PUA
  0xE62C,  // { 0xF8, 0x8D } PUA
  0xE62D,  // { 0xF8, 0x8E } PUA
  0xE62E,  // { 0xF8, 0x8F } PUA
  0xE62F,  // { 0xF8, 0x90 } PUA
  0xE630,  // { 0xF8, 0x91 } PUA
  0xE631,  // { 0xF8, 0x92 } PUA
  0xE632,  // { 0xF8, 0x93 } PUA
  0xE633,  // { 0xF8, 0x94 } PUA
  0xE634,  // { 0xF8, 0x95 } PUA
  0xE635,  // { 0xF8, 0x96 } PUA
  0xE636,  // { 0xF8, 0x97 } PUA
  0xE637,  // { 0xF8, 0x98 } PUA
  0xE638,  // { 0xF8, 0x99 } PUA
  0xE639,  // { 0xF8, 0x9A } PUA
  0xE63A,  // { 0xF8, 0x9B } PUA
  0xE63B,  // { 0xF8, 0x9C } PUA
  0xE63C,  // { 0xF8, 0x9D } PUA
  0xE63D,  // { 0xF8, 0x9E } PUA
  0xE63E,  // { 0xF8, 0x9F } PUA
  0xE63F,  // { 0xF8, 0xA0 } PUA
  0xE640,  // { 0xF8, 0xA1 } PUA
  0xE641,  // { 0xF8, 0xA2 } PUA
  0xE642,  // { 0xF8, 0xA3 } PUA
  0xE643,  // { 0xF8, 0xA4 } PUA
  0xE644,  // { 0xF8, 0xA5 } PUA
  0xE645,  // { 0xF8, 0xA6 } PUA
  0xE646,  // { 0xF8, 0xA7 } PUA
  0xE647,  // { 0xF8, 0xA8 } PUA
  0xE648,  // { 0xF8, 0xA9 } PUA
  0xE649,  // { 0xF8, 0xAA } PUA
  0xE64A,  // { 0xF8, 0xAB } PUA
  0xE64B,  // { 0xF8, 0xAC } PUA
  0xE64C,  // { 0xF8, 0xAD } PUA
  0xE64D,  // { 0xF8, 0xAE } PUA
  0xE64E,  // { 0xF8, 0xAF } PUA
  0xE64F,  // { 0xF8, 0xB0 } PUA
  0xE650,  // { 0xF8, 0xB1 } PUA
  0xE651,  // { 0xF8, 0xB2 } PUA
  0xE652,  // { 0xF8, 0xB3 } PUA
  0xE653,  // { 0xF8, 0xB4 } PUA
  0xE654,  // { 0xF8, 0xB5 } PUA
  0xE655,  // { 0xF8, 0xB6 } PUA
  0xE656,  // { 0xF8, 0xB7 } PUA
  0xE657,  // { 0xF8, 0xB8 } PUA
  0xE658,  // { 0xF8, 0xB9 } PUA
  0xE659,  // { 0xF8, 0xBA } PUA
  0xE65A,  // { 0xF8, 0xBB } PUA
  0xE65B,  // { 0xF8, 0xBC } PUA
  0xE65C,  // { 0xF8, 0xBD } PUA
  0xE65D,  // { 0xF8, 0xBE } PUA
  0xE65E,  // { 0xF8, 0xBF } PUA
  0xE65F,  // { 0xF8, 0xC0 } PUA
  0xE660,  // { 0xF8, 0xC1 } PUA
  0xE661,  // { 0xF8, 0xC2 } PUA
  0xE662,  // { 0xF8, 0xC3 } PUA
  0xE663,  // { 0xF8, 0xC4 } PUA
  0xE664,  // { 0xF8, 0xC5 } PUA
  0xE665,  // { 0xF8, 0xC6 } PUA
  0xE666,  // { 0xF8, 0xC7 } PUA
  0xE667,  // { 0xF8, 0xC8 } PUA
  0xE668,  // { 0xF8, 0xC9 } PUA
  0xE669,  // { 0xF8, 0xCA } PUA
  0xE66A,  // { 0xF8, 0xCB } PUA
  0xE66B,  // { 0xF8, 0xCC } PUA
  0xE66C,  // { 0xF8, 0xCD } PUA
  0xE66D,  // { 0xF8, 0xCE } PUA
  0xE66E,  // { 0xF8, 0xCF } PUA
  0xE66F,  // { 0xF8, 0xD0 } PUA
  0xE670,  // { 0xF8, 0xD1 } PUA
  0xE671,  // { 0xF8, 0xD2 } PUA
  0xE672,  // { 0xF8, 0xD3 } PUA
  0xE673,  // { 0xF8, 0xD4 } PUA
  0xE674,  // { 0xF8, 0xD5 } PUA
  0xE675,  // { 0xF8, 0xD6 } PUA
  0xE676,  // { 0xF8, 0xD7 } PUA
  0xE677,  // { 0xF8, 0xD8 } PUA
  0xE678,  // { 0xF8, 0xD9 } PUA
  0xE679,  // { 0xF8, 0xDA } PUA
  0xE67A,  // { 0xF8, 0xDB } PUA
  0xE67B,  // { 0xF8, 0xDC } PUA
  0xE67C,  // { 0xF8, 0xDD } PUA
  0xE67D,  // { 0xF8, 0xDE } PUA
  0xE67E,  // { 0xF8, 0xDF } PUA
  0xE67F,  // { 0xF8, 0xE0 } PUA
  0xE680,  // { 0xF8, 0xE1 } PUA
  0xE681,  // { 0xF8, 0xE2 } PUA
  0xE682,  // { 0xF8, 0xE3 } PUA
  0xE683,  // { 0xF8, 0xE4 } PUA
  0xE684,  // { 0xF8, 0xE5 } PUA
  0xE685,  // { 0xF8, 0xE6 } PUA
  0xE686,  // { 0xF8, 0xE7 } PUA
  0xE687,  // { 0xF8, 0xE8 } PUA
  0xE688,  // { 0xF8, 0xE9 } PUA
  0xE689,  // { 0xF8, 0xEA } PUA
  0xE68A,  // { 0xF8, 0xEB } PUA
  0xE68B,  // { 0xF8, 0xEC } PUA
  0xE68C,  // { 0xF8, 0xED } PUA
  0xE68D,  // { 0xF8, 0xEE } PUA
  0xE68E,  // { 0xF8, 0xEF } PUA
  0xE68F,  // { 0xF8, 0xF0 } PUA
  0xE690,  // { 0xF8, 0xF1 } PUA
  0xE691,  // { 0xF8, 0xF2 } PUA
  0xE692,  // { 0xF8, 0xF3 } PUA
  0xE693,  // { 0xF8, 0xF4 } PUA
  0xE694,  // { 0xF8, 0xF5 } PUA
  0xE695,  // { 0xF8, 0xF6 } PUA
  0xE696,  // { 0xF8, 0xF7 } PUA
  0xE697,  // { 0xF8, 0xF8 } PUA
  0xE698,  // { 0xF8, 0xF9 } PUA
  0xE699,  // { 0xF8, 0xFA } PUA
  0xE69A,  // { 0xF8, 0xFB } PUA
  0xE69B,  // { 0xF8, 0xFC } PUA
  0x0000,  // { 0xF8, 0xFD }
  0x0000,  // { 0xF8, 0xFE }
  0x0000,  // { 0xF8, 0xFF }
  0xE69C,  // { 0xF9, 0x40 } PUA
  0xE69D,  // { 0xF9, 0x41 } PUA
  0xE69E,  // { 0xF9, 0x42 } PUA
  0xE69F,  // { 0xF9, 0x43 } PUA
  0xE6A0,  // { 0xF9, 0x44 } PUA
  0xE6A1,  // { 0xF9, 0x45 } PUA
  0xE6A2,  // { 0xF9, 0x46 } PUA
  0xE6A3,  // { 0xF9, 0x47 } PUA
  0xE6A4,  // { 0xF9, 0x48 } PUA
  0xE6A5,  // { 0xF9, 0x49 } PUA
  0xE6A6,  // { 0xF9, 0x4A } PUA
  0xE6A7,  // { 0xF9, 0x4B } PUA
  0xE6A8,  // { 0xF9, 0x4C } PUA
  0xE6A9,  // { 0xF9, 0x4D } PUA
  0xE6AA,  // { 0xF9, 0x4E } PUA
  0xE6AB,  // { 0xF9, 0x4F } PUA
  0xE6AC,  // { 0xF9, 0x50 } PUA
  0xE6AD,  // { 0xF9, 0x51 } PUA
  0xE6AE,  // { 0xF9, 0x52 } PUA
  0xE6AF,  // { 0xF9, 0x53 } PUA
  0xE6B0,  // { 0xF9, 0x54 } PUA
  0xE6B1,  // { 0xF9, 0x55 } PUA
  0xE6B2,  // { 0xF9, 0x56 } PUA
  0xE6B3,  // { 0xF9, 0x57 } PUA
  0xE6B4,  // { 0xF9, 0x58 } PUA
  0xE6B5,  // { 0xF9, 0x59 } PUA
  0xE6B6,  // { 0xF9, 0x5A } PUA
  0xE6B7,  // { 0xF9, 0x5B } PUA
  0xE6B8,  // { 0xF9, 0x5C } PUA
  0xE6B9,  // { 0xF9, 0x5D } PUA
  0xE6BA,  // { 0xF9, 0x5E } PUA
  0xE6BB,  // { 0xF9, 0x5F } PUA
  0xE6BC,  // { 0xF9, 0x60 } PUA
  0xE6BD,  // { 0xF9, 0x61 } PUA
  0xE6BE,  // { 0xF9, 0x62 } PUA
  0xE6BF,  // { 0xF9, 0x63 } PUA
  0xE6C0,  // { 0xF9, 0x64 } PUA
  0xE6C1,  // { 0xF9, 0x65 } PUA
  0xE6C2,  // { 0xF9, 0x66 } PUA
  0xE6C3,  // { 0xF9, 0x67 } PUA
  0xE6C4,  // { 0xF9, 0x68 } PUA
  0xE6C5,  // { 0xF9, 0x69 } PUA
  0xE6C6,  // { 0xF9, 0x6A } PUA
  0xE6C7,  // { 0xF9, 0x6B } PUA
  0xE6C8,  // { 0xF9, 0x6C } PUA
  0xE6C9,  // { 0xF9, 0x6D } PUA
  0xE6CA,  // { 0xF9, 0x6E } PUA
  0xE6CB,  // { 0xF9, 0x6F } PUA
  0xE6CC,  // { 0xF9, 0x70 } PUA
  0xE6CD,  // { 0xF9, 0x71 } PUA
  0xE6CE,  // { 0xF9, 0x72 } PUA
  0xE6CF,  // { 0xF9, 0x73 } PUA
  0xE6D0,  // { 0xF9, 0x74 } PUA
  0xE6D1,  // { 0xF9, 0x75 } PUA
  0xE6D2,  // { 0xF9, 0x76 } PUA
  0xE6D3,  // { 0xF9, 0x77 } PUA
  0xE6D4,  // { 0xF9, 0x78 } PUA
  0xE6D5,  // { 0xF9, 0x79 } PUA
  0xE6D6,  // { 0xF9, 0x7A } PUA
  0xE6D7,  // { 0xF9, 0x7B } PUA
  0xE6D8,  // { 0xF9, 0x7C } PUA
  0xE6D9,  // { 0xF9, 0x7D } PUA
  0xE6DA,  // { 0xF9, 0x7E } PUA
  0xE6DB,  // { 0xF9, 0x80 } PUA
  0xE6DC,  // { 0xF9, 0x81 } PUA
  0xE6DD,  // { 0xF9, 0x82 } PUA
  0xE6DE,  // { 0xF9, 0x83 } PUA
  0xE6DF,  // { 0xF9, 0x84 } PUA
  0xE6E0,  // { 0xF9, 0x85 } PUA
  0xE6E1,  // { 0xF9, 0x86 } PUA
  0xE6E2,  // { 0xF9, 0x87 } PUA
  0xE6E3,  // { 0xF9, 0x88 } PUA
  0xE6E4,  // { 0xF9, 0x89 } PUA
  0xE6E5,  // { 0xF9, 0x8A } PUA
  0xE6E6,  // { 0xF9, 0x8B } PUA
  0xE6E7,  // { 0xF9, 0x8C } PUA
  0xE6E8,  // { 0xF9, 0x8D } PUA
  0xE6E9,  // { 0xF9, 0x8E } PUA
  0xE6EA,  // { 0xF9, 0x8F } PUA
  0xE6EB,  // { 0xF9, 0x90 } PUA
  0xE6EC,  // { 0xF9, 0x91 } PUA
  0xE6ED,  // { 0xF9, 0x92 } PUA
  0xE6EE,  // { 0xF9, 0x93 } PUA
  0xE6EF,  // { 0xF9, 0x94 } PUA
  0xE6F0,  // { 0xF9, 0x95 } PUA
  0xE6F1,  // { 0xF9, 0x96 } PUA
  0xE6F2,  // { 0xF9, 0x97 } PUA
  0xE6F3,  // { 0xF9, 0x98 } PUA
  0xE6F4,  // { 0xF9, 0x99 } PUA
  0xE6F5,  // { 0xF9, 0x9A } PUA
  0xE6F6,  // { 0xF9, 0x9B } PUA
  0xE6F7,  // { 0xF9, 0x9C } PUA
  0xE6F8,  // { 0xF9, 0x9D } PUA
  0xE6F9,  // { 0xF9, 0x9E } PUA
  0xE6FA,  // { 0xF9, 0x9F } PUA
  0xE6FB,  // { 0xF9, 0xA0 } PUA
  0xE6FC,  // { 0xF9, 0xA1 } PUA
  0xE6FD,  // { 0xF9, 0xA2 } PUA
  0xE6FE,  // { 0xF9, 0xA3 } PUA
  0xE6FF,  // { 0xF9, 0xA4 } PUA
  0xE700,  // { 0xF9, 0xA5 } PUA
  0xE701,  // { 0xF9, 0xA6 } PUA
  0xE702,  // { 0xF9, 0xA7 } PUA
  0xE703,  // { 0xF9, 0xA8 } PUA
  0xE704,  // { 0xF9, 0xA9 } PUA
  0xE705,  // { 0xF9, 0xAA } PUA
  0xE706,  // { 0xF9, 0xAB } PUA
  0xE707,  // { 0xF9, 0xAC } PUA
  0xE708,  // { 0xF9, 0xAD } PUA
  0xE709,  // { 0xF9, 0xAE } PUA
  0xE70A,  // { 0xF9, 0xAF } PUA
  0xE70B,  // { 0xF9, 0xB0 } PUA
  0xE70C,  // { 0xF9, 0xB1 } PUA
  0xE70D,  // { 0xF9, 0xB2 } PUA
  0xE70E,  // { 0xF9, 0xB3 } PUA
  0xE70F,  // { 0xF9, 0xB4 } PUA
  0xE710,  // { 0xF9, 0xB5 } PUA
  0xE711,  // { 0xF9, 0xB6 } PUA
  0xE712,  // { 0xF9, 0xB7 } PUA
  0xE713,  // { 0xF9, 0xB8 } PUA
  0xE714,  // { 0xF9, 0xB9 } PUA
  0xE715,  // { 0xF9, 0xBA } PUA
  0xE716,  // { 0xF9, 0xBB } PUA
  0xE717,  // { 0xF9, 0xBC } PUA
  0xE718,  // { 0xF9, 0xBD } PUA
  0xE719,  // { 0xF9, 0xBE } PUA
  0xE71A,  // { 0xF9, 0xBF } PUA
  0xE71B,  // { 0xF9, 0xC0 } PUA
  0xE71C,  // { 0xF9, 0xC1 } PUA
  0xE71D,  // { 0xF9, 0xC2 } PUA
  0xE71E,  // { 0xF9, 0xC3 } PUA
  0xE71F,  // { 0xF9, 0xC4 } PUA
  0xE720,  // { 0xF9, 0xC5 } PUA
  0xE721,  // { 0xF9, 0xC6 } PUA
  0xE722,  // { 0xF9, 0xC7 } PUA
  0xE723,  // { 0xF9, 0xC8 } PUA
  0xE724,  // { 0xF9, 0xC9 } PUA
  0xE725,  // { 0xF9, 0xCA } PUA
  0xE726,  // { 0xF9, 0xCB } PUA
  0xE727,  // { 0xF9, 0xCC } PUA
  0xE728,  // { 0xF9, 0xCD } PUA
  0xE729,  // { 0xF9, 0xCE } PUA
  0xE72A,  // { 0xF9, 0xCF } PUA
  0xE72B,  // { 0xF9, 0xD0 } PUA
  0xE72C,  // { 0xF9, 0xD1 } PUA
  0xE72D,  // { 0xF9, 0xD2 } PUA
  0xE72E,  // { 0xF9, 0xD3 } PUA
  0xE72F,  // { 0xF9, 0xD4 } PUA
  0xE730,  // { 0xF9, 0xD5 } PUA
  0xE731,  // { 0xF9, 0xD6 } PUA
  0xE732,  // { 0xF9, 0xD7 } PUA
  0xE733,  // { 0xF9, 0xD8 } PUA
  0xE734,  // { 0xF9, 0xD9 } PUA
  0xE735,  // { 0xF9, 0xDA } PUA
  0xE736,  // { 0xF9, 0xDB } PUA
  0xE737,  // { 0xF9, 0xDC } PUA
  0xE738,  // { 0xF9, 0xDD } PUA
  0xE739,  // { 0xF9, 0xDE } PUA
  0xE73A,  // { 0xF9, 0xDF } PUA
  0xE73B,  // { 0xF9, 0xE0 } PUA
  0xE73C,  // { 0xF9, 0xE1 } PUA
  0xE73D,  // { 0xF9, 0xE2 } PUA
  0xE73E,  // { 0xF9, 0xE3 } PUA
  0xE73F,  // { 0xF9, 0xE4 } PUA
  0xE740,  // { 0xF9, 0xE5 } PUA
  0xE741,  // { 0xF9, 0xE6 } PUA
  0xE742,  // { 0xF9, 0xE7 } PUA
  0xE743,  // { 0xF9, 0xE8 } PUA
  0xE744,  // { 0xF9, 0xE9 } PUA
  0xE745,  // { 0xF9, 0xEA } PUA
  0xE746,  // { 0xF9, 0xEB } PUA
  0xE747,  // { 0xF9, 0xEC } PUA
  0xE748,  // { 0xF9, 0xED } PUA
  0xE749,  // { 0xF9, 0xEE } PUA
  0xE74A,  // { 0xF9, 0xEF } PUA
  0xE74B,  // { 0xF9, 0xF0 } PUA
  0xE74C,  // { 0xF9, 0xF1 } PUA
  0xE74D,  // { 0xF9, 0xF2 } PUA
  0xE74E,  // { 0xF9, 0xF3 } PUA
  0xE74F,  // { 0xF9, 0xF4 } PUA
  0xE750,  // { 0xF9, 0xF5 } PUA
  0xE751,  // { 0xF9, 0xF6 } PUA
  0xE752,  // { 0xF9, 0xF7 } PUA
  0xE753,  // { 0xF9, 0xF8 } PUA
  0xE754,  // { 0xF9, 0xF9 } PUA
  0xE755,  // { 0xF9, 0xFA } PUA
  0xE756,  // { 0xF9, 0xFB } PUA
  0xE757,  // { 0xF9, 0xFC } PUA
  0x0000,  // { 0xF9, 0xFD }
  0x0000,  // { 0xF9, 0xFE }
  0x0000,  // { 0xF9, 0xFF }
  0x2170,  // { 0xFA, 0x40 } "ⅰ"
  0x2171,  // { 0xFA, 0x41 } "ⅱ"
  0x2172,  // { 0xFA, 0x42 } "ⅲ"
  0x2173,  // { 0xFA, 0x43 } "ⅳ"
  0x2174,  // { 0xFA, 0x44 } "ⅴ"
  0x2175,  // { 0xFA, 0x45 } "ⅵ"
  0x2176,  // { 0xFA, 0x46 } "ⅶ"
  0x2177,  // { 0xFA, 0x47 } "ⅷ"
  0x2178,  // { 0xFA, 0x48 } "ⅸ"
  0x2179,  // { 0xFA, 0x49 } "ⅹ"
  0x2160,  // { 0xFA, 0x4A } "Ⅰ"
  0x2161,  // { 0xFA, 0x4B } "Ⅱ"
  0x2162,  // { 0xFA, 0x4C } "Ⅲ"
  0x2163,  // { 0xFA, 0x4D } "Ⅳ"
  0x2164,  // { 0xFA, 0x4E } "Ⅴ"
  0x2165,  // { 0xFA, 0x4F } "Ⅵ"
  0x2166,  // { 0xFA, 0x50 } "Ⅶ"
  0x2167,  // { 0xFA, 0x51 } "Ⅷ"
  0x2168,  // { 0xFA, 0x52 } "Ⅸ"
  0x2169,  // { 0xFA, 0x53 } "Ⅹ"
  0xFFE2,  // { 0xFA, 0x54 } "￢"
  0xFFE4,  // { 0xFA, 0x55 } "￤"
  0xFF07,  // { 0xFA, 0x56 } "＇"
  0xFF02,  // { 0xFA, 0x57 } "＂"
  0x3231,  // { 0xFA, 0x58 } "㈱"
  0x2116,  // { 0xFA, 0x59 } "№"
  0x2121,  // { 0xFA, 0x5A } "℡"
  0x2235,  // { 0xFA, 0x5B } "∵"
  0x7E8A,  // { 0xFA, 0x5C } "纊"
  0x891C,  // { 0xFA, 0x5D } "褜"
  0x9348,  // { 0xFA, 0x5E } "鍈"
  0x9288,  // { 0xFA, 0x5F } "銈"
  0x84DC,  // { 0xFA, 0x60 } "蓜"
  0x4FC9,  // { 0xFA, 0x61 } "俉"
  0x70BB,  // { 0xFA, 0x62 } "炻"
  0x6631,  // { 0xFA, 0x63 } "昱"
  0x68C8,  // { 0xFA, 0x64 } "棈"
  0x92F9,  // { 0xFA, 0x65 } "鋹"
  0x66FB,  // { 0xFA, 0x66 } "曻"
  0x5F45,  // { 0xFA, 0x67 } "彅"
  0x4E28,  // { 0xFA, 0x68 } "丨"
  0x4EE1,  // { 0xFA, 0x69 } "仡"
  0x4EFC,  // { 0xFA, 0x6A } "仼"
  0x4F00,  // { 0xFA, 0x6B } "伀"
  0x4F03,  // { 0xFA, 0x6C } "伃"
  0x4F39,  // { 0xFA, 0x6D } "伹"
  0x4F56,  // { 0xFA, 0x6E } "佖"
  0x4F92,  // { 0xFA, 0x6F } "侒"
  0x4F8A,  // { 0xFA, 0x70 } "侊"
  0x4F9A,  // { 0xFA, 0x71 } "侚"
  0x4F94,  // { 0xFA, 0x72 } "侔"
  0x4FCD,  // { 0xFA, 0x73 } "俍"
  0x5040,  // { 0xFA, 0x74 } "偀"
  0x5022,  // { 0xFA, 0x75 } "倢"
  0x4FFF,  // { 0xFA, 0x76 } "俿"
  0x501E,  // { 0xFA, 0x77 } "倞"
  0x5046,  // { 0xFA, 0x78 } "偆"
  0x5070,  // { 0xFA, 0x79 } "偰"
  0x5042,  // { 0xFA, 0x7A } "偂"
  0x5094,  // { 0xFA, 0x7B } "傔"
  0x50F4,  // { 0xFA, 0x7C } "僴"
  0x50D8,  // { 0xFA, 0x7D } "僘"
  0x514A,  // { 0xFA, 0x7E } "兊"
  0x5164,  // { 0xFA, 0x80 } "兤"
  0x519D,  // { 0xFA, 0x81 } "冝"
  0x51BE,  // { 0xFA, 0x82 } "冾"
  0x51EC,  // { 0xFA, 0x83 } "凬"
  0x5215,  // { 0xFA, 0x84 } "刕"
  0x529C,  // { 0xFA, 0x85 } "劜"
  0x52A6,  // { 0xFA, 0x86 } "劦"
  0x52C0,  // { 0xFA, 0x87 } "勀"
  0x52DB,  // { 0xFA, 0x88 } "勛"
  0x5300,  // { 0xFA, 0x89 } "匀"
  0x5307,  // { 0xFA, 0x8A } "匇"
  0x5324,  // { 0xFA, 0x8B } "匤"
  0x5372,  // { 0xFA, 0x8C } "卲"
  0x5393,  // { 0xFA, 0x8D } "厓"
  0x53B2,  // { 0xFA, 0x8E } "厲"
  0x53DD,  // { 0xFA, 0x8F } "叝"
  0xFA0E,  // { 0xFA, 0x90 } "﨎"
  0x549C,  // { 0xFA, 0x91 } "咜"
  0x548A,  // { 0xFA, 0x92 } "咊"
  0x54A9,  // { 0xFA, 0x93 } "咩"
  0x54FF,  // { 0xFA, 0x94 } "哿"
  0x5586,  // { 0xFA, 0x95 } "喆"
  0x5759,  // { 0xFA, 0x96 } "坙"
  0x5765,  // { 0xFA, 0x97 } "坥"
  0x57AC,  // { 0xFA, 0x98 } "垬"
  0x57C8,  // { 0xFA, 0x99 } "埈"
  0x57C7,  // { 0xFA, 0x9A } "埇"
  0xFA0F,  // { 0xFA, 0x9B } "﨏"
  0xFA10,  // { 0xFA, 0x9C } "塚"
  0x589E,  // { 0xFA, 0x9D } "增"
  0x58B2,  // { 0xFA, 0x9E } "墲"
  0x590B,  // { 0xFA, 0x9F } "夋"
  0x5953,  // { 0xFA, 0xA0 } "奓"
  0x595B,  // { 0xFA, 0xA1 } "奛"
  0x595D,  // { 0xFA, 0xA2 } "奝"
  0x5963,  // { 0xFA, 0xA3 } "奣"
  0x59A4,  // { 0xFA, 0xA4 } "妤"
  0x59BA,  // { 0xFA, 0xA5 } "妺"
  0x5B56,  // { 0xFA, 0xA6 } "孖"
  0x5BC0,  // { 0xFA, 0xA7 } "寀"
  0x752F,  // { 0xFA, 0xA8 } "甯"
  0x5BD8,  // { 0xFA, 0xA9 } "寘"
  0x5BEC,  // { 0xFA, 0xAA } "寬"
  0x5C1E,  // { 0xFA, 0xAB } "尞"
  0x5CA6,  // { 0xFA, 0xAC } "岦"
  0x5CBA,  // { 0xFA, 0xAD } "岺"
  0x5CF5,  // { 0xFA, 0xAE } "峵"
  0x5D27,  // { 0xFA, 0xAF } "崧"
  0x5D53,  // { 0xFA, 0xB0 } "嵓"
  0xFA11,  // { 0xFA, 0xB1 } "﨑"
  0x5D42,  // { 0xFA, 0xB2 } "嵂"
  0x5D6D,  // { 0xFA, 0xB3 } "嵭"
  0x5DB8,  // { 0xFA, 0xB4 } "嶸"
  0x5DB9,  // { 0xFA, 0xB5 } "嶹"
  0x5DD0,  // { 0xFA, 0xB6 } "巐"
  0x5F21,  // { 0xFA, 0xB7 } "弡"
  0x5F34,  // { 0xFA, 0xB8 } "弴"
  0x5F67,  // { 0xFA, 0xB9 } "彧"
  0x5FB7,  // { 0xFA, 0xBA } "德"
  0x5FDE,  // { 0xFA, 0xBB } "忞"
  0x605D,  // { 0xFA, 0xBC } "恝"
  0x6085,  // { 0xFA, 0xBD } "悅"
  0x608A,  // { 0xFA, 0xBE } "悊"
  0x60DE,  // { 0xFA, 0xBF } "惞"
  0x60D5,  // { 0xFA, 0xC0 } "惕"
  0x6120,  // { 0xFA, 0xC1 } "愠"
  0x60F2,  // { 0xFA, 0xC2 } "惲"
  0x6111,  // { 0xFA, 0xC3 } "愑"
  0x6137,  // { 0xFA, 0xC4 } "愷"
  0x6130,  // { 0xFA, 0xC5 } "愰"
  0x6198,  // { 0xFA, 0xC6 } "憘"
  0x6213,  // { 0xFA, 0xC7 } "戓"
  0x62A6,  // { 0xFA, 0xC8 } "抦"
  0x63F5,  // { 0xFA, 0xC9 } "揵"
  0x6460,  // { 0xFA, 0xCA } "摠"
  0x649D,  // { 0xFA, 0xCB } "撝"
  0x64CE,  // { 0xFA, 0xCC } "擎"
  0x654E,  // { 0xFA, 0xCD } "敎"
  0x6600,  // { 0xFA, 0xCE } "昀"
  0x6615,  // { 0xFA, 0xCF } "昕"
  0x663B,  // { 0xFA, 0xD0 } "昻"
  0x6609,  // { 0xFA, 0xD1 } "昉"
  0x662E,  // { 0xFA, 0xD2 } "昮"
  0x661E,  // { 0xFA, 0xD3 } "昞"
  0x6624,  // { 0xFA, 0xD4 } "昤"
  0x6665,  // { 0xFA, 0xD5 } "晥"
  0x6657,  // { 0xFA, 0xD6 } "晗"
  0x6659,  // { 0xFA, 0xD7 } "晙"
  0xFA12,  // { 0xFA, 0xD8 } "晴"
  0x6673,  // { 0xFA, 0xD9 } "晳"
  0x6699,  // { 0xFA, 0xDA } "暙"
  0x66A0,  // { 0xFA, 0xDB } "暠"
  0x66B2,  // { 0xFA, 0xDC } "暲"
  0x66BF,  // { 0xFA, 0xDD } "暿"
  0x66FA,  // { 0xFA, 0xDE } "曺"
  0x670E,  // { 0xFA, 0xDF } "朎"
  0xF929,  // { 0xFA, 0xE0 } "朗"
  0x6766,  // { 0xFA, 0xE1 } "杦"
  0x67BB,  // { 0xFA, 0xE2 } "枻"
  0x6852,  // { 0xFA, 0xE3 } "桒"
  0x67C0,  // { 0xFA, 0xE4 } "柀"
  0x6801,  // { 0xFA, 0xE5 } "栁"
  0x6844,  // { 0xFA, 0xE6 } "桄"
  0x68CF,  // { 0xFA, 0xE7 } "棏"
  0xFA13,  // { 0xFA, 0xE8 } "﨓"
  0x6968,  // { 0xFA, 0xE9 } "楨"
  0xFA14,  // { 0xFA, 0xEA } "﨔"
  0x6998,  // { 0xFA, 0xEB } "榘"
  0x69E2,  // { 0xFA, 0xEC } "槢"
  0x6A30,  // { 0xFA, 0xED } "樰"
  0x6A6B,  // { 0xFA, 0xEE } "橫"
  0x6A46,  // { 0xFA, 0xEF } "橆"
  0x6A73,  // { 0xFA, 0xF0 } "橳"
  0x6A7E,  // { 0xFA, 0xF1 } "橾"
  0x6AE2,  // { 0xFA, 0xF2 } "櫢"
  0x6AE4,  // { 0xFA, 0xF3 } "櫤"
  0x6BD6,  // { 0xFA, 0xF4 } "毖"
  0x6C3F,  // { 0xFA, 0xF5 } "氿"
  0x6C5C,  // { 0xFA, 0xF6 } "汜"
  0x6C86,  // { 0xFA, 0xF7 } "沆"
  0x6C6F,  // { 0xFA, 0xF8 } "汯"
  0x6CDA,  // { 0xFA, 0xF9 } "泚"
  0x6D04,  // { 0xFA, 0xFA } "洄"
  0x6D87,  // { 0xFA, 0xFB } "涇"
  0x6D6F,  // { 0xFA, 0xFC } "浯"
  0x0000,  // { 0xFA, 0xFD }
  0x0000,  // { 0xFA, 0xFE }
  0x0000,  // { 0xFA, 0xFF }
  0x6D96,  // { 0xFB, 0x40 } "涖"
  0x6DAC,  // { 0xFB, 0x41 } "涬"
  0x6DCF,  // { 0xFB, 0x42 } "淏"
  0x6DF8,  // { 0xFB, 0x43 } "淸"
  0x6DF2,  // { 0xFB, 0x44 } "淲"
  0x6DFC,  // { 0xFB, 0x45 } "淼"
  0x6E39,  // { 0xFB, 0x46 } "渹"
  0x6E5C,  // { 0xFB, 0x47 } "湜"
  0x6E27,  // { 0xFB, 0x48 } "渧"
  0x6E3C,  // { 0xFB, 0x49 } "渼"
  0x6EBF,  // { 0xFB, 0x4A } "溿"
  0x6F88,  // { 0xFB, 0x4B } "澈"
  0x6FB5,  // { 0xFB, 0x4C } "澵"
  0x6FF5,  // { 0xFB, 0x4D } "濵"
  0x7005,  // { 0xFB, 0x4E } "瀅"
  0x7007,  // { 0xFB, 0x4F } "瀇"
  0x7028,  // { 0xFB, 0x50 } "瀨"
  0x7085,  // { 0xFB, 0x51 } "炅"
  0x70AB,  // { 0xFB, 0x52 } "炫"
  0x710F,  // { 0xFB, 0x53 } "焏"
  0x7104,  // { 0xFB, 0x54 } "焄"
  0x715C,  // { 0xFB, 0x55 } "煜"
  0x7146,  // { 0xFB, 0x56 } "煆"
  0x7147,  // { 0xFB, 0x57 } "煇"
  0xFA15,  // { 0xFB, 0x58 } "凞"
  0x71C1,  // { 0xFB, 0x59 } "燁"
  0x71FE,  // { 0xFB, 0x5A } "燾"
  0x72B1,  // { 0xFB, 0x5B } "犱"
  0x72BE,  // { 0xFB, 0x5C } "犾"
  0x7324,  // { 0xFB, 0x5D } "猤"
  0xFA16,  // { 0xFB, 0x5E } "猪"
  0x7377,  // { 0xFB, 0x5F } "獷"
  0x73BD,  // { 0xFB, 0x60 } "玽"
  0x73C9,  // { 0xFB, 0x61 } "珉"
  0x73D6,  // { 0xFB, 0x62 } "珖"
  0x73E3,  // { 0xFB, 0x63 } "珣"
  0x73D2,  // { 0xFB, 0x64 } "珒"
  0x7407,  // { 0xFB, 0x65 } "琇"
  0x73F5,  // { 0xFB, 0x66 } "珵"
  0x7426,  // { 0xFB, 0x67 } "琦"
  0x742A,  // { 0xFB, 0x68 } "琪"
  0x7429,  // { 0xFB, 0x69 } "琩"
  0x742E,  // { 0xFB, 0x6A } "琮"
  0x7462,  // { 0xFB, 0x6B } "瑢"
  0x7489,  // { 0xFB, 0x6C } "璉"
  0x749F,  // { 0xFB, 0x6D } "璟"
  0x7501,  // { 0xFB, 0x6E } "甁"
  0x756F,  // { 0xFB, 0x6F } "畯"
  0x7682,  // { 0xFB, 0x70 } "皂"
  0x769C,  // { 0xFB, 0x71 } "皜"
  0x769E,  // { 0xFB, 0x72 } "皞"
  0x769B,  // { 0xFB, 0x73 } "皛"
  0x76A6,  // { 0xFB, 0x74 } "皦"
  0xFA17,  // { 0xFB, 0x75 } "益"
  0x7746,  // { 0xFB, 0x76 } "睆"
  0x52AF,  // { 0xFB, 0x77 } "劯"
  0x7821,  // { 0xFB, 0x78 } "砡"
  0x784E,  // { 0xFB, 0x79 } "硎"
  0x7864,  // { 0xFB, 0x7A } "硤"
  0x787A,  // { 0xFB, 0x7B } "硺"
  0x7930,  // { 0xFB, 0x7C } "礰"
  0xFA18,  // { 0xFB, 0x7D } "礼"
  0xFA19,  // { 0xFB, 0x7E } "神"
  0xFA1A,  // { 0xFB, 0x80 } "祥"
  0x7994,  // { 0xFB, 0x81 } "禔"
  0xFA1B,  // { 0xFB, 0x82 } "福"
  0x799B,  // { 0xFB, 0x83 } "禛"
  0x7AD1,  // { 0xFB, 0x84 } "竑"
  0x7AE7,  // { 0xFB, 0x85 } "竧"
  0xFA1C,  // { 0xFB, 0x86 } "靖"
  0x7AEB,  // { 0xFB, 0x87 } "竫"
  0x7B9E,  // { 0xFB, 0x88 } "箞"
  0xFA1D,  // { 0xFB, 0x89 } "精"
  0x7D48,  // { 0xFB, 0x8A } "絈"
  0x7D5C,  // { 0xFB, 0x8B } "絜"
  0x7DB7,  // { 0xFB, 0x8C } "綷"
  0x7DA0,  // { 0xFB, 0x8D } "綠"
  0x7DD6,  // { 0xFB, 0x8E } "緖"
  0x7E52,  // { 0xFB, 0x8F } "繒"
  0x7F47,  // { 0xFB, 0x90 } "罇"
  0x7FA1,  // { 0xFB, 0x91 } "羡"
  0xFA1E,  // { 0xFB, 0x92 } "羽"
  0x8301,  // { 0xFB, 0x93 } "茁"
  0x8362,  // { 0xFB, 0x94 } "荢"
  0x837F,  // { 0xFB, 0x95 } "荿"
  0x83C7,  // { 0xFB, 0x96 } "菇"
  0x83F6,  // { 0xFB, 0x97 } "菶"
  0x8448,  // { 0xFB, 0x98 } "葈"
  0x84B4,  // { 0xFB, 0x99 } "蒴"
  0x8553,  // { 0xFB, 0x9A } "蕓"
  0x8559,  // { 0xFB, 0x9B } "蕙"
  0x856B,  // { 0xFB, 0x9C } "蕫"
  0xFA1F,  // { 0xFB, 0x9D } "﨟"
  0x85B0,  // { 0xFB, 0x9E } "薰"
  0xFA20,  // { 0xFB, 0x9F } "蘒"
  0xFA21,  // { 0xFB, 0xA0 } "﨡"
  0x8807,  // { 0xFB, 0xA1 } "蠇"
  0x88F5,  // { 0xFB, 0xA2 } "裵"
  0x8A12,  // { 0xFB, 0xA3 } "訒"
  0x8A37,  // { 0xFB, 0xA4 } "訷"
  0x8A79,  // { 0xFB, 0xA5 } "詹"
  0x8AA7,  // { 0xFB, 0xA6 } "誧"
  0x8ABE,  // { 0xFB, 0xA7 } "誾"
  0x8ADF,  // { 0xFB, 0xA8 } "諟"
  0xFA22,  // { 0xFB, 0xA9 } "諸"
  0x8AF6,  // { 0xFB, 0xAA } "諶"
  0x8B53,  // { 0xFB, 0xAB } "譓"
  0x8B7F,  // { 0xFB, 0xAC } "譿"
  0x8CF0,  // { 0xFB, 0xAD } "賰"
  0x8CF4,  // { 0xFB, 0xAE } "賴"
  0x8D12,  // { 0xFB, 0xAF } "贒"
  0x8D76,  // { 0xFB, 0xB0 } "赶"
  0xFA23,  // { 0xFB, 0xB1 } "﨣"
  0x8ECF,  // { 0xFB, 0xB2 } "軏"
  0xFA24,  // { 0xFB, 0xB3 } "﨤"
  0xFA25,  // { 0xFB, 0xB4 } "逸"
  0x9067,  // { 0xFB, 0xB5 } "遧"
  0x90DE,  // { 0xFB, 0xB6 } "郞"
  0xFA26,  // { 0xFB, 0xB7 } "都"
  0x9115,  // { 0xFB, 0xB8 } "鄕"
  0x9127,  // { 0xFB, 0xB9 } "鄧"
  0x91DA,  // { 0xFB, 0xBA } "釚"
  0x91D7,  // { 0xFB, 0xBB } "釗"
  0x91DE,  // { 0xFB, 0xBC } "釞"
  0x91ED,  // { 0xFB, 0xBD } "釭"
  0x91EE,  // { 0xFB, 0xBE } "釮"
  0x91E4,  // { 0xFB, 0xBF } "釤"
  0x91E5,  // { 0xFB, 0xC0 } "釥"
  0x9206,  // { 0xFB, 0xC1 } "鈆"
  0x9210,  // { 0xFB, 0xC2 } "鈐"
  0x920A,  // { 0xFB, 0xC3 } "鈊"
  0x923A,  // { 0xFB, 0xC4 } "鈺"
  0x9240,  // { 0xFB, 0xC5 } "鉀"
  0x923C,  // { 0xFB, 0xC6 } "鈼"
  0x924E,  // { 0xFB, 0xC7 } "鉎"
  0x9259,  // { 0xFB, 0xC8 } "鉙"
  0x9251,  // { 0xFB, 0xC9 } "鉑"
  0x9239,  // { 0xFB, 0xCA } "鈹"
  0x9267,  // { 0xFB, 0xCB } "鉧"
  0x92A7,  // { 0xFB, 0xCC } "銧"
  0x9277,  // { 0xFB, 0xCD } "鉷"
  0x9278,  // { 0xFB, 0xCE } "鉸"
  0x92E7,  // { 0xFB, 0xCF } "鋧"
  0x92D7,  // { 0xFB, 0xD0 } "鋗"
  0x92D9,  // { 0xFB, 0xD1 } "鋙"
  0x92D0,  // { 0xFB, 0xD2 } "鋐"
  0xFA27,  // { 0xFB, 0xD3 } "﨧"
  0x92D5,  // { 0xFB, 0xD4 } "鋕"
  0x92E0,  // { 0xFB, 0xD5 } "鋠"
  0x92D3,  // { 0xFB, 0xD6 } "鋓"
  0x9325,  // { 0xFB, 0xD7 } "錥"
  0x9321,  // { 0xFB, 0xD8 } "錡"
  0x92FB,  // { 0xFB, 0xD9 } "鋻"
  0xFA28,  // { 0xFB, 0xDA } "﨨"
  0x931E,  // { 0xFB, 0xDB } "錞"
  0x92FF,  // { 0xFB, 0xDC } "鋿"
  0x931D,  // { 0xFB, 0xDD } "錝"
  0x9302,  // { 0xFB, 0xDE } "錂"
  0x9370,  // { 0xFB, 0xDF } "鍰"
  0x9357,  // { 0xFB, 0xE0 } "鍗"
  0x93A4,  // { 0xFB, 0xE1 } "鎤"
  0x93C6,  // { 0xFB, 0xE2 } "鏆"
  0x93DE,  // { 0xFB, 0xE3 } "鏞"
  0x93F8,  // { 0xFB, 0xE4 } "鏸"
  0x9431,  // { 0xFB, 0xE5 } "鐱"
  0x9445,  // { 0xFB, 0xE6 } "鑅"
  0x9448,  // { 0xFB, 0xE7 } "鑈"
  0x9592,  // { 0xFB, 0xE8 } "閒"
  0xF9DC,  // { 0xFB, 0xE9 } "隆"
  0xFA29,  // { 0xFB, 0xEA } "﨩"
  0x969D,  // { 0xFB, 0xEB } "隝"
  0x96AF,  // { 0xFB, 0xEC } "隯"
  0x9733,  // { 0xFB, 0xED } "霳"
  0x973B,  // { 0xFB, 0xEE } "霻"
  0x9743,  // { 0xFB, 0xEF } "靃"
  0x974D,  // { 0xFB, 0xF0 } "靍"
  0x974F,  // { 0xFB, 0xF1 } "靏"
  0x9751,  // { 0xFB, 0xF2 } "靑"
  0x9755,  // { 0xFB, 0xF3 } "靕"
  0x9857,  // { 0xFB, 0xF4 } "顗"
  0x9865,  // { 0xFB, 0xF5 } "顥"
  0xFA2A,  // { 0xFB, 0xF6 } "飯"
  0xFA2B,  // { 0xFB, 0xF7 } "飼"
  0x9927,  // { 0xFB, 0xF8 } "餧"
  0xFA2C,  // { 0xFB, 0xF9 } "館"
  0x999E,  // { 0xFB, 0xFA } "馞"
  0x9A4E,  // { 0xFB, 0xFB } "驎"
  0x9AD9,  // { 0xFB, 0xFC } "髙"
  0x0000,  // { 0xFB, 0xFD }
  0x0000,  // { 0xFB, 0xFE }
  0x0000,  // { 0xFB, 0xFF }
  0x9ADC,  // { 0xFC, 0x40 } "髜"
  0x9B75,  // { 0xFC, 0x41 } "魵"
  0x9B72,  // { 0xFC, 0x42 } "魲"
  0x9B8F,  // { 0xFC, 0x43 } "鮏"
  0x9BB1,  // { 0xFC, 0x44 } "鮱"
  0x9BBB,  // { 0xFC, 0x45 } "鮻"
  0x9C00,  // { 0xFC, 0x46 } "鰀"
  0x9D70,  // { 0xFC, 0x47 } "鵰"
  0x9D6B,  // { 0xFC, 0x48 } "鵫"
  0xFA2D,  // { 0xFC, 0x49 } "鶴"
  0x9E19,  // { 0xFC, 0x4A } "鸙"
  0x9ED1,  // { 0xFC, 0x4B } "黑"
};

#endif  // MOZC_GUI_BASE_SJIS_TO_UCS2_TABLE_H_
