# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Ugo Riboni <uriboni@fluendo.com>

from twisted.trial.unittest import TestCase

try:
    from elisa.plugins.elisa_updater.resource_provider import UpdaterResourceProvider
except:
    UpdaterResourceProvider = None

from elisa.plugins.base.tests.resource_providers import GenericSetup, UriRegExpTester
from elisa.core.media_uri import MediaUri
from elisa.plugins.base.models.media import RawDataModel

class TestElisaUpdaterResourceProvider(GenericSetup, TestCase, UriRegExpTester):

    resource_class = UpdaterResourceProvider
    working_uris = ['http://www.moovida.com/download/moovida/windows/moovida-mediacenter-1.0.0.exe']
    failing_uris = ['http://www.moovida.com/', 'http://www.moovida.com/sandbox/example-list']
