﻿#region --- License ---
/* Licensed under the MIT/X11 license.
* Copyright (c) 2006-2008 the OpenTK Team.
* This notice may not be removed from any source distribution.
* See license.txt for licensing details.
*/
#endregion
using System;
using System.Collections.Generic;
using System.Text;

namespace MonoMac.OpenGL
{
	/// <summary>
	/// Enumerates available window states.
	/// </summary>
	public enum WindowState
	{
		/// <summary>
		/// The window is in its normal state.
		/// </summary>
		Normal = 0,
		/// <summary>
		/// The window is minimized to the taskbar (also known as 'iconified').
		/// </summary>
		Minimized,
		/// <summary>
		/// The window covers the whole working area, which includes the desktop but not the taskbar and/or panels.
		/// </summary>
		Maximized,
		/// <summary>
		/// The window covers the whole screen, including all taskbars and/or panels.
		/// </summary>
		Fullscreen
	}
}
