/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;

public class SVGPathOutlineHandle
extends AbstractHandle {
    private boolean isHoverHandle = false;

    public SVGPathOutlineHandle(SVGPathFigure sVGPathFigure) {
        this(sVGPathFigure, false);
    }

    public SVGPathOutlineHandle(SVGPathFigure sVGPathFigure, boolean bl) {
        super(sVGPathFigure);
        this.isHoverHandle = bl;
    }

    @Override
    public SVGPathFigure getOwner() {
        return (SVGPathFigure)super.getOwner();
    }

    @Override
    protected Rectangle basicGetBounds() {
        return this.view.drawingToView(this.getOwner().getDrawingArea());
    }

    @Override
    public boolean contains(Point point) {
        return false;
    }

    @Override
    public void trackStart(Point point, int n) {
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        Color color;
        Stroke stroke;
        Color color2;
        Stroke stroke2;
        SVGPathFigure sVGPathFigure = this.getOwner();
        Shape shape = sVGPathFigure.getPath();
        if (sVGPathFigure.get(SVGAttributeKeys.TRANSFORM) != null) {
            shape = ((AffineTransform)sVGPathFigure.get(SVGAttributeKeys.TRANSFORM)).createTransformedShape(shape);
        }
        shape = this.view.getDrawingToViewTransform().createTransformedShape(shape);
        DrawingEditor drawingEditor = this.getEditor();
        if (drawingEditor.getTool().supportsHandleInteraction()) {
            if (this.isHoverHandle) {
                stroke2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1_HOVER);
                color2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1_HOVER);
                stroke = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2_HOVER);
                color = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2_HOVER);
            } else {
                stroke2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1);
                color2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1);
                stroke = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2);
                color = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2);
            }
        } else {
            stroke2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_1_DISABLED);
            color2 = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_1_DISABLED);
            stroke = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_STROKE_2_DISABLED);
            color = drawingEditor.getHandleAttribute(HandleAttributeKeys.BEZIER_PATH_COLOR_2_DISABLED);
        }
        if (stroke2 != null && color2 != null) {
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color2);
            graphics2D.draw(shape);
        }
        if (stroke != null && color != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }
}

