/*
 * Written by Bastien Chevreux (BaCh)
 *
 * Copyright (C) 1997-2000 by the German Cancer Research Center (Deutsches
 *   Krebsforschungszentrum, DKFZ Heidelberg) and Bastien Chevreux
 * Copyright (C) 2000 and later by Bastien Chevreux
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the 
 * Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 * 
 */

// 	$Id$	


#ifndef _util_misc_h
#define _util_misc_h

// use stat (2)
#include <sys/types.h>
#include <sys/stat.h>
// for perror (3C) 
#include <cstdio>

#include <string.h>
#include <time.h>
#include <sys/time.h>

#include <iostream>

#include "stdinc/defines.H"

#include "stdinc/stlincludes.H"


using namespace std;



char * conditionalStrCpy(const char * src);

void dateStamp(ostream & ostr);

void ctout(char * ptr);
void ctinplace(char * ptr);

void splitFullPathAndFileName(const string & what,
			      string & path,
			      string & filename
  );
uint64 countLinesInFile(const string & filename);
void dumpFile(const char * fname, ostream & ostr);


suseconds_t median_suseconds(vector<suseconds_t> & suv);
suseconds_t avg_suseconds(vector<suseconds_t> & suv);
suseconds_t diffsuseconds(timeval & oldtv);


void byteToHumanReadableSize(double b, ostream & o);

uint64 grepMemSizeFromProcFS(const char * fname, const string & identifier);


int ensureDirectory(const string & dirname, bool purge, bool verbose = true);
int purgeCreateDir(const string & dirname, bool verbose);

bool getSTDOUTFromCommand(const string & cmd, string & result);
bool checkRunabilityOfCommand(string cmd);


#endif
