/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvOda_H
#define MvOda_H

#include <iostream>
#include <map>
#include <vector>
#include <list>
#include <assert.h>

//#include <Metview.h>
//#include "MvObs.h"

using namespace std;


class MvOdaBitfieldMember
{
public:
	MvOdaBitfieldMember(string name,int pos, int size) : name_(name), 
						       pos_(pos), 
					               size_(size) {}
	string name() {return name_;}
	int pos() {return pos_;}
	int size() {return size_;}

private:						   
	string name_;
	int pos_;
	int size_;
};


class MvOdaColumn
{
public:
	enum OdaColumnType {None, Int, Float, String, Bitfield};

	MvOdaColumn() : type_(None), num_(0), min_(1.0e+08), max_(-1.0e+08) {};
	void addToStats(float);
	void compStats();

	string name() {return name_;}
	OdaColumnType type() {return type_;}
	string unit() {return unit_;}
	const  vector<MvOdaBitfieldMember*>& bitfield() {return bitfield_;}
	int bitfieldNum() {return bitfield_.size();}

	float  min()  {return min_;}
	float  max()  {return max_;}
	float  avg()  {return avg_;}
	float  std()  {return std_;}
	
	void   setName(string s) {name_=s;}
	void   setType(OdaColumnType s) {type_=s;}
	void   setUnit(string s) {unit_=s;}
	void   addBitfieldMember(MvOdaBitfieldMember* b) {bitfield_.push_back(b);};
	
	
private:
	void clear();

	string name_;
	OdaColumnType type_;
	string unit_;
	vector<MvOdaBitfieldMember*> bitfield_;

	int    num_;
	float  min_;
	float  max_;
	float  avg_;
	float  std_;	

	vector<float> fval_;
	vector<string> sval_;
};

class MvOda
{ 
public:
	MvOda(string);
	~MvOda();
	void init();	  	

	string fileName() {return fileName_;}
	string query()    {return query_;}
	int rowNum()   {return rowNum_;}
	int columnNum() {return data_.size();}

	void generateStats(int);
	void retrieve(string,string);

	const vector<MvOdaColumn*>& column() {return data_;}

protected:			
	void readData();
	
	int rowNum_;
	string fileName_;
	string query_;
	vector<MvOdaColumn*> data_;


};

#endif