/*  This file is part of MED.
 *
 *  COPYRIGHT (C) 1999 - 2011  EDF R&D, CEA/DEN
 *  MED is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MED is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with MED.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "med_config.h"
#include <med.h>
#include "med_outils.h"
#include <string.h>

void _MEDmeshInfoByName30(int dummy, ...) {

/*   med_idt                  fid; */
/*   char *             const meshname; */
/*   med_int *          const spacedim; */
/*   med_int *          const meshdim; */
/*   med_mesh_type *    const meshtype; */
/*   char *             const description; */
/*   char *             const dtunit; */
/*   med_sorting_type * const sortingtype; */
/*   med_int *          const nstep; */
/*   med_axis_type *    const axistype; */
/*   char *             const axisname; */
/*   char *             const axisunit; */

  med_err  _ret=-1;

  va_list params;
  va_start(params,dummy);

  med_idt                    fid         = va_arg(params,med_idt);
  char *             const   meshname    = va_arg(params, char *             const);
  med_int *          const   spacedim    = va_arg(params, med_int *          const);
  med_int *          const   meshdim     = va_arg(params, med_int *          const);
  med_mesh_type *    const   meshtype    = va_arg(params, med_mesh_type *    const);
  char *             const   description = va_arg(params, char *             const);
  char *             const   dtunit      = va_arg(params, char *             const);
  med_sorting_type * const   sortingtype = va_arg(params, med_sorting_type * const);
  med_int *          const   nstep       = va_arg(params, med_int *          const);
  med_axis_type *    const   axistype    = va_arg(params, med_axis_type *    const);
  char *             const   axisname    = va_arg(params, char *             const);
  char *             const   axisunit    = va_arg(params,  char *            const);
  med_err *                  fret        = va_arg(params,med_err *);


  /*
   * On inhibe le gestionnaire d'erreur HDF 5
   */
  _MEDmodeErreurVerrouiller();

  if ( _MEDmeshInfoByName(fid, MED_MAA, meshname, spacedim, meshdim, meshtype,
			  description, dtunit, sortingtype, nstep,axistype,
			  axisname, axisunit)  < 0) {
    MED_ERR_(_ret,MED_ERR_CALL,MED_ERR_API,MED_ERR_MESH_MSG);
    SSCRUTE(meshname);SSCRUTE("MEDmeshInfoByName");
    goto ERROR;
  }

  _ret = 0;

 ERROR:

  va_end(params);
  *fret = _ret;
  return;
}
