*
* $Id: fxaver.F,v 1.1.1.3 1996/11/15 17:35:06 cernlib Exp $
*
* $Log: fxaver.F,v $
* Revision 1.1.1.3  1996/11/15 17:35:06  cernlib
* Import version 7.06
*
* Revision 1.2  1996/11/15 15:06:57  pdflib
* Version 7.06: tabs removed and bug fixed in grsgalo
*
* Revision 1.1.1.1  1996/04/12 15:29:17  plothow
* Version 7.01
*
*
#include "pdf/pilot.h"
C------------------------------------------------------------
C------------- Subroutine to compute a point in x and q**2 --
C------------- for the following parton distributions :    --
C------------- UP Valence, DOWN Valence , GLUON , QBAR ,   --
C------------- UBAR , Strange , Charm , Bottom , Top .     --
C------------- Range of validity :                         --
C-------------                     5.E-05 < x < .95        --
C-------------                     1      <Log10 Q**2 < 8  --
C------------------------------------------------------------
C-------------        Authors :    M. Diemoz
C-------------                     F. Ferroni
C-------------                     E. Longo
C-------------                     G. Martinelli
C------------------------------------------------------------
      SUBROUTINE  FXAVER(X,QSTAR2,STRFUN,FUNC)
C------------------------------------------------------------
C-------------   X is x and QSTAR2 is Q square  -------------
      CHARACTER*(*) STRFUN
C------------------------------------------------------------
C------------ STRFUN specifies the desired function----------
C------------------------------------------------------------
C------------------------------------------------------------
C        IFUN =  1     UP valence      'UPVAL'
C                2     DOWN valence    'DOVAL'
C                3     Gluon           'GLUON'
C                4     Q bar           'QBAR '
C                5     UP bar          'UBAR '
C                6     Strange         'SBAR '
C                7     Charm           'CBAR '
C                8     Bottom          'BBAR '
C                9     Top             'TBAR '
C------------------------------------------------------------
C-------------  FUNC is the output (parton density value)----
C------------------------------------------------------------
      PARAMETER (IX=104,IQ=9,NARG=2,KFUN=9)
C------------------------------------------------------------
C-----------Input tables are given as 104 x points at 9 Q**2
C-----------positions (log spaced in Q**2 and x up to .6
C-----------(90 points). The remaining 14 x points are ------
C----------linearly spaced)----------------------------------
C------------------------------------------------------------
      DIMENSION ARG(NARG),NENT(NARG),ENT(IX+IQ)
      DIMENSION XQDUM(IX,IQ,KFUN)
      DIMENSION Q2(IQ),XCO(IX)
C------------------------------------------------------------
C----------- Next the 9 Q**2 of the input tables are defined
C------------------------------------------------------------
      DATA Q2 /10.,30.,100.,1000.,10000.,100000.,1000000,
     +         10000000.,100000000./
C----------------------------------------------------------------
C----------- And now the 104 x positions ------------------------
C----------------------------------------------------------------
      DATA XCO   /
     +0.5000E-04,0.5545E-04,0.6150E-04,0.6820E-04,0.7564E-04,0.8389E-04,
     +0.9303E-04,0.1032E-03,0.1144E-03,0.1269E-03,0.1407E-03,0.1561E-03,
     +0.1731E-03,0.1920E-03,0.2129E-03,0.2361E-03,0.2619E-03,0.2904E-03,
     +0.3221E-03,0.3572E-03,0.3961E-03,0.4393E-03,0.4872E-03,0.5404E-03,
     +0.5993E-03,0.6646E-03,0.7371E-03,0.8174E-03,0.9066E-03,0.1005E-02,
     +0.1115E-02,0.1237E-02,0.1371E-02,0.1521E-02,0.1687E-02,0.1871E-02,
     +0.2075E-02,0.2301E-02,0.2552E-02,0.2830E-02,0.3139E-02,0.3481E-02,
     +0.3860E-02,0.4281E-02,0.4748E-02,0.5266E-02,0.5840E-02,0.6476E-02,
     +0.7182E-02,0.7966E-02,0.8834E-02,0.9797E-02,0.1087E-01,0.1205E-01,
     +0.1336E-01,0.1482E-01,0.1644E-01,0.1823E-01,0.2022E-01,0.2242E-01,
     +0.2487E-01,0.2758E-01,0.3058E-01,0.3392E-01,0.3762E-01,0.4172E-01,
     +0.4627E-01,0.5131E-01,0.5690E-01,0.6311E-01,0.6999E-01,0.7762E-01,
     +0.8608E-01,0.9547E-01,0.1059E+00,0.1174E+00,0.1302E+00,0.1444E+00,
     +0.1602E+00,0.1776E+00,0.1970E+00,0.2185E+00,0.2423E+00,0.2687E+00,
     +0.2980E+00,0.3305E+00,0.3666E+00,0.4065E+00,0.4508E+00,0.5000E+00,
     +0.5321E+00,0.5643E+00,0.5964E+00,0.6286E+00,0.6607E+00,0.6929E+00,
     +0.7250E+00,0.7571E+00,0.7893E+00,0.8214E+00,0.8536E+00,0.8857E+00,
     +0.9179E+00,0.9500E+00/
      DATA (XQDUM (I,1,1),I=1,104) /
     +0.1154E-01,0.1220E-01,0.1290E-01,0.1363E-01,0.1441E-01,0.1523E-01,
     +0.1610E-01,0.1702E-01,0.1799E-01,0.1901E-01,0.2010E-01,0.2124E-01,
     +0.2245E-01,0.2373E-01,0.2509E-01,0.2652E-01,0.2803E-01,0.2962E-01,
     +0.3131E-01,0.3309E-01,0.3498E-01,0.3697E-01,0.3908E-01,0.4130E-01,
     +0.4365E-01,0.4613E-01,0.4876E-01,0.5153E-01,0.5445E-01,0.5755E-01,
     +0.6082E-01,0.6427E-01,0.6791E-01,0.7176E-01,0.7583E-01,0.8012E-01,
     +0.8465E-01,0.8943E-01,0.9448E-01,0.9981E-01,0.1054E+00,0.1114E+00,
     +0.1176E+00,0.1242E+00,0.1311E+00,0.1385E+00,0.1462E+00,0.1543E+00,
     +0.1628E+00,0.1718E+00,0.1812E+00,0.1912E+00,0.2016E+00,0.2125E+00,
     +0.2239E+00,0.2359E+00,0.2484E+00,0.2615E+00,0.2751E+00,0.2893E+00,
     +0.3040E+00,0.3193E+00,0.3350E+00,0.3513E+00,0.3679E+00,0.3850E+00,
     +0.4023E+00,0.4198E+00,0.4373E+00,0.4548E+00,0.4719E+00,0.4886E+00,
     +0.5045E+00,0.5193E+00,0.5326E+00,0.5440E+00,0.5530E+00,0.5591E+00,
     +0.5617E+00,0.5601E+00,0.5538E+00,0.5421E+00,0.5243E+00,0.5002E+00,
     +0.4693E+00,0.4318E+00,0.3881E+00,0.3390E+00,0.2860E+00,0.2312E+00,
     +0.1982E+00,0.1679E+00,0.1404E+00,0.1157E+00,0.9371E-01,0.7442E-01,
     +0.5769E-01,0.4337E-01,0.3133E-01,0.2144E-01,0.1357E-01,0.7621E-02,
     +0.3496E-02,0.1057E-02/
      DATA (XQDUM (I,1,2),I=1,104) /
     +0.6591E-02,0.6967E-02,0.7364E-02,0.7784E-02,0.8228E-02,0.8697E-02,
     +0.9193E-02,0.9717E-02,0.1027E-01,0.1086E-01,0.1147E-01,0.1213E-01,
     +0.1282E-01,0.1355E-01,0.1432E-01,0.1514E-01,0.1600E-01,0.1691E-01,
     +0.1787E-01,0.1889E-01,0.1997E-01,0.2110E-01,0.2230E-01,0.2357E-01,
     +0.2491E-01,0.2632E-01,0.2782E-01,0.2940E-01,0.3107E-01,0.3283E-01,
     +0.3469E-01,0.3665E-01,0.3872E-01,0.4091E-01,0.4322E-01,0.4566E-01,
     +0.4823E-01,0.5095E-01,0.5381E-01,0.5683E-01,0.6001E-01,0.6336E-01,
     +0.6689E-01,0.7061E-01,0.7453E-01,0.7864E-01,0.8297E-01,0.8752E-01,
     +0.9230E-01,0.9732E-01,0.1026E+00,0.1081E+00,0.1138E+00,0.1199E+00,
     +0.1262E+00,0.1327E+00,0.1395E+00,0.1466E+00,0.1539E+00,0.1615E+00,
     +0.1693E+00,0.1773E+00,0.1855E+00,0.1938E+00,0.2022E+00,0.2106E+00,
     +0.2191E+00,0.2274E+00,0.2355E+00,0.2433E+00,0.2506E+00,0.2573E+00,
     +0.2633E+00,0.2682E+00,0.2719E+00,0.2741E+00,0.2746E+00,0.2731E+00,
     +0.2694E+00,0.2630E+00,0.2539E+00,0.2419E+00,0.2269E+00,0.2088E+00,
     +0.1881E+00,0.1651E+00,0.1404E+00,0.1149E+00,0.8969E-01,0.6600E-01,
     +0.5296E-01,0.4178E-01,0.3235E-01,0.2453E-01,0.1816E-01,0.1305E-01,
     +0.9059E-02,0.6015E-02,0.3770E-02,0.2186E-02,0.1134E-02,0.4973E-03,
     +0.1640E-03,0.3020E-04/
      DATA (XQDUM (I,1,3),I=1,104) /
     +0.7804E+01,0.7693E+01,0.7584E+01,0.7477E+01,0.7371E+01,0.7267E+01,
     +0.7165E+01,0.7064E+01,0.6966E+01,0.6869E+01,0.6773E+01,0.6680E+01,
     +0.6588E+01,0.6498E+01,0.6410E+01,0.6323E+01,0.6238E+01,0.6154E+01,
     +0.6073E+01,0.5993E+01,0.5915E+01,0.5838E+01,0.5763E+01,0.5690E+01,
     +0.5618E+01,0.5549E+01,0.5481E+01,0.5414E+01,0.5350E+01,0.5287E+01,
     +0.5226E+01,0.5166E+01,0.5108E+01,0.5052E+01,0.4997E+01,0.4944E+01,
     +0.4893E+01,0.4843E+01,0.4794E+01,0.4747E+01,0.4701E+01,0.4656E+01,
     +0.4612E+01,0.4569E+01,0.4526E+01,0.4484E+01,0.4443E+01,0.4401E+01,
     +0.4360E+01,0.4317E+01,0.4274E+01,0.4230E+01,0.4184E+01,0.4136E+01,
     +0.4085E+01,0.4032E+01,0.3975E+01,0.3914E+01,0.3848E+01,0.3778E+01,
     +0.3702E+01,0.3619E+01,0.3530E+01,0.3434E+01,0.3330E+01,0.3218E+01,
     +0.3098E+01,0.2970E+01,0.2833E+01,0.2688E+01,0.2536E+01,0.2376E+01,
     +0.2210E+01,0.2038E+01,0.1863E+01,0.1685E+01,0.1506E+01,0.1329E+01,
     +0.1155E+01,0.9871E+00,0.8276E+00,0.6786E+00,0.5424E+00,0.4207E+00,
     +0.3151E+00,0.2262E+00,0.1544E+00,0.9896E-01,0.5864E-01,0.3139E-01,
     +0.2024E-01,0.1269E-01,0.7695E-02,0.4490E-02,0.2502E-02,0.1318E-02,
     +0.6487E-03,0.2929E-03,0.1183E-03,0.4116E-04,0.1161E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,4),I=1,104) /
     +0.6996E+00,0.6995E+00,0.6994E+00,0.6994E+00,0.6994E+00,0.6993E+00,
     +0.6992E+00,0.6991E+00,0.6990E+00,0.6989E+00,0.6988E+00,0.6987E+00,
     +0.6985E+00,0.6983E+00,0.6981E+00,0.6980E+00,0.6977E+00,0.6974E+00,
     +0.6972E+00,0.6969E+00,0.6965E+00,0.6961E+00,0.6957E+00,0.6952E+00,
     +0.6947E+00,0.6941E+00,0.6935E+00,0.6928E+00,0.6920E+00,0.6911E+00,
     +0.6902E+00,0.6891E+00,0.6879E+00,0.6866E+00,0.6852E+00,0.6836E+00,
     +0.6818E+00,0.6799E+00,0.6777E+00,0.6754E+00,0.6727E+00,0.6698E+00,
     +0.6666E+00,0.6631E+00,0.6592E+00,0.6549E+00,0.6502E+00,0.6450E+00,
     +0.6393E+00,0.6331E+00,0.6262E+00,0.6187E+00,0.6105E+00,0.6015E+00,
     +0.5917E+00,0.5811E+00,0.5695E+00,0.5570E+00,0.5435E+00,0.5290E+00,
     +0.5134E+00,0.4966E+00,0.4788E+00,0.4599E+00,0.4400E+00,0.4190E+00,
     +0.3971E+00,0.3744E+00,0.3510E+00,0.3271E+00,0.3028E+00,0.2785E+00,
     +0.2543E+00,0.2305E+00,0.2073E+00,0.1850E+00,0.1638E+00,0.1438E+00,
     +0.1252E+00,0.1079E+00,0.9189E-01,0.7717E-01,0.6363E-01,0.5119E-01,
     +0.3985E-01,0.2967E-01,0.2082E-01,0.1351E-01,0.7893E-02,0.4007E-02,
     +0.2439E-02,0.1414E-02,0.7767E-03,0.4008E-03,0.1924E-03,0.8481E-04,
     +0.3374E-04,0.1183E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,5),I=1,104) /
     +0.2915E+00,0.2915E+00,0.2914E+00,0.2914E+00,0.2914E+00,0.2914E+00,
     +0.2913E+00,0.2913E+00,0.2912E+00,0.2912E+00,0.2912E+00,0.2911E+00,
     +0.2910E+00,0.2910E+00,0.2909E+00,0.2908E+00,0.2907E+00,0.2906E+00,
     +0.2905E+00,0.2904E+00,0.2902E+00,0.2901E+00,0.2899E+00,0.2897E+00,
     +0.2895E+00,0.2892E+00,0.2890E+00,0.2887E+00,0.2883E+00,0.2880E+00,
     +0.2876E+00,0.2871E+00,0.2866E+00,0.2861E+00,0.2855E+00,0.2848E+00,
     +0.2841E+00,0.2833E+00,0.2824E+00,0.2814E+00,0.2803E+00,0.2791E+00,
     +0.2778E+00,0.2763E+00,0.2747E+00,0.2729E+00,0.2709E+00,0.2688E+00,
     +0.2664E+00,0.2638E+00,0.2609E+00,0.2578E+00,0.2544E+00,0.2506E+00,
     +0.2466E+00,0.2421E+00,0.2373E+00,0.2321E+00,0.2265E+00,0.2204E+00,
     +0.2139E+00,0.2069E+00,0.1995E+00,0.1916E+00,0.1833E+00,0.1746E+00,
     +0.1655E+00,0.1560E+00,0.1462E+00,0.1363E+00,0.1262E+00,0.1160E+00,
     +0.1060E+00,0.9604E-01,0.8639E-01,0.7710E-01,0.6826E-01,0.5993E-01,
     +0.5215E-01,0.4494E-01,0.3829E-01,0.3216E-01,0.2651E-01,0.2133E-01,
     +0.1660E-01,0.1236E-01,0.8676E-02,0.5628E-02,0.3289E-02,0.1670E-02,
     +0.1016E-02,0.5893E-03,0.3236E-03,0.1670E-03,0.8017E-04,0.3534E-04,
     +0.1406E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,6),I=1,104) /
     +0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1166E+00,0.1165E+00,
     +0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1165E+00,0.1164E+00,
     +0.1164E+00,0.1164E+00,0.1164E+00,0.1163E+00,0.1163E+00,0.1162E+00,
     +0.1162E+00,0.1161E+00,0.1161E+00,0.1160E+00,0.1159E+00,0.1159E+00,
     +0.1158E+00,0.1157E+00,0.1156E+00,0.1155E+00,0.1153E+00,0.1152E+00,
     +0.1150E+00,0.1149E+00,0.1147E+00,0.1144E+00,0.1142E+00,0.1139E+00,
     +0.1136E+00,0.1133E+00,0.1130E+00,0.1126E+00,0.1121E+00,0.1116E+00,
     +0.1111E+00,0.1105E+00,0.1099E+00,0.1092E+00,0.1084E+00,0.1075E+00,
     +0.1066E+00,0.1055E+00,0.1044E+00,0.1031E+00,0.1017E+00,0.1002E+00,
     +0.9862E-01,0.9685E-01,0.9492E-01,0.9284E-01,0.9059E-01,0.8816E-01,
     +0.8556E-01,0.8277E-01,0.7980E-01,0.7665E-01,0.7333E-01,0.6983E-01,
     +0.6618E-01,0.6240E-01,0.5850E-01,0.5451E-01,0.5047E-01,0.4642E-01,
     +0.4238E-01,0.3842E-01,0.3456E-01,0.3084E-01,0.2730E-01,0.2397E-01,
     +0.2086E-01,0.1798E-01,0.1531E-01,0.1286E-01,0.1061E-01,0.8532E-02,
     +0.6641E-02,0.4945E-02,0.3470E-02,0.2251E-02,0.1315E-02,0.6679E-03,
     +0.4064E-03,0.2357E-03,0.1295E-03,0.6681E-04,0.3207E-04,0.1414E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,7),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,8),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,1,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,1),I=1,104) /
     +0.1277E-01,0.1350E-01,0.1427E-01,0.1508E-01,0.1593E-01,0.1684E-01,
     +0.1780E-01,0.1881E-01,0.1987E-01,0.2100E-01,0.2219E-01,0.2345E-01,
     +0.2478E-01,0.2618E-01,0.2766E-01,0.2923E-01,0.3088E-01,0.3263E-01,
     +0.3448E-01,0.3642E-01,0.3848E-01,0.4065E-01,0.4295E-01,0.4537E-01,
     +0.4793E-01,0.5062E-01,0.5347E-01,0.5648E-01,0.5965E-01,0.6300E-01,
     +0.6653E-01,0.7025E-01,0.7418E-01,0.7833E-01,0.8270E-01,0.8730E-01,
     +0.9216E-01,0.9727E-01,0.1027E+00,0.1083E+00,0.1143E+00,0.1206E+00,
     +0.1272E+00,0.1342E+00,0.1415E+00,0.1492E+00,0.1573E+00,0.1658E+00,
     +0.1747E+00,0.1840E+00,0.1938E+00,0.2041E+00,0.2148E+00,0.2260E+00,
     +0.2377E+00,0.2498E+00,0.2625E+00,0.2757E+00,0.2893E+00,0.3035E+00,
     +0.3180E+00,0.3331E+00,0.3485E+00,0.3642E+00,0.3802E+00,0.3965E+00,
     +0.4128E+00,0.4291E+00,0.4453E+00,0.4611E+00,0.4764E+00,0.4908E+00,
     +0.5043E+00,0.5163E+00,0.5266E+00,0.5347E+00,0.5402E+00,0.5426E+00,
     +0.5413E+00,0.5358E+00,0.5255E+00,0.5101E+00,0.4890E+00,0.4620E+00,
     +0.4291E+00,0.3905E+00,0.3468E+00,0.2991E+00,0.2488E+00,0.1980E+00,
     +0.1681E+00,0.1409E+00,0.1165E+00,0.9488E-01,0.7593E-01,0.5950E-01,
     +0.4546E-01,0.3363E-01,0.2385E-01,0.1597E-01,0.9851E-02,0.5362E-02,
     +0.2361E-02,0.6710E-03/
      DATA (XQDUM (I,2,2),I=1,104) /
     +0.7290E-02,0.7704E-02,0.8141E-02,0.8604E-02,0.9092E-02,0.9608E-02,
     +0.1015E-01,0.1073E-01,0.1134E-01,0.1198E-01,0.1266E-01,0.1337E-01,
     +0.1413E-01,0.1493E-01,0.1578E-01,0.1667E-01,0.1761E-01,0.1860E-01,
     +0.1965E-01,0.2076E-01,0.2193E-01,0.2317E-01,0.2447E-01,0.2585E-01,
     +0.2730E-01,0.2884E-01,0.3046E-01,0.3216E-01,0.3396E-01,0.3586E-01,
     +0.3786E-01,0.3998E-01,0.4220E-01,0.4455E-01,0.4702E-01,0.4962E-01,
     +0.5237E-01,0.5525E-01,0.5829E-01,0.6149E-01,0.6485E-01,0.6839E-01,
     +0.7210E-01,0.7601E-01,0.8010E-01,0.8440E-01,0.8891E-01,0.9363E-01,
     +0.9857E-01,0.1037E+00,0.1091E+00,0.1148E+00,0.1206E+00,0.1267E+00,
     +0.1331E+00,0.1397E+00,0.1465E+00,0.1535E+00,0.1607E+00,0.1681E+00,
     +0.1757E+00,0.1834E+00,0.1913E+00,0.1992E+00,0.2070E+00,0.2149E+00,
     +0.2226E+00,0.2301E+00,0.2372E+00,0.2439E+00,0.2500E+00,0.2554E+00,
     +0.2599E+00,0.2632E+00,0.2652E+00,0.2657E+00,0.2644E+00,0.2611E+00,
     +0.2555E+00,0.2475E+00,0.2369E+00,0.2236E+00,0.2077E+00,0.1893E+00,
     +0.1686E+00,0.1462E+00,0.1228E+00,0.9910E-01,0.7622E-01,0.5515E-01,
     +0.4377E-01,0.3414E-01,0.2613E-01,0.1957E-01,0.1430E-01,0.1014E-01,
     +0.6929E-02,0.4523E-02,0.2782E-02,0.1578E-02,0.7980E-03,0.3389E-03,
     +0.1072E-03,0.1858E-04/
      DATA (XQDUM (I,2,3),I=1,104) /
     +0.1964E+02,0.1922E+02,0.1881E+02,0.1841E+02,0.1801E+02,0.1762E+02,
     +0.1724E+02,0.1686E+02,0.1650E+02,0.1613E+02,0.1578E+02,0.1543E+02,
     +0.1508E+02,0.1475E+02,0.1442E+02,0.1409E+02,0.1377E+02,0.1346E+02,
     +0.1315E+02,0.1285E+02,0.1256E+02,0.1226E+02,0.1198E+02,0.1170E+02,
     +0.1143E+02,0.1116E+02,0.1090E+02,0.1064E+02,0.1038E+02,0.1014E+02,
     +0.9893E+01,0.9655E+01,0.9421E+01,0.9193E+01,0.8969E+01,0.8749E+01,
     +0.8534E+01,0.8324E+01,0.8117E+01,0.7915E+01,0.7717E+01,0.7522E+01,
     +0.7332E+01,0.7144E+01,0.6961E+01,0.6780E+01,0.6602E+01,0.6427E+01,
     +0.6254E+01,0.6084E+01,0.5915E+01,0.5748E+01,0.5582E+01,0.5417E+01,
     +0.5252E+01,0.5088E+01,0.4923E+01,0.4758E+01,0.4591E+01,0.4424E+01,
     +0.4254E+01,0.4083E+01,0.3909E+01,0.3733E+01,0.3554E+01,0.3372E+01,
     +0.3188E+01,0.3001E+01,0.2811E+01,0.2620E+01,0.2427E+01,0.2234E+01,
     +0.2041E+01,0.1849E+01,0.1659E+01,0.1474E+01,0.1294E+01,0.1121E+01,
     +0.9563E+00,0.8022E+00,0.6599E+00,0.5308E+00,0.4160E+00,0.3163E+00,
     +0.2322E+00,0.1634E+00,0.1093E+00,0.6881E-01,0.4013E-01,0.2126E-01,
     +0.1369E-01,0.8628E-02,0.5303E-02,0.3171E-02,0.1840E-02,0.1032E-02,
     +0.5572E-03,0.2884E-03,0.1419E-03,0.6552E-04,0.2762E-04,0.1005E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,4),I=1,104) /
     +0.1410E+01,0.1397E+01,0.1383E+01,0.1370E+01,0.1357E+01,0.1345E+01,
     +0.1332E+01,0.1320E+01,0.1308E+01,0.1296E+01,0.1284E+01,0.1273E+01,
     +0.1261E+01,0.1250E+01,0.1239E+01,0.1228E+01,0.1218E+01,0.1207E+01,
     +0.1197E+01,0.1187E+01,0.1176E+01,0.1166E+01,0.1156E+01,0.1147E+01,
     +0.1137E+01,0.1127E+01,0.1118E+01,0.1108E+01,0.1099E+01,0.1089E+01,
     +0.1080E+01,0.1070E+01,0.1061E+01,0.1051E+01,0.1042E+01,0.1032E+01,
     +0.1022E+01,0.1012E+01,0.1002E+01,0.9913E+00,0.9806E+00,0.9697E+00,
     +0.9584E+00,0.9468E+00,0.9348E+00,0.9223E+00,0.9093E+00,0.8958E+00,
     +0.8817E+00,0.8670E+00,0.8515E+00,0.8353E+00,0.8184E+00,0.8005E+00,
     +0.7818E+00,0.7621E+00,0.7414E+00,0.7198E+00,0.6970E+00,0.6732E+00,
     +0.6483E+00,0.6223E+00,0.5953E+00,0.5673E+00,0.5384E+00,0.5087E+00,
     +0.4782E+00,0.4471E+00,0.4157E+00,0.3841E+00,0.3526E+00,0.3214E+00,
     +0.2908E+00,0.2610E+00,0.2324E+00,0.2052E+00,0.1795E+00,0.1555E+00,
     +0.1334E+00,0.1131E+00,0.9466E-01,0.7796E-01,0.6293E-01,0.4949E-01,
     +0.3762E-01,0.2733E-01,0.1870E-01,0.1182E-01,0.6733E-02,0.3331E-02,
     +0.1996E-02,0.1141E-02,0.6180E-03,0.3151E-03,0.1497E-03,0.6548E-04,
     +0.2597E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,5),I=1,104) /
     +0.4518E+00,0.4487E+00,0.4457E+00,0.4428E+00,0.4399E+00,0.4370E+00,
     +0.4342E+00,0.4315E+00,0.4287E+00,0.4260E+00,0.4234E+00,0.4208E+00,
     +0.4182E+00,0.4157E+00,0.4132E+00,0.4107E+00,0.4083E+00,0.4059E+00,
     +0.4035E+00,0.4011E+00,0.3987E+00,0.3964E+00,0.3941E+00,0.3918E+00,
     +0.3895E+00,0.3872E+00,0.3849E+00,0.3826E+00,0.3803E+00,0.3779E+00,
     +0.3756E+00,0.3732E+00,0.3708E+00,0.3683E+00,0.3659E+00,0.3633E+00,
     +0.3607E+00,0.3580E+00,0.3552E+00,0.3523E+00,0.3493E+00,0.3462E+00,
     +0.3429E+00,0.3395E+00,0.3360E+00,0.3322E+00,0.3283E+00,0.3241E+00,
     +0.3197E+00,0.3150E+00,0.3100E+00,0.3048E+00,0.2992E+00,0.2933E+00,
     +0.2870E+00,0.2804E+00,0.2733E+00,0.2659E+00,0.2580E+00,0.2497E+00,
     +0.2409E+00,0.2317E+00,0.2221E+00,0.2121E+00,0.2016E+00,0.1908E+00,
     +0.1797E+00,0.1684E+00,0.1569E+00,0.1452E+00,0.1336E+00,0.1220E+00,
     +0.1106E+00,0.9952E-01,0.8884E-01,0.7864E-01,0.6901E-01,0.6001E-01,
     +0.5167E-01,0.4401E-01,0.3700E-01,0.3063E-01,0.2485E-01,0.1965E-01,
     +0.1501E-01,0.1095E-01,0.7525E-02,0.4774E-02,0.2726E-02,0.1351E-02,
     +0.8097E-03,0.4628E-03,0.2506E-03,0.1276E-03,0.6045E-04,0.2634E-04,
     +0.1038E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,6),I=1,104) /
     +0.2769E+00,0.2739E+00,0.2709E+00,0.2680E+00,0.2651E+00,0.2623E+00,
     +0.2595E+00,0.2568E+00,0.2541E+00,0.2515E+00,0.2489E+00,0.2463E+00,
     +0.2438E+00,0.2413E+00,0.2389E+00,0.2365E+00,0.2341E+00,0.2318E+00,
     +0.2295E+00,0.2272E+00,0.2250E+00,0.2228E+00,0.2206E+00,0.2184E+00,
     +0.2163E+00,0.2142E+00,0.2121E+00,0.2100E+00,0.2079E+00,0.2059E+00,
     +0.2038E+00,0.2018E+00,0.1997E+00,0.1977E+00,0.1956E+00,0.1936E+00,
     +0.1915E+00,0.1894E+00,0.1872E+00,0.1850E+00,0.1828E+00,0.1806E+00,
     +0.1782E+00,0.1759E+00,0.1734E+00,0.1709E+00,0.1683E+00,0.1656E+00,
     +0.1628E+00,0.1599E+00,0.1568E+00,0.1537E+00,0.1504E+00,0.1469E+00,
     +0.1433E+00,0.1395E+00,0.1356E+00,0.1314E+00,0.1271E+00,0.1226E+00,
     +0.1180E+00,0.1131E+00,0.1081E+00,0.1028E+00,0.9748E-01,0.9198E-01,
     +0.8637E-01,0.8066E-01,0.7490E-01,0.6912E-01,0.6336E-01,0.5768E-01,
     +0.5211E-01,0.4670E-01,0.4150E-01,0.3656E-01,0.3191E-01,0.2758E-01,
     +0.2359E-01,0.1994E-01,0.1663E-01,0.1364E-01,0.1097E-01,0.8590E-02,
     +0.6503E-02,0.4706E-02,0.3210E-02,0.2024E-02,0.1150E-02,0.5680E-03,
     +0.3402E-03,0.1944E-03,0.1054E-03,0.5378E-04,0.2560E-04,0.1123E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,7),I=1,104) /
     +0.1603E+00,0.1573E+00,0.1544E+00,0.1515E+00,0.1486E+00,0.1458E+00,
     +0.1431E+00,0.1404E+00,0.1377E+00,0.1351E+00,0.1325E+00,0.1300E+00,
     +0.1275E+00,0.1251E+00,0.1227E+00,0.1203E+00,0.1180E+00,0.1157E+00,
     +0.1135E+00,0.1113E+00,0.1091E+00,0.1070E+00,0.1049E+00,0.1028E+00,
     +0.1008E+00,0.9883E-01,0.9687E-01,0.9494E-01,0.9304E-01,0.9116E-01,
     +0.8931E-01,0.8749E-01,0.8569E-01,0.8390E-01,0.8214E-01,0.8039E-01,
     +0.7866E-01,0.7694E-01,0.7523E-01,0.7353E-01,0.7183E-01,0.7014E-01,
     +0.6845E-01,0.6676E-01,0.6506E-01,0.6336E-01,0.6165E-01,0.5993E-01,
     +0.5820E-01,0.5645E-01,0.5469E-01,0.5291E-01,0.5111E-01,0.4929E-01,
     +0.4745E-01,0.4558E-01,0.4370E-01,0.4180E-01,0.3987E-01,0.3793E-01,
     +0.3597E-01,0.3400E-01,0.3202E-01,0.3004E-01,0.2806E-01,0.2608E-01,
     +0.2412E-01,0.2218E-01,0.2027E-01,0.1839E-01,0.1657E-01,0.1480E-01,
     +0.1310E-01,0.1148E-01,0.9948E-02,0.8512E-02,0.7182E-02,0.5965E-02,
     +0.4867E-02,0.3892E-02,0.3042E-02,0.2316E-02,0.1711E-02,0.1220E-02,
     +0.8344E-03,0.5433E-03,0.3334E-03,0.1903E-03,0.9924E-04,0.4613E-04,
     +0.2714E-04,0.1552E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,8),I=1,104) /
     +0.6951E-01,0.6805E-01,0.6663E-01,0.6523E-01,0.6385E-01,0.6249E-01,
     +0.6118E-01,0.5987E-01,0.5859E-01,0.5733E-01,0.5609E-01,0.5487E-01,
     +0.5367E-01,0.5249E-01,0.5134E-01,0.5020E-01,0.4909E-01,0.4800E-01,
     +0.4693E-01,0.4587E-01,0.4484E-01,0.4382E-01,0.4282E-01,0.4184E-01,
     +0.4088E-01,0.3993E-01,0.3899E-01,0.3808E-01,0.3718E-01,0.3629E-01,
     +0.3542E-01,0.3456E-01,0.3371E-01,0.3288E-01,0.3205E-01,0.3124E-01,
     +0.3044E-01,0.2965E-01,0.2887E-01,0.2809E-01,0.2733E-01,0.2657E-01,
     +0.2581E-01,0.2506E-01,0.2432E-01,0.2358E-01,0.2284E-01,0.2210E-01,
     +0.2137E-01,0.2064E-01,0.1990E-01,0.1917E-01,0.1844E-01,0.1770E-01,
     +0.1697E-01,0.1623E-01,0.1550E-01,0.1476E-01,0.1402E-01,0.1328E-01,
     +0.1255E-01,0.1181E-01,0.1108E-01,0.1035E-01,0.9632E-02,0.8919E-02,
     +0.8217E-02,0.7528E-02,0.6854E-02,0.6198E-02,0.5563E-02,0.4952E-02,
     +0.4369E-02,0.3815E-02,0.3294E-02,0.2809E-02,0.2363E-02,0.1956E-02,
     +0.1591E-02,0.1268E-02,0.9881E-03,0.7500E-03,0.5524E-03,0.3929E-03,
     +0.2681E-03,0.1743E-03,0.1069E-03,0.6102E-04,0.3191E-04,0.1493E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,2,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,1),I=1,104) /
     +0.1402E-01,0.1481E-01,0.1565E-01,0.1654E-01,0.1747E-01,0.1846E-01,
     +0.1950E-01,0.2060E-01,0.2177E-01,0.2299E-01,0.2429E-01,0.2566E-01,
     +0.2710E-01,0.2863E-01,0.3024E-01,0.3194E-01,0.3373E-01,0.3563E-01,
     +0.3762E-01,0.3973E-01,0.4196E-01,0.4431E-01,0.4678E-01,0.4939E-01,
     +0.5215E-01,0.5505E-01,0.5812E-01,0.6134E-01,0.6475E-01,0.6833E-01,
     +0.7211E-01,0.7610E-01,0.8029E-01,0.8471E-01,0.8936E-01,0.9426E-01,
     +0.9941E-01,0.1048E+00,0.1105E+00,0.1165E+00,0.1228E+00,0.1294E+00,
     +0.1364E+00,0.1437E+00,0.1513E+00,0.1593E+00,0.1678E+00,0.1766E+00,
     +0.1858E+00,0.1954E+00,0.2054E+00,0.2159E+00,0.2269E+00,0.2382E+00,
     +0.2501E+00,0.2624E+00,0.2751E+00,0.2883E+00,0.3018E+00,0.3158E+00,
     +0.3301E+00,0.3448E+00,0.3598E+00,0.3749E+00,0.3902E+00,0.4056E+00,
     +0.4208E+00,0.4359E+00,0.4506E+00,0.4648E+00,0.4782E+00,0.4906E+00,
     +0.5017E+00,0.5112E+00,0.5187E+00,0.5238E+00,0.5262E+00,0.5252E+00,
     +0.5206E+00,0.5118E+00,0.4983E+00,0.4799E+00,0.4563E+00,0.4273E+00,
     +0.3932E+00,0.3542E+00,0.3111E+00,0.2652E+00,0.2178E+00,0.1708E+00,
     +0.1436E+00,0.1192E+00,0.9757E-01,0.7862E-01,0.6219E-01,0.4814E-01,
     +0.3628E-01,0.2643E-01,0.1842E-01,0.1209E-01,0.7286E-02,0.3852E-02,
     +0.1632E-02,0.4382E-03/
      DATA (XQDUM (I,3,2),I=1,104) /
     +0.7995E-02,0.8447E-02,0.8924E-02,0.9429E-02,0.9961E-02,0.1052E-01,
     +0.1112E-01,0.1174E-01,0.1241E-01,0.1310E-01,0.1384E-01,0.1462E-01,
     +0.1544E-01,0.1631E-01,0.1723E-01,0.1819E-01,0.1921E-01,0.2029E-01,
     +0.2142E-01,0.2262E-01,0.2388E-01,0.2521E-01,0.2662E-01,0.2810E-01,
     +0.2966E-01,0.3130E-01,0.3304E-01,0.3487E-01,0.3679E-01,0.3882E-01,
     +0.4095E-01,0.4320E-01,0.4557E-01,0.4806E-01,0.5068E-01,0.5343E-01,
     +0.5633E-01,0.5937E-01,0.6257E-01,0.6593E-01,0.6945E-01,0.7315E-01,
     +0.7702E-01,0.8108E-01,0.8533E-01,0.8978E-01,0.9443E-01,0.9928E-01,
     +0.1043E+00,0.1096E+00,0.1151E+00,0.1208E+00,0.1268E+00,0.1329E+00,
     +0.1392E+00,0.1458E+00,0.1525E+00,0.1595E+00,0.1665E+00,0.1738E+00,
     +0.1811E+00,0.1885E+00,0.1959E+00,0.2034E+00,0.2107E+00,0.2179E+00,
     +0.2249E+00,0.2315E+00,0.2377E+00,0.2434E+00,0.2484E+00,0.2525E+00,
     +0.2556E+00,0.2575E+00,0.2581E+00,0.2570E+00,0.2541E+00,0.2493E+00,
     +0.2423E+00,0.2329E+00,0.2212E+00,0.2071E+00,0.1906E+00,0.1721E+00,
     +0.1517E+00,0.1302E+00,0.1080E+00,0.8609E-01,0.6530E-01,0.4653E-01,
     +0.3655E-01,0.2821E-01,0.2136E-01,0.1582E-01,0.1141E-01,0.7987E-02,
     +0.5383E-02,0.3460E-02,0.2090E-02,0.1162E-02,0.5736E-03,0.2365E-03,
     +0.7197E-04,0.1179E-04/
      DATA (XQDUM (I,3,3),I=1,104) /
     +0.3553E+02,0.3458E+02,0.3366E+02,0.3275E+02,0.3186E+02,0.3100E+02,
     +0.3015E+02,0.2932E+02,0.2851E+02,0.2771E+02,0.2694E+02,0.2618E+02,
     +0.2544E+02,0.2471E+02,0.2401E+02,0.2332E+02,0.2264E+02,0.2198E+02,
     +0.2133E+02,0.2070E+02,0.2009E+02,0.1949E+02,0.1890E+02,0.1833E+02,
     +0.1777E+02,0.1722E+02,0.1669E+02,0.1617E+02,0.1566E+02,0.1517E+02,
     +0.1468E+02,0.1421E+02,0.1375E+02,0.1330E+02,0.1287E+02,0.1244E+02,
     +0.1203E+02,0.1162E+02,0.1123E+02,0.1084E+02,0.1047E+02,0.1010E+02,
     +0.9748E+01,0.9401E+01,0.9062E+01,0.8732E+01,0.8410E+01,0.8096E+01,
     +0.7789E+01,0.7489E+01,0.7195E+01,0.6908E+01,0.6628E+01,0.6352E+01,
     +0.6082E+01,0.5817E+01,0.5557E+01,0.5300E+01,0.5048E+01,0.4799E+01,
     +0.4553E+01,0.4311E+01,0.4071E+01,0.3834E+01,0.3600E+01,0.3368E+01,
     +0.3140E+01,0.2914E+01,0.2691E+01,0.2472E+01,0.2257E+01,0.2048E+01,
     +0.1843E+01,0.1645E+01,0.1455E+01,0.1273E+01,0.1101E+01,0.9390E+00,
     +0.7889E+00,0.6514E+00,0.5274E+00,0.4175E+00,0.3220E+00,0.2409E+00,
     +0.1740E+00,0.1206E+00,0.7953E-01,0.4942E-01,0.2856E-01,0.1510E-01,
     +0.9760E-02,0.6204E-02,0.3872E-02,0.2368E-02,0.1416E-02,0.8255E-03,
     +0.4672E-03,0.2548E-03,0.1323E-03,0.6403E-04,0.2790E-04,0.1026E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,4),I=1,104) /
     +0.2833E+01,0.2783E+01,0.2734E+01,0.2687E+01,0.2640E+01,0.2593E+01,
     +0.2548E+01,0.2504E+01,0.2460E+01,0.2418E+01,0.2376E+01,0.2335E+01,
     +0.2295E+01,0.2256E+01,0.2217E+01,0.2179E+01,0.2142E+01,0.2105E+01,
     +0.2070E+01,0.2034E+01,0.2000E+01,0.1966E+01,0.1933E+01,0.1900E+01,
     +0.1868E+01,0.1836E+01,0.1805E+01,0.1775E+01,0.1745E+01,0.1715E+01,
     +0.1686E+01,0.1657E+01,0.1628E+01,0.1600E+01,0.1572E+01,0.1544E+01,
     +0.1517E+01,0.1489E+01,0.1462E+01,0.1435E+01,0.1408E+01,0.1381E+01,
     +0.1353E+01,0.1326E+01,0.1298E+01,0.1271E+01,0.1243E+01,0.1214E+01,
     +0.1185E+01,0.1156E+01,0.1126E+01,0.1096E+01,0.1065E+01,0.1033E+01,
     +0.1001E+01,0.9679E+00,0.9341E+00,0.8995E+00,0.8640E+00,0.8277E+00,
     +0.7907E+00,0.7529E+00,0.7144E+00,0.6753E+00,0.6356E+00,0.5956E+00,
     +0.5553E+00,0.5150E+00,0.4749E+00,0.4351E+00,0.3960E+00,0.3578E+00,
     +0.3209E+00,0.2854E+00,0.2516E+00,0.2199E+00,0.1903E+00,0.1630E+00,
     +0.1380E+00,0.1154E+00,0.9514E-01,0.7708E-01,0.6112E-01,0.4717E-01,
     +0.3514E-01,0.2500E-01,0.1675E-01,0.1036E-01,0.5771E-02,0.2794E-02,
     +0.1652E-02,0.9337E-03,0.5009E-03,0.2534E-03,0.1199E-03,0.5248E-04,
     +0.2103E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,5),I=1,104) /
     +0.7359E+00,0.7256E+00,0.7155E+00,0.7056E+00,0.6959E+00,0.6864E+00,
     +0.6771E+00,0.6679E+00,0.6589E+00,0.6501E+00,0.6414E+00,0.6329E+00,
     +0.6245E+00,0.6163E+00,0.6083E+00,0.6004E+00,0.5926E+00,0.5850E+00,
     +0.5775E+00,0.5701E+00,0.5629E+00,0.5558E+00,0.5488E+00,0.5418E+00,
     +0.5350E+00,0.5283E+00,0.5217E+00,0.5151E+00,0.5086E+00,0.5022E+00,
     +0.4959E+00,0.4896E+00,0.4833E+00,0.4770E+00,0.4708E+00,0.4646E+00,
     +0.4583E+00,0.4521E+00,0.4458E+00,0.4394E+00,0.4330E+00,0.4266E+00,
     +0.4200E+00,0.4133E+00,0.4065E+00,0.3996E+00,0.3925E+00,0.3852E+00,
     +0.3776E+00,0.3699E+00,0.3619E+00,0.3537E+00,0.3452E+00,0.3363E+00,
     +0.3272E+00,0.3177E+00,0.3078E+00,0.2976E+00,0.2871E+00,0.2761E+00,
     +0.2648E+00,0.2532E+00,0.2411E+00,0.2288E+00,0.2162E+00,0.2034E+00,
     +0.1903E+00,0.1772E+00,0.1640E+00,0.1508E+00,0.1378E+00,0.1251E+00,
     +0.1126E+00,0.1006E+00,0.8917E-01,0.7834E-01,0.6819E-01,0.5879E-01,
     +0.5015E-01,0.4227E-01,0.3515E-01,0.2873E-01,0.2300E-01,0.1791E-01,
     +0.1346E-01,0.9660E-02,0.6518E-02,0.4058E-02,0.2271E-02,0.1102E-02,
     +0.6519E-03,0.3679E-03,0.1969E-03,0.9915E-04,0.4655E-04,0.2014E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,6),I=1,104) /
     +0.5612E+00,0.5509E+00,0.5408E+00,0.5310E+00,0.5213E+00,0.5118E+00,
     +0.5025E+00,0.4933E+00,0.4844E+00,0.4756E+00,0.4670E+00,0.4585E+00,
     +0.4503E+00,0.4422E+00,0.4342E+00,0.4264E+00,0.4187E+00,0.4112E+00,
     +0.4038E+00,0.3966E+00,0.3895E+00,0.3825E+00,0.3757E+00,0.3690E+00,
     +0.3623E+00,0.3559E+00,0.3495E+00,0.3432E+00,0.3370E+00,0.3309E+00,
     +0.3249E+00,0.3190E+00,0.3132E+00,0.3074E+00,0.3017E+00,0.2960E+00,
     +0.2904E+00,0.2848E+00,0.2793E+00,0.2738E+00,0.2683E+00,0.2628E+00,
     +0.2573E+00,0.2518E+00,0.2462E+00,0.2407E+00,0.2351E+00,0.2294E+00,
     +0.2237E+00,0.2179E+00,0.2120E+00,0.2060E+00,0.1999E+00,0.1937E+00,
     +0.1874E+00,0.1810E+00,0.1744E+00,0.1677E+00,0.1609E+00,0.1539E+00,
     +0.1469E+00,0.1396E+00,0.1323E+00,0.1249E+00,0.1174E+00,0.1099E+00,
     +0.1023E+00,0.9473E-01,0.8722E-01,0.7980E-01,0.7251E-01,0.6542E-01,
     +0.5856E-01,0.5198E-01,0.4574E-01,0.3987E-01,0.3441E-01,0.2939E-01,
     +0.2480E-01,0.2066E-01,0.1696E-01,0.1368E-01,0.1080E-01,0.8291E-02,
     +0.6147E-02,0.4354E-02,0.2905E-02,0.1791E-02,0.9951E-03,0.4809E-03,
     +0.2844E-03,0.1607E-03,0.8632E-04,0.4376E-04,0.2077E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,7),I=1,104) /
     +0.4447E+00,0.4344E+00,0.4244E+00,0.4145E+00,0.4049E+00,0.3954E+00,
     +0.3861E+00,0.3770E+00,0.3681E+00,0.3593E+00,0.3507E+00,0.3423E+00,
     +0.3341E+00,0.3260E+00,0.3181E+00,0.3104E+00,0.3028E+00,0.2953E+00,
     +0.2880E+00,0.2809E+00,0.2739E+00,0.2670E+00,0.2603E+00,0.2537E+00,
     +0.2472E+00,0.2409E+00,0.2347E+00,0.2286E+00,0.2226E+00,0.2167E+00,
     +0.2110E+00,0.2053E+00,0.1998E+00,0.1943E+00,0.1889E+00,0.1837E+00,
     +0.1785E+00,0.1734E+00,0.1683E+00,0.1633E+00,0.1584E+00,0.1536E+00,
     +0.1488E+00,0.1441E+00,0.1394E+00,0.1347E+00,0.1301E+00,0.1256E+00,
     +0.1210E+00,0.1165E+00,0.1120E+00,0.1075E+00,0.1031E+00,0.9866E-01,
     +0.9425E-01,0.8986E-01,0.8548E-01,0.8113E-01,0.7680E-01,0.7249E-01,
     +0.6821E-01,0.6397E-01,0.5978E-01,0.5563E-01,0.5154E-01,0.4753E-01,
     +0.4360E-01,0.3977E-01,0.3604E-01,0.3244E-01,0.2897E-01,0.2566E-01,
     +0.2252E-01,0.1955E-01,0.1679E-01,0.1423E-01,0.1190E-01,0.9784E-02,
     +0.7903E-02,0.6256E-02,0.4838E-02,0.3644E-02,0.2661E-02,0.1876E-02,
     +0.1269E-02,0.8165E-03,0.4954E-03,0.2798E-03,0.1446E-03,0.6686E-04,
     +0.3932E-04,0.2257E-04,0.1261E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,8),I=1,104) /
     +0.3554E+00,0.3466E+00,0.3381E+00,0.3297E+00,0.3215E+00,0.3134E+00,
     +0.3055E+00,0.2978E+00,0.2903E+00,0.2829E+00,0.2756E+00,0.2685E+00,
     +0.2615E+00,0.2547E+00,0.2480E+00,0.2415E+00,0.2351E+00,0.2288E+00,
     +0.2226E+00,0.2166E+00,0.2107E+00,0.2050E+00,0.1993E+00,0.1938E+00,
     +0.1884E+00,0.1830E+00,0.1778E+00,0.1728E+00,0.1678E+00,0.1629E+00,
     +0.1581E+00,0.1534E+00,0.1488E+00,0.1443E+00,0.1399E+00,0.1355E+00,
     +0.1313E+00,0.1271E+00,0.1230E+00,0.1189E+00,0.1150E+00,0.1111E+00,
     +0.1072E+00,0.1034E+00,0.9972E-01,0.9605E-01,0.9242E-01,0.8885E-01,
     +0.8532E-01,0.8183E-01,0.7838E-01,0.7497E-01,0.7160E-01,0.6827E-01,
     +0.6497E-01,0.6171E-01,0.5849E-01,0.5530E-01,0.5215E-01,0.4905E-01,
     +0.4598E-01,0.4297E-01,0.4000E-01,0.3710E-01,0.3425E-01,0.3147E-01,
     +0.2877E-01,0.2614E-01,0.2361E-01,0.2118E-01,0.1885E-01,0.1664E-01,
     +0.1455E-01,0.1260E-01,0.1078E-01,0.9109E-02,0.7589E-02,0.6222E-02,
     +0.5010E-02,0.3954E-02,0.3049E-02,0.2289E-02,0.1668E-02,0.1173E-02,
     +0.7915E-03,0.5088E-03,0.3086E-03,0.1745E-03,0.9051E-04,0.4218E-04,
     +0.2500E-04,0.1451E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,3,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,1),I=1,104) /
     +0.1617E-01,0.1708E-01,0.1804E-01,0.1905E-01,0.2012E-01,0.2124E-01,
     +0.2243E-01,0.2369E-01,0.2501E-01,0.2641E-01,0.2788E-01,0.2943E-01,
     +0.3107E-01,0.3280E-01,0.3462E-01,0.3654E-01,0.3857E-01,0.4070E-01,
     +0.4295E-01,0.4533E-01,0.4782E-01,0.5046E-01,0.5323E-01,0.5615E-01,
     +0.5922E-01,0.6246E-01,0.6586E-01,0.6945E-01,0.7322E-01,0.7719E-01,
     +0.8136E-01,0.8574E-01,0.9035E-01,0.9519E-01,0.1003E+00,0.1056E+00,
     +0.1112E+00,0.1171E+00,0.1233E+00,0.1297E+00,0.1365E+00,0.1436E+00,
     +0.1510E+00,0.1588E+00,0.1669E+00,0.1753E+00,0.1842E+00,0.1934E+00,
     +0.2030E+00,0.2130E+00,0.2233E+00,0.2341E+00,0.2452E+00,0.2568E+00,
     +0.2687E+00,0.2810E+00,0.2936E+00,0.3066E+00,0.3198E+00,0.3333E+00,
     +0.3471E+00,0.3610E+00,0.3750E+00,0.3890E+00,0.4029E+00,0.4166E+00,
     +0.4300E+00,0.4429E+00,0.4552E+00,0.4666E+00,0.4770E+00,0.4860E+00,
     +0.4935E+00,0.4990E+00,0.5023E+00,0.5029E+00,0.5007E+00,0.4951E+00,
     +0.4858E+00,0.4725E+00,0.4549E+00,0.4329E+00,0.4063E+00,0.3754E+00,
     +0.3404E+00,0.3019E+00,0.2607E+00,0.2182E+00,0.1756E+00,0.1347E+00,
     +0.1115E+00,0.9116E-01,0.7343E-01,0.5817E-01,0.4520E-01,0.3431E-01,
     +0.2531E-01,0.1800E-01,0.1221E-01,0.7771E-02,0.4511E-02,0.2278E-02,
     +0.9087E-03,0.2233E-03/
      DATA (XQDUM (I,4,2),I=1,104) /
     +0.9211E-02,0.9727E-02,0.1027E-01,0.1085E-01,0.1145E-01,0.1209E-01,
     +0.1277E-01,0.1348E-01,0.1423E-01,0.1503E-01,0.1586E-01,0.1674E-01,
     +0.1767E-01,0.1865E-01,0.1968E-01,0.2077E-01,0.2192E-01,0.2313E-01,
     +0.2440E-01,0.2574E-01,0.2715E-01,0.2864E-01,0.3020E-01,0.3185E-01,
     +0.3359E-01,0.3541E-01,0.3733E-01,0.3935E-01,0.4147E-01,0.4370E-01,
     +0.4604E-01,0.4850E-01,0.5108E-01,0.5379E-01,0.5663E-01,0.5962E-01,
     +0.6274E-01,0.6601E-01,0.6944E-01,0.7303E-01,0.7678E-01,0.8070E-01,
     +0.8480E-01,0.8907E-01,0.9352E-01,0.9816E-01,0.1030E+00,0.1080E+00,
     +0.1132E+00,0.1186E+00,0.1242E+00,0.1299E+00,0.1359E+00,0.1420E+00,
     +0.1483E+00,0.1547E+00,0.1613E+00,0.1679E+00,0.1747E+00,0.1815E+00,
     +0.1883E+00,0.1951E+00,0.2018E+00,0.2084E+00,0.2147E+00,0.2208E+00,
     +0.2266E+00,0.2319E+00,0.2366E+00,0.2406E+00,0.2438E+00,0.2460E+00,
     +0.2471E+00,0.2469E+00,0.2452E+00,0.2420E+00,0.2370E+00,0.2301E+00,
     +0.2212E+00,0.2103E+00,0.1973E+00,0.1823E+00,0.1655E+00,0.1472E+00,
     +0.1278E+00,0.1078E+00,0.8786E-01,0.6866E-01,0.5096E-01,0.3545E-01,
     +0.2740E-01,0.2081E-01,0.1549E-01,0.1126E-01,0.7977E-02,0.5470E-02,
     +0.3605E-02,0.2261E-02,0.1329E-02,0.7153E-03,0.3401E-03,0.1339E-03,
     +0.3836E-04,0.0000E+00/
      DATA (XQDUM (I,4,3),I=1,104) /
     +0.7088E+02,0.6849E+02,0.6616E+02,0.6390E+02,0.6171E+02,0.5957E+02,
     +0.5750E+02,0.5549E+02,0.5354E+02,0.5164E+02,0.4980E+02,0.4801E+02,
     +0.4628E+02,0.4460E+02,0.4296E+02,0.4138E+02,0.3985E+02,0.3836E+02,
     +0.3691E+02,0.3551E+02,0.3416E+02,0.3284E+02,0.3157E+02,0.3033E+02,
     +0.2914E+02,0.2798E+02,0.2686E+02,0.2577E+02,0.2472E+02,0.2371E+02,
     +0.2273E+02,0.2177E+02,0.2086E+02,0.1997E+02,0.1911E+02,0.1828E+02,
     +0.1747E+02,0.1670E+02,0.1595E+02,0.1523E+02,0.1453E+02,0.1385E+02,
     +0.1320E+02,0.1258E+02,0.1197E+02,0.1139E+02,0.1082E+02,0.1028E+02,
     +0.9753E+01,0.9247E+01,0.8759E+01,0.8289E+01,0.7835E+01,0.7397E+01,
     +0.6974E+01,0.6567E+01,0.6174E+01,0.5794E+01,0.5428E+01,0.5074E+01,
     +0.4733E+01,0.4404E+01,0.4087E+01,0.3781E+01,0.3487E+01,0.3203E+01,
     +0.2931E+01,0.2669E+01,0.2419E+01,0.2180E+01,0.1952E+01,0.1736E+01,
     +0.1532E+01,0.1340E+01,0.1161E+01,0.9951E+00,0.8426E+00,0.7038E+00,
     +0.5789E+00,0.4679E+00,0.3708E+00,0.2873E+00,0.2170E+00,0.1590E+00,
     +0.1126E+00,0.7665E-01,0.4977E-01,0.3058E-01,0.1759E-01,0.9348E-02,
     +0.6105E-02,0.3941E-02,0.2510E-02,0.1574E-02,0.9684E-03,0.5815E-03,
     +0.3384E-03,0.1888E-03,0.9934E-04,0.4812E-04,0.2063E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,4),I=1,104) /
     +0.6801E+01,0.6622E+01,0.6448E+01,0.6277E+01,0.6111E+01,0.5949E+01,
     +0.5791E+01,0.5637E+01,0.5487E+01,0.5340E+01,0.5197E+01,0.5058E+01,
     +0.4923E+01,0.4790E+01,0.4661E+01,0.4536E+01,0.4413E+01,0.4294E+01,
     +0.4177E+01,0.4064E+01,0.3953E+01,0.3845E+01,0.3740E+01,0.3638E+01,
     +0.3538E+01,0.3441E+01,0.3346E+01,0.3253E+01,0.3163E+01,0.3074E+01,
     +0.2988E+01,0.2904E+01,0.2822E+01,0.2742E+01,0.2664E+01,0.2587E+01,
     +0.2512E+01,0.2438E+01,0.2366E+01,0.2295E+01,0.2226E+01,0.2158E+01,
     +0.2091E+01,0.2024E+01,0.1959E+01,0.1895E+01,0.1832E+01,0.1769E+01,
     +0.1707E+01,0.1645E+01,0.1584E+01,0.1523E+01,0.1463E+01,0.1403E+01,
     +0.1343E+01,0.1284E+01,0.1224E+01,0.1165E+01,0.1106E+01,0.1047E+01,
     +0.9884E+00,0.9300E+00,0.8720E+00,0.8145E+00,0.7576E+00,0.7014E+00,
     +0.6462E+00,0.5921E+00,0.5393E+00,0.4881E+00,0.4387E+00,0.3915E+00,
     +0.3465E+00,0.3042E+00,0.2646E+00,0.2279E+00,0.1943E+00,0.1638E+00,
     +0.1363E+00,0.1119E+00,0.9046E-01,0.7173E-01,0.5558E-01,0.4184E-01,
     +0.3036E-01,0.2102E-01,0.1368E-01,0.8216E-02,0.4441E-02,0.2086E-02,
     +0.1213E-02,0.6752E-03,0.3579E-03,0.1797E-03,0.8485E-04,0.3745E-04,
     +0.1534E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,5),I=1,104) /
     +0.1529E+01,0.1493E+01,0.1458E+01,0.1423E+01,0.1390E+01,0.1357E+01,
     +0.1325E+01,0.1294E+01,0.1263E+01,0.1234E+01,0.1205E+01,0.1177E+01,
     +0.1149E+01,0.1123E+01,0.1096E+01,0.1071E+01,0.1046E+01,0.1022E+01,
     +0.9982E+00,0.9751E+00,0.9526E+00,0.9306E+00,0.9092E+00,0.8883E+00,
     +0.8679E+00,0.8479E+00,0.8284E+00,0.8094E+00,0.7908E+00,0.7726E+00,
     +0.7548E+00,0.7373E+00,0.7203E+00,0.7035E+00,0.6870E+00,0.6709E+00,
     +0.6550E+00,0.6394E+00,0.6240E+00,0.6088E+00,0.5938E+00,0.5789E+00,
     +0.5642E+00,0.5496E+00,0.5351E+00,0.5206E+00,0.5062E+00,0.4918E+00,
     +0.4774E+00,0.4630E+00,0.4485E+00,0.4339E+00,0.4193E+00,0.4045E+00,
     +0.3896E+00,0.3746E+00,0.3594E+00,0.3441E+00,0.3286E+00,0.3130E+00,
     +0.2972E+00,0.2813E+00,0.2654E+00,0.2493E+00,0.2332E+00,0.2172E+00,
     +0.2013E+00,0.1855E+00,0.1699E+00,0.1547E+00,0.1399E+00,0.1256E+00,
     +0.1120E+00,0.9896E-01,0.8672E-01,0.7531E-01,0.6477E-01,0.5512E-01,
     +0.4638E-01,0.3852E-01,0.3151E-01,0.2531E-01,0.1987E-01,0.1515E-01,
     +0.1113E-01,0.7795E-02,0.5125E-02,0.3103E-02,0.1686E-02,0.7938E-03,
     +0.4608E-03,0.2555E-03,0.1345E-03,0.6678E-04,0.3101E-04,0.1335E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,6),I=1,104) /
     +0.1354E+01,0.1318E+01,0.1283E+01,0.1249E+01,0.1215E+01,0.1183E+01,
     +0.1151E+01,0.1120E+01,0.1089E+01,0.1060E+01,0.1031E+01,0.1003E+01,
     +0.9755E+00,0.9488E+00,0.9227E+00,0.8974E+00,0.8727E+00,0.8486E+00,
     +0.8251E+00,0.8022E+00,0.7799E+00,0.7581E+00,0.7369E+00,0.7163E+00,
     +0.6961E+00,0.6765E+00,0.6573E+00,0.6387E+00,0.6204E+00,0.6027E+00,
     +0.5853E+00,0.5684E+00,0.5519E+00,0.5357E+00,0.5199E+00,0.5045E+00,
     +0.4894E+00,0.4746E+00,0.4601E+00,0.4459E+00,0.4320E+00,0.4183E+00,
     +0.4048E+00,0.3916E+00,0.3786E+00,0.3658E+00,0.3531E+00,0.3406E+00,
     +0.3282E+00,0.3160E+00,0.3039E+00,0.2919E+00,0.2800E+00,0.2681E+00,
     +0.2563E+00,0.2446E+00,0.2330E+00,0.2214E+00,0.2099E+00,0.1984E+00,
     +0.1871E+00,0.1758E+00,0.1646E+00,0.1535E+00,0.1426E+00,0.1318E+00,
     +0.1212E+00,0.1109E+00,0.1008E+00,0.9112E-01,0.8176E-01,0.7282E-01,
     +0.6433E-01,0.5634E-01,0.4889E-01,0.4200E-01,0.3570E-01,0.2999E-01,
     +0.2487E-01,0.2034E-01,0.1636E-01,0.1291E-01,0.9950E-02,0.7450E-02,
     +0.5378E-02,0.3704E-02,0.2400E-02,0.1436E-02,0.7743E-03,0.3633E-03,
     +0.2113E-03,0.1178E-03,0.6257E-04,0.3153E-04,0.1498E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,7),I=1,104) /
     +0.1238E+01,0.1202E+01,0.1167E+01,0.1132E+01,0.1099E+01,0.1066E+01,
     +0.1034E+01,0.1003E+01,0.9731E+00,0.9436E+00,0.9149E+00,0.8869E+00,
     +0.8595E+00,0.8329E+00,0.8070E+00,0.7817E+00,0.7571E+00,0.7331E+00,
     +0.7097E+00,0.6869E+00,0.6647E+00,0.6431E+00,0.6221E+00,0.6016E+00,
     +0.5816E+00,0.5622E+00,0.5433E+00,0.5248E+00,0.5069E+00,0.4894E+00,
     +0.4724E+00,0.4558E+00,0.4396E+00,0.4238E+00,0.4085E+00,0.3935E+00,
     +0.3789E+00,0.3647E+00,0.3508E+00,0.3373E+00,0.3241E+00,0.3112E+00,
     +0.2986E+00,0.2863E+00,0.2743E+00,0.2625E+00,0.2510E+00,0.2398E+00,
     +0.2288E+00,0.2180E+00,0.2075E+00,0.1972E+00,0.1871E+00,0.1772E+00,
     +0.1675E+00,0.1580E+00,0.1487E+00,0.1396E+00,0.1307E+00,0.1221E+00,
     +0.1136E+00,0.1054E+00,0.9738E-01,0.8962E-01,0.8210E-01,0.7485E-01,
     +0.6787E-01,0.6117E-01,0.5479E-01,0.4872E-01,0.4298E-01,0.3760E-01,
     +0.3258E-01,0.2793E-01,0.2367E-01,0.1980E-01,0.1632E-01,0.1323E-01,
     +0.1054E-01,0.8218E-02,0.6260E-02,0.4642E-02,0.3337E-02,0.2315E-02,
     +0.1540E-02,0.9759E-03,0.5832E-03,0.3248E-03,0.1661E-03,0.7636E-04,
     +0.4494E-04,0.2592E-04,0.1462E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,8),I=1,104) /
     +0.1151E+01,0.1116E+01,0.1083E+01,0.1050E+01,0.1018E+01,0.9865E+00,
     +0.9560E+00,0.9263E+00,0.8974E+00,0.8692E+00,0.8417E+00,0.8149E+00,
     +0.7889E+00,0.7635E+00,0.7387E+00,0.7146E+00,0.6912E+00,0.6683E+00,
     +0.6461E+00,0.6244E+00,0.6033E+00,0.5828E+00,0.5628E+00,0.5433E+00,
     +0.5244E+00,0.5060E+00,0.4881E+00,0.4706E+00,0.4537E+00,0.4372E+00,
     +0.4211E+00,0.4055E+00,0.3902E+00,0.3754E+00,0.3610E+00,0.3470E+00,
     +0.3334E+00,0.3201E+00,0.3071E+00,0.2946E+00,0.2823E+00,0.2704E+00,
     +0.2587E+00,0.2474E+00,0.2363E+00,0.2256E+00,0.2151E+00,0.2049E+00,
     +0.1949E+00,0.1852E+00,0.1757E+00,0.1664E+00,0.1574E+00,0.1486E+00,
     +0.1400E+00,0.1317E+00,0.1236E+00,0.1156E+00,0.1079E+00,0.1005E+00,
     +0.9321E-01,0.8618E-01,0.7937E-01,0.7281E-01,0.6648E-01,0.6041E-01,
     +0.5460E-01,0.4906E-01,0.4380E-01,0.3882E-01,0.3414E-01,0.2977E-01,
     +0.2571E-01,0.2197E-01,0.1856E-01,0.1548E-01,0.1272E-01,0.1028E-01,
     +0.8164E-02,0.6348E-02,0.4823E-02,0.3567E-02,0.2558E-02,0.1771E-02,
     +0.1177E-02,0.7450E-03,0.4454E-03,0.2487E-03,0.1278E-03,0.5931E-04,
     +0.3521E-04,0.2053E-04,0.1173E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,4,9),I=1,104) /
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,1),I=1,104) /
     +0.1809E-01,0.1910E-01,0.2017E-01,0.2129E-01,0.2247E-01,0.2372E-01,
     +0.2504E-01,0.2642E-01,0.2789E-01,0.2943E-01,0.3105E-01,0.3277E-01,
     +0.3457E-01,0.3647E-01,0.3847E-01,0.4058E-01,0.4280E-01,0.4514E-01,
     +0.4761E-01,0.5020E-01,0.5292E-01,0.5579E-01,0.5881E-01,0.6199E-01,
     +0.6532E-01,0.6883E-01,0.7252E-01,0.7639E-01,0.8046E-01,0.8473E-01,
     +0.8922E-01,0.9392E-01,0.9886E-01,0.1040E+00,0.1095E+00,0.1151E+00,
     +0.1211E+00,0.1273E+00,0.1338E+00,0.1406E+00,0.1478E+00,0.1552E+00,
     +0.1629E+00,0.1710E+00,0.1795E+00,0.1882E+00,0.1973E+00,0.2068E+00,
     +0.2166E+00,0.2268E+00,0.2373E+00,0.2482E+00,0.2594E+00,0.2709E+00,
     +0.2828E+00,0.2949E+00,0.3073E+00,0.3199E+00,0.3328E+00,0.3457E+00,
     +0.3588E+00,0.3719E+00,0.3849E+00,0.3978E+00,0.4104E+00,0.4227E+00,
     +0.4344E+00,0.4454E+00,0.4556E+00,0.4647E+00,0.4726E+00,0.4789E+00,
     +0.4834E+00,0.4858E+00,0.4859E+00,0.4833E+00,0.4777E+00,0.4688E+00,
     +0.4563E+00,0.4401E+00,0.4199E+00,0.3958E+00,0.3677E+00,0.3361E+00,
     +0.3012E+00,0.2638E+00,0.2248E+00,0.1854E+00,0.1468E+00,0.1106E+00,
     +0.9048E-01,0.7304E-01,0.5807E-01,0.4538E-01,0.3474E-01,0.2596E-01,
     +0.1882E-01,0.1313E-01,0.8717E-02,0.5408E-02,0.3047E-02,0.1483E-02,
     +0.5636E-03,0.1290E-03/
      DATA (XQDUM (I,5,2),I=1,104) /
     +0.1029E-01,0.1087E-01,0.1147E-01,0.1211E-01,0.1278E-01,0.1349E-01,
     +0.1423E-01,0.1502E-01,0.1585E-01,0.1672E-01,0.1764E-01,0.1861E-01,
     +0.1963E-01,0.2070E-01,0.2183E-01,0.2302E-01,0.2428E-01,0.2560E-01,
     +0.2698E-01,0.2844E-01,0.2998E-01,0.3160E-01,0.3329E-01,0.3508E-01,
     +0.3695E-01,0.3892E-01,0.4099E-01,0.4316E-01,0.4543E-01,0.4782E-01,
     +0.5033E-01,0.5295E-01,0.5570E-01,0.5858E-01,0.6160E-01,0.6475E-01,
     +0.6805E-01,0.7149E-01,0.7509E-01,0.7884E-01,0.8275E-01,0.8683E-01,
     +0.9107E-01,0.9548E-01,0.1001E+00,0.1048E+00,0.1097E+00,0.1148E+00,
     +0.1201E+00,0.1255E+00,0.1311E+00,0.1369E+00,0.1428E+00,0.1488E+00,
     +0.1549E+00,0.1612E+00,0.1675E+00,0.1738E+00,0.1802E+00,0.1866E+00,
     +0.1929E+00,0.1991E+00,0.2052E+00,0.2110E+00,0.2165E+00,0.2217E+00,
     +0.2264E+00,0.2305E+00,0.2340E+00,0.2367E+00,0.2384E+00,0.2392E+00,
     +0.2387E+00,0.2370E+00,0.2338E+00,0.2290E+00,0.2225E+00,0.2143E+00,
     +0.2043E+00,0.1924E+00,0.1788E+00,0.1635E+00,0.1469E+00,0.1291E+00,
     +0.1107E+00,0.9214E-01,0.7401E-01,0.5693E-01,0.4154E-01,0.2834E-01,
     +0.2163E-01,0.1621E-01,0.1190E-01,0.8531E-02,0.5949E-02,0.4013E-02,
     +0.2598E-02,0.1597E-02,0.9179E-03,0.4817E-03,0.2222E-03,0.8429E-04,
     +0.2300E-04,0.0000E+00/
      DATA (XQDUM (I,5,3),I=1,104) /
     +0.1082E+03,0.1040E+03,0.9992E+02,0.9601E+02,0.9222E+02,0.8857E+02,
     +0.8503E+02,0.8162E+02,0.7832E+02,0.7513E+02,0.7206E+02,0.6909E+02,
     +0.6622E+02,0.6345E+02,0.6078E+02,0.5821E+02,0.5572E+02,0.5333E+02,
     +0.5101E+02,0.4879E+02,0.4664E+02,0.4457E+02,0.4258E+02,0.4066E+02,
     +0.3881E+02,0.3703E+02,0.3532E+02,0.3368E+02,0.3209E+02,0.3057E+02,
     +0.2910E+02,0.2769E+02,0.2634E+02,0.2504E+02,0.2379E+02,0.2259E+02,
     +0.2144E+02,0.2034E+02,0.1928E+02,0.1826E+02,0.1729E+02,0.1636E+02,
     +0.1546E+02,0.1460E+02,0.1378E+02,0.1300E+02,0.1225E+02,0.1153E+02,
     +0.1084E+02,0.1019E+02,0.9557E+01,0.8957E+01,0.8384E+01,0.7836E+01,
     +0.7313E+01,0.6815E+01,0.6339E+01,0.5885E+01,0.5452E+01,0.5040E+01,
     +0.4648E+01,0.4275E+01,0.3920E+01,0.3583E+01,0.3263E+01,0.2960E+01,
     +0.2674E+01,0.2404E+01,0.2150E+01,0.1912E+01,0.1689E+01,0.1481E+01,
     +0.1289E+01,0.1112E+01,0.9500E+00,0.8026E+00,0.6699E+00,0.5515E+00,
     +0.4471E+00,0.3563E+00,0.2784E+00,0.2127E+00,0.1585E+00,0.1147E+00,
     +0.8034E-01,0.5415E-01,0.3492E-01,0.2138E-01,0.1232E-01,0.6592E-02,
     +0.4337E-02,0.2825E-02,0.1817E-02,0.1150E-02,0.7132E-03,0.4306E-03,
     +0.2509E-03,0.1394E-03,0.7256E-04,0.3451E-04,0.1439E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,4),I=1,104) /
     +0.1241E+02,0.1201E+02,0.1162E+02,0.1125E+02,0.1089E+02,0.1053E+02,
     +0.1019E+02,0.9857E+01,0.9534E+01,0.9220E+01,0.8916E+01,0.8621E+01,
     +0.8335E+01,0.8058E+01,0.7788E+01,0.7527E+01,0.7274E+01,0.7028E+01,
     +0.6790E+01,0.6560E+01,0.6336E+01,0.6119E+01,0.5909E+01,0.5705E+01,
     +0.5507E+01,0.5316E+01,0.5130E+01,0.4950E+01,0.4776E+01,0.4607E+01,
     +0.4443E+01,0.4284E+01,0.4130E+01,0.3980E+01,0.3835E+01,0.3695E+01,
     +0.3558E+01,0.3425E+01,0.3296E+01,0.3171E+01,0.3049E+01,0.2931E+01,
     +0.2815E+01,0.2703E+01,0.2594E+01,0.2487E+01,0.2383E+01,0.2281E+01,
     +0.2182E+01,0.2085E+01,0.1989E+01,0.1896E+01,0.1805E+01,0.1716E+01,
     +0.1628E+01,0.1542E+01,0.1457E+01,0.1374E+01,0.1293E+01,0.1213E+01,
     +0.1135E+01,0.1058E+01,0.9831E+00,0.9099E+00,0.8385E+00,0.7692E+00,
     +0.7021E+00,0.6373E+00,0.5751E+00,0.5156E+00,0.4590E+00,0.4056E+00,
     +0.3555E+00,0.3089E+00,0.2659E+00,0.2266E+00,0.1910E+00,0.1591E+00,
     +0.1308E+00,0.1060E+00,0.8447E-01,0.6596E-01,0.5028E-01,0.3720E-01,
     +0.2649E-01,0.1798E-01,0.1146E-01,0.6741E-02,0.3566E-02,0.1641E-02,
     +0.9427E-03,0.5196E-03,0.2736E-03,0.1369E-03,0.6477E-04,0.2886E-04,
     +0.1206E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,5),I=1,104) /
     +0.2549E+01,0.2473E+01,0.2400E+01,0.2328E+01,0.2259E+01,0.2191E+01,
     +0.2126E+01,0.2062E+01,0.2000E+01,0.1940E+01,0.1882E+01,0.1825E+01,
     +0.1771E+01,0.1717E+01,0.1666E+01,0.1615E+01,0.1567E+01,0.1520E+01,
     +0.1474E+01,0.1429E+01,0.1386E+01,0.1344E+01,0.1304E+01,0.1264E+01,
     +0.1226E+01,0.1189E+01,0.1153E+01,0.1118E+01,0.1084E+01,0.1051E+01,
     +0.1019E+01,0.9873E+00,0.9570E+00,0.9275E+00,0.8988E+00,0.8708E+00,
     +0.8436E+00,0.8171E+00,0.7911E+00,0.7658E+00,0.7411E+00,0.7169E+00,
     +0.6932E+00,0.6700E+00,0.6472E+00,0.6248E+00,0.6028E+00,0.5811E+00,
     +0.5597E+00,0.5386E+00,0.5177E+00,0.4970E+00,0.4765E+00,0.4562E+00,
     +0.4360E+00,0.4160E+00,0.3960E+00,0.3762E+00,0.3565E+00,0.3370E+00,
     +0.3175E+00,0.2982E+00,0.2791E+00,0.2602E+00,0.2415E+00,0.2232E+00,
     +0.2052E+00,0.1876E+00,0.1705E+00,0.1540E+00,0.1382E+00,0.1231E+00,
     +0.1088E+00,0.9535E-01,0.8284E-01,0.7131E-01,0.6076E-01,0.5121E-01,
     +0.4265E-01,0.3503E-01,0.2831E-01,0.2244E-01,0.1737E-01,0.1304E-01,
     +0.9425E-02,0.6480E-02,0.4178E-02,0.2478E-02,0.1317E-02,0.6060E-03,
     +0.3469E-03,0.1898E-03,0.9878E-04,0.4856E-04,0.2240E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,6),I=1,104) /
     +0.2375E+01,0.2299E+01,0.2225E+01,0.2154E+01,0.2084E+01,0.2017E+01,
     +0.1952E+01,0.1888E+01,0.1826E+01,0.1766E+01,0.1708E+01,0.1652E+01,
     +0.1597E+01,0.1544E+01,0.1492E+01,0.1442E+01,0.1394E+01,0.1347E+01,
     +0.1301E+01,0.1257E+01,0.1214E+01,0.1172E+01,0.1132E+01,0.1093E+01,
     +0.1055E+01,0.1018E+01,0.9826E+00,0.9480E+00,0.9145E+00,0.8820E+00,
     +0.8504E+00,0.8199E+00,0.7902E+00,0.7614E+00,0.7335E+00,0.7063E+00,
     +0.6800E+00,0.6544E+00,0.6296E+00,0.6054E+00,0.5820E+00,0.5591E+00,
     +0.5369E+00,0.5152E+00,0.4941E+00,0.4735E+00,0.4534E+00,0.4338E+00,
     +0.4147E+00,0.3959E+00,0.3776E+00,0.3597E+00,0.3421E+00,0.3249E+00,
     +0.3080E+00,0.2915E+00,0.2753E+00,0.2594E+00,0.2438E+00,0.2285E+00,
     +0.2136E+00,0.1989E+00,0.1846E+00,0.1707E+00,0.1571E+00,0.1440E+00,
     +0.1313E+00,0.1190E+00,0.1072E+00,0.9602E-01,0.8536E-01,0.7530E-01,
     +0.6589E-01,0.5714E-01,0.4908E-01,0.4173E-01,0.3508E-01,0.2913E-01,
     +0.2387E-01,0.1927E-01,0.1528E-01,0.1188E-01,0.9012E-02,0.6634E-02,
     +0.4701E-02,0.3175E-02,0.2016E-02,0.1182E-02,0.6237E-03,0.2867E-03,
     +0.1648E-03,0.9101E-04,0.4805E-04,0.2414E-04,0.1150E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,7),I=1,104) /
     +0.2258E+01,0.2183E+01,0.2109E+01,0.2038E+01,0.1968E+01,0.1901E+01,
     +0.1835E+01,0.1772E+01,0.1710E+01,0.1650E+01,0.1592E+01,0.1536E+01,
     +0.1481E+01,0.1428E+01,0.1377E+01,0.1327E+01,0.1279E+01,0.1232E+01,
     +0.1186E+01,0.1142E+01,0.1099E+01,0.1058E+01,0.1018E+01,0.9788E+00,
     +0.9411E+00,0.9046E+00,0.8692E+00,0.8349E+00,0.8017E+00,0.7695E+00,
     +0.7384E+00,0.7082E+00,0.6790E+00,0.6507E+00,0.6232E+00,0.5967E+00,
     +0.5710E+00,0.5460E+00,0.5219E+00,0.4985E+00,0.4758E+00,0.4539E+00,
     +0.4326E+00,0.4120E+00,0.3920E+00,0.3726E+00,0.3538E+00,0.3356E+00,
     +0.3180E+00,0.3008E+00,0.2842E+00,0.2681E+00,0.2525E+00,0.2374E+00,
     +0.2227E+00,0.2085E+00,0.1948E+00,0.1815E+00,0.1686E+00,0.1562E+00,
     +0.1442E+00,0.1327E+00,0.1217E+00,0.1110E+00,0.1009E+00,0.9121E-01,
     +0.8200E-01,0.7328E-01,0.6506E-01,0.5734E-01,0.5013E-01,0.4345E-01,
     +0.3730E-01,0.3167E-01,0.2658E-01,0.2201E-01,0.1796E-01,0.1441E-01,
     +0.1136E-01,0.8761E-02,0.6600E-02,0.4839E-02,0.3440E-02,0.2359E-02,
     +0.1552E-02,0.9724E-03,0.5751E-03,0.3174E-03,0.1611E-03,0.7381E-04,
     +0.4345E-04,0.2512E-04,0.1423E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,8),I=1,104) /
     +0.2173E+01,0.2099E+01,0.2027E+01,0.1957E+01,0.1889E+01,0.1823E+01,
     +0.1759E+01,0.1696E+01,0.1636E+01,0.1578E+01,0.1521E+01,0.1466E+01,
     +0.1412E+01,0.1360E+01,0.1310E+01,0.1261E+01,0.1214E+01,0.1168E+01,
     +0.1124E+01,0.1081E+01,0.1039E+01,0.9989E+00,0.9598E+00,0.9219E+00,
     +0.8852E+00,0.8497E+00,0.8153E+00,0.7820E+00,0.7498E+00,0.7186E+00,
     +0.6884E+00,0.6592E+00,0.6309E+00,0.6035E+00,0.5771E+00,0.5515E+00,
     +0.5267E+00,0.5027E+00,0.4795E+00,0.4571E+00,0.4354E+00,0.4144E+00,
     +0.3941E+00,0.3744E+00,0.3554E+00,0.3371E+00,0.3193E+00,0.3021E+00,
     +0.2855E+00,0.2694E+00,0.2539E+00,0.2388E+00,0.2243E+00,0.2103E+00,
     +0.1968E+00,0.1837E+00,0.1711E+00,0.1590E+00,0.1473E+00,0.1360E+00,
     +0.1252E+00,0.1149E+00,0.1050E+00,0.9554E-01,0.8655E-01,0.7800E-01,
     +0.6991E-01,0.6229E-01,0.5513E-01,0.4844E-01,0.4222E-01,0.3649E-01,
     +0.3122E-01,0.2643E-01,0.2211E-01,0.1826E-01,0.1485E-01,0.1189E-01,
     +0.9339E-02,0.7185E-02,0.5399E-02,0.3950E-02,0.2802E-02,0.1918E-02,
     +0.1261E-02,0.7898E-03,0.4676E-03,0.2589E-03,0.1322E-03,0.6119E-04,
     +0.3634E-04,0.2123E-04,0.1217E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,5,9),I=1,104) /
     +0.5021E+00,0.4822E+00,0.4630E+00,0.4444E+00,0.4264E+00,0.4091E+00,
     +0.3924E+00,0.3762E+00,0.3606E+00,0.3455E+00,0.3309E+00,0.3169E+00,
     +0.3033E+00,0.2903E+00,0.2777E+00,0.2655E+00,0.2538E+00,0.2425E+00,
     +0.2316E+00,0.2211E+00,0.2110E+00,0.2013E+00,0.1919E+00,0.1829E+00,
     +0.1743E+00,0.1659E+00,0.1579E+00,0.1502E+00,0.1428E+00,0.1356E+00,
     +0.1288E+00,0.1222E+00,0.1159E+00,0.1099E+00,0.1040E+00,0.9847E-01,
     +0.9313E-01,0.8800E-01,0.8309E-01,0.7839E-01,0.7389E-01,0.6958E-01,
     +0.6545E-01,0.6150E-01,0.5773E-01,0.5413E-01,0.5068E-01,0.4739E-01,
     +0.4426E-01,0.4126E-01,0.3841E-01,0.3569E-01,0.3311E-01,0.3065E-01,
     +0.2831E-01,0.2610E-01,0.2399E-01,0.2200E-01,0.2012E-01,0.1834E-01,
     +0.1666E-01,0.1508E-01,0.1360E-01,0.1221E-01,0.1091E-01,0.9704E-02,
     +0.8582E-02,0.7544E-02,0.6588E-02,0.5713E-02,0.4914E-02,0.4191E-02,
     +0.3541E-02,0.2960E-02,0.2445E-02,0.1995E-02,0.1604E-02,0.1269E-02,
     +0.9867E-03,0.7518E-03,0.5601E-03,0.4068E-03,0.2871E-03,0.1961E-03,
     +0.1289E-03,0.8123E-04,0.4867E-04,0.2749E-04,0.1448E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,1),I=1,104) /
     +0.1986E-01,0.2096E-01,0.2212E-01,0.2334E-01,0.2463E-01,0.2599E-01,
     +0.2742E-01,0.2892E-01,0.3051E-01,0.3218E-01,0.3394E-01,0.3579E-01,
     +0.3774E-01,0.3980E-01,0.4196E-01,0.4423E-01,0.4663E-01,0.4914E-01,
     +0.5179E-01,0.5457E-01,0.5750E-01,0.6057E-01,0.6380E-01,0.6720E-01,
     +0.7076E-01,0.7450E-01,0.7842E-01,0.8254E-01,0.8686E-01,0.9139E-01,
     +0.9613E-01,0.1011E+00,0.1063E+00,0.1118E+00,0.1175E+00,0.1234E+00,
     +0.1296E+00,0.1362E+00,0.1429E+00,0.1500E+00,0.1574E+00,0.1651E+00,
     +0.1731E+00,0.1814E+00,0.1901E+00,0.1990E+00,0.2083E+00,0.2179E+00,
     +0.2279E+00,0.2381E+00,0.2487E+00,0.2596E+00,0.2708E+00,0.2822E+00,
     +0.2939E+00,0.3058E+00,0.3179E+00,0.3302E+00,0.3425E+00,0.3549E+00,
     +0.3673E+00,0.3796E+00,0.3917E+00,0.4035E+00,0.4149E+00,0.4258E+00,
     +0.4360E+00,0.4454E+00,0.4538E+00,0.4609E+00,0.4666E+00,0.4707E+00,
     +0.4728E+00,0.4728E+00,0.4703E+00,0.4651E+00,0.4569E+00,0.4456E+00,
     +0.4308E+00,0.4126E+00,0.3907E+00,0.3653E+00,0.3365E+00,0.3047E+00,
     +0.2704E+00,0.2344E+00,0.1975E+00,0.1609E+00,0.1257E+00,0.9324E-01,
     +0.7551E-01,0.6031E-01,0.4743E-01,0.3663E-01,0.2770E-01,0.2042E-01,
     +0.1459E-01,0.1001E-01,0.6525E-02,0.3963E-02,0.2177E-02,0.1027E-02,
     +0.3747E-03,0.8079E-04/
      DATA (XQDUM (I,6,2),I=1,104) /
     +0.1129E-01,0.1191E-01,0.1257E-01,0.1326E-01,0.1399E-01,0.1475E-01,
     +0.1556E-01,0.1641E-01,0.1731E-01,0.1826E-01,0.1925E-01,0.2029E-01,
     +0.2140E-01,0.2255E-01,0.2377E-01,0.2505E-01,0.2640E-01,0.2781E-01,
     +0.2930E-01,0.3086E-01,0.3251E-01,0.3423E-01,0.3604E-01,0.3794E-01,
     +0.3993E-01,0.4202E-01,0.4422E-01,0.4651E-01,0.4892E-01,0.5144E-01,
     +0.5408E-01,0.5684E-01,0.5972E-01,0.6274E-01,0.6589E-01,0.6918E-01,
     +0.7261E-01,0.7619E-01,0.7991E-01,0.8379E-01,0.8782E-01,0.9201E-01,
     +0.9635E-01,0.1009E+00,0.1055E+00,0.1103E+00,0.1153E+00,0.1205E+00,
     +0.1257E+00,0.1312E+00,0.1367E+00,0.1424E+00,0.1482E+00,0.1541E+00,
     +0.1601E+00,0.1661E+00,0.1721E+00,0.1782E+00,0.1842E+00,0.1902E+00,
     +0.1960E+00,0.2017E+00,0.2071E+00,0.2123E+00,0.2170E+00,0.2214E+00,
     +0.2252E+00,0.2283E+00,0.2308E+00,0.2323E+00,0.2330E+00,0.2325E+00,
     +0.2309E+00,0.2279E+00,0.2235E+00,0.2176E+00,0.2101E+00,0.2010E+00,
     +0.1902E+00,0.1777E+00,0.1638E+00,0.1485E+00,0.1322E+00,0.1151E+00,
     +0.9766E-01,0.8037E-01,0.6378E-01,0.4842E-01,0.3481E-01,0.2337E-01,
     +0.1764E-01,0.1307E-01,0.9487E-02,0.6720E-02,0.4626E-02,0.3077E-02,
     +0.1962E-02,0.1186E-02,0.6690E-03,0.3436E-03,0.1545E-03,0.5679E-04,
     +0.1487E-04,0.0000E+00/
      DATA (XQDUM (I,6,3),I=1,104) /
     +0.1449E+03,0.1387E+03,0.1328E+03,0.1271E+03,0.1216E+03,0.1163E+03,
     +0.1112E+03,0.1063E+03,0.1015E+03,0.9700E+02,0.9264E+02,0.8844E+02,
     +0.8440E+02,0.8052E+02,0.7679E+02,0.7321E+02,0.6977E+02,0.6647E+02,
     +0.6330E+02,0.6026E+02,0.5734E+02,0.5454E+02,0.5185E+02,0.4928E+02,
     +0.4681E+02,0.4445E+02,0.4218E+02,0.4001E+02,0.3794E+02,0.3595E+02,
     +0.3405E+02,0.3223E+02,0.3049E+02,0.2883E+02,0.2725E+02,0.2573E+02,
     +0.2428E+02,0.2290E+02,0.2158E+02,0.2033E+02,0.1913E+02,0.1798E+02,
     +0.1690E+02,0.1586E+02,0.1488E+02,0.1394E+02,0.1305E+02,0.1220E+02,
     +0.1139E+02,0.1063E+02,0.9901E+01,0.9212E+01,0.8559E+01,0.7940E+01,
     +0.7353E+01,0.6798E+01,0.6273E+01,0.5777E+01,0.5307E+01,0.4865E+01,
     +0.4447E+01,0.4054E+01,0.3684E+01,0.3337E+01,0.3011E+01,0.2706E+01,
     +0.2421E+01,0.2155E+01,0.1908E+01,0.1680E+01,0.1469E+01,0.1275E+01,
     +0.1098E+01,0.9373E+00,0.7922E+00,0.6623E+00,0.5469E+00,0.4455E+00,
     +0.3575E+00,0.2819E+00,0.2181E+00,0.1651E+00,0.1219E+00,0.8757E-01,
     +0.6092E-01,0.4085E-01,0.2626E-01,0.1607E-01,0.9279E-02,0.4992E-02,
     +0.3298E-02,0.2156E-02,0.1392E-02,0.8824E-03,0.5470E-03,0.3292E-03,
     +0.1906E-03,0.1048E-03,0.5381E-04,0.2510E-04,0.1021E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,4),I=1,104) /
     +0.1943E+02,0.1872E+02,0.1804E+02,0.1739E+02,0.1675E+02,0.1613E+02,
     +0.1554E+02,0.1496E+02,0.1441E+02,0.1387E+02,0.1335E+02,0.1284E+02,
     +0.1236E+02,0.1189E+02,0.1144E+02,0.1100E+02,0.1057E+02,0.1017E+02,
     +0.9772E+01,0.9391E+01,0.9023E+01,0.8668E+01,0.8326E+01,0.7995E+01,
     +0.7676E+01,0.7368E+01,0.7071E+01,0.6785E+01,0.6508E+01,0.6242E+01,
     +0.5985E+01,0.5736E+01,0.5497E+01,0.5266E+01,0.5043E+01,0.4828E+01,
     +0.4621E+01,0.4420E+01,0.4227E+01,0.4040E+01,0.3860E+01,0.3686E+01,
     +0.3518E+01,0.3355E+01,0.3198E+01,0.3046E+01,0.2898E+01,0.2756E+01,
     +0.2618E+01,0.2484E+01,0.2354E+01,0.2228E+01,0.2106E+01,0.1987E+01,
     +0.1872E+01,0.1761E+01,0.1652E+01,0.1547E+01,0.1445E+01,0.1346E+01,
     +0.1250E+01,0.1157E+01,0.1067E+01,0.9802E+00,0.8966E+00,0.8164E+00,
     +0.7395E+00,0.6662E+00,0.5966E+00,0.5307E+00,0.4688E+00,0.4110E+00,
     +0.3574E+00,0.3080E+00,0.2629E+00,0.2221E+00,0.1856E+00,0.1531E+00,
     +0.1247E+00,0.9996E-01,0.7875E-01,0.6077E-01,0.4573E-01,0.3337E-01,
     +0.2342E-01,0.1565E-01,0.9820E-02,0.5679E-02,0.2955E-02,0.1338E-02,
     +0.7621E-03,0.4172E-03,0.2187E-03,0.1093E-03,0.5187E-04,0.2331E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,5),I=1,104) /
     +0.3710E+01,0.3583E+01,0.3461E+01,0.3342E+01,0.3227E+01,0.3116E+01,
     +0.3009E+01,0.2905E+01,0.2804E+01,0.2707E+01,0.2613E+01,0.2522E+01,
     +0.2434E+01,0.2349E+01,0.2267E+01,0.2187E+01,0.2110E+01,0.2036E+01,
     +0.1964E+01,0.1895E+01,0.1828E+01,0.1763E+01,0.1701E+01,0.1640E+01,
     +0.1582E+01,0.1525E+01,0.1471E+01,0.1418E+01,0.1367E+01,0.1318E+01,
     +0.1270E+01,0.1224E+01,0.1180E+01,0.1137E+01,0.1095E+01,0.1055E+01,
     +0.1015E+01,0.9776E+00,0.9409E+00,0.9053E+00,0.8708E+00,0.8373E+00,
     +0.8047E+00,0.7730E+00,0.7422E+00,0.7121E+00,0.6828E+00,0.6542E+00,
     +0.6262E+00,0.5989E+00,0.5721E+00,0.5459E+00,0.5202E+00,0.4949E+00,
     +0.4701E+00,0.4458E+00,0.4218E+00,0.3982E+00,0.3750E+00,0.3523E+00,
     +0.3299E+00,0.3079E+00,0.2864E+00,0.2653E+00,0.2447E+00,0.2247E+00,
     +0.2053E+00,0.1865E+00,0.1685E+00,0.1512E+00,0.1348E+00,0.1192E+00,
     +0.1047E+00,0.9114E-01,0.7864E-01,0.6721E-01,0.5685E-01,0.4755E-01,
     +0.3927E-01,0.3197E-01,0.2559E-01,0.2008E-01,0.1536E-01,0.1140E-01,
     +0.8125E-02,0.5505E-02,0.3494E-02,0.2038E-02,0.1064E-02,0.4807E-03,
     +0.2721E-03,0.1474E-03,0.7597E-04,0.3708E-04,0.1702E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,6),I=1,104) /
     +0.3535E+01,0.3409E+01,0.3286E+01,0.3168E+01,0.3053E+01,0.2942E+01,
     +0.2835E+01,0.2731E+01,0.2631E+01,0.2534E+01,0.2440E+01,0.2349E+01,
     +0.2261E+01,0.2176E+01,0.2094E+01,0.2015E+01,0.1938E+01,0.1864E+01,
     +0.1792E+01,0.1723E+01,0.1657E+01,0.1592E+01,0.1530E+01,0.1470E+01,
     +0.1412E+01,0.1356E+01,0.1302E+01,0.1249E+01,0.1199E+01,0.1150E+01,
     +0.1103E+01,0.1058E+01,0.1014E+01,0.9720E+00,0.9312E+00,0.8918E+00,
     +0.8537E+00,0.8170E+00,0.7815E+00,0.7472E+00,0.7141E+00,0.6820E+00,
     +0.6510E+00,0.6210E+00,0.5920E+00,0.5639E+00,0.5367E+00,0.5104E+00,
     +0.4848E+00,0.4601E+00,0.4360E+00,0.4127E+00,0.3901E+00,0.3681E+00,
     +0.3467E+00,0.3260E+00,0.3059E+00,0.2863E+00,0.2673E+00,0.2489E+00,
     +0.2311E+00,0.2138E+00,0.1971E+00,0.1810E+00,0.1655E+00,0.1506E+00,
     +0.1363E+00,0.1227E+00,0.1098E+00,0.9761E-01,0.8614E-01,0.7544E-01,
     +0.6551E-01,0.5638E-01,0.4805E-01,0.4052E-01,0.3377E-01,0.2780E-01,
     +0.2257E-01,0.1804E-01,0.1416E-01,0.1088E-01,0.8154E-02,0.5924E-02,
     +0.4140E-02,0.2755E-02,0.1722E-02,0.9931E-03,0.5156E-03,0.2333E-03,
     +0.1330E-03,0.7290E-04,0.3830E-04,0.1921E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,7),I=1,104) /
     +0.3419E+01,0.3293E+01,0.3170E+01,0.3052E+01,0.2937E+01,0.2826E+01,
     +0.2719E+01,0.2615E+01,0.2515E+01,0.2418E+01,0.2324E+01,0.2233E+01,
     +0.2146E+01,0.2061E+01,0.1979E+01,0.1900E+01,0.1823E+01,0.1749E+01,
     +0.1678E+01,0.1609E+01,0.1542E+01,0.1478E+01,0.1416E+01,0.1356E+01,
     +0.1298E+01,0.1243E+01,0.1189E+01,0.1137E+01,0.1087E+01,0.1039E+01,
     +0.9921E+00,0.9473E+00,0.9040E+00,0.8623E+00,0.8221E+00,0.7833E+00,
     +0.7459E+00,0.7099E+00,0.6752E+00,0.6418E+00,0.6095E+00,0.5785E+00,
     +0.5486E+00,0.5197E+00,0.4919E+00,0.4652E+00,0.4394E+00,0.4145E+00,
     +0.3906E+00,0.3675E+00,0.3453E+00,0.3239E+00,0.3033E+00,0.2835E+00,
     +0.2645E+00,0.2462E+00,0.2286E+00,0.2117E+00,0.1955E+00,0.1800E+00,
     +0.1652E+00,0.1511E+00,0.1376E+00,0.1248E+00,0.1127E+00,0.1012E+00,
     +0.9036E-01,0.8020E-01,0.7072E-01,0.6189E-01,0.5373E-01,0.4623E-01,
     +0.3939E-01,0.3320E-01,0.2765E-01,0.2272E-01,0.1839E-01,0.1464E-01,
     +0.1144E-01,0.8749E-02,0.6535E-02,0.4750E-02,0.3347E-02,0.2275E-02,
     +0.1484E-02,0.9218E-03,0.5409E-03,0.2965E-03,0.1497E-03,0.6835E-04,
     +0.4020E-04,0.2325E-04,0.1318E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,8),I=1,104) /
     +0.3335E+01,0.3210E+01,0.3089E+01,0.2972E+01,0.2859E+01,0.2750E+01,
     +0.2644E+01,0.2541E+01,0.2442E+01,0.2346E+01,0.2254E+01,0.2164E+01,
     +0.2078E+01,0.1994E+01,0.1913E+01,0.1835E+01,0.1760E+01,0.1687E+01,
     +0.1617E+01,0.1549E+01,0.1483E+01,0.1420E+01,0.1359E+01,0.1300E+01,
     +0.1244E+01,0.1189E+01,0.1136E+01,0.1085E+01,0.1036E+01,0.9888E+00,
     +0.9433E+00,0.8993E+00,0.8570E+00,0.8163E+00,0.7770E+00,0.7392E+00,
     +0.7028E+00,0.6677E+00,0.6340E+00,0.6015E+00,0.5702E+00,0.5401E+00,
     +0.5112E+00,0.4833E+00,0.4565E+00,0.4308E+00,0.4060E+00,0.3822E+00,
     +0.3593E+00,0.3373E+00,0.3161E+00,0.2958E+00,0.2764E+00,0.2577E+00,
     +0.2397E+00,0.2226E+00,0.2061E+00,0.1904E+00,0.1754E+00,0.1610E+00,
     +0.1474E+00,0.1344E+00,0.1220E+00,0.1104E+00,0.9934E-01,0.8895E-01,
     +0.7921E-01,0.7010E-01,0.6163E-01,0.5378E-01,0.4655E-01,0.3994E-01,
     +0.3393E-01,0.2851E-01,0.2367E-01,0.1939E-01,0.1565E-01,0.1243E-01,
     +0.9684E-02,0.7389E-02,0.5506E-02,0.3993E-02,0.2809E-02,0.1907E-02,
     +0.1243E-02,0.7724E-03,0.4540E-03,0.2498E-03,0.1270E-03,0.5858E-04,
     +0.3476E-04,0.2031E-04,0.1164E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,6,9),I=1,104) /
     +0.1717E+01,0.1645E+01,0.1576E+01,0.1509E+01,0.1444E+01,0.1382E+01,
     +0.1322E+01,0.1265E+01,0.1209E+01,0.1155E+01,0.1104E+01,0.1054E+01,
     +0.1006E+01,0.9605E+00,0.9163E+00,0.8738E+00,0.8330E+00,0.7937E+00,
     +0.7559E+00,0.7197E+00,0.6849E+00,0.6514E+00,0.6193E+00,0.5885E+00,
     +0.5589E+00,0.5306E+00,0.5034E+00,0.4773E+00,0.4524E+00,0.4284E+00,
     +0.4055E+00,0.3836E+00,0.3626E+00,0.3425E+00,0.3233E+00,0.3049E+00,
     +0.2874E+00,0.2706E+00,0.2546E+00,0.2393E+00,0.2247E+00,0.2108E+00,
     +0.1976E+00,0.1849E+00,0.1729E+00,0.1615E+00,0.1506E+00,0.1402E+00,
     +0.1304E+00,0.1211E+00,0.1122E+00,0.1038E+00,0.9586E-01,0.8833E-01,
     +0.8121E-01,0.7449E-01,0.6816E-01,0.6219E-01,0.5657E-01,0.5130E-01,
     +0.4636E-01,0.4174E-01,0.3743E-01,0.3342E-01,0.2970E-01,0.2625E-01,
     +0.2308E-01,0.2016E-01,0.1750E-01,0.1508E-01,0.1289E-01,0.1092E-01,
     +0.9161E-02,0.7605E-02,0.6240E-02,0.5053E-02,0.4034E-02,0.3169E-02,
     +0.2445E-02,0.1850E-02,0.1368E-02,0.9862E-03,0.6910E-03,0.4687E-03,
     +0.3063E-03,0.1919E-03,0.1144E-03,0.6432E-04,0.3376E-04,0.1628E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,1),I=1,104) /
     +0.2150E-01,0.2269E-01,0.2393E-01,0.2524E-01,0.2663E-01,0.2808E-01,
     +0.2962E-01,0.3123E-01,0.3293E-01,0.3472E-01,0.3660E-01,0.3858E-01,
     +0.4066E-01,0.4285E-01,0.4516E-01,0.4758E-01,0.5012E-01,0.5280E-01,
     +0.5561E-01,0.5856E-01,0.6166E-01,0.6492E-01,0.6833E-01,0.7192E-01,
     +0.7567E-01,0.7962E-01,0.8375E-01,0.8808E-01,0.9261E-01,0.9736E-01,
     +0.1023E+00,0.1075E+00,0.1130E+00,0.1186E+00,0.1246E+00,0.1307E+00,
     +0.1372E+00,0.1439E+00,0.1509E+00,0.1582E+00,0.1658E+00,0.1737E+00,
     +0.1819E+00,0.1904E+00,0.1992E+00,0.2083E+00,0.2177E+00,0.2274E+00,
     +0.2374E+00,0.2477E+00,0.2583E+00,0.2691E+00,0.2802E+00,0.2915E+00,
     +0.3030E+00,0.3146E+00,0.3264E+00,0.3382E+00,0.3501E+00,0.3619E+00,
     +0.3736E+00,0.3851E+00,0.3964E+00,0.4072E+00,0.4175E+00,0.4271E+00,
     +0.4360E+00,0.4439E+00,0.4507E+00,0.4561E+00,0.4600E+00,0.4621E+00,
     +0.4622E+00,0.4602E+00,0.4556E+00,0.4484E+00,0.4382E+00,0.4250E+00,
     +0.4085E+00,0.3888E+00,0.3658E+00,0.3397E+00,0.3106E+00,0.2791E+00,
     +0.2456E+00,0.2109E+00,0.1760E+00,0.1418E+00,0.1095E+00,0.8017E-01,
     +0.6435E-01,0.5092E-01,0.3966E-01,0.3033E-01,0.2269E-01,0.1653E-01,
     +0.1166E-01,0.7889E-02,0.5059E-02,0.3016E-02,0.1621E-02,0.7440E-03,
     +0.2620E-03,0.5364E-04/
      DATA (XQDUM (I,7,2),I=1,104) /
     +0.1221E-01,0.1288E-01,0.1358E-01,0.1432E-01,0.1511E-01,0.1593E-01,
     +0.1679E-01,0.1770E-01,0.1866E-01,0.1967E-01,0.2073E-01,0.2184E-01,
     +0.2302E-01,0.2425E-01,0.2554E-01,0.2690E-01,0.2833E-01,0.2983E-01,
     +0.3141E-01,0.3306E-01,0.3480E-01,0.3662E-01,0.3852E-01,0.4052E-01,
     +0.4262E-01,0.4482E-01,0.4711E-01,0.4952E-01,0.5204E-01,0.5467E-01,
     +0.5742E-01,0.6029E-01,0.6329E-01,0.6642E-01,0.6968E-01,0.7307E-01,
     +0.7661E-01,0.8029E-01,0.8411E-01,0.8808E-01,0.9220E-01,0.9647E-01,
     +0.1009E+00,0.1055E+00,0.1102E+00,0.1150E+00,0.1200E+00,0.1252E+00,
     +0.1304E+00,0.1358E+00,0.1413E+00,0.1469E+00,0.1526E+00,0.1583E+00,
     +0.1641E+00,0.1699E+00,0.1757E+00,0.1815E+00,0.1872E+00,0.1927E+00,
     +0.1981E+00,0.2033E+00,0.2081E+00,0.2127E+00,0.2168E+00,0.2204E+00,
     +0.2234E+00,0.2257E+00,0.2272E+00,0.2279E+00,0.2276E+00,0.2261E+00,
     +0.2235E+00,0.2196E+00,0.2143E+00,0.2075E+00,0.1992E+00,0.1894E+00,
     +0.1781E+00,0.1654E+00,0.1514E+00,0.1363E+00,0.1203E+00,0.1039E+00,
     +0.8734E-01,0.7119E-01,0.5590E-01,0.4196E-01,0.2979E-01,0.1972E-01,
     +0.1475E-01,0.1082E-01,0.7775E-02,0.5449E-02,0.3709E-02,0.2438E-02,
     +0.1534E-02,0.9140E-03,0.5071E-03,0.2556E-03,0.1124E-03,0.4020E-04,
     +0.1016E-04,0.0000E+00/
      DATA (XQDUM (I,7,3),I=1,104) /
     +0.1808E+03,0.1725E+03,0.1646E+03,0.1570E+03,0.1497E+03,0.1427E+03,
     +0.1360E+03,0.1295E+03,0.1234E+03,0.1174E+03,0.1118E+03,0.1063E+03,
     +0.1011E+03,0.9612E+02,0.9134E+02,0.8677E+02,0.8239E+02,0.7820E+02,
     +0.7420E+02,0.7037E+02,0.6671E+02,0.6321E+02,0.5986E+02,0.5667E+02,
     +0.5362E+02,0.5071E+02,0.4793E+02,0.4529E+02,0.4276E+02,0.4035E+02,
     +0.3806E+02,0.3587E+02,0.3379E+02,0.3181E+02,0.2993E+02,0.2814E+02,
     +0.2643E+02,0.2482E+02,0.2328E+02,0.2182E+02,0.2043E+02,0.1912E+02,
     +0.1787E+02,0.1669E+02,0.1558E+02,0.1452E+02,0.1352E+02,0.1257E+02,
     +0.1168E+02,0.1083E+02,0.1003E+02,0.9282E+01,0.8573E+01,0.7905E+01,
     +0.7277E+01,0.6685E+01,0.6129E+01,0.5608E+01,0.5118E+01,0.4660E+01,
     +0.4231E+01,0.3830E+01,0.3455E+01,0.3107E+01,0.2783E+01,0.2482E+01,
     +0.2203E+01,0.1946E+01,0.1710E+01,0.1493E+01,0.1295E+01,0.1115E+01,
     +0.9528E+00,0.8067E+00,0.6763E+00,0.5608E+00,0.4594E+00,0.3712E+00,
     +0.2955E+00,0.2313E+00,0.1777E+00,0.1336E+00,0.9810E-01,0.7010E-01,
     +0.4856E-01,0.3247E-01,0.2085E-01,0.1276E-01,0.7379E-02,0.3979E-02,
     +0.2632E-02,0.1722E-02,0.1111E-02,0.7030E-03,0.4342E-03,0.2597E-03,
     +0.1491E-03,0.8109E-04,0.4103E-04,0.1880E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,4),I=1,104) /
     +0.2694E+02,0.2588E+02,0.2486E+02,0.2387E+02,0.2292E+02,0.2201E+02,
     +0.2112E+02,0.2027E+02,0.1945E+02,0.1866E+02,0.1790E+02,0.1716E+02,
     +0.1645E+02,0.1577E+02,0.1511E+02,0.1448E+02,0.1387E+02,0.1329E+02,
     +0.1272E+02,0.1218E+02,0.1166E+02,0.1115E+02,0.1067E+02,0.1020E+02,
     +0.9758E+01,0.9328E+01,0.8915E+01,0.8517E+01,0.8135E+01,0.7768E+01,
     +0.7416E+01,0.7077E+01,0.6751E+01,0.6438E+01,0.6138E+01,0.5849E+01,
     +0.5571E+01,0.5305E+01,0.5048E+01,0.4802E+01,0.4565E+01,0.4338E+01,
     +0.4119E+01,0.3909E+01,0.3707E+01,0.3512E+01,0.3325E+01,0.3145E+01,
     +0.2972E+01,0.2805E+01,0.2644E+01,0.2489E+01,0.2340E+01,0.2196E+01,
     +0.2058E+01,0.1924E+01,0.1796E+01,0.1672E+01,0.1553E+01,0.1438E+01,
     +0.1328E+01,0.1222E+01,0.1120E+01,0.1023E+01,0.9303E+00,0.8420E+00,
     +0.7582E+00,0.6789E+00,0.6042E+00,0.5342E+00,0.4690E+00,0.4085E+00,
     +0.3529E+00,0.3021E+00,0.2562E+00,0.2149E+00,0.1783E+00,0.1460E+00,
     +0.1179E+00,0.9378E-01,0.7323E-01,0.5597E-01,0.4169E-01,0.3009E-01,
     +0.2088E-01,0.1378E-01,0.8533E-02,0.4869E-02,0.2499E-02,0.1117E-02,
     +0.6317E-03,0.3439E-03,0.1796E-03,0.8964E-04,0.4263E-04,0.1927E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,5),I=1,104) /
     +0.4953E+01,0.4768E+01,0.4589E+01,0.4416E+01,0.4249E+01,0.4088E+01,
     +0.3933E+01,0.3783E+01,0.3639E+01,0.3499E+01,0.3365E+01,0.3235E+01,
     +0.3110E+01,0.2990E+01,0.2874E+01,0.2762E+01,0.2654E+01,0.2551E+01,
     +0.2451E+01,0.2354E+01,0.2262E+01,0.2172E+01,0.2086E+01,0.2004E+01,
     +0.1924E+01,0.1847E+01,0.1773E+01,0.1702E+01,0.1633E+01,0.1568E+01,
     +0.1504E+01,0.1443E+01,0.1384E+01,0.1327E+01,0.1273E+01,0.1220E+01,
     +0.1169E+01,0.1120E+01,0.1073E+01,0.1028E+01,0.9836E+00,0.9411E+00,
     +0.9001E+00,0.8604E+00,0.8220E+00,0.7848E+00,0.7488E+00,0.7139E+00,
     +0.6800E+00,0.6470E+00,0.6150E+00,0.5839E+00,0.5536E+00,0.5241E+00,
     +0.4953E+00,0.4672E+00,0.4399E+00,0.4132E+00,0.3871E+00,0.3618E+00,
     +0.3370E+00,0.3130E+00,0.2896E+00,0.2669E+00,0.2449E+00,0.2237E+00,
     +0.2033E+00,0.1837E+00,0.1651E+00,0.1474E+00,0.1306E+00,0.1150E+00,
     +0.1004E+00,0.8691E-01,0.7456E-01,0.6334E-01,0.5325E-01,0.4425E-01,
     +0.3629E-01,0.2933E-01,0.2329E-01,0.1812E-01,0.1374E-01,0.1008E-01,
     +0.7109E-02,0.4759E-02,0.2981E-02,0.1714E-02,0.8822E-03,0.3923E-03,
     +0.2200E-03,0.1181E-03,0.6043E-04,0.2932E-04,0.1341E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,6),I=1,104) /
     +0.4779E+01,0.4594E+01,0.4415E+01,0.4242E+01,0.4075E+01,0.3914E+01,
     +0.3759E+01,0.3610E+01,0.3465E+01,0.3326E+01,0.3192E+01,0.3062E+01,
     +0.2938E+01,0.2817E+01,0.2702E+01,0.2590E+01,0.2483E+01,0.2379E+01,
     +0.2279E+01,0.2183E+01,0.2091E+01,0.2002E+01,0.1916E+01,0.1834E+01,
     +0.1755E+01,0.1678E+01,0.1605E+01,0.1534E+01,0.1467E+01,0.1401E+01,
     +0.1338E+01,0.1278E+01,0.1220E+01,0.1164E+01,0.1111E+01,0.1059E+01,
     +0.1009E+01,0.9615E+00,0.9156E+00,0.8715E+00,0.8290E+00,0.7882E+00,
     +0.7488E+00,0.7110E+00,0.6746E+00,0.6395E+00,0.6057E+00,0.5732E+00,
     +0.5418E+00,0.5116E+00,0.4824E+00,0.4543E+00,0.4272E+00,0.4011E+00,
     +0.3759E+00,0.3516E+00,0.3281E+00,0.3056E+00,0.2838E+00,0.2628E+00,
     +0.2427E+00,0.2233E+00,0.2048E+00,0.1870E+00,0.1700E+00,0.1538E+00,
     +0.1385E+00,0.1239E+00,0.1103E+00,0.9744E-01,0.8548E-01,0.7441E-01,
     +0.6422E-01,0.5492E-01,0.4651E-01,0.3896E-01,0.3225E-01,0.2636E-01,
     +0.2124E-01,0.1684E-01,0.1311E-01,0.9981E-02,0.7407E-02,0.5325E-02,
     +0.3680E-02,0.2419E-02,0.1493E-02,0.8498E-03,0.4354E-03,0.1944E-03,
     +0.1100E-03,0.5997E-04,0.3138E-04,0.1572E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,7),I=1,104) /
     +0.4663E+01,0.4478E+01,0.4299E+01,0.4126E+01,0.3959E+01,0.3799E+01,
     +0.3644E+01,0.3494E+01,0.3350E+01,0.3210E+01,0.3076E+01,0.2947E+01,
     +0.2822E+01,0.2702E+01,0.2587E+01,0.2475E+01,0.2368E+01,0.2265E+01,
     +0.2165E+01,0.2069E+01,0.1977E+01,0.1888E+01,0.1803E+01,0.1721E+01,
     +0.1642E+01,0.1566E+01,0.1493E+01,0.1423E+01,0.1355E+01,0.1290E+01,
     +0.1228E+01,0.1168E+01,0.1111E+01,0.1055E+01,0.1002E+01,0.9515E+00,
     +0.9026E+00,0.8557E+00,0.8107E+00,0.7675E+00,0.7260E+00,0.6862E+00,
     +0.6480E+00,0.6114E+00,0.5763E+00,0.5426E+00,0.5103E+00,0.4794E+00,
     +0.4497E+00,0.4213E+00,0.3940E+00,0.3680E+00,0.3430E+00,0.3191E+00,
     +0.2963E+00,0.2745E+00,0.2537E+00,0.2338E+00,0.2149E+00,0.1969E+00,
     +0.1798E+00,0.1636E+00,0.1482E+00,0.1337E+00,0.1201E+00,0.1072E+00,
     +0.9526E-01,0.8408E-01,0.7372E-01,0.6415E-01,0.5537E-01,0.4736E-01,
     +0.4011E-01,0.3360E-01,0.2781E-01,0.2270E-01,0.1826E-01,0.1444E-01,
     +0.1120E-01,0.8511E-02,0.6312E-02,0.4556E-02,0.3187E-02,0.2151E-02,
     +0.1393E-02,0.8598E-03,0.5013E-03,0.2732E-03,0.1373E-03,0.6249E-04,
     +0.3671E-04,0.2121E-04,0.1202E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,8),I=1,104) /
     +0.4581E+01,0.4397E+01,0.4219E+01,0.4048E+01,0.3883E+01,0.3723E+01,
     +0.3569E+01,0.3421E+01,0.3278E+01,0.3140E+01,0.3007E+01,0.2879E+01,
     +0.2756E+01,0.2637E+01,0.2522E+01,0.2412E+01,0.2306E+01,0.2203E+01,
     +0.2105E+01,0.2010E+01,0.1919E+01,0.1831E+01,0.1747E+01,0.1666E+01,
     +0.1588E+01,0.1513E+01,0.1441E+01,0.1372E+01,0.1305E+01,0.1241E+01,
     +0.1180E+01,0.1121E+01,0.1065E+01,0.1010E+01,0.9583E+00,0.9084E+00,
     +0.8604E+00,0.8145E+00,0.7704E+00,0.7281E+00,0.6876E+00,0.6488E+00,
     +0.6116E+00,0.5760E+00,0.5419E+00,0.5092E+00,0.4780E+00,0.4481E+00,
     +0.4194E+00,0.3921E+00,0.3659E+00,0.3409E+00,0.3171E+00,0.2943E+00,
     +0.2726E+00,0.2519E+00,0.2322E+00,0.2135E+00,0.1957E+00,0.1788E+00,
     +0.1629E+00,0.1478E+00,0.1335E+00,0.1201E+00,0.1076E+00,0.9583E-01,
     +0.8488E-01,0.7471E-01,0.6531E-01,0.5667E-01,0.4878E-01,0.4160E-01,
     +0.3513E-01,0.2934E-01,0.2421E-01,0.1971E-01,0.1581E-01,0.1247E-01,
     +0.9652E-02,0.7315E-02,0.5413E-02,0.3900E-02,0.2724E-02,0.1837E-02,
     +0.1189E-02,0.7344E-03,0.4292E-03,0.2349E-03,0.1189E-03,0.5468E-04,
     +0.3240E-04,0.1890E-04,0.1082E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,7,9),I=1,104) /
     +0.3008E+01,0.2875E+01,0.2748E+01,0.2626E+01,0.2508E+01,0.2395E+01,
     +0.2286E+01,0.2181E+01,0.2080E+01,0.1984E+01,0.1891E+01,0.1802E+01,
     +0.1716E+01,0.1634E+01,0.1555E+01,0.1480E+01,0.1407E+01,0.1337E+01,
     +0.1271E+01,0.1207E+01,0.1146E+01,0.1087E+01,0.1031E+01,0.9770E+00,
     +0.9256E+00,0.8763E+00,0.8292E+00,0.7842E+00,0.7412E+00,0.7001E+00,
     +0.6609E+00,0.6234E+00,0.5876E+00,0.5535E+00,0.5209E+00,0.4899E+00,
     +0.4604E+00,0.4322E+00,0.4054E+00,0.3799E+00,0.3557E+00,0.3326E+00,
     +0.3107E+00,0.2899E+00,0.2701E+00,0.2514E+00,0.2337E+00,0.2169E+00,
     +0.2009E+00,0.1859E+00,0.1717E+00,0.1582E+00,0.1455E+00,0.1336E+00,
     +0.1224E+00,0.1118E+00,0.1019E+00,0.9256E-01,0.8385E-01,0.7571E-01,
     +0.6812E-01,0.6106E-01,0.5451E-01,0.4844E-01,0.4284E-01,0.3769E-01,
     +0.3297E-01,0.2866E-01,0.2475E-01,0.2121E-01,0.1803E-01,0.1519E-01,
     +0.1268E-01,0.1047E-01,0.8538E-02,0.6875E-02,0.5456E-02,0.4261E-02,
     +0.3269E-02,0.2458E-02,0.1807E-02,0.1295E-02,0.9025E-03,0.6089E-03,
     +0.3959E-03,0.2468E-03,0.1465E-03,0.8208E-04,0.4292E-04,0.2061E-04,
     +0.1260E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,1),I=1,104) /
     +0.2304E-01,0.2430E-01,0.2563E-01,0.2702E-01,0.2849E-01,0.3004E-01,
     +0.3167E-01,0.3338E-01,0.3518E-01,0.3708E-01,0.3907E-01,0.4116E-01,
     +0.4337E-01,0.4568E-01,0.4811E-01,0.5067E-01,0.5335E-01,0.5617E-01,
     +0.5913E-01,0.6223E-01,0.6549E-01,0.6890E-01,0.7248E-01,0.7623E-01,
     +0.8017E-01,0.8428E-01,0.8860E-01,0.9311E-01,0.9783E-01,0.1028E+00,
     +0.1079E+00,0.1133E+00,0.1189E+00,0.1248E+00,0.1309E+00,0.1373E+00,
     +0.1439E+00,0.1509E+00,0.1580E+00,0.1655E+00,0.1733E+00,0.1813E+00,
     +0.1896E+00,0.1983E+00,0.2072E+00,0.2164E+00,0.2258E+00,0.2356E+00,
     +0.2456E+00,0.2559E+00,0.2664E+00,0.2772E+00,0.2881E+00,0.2992E+00,
     +0.3105E+00,0.3218E+00,0.3333E+00,0.3447E+00,0.3561E+00,0.3673E+00,
     +0.3784E+00,0.3891E+00,0.3995E+00,0.4094E+00,0.4187E+00,0.4272E+00,
     +0.4349E+00,0.4415E+00,0.4468E+00,0.4507E+00,0.4530E+00,0.4535E+00,
     +0.4520E+00,0.4482E+00,0.4419E+00,0.4330E+00,0.4213E+00,0.4066E+00,
     +0.3888E+00,0.3681E+00,0.3443E+00,0.3178E+00,0.2887E+00,0.2576E+00,
     +0.2250E+00,0.1917E+00,0.1586E+00,0.1266E+00,0.9675E-01,0.7000E-01,
     +0.5575E-01,0.4376E-01,0.3380E-01,0.2561E-01,0.1897E-01,0.1368E-01,
     +0.9541E-02,0.6376E-02,0.4030E-02,0.2363E-02,0.1246E-02,0.5583E-03,
     +0.1906E-03,0.3727E-04/
      DATA (XQDUM (I,8,2),I=1,104) /
     +0.1307E-01,0.1378E-01,0.1453E-01,0.1532E-01,0.1615E-01,0.1702E-01,
     +0.1794E-01,0.1890E-01,0.1991E-01,0.2098E-01,0.2210E-01,0.2328E-01,
     +0.2451E-01,0.2581E-01,0.2718E-01,0.2861E-01,0.3011E-01,0.3169E-01,
     +0.3334E-01,0.3507E-01,0.3689E-01,0.3880E-01,0.4079E-01,0.4288E-01,
     +0.4507E-01,0.4735E-01,0.4974E-01,0.5224E-01,0.5485E-01,0.5758E-01,
     +0.6042E-01,0.6339E-01,0.6648E-01,0.6970E-01,0.7306E-01,0.7654E-01,
     +0.8017E-01,0.8393E-01,0.8783E-01,0.9187E-01,0.9605E-01,0.1004E+00,
     +0.1048E+00,0.1095E+00,0.1142E+00,0.1191E+00,0.1241E+00,0.1292E+00,
     +0.1344E+00,0.1398E+00,0.1452E+00,0.1507E+00,0.1562E+00,0.1618E+00,
     +0.1674E+00,0.1730E+00,0.1785E+00,0.1840E+00,0.1893E+00,0.1945E+00,
     +0.1995E+00,0.2042E+00,0.2085E+00,0.2125E+00,0.2160E+00,0.2189E+00,
     +0.2213E+00,0.2228E+00,0.2236E+00,0.2235E+00,0.2224E+00,0.2201E+00,
     +0.2167E+00,0.2120E+00,0.2060E+00,0.1985E+00,0.1897E+00,0.1794E+00,
     +0.1678E+00,0.1549E+00,0.1409E+00,0.1260E+00,0.1105E+00,0.9467E-01,
     +0.7898E-01,0.6383E-01,0.4966E-01,0.3690E-01,0.2591E-01,0.1694E-01,
     +0.1256E-01,0.9142E-02,0.6509E-02,0.4520E-02,0.3046E-02,0.1981E-02,
     +0.1232E-02,0.7246E-03,0.3962E-03,0.1964E-03,0.8468E-04,0.2957E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,3),I=1,104) /
     +0.2152E+03,0.2048E+03,0.1949E+03,0.1854E+03,0.1763E+03,0.1676E+03,
     +0.1592E+03,0.1512E+03,0.1436E+03,0.1363E+03,0.1294E+03,0.1227E+03,
     +0.1163E+03,0.1103E+03,0.1045E+03,0.9894E+02,0.9366E+02,0.8863E+02,
     +0.8383E+02,0.7925E+02,0.7489E+02,0.7073E+02,0.6678E+02,0.6301E+02,
     +0.5942E+02,0.5601E+02,0.5276E+02,0.4968E+02,0.4675E+02,0.4396E+02,
     +0.4132E+02,0.3881E+02,0.3643E+02,0.3417E+02,0.3202E+02,0.3000E+02,
     +0.2807E+02,0.2625E+02,0.2453E+02,0.2290E+02,0.2136E+02,0.1991E+02,
     +0.1854E+02,0.1724E+02,0.1602E+02,0.1486E+02,0.1378E+02,0.1276E+02,
     +0.1180E+02,0.1089E+02,0.1004E+02,0.9245E+01,0.8497E+01,0.7796E+01,
     +0.7139E+01,0.6525E+01,0.5951E+01,0.5416E+01,0.4916E+01,0.4451E+01,
     +0.4018E+01,0.3616E+01,0.3244E+01,0.2899E+01,0.2581E+01,0.2288E+01,
     +0.2019E+01,0.1772E+01,0.1547E+01,0.1342E+01,0.1157E+01,0.9896E+00,
     +0.8398E+00,0.7064E+00,0.5884E+00,0.4848E+00,0.3946E+00,0.3170E+00,
     +0.2509E+00,0.1953E+00,0.1492E+00,0.1117E+00,0.8163E-01,0.5812E-01,
     +0.4015E-01,0.2680E-01,0.1719E-01,0.1052E-01,0.6088E-02,0.3284E-02,
     +0.2171E-02,0.1419E-02,0.9126E-03,0.5754E-03,0.3534E-03,0.2100E-03,
     +0.1195E-03,0.6425E-04,0.3207E-04,0.1446E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,4),I=1,104) /
     +0.3471E+02,0.3326E+02,0.3187E+02,0.3052E+02,0.2923E+02,0.2799E+02,
     +0.2679E+02,0.2564E+02,0.2453E+02,0.2347E+02,0.2244E+02,0.2146E+02,
     +0.2051E+02,0.1961E+02,0.1873E+02,0.1790E+02,0.1709E+02,0.1632E+02,
     +0.1558E+02,0.1487E+02,0.1419E+02,0.1353E+02,0.1290E+02,0.1230E+02,
     +0.1172E+02,0.1117E+02,0.1064E+02,0.1013E+02,0.9644E+01,0.9177E+01,
     +0.8730E+01,0.8301E+01,0.7891E+01,0.7498E+01,0.7122E+01,0.6761E+01,
     +0.6417E+01,0.6086E+01,0.5770E+01,0.5467E+01,0.5178E+01,0.4900E+01,
     +0.4635E+01,0.4380E+01,0.4137E+01,0.3904E+01,0.3680E+01,0.3466E+01,
     +0.3261E+01,0.3065E+01,0.2877E+01,0.2696E+01,0.2524E+01,0.2358E+01,
     +0.2199E+01,0.2047E+01,0.1902E+01,0.1762E+01,0.1629E+01,0.1502E+01,
     +0.1380E+01,0.1264E+01,0.1153E+01,0.1048E+01,0.9486E+00,0.8543E+00,
     +0.7654E+00,0.6819E+00,0.6038E+00,0.5311E+00,0.4639E+00,0.4019E+00,
     +0.3454E+00,0.2941E+00,0.2480E+00,0.2068E+00,0.1705E+00,0.1388E+00,
     +0.1114E+00,0.8796E-01,0.6818E-01,0.5170E-01,0.3819E-01,0.2731E-01,
     +0.1876E-01,0.1226E-01,0.7508E-02,0.4236E-02,0.2149E-02,0.9500E-03,
     +0.5341E-03,0.2894E-03,0.1507E-03,0.7511E-04,0.3576E-04,0.1622E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,5),I=1,104) /
     +0.6243E+01,0.5992E+01,0.5750E+01,0.5518E+01,0.5294E+01,0.5078E+01,
     +0.4871E+01,0.4671E+01,0.4479E+01,0.4295E+01,0.4117E+01,0.3946E+01,
     +0.3782E+01,0.3624E+01,0.3472E+01,0.3327E+01,0.3186E+01,0.3052E+01,
     +0.2922E+01,0.2798E+01,0.2679E+01,0.2564E+01,0.2454E+01,0.2349E+01,
     +0.2247E+01,0.2150E+01,0.2057E+01,0.1967E+01,0.1881E+01,0.1798E+01,
     +0.1719E+01,0.1643E+01,0.1570E+01,0.1500E+01,0.1433E+01,0.1368E+01,
     +0.1306E+01,0.1246E+01,0.1189E+01,0.1134E+01,0.1081E+01,0.1031E+01,
     +0.9816E+00,0.9345E+00,0.8892E+00,0.8455E+00,0.8034E+00,0.7627E+00,
     +0.7235E+00,0.6856E+00,0.6489E+00,0.6135E+00,0.5792E+00,0.5460E+00,
     +0.5138E+00,0.4827E+00,0.4525E+00,0.4232E+00,0.3948E+00,0.3674E+00,
     +0.3408E+00,0.3151E+00,0.2903E+00,0.2663E+00,0.2433E+00,0.2213E+00,
     +0.2002E+00,0.1801E+00,0.1611E+00,0.1432E+00,0.1263E+00,0.1107E+00,
     +0.9618E-01,0.8287E-01,0.7074E-01,0.5980E-01,0.5001E-01,0.4133E-01,
     +0.3370E-01,0.2706E-01,0.2135E-01,0.1648E-01,0.1240E-01,0.9021E-02,
     +0.6299E-02,0.4173E-02,0.2585E-02,0.1469E-02,0.7461E-03,0.3274E-03,
     +0.1821E-03,0.9705E-04,0.4934E-04,0.2381E-04,0.1086E-04,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,6),I=1,104) /
     +0.6069E+01,0.5818E+01,0.5576E+01,0.5344E+01,0.5120E+01,0.4905E+01,
     +0.4698E+01,0.4498E+01,0.4306E+01,0.4122E+01,0.3944E+01,0.3774E+01,
     +0.3610E+01,0.3452E+01,0.3300E+01,0.3155E+01,0.3015E+01,0.2881E+01,
     +0.2752E+01,0.2628E+01,0.2509E+01,0.2395E+01,0.2285E+01,0.2180E+01,
     +0.2079E+01,0.1982E+01,0.1889E+01,0.1800E+01,0.1715E+01,0.1633E+01,
     +0.1555E+01,0.1479E+01,0.1407E+01,0.1338E+01,0.1272E+01,0.1208E+01,
     +0.1148E+01,0.1089E+01,0.1034E+01,0.9801E+00,0.9288E+00,0.8797E+00,
     +0.8326E+00,0.7875E+00,0.7442E+00,0.7027E+00,0.6630E+00,0.6248E+00,
     +0.5883E+00,0.5532E+00,0.5195E+00,0.4872E+00,0.4562E+00,0.4265E+00,
     +0.3980E+00,0.3707E+00,0.3445E+00,0.3193E+00,0.2953E+00,0.2723E+00,
     +0.2503E+00,0.2293E+00,0.2092E+00,0.1902E+00,0.1721E+00,0.1550E+00,
     +0.1389E+00,0.1237E+00,0.1095E+00,0.9631E-01,0.8407E-01,0.7281E-01,
     +0.6252E-01,0.5319E-01,0.4479E-01,0.3732E-01,0.3072E-01,0.2496E-01,
     +0.1998E-01,0.1574E-01,0.1216E-01,0.9191E-02,0.6765E-02,0.4821E-02,
     +0.3300E-02,0.2148E-02,0.1312E-02,0.7382E-03,0.3739E-03,0.1652E-03,
     +0.9290E-04,0.5039E-04,0.2628E-04,0.1314E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,7),I=1,104) /
     +0.5953E+01,0.5702E+01,0.5460E+01,0.5228E+01,0.5004E+01,0.4789E+01,
     +0.4582E+01,0.4383E+01,0.4191E+01,0.4006E+01,0.3829E+01,0.3659E+01,
     +0.3495E+01,0.3337E+01,0.3186E+01,0.3040E+01,0.2901E+01,0.2766E+01,
     +0.2638E+01,0.2514E+01,0.2395E+01,0.2281E+01,0.2172E+01,0.2067E+01,
     +0.1967E+01,0.1870E+01,0.1778E+01,0.1689E+01,0.1604E+01,0.1523E+01,
     +0.1445E+01,0.1370E+01,0.1299E+01,0.1230E+01,0.1165E+01,0.1102E+01,
     +0.1042E+01,0.9847E+00,0.9298E+00,0.8773E+00,0.8271E+00,0.7792E+00,
     +0.7333E+00,0.6895E+00,0.6476E+00,0.6076E+00,0.5694E+00,0.5329E+00,
     +0.4981E+00,0.4649E+00,0.4332E+00,0.4030E+00,0.3743E+00,0.3469E+00,
     +0.3208E+00,0.2960E+00,0.2725E+00,0.2501E+00,0.2289E+00,0.2089E+00,
     +0.1899E+00,0.1721E+00,0.1552E+00,0.1394E+00,0.1246E+00,0.1108E+00,
     +0.9800E-01,0.8610E-01,0.7513E-01,0.6507E-01,0.5589E-01,0.4757E-01,
     +0.4008E-01,0.3340E-01,0.2749E-01,0.2233E-01,0.1786E-01,0.1404E-01,
     +0.1084E-01,0.8184E-02,0.6035E-02,0.4330E-02,0.3011E-02,0.2020E-02,
     +0.1301E-02,0.7983E-03,0.4630E-03,0.2512E-03,0.1257E-03,0.5701E-04,
     +0.3343E-04,0.1929E-04,0.1091E-04,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,8),I=1,104) /
     +0.5871E+01,0.5622E+01,0.5382E+01,0.5151E+01,0.4929E+01,0.4715E+01,
     +0.4509E+01,0.4311E+01,0.4120E+01,0.3937E+01,0.3761E+01,0.3592E+01,
     +0.3429E+01,0.3272E+01,0.3122E+01,0.2978E+01,0.2839E+01,0.2706E+01,
     +0.2579E+01,0.2456E+01,0.2338E+01,0.2225E+01,0.2117E+01,0.2013E+01,
     +0.1914E+01,0.1818E+01,0.1727E+01,0.1639E+01,0.1555E+01,0.1475E+01,
     +0.1398E+01,0.1324E+01,0.1254E+01,0.1186E+01,0.1122E+01,0.1060E+01,
     +0.1001E+01,0.9444E+00,0.8904E+00,0.8389E+00,0.7897E+00,0.7427E+00,
     +0.6978E+00,0.6550E+00,0.6141E+00,0.5751E+00,0.5380E+00,0.5025E+00,
     +0.4688E+00,0.4366E+00,0.4060E+00,0.3769E+00,0.3492E+00,0.3230E+00,
     +0.2980E+00,0.2743E+00,0.2519E+00,0.2307E+00,0.2106E+00,0.1917E+00,
     +0.1738E+00,0.1571E+00,0.1413E+00,0.1266E+00,0.1129E+00,0.1001E+00,
     +0.8827E-01,0.7734E-01,0.6730E-01,0.5812E-01,0.4978E-01,0.4225E-01,
     +0.3550E-01,0.2950E-01,0.2422E-01,0.1961E-01,0.1564E-01,0.1227E-01,
     +0.9446E-02,0.7118E-02,0.5238E-02,0.3752E-02,0.2606E-02,0.1747E-02,
     +0.1125E-02,0.6911E-03,0.4019E-03,0.2190E-03,0.1104E-03,0.5061E-04,
     +0.2993E-04,0.1743E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,8,9),I=1,104) /
     +0.4337E+01,0.4138E+01,0.3948E+01,0.3765E+01,0.3589E+01,0.3420E+01,
     +0.3258E+01,0.3103E+01,0.2954E+01,0.2811E+01,0.2674E+01,0.2543E+01,
     +0.2417E+01,0.2297E+01,0.2181E+01,0.2071E+01,0.1965E+01,0.1864E+01,
     +0.1767E+01,0.1675E+01,0.1586E+01,0.1502E+01,0.1421E+01,0.1344E+01,
     +0.1270E+01,0.1200E+01,0.1133E+01,0.1069E+01,0.1008E+01,0.9498E+00,
     +0.8945E+00,0.8417E+00,0.7915E+00,0.7437E+00,0.6982E+00,0.6550E+00,
     +0.6139E+00,0.5749E+00,0.5378E+00,0.5027E+00,0.4693E+00,0.4377E+00,
     +0.4077E+00,0.3794E+00,0.3525E+00,0.3272E+00,0.3032E+00,0.2805E+00,
     +0.2591E+00,0.2390E+00,0.2200E+00,0.2022E+00,0.1854E+00,0.1696E+00,
     +0.1548E+00,0.1410E+00,0.1280E+00,0.1159E+00,0.1046E+00,0.9412E-01,
     +0.8437E-01,0.7534E-01,0.6699E-01,0.5930E-01,0.5224E-01,0.4577E-01,
     +0.3987E-01,0.3451E-01,0.2967E-01,0.2532E-01,0.2143E-01,0.1797E-01,
     +0.1493E-01,0.1227E-01,0.9960E-02,0.7982E-02,0.6304E-02,0.4899E-02,
     +0.3739E-02,0.2798E-02,0.2047E-02,0.1461E-02,0.1013E-02,0.6804E-03,
     +0.4406E-03,0.2735E-03,0.1617E-03,0.9031E-04,0.4705E-04,0.2250E-04,
     +0.1370E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,1),I=1,104) /
     +0.2449E-01,0.2582E-01,0.2722E-01,0.2870E-01,0.3025E-01,0.3188E-01,
     +0.3359E-01,0.3539E-01,0.3729E-01,0.3928E-01,0.4138E-01,0.4358E-01,
     +0.4589E-01,0.4832E-01,0.5087E-01,0.5354E-01,0.5635E-01,0.5930E-01,
     +0.6239E-01,0.6563E-01,0.6902E-01,0.7258E-01,0.7631E-01,0.8021E-01,
     +0.8430E-01,0.8858E-01,0.9305E-01,0.9772E-01,0.1026E+00,0.1077E+00,
     +0.1130E+00,0.1186E+00,0.1244E+00,0.1304E+00,0.1367E+00,0.1432E+00,
     +0.1500E+00,0.1571E+00,0.1644E+00,0.1720E+00,0.1799E+00,0.1881E+00,
     +0.1965E+00,0.2052E+00,0.2142E+00,0.2235E+00,0.2330E+00,0.2427E+00,
     +0.2528E+00,0.2630E+00,0.2734E+00,0.2841E+00,0.2948E+00,0.3058E+00,
     +0.3168E+00,0.3278E+00,0.3389E+00,0.3499E+00,0.3608E+00,0.3715E+00,
     +0.3819E+00,0.3920E+00,0.4016E+00,0.4106E+00,0.4190E+00,0.4265E+00,
     +0.4330E+00,0.4384E+00,0.4425E+00,0.4451E+00,0.4460E+00,0.4451E+00,
     +0.4421E+00,0.4368E+00,0.4291E+00,0.4189E+00,0.4059E+00,0.3900E+00,
     +0.3713E+00,0.3498E+00,0.3255E+00,0.2988E+00,0.2699E+00,0.2393E+00,
     +0.2077E+00,0.1757E+00,0.1442E+00,0.1142E+00,0.8644E-01,0.6189E-01,
     +0.4894E-01,0.3814E-01,0.2923E-01,0.2197E-01,0.1614E-01,0.1153E-01,
     +0.7959E-02,0.5258E-02,0.3282E-02,0.1896E-02,0.9823E-03,0.4309E-03,
     +0.1430E-03,0.2684E-04/
      DATA (XQDUM (I,9,2),I=1,104) /
     +0.1388E-01,0.1463E-01,0.1542E-01,0.1625E-01,0.1712E-01,0.1804E-01,
     +0.1900E-01,0.2002E-01,0.2108E-01,0.2220E-01,0.2338E-01,0.2461E-01,
     +0.2591E-01,0.2727E-01,0.2869E-01,0.3019E-01,0.3176E-01,0.3340E-01,
     +0.3513E-01,0.3693E-01,0.3883E-01,0.4080E-01,0.4288E-01,0.4504E-01,
     +0.4731E-01,0.4967E-01,0.5215E-01,0.5473E-01,0.5742E-01,0.6023E-01,
     +0.6316E-01,0.6620E-01,0.6938E-01,0.7267E-01,0.7610E-01,0.7966E-01,
     +0.8335E-01,0.8718E-01,0.9114E-01,0.9524E-01,0.9947E-01,0.1038E+00,
     +0.1083E+00,0.1130E+00,0.1177E+00,0.1226E+00,0.1276E+00,0.1327E+00,
     +0.1379E+00,0.1431E+00,0.1485E+00,0.1538E+00,0.1593E+00,0.1647E+00,
     +0.1701E+00,0.1755E+00,0.1808E+00,0.1859E+00,0.1910E+00,0.1958E+00,
     +0.2003E+00,0.2046E+00,0.2085E+00,0.2119E+00,0.2149E+00,0.2173E+00,
     +0.2190E+00,0.2199E+00,0.2200E+00,0.2192E+00,0.2174E+00,0.2145E+00,
     +0.2104E+00,0.2050E+00,0.1984E+00,0.1904E+00,0.1812E+00,0.1706E+00,
     +0.1587E+00,0.1458E+00,0.1319E+00,0.1173E+00,0.1022E+00,0.8699E-01,
     +0.7206E-01,0.5779E-01,0.4460E-01,0.3284E-01,0.2284E-01,0.1476E-01,
     +0.1087E-01,0.7848E-02,0.5543E-02,0.3817E-02,0.2550E-02,0.1642E-02,
     +0.1011E-02,0.5876E-03,0.3171E-03,0.1549E-03,0.6562E-04,0.2243E-04,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,3),I=1,104) /
     +0.2479E+03,0.2354E+03,0.2235E+03,0.2121E+03,0.2012E+03,0.1907E+03,
     +0.1808E+03,0.1713E+03,0.1623E+03,0.1537E+03,0.1455E+03,0.1376E+03,
     +0.1302E+03,0.1231E+03,0.1163E+03,0.1099E+03,0.1037E+03,0.9788E+02,
     +0.9233E+02,0.8706E+02,0.8204E+02,0.7728E+02,0.7275E+02,0.6846E+02,
     +0.6438E+02,0.6051E+02,0.5684E+02,0.5336E+02,0.5006E+02,0.4694E+02,
     +0.4398E+02,0.4119E+02,0.3854E+02,0.3604E+02,0.3367E+02,0.3144E+02,
     +0.2933E+02,0.2734E+02,0.2546E+02,0.2369E+02,0.2202E+02,0.2045E+02,
     +0.1897E+02,0.1758E+02,0.1628E+02,0.1505E+02,0.1390E+02,0.1282E+02,
     +0.1181E+02,0.1086E+02,0.9972E+01,0.9143E+01,0.8369E+01,0.7646E+01,
     +0.6972E+01,0.6345E+01,0.5761E+01,0.5219E+01,0.4716E+01,0.4249E+01,
     +0.3818E+01,0.3420E+01,0.3052E+01,0.2714E+01,0.2404E+01,0.2120E+01,
     +0.1861E+01,0.1625E+01,0.1411E+01,0.1218E+01,0.1044E+01,0.8885E+00,
     +0.7501E+00,0.6276E+00,0.5200E+00,0.4262E+00,0.3452E+00,0.2760E+00,
     +0.2174E+00,0.1685E+00,0.1282E+00,0.9562E-01,0.6969E-01,0.4949E-01,
     +0.3413E-01,0.2275E-01,0.1458E-01,0.8919E-02,0.5157E-02,0.2778E-02,
     +0.1833E-02,0.1195E-02,0.7659E-03,0.4807E-03,0.2935E-03,0.1731E-03,
     +0.9763E-04,0.5197E-04,0.2562E-04,0.1138E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,4),I=1,104) /
     +0.4260E+02,0.4073E+02,0.3893E+02,0.3721E+02,0.3555E+02,0.3396E+02,
     +0.3243E+02,0.3097E+02,0.2956E+02,0.2821E+02,0.2692E+02,0.2567E+02,
     +0.2448E+02,0.2334E+02,0.2225E+02,0.2120E+02,0.2020E+02,0.1924E+02,
     +0.1832E+02,0.1744E+02,0.1659E+02,0.1579E+02,0.1501E+02,0.1427E+02,
     +0.1357E+02,0.1289E+02,0.1224E+02,0.1163E+02,0.1103E+02,0.1047E+02,
     +0.9931E+01,0.9416E+01,0.8924E+01,0.8454E+01,0.8005E+01,0.7577E+01,
     +0.7168E+01,0.6777E+01,0.6405E+01,0.6049E+01,0.5710E+01,0.5386E+01,
     +0.5077E+01,0.4783E+01,0.4501E+01,0.4233E+01,0.3977E+01,0.3732E+01,
     +0.3499E+01,0.3277E+01,0.3064E+01,0.2862E+01,0.2668E+01,0.2484E+01,
     +0.2308E+01,0.2141E+01,0.1981E+01,0.1828E+01,0.1684E+01,0.1546E+01,
     +0.1415E+01,0.1291E+01,0.1173E+01,0.1062E+01,0.9567E+00,0.8581E+00,
     +0.7656E+00,0.6791E+00,0.5988E+00,0.5244E+00,0.4560E+00,0.3933E+00,
     +0.3364E+00,0.2851E+00,0.2393E+00,0.1986E+00,0.1629E+00,0.1319E+00,
     +0.1053E+00,0.8264E-01,0.6365E-01,0.4794E-01,0.3516E-01,0.2495E-01,
     +0.1700E-01,0.1100E-01,0.6678E-02,0.3731E-02,0.1874E-02,0.8207E-03,
     +0.4590E-03,0.2477E-03,0.1286E-03,0.6402E-04,0.3049E-04,0.1386E-04,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,5),I=1,104) /
     +0.7551E+01,0.7230E+01,0.6922E+01,0.6626E+01,0.6342E+01,0.6068E+01,
     +0.5806E+01,0.5554E+01,0.5313E+01,0.5081E+01,0.4858E+01,0.4644E+01,
     +0.4439E+01,0.4243E+01,0.4054E+01,0.3873E+01,0.3700E+01,0.3534E+01,
     +0.3375E+01,0.3222E+01,0.3076E+01,0.2936E+01,0.2802E+01,0.2673E+01,
     +0.2550E+01,0.2433E+01,0.2320E+01,0.2212E+01,0.2109E+01,0.2010E+01,
     +0.1915E+01,0.1825E+01,0.1738E+01,0.1655E+01,0.1576E+01,0.1500E+01,
     +0.1427E+01,0.1358E+01,0.1291E+01,0.1227E+01,0.1166E+01,0.1108E+01,
     +0.1051E+01,0.9976E+00,0.9459E+00,0.8963E+00,0.8487E+00,0.8029E+00,
     +0.7589E+00,0.7166E+00,0.6759E+00,0.6367E+00,0.5990E+00,0.5626E+00,
     +0.5275E+00,0.4937E+00,0.4611E+00,0.4297E+00,0.3995E+00,0.3703E+00,
     +0.3422E+00,0.3152E+00,0.2893E+00,0.2644E+00,0.2407E+00,0.2180E+00,
     +0.1965E+00,0.1761E+00,0.1569E+00,0.1389E+00,0.1221E+00,0.1065E+00,
     +0.9219E-01,0.7910E-01,0.6724E-01,0.5659E-01,0.4711E-01,0.3874E-01,
     +0.3143E-01,0.2511E-01,0.1969E-01,0.1510E-01,0.1128E-01,0.8145E-02,
     +0.5639E-02,0.3702E-02,0.2271E-02,0.1277E-02,0.6413E-03,0.2781E-03,
     +0.1536E-03,0.8135E-04,0.4112E-04,0.1976E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,6),I=1,104) /
     +0.7377E+01,0.7056E+01,0.6748E+01,0.6452E+01,0.6168E+01,0.5895E+01,
     +0.5633E+01,0.5381E+01,0.5140E+01,0.4908E+01,0.4685E+01,0.4472E+01,
     +0.4267E+01,0.4071E+01,0.3882E+01,0.3702E+01,0.3529E+01,0.3363E+01,
     +0.3204E+01,0.3052E+01,0.2906E+01,0.2767E+01,0.2633E+01,0.2505E+01,
     +0.2383E+01,0.2266E+01,0.2154E+01,0.2046E+01,0.1944E+01,0.1846E+01,
     +0.1752E+01,0.1663E+01,0.1577E+01,0.1495E+01,0.1417E+01,0.1342E+01,
     +0.1271E+01,0.1202E+01,0.1137E+01,0.1075E+01,0.1016E+01,0.9588E+00,
     +0.9045E+00,0.8527E+00,0.8032E+00,0.7559E+00,0.7108E+00,0.6676E+00,
     +0.6264E+00,0.5870E+00,0.5493E+00,0.5134E+00,0.4790E+00,0.4462E+00,
     +0.4149E+00,0.3850E+00,0.3564E+00,0.3292E+00,0.3033E+00,0.2786E+00,
     +0.2551E+00,0.2328E+00,0.2116E+00,0.1916E+00,0.1727E+00,0.1549E+00,
     +0.1382E+00,0.1226E+00,0.1081E+00,0.9466E-01,0.8228E-01,0.7095E-01,
     +0.6066E-01,0.5137E-01,0.4306E-01,0.3570E-01,0.2925E-01,0.2364E-01,
     +0.1882E-01,0.1474E-01,0.1132E-01,0.8503E-02,0.6214E-02,0.4395E-02,
     +0.2984E-02,0.1926E-02,0.1165E-02,0.6494E-03,0.3257E-03,0.1425E-03,
     +0.7973E-04,0.4307E-04,0.2239E-04,0.1118E-04,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,7),I=1,104) /
     +0.7261E+01,0.6940E+01,0.6632E+01,0.6337E+01,0.6052E+01,0.5779E+01,
     +0.5517E+01,0.5266E+01,0.5024E+01,0.4793E+01,0.4570E+01,0.4357E+01,
     +0.4152E+01,0.3956E+01,0.3768E+01,0.3588E+01,0.3415E+01,0.3249E+01,
     +0.3091E+01,0.2939E+01,0.2793E+01,0.2654E+01,0.2521E+01,0.2393E+01,
     +0.2271E+01,0.2154E+01,0.2043E+01,0.1936E+01,0.1834E+01,0.1736E+01,
     +0.1643E+01,0.1554E+01,0.1469E+01,0.1388E+01,0.1311E+01,0.1237E+01,
     +0.1166E+01,0.1099E+01,0.1035E+01,0.9735E+00,0.9152E+00,0.8596E+00,
     +0.8066E+00,0.7561E+00,0.7081E+00,0.6623E+00,0.6188E+00,0.5774E+00,
     +0.5380E+00,0.5005E+00,0.4649E+00,0.4311E+00,0.3991E+00,0.3686E+00,
     +0.3398E+00,0.3125E+00,0.2866E+00,0.2622E+00,0.2392E+00,0.2174E+00,
     +0.1970E+00,0.1778E+00,0.1598E+00,0.1430E+00,0.1274E+00,0.1128E+00,
     +0.9936E-01,0.8695E-01,0.7557E-01,0.6518E-01,0.5574E-01,0.4724E-01,
     +0.3963E-01,0.3288E-01,0.2694E-01,0.2178E-01,0.1734E-01,0.1357E-01,
     +0.1042E-01,0.7831E-02,0.5745E-02,0.4101E-02,0.2838E-02,0.1895E-02,
     +0.1214E-02,0.7413E-03,0.4280E-03,0.2312E-03,0.1153E-03,0.5209E-04,
     +0.3049E-04,0.1755E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,8),I=1,104) /
     +0.7181E+01,0.6861E+01,0.6555E+01,0.6260E+01,0.5978E+01,0.5706E+01,
     +0.5445E+01,0.5195E+01,0.4955E+01,0.4724E+01,0.4503E+01,0.4291E+01,
     +0.4087E+01,0.3892E+01,0.3705E+01,0.3526E+01,0.3354E+01,0.3190E+01,
     +0.3032E+01,0.2881E+01,0.2737E+01,0.2599E+01,0.2466E+01,0.2340E+01,
     +0.2219E+01,0.2103E+01,0.1992E+01,0.1887E+01,0.1786E+01,0.1689E+01,
     +0.1597E+01,0.1509E+01,0.1425E+01,0.1345E+01,0.1268E+01,0.1195E+01,
     +0.1126E+01,0.1059E+01,0.9961E+00,0.9358E+00,0.8785E+00,0.8239E+00,
     +0.7719E+00,0.7225E+00,0.6754E+00,0.6307E+00,0.5882E+00,0.5478E+00,
     +0.5095E+00,0.4731E+00,0.4386E+00,0.4059E+00,0.3749E+00,0.3455E+00,
     +0.3178E+00,0.2916E+00,0.2668E+00,0.2435E+00,0.2216E+00,0.2010E+00,
     +0.1816E+00,0.1635E+00,0.1466E+00,0.1309E+00,0.1162E+00,0.1027E+00,
     +0.9018E-01,0.7871E-01,0.6821E-01,0.5867E-01,0.5004E-01,0.4229E-01,
     +0.3539E-01,0.2928E-01,0.2393E-01,0.1929E-01,0.1532E-01,0.1196E-01,
     +0.9161E-02,0.6870E-02,0.5031E-02,0.3586E-02,0.2478E-02,0.1654E-02,
     +0.1060E-02,0.6482E-03,0.3753E-03,0.2037E-03,0.1023E-03,0.4674E-04,
     +0.2758E-04,0.1602E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA (XQDUM (I,9,9),I=1,104) /
     +0.5681E+01,0.5411E+01,0.5153E+01,0.4905E+01,0.4668E+01,0.4441E+01,
     +0.4223E+01,0.4015E+01,0.3815E+01,0.3624E+01,0.3442E+01,0.3267E+01,
     +0.3100E+01,0.2940E+01,0.2787E+01,0.2641E+01,0.2502E+01,0.2368E+01,
     +0.2241E+01,0.2120E+01,0.2004E+01,0.1894E+01,0.1788E+01,0.1688E+01,
     +0.1592E+01,0.1501E+01,0.1414E+01,0.1332E+01,0.1253E+01,0.1179E+01,
     +0.1107E+01,0.1040E+01,0.9758E+00,0.9149E+00,0.8571E+00,0.8022E+00,
     +0.7502E+00,0.7010E+00,0.6543E+00,0.6101E+00,0.5683E+00,0.5287E+00,
     +0.4914E+00,0.4561E+00,0.4228E+00,0.3913E+00,0.3617E+00,0.3338E+00,
     +0.3076E+00,0.2829E+00,0.2597E+00,0.2380E+00,0.2176E+00,0.1985E+00,
     +0.1807E+00,0.1641E+00,0.1485E+00,0.1341E+00,0.1207E+00,0.1082E+00,
     +0.9669E-01,0.8606E-01,0.7627E-01,0.6729E-01,0.5906E-01,0.5157E-01,
     +0.4476E-01,0.3861E-01,0.3307E-01,0.2811E-01,0.2370E-01,0.1980E-01,
     +0.1638E-01,0.1341E-01,0.1084E-01,0.8654E-02,0.6807E-02,0.5268E-02,
     +0.4005E-02,0.2984E-02,0.2174E-02,0.1545E-02,0.1067E-02,0.7143E-03,
     +0.4608E-03,0.2851E-03,0.1680E-03,0.9348E-04,0.4852E-04,0.2309E-04,
     +0.1401E-04,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,0.0000E+00,
     +0.0000E+00,0.0000E+00/
      DATA XMIN/5.E-05/,XMAX/.95/
      DATA ISTEP/0/
      IF(ISTEP.EQ.0) THEN
        DO 2 I=1,IX
          ENT(I)=LOG10(XCO(I))
    2   CONTINUE
        NENT(1)=IX
        NENT(2)=IQ
        DO 3 I=1,IQ
          ENT(IX+I)=LOG10(Q2(I))
    3   CONTINUE
        ISTEP=1
      ENDIF
      IF (STRFUN(1:2) .EQ. 'UP' ) THEN
      IFUN =1
      ELSE IF (STRFUN(1:2) .EQ. 'DO') THEN
      IFUN =2
      ELSE IF (STRFUN(1:2) .EQ. 'GL') THEN
      IFUN =3
      ELSE IF (STRFUN(1:2) .EQ. 'QB') THEN
      IFUN =4
      ELSE IF (STRFUN(1:2) .EQ. 'UB') THEN
      IFUN =5
      ELSE IF (STRFUN(1:2) .EQ. 'SB') THEN
      IFUN =6
      ELSE IF (STRFUN(1:2) .EQ. 'CB') THEN
      IFUN =7
      ELSE IF (STRFUN(1:2) .EQ. 'BB') THEN
      IFUN =8
      ELSE IF (STRFUN(1:2) .EQ. 'TB') THEN
      IFUN =9
      ENDIF
      FUNC=0.
C     IF(X.GT.XMIN.AND.X.LT.XMAX) THEN
      IF(X.LT.XMAX) THEN
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(QSTAR2)
      FUNC =FINT(NARG,ARG,NENT,ENT,XQDUM(1,1,IFUN))
      ENDIF
      IF (FUNC.LT.0.) FUNC=0.
      END
