/*************************************************************
 *
 *  MathJax/jax/output/SVG/fonts/TeX/svg/Fraktur/Regular/BasicLatin.js
 *
 *  Copyright (c) 2011-2016 The MathJax Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

MathJax.Hub.Insert(
  MathJax.OutputJax.SVG.FONTDATA.FONTS['MathJax_Fraktur'],
  {
    // SPACE
    0x20: [0,0,250,0,0,''],

    // EXCLAMATION MARK
    0x21: [689,12,296,91,204,'102 582T102 620T112 673T152 689Q190 689 190 638Q190 605 167 373L148 187L133 184Q102 582 102 620ZM91 24T91 48T107 88T148 104Q171 104 187 87T204 48Q204 22 188 5T149 -12Q124 -12 108 6'],

    // QUOTATION MARK
    0x22: [695,-432,215,8,196,'33 436Q8 603 8 648Q8 663 9 671T19 687T43 695Q63 695 74 681Q76 678 76 650V623L66 532Q57 443 55 436V432H33V436ZM128 666Q128 691 162 691T196 668Q196 634 186 531Q176 441 176 432H166Q155 432 155 434L142 545Q135 603 130 647Q128 664 128 666'],

    // AMPERSAND
    0x26: [698,11,738,49,733,'181 520Q181 604 231 650T328 697L330 698Q333 698 335 698Q336 698 340 698T346 697Q390 697 418 670T446 604Q446 554 414 511Q384 467 300 417L283 406Q281 405 296 374T347 286T425 182Q466 135 469 135Q470 135 473 140T480 152T486 165Q509 210 509 263Q509 282 507 292Q498 317 488 332T465 352T443 359T418 361Q388 361 357 358L346 356L347 374Q347 394 348 396V399H355Q366 396 535 396Q663 396 689 398L703 399Q703 398 702 375T700 351L688 353Q655 356 601 357Q553 357 553 355Q562 332 562 294Q562 280 561 267T555 241T548 218T539 195T529 175T518 156T508 141T497 126L489 115L496 107Q549 54 596 54Q623 54 644 67T677 101T697 140T708 174L710 187Q710 188 710 188L711 190Q714 190 723 187T733 183Q733 179 732 172T726 145T714 107T694 66T665 27T623 0T569 -11Q500 -11 443 41L434 49L425 42Q348 -9 275 -9Q251 -9 233 -6Q187 -1 152 18T98 60T67 111T52 159T49 195Q49 231 60 261T96 315T141 354T197 390L208 397Q181 459 181 520ZM374 577Q374 607 356 629T311 651Q289 651 271 636Q242 614 242 559Q242 533 249 502T262 453T270 435T279 440T298 453T314 464Q374 503 374 577ZM127 217Q127 145 173 89T291 32Q318 32 347 42T393 63T409 75Q384 100 325 184T227 351Q223 366 220 366Q215 366 178 338Q127 298 127 217'],

    // APOSTROPHE
    0x27: [695,-436,212,69,134,'69 666Q69 680 79 687T104 695Q112 695 117 694T128 684T134 659L104 438Q104 436 96 436T88 438Q88 447 79 540T69 655V666'],

    // LEFT PARENTHESIS
    0x28: [737,186,389,114,293,'293 737V719Q291 718 285 714T276 708T268 702T258 695T250 686T241 674Q164 570 164 282Q164 -37 230 -119Q273 -171 292 -171Q293 -171 293 -179V-186H289Q270 -180 259 -175Q175 -132 145 -23T114 275Q114 491 157 598T293 737'],

    // RIGHT PARENTHESIS
    0x29: [735,187,389,89,276,'223 259Q223 386 212 474T178 609T136 677T89 714V735Q121 726 139 713Q276 622 276 273Q276 98 246 -23Q225 -106 189 -139T89 -187V-170L101 -165Q148 -146 172 -110T210 13T223 259'],

    // ASTERISK
    0x2A: [692,-449,278,34,234,'118 573Q118 575 76 602L34 629L50 647L55 652L66 642Q76 633 91 620T117 598L128 590Q128 663 125 687V692H151V689V687Q151 685 151 683T150 678T150 672Q145 628 144 605V592L219 652L232 634Q232 632 220 624Q195 610 155 582L146 575L158 567Q178 552 197 540T225 523T233 516Q233 515 226 506T217 495L152 549L143 555V530Q144 509 145 492T148 466T149 454Q149 449 142 449H125V462Q128 522 128 549V562L115 552Q88 531 59 506L45 495Q44 495 39 505T34 516L118 573'],

    // PLUS SIGN
    0x2B: [598,82,756,47,709,'357 584L399 598V282H709L702 263L696 243H399V-64L379 -73L358 -82Q357 -82 357 81V243H47L51 253Q52 256 54 263T58 272L62 282H357V584'],

    // COMMA
    0x2C: [107,191,278,99,213,'99 62Q99 82 114 94T144 107Q159 107 178 77T205 26Q213 5 213 -23Q213 -49 207 -65T181 -113Q128 -189 122 -191Q121 -191 116 -184T111 -174Q111 -173 122 -155T145 -111T156 -62Q156 -44 152 -34T127 4L104 37Q99 49 99 62'],

    // HYPHEN-MINUS
    0x2D: [275,-236,756,46,706,'46 236L62 274Q62 275 384 275H706L699 255L693 236H46'],

    // FULL STOP
    0x2E: [102,15,278,87,200,'87 43Q87 69 104 85T142 102Q164 102 182 86T200 44Q200 20 183 3T141 -15Q118 -15 103 2T87 43'],

    // SOLIDUS
    0x2F: [721,182,502,34,466,'230 270Q426 721 428 721Q437 719 447 717L466 713L448 672Q78 -180 77 -181Q77 -182 55 -182L34 -181L230 270'],

    // DIGIT ZERO
    0x30: [492,13,502,42,456,'212 -13Q184 -13 156 -2T101 32T59 97T42 195Q42 311 132 396Q170 433 211 462T262 492Q272 492 301 477T366 434T429 360T456 258Q456 161 378 74T212 -13ZM381 209Q381 257 365 295T328 355T282 390T243 408T223 413Q220 413 204 403T167 376T137 341Q119 305 119 250Q119 168 159 114T263 59Q308 59 344 93T381 209'],

    // DIGIT ONE
    0x31: [468,2,502,47,460,'123 459Q145 459 170 460T217 462T256 464T284 466L295 467Q296 467 296 467T297 468Q299 468 302 466T307 462L309 459Q307 454 304 424T299 341T297 235Q297 139 298 101T302 55T313 44Q316 43 367 43L460 46Q460 35 459 22V-1H450Q402 2 281 6Q222 6 171 4T91 1T56 -1L47 -2V43H121H170Q195 43 201 45T209 56Q212 69 212 214Q212 333 209 365T194 409Q183 417 161 423T121 430L104 432Q103 432 103 446V459H123'],

    // DIGIT TWO
    0x32: [474,-1,502,60,484,'104 384Q115 394 133 409T199 449T281 474Q321 474 351 447T385 378Q385 328 333 255T228 127T176 72Q176 67 183 65Q184 65 203 65T260 67T331 69L475 73L484 67Q484 64 472 33L460 1H60V17L107 61Q210 159 249 208Q309 283 309 331Q309 363 285 389T228 415Q212 415 184 403T134 379L114 367L104 384'],

    // DIGIT THREE
    0x33: [473,182,502,39,429,'305 328Q305 372 279 396T214 421H211Q172 421 128 384L107 398L116 405Q151 437 191 455T251 473H260Q314 473 341 455T382 394Q384 386 384 367T382 338Q362 263 271 217L256 210L257 206L259 202Q260 202 272 201T296 198T324 192T355 179T384 157T410 123T427 75Q429 64 429 41Q429 -59 353 -120T183 -182L88 -164Q81 -162 69 -157T48 -147T39 -141Q39 -139 46 -127L53 -114L69 -122Q129 -149 171 -149Q218 -149 253 -131T305 -83T330 -26T338 29Q338 41 336 55T328 89T308 127T273 153Q228 171 162 171Q158 171 152 171T142 170H127V204H134Q232 214 275 257Q305 292 305 328'],

    // DIGIT FOUR
    0x34: [476,191,502,10,481,'299 -179Q306 -156 306 -48V0H11V7Q10 10 10 18Q10 23 154 236L298 449Q298 450 339 463L379 476Q385 473 384 470V466Q384 463 384 457T384 444T383 427T383 408Q381 328 381 248Q381 46 384 40H387Q422 40 460 44Q465 44 470 44T478 44L481 45Q481 43 478 24T473 1Q473 -1 464 -1Q462 -1 451 -1T430 0H387V-76L389 -156V-161L311 -191Q299 -181 299 -179ZM299 364H287L277 352Q234 297 186 224T112 104T79 43Q79 42 192 42H306V115Q306 300 299 359V364'],

    // DIGIT FIVE
    0x35: [458,185,502,47,441,'334 25Q334 99 296 134T207 169Q154 169 107 123L98 114L89 120L80 125V458H420Q420 456 409 418L397 379Q397 378 264 378H131Q130 377 128 376T125 374T124 371T122 368T122 363T121 356T121 345V279V190L130 186L140 190Q196 214 260 214Q311 214 348 197T404 153T431 99T440 42T433 -16T406 -76T356 -130T276 -169T163 -184H156Q110 -184 57 -163L47 -159L53 -147L58 -134Q61 -134 74 -139T110 -148T156 -153Q206 -153 243 -135T299 -87T326 -30T334 25'],

    // DIGIT SIX
    0x36: [700,13,502,45,471,'45 240Q45 328 73 406T143 536T235 626T327 681T399 699Q400 699 404 699T411 700Q424 700 441 696T459 689Q459 671 451 637Q451 633 447 632L444 629L434 633Q413 640 384 640H377Q299 640 222 565Q182 531 156 463T129 315V306H136L149 315Q229 376 316 376H318Q393 376 432 326T471 213Q471 129 402 58T237 -13T93 59T45 240ZM391 172Q391 231 354 272T258 314Q230 314 200 302T154 279T133 262L134 249Q154 32 266 32Q315 32 353 64T391 172'],

    // DIGIT SEVEN
    0x37: [468,181,502,37,498,'395 377L391 382H225Q59 382 59 383L74 423Q89 464 89 465Q90 468 94 468Q146 460 350 458H498V442L473 406Q241 75 125 -156L113 -181H40L37 -168L57 -140Q115 -58 199 70T339 287T395 377'],

    // DIGIT EIGHT
    0x38: [705,10,502,40,461,'220 -10Q168 -10 131 6T75 50T48 103T40 157Q40 223 77 266Q103 295 156 328T225 375Q247 393 247 394L206 361Q205 361 193 368T164 391T131 426T102 474T90 531Q90 580 114 615Q146 660 238 698L254 705L262 704Q288 704 332 693T402 656Q434 620 434 568Q434 518 401 475T321 402L305 391L336 368Q339 366 353 356T372 343T389 330T406 316T420 301T434 283T445 265T454 244T458 222T461 195Q461 106 389 48T220 -10ZM350 545Q350 578 337 601T304 634T266 649T234 653L224 654L204 639Q196 634 191 629T182 621T176 614T173 609T170 603T168 597Q165 585 165 567Q165 497 261 424L273 415Q350 467 350 545ZM261 405L263 407Q262 407 261 405ZM258 403Q257 403 255 401L254 399L256 400Q258 402 258 403ZM252 398Q251 398 249 396L248 394L250 395Q252 397 252 398ZM245 36Q276 36 300 45T338 69T360 102T371 136T374 168Q374 211 341 255Q324 275 305 289T235 332Q231 330 215 321T193 307T173 292T153 271T138 247T127 216T123 177Q123 146 132 117T170 62T245 36'],

    // DIGIT NINE
    0x39: [469,182,502,28,466,'353 93T352 93T320 79T251 49T201 34Q127 37 87 79Q28 138 28 234Q28 273 37 304T60 355T101 396T152 429T218 462L234 469H243Q348 461 395 417Q466 348 466 201Q466 72 397 -29T211 -163Q155 -179 91 -182H72V-154H80Q144 -154 202 -131T297 -60Q318 -31 333 7T352 68L357 92Q353 93 352 93ZM369 208Q369 240 362 272T339 339T290 394T214 415Q171 415 144 372T116 266Q116 193 154 144T238 95H249Q369 95 369 208'],

    // COLON
    0x3A: [457,12,216,50,168,'50 377T50 400T64 440T99 457Q128 457 146 440T165 399Q165 375 146 359T102 342T64 359ZM53 19T53 43T66 86T103 105Q129 105 148 87T168 41Q168 17 147 3T102 -12Q80 -12 67 3'],

    // SEMICOLON
    0x3B: [458,189,216,47,179,'47 399Q47 424 62 441T101 458T143 442T162 400T144 359T101 343Q78 343 63 360T47 399ZM76 86Q76 88 80 91T91 96T106 99Q119 99 131 86Q179 35 179 -25Q179 -64 146 -115T89 -189Q86 -187 83 -185T79 -182T76 -180T75 -177T77 -173T80 -168Q121 -108 121 -64Q121 -44 94 -5T66 52Q66 66 71 75T76 86'],

    // EQUALS SIGN
    0x3D: [368,-132,756,54,725,'725 366Q724 365 721 349T716 331V329H385Q54 329 54 331Q55 332 59 349T63 368H394Q725 368 725 366ZM725 169Q724 168 721 152T716 134V132H385Q54 132 54 134Q55 135 59 152T63 171H394Q725 171 725 169'],

    // QUESTION MARK
    0x3F: [693,11,362,46,357,'46 557Q46 613 103 653T227 693Q287 693 322 659T357 564Q357 517 326 469T259 390T191 326T160 272Q160 240 187 221Q193 217 193 216Q182 209 170 200L147 184Q127 192 113 209T98 250Q98 290 193 376Q287 454 287 542Q287 581 262 616T188 652Q143 652 126 631T108 588Q108 559 140 527L79 490Q46 515 46 557ZM108 47Q108 68 123 85T160 103Q179 103 198 90T217 46Q215 24 201 7T164 -11Q142 -11 125 6T108 47'],

    // LATIN CAPITAL LETTER A
    0x41: [696,26,718,22,707,'22 505Q22 563 94 624T271 685H280Q416 685 443 560Q447 535 447 504Q444 414 405 330L399 319L229 155Q233 154 241 153T253 150T265 145T281 135T301 119T328 93L357 64L402 92Q438 116 473 137L500 154V339Q500 528 495 593V601L559 649Q621 696 624 696L638 686L629 677Q599 650 593 638Q582 614 581 504Q580 490 580 443Q580 314 584 238Q584 235 584 224T584 210T585 199T586 187T588 176T591 164T595 152T601 137T609 121Q630 77 640 77Q661 77 703 101Q704 95 706 90L707 86V84L636 29Q618 15 601 2T574 -19T564 -25L500 121Q499 121 399 48L299 -26Q298 -26 291 -15T272 11T245 42T209 69T165 80Q120 80 58 43L48 37L40 42L32 48L122 117Q196 173 241 211Q319 280 343 327T368 447Q368 535 317 582Q264 633 199 633Q155 633 122 605T86 542Q86 518 133 467T181 387Q181 348 140 309Q113 281 73 260L64 255L50 265L59 273Q112 307 112 345Q112 363 90 387T45 441T22 505'],

    // LATIN CAPITAL LETTER B
    0x42: [691,27,884,48,820,'48 506Q48 568 120 629T268 691Q362 691 425 594L431 585L441 594Q478 628 528 657T629 686Q665 686 687 670Q703 658 718 584T753 506Q756 505 763 505Q778 505 804 512L815 516L820 496Q820 494 808 490T774 476T732 454Q720 445 708 437L675 415L640 394L625 383Q626 382 635 382Q652 382 670 379T712 364T754 336T784 289T797 220Q797 172 776 122Q769 106 766 102T745 84Q654 11 619 -8T538 -27Q483 -27 387 10T249 47Q218 47 186 34T133 8T112 -5T104 7T97 21L196 82Q259 120 284 140Q333 181 351 214Q368 251 368 353Q368 588 228 620Q222 621 205 621Q160 621 139 596Q117 569 117 548Q117 526 162 470T208 387Q208 352 179 320T104 264Q88 256 86 256Q83 256 70 266L82 274Q134 309 134 343Q134 352 130 359Q118 377 100 401T72 439T56 470T48 506ZM453 528Q457 496 457 419L458 357L488 367Q554 390 622 425Q673 449 673 453L671 454Q669 456 665 460T657 473T648 498T639 541Q629 597 616 613Q599 633 567 633Q534 633 493 599Q471 577 457 540L453 528ZM713 176Q713 252 661 295T528 339Q512 339 494 336T466 330T455 325Q454 325 452 311T444 270T425 217L420 207L304 118L319 116Q381 111 475 74T602 37Q655 37 684 79T713 176'],

    // LATIN CAPITAL LETTER C
    0x43: [685,24,613,59,607,'299 585Q333 609 384 634T470 672L505 685Q506 685 513 662T531 613T548 580Q553 576 563 576Q575 576 605 585Q607 585 607 575V564Q537 532 496 527Q475 542 456 567T427 610T415 627Q410 627 398 618T382 603Q373 588 373 558T386 475T400 399Q400 337 366 303Q343 281 309 266T254 247T226 242L214 257Q214 258 223 260T251 272T287 299Q304 316 304 360Q304 396 289 451T274 532Q274 553 277 561V564H269Q205 558 172 501T139 358Q139 207 226 127T443 46Q448 46 457 46T470 47L485 48L601 106Q602 106 602 93V80Q551 48 517 25T474 -4T460 -13T443 -19Q409 -24 367 -24Q360 -24 351 -24T335 -23T326 -22Q190 -2 125 87T59 319V328Q62 412 96 487L101 500L118 512Q189 563 245 591L266 601L299 585'],

    // LATIN CAPITAL LETTER D
    0x44: [685,27,832,27,745,'346 611Q300 611 261 604T194 584T144 555T107 519T82 481T65 443T55 410T50 383T48 367L37 372L27 378V393Q33 524 115 603Q160 648 230 666T365 685Q423 685 434 684Q745 653 745 405Q745 281 694 151L687 133L657 103Q524 -27 470 -27Q456 -27 331 18T157 64Q122 64 84 28Q67 9 57 -6L50 -16L43 -8L35 0Q35 3 46 22T83 74T141 133H154Q208 136 253 161T299 230Q299 259 277 290T232 348T209 392Q209 434 254 479T358 556L368 561L382 550Q382 549 381 548T377 545T371 541Q353 527 326 496T298 444Q298 430 343 365T389 277Q389 240 353 202T267 136L252 127Q304 118 400 83T513 47Q548 47 582 79T635 145Q671 208 671 323Q671 390 651 441T599 524T523 576T436 603T346 611'],

    // LATIN CAPITAL LETTER E
    0x45: [685,24,663,86,634,'301 564Q240 564 203 507T165 361Q165 280 190 218T260 119T358 64T474 46Q491 46 499 47L511 48L628 106V80L499 -5Q498 -6 497 -7T494 -10T490 -12T485 -15T478 -17T468 -19T456 -21T439 -22T418 -23T392 -24Q252 -20 169 67T86 315Q86 409 124 491Q128 500 139 508Q211 560 272 591L293 601L325 585L338 594Q374 617 422 639T502 674L532 685Q533 685 540 663T557 614T574 581Q580 575 591 575Q600 575 616 580T634 585V564L623 559Q572 535 532 529L522 527Q491 547 442 627Q442 628 440 627T435 624T428 620Q410 610 405 597T399 559V553Q399 534 409 487Q419 431 427 369L476 400Q526 431 526 432Q531 426 537 420Q565 382 602 359Q611 353 610 352Q609 351 575 332T537 312Q536 312 505 335T463 358Q451 358 439 352T425 337Q394 243 263 223L251 221L243 229L235 236L245 239Q274 247 303 266Q320 277 325 290T330 336Q330 394 315 451T300 531Q300 549 303 561Q303 564 301 564'],

    // LATIN CAPITAL LETTER F
    0x46: [686,153,611,11,612,'198 617Q177 617 159 609T128 587T106 557T91 524T82 494T76 472L75 463Q74 463 67 468T59 474Q59 488 63 510T80 564T114 622T170 667T253 686Q272 686 295 680Q330 672 384 645T468 598Q498 580 524 580Q549 580 595 626L612 643V616L599 599Q522 500 482 500Q466 500 435 514L420 521Q388 516 349 486T309 415Q309 396 323 366T352 315T367 294Q367 293 375 301T398 322T429 352L490 410Q537 355 542 332Q542 330 531 315T510 286L499 273Q479 313 449 313Q437 313 419 303T390 282L378 271L394 250Q444 183 470 129Q484 96 484 71Q484 -19 402 -86T223 -153H220Q175 -153 137 -120Q103 -89 103 -8Q103 12 106 40T109 96Q109 132 103 146T72 161Q46 161 16 143L14 154L11 165Q88 219 143 219Q163 219 177 197T192 127Q192 102 186 65T179 4Q179 -60 210 -88T272 -117Q319 -117 362 -75T405 33Q405 72 363 139T278 271T235 368Q235 385 243 404T264 439T292 472T324 500T353 522T374 538L382 543Q382 544 351 562T274 598T198 617'],

    // LATIN CAPITAL LETTER G
    0x47: [690,26,785,66,710,'373 560Q373 543 378 509T388 448T394 421Q396 421 416 433T474 474T548 537L538 543Q481 570 452 628L487 659Q521 690 522 690L526 684Q529 677 535 667T551 646T575 625T607 608Q617 606 621 606Q644 606 660 622L664 600L497 455Q495 453 527 453H546Q628 453 665 407L666 406Q710 357 710 297Q710 196 631 109L621 98L577 69Q471 -7 452 -15Q413 -26 370 -26Q239 -26 155 59Q66 148 66 319Q66 442 113 505L191 552Q269 600 270 600H271Q273 600 280 596T293 589T299 586Q300 586 357 623Q413 659 415 659L426 649Q373 604 373 560ZM219 228Q305 262 305 329V343Q305 384 294 434T282 519Q282 562 287 567Q287 569 286 569Q222 556 191 520Q144 464 144 362Q144 213 228 128T420 42Q514 42 568 103T622 255V260Q622 320 578 357Q526 400 453 400Q434 400 410 396L399 394L400 378V372Q400 330 388 301T348 254T305 232T252 217Q245 215 242 214L234 213L226 220L219 228'],

    // LATIN CAPITAL LETTER H
    0x48: [666,133,720,1,644,'11 -16L1 0Q7 6 25 27T57 62T91 88T128 101Q159 99 195 66L203 59L211 67Q239 95 239 133Q239 158 210 213T152 330T123 430Q123 477 173 536T269 630T320 666Q376 610 440 606H443Q457 606 466 611T519 647L542 664Q543 664 543 654V643L522 622Q434 537 403 537Q388 537 366 543T329 555T293 570T270 580L261 585L253 574Q206 517 206 475Q206 452 218 416T242 356L255 331Q256 331 270 345T324 391T421 459L437 468H453Q545 463 608 421L618 415L623 392Q644 307 644 233Q644 97 612 9Q604 -10 601 -15T581 -35Q505 -104 467 -124Q446 -133 431 -133Q414 -132 399 -126T376 -115T368 -107Q368 -106 392 -75L415 -43Q432 -67 444 -73T472 -79H474Q479 -79 484 -78T501 -69T521 -50T538 -13T551 46Q558 97 558 180Q558 232 557 245Q553 277 547 300T528 349T488 389T424 404Q344 404 276 295Q272 288 273 285Q300 216 300 168Q300 161 300 156T298 145T297 137T293 129T289 123T283 116T277 107Q212 23 178 -13L166 -26L149 -9Q108 32 81 32Q63 32 21 -7L11 -16'],

    // LATIN CAPITAL LETTER I
    0x49: [686,26,554,30,532,'190 601Q161 601 137 587T97 553T71 512T55 477T48 463Q44 465 39 468L30 473L35 488Q73 594 106 636T199 685Q200 686 211 686Q250 686 326 652T417 617Q435 617 455 626T497 652T522 670Q532 660 532 654Q469 591 390 550L378 543L343 556Q223 601 190 601ZM378 208Q378 249 369 318T360 424Q360 430 360 439T361 451L362 462Q416 526 482 571L495 580L503 577L511 575L499 562Q442 502 442 465Q442 436 452 368T462 246Q462 169 442 128T385 56Q292 -26 195 -26Q150 -26 104 14L96 21L43 -16Q43 -15 43 -14T41 -10T38 0L48 13Q76 50 123 97L150 125Q154 131 159 131Q166 131 171 116T182 81T193 53Q199 43 216 33T261 22Q307 22 344 68Q378 113 378 208'],

    // LATIN CAPITAL LETTER J
    0x4A: [686,139,552,-10,522,'194 601Q175 601 155 590T121 564T95 533T76 506L69 495Q55 503 55 507Q55 509 60 521Q87 586 132 636T222 686Q251 686 289 660T363 607T422 580Q442 580 466 588T506 604L522 612V591L487 574Q371 517 359 517H357Q332 522 280 561T194 601ZM383 39Q383 96 356 203T329 361Q329 364 329 370T330 378L331 388L339 399Q362 429 394 462T446 513T469 531Q470 531 477 527T484 521L474 509Q411 434 411 379Q411 341 434 223T458 82Q458 1 390 -69T239 -139Q191 -139 162 -123T123 -83T108 -30T101 23T88 64T52 80Q27 80 -4 64L-10 80Q-5 85 13 98T63 128T118 144Q149 144 163 129T179 93T182 38T187 -19Q199 -96 278 -96Q294 -96 309 -91T343 -73T372 -31T383 39'],

    // LATIN CAPITAL LETTER K
    0x4B: [680,27,668,17,682,'154 37Q219 41 219 142Q219 203 190 302T160 434Q160 445 172 472T209 534T269 602T354 657T460 680H472Q576 680 618 617V599Q618 578 615 555T608 517T602 501Q596 495 587 495Q586 495 586 499Q586 500 586 505T585 513Q567 628 415 628Q384 628 356 621T302 596T260 546T244 466Q244 416 258 377L261 367L276 382Q294 401 317 422T386 471T468 500Q500 500 518 477T544 422T554 386Q555 382 560 376T576 364T601 357Q612 357 623 361Q623 360 621 351T617 340L541 305L465 272Q469 271 476 270T488 266T502 260L512 255L519 242Q533 211 546 157T564 93Q584 53 617 53Q649 53 682 74V54L675 46Q646 17 612 -5T554 -27Q546 -27 538 -23T517 -9T494 28T478 91Q465 172 448 200T378 228Q337 228 289 207L288 196Q288 160 284 138Q283 125 262 98Q185 1 112 -24L102 -27L91 -25Q47 -13 17 31Q17 33 49 69L80 106Q111 37 154 37ZM421 434Q411 436 405 436Q370 436 336 407T275 337L267 325L271 313Q288 257 288 234Q289 234 395 276T502 319Q501 320 499 323T493 330T485 345T475 371Q473 378 468 388T449 416T421 434'],

    // LATIN CAPITAL LETTER L
    0x4C: [686,26,666,33,644,'251 231Q251 254 206 341T160 468Q160 529 238 605Q313 677 425 685L432 686Q440 686 445 686Q520 686 545 657T571 576Q571 548 568 517T564 480Q564 466 572 460T608 452H623V431L619 430Q618 430 611 428T591 423T566 417L516 404Q497 415 491 419T480 433T475 461Q475 470 477 498T480 546Q480 561 480 569T474 592T459 615T429 631T379 638Q322 638 283 606T239 526Q237 480 280 394Q319 310 320 268V250Q308 235 244 169L203 128H210Q215 128 256 112T357 80T466 64Q526 64 564 88T625 186L629 196Q643 187 644 186Q618 70 604 41Q577 -15 513 -24Q496 -26 476 -26Q418 -26 344 -3T211 45T133 69Q115 69 97 50T65 7T49 -20L45 -16Q41 -11 37 -6T33 0Q33 8 66 69T111 134Q251 156 251 231'],

    // LATIN CAPITAL LETTER M
    0x4D: [692,27,1050,27,1048,'687 578Q690 586 719 612T794 665T877 692Q909 692 926 670T953 614T973 570Q983 561 1000 560Q1023 560 1048 569V553L1034 546Q1003 528 972 504T933 466Q905 403 905 264Q905 205 909 172T920 126T940 91Q951 74 959 74T997 87L1027 100V79L956 27Q940 15 922 2T894 -19L885 -26Q883 -26 854 27L825 80V192Q826 314 830 341Q831 345 833 356Q840 398 844 404Q871 444 920 489L917 491Q914 493 911 495T903 501T898 508Q893 516 877 562T852 616Q840 628 818 628Q751 628 702 541L697 532L700 515Q708 467 708 419Q706 348 690 276T662 169T643 126L634 116Q626 105 611 87T581 51L522 -22L514 -15Q470 21 452 21Q431 21 394 -16L384 5L386 9L426 60Q449 87 460 95T486 104Q487 104 491 104T497 103Q514 99 541 81L559 69Q595 96 606 169T618 350Q618 486 598 543T517 601Q484 601 458 570T432 523Q432 516 434 492T436 443Q436 250 369 133L363 122L280 50Q207 -16 192 -27L182 -18Q136 26 106 26Q83 26 62 9T37 -16L27 0L33 10Q41 22 54 39T94 81T143 106Q178 106 225 62L235 53Q283 82 307 117Q352 190 352 359Q352 408 345 451T320 534T267 597T183 621Q159 621 147 617T120 598Q97 574 96 556Q96 528 143 469T191 377T161 311T102 262T70 245Q69 245 59 252T49 260L56 264Q63 268 73 275T94 291T111 312T118 338Q118 355 95 384T50 446T27 506Q31 567 101 626T255 686Q297 686 330 671T382 632T409 595T421 572V571L430 580Q454 610 496 634T588 659H590Q655 659 683 585L687 578'],

    // LATIN CAPITAL LETTER N
    0x4E: [686,25,832,27,825,'112 334Q112 356 70 410T27 497Q27 553 94 619T229 685Q230 685 236 685T246 686Q303 686 349 654Q373 636 392 607T419 558L426 538L454 576Q474 604 486 618T520 651T569 678T633 686Q668 684 687 673T713 651T730 609Q730 608 732 600T736 588T741 578T747 568T754 561T765 555T779 553Q789 553 817 562Q819 557 819 555V547L790 526Q743 492 730 479T712 447Q697 369 697 281Q697 166 726 108Q741 76 755 68Q759 66 767 66Q789 66 825 93V82Q825 71 822 70Q821 69 763 27T701 -18L692 -25L668 15Q662 25 650 45T635 70L627 85V107Q627 122 626 162T624 285Q624 381 632 398Q638 409 651 425T675 454T696 477T707 489H696Q683 490 679 492T669 507T653 551Q642 588 627 608T584 628Q572 628 560 625T538 616T519 602T502 586T486 568T473 549T463 532T454 517T448 504L445 497Q437 480 437 474Q437 472 439 461T444 421T446 348Q446 205 405 124Q396 105 392 100T368 78Q312 32 278 9T235 -18T214 -22Q191 -22 170 -10T139 12T129 25T160 66T192 105Q193 102 194 98T200 83T213 64T233 49T261 42Q303 42 339 90Q373 134 373 268Q373 397 339 493T235 618Q215 628 191 628Q155 628 126 604T97 548Q97 524 120 493T168 431T192 381Q192 346 164 318T86 260L70 250L54 266L63 272Q112 300 112 334'],

    // LATIN CAPITAL LETTER O
    0x4F: [729,27,827,12,744,'428 596Q412 596 386 595T350 593Q289 593 270 625Q267 632 267 640Q267 656 280 672T312 705T336 729H343Q351 729 351 728Q342 710 342 703Q342 683 382 676T493 662T604 643Q648 627 677 599T720 535T739 466T744 392Q744 317 732 260T696 166T659 116T621 83Q617 80 615 78Q485 -27 377 -27Q320 -25 272 -9T187 21T122 36H116Q65 36 29 -13L27 -15L12 0Q12 1 32 26T76 78T109 109Q145 123 166 150T187 207Q187 244 134 318T80 412Q80 454 112 498T176 566T213 590Q216 590 224 585L234 580L225 573Q216 566 207 557T188 536T172 511T165 484Q165 448 213 368T261 259Q261 241 252 219T228 179T200 146T176 122L167 112Q170 111 174 111Q188 110 233 91T339 55T453 37Q508 37 556 68T626 152Q655 219 655 328Q655 543 532 582Q484 596 428 596'],

    // LATIN CAPITAL LETTER P
    0x50: [692,218,828,28,804,'112 339Q112 354 91 380T49 438T28 497Q28 565 95 628T242 692Q261 692 277 689T307 682T331 670T351 655T367 637T379 619T388 600T395 582T401 565T405 550Q409 554 422 570T453 603T500 641Q573 692 637 692Q656 692 670 686T692 672T705 647T713 618T718 584Q720 568 721 562T728 546T742 534T768 530Q776 531 782 532T791 535T796 536Q799 536 804 521Q801 519 789 513T764 499T738 480Q697 447 680 414Q677 407 677 396Q677 370 713 312T750 210Q750 125 686 57T560 -11Q540 -11 475 13L410 37V31Q410 -9 412 -50T417 -118T420 -150Q419 -150 373 -184T326 -218L305 -208Q305 -207 307 -196T314 -165T322 -116T328 -46T331 43V63L318 66Q270 80 250 80Q233 80 213 70Q183 57 138 -3L128 -16L118 5L125 20Q193 154 282 154Q309 154 331 146V287Q331 444 327 469Q321 522 301 560Q284 590 251 611T184 633Q146 633 119 607T92 550Q92 539 94 534Q100 516 143 460T186 386Q186 366 170 336T119 281Q102 264 70 250L49 260L56 266Q64 271 72 278T90 296T106 317T112 339ZM602 345Q602 357 608 371T622 397T642 421T661 441T678 456L686 462Q663 473 652 486T639 512T634 553Q631 594 624 608T593 631Q587 632 567 632Q539 632 497 600T416 497L410 484V122L467 103Q481 99 502 92T533 82T557 75T578 69T594 66T610 64Q647 64 672 87T697 144Q697 180 650 250T602 345'],

    // LATIN CAPITAL LETTER Q
    0x51: [729,69,827,11,782,'428 596Q412 596 386 595T350 593Q313 593 291 605T268 638Q268 644 269 648T274 658T284 669T301 689T326 718L336 729H343Q351 729 351 728Q342 710 342 703Q342 683 382 676T493 662T604 643Q744 592 744 398Q744 299 708 213T646 104L603 68L614 55Q670 -5 710 -5Q726 -5 744 1T772 14L781 20Q782 20 782 7V-6L771 -13Q673 -69 665 -69L647 -63Q552 -30 514 8H512Q509 8 500 3T471 -9T428 -23Q405 -27 377 -27Q305 -24 228 6T124 36Q69 36 27 -16Q23 -13 19 -8L11 0L27 20Q93 102 109 109Q145 123 166 150T187 207Q187 244 134 318T80 412Q80 454 112 498T176 566T213 590Q216 590 224 585L234 580L225 573Q216 566 207 557T188 536T172 511T165 484Q165 448 213 368T261 259Q261 241 252 219T228 179T200 146T176 122L167 112Q170 111 174 111Q188 110 233 91T339 55T453 37Q508 37 556 68T626 152Q655 219 655 328Q655 543 532 582Q484 596 428 596'],

    // LATIN CAPITAL LETTER R
    0x52: [686,26,828,27,824,'27 496Q31 569 102 627T234 685Q236 685 241 685T251 686Q287 686 318 672T367 638T399 598T418 564L423 550Q424 554 434 567T463 601T505 639T561 671T626 685Q672 685 688 659T710 572Q713 533 721 523T766 513Q781 513 787 514T794 516Q796 512 798 509T801 504T802 501T787 493Q702 461 624 401L607 389Q655 383 688 358L697 352V342Q699 330 699 297Q704 209 710 173T734 103Q751 69 765 69Q769 69 806 83L824 90V74Q823 73 759 24T693 -26Q692 -26 660 32L628 90L629 111Q631 159 631 177Q631 278 614 300Q584 340 523 340Q500 340 467 333T431 325Q429 325 429 322Q428 321 426 308T420 275T410 230T392 178T366 125L358 112L342 99Q306 70 269 38T213 -10T193 -26Q192 -26 163 0T116 26Q82 26 50 -8L42 -16L35 -8L27 0L35 10Q43 21 58 38T104 80T158 106Q179 106 218 65L235 48Q238 48 255 60T295 99T329 158Q352 231 352 359Q352 555 242 614Q210 628 187 628Q140 628 116 600T91 548Q91 522 138 464T185 382V376Q185 345 158 313T103 263L76 246Q74 244 64 253L54 260L65 267Q91 285 100 302Q111 318 111 337Q111 355 69 410T27 496ZM562 628Q504 628 443 507L435 491L436 479Q437 471 437 446Q437 396 432 351L529 389L602 426Q673 462 673 463H672Q644 470 637 483T622 553Q608 628 562 628'],

    // LATIN CAPITAL LETTER S
    0x53: [692,27,829,66,756,'750 276Q750 141 645 57T378 -27Q224 -27 146 67Q66 163 66 307Q66 361 80 412T127 515T217 609T356 676L388 684L420 692L442 681Q545 625 586 608T654 591Q688 591 710 609T737 646L742 665Q742 665 756 654L752 642Q736 594 706 566T621 515L607 510Q580 513 528 542T421 599T335 627Q272 627 214 569Q139 500 139 373Q139 308 159 247T217 136T316 56T455 26Q520 26 566 43T634 90T666 148T676 207Q676 264 649 297T580 338Q574 339 552 339Q516 339 442 325T327 310H324Q303 310 290 312T259 328T232 369Q230 375 230 390Q230 426 259 461Q286 488 338 507Q351 498 351 495L346 492Q342 490 339 488T330 482T320 473T312 462T305 447T303 428Q303 368 366 368Q393 368 487 388T613 409Q656 409 696 385T748 306Q750 294 750 276'],

    // LATIN CAPITAL LETTER T
    0x54: [701,27,669,34,676,'289 686Q338 686 439 668T565 649Q606 649 641 672Q656 683 664 690T674 700L675 701Q676 698 676 692V681L641 636Q608 591 602 588Q577 575 528 575Q490 575 438 583L426 585L416 578Q335 520 335 465Q335 437 393 366T452 259Q452 226 406 171Q387 146 351 115L341 106L358 97Q438 58 475 58Q525 58 598 124L608 133Q617 119 617 118Q617 114 606 103Q513 0 448 -27L438 -25Q401 -19 337 14T234 48Q186 48 122 -3L112 -11L106 -3L101 5L110 15Q160 63 209 105L224 117H310Q384 163 384 210Q384 238 329 303T263 398Q262 400 262 404Q262 427 290 476T368 580Q383 596 381 596Q315 622 228 622Q159 622 118 593T76 516Q76 482 96 461T139 431L107 399L75 367Q34 403 34 472Q34 525 64 572T148 652Q207 686 289 686'],

    // LATIN CAPITAL LETTER U
    0x55: [697,27,646,-25,665,'160 247Q160 291 110 382T59 505Q59 542 106 597T207 690L218 697L229 682Q229 680 216 669T187 644T158 604T144 552Q144 526 165 482T207 387T228 291Q228 277 228 267T224 247T219 232T210 217T199 202T184 184T166 163L118 107Q124 105 132 105T160 98T220 77Q298 47 317 47Q354 47 409 105Q444 142 451 161T458 244V277Q458 339 455 457T447 596L575 686L591 676L583 668Q550 632 541 587T532 449V372V298Q532 198 550 147Q572 79 605 79Q617 79 631 84T656 95L665 100V79L595 27Q578 15 560 2T532 -19L523 -26Q522 -26 490 42L458 111L397 50Q389 42 374 27T355 8T340 -5T325 -16T311 -22T294 -26T274 -27Q232 -25 152 6T35 37Q28 36 19 30T4 18T-8 4T-16 -5Q-25 10 -25 11T-20 18Q-5 34 15 57L54 101Q70 103 86 116Q94 121 113 140T137 166Q160 201 160 247'],

    // LATIN CAPITAL LETTER V
    0x56: [687,26,831,26,825,'54 266Q118 307 118 339Q118 360 74 413T27 493Q26 530 59 578T133 651Q187 686 256 686Q299 686 332 673T382 640T409 600T424 567T429 553Q431 553 463 586T542 653T624 686Q663 686 715 652T798 617Q812 617 825 622V606L815 599Q785 576 762 546Q724 495 724 432Q724 397 737 317T750 217Q750 148 711 96Q697 75 639 34T578 -10Q563 -21 555 -23T522 -26Q458 -26 363 29Q253 89 211 89Q192 89 173 83T139 67T114 49T96 34L90 27L80 43L95 59Q121 87 148 110T191 143T213 154Q261 154 300 195Q328 222 340 267T352 406Q352 562 255 611Q222 627 187 627H182Q143 627 115 598Q96 579 96 559Q96 528 144 470T192 381Q192 348 156 314T80 256L70 250L54 266ZM727 548Q701 550 650 583T567 617Q560 617 554 615Q532 610 501 580T445 501L437 485V465Q432 326 378 223L294 150Q321 143 421 87T560 31Q608 31 634 64Q660 102 660 198Q660 226 655 292T650 387Q650 418 658 452L660 462L735 548H727ZM264 150Q265 151 263 151H261Q261 150 264 150ZM280 150H276V149Q280 149 280 150'],

    // LATIN CAPITAL LETTER W
    0x57: [686,27,1046,32,1054,'32 501Q35 564 103 625T264 686Q326 686 365 652Q402 618 420 564L441 585Q486 630 539 670L559 686L572 672Q637 606 665 559L682 576Q787 686 845 686Q877 686 929 656T992 623Q999 621 1016 621Q1041 621 1054 628L1051 617L1047 606Q1042 602 1037 597Q983 557 969 522T954 434Q954 394 961 336T968 221Q968 201 966 184T963 155T956 131T948 113T936 96T923 82T906 66T887 50L816 -2Q815 -3 810 -6T801 -11T791 -16T777 -20T759 -23T735 -25Q691 -25 619 4T505 37H496L463 21Q420 0 389 -20L378 -27H362Q316 -27 275 -9T202 28T150 46H146Q114 46 59 -5L48 -16L41 -6Q40 -4 38 -2T34 2L33 4Q33 8 77 54Q111 87 142 112L154 122H166Q239 127 288 182Q346 244 346 406Q346 489 326 537T259 610Q227 628 195 628Q155 628 128 606T101 549Q101 517 146 465T192 382Q192 348 156 310T85 254L75 250L64 258L55 266Q56 267 74 276T105 301T118 339Q118 362 75 413T32 501ZM952 547Q927 555 877 586T796 617Q744 617 682 525L676 516L677 498Q678 486 678 425Q678 301 652 206Q649 195 613 151T577 102Q577 100 582 100Q618 100 720 51Q761 32 790 32H794Q843 32 869 83Q884 110 884 189Q884 233 879 294T873 400Q874 433 879 451T889 478T915 507T952 547ZM241 105Q249 98 263 88T317 60T393 42Q478 42 547 109Q607 171 607 358Q607 371 607 380T604 417T595 467T577 517T546 566T500 601L479 580Q449 550 433 526L426 516V503Q426 311 357 200L352 191L296 149Q241 107 241 105'],

    // LATIN CAPITAL LETTER X
    0x58: [688,27,719,28,709,'96 511L78 527L149 603Q207 666 227 686L237 685Q278 680 306 667T351 631T376 588T395 533L400 516L406 527Q439 600 523 653Q538 664 587 688Q589 688 596 672T613 635T629 606Q643 588 665 588Q677 588 693 596L709 603V585L607 526Q583 536 554 564T512 614Q461 571 435 507T405 381V367H581L563 347Q561 344 558 341T553 335T549 330T546 326L545 325H541Q537 325 488 329T411 334H405V325Q405 198 454 123Q497 54 568 54Q594 54 619 64T660 84L676 95V74L565 -16L553 -20Q528 -27 512 -27Q492 -27 475 -21T444 -5T418 19T398 47T382 77T371 105T363 128T358 145L357 151Q354 151 339 136T294 91T232 37Q152 -22 113 -22Q90 -22 69 -9T38 17T28 32Q28 33 58 68L86 101Q94 81 115 64T165 47Q206 47 249 84Q302 128 325 222Q334 263 336 312V334H312Q198 334 163 324H161Q162 326 182 348L198 367H336V398Q333 508 308 550Q295 570 274 585T227 601Q204 601 181 589T145 565T115 533T96 511'],

    // LATIN CAPITAL LETTER Y
    0x59: [686,218,833,27,740,'123 345Q123 358 75 415T27 496Q27 533 63 578T121 639Q181 685 256 685Q305 685 332 676T384 635Q419 588 425 542Q468 585 526 628T618 686Q632 667 658 645T704 609T724 594Q740 512 740 385V375V361Q740 128 682 -3Q656 -64 554 -141T361 -218Q319 -218 287 -203T243 -173T230 -150Q230 -148 267 -109L304 -69Q311 -115 341 -142T411 -170Q474 -170 534 -119T624 11Q660 111 660 312Q660 447 633 528L612 549Q578 583 552 596L543 601L528 592Q501 574 483 558Q454 528 436 494L431 484V473Q431 330 376 230Q366 213 359 206T306 159L250 112Q278 105 327 82T399 58Q421 58 440 69T471 92T484 104H485L493 90L480 73Q453 39 429 13Q393 -22 372 -22Q342 -22 260 15T153 53Q97 53 48 -16L38 5Q46 22 74 54T128 108L143 122H155Q226 127 275 168Q352 236 352 399Q352 501 309 564T197 628Q156 628 129 607T102 553Q102 517 147 463T192 383Q192 323 75 250L59 266Q123 314 123 345'],

    // LATIN CAPITAL LETTER Z
    0x5A: [729,139,602,11,532,'148 590Q95 592 91 627V633L160 729H176Q169 713 169 705Q169 670 244 670Q269 670 305 672T357 675Q405 675 432 661T468 609Q469 605 469 596Q469 572 460 540Q433 463 301 372Q325 378 359 378Q431 378 472 350T519 297Q532 249 532 198Q532 115 500 40T442 -57Q335 -139 202 -139Q165 -139 125 -131L112 -129V-100Q112 -49 106 -33T75 -17Q55 -17 31 -35L22 -42L11 -26L22 -18Q94 36 151 36H160Q171 36 178 33T188 27T194 13T196 -5T197 -32Q198 -79 206 -90Q217 -107 251 -107Q336 -107 389 -33T442 155Q442 240 407 274Q362 319 285 319Q236 319 192 298Q188 298 181 309L224 372Q227 373 234 374T246 376T257 379T271 384T285 391T302 402T321 417Q384 471 384 540Q384 562 366 581T306 600Q292 600 233 595T148 590'],

    // LEFT SQUARE BRACKET
    0x5B: [740,130,278,117,278,'262 -119Q224 -120 191 -123T141 -128T118 -130Q117 -130 117 305V740H122Q141 737 219 736H278V723Q278 711 277 711L159 699V-93H162Q167 -93 220 -96T276 -100Q278 -100 278 -109V-119H262'],

    // RIGHT SQUARE BRACKET
    0x5D: [739,131,278,-4,160,'64 733Q89 733 110 734T143 737T158 738H160V-131H154Q101 -125 40 -124H-4V-103H1Q3 -102 57 -98T113 -92H118V700L64 703Q7 707 3 708H-4V732H21Q34 733 64 733'],

    // CIRCUMFLEX ACCENT
    0x5E: [734,-452,500,0,495,'0 464L250 734L262 722Q274 712 384 598L495 486Q483 478 467 467L456 459L248 672L154 580L23 452Q17 454 10 458T0 464'],

    // LATIN SMALL LETTER A
    0x61: [470,35,500,66,497,'86 363Q86 365 128 391T212 444L255 470Q256 470 263 465T283 453T308 442Q338 431 346 431Q350 431 358 436L414 465L421 459L418 434Q404 339 404 262Q404 147 408 119L425 97Q443 74 444 74L467 86L491 97Q492 97 497 83L436 28Q377 -26 374 -26L331 46L329 91L155 -35Q152 -35 114 10T68 65L67 86Q66 100 66 156Q66 177 66 198T68 236T71 268T74 296T77 320T80 338T83 351T86 360V363ZM314 365Q285 367 255 374T206 386L187 392Q181 392 172 376T154 311T145 197Q145 124 151 118Q156 110 187 78L208 56H214Q221 57 253 76L308 109L329 123V136Q328 143 328 257V365H314'],

    // LATIN SMALL LETTER B
    0x62: [685,31,513,87,442,'177 427Q177 364 181 364Q184 364 192 370T223 395T271 433Q317 469 323 469Q325 469 338 462T377 440T432 413L440 409L441 396Q441 394 441 372T442 334Q442 203 425 108L423 97L400 83Q347 49 296 21T222 -19T196 -31Q192 -29 149 12T87 71L89 89Q100 155 100 319Q100 500 94 627Q94 632 94 638T94 648T94 656T93 662V664Q93 668 97 669T106 670H110Q114 653 118 633L127 596Q127 595 132 597Q136 599 195 642L255 685L272 673Q269 670 256 659T233 637T211 609T190 565T179 508Q177 494 177 427ZM295 377L274 385Q273 385 264 381T242 370T223 361Q213 355 188 340L178 333V123L198 103Q259 42 285 42Q299 42 314 55T339 85Q363 132 363 232Q363 310 358 343V349L345 355Q330 363 295 377'],

    // LATIN SMALL LETTER C
    0x63: [466,29,389,72,358,'72 208Q72 323 84 361Q84 363 167 414Q248 466 250 466Q255 465 260 465Q283 460 307 450T344 430L357 422L306 343L301 342L296 340Q267 362 247 372T216 384T177 390Q154 349 154 238Q154 220 156 158V145L168 132Q179 121 208 93T244 59Q245 58 246 58Q255 58 302 83T350 108L352 104Q355 100 356 96L358 92Q358 91 274 32T187 -29L177 -20Q160 -6 120 36T77 84Q77 87 75 118T72 208'],

    // LATIN SMALL LETTER D
    0x64: [609,33,499,13,428,'13 542Q13 544 77 576T147 609Q154 609 185 598T283 551T414 464L427 454V440Q427 436 427 412T428 372Q428 315 426 270T418 197T409 152T400 121T394 103L304 35Q285 21 261 2T225 -25L214 -33Q149 7 97 59L76 80L75 91V171Q75 221 76 254T79 299T80 313Q80 315 78 321Q78 323 78 326L77 330Q79 336 132 384T211 447L219 445Q221 445 224 444L228 443Q229 443 228 441T221 432T206 415L191 395Q175 378 162 339Q152 306 152 250Q152 217 159 140V134L171 121Q194 99 235 74T284 48Q296 48 310 75T337 156T349 267Q349 346 336 400L315 420Q246 489 176 525Q127 545 94 545H73L27 527L13 542'],

    // LATIN SMALL LETTER E
    0x65: [467,30,401,70,364,'353 103Q353 97 358 87L337 71Q293 38 247 6Q191 -30 189 -30Q188 -30 173 -16T130 26T76 85L74 99Q70 139 70 190Q70 228 73 271T79 338T84 365L94 372Q105 378 126 392T166 417L246 467Q283 417 349 369L364 358L355 349Q249 249 169 180L151 166L152 152V139L165 126Q186 105 215 84T260 62Q267 62 309 82L353 103ZM267 323Q246 337 230 350T204 371T189 385T179 394T174 397Q149 381 149 219V211Q151 211 171 223T220 258T268 299L282 313L267 323'],

    // LATIN SMALL LETTER F
    0x66: [681,221,326,30,323,'128 387Q128 391 112 456T92 546V555L101 568Q133 617 183 670L193 681L204 673Q238 648 262 648Q276 648 292 656L302 661L308 653Q308 652 278 618L249 585H234Q194 587 159 595Q158 595 156 596H153L150 597Q151 593 152 581T154 564T157 547T164 524T176 494Q199 436 203 400V392H207L323 386Q323 384 309 368L296 351H203V176Q201 -9 198 -32Q194 -61 166 -114Q158 -129 153 -138Q114 -214 110 -221Q105 -221 98 -220L87 -219V-216Q88 -215 106 -150T124 -82Q128 -73 129 155V351H30L64 386H96Q128 386 128 387'],

    // LATIN SMALL LETTER G
    0x67: [470,209,504,17,455,'27 -144L17 -131L82 -75L146 -20L126 6Q99 37 92 48L78 65L77 79Q75 103 75 158Q75 217 78 268T86 343T91 368Q92 370 109 382T157 413T222 452Q240 465 249 469L251 470Q296 443 350 428L365 424L437 465L442 459Q442 456 441 453T437 444T432 424T427 385T423 317T421 215V133L423 119Q423 111 455 -17Q455 -21 380 -108T290 -201Q290 -202 284 -204T269 -207T252 -209Q172 -209 75 -135L62 -126Q60 -126 44 -135L27 -144ZM349 351Q267 359 178 389Q177 387 173 376T166 358T161 337T157 303T155 259Q155 195 159 135L160 124L170 112Q180 101 204 77T230 53Q231 53 286 88L340 123V141Q340 235 348 329Q348 334 348 339T348 348L349 351ZM364 -59Q364 -37 358 -1T347 64T341 93Q336 93 252 28T149 -57Q226 -134 293 -134Q325 -134 344 -118T364 -69V-59'],

    // LATIN SMALL LETTER H
    0x68: [688,205,521,77,434,'88 427Q88 486 87 545T84 634T81 667Q81 673 82 673T89 676H94L117 600L200 661Q208 667 218 674T233 684L238 688L254 678Q222 646 216 637Q164 572 164 483V442V371Q187 390 244 431T312 478Q344 446 411 423L428 417L429 396Q434 297 434 218Q430 8 406 -34Q346 -111 262 -195L251 -205L249 -203Q248 -203 244 -199T236 -193Q226 -183 227 -182Q228 -182 244 -169T278 -140T301 -121Q330 -89 340 -22Q355 60 355 171Q355 200 353 244T348 321T344 354Q333 363 307 376T260 390Q241 390 179 350L164 341V121Q180 96 201 66L213 50Q210 46 172 11T131 -24Q130 -24 123 -11T102 25T77 65V78Q80 104 84 227T88 427'],

    // LATIN SMALL LETTER I
    0x69: [673,20,279,14,267,'72 617Q72 618 102 645T133 673H134Q134 668 175 627L187 615L130 555L116 568Q72 615 72 617ZM27 369Q21 376 14 382L26 392Q83 440 119 474Q158 435 169 427L179 420L176 395Q166 302 166 227Q166 171 174 139Q178 119 186 103T202 81L208 75Q255 100 261 100Q262 100 264 92T267 83Q267 80 208 30T145 -20Q143 -20 118 17L91 55Q98 117 98 193Q98 339 88 369Q71 390 68 390Q63 390 39 376L27 369'],

    // LATIN SMALL LETTER J
    0x6A: [672,208,281,-9,196,'101 644L132 672L145 657Q155 642 169 628L182 614L169 600Q148 579 140 570L125 555L112 568Q109 570 91 592T72 615Q72 617 101 644ZM19 -208Q-9 -185 -9 -183Q57 -134 80 -106Q103 -81 110 -19T118 179Q118 294 113 329T86 383Q78 389 76 389Q73 389 57 379L39 367Q26 380 26 381L33 387Q40 393 53 405T79 428L130 474Q147 457 186 428L195 422L196 376Q196 130 192 58T174 -35Q172 -39 104 -114T19 -208'],

    // LATIN SMALL LETTER K
    0x6B: [689,25,389,24,362,'93 348Q93 379 90 503T87 658V670Q87 671 94 671L100 672L112 636Q124 603 124 600L144 616Q196 659 234 682L246 689Q252 686 256 685T268 680L254 667Q225 641 211 626T184 579T168 505V497L178 504Q203 523 237 544L300 584L310 573Q359 522 359 481Q359 476 359 472T358 464T355 456T351 448T346 440T340 433T332 424T323 414T312 402T299 389L255 343L300 342H346L320 309H177V128L193 113Q214 92 244 68L254 60L303 84Q351 108 352 108L362 96Q355 85 277 30T194 -25L170 -4Q146 18 120 41T89 68Q94 85 94 168Q94 184 94 218T93 268V309H58L24 310L51 342H93V348ZM172 342Q217 342 252 374T287 445Q287 472 255 504Q242 517 241 517Q202 498 187 468T168 365V342H172'],

    // LATIN SMALL LETTER L
    0x6C: [685,20,280,98,277,'221 76L267 99Q268 98 269 96T271 88T270 82L262 76Q255 69 241 57T214 34L148 -20L98 56L99 89Q107 247 107 373Q107 494 101 621Q101 653 99 659V665L106 668L113 672L118 655Q122 642 131 617L138 597Q140 597 157 611L240 670L264 685Q265 685 270 680T276 674T269 667T247 647T219 617Q197 587 186 551T173 493T171 438Q171 376 175 282T179 147V117Q184 109 201 93T221 76'],

    // LATIN SMALL LETTER M
    0x6D: [475,26,767,8,753,'20 367L8 379Q9 380 63 425T118 471Q130 460 143 446L168 421V398L169 376L295 475Q362 433 415 418V399Q415 380 416 380T437 394T484 428T529 462L544 474L556 467Q590 449 614 438T646 424L653 421L665 417L664 412Q664 411 664 407T664 397T663 384Q660 342 660 335Q658 303 658 245Q658 186 660 152L661 126L669 115Q680 96 697 79L707 83Q716 87 723 90T735 96T741 100T746 102L747 103V102L750 95Q753 88 753 87L631 -18Q630 -17 622 -3T589 43L576 60L579 72Q592 146 592 218Q592 265 584 321Q581 345 578 350T560 363Q535 376 496 386L481 390Q475 387 425 358L415 351V238V157Q415 142 415 135T417 120T421 110T430 98T441 81L465 47Q462 44 458 41T443 28T420 8L380 -26L333 47L336 62Q339 77 342 109T345 184Q345 223 341 285T333 348Q322 364 258 382L240 388L169 347L168 240Q168 118 171 110L174 106Q178 101 183 93T195 78L217 48Q217 47 196 30T154 -5T133 -21L130 -16Q127 -10 122 0T111 19Q89 56 89 60Q95 76 95 153Q95 239 88 337V365L62 391L20 367'],

    // LATIN SMALL LETTER N
    0x6E: [475,22,527,20,514,'31 368Q20 379 20 380T72 427L121 470L129 463Q137 455 155 441T176 425V367L320 475L329 469Q351 454 385 437T434 417L432 402Q429 362 429 231V128L439 111Q442 107 445 102T449 95T453 90T456 86T459 84T463 82T467 82Q468 82 489 93T511 105T514 95V88L395 -18L340 65L341 77Q347 111 348 178Q348 343 343 353V358L332 363Q298 377 264 382Q260 382 254 382L249 383Q247 383 211 362L176 341V229V147Q176 134 176 127T177 115T179 106T183 99T189 91T197 81Q201 76 206 69T214 57L217 53Q217 52 175 15T132 -22Q132 -20 114 5T88 41Q84 45 84 50Q94 116 94 203Q94 227 93 263T92 324L90 364L67 388L50 378Q32 368 31 368'],

    // LATIN SMALL LETTER O
    0x6F: [480,28,489,67,412,'67 121Q70 265 84 359V364L97 371Q137 394 177 421T238 464T260 480L278 468Q295 457 327 442T394 418L406 414Q412 388 412 300Q412 263 410 228T405 170T399 130T393 103T391 92L381 86Q274 19 165 -28L161 -24Q157 -21 151 -15T136 -2T118 14T101 30T86 46T74 60L67 68V121ZM335 278Q335 286 335 303T334 335L333 349V356H326Q288 360 208 388L183 397Q178 393 172 383T154 333T142 239Q142 192 151 134Q152 124 155 120T175 99Q197 77 219 64T251 47T267 44T281 52T302 80T320 124Q335 182 335 278'],

    // LATIN SMALL LETTER P
    0x70: [541,212,500,12,430,'23 25Q15 33 12 38L35 59Q82 102 87 105V351L68 378Q42 414 42 422Q42 437 67 472T114 530L125 541Q126 541 132 537T138 532Q121 507 121 488Q121 453 160 413L167 405L166 390L165 372Q169 372 233 421T305 478Q307 479 315 472Q395 421 423 415Q424 415 424 415T425 414L426 410Q426 407 426 401T426 388Q430 335 430 272Q430 139 408 80Q407 78 340 22L273 -33Q200 23 165 23Q164 23 164 -32Q165 -89 168 -155V-170L93 -212L78 -203Q85 -48 87 16V47H79Q53 44 23 25ZM319 41Q346 94 349 212Q349 278 343 343V351L330 357Q318 363 270 381L255 387L245 383Q212 370 178 345L166 336V287Q165 260 165 166V94H175Q219 90 299 51L319 41ZM132 57L129 60Q130 58 132 57ZM158 29Q159 29 155 34T145 45T138 50Q155 29 158 29'],

    // LATIN SMALL LETTER Q
    0x71: [479,219,489,60,419,'399 19Q399 -123 407 -174V-179L332 -219L322 -210L312 -202L314 -185Q320 -83 323 54V95L311 85Q255 40 162 -19Q146 -29 145 -27Q140 -22 103 20L63 65V73Q61 83 61 115Q61 122 61 135T60 154Q60 263 79 353L83 368L94 375Q123 391 147 405T186 429T212 446T229 458T238 466T243 470T247 471L260 464Q274 457 295 448T330 434L341 432L410 479L412 478Q414 476 416 475T419 473L417 461Q399 358 399 19ZM316 367Q287 370 252 377T196 391L176 397H175Q173 397 166 382T149 314T139 187V158Q139 138 141 132T155 114Q158 111 160 109Q210 58 211 58L218 62Q226 67 240 75T266 91L319 124V196Q319 334 325 361V367H316'],

    // LATIN SMALL LETTER R
    0x72: [474,21,389,17,387,'357 398Q364 398 375 403L386 408Q386 404 387 400V393L369 377Q361 370 350 360T336 347T327 340T316 336T303 335Q270 335 234 371L224 379Q220 375 214 370T198 355L182 340V243Q182 164 183 152T189 129Q195 117 211 100T239 72T254 60T298 81Q342 101 343 101Q344 100 345 92T346 82L200 -21Q174 -5 117 55L97 75L99 92Q106 147 106 196Q106 216 104 282T97 355Q95 359 95 361Q95 364 77 378L65 387L48 380Q30 372 29 372Q28 371 23 375T17 380Q17 384 50 415T107 467L115 474L128 461Q171 421 182 414V382L235 425Q247 435 261 446T283 462L290 468L295 460Q335 398 357 398'],

    // LATIN SMALL LETTER S
    0x73: [478,29,443,-18,406,'272 33Q284 33 290 70T296 138Q296 181 290 198T262 230Q257 232 246 232Q231 232 218 227T156 194L108 167L101 176Q90 192 75 219L69 230V284Q69 346 70 357V377L146 427Q181 450 202 464T223 477L225 476Q227 475 229 474Q231 472 242 466T270 450T296 431Q309 418 326 418Q342 418 361 429T392 450T403 459Q406 445 406 442Q406 440 384 421T338 382L316 363Q315 362 310 362Q292 362 251 371T173 396Q156 403 155 403Q143 386 143 342Q143 305 150 278T168 244Q171 242 181 242L190 243L315 300Q330 295 357 274Q358 273 362 270T366 266T369 261T372 253T373 239T374 217T374 185Q374 157 372 133T368 98T363 71T358 50L336 40Q288 20 255 2T211 -22T198 -29L190 -22Q181 -14 168 -3T138 19T104 38T70 46Q50 46 32 37T3 20T-9 11L-18 23L-1 41Q46 89 62 99T112 110Q141 110 157 103T225 62Q268 33 272 33'],

    // LATIN SMALL LETTER T
    0x74: [640,20,333,27,348,'228 640L242 627L227 613Q213 599 211 593T203 553Q197 500 196 435V389H301L272 353H195V274Q195 178 196 159L197 123Q249 71 273 68H280L312 83Q344 99 345 99Q348 99 348 78Q348 76 314 52T246 4L212 -20Q211 -20 164 19T112 62Q112 122 113 196Q113 228 113 262T114 318T114 341V353H27L62 389H116L117 431V558L228 640'],

    // LATIN SMALL LETTER U
    0x75: [474,23,517,9,513,'171 315Q171 252 165 199T153 124L147 103Q147 102 196 80L244 57L335 107V116Q339 161 339 268Q339 315 338 351T337 412V424L420 468Q424 465 427 461L424 435Q412 331 412 226Q412 170 415 145T434 96Q442 84 452 83Q461 83 492 96L506 102Q507 102 510 96T513 88L493 71Q445 32 401 -9Q392 -18 388 -17L384 -16Q358 39 355 44Q336 77 333 77Q261 45 203 -9Q186 -23 181 -23Q177 -23 162 -11T121 18T69 44L57 48L61 54Q65 60 71 73T82 102Q100 156 100 262Q100 305 93 335T80 373T62 396L23 376Q18 377 9 386L119 474Q149 437 171 421V339V315'],

    // LATIN SMALL LETTER V
    0x76: [530,28,512,55,434,'55 418Q55 443 100 503Q121 530 123 530Q125 528 127 528T131 528T134 528T135 524T131 516Q123 499 123 486Q123 457 159 416L169 405L170 388L171 372Q171 371 244 424L317 477L334 466Q394 428 432 416L433 402Q433 400 433 377T434 336V305Q434 195 420 131Q413 94 406 87Q403 84 298 29L192 -28L172 -8Q139 25 106 52L92 64V70Q95 97 95 198Q95 293 94 318L92 355L84 367Q55 406 55 418ZM174 306Q174 297 173 255T171 184Q171 153 175 136T198 100Q207 94 224 80T255 57T282 49Q304 49 328 80Q359 129 359 243Q359 284 352 345Q351 358 348 360Q333 373 304 384T265 396L251 390Q215 372 186 351L175 344V337Q175 319 174 306'],

    // LATIN SMALL LETTER W
    0x77: [532,28,774,45,688,'45 425Q45 439 82 485T126 532Q127 532 128 532T131 531T137 529L132 519Q121 499 121 483Q121 473 131 454T156 419L167 408L169 376L185 388Q237 425 291 473L301 466Q337 443 394 416L419 405L418 387V369Q419 369 487 418T560 471L581 459Q597 450 621 437T664 415T684 406Q688 406 688 323Q688 254 679 193T662 103T648 71Q647 70 554 20L464 -28L443 -15Q416 1 386 17T343 40T331 49Q331 52 333 73T337 133T339 216Q339 309 334 339Q333 341 316 353T277 377T246 389Q235 389 201 369T166 346Q166 345 164 247Q164 232 164 210T163 179Q163 139 170 116T205 57L212 48L136 -27Q115 16 87 44L78 53L80 67Q88 124 88 211Q88 282 87 315T83 356T74 371Q45 410 45 425ZM591 352Q580 359 565 365T540 374T517 381T504 385L418 342L417 318V220Q417 212 417 194T417 170T418 152T420 134T424 120T431 106T440 95T454 83Q508 44 544 44Q566 44 583 77Q603 120 605 235Q605 289 600 322Q598 343 597 345T591 352'],

    // LATIN SMALL LETTER X
    0x78: [472,188,389,10,363,'14 377Q63 428 117 472Q130 462 144 449L193 408V392V376L247 420Q300 464 301 464L310 451Q331 417 363 390L333 365Q303 340 301 340Q293 343 277 364T250 386Q241 386 215 361L195 341Q194 333 193 327T191 318T190 304T188 269Q188 220 192 148Q193 122 195 118T210 101Q255 60 271 60Q276 60 278 61L318 82Q327 86 336 91T351 98L356 101Q359 82 356 79Q354 77 283 27T210 -24L192 -7Q160 23 137 40L126 49L116 40Q66 -13 66 -54Q66 -117 167 -140L179 -142V-147L180 -152L123 -188L112 -185Q58 -170 31 -145Q10 -122 10 -96Q10 -80 22 -53Q44 -10 95 49Q97 51 100 54T104 59T107 64T109 71T111 81T112 97T113 119T114 149T114 188Q114 284 108 347V354L96 365Q76 385 67 385Q62 385 45 377L27 368L14 377'],

    // LATIN SMALL LETTER Y
    0x79: [528,218,499,45,431,'74 58Q89 124 89 241Q89 265 89 278T89 305T88 324T87 336T84 346T81 352T77 359T71 368Q57 388 52 398L45 409Q62 454 98 507L113 528Q128 528 128 524Q128 523 125 518T120 503T117 483V471Q123 456 130 445Q135 438 140 432T148 422T153 415T157 409T160 405T162 402T163 399T163 395V384V365Q165 365 237 419L311 473Q383 430 420 416Q426 414 426 411V404Q426 398 426 388T427 367Q431 233 431 201Q431 -3 391 -52Q387 -58 305 -138T221 -218L218 -217Q216 -216 211 -214T202 -210L184 -202L199 -194Q259 -162 288 -127T334 -19T350 184Q350 257 342 328L340 356Q282 390 262 390Q248 390 178 346L163 336V111L216 45L131 -26L124 -15Q114 3 85 44L74 58'],

    // LATIN SMALL LETTER Z
    0x7A: [471,214,391,-7,314,'47 335L36 347L52 362Q112 421 167 461L181 471L192 465Q236 444 260 417T284 369Q284 355 276 343T233 291Q195 246 195 245T205 242T241 228T300 198L302 187Q314 138 314 74Q314 -24 291 -95Q290 -100 222 -157L154 -214H145Q102 -214 53 -189T-7 -117Q41 -21 183 122L207 147Q205 149 186 157T140 172T100 180H97V192L140 231Q192 280 199 293Q205 303 205 315Q205 339 185 363T137 388Q119 388 63 347L47 335ZM179 -153Q212 -153 226 -113T240 14Q240 67 233 98T223 132T211 143L222 130Q216 125 206 116T170 82T124 33T88 -20T72 -70Q72 -99 105 -126T179 -153']
  }
);

MathJax.Ajax.loadComplete(MathJax.OutputJax.SVG.fontDir+"/Fraktur/Regular/BasicLatin.js");
