/***********************************************************************************

    Copyright (C) 2007-2012 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_VIEW_LOGIN_HEADER
#define LIFEOGRAPH_VIEW_LOGIN_HEADER


namespace LIFEO
{

class ViewLogin
{
        enum InfoResponse { RESP_OK = 10, RESP_UNDO = 20 };
        enum SortDateType { SDT_ACCESS, SDT_SAVE, SDT_NAME };

    public:
        class Colrec : public Gtk::TreeModel::ColumnRecord
        {
            public:
                Colrec()
                {
                    //add( icon );
                    add( name );
                    add( date );
                    add( path );
                    add( date_sort );
                }
                //Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >     icon;
                Gtk::TreeModelColumn< Glib::ustring >                   name;
                Gtk::TreeModelColumn< Glib::ustring >                   date;
                Gtk::TreeModelColumn< std::string >                     path;
                Gtk::TreeModelColumn< time_t >                          date_sort;
        };
        static Colrec               *colrec;

                                    ViewLogin();

        void                        handle_start();
        void                        handle_logout();

        void                        populate_diaries();
        void                        sort_by_date();
        void                        sort_by_name();
        int                         sort_by_date_func( const Gtk::TreeModel::iterator&,
                                                       const Gtk::TreeModel::iterator& );
        int                         sort_by_name_func( const Gtk::TreeModel::iterator&,
                                                       const Gtk::TreeModel::iterator& );

        static std::string          m_path_cur;

    protected:
        // these two functions are to mask bool return type of open_selected_diary()
        // from signal connection system
        void                        handle_button_read()
        { open_selected_diary( true ); }
        void                        handle_button_edit()
        { open_selected_diary( false ); }
        Result                      open_selected_diary( bool );
        void                        open_activated_diary();
        void                        remove_selected_diary();

        void                        create_new_diary();
        void                        add_existing_diary();

        void                        show_info( Gtk::MessageType, const Glib::ustring&,
                                               const Glib::ustring& =  _( "OK" ),
                                               InfoResponse = RESP_OK );
        void                        handle_infobar_response( int );
        void                        hide_infobar();

        void                        handle_diary_selection_changed();
        void                        handle_diary_activated( const Gtk::TreePath&,
                                                            Gtk::TreeView::Column* );
        void                        handle_button_release( GdkEventButton* );
        void                        handle_key_release( GdkEventKey* );
        bool                        handle_diary_tooltip( int, int, bool,
                                                          const Glib::RefPtr<Gtk::Tooltip>& );

        void                        handle_dragged_file( const Glib::RefPtr<Gdk::DragContext>&,
                                                         int, int,
                                                         const Gtk::SelectionData&,
                                                         guint, guint );

        Gtk::TreeView               *m_treeview_diaries;
        Glib::RefPtr< Gtk::ListStore >
                                    m_treestore_diaries;
        Glib::RefPtr< Gtk::TreeSelection >
                                    m_treesel_diaries;

        Gtk::Grid                   *m_grid_login;
        Gtk::InfoBar                *m_infobar;
        Gtk::Label                  *m_label_info;
        Gtk::Button                 *m_button_info;
        Gtk::Button                 *m_button_edit_diary;
        Gtk::Button                 *m_button_read_diary;
        Gtk::Button                 *m_button_remove_diary;

        std::string                 m_path_removed;
        bool                        m_flag_info_is_visible;
        bool                        m_flag_diary_activated;
        int                         m_password_attempt_no;
        InfoResponse                m_resp_cur; // FIXME: a most unfortunate solution!!
        SortDateType                m_sort_date_type;
};

} // end of namespace LIFEO

#endif
