/***************************************************************************
 *   Copyright (C) 2005-2010 by Georg Hennig                               *
 *   Email: georg.hennig@web.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KOMPARATORFILEFILTER_H_
#define _KOMPARATORFILEFILTER_H_

#include <KPushButton>
#include <QEvent>

class QCheckBox;
class QDate;
class QRadioButton;
class QComboBox;
class KDateCombo;
class KIntSpinBox;
class KPopupFrame;
class KLineEdit;
class QVBoxLayout;
class QHBoxLayout;

enum FILTER_TYPE
{
	MISSING_TYPE = 0,
	NEWER_TYPE,
	DUPLICATES_TYPE
};

class KomparatorFileFilter : public KPushButton
{
	Q_OBJECT

	public:
		KomparatorFileFilter( QWidget *parent, const char *name = NULL );
		KomparatorFileFilter( const QString &text, QWidget *parent, const char *name = NULL );
		KomparatorFileFilter( const KIcon &icon, const QString &text, QWidget *parent, const char *name = NULL );
		KomparatorFileFilter( const KGuiItem &item, QWidget *parent, const char *name = NULL );
		~KomparatorFileFilter();
		void setFilterType( int filter_type );
		QStringList getStringList();
		QList<int> getIntList();
		void setStringList( QStringList &string_list );
		void setIntList( QList<int> &int_list );

	signals:
		void signalChanged( KomparatorFileFilter *, const QString &/*name*/, const QString &/*path*/, const QString &/*owner*/,
			const QString &/*group*/, const unsigned long &/*min_size*/, const unsigned long &/*max_size*/,
			const bool &/*consider date*/, const QDate &/*date*/, const bool &/*newer_real*/, const bool &/*newer_equal*/, const bool &/*newer_same_time*/ );
		void signalChanged( KomparatorFileFilter *, const QString &/*name*/, const QString &/*path*/, const QString &/*owner*/,
			const QString &/*group*/, const unsigned long &/*min_size*/, const unsigned long &/*max_size*/,
			const bool &/*consider date*/, const QDate &/*date*/, const bool &/*duplicates_normal*/, const bool &/*duplicates_multiple*/ );
		void signalChanged( KomparatorFileFilter *, const QString &/*name*/, const QString &/*path*/, const QString &/*owner*/,
			const QString &/*group*/, const unsigned long &/*min_size*/, const unsigned long &/*max_size*/,
			const bool &/*consider date*/, const QDate &/*date*/ );

	public slots:
		void slotClear();
		void slotEmitFilterChanged();

	protected slots:
		void slotClicked();
		void slotConsiderDate( bool on );
		void slotEmitChanged( const QString &str = "" );

		void slotAutoApply( bool apply );

	protected:
		bool eventFilter( QObject*, QEvent *e );

	private:
		bool m_auto_apply;
		int m_filter_type;

		QWidget *m_main_box;
		QHBoxLayout *m_main_box_layout;
		QWidget *m_misc_box;
		QVBoxLayout *m_misc_box_layout;

		KPopupFrame *m_popup_frame;
		KLineEdit *m_name_edit;
		KLineEdit *m_path_edit;
		KLineEdit *m_owner_edit;
		KLineEdit *m_group_edit;

		KIntSpinBox *m_min_size;
		KIntSpinBox *m_max_size;

		QComboBox *m_min_size_combo;
		QComboBox *m_max_size_combo;

		QCheckBox *m_date_checkbox;
		KDateCombo *m_date_combo;

		QCheckBox *m_newer_real;
		QCheckBox *m_newer_equal;
		QCheckBox *m_newer_same_time;

		QCheckBox *m_duplicates_normal;
		QCheckBox *m_duplicates_multiple;

		void init();
		void emitChanged();
};

#endif
