/*
 * This file is part of John the Ripper password cracker,
 * Copyright (c) 1996-2000,2005,2008,2010 by Solar Designer
 */

/*
 * Architecture specific parameters for 32-bit PowerPC w/ AltiVec (128-bit).
 */

#ifndef _JOHN_ARCH_H
#define _JOHN_ARCH_H

#define ARCH_WORD			int
#define ARCH_SIZE			4
#define ARCH_BITS			32
#define ARCH_BITS_LOG			5
#define ARCH_BITS_STR			"32"
#define ARCH_LITTLE_ENDIAN		0
#define ARCH_INT_GT_32			0
#define ARCH_ALLOWS_UNALIGNED		0
#define ARCH_INDEX(x)			((unsigned int)(unsigned char)(x))

#define OS_TIMER			1
#define OS_FLOCK			1

#define CPU_DETECT			0

#define DES_ASM				0
#define DES_128K			0
#define DES_X2				0
#define DES_MASK			1
#define DES_SCALE			0
#define DES_EXTB			1
#define DES_COPY			0
#define DES_BS_ASM			0
#define DES_BS				3
#define DES_BS_EXPAND			0

#if 1
#define DES_BS_VECTOR			4
#define DES_BS_ALGORITHM_NAME		"128/128 BS AltiVec"
#elif 0
/* It is likely unreasonable to use S-box expressions requiring vsel when this
 * operation is only available in one of the two instruction sets.
 * So let's revert to less demanding S-box expressions. */
#undef DES_BS
#define DES_BS				1
#define DES_BS_VECTOR			5
#define DES_BS_VECTOR_SIZE		8
#define DES_BS_ALGORITHM_NAME		"128/128 BS AltiVec + 32/32 BS"
#else
#define DES_BS_VECTOR			8
#define DES_BS_ALGORITHM_NAME		"128/128 X2 BS AltiVec"
#endif

#define MD5_ASM				0
#define MD5_X2				1
#define MD5_IMM				0

#define BF_ASM				0
#define BF_SCALE			0
#define BF_X2				0

#endif
