/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IIMAGECOMPOSER_H
#define IIMAGECOMPOSER_H


#include "iobject.h"


#include "iarray.h"

class iControlModule;
class iImageComposerWindow;
class iImageComposerBackgroundWindow;
class iImageComposerForegroundWindow;
class iStereoImageArray;
class iViewModule;


class iImageComposer : public iObject
{

	IPOINTER_AS_PART(ControlModule);

public:

	vtkTypeMacro(iImageComposer,iObject);
	static iImageComposer* New(iControlModule *cm = 0);
	static const iObjectType& Type();

	IOBJECT_DECLARE_GETSET1(ScaleBackground,bool);
	IOBJECT_DECLARE_GETSET1(InnerBorder,bool);
	IOBJECT_DECLARE_GETSET1(BorderColor,const iColor&);
	IOBJECT_DECLARE_GETSET1(BorderWidth,int);

	IOBJECT_DECLARE_GET(ImageWidth,mFullWidth,int);
	IOBJECT_DECLARE_GET(ImageHeight,mFullHeight,int);
	int GetTileWidth() const { return mTileWidth; }
	int GetTileHeight() const { return mTileHeight; }

	void SetNumTiles(int nx, int ny);
	int GetNumTilesX() const { return mNumTilesX; }
	int GetNumTilesY() const { return mNumTilesY; }
	static const iObjectKey& KeyNumTiles();

	int GetNumberOfBackgroundWindows() const { return mBackgroundWindows.Size(); }
	int GetNumberOfForegroundWindows() const { return mForegroundWindows.Size(); }
	static const iObjectKey& KeyNumForegroundWindows();

	inline iImageComposerBackgroundWindow* GetBackgroundWindow(int i, int j) const
	{
		return this->GetBackgroundWindow(i+mNumTilesX*j);
	}

	iImageComposerBackgroundWindow* GetBackgroundWindow(int i) const;
	iImageComposerForegroundWindow* GetForegroundWindow(int i) const;

	void AddForegroundWindow(iViewModule *v);
	void RemoveForegroundWindow(int n);
	void MoveToBack(int n);

	//
	//  Useful keys for command-line interface 
	//
	static const iObjectKey& KeyBackgroundWindowViewModule();
	static const iObjectKey& KeyBackgroundWindowViewModule2();
	static const iObjectKey& KeyBackgroundWindowViewModule3();
	static const iObjectKey& KeyBackgroundWindowWallpaperFile();

	static const iObjectKey& KeyForegroundWindowViewModule();
	static const iObjectKey& KeyForegroundWindowViewModule2();
	static const iObjectKey& KeyForegroundWindowViewModule3();
	static const iObjectKey& KeyForegroundWindowPositionX();
	static const iObjectKey& KeyForegroundWindowPositionY();
	static const iObjectKey& KeyForegroundWindowScale();
	static const iObjectKey& KeyForegroundWindowBorderWidth();
	static const iObjectKey& KeyForegroundWindowBorderColor();

	static const iObjectKey& KeyForegroundWindowZoomSource();
	static const iObjectKey& KeyForegroundWindowZoom4Line();
	static const iObjectKey& KeyForegroundWindowZoomFactor();
	static const iObjectKey& KeyForegroundWindowZoomX();
	static const iObjectKey& KeyForegroundWindowZoomY();

	//
	//  Other functions
	//
	inline bool InComposing() const { return mInComposing; }
	void Compose(iViewModule *vm, iStereoImageArray &images);
	bool IsActive();

	void Update();  // update all
	void UpdateWindowList();
	void UpdateSize();

protected:

	virtual ~iImageComposer();

private:

	iImageComposer(iControlModule *cm);

	virtual void PackStateBody(iString &s) const;
	virtual void UnPackStateBody(const iString &s);

	void UnPackingHelper(int n, int j, iImageComposerWindow **win, int *itmp, const iObjectKey &key, const iString &s);

	bool mBlockUpdate, mInComposing;
	bool mInnerBorder, mScaleBackground;
	iColor mBorderColor;
	int mBorderWidth;
	int mFullWidth, mFullHeight;
	int mTileWidth, mTileHeight;
	int mNumTilesX, mNumTilesY;

	iArray<iImageComposerBackgroundWindow*> mBackgroundWindows;
	iArray<iImageComposerForegroundWindow*> mForegroundWindows;
};

#endif // IIMAGECOMPOSER_H

