{- This module was generated from data in the Kate syntax
   highlighting file alert.xml, version 1.09, by Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Alert
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Alerts"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = ""

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Alerts","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Alerts","Normal Text") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_alerts'5fhi = Set.fromList $ words $ "ALERT ATTENTION DANGER HACK SECURITY"
list_alerts'5fmid = Set.fromList $ words $ "BUG FIXME DEPRECATED TASK TODO TBD WARNING CAUTION NOLINT"
list_alerts'5flo = Set.fromList $ words $ "### NOTE NOTICE TEST TESTING"


parseRules ("Alerts","Normal Text") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_alerts'5fhi >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_alerts'5fmid >>= withAttribute AlertTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_alerts'5flo >>= withAttribute AlertTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Alerts","Normal Text")) >> pDefault >>= withAttribute NormalTok))


parseRules x = parseRules ("Alerts","Normal Text") <|> fail ("Unknown context" ++ show x)
