{- This module was generated from data in the Kate syntax
   highlighting file json.xml, version 1.2, by Sebastian Pipping (sebastian@pipping.org) -}

module Text.Highlighting.Kate.Syntax.Json
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "JSON"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.json"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "JSON" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("JSON",["Normal"])], synStLanguage = "JSON", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "Pair" -> return ()
    "String_Key" -> return ()
    "Value" -> return ()
    "String_Value" -> return ()
    "Array" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_Constants = Set.fromList $ words $ "null true false"

regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 = compileRegex "\\\\(?:[\"\\\\/bfnrt]|u[0-9a-fA-f]{4})"
regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f = compileRegex "-?(?:[0-9]|[1-9][0-9]+)\\.[0-9]+(?:[eE][+-]?[0-9]+)?"
regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f = compileRegex "-?(?:[0-9]|[1-9][0-9]+)(?:[eE][+-]?[0-9]+)?"

defaultAttributes = [("Normal",ErrorTok),("Pair",ErrorTok),("String_Key",DataTypeTok),("Value",ErrorTok),("String_Value",StringTok),("Array",ErrorTok)]

parseRules "Normal" =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "Pair")
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext "Array")
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok)))

parseRules "Pair" =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ pushContext "String_Key")
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext "Value")
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok)))

parseRules "String_Key" =
  (((pDetectChar False '"' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 >>= withAttribute DataTypeTok)))

parseRules "Value" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String_Value")
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "Pair")
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext "Array")
   <|>
   ((lookAhead (pDetectChar False '}') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((lookAhead (pDetectChar False ',') >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Constants >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute DecValTok)))

parseRules "String_Value" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5c'5c'28'3f'3a'5b'22'5c'5c'2fbfnrt'5d'7cu'5b0'2d9a'2dfA'2df'5d'7b4'7d'29 >>= withAttribute StringTok)))

parseRules "Array" =
  (((pDetectChar False ',' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False ']' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext "Pair")
   <|>
   ((pDetectChar False '[' >>= withAttribute NormalTok) >>~ pushContext "Array")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String_Value")
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Constants >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'5c'2e'5b0'2d9'5d'2b'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'2d'3f'28'3f'3a'5b0'2d9'5d'7c'5b1'2d9'5d'5b0'2d9'5d'2b'29'28'3f'3a'5beE'5d'5b'2b'2d'5d'3f'5b0'2d9'5d'2b'29'3f >>= withAttribute DecValTok)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
