/* 
 * gpsk31  - PSK31 for Linux with a GTK+ Interface
 * 
 * Copyright (C) 2000 Luc Langehegermann, LX2GT
 * Copyright (C) 2005,2006,2007,2008 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * The main author can be reached at pg4i@amsat.org or by smail-mail:
 * Joop Stakenborg, Bramengaarde 24, 3992KG Houten, The Netherlands.
 * 
 */

#ifndef __HANSIS_FFT_H
#define __HANSIS_FFT_H

#ifndef CMPLX_DEFINED
#define CMPLX_DEFINED
typedef struct {
        double x,y;
} cmplx;
#endif

class FFTer
{
public:
	FFTer( int l, int mod=0 );
	~FFTer();

#if 0
	Vector<Complex> operator*( const Vector<Complex>& fd );
	Vector<Complex> operator*( const Vector<double>& fd );
	Vector<Complex> operator*( const Vector<short>& fd );

	friend Vector<Complex> operator*( const Vector<Complex>& fd, 
					  const FFTer& fft );
	friend Vector<Complex> operator*( const Vector<double>& fd, 
					  const FFTer& fft );
	friend Vector<Complex> operator*( const Vector<short>& fd, 
					  const FFTer& fft );
	friend Vector<Complex> operator/( const Vector<Complex>& fd, 
					  const FFTer& fft );
#endif

protected:
	int len, M;
	int mode;
	double *real_a, *imag_a;


public:	
	// Dumm-DFT: Hilfsfunktionen und -tabellen
	cmplx *Dm;
#if 0
	Vector<Complex> dft( const Vector<Complex>, int invers ) const;
	Vector<Complex> dft( const Vector<double>, int invers ) const;
	Vector<Complex> dft( const Vector<short>, int invers ) const;
	void dft_init();
	void dft_remove();
#endif

	// Split-Radix FFT mit Hilfstabellen (Base 2) und -funktionen
	void fftsr_init();
	void fftsr_remove();
	void fftsr_bitrevers(double *x, double *y) const;
	double *CT1, *CT3, *ST1, *ST3;
	int *itab;

	// a) normale Transformation (komplex)
	cmplx* fftsr( const cmplx* ) const;
	void fftsr_helper( int, int, int, double *, double *, 
			   double *, double *, double *, double *, 
			   double *, double *) const;
	void fftsr_main( double *, double *) const;
	// b) inverse Split-Radix (auch komplex)
	cmplx* ifftsr( const cmplx* ) const;
	void ifftsr_main( double *, double *) const;
	void ifftsr_helper( int, int, double *, double *, 
			    double *, double *, double *, double *, 
			    double *, double *) const;
	// c) reele Transformation (Input=Vector<double>)
	cmplx* rfftsr( const double* ) const;
	cmplx* rfftsr( const short* ) const;
	cmplx* rfftsr_wrapper( double *) const;
	void rfftsr_bitrevers(double *x) const;
	void rfftsr_main( double *) const;
	void rfftsr_helper( int, int, double *, double *, double *,
			    double *) const;
};

#endif
