package exif

var regressExpected = map[string]map[FieldName]string{
	"2004-01-11-22-45-15-sep-2004-01-11-22-45-15a.jpg": map[FieldName]string{
		PixelXDimension:            `1600`,
		InteroperabilityIFDPointer: `1009`,
		SceneType:                  `""`,
		InteroperabilityIndex:      `"R98"`,
		Make:                       `"Samsung Techwin"`,
		DateTimeOriginal:           `"2004:01:11 22:45:15"`,
		DateTimeDigitized:          `"2004:01:11 22:45:15"`,
		ImageDescription:           `"SAMSUNG DIGITAL CAMERA         "`,
		ExifVersion:                `"0220"`,
		MeteringMode:               `2`,
		Flash:                      `1`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		FlashpixVersion:            `"0100"`,
		YResolution:                `"72/1"`,
		ThumbJPEGInterchangeFormat: `1039`,
		MaxApertureValue:           `"32/10"`,
		ExposureProgram:            `2`,
		Software:                   `"M5011S-1031"`,
		DateTime:                   `"2004:01:11 22:45:19"`,
		FNumber:                    `"320/100"`,
		ISOSpeedRatings:            `150`,
		ComponentsConfiguration:    `""`,
		CompressedBitsPerPixel:     `"2/1"`,
		RelatedSoundFile:           `""`,
		XResolution:                `"72/1"`,
		ExifIFDPointer:             `251`,
		ExposureTime:               `"1000/30000"`,
		LightSource:                `0`,
		FocalLength:                `"82/11"`,
		ColorSpace:                 `1`,
		PixelYDimension:            `1200`,
		FileSource:                 `""`,
		Model:                      `"U-CA 501"`,
		ThumbJPEGInterchangeFormatLength: `3530`,
		ExposureBiasValue:                `"95/10"`,
	},
	"2006-08-03-16-29-38-sep-2006-08-03-16-29-38a.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `5108`,
		ThumbJPEGInterchangeFormatLength: `4323`,
		MaxApertureValue:                 `"95/32"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `196`,
		ExposureTime:                     `"1/1500"`,
		InteroperabilityIndex:            `"R98"`,
		FocalPlaneXResolution:            `"2816000/225"`,
		YResolution:                      `"180/1"`,
		DateTime:                         `"2006:08:03 16:29:38"`,
		ShutterSpeedValue:                `"338/32"`,
		ApertureValue:                    `"95/32"`,
		FocalLength:                      `"5800/1000"`,
		FlashpixVersion:                  `"0100"`,
		Make:                             `"Canon"`,
		DateTimeOriginal:                 `"2006:08:03 16:29:38"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `2824`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		FNumber:                          `"28/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2006:08:03 16:29:38"`,
		CompressedBitsPerPixel:           `"5/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		UserComment:                      `""`,
		PixelXDimension:                  `2816`,
		Model:                            `"Canon PowerShot SD600"`,
		ExposureBiasValue:                `"0/3"`,
		PixelYDimension:                  `2112`,
		FocalPlaneResolutionUnit:         `2`,
		DigitalZoomRatio:                 `"2816/2816"`,
		Orientation:                      `6`,
		XResolution:                      `"180/1"`,
		ExifVersion:                      `"0220"`,
		Flash:                            `24`,
		FocalPlaneYResolution: `"2112000/169"`,
		CustomRendered:        `0`,
	},
	"2006-11-11-19-17-56-sep-2006-11-11-19-17-56a.jpg": map[FieldName]string{
		FNumber:                 `"28/10"`,
		ExposureProgram:         `2`,
		Software:                `"E3200v1.1"`,
		DateTime:                `"2006:11:11 19:17:56"`,
		ExposureTime:            `"10/601"`,
		ISOSpeedRatings:         `50`,
		ComponentsConfiguration: `""`,
		CompressedBitsPerPixel:  `"4/1"`,
		Saturation:              `0`,
		XResolution:             `"300/1"`,
		ExifIFDPointer:          `284`,
		ExposureBiasValue:       `"0/10"`,
		LightSource:             `0`,
		FocalLength:             `"58/10"`,
		ColorSpace:              `1`,
		PixelYDimension:         `1536`,
		FileSource:              `""`,
		Model:                   `"E3200"`,
		ThumbJPEGInterchangeFormatLength: `4546`,
		DateTimeDigitized:                `"2006:11:11 19:17:56"`,
		PixelXDimension:                  `2048`,
		InteroperabilityIFDPointer:       `1026`,
		SceneType:                        `""`,
		DigitalZoomRatio:                 `"0/100"`,
		GainControl:                      `0`,
		Make:                             `"NIKON"`,
		DateTimeOriginal:                 `"2006:11:11 19:17:56"`,
		InteroperabilityIndex:            `"R98"`,
		ImageDescription:                 `"          "`,
		Sharpness:                        `0`,
		YCbCrPositioning:                 `2`,
		ExifVersion:                      `"0220"`,
		MeteringMode:                     `5`,
		Flash:                            `25`,
		FocalLengthIn35mmFilm:      `38`,
		SubjectDistanceRange:       `0`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		MaxApertureValue:           `"30/10"`,
		FlashpixVersion:            `"0100"`,
		WhiteBalance:               `0`,
		YResolution:                `"300/1"`,
		ThumbJPEGInterchangeFormat: `4596`,
		CustomRendered:             `1`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Contrast:                   `0`,
		MakerNote:                  `""`,
		UserComment:                `"                                                                                                                     "`,
	},
	"2006-12-10-23-58-20-sep-2006-12-10-23-58-20a.jpg": map[FieldName]string{
		Model:                    `"Canon PowerShot A80"`,
		ExposureBiasValue:        `"0/3"`,
		PixelYDimension:          `1704`,
		FocalPlaneResolutionUnit: `2`,
		FocalPlaneYResolution:    `"1704000/210"`,
		CustomRendered:           `0`,
		DigitalZoomRatio:         `"2272/2272"`,
		Orientation:              `1`,
		XResolution:              `"180/1"`,
		ExifVersion:              `"0220"`,
		Flash:                    `24`,
		ThumbJPEGInterchangeFormat:       `2036`,
		ThumbJPEGInterchangeFormatLength: `6465`,
		MaxApertureValue:                 `"95/32"`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `196`,
		ExposureTime:                     `"1/80"`,
		FocalLength:                      `"250/32"`,
		FlashpixVersion:                  `"0100"`,
		FocalPlaneXResolution:            `"2272000/280"`,
		YResolution:                      `"180/1"`,
		DateTime:                         `"2006:12:10 23:58:20"`,
		ShutterSpeedValue:                `"202/32"`,
		ApertureValue:                    `"95/32"`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Make:                             `"Canon"`,
		DateTimeOriginal:                 `"2006:12:10 23:58:20"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `1844`,
		FNumber:                          `"28/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		UserComment:                      `""`,
		PixelXDimension:                  `2272`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2006:12:10 23:58:20"`,
		CompressedBitsPerPixel:           `"3/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
	},
	"2006-12-17-07-09-14-sep-2006-12-17-07-09-14a.jpg": map[FieldName]string{
		WhiteBalance:                     `0`,
		YResolution:                      `"72/1"`,
		ThumbJPEGInterchangeFormatLength: `7063`,
		ExposureBiasValue:                `"0/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1536`,
		ExposureMode:                     `0`,
		InteroperabilityIndex:            `"R98"`,
		Make:                       `"PENTAX Corporation"`,
		DateTimeDigitized:          `"2006:12:17 07:09:14"`,
		PixelXDimension:            `2048`,
		InteroperabilityIFDPointer: `31048`,
		CustomRendered:             `0`,
		DateTime:                   `"2006:12:17 07:09:14"`,
		ExposureProgram:            `2`,
		FocalLengthIn35mmFilm:      `38`,
		Saturation:                 `0`,
		XResolution:                `"72/1"`,
		ISOSpeedRatings:            `64`,
		ExifVersion:                `"0220"`,
		CompressedBitsPerPixel:     `"5725504/3145728"`,
		Flash: `24`,
		Model: `"PENTAX Optio S6"`,
		ThumbJPEGInterchangeFormat: `31172`,
		MaxApertureValue:           `"27/10"`,
		FocalLength:                `"62/10"`,
		ColorSpace:                 `1`,
		DateTimeOriginal:           `"2006:12:17 07:09:14"`,
		MakerNote:                  `""`,
		DigitalZoomRatio:           `"100/100"`,
		SceneCaptureType:           `0`,
		Contrast:                   `0`,
		Software:                   `"Optio S6 Ver 1.00"`,
		FNumber:                    `"270/100"`,
		Sharpness:                  `0`,
		ComponentsConfiguration:    `""`,
		MeteringMode:               `5`,
		SubjectDistanceRange:       `2`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		ExifIFDPointer:             `586`,
		ExposureTime:               `"1/160"`,
	},
	"2006-12-21-15-55-26-sep-2006-12-21-15-55-26a.jpg": map[FieldName]string{
		DateTimeDigitized:                `"2006:12:21 15:55:26"`,
		CompressedBitsPerPixel:           `"8/1"`,
		MeteringMode:                     `3`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2592`,
		Saturation:                       `0`,
		ImageDescription:                 `"                               "`,
		Model:                            `"DSC-W15"`,
		ExposureBiasValue:                `"-20/10"`,
		PixelYDimension:                  `1944`,
		Orientation:                      `1`,
		XResolution:                      `"72/1"`,
		ISOSpeedRatings:                  `100`,
		ExifVersion:                      `"0220"`,
		Flash:                            `79`,
		CustomRendered:                   `0`,
		ThumbJPEGInterchangeFormat:       `2484`,
		ThumbJPEGInterchangeFormatLength: `13571`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"48/16"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `256`,
		ExposureTime:                     `"10/400"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		YResolution:                      `"72/1"`,
		DateTime:                         `"2006:12:21 15:55:26"`,
		LightSource:                      `0`,
		FocalLength:                      `"79/10"`,
		FlashpixVersion:                  `"0100"`,
		Contrast:                         `0`,
		Make:                             `"SONY"`,
		DateTimeOriginal:                 `"2006:12:21 15:55:26"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `2278`,
		ExposureMode:                     `1`,
		SceneCaptureType:                 `0`,
		FNumber:                          `"28/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
	},
	"2007-01-01-12-00-00-sep-2007-01-01-12-00-00a.jpg": map[FieldName]string{
		MaxApertureValue:                 `"286/100"`,
		ExposureIndex:                    `"200/1"`,
		ThumbJPEGInterchangeFormat:       `13848`,
		ThumbJPEGInterchangeFormatLength: `3436`,
		ExposureProgram:                  `2`,
		ExposureTime:                     `"8942/1000000"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `340`,
		ApertureValue:                    `"286/100"`,
		LightSource:                      `0`,
		FocalLength:                      `"60/10"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"480/1"`,
		Software:                         `"KODAK EASYSHARE C713 ZOOM DIGITAL CAMERA"`,
		ShutterSpeedValue:                `"680/100"`,
		InteroperabilityIFDPointer:       `13816`,
		ExposureMode:                     `0`,
		FocalLengthIn35mmFilm:            `36`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		Make:                             `"EASTMAN KODAK COMPANY"`,
		DateTimeOriginal:                 `"2007:01:01 12:00:00"`,
		ComponentsConfiguration:          `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		FNumber:                          `"270/100"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		PixelXDimension:                  `1280`,
		SensingMethod:                    `2`,
		GainControl:                      `2`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		DateTimeDigitized:                `"2007:01:01 12:00:00"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		Model:                            `"KODAK EASYSHARE C713 ZOOM DIGITAL CAMERA"`,
		ExposureBiasValue:                `"0/10"`,
		PixelYDimension:                  `960`,
		ExifVersion:                      `"0221"`,
		Flash:                            `25`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/10"`,
		Orientation:                      `1`,
		XResolution:                      `"480/1"`,
		ISOSpeedRatings:                  `200`,
	},
	"2007-01-17-21-49-44-sep-2007-01-17-21-49-44a.jpg": map[FieldName]string{
		XResolution:                      `"180/1"`,
		ISOSpeedRatings:                  `50`,
		ExifVersion:                      `"0220"`,
		Flash:                            `24`,
		CustomRendered:                   `0`,
		Orientation:                      `1`,
		ThumbJPEGInterchangeFormatLength: `7024`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"297/100"`,
		ThumbJPEGInterchangeFormat:       `956`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `266`,
		ExposureTime:                     `"1/30"`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		Software:                         `"1.00.018PR         "`,
		DateTime:                         `"2007:01:17 21:49:44"`,
		ShutterSpeedValue:                `"491/100"`,
		ApertureValue:                    `"33/10"`,
		LightSource:                      `0`,
		FocalLength:                      `"73/10"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"180/1"`,
		DateTimeOriginal:                 `"2007:01:17 21:49:44"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `832`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Make:                             `"Digital Camera                 "`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		FNumber:                          `"33/10"`,
		MeteringMode:                     `2`,
		MakerNote:                        `"6106789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456"`,
		PixelXDimension:                  `2816`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2007:01:17 21:49:44"`,
		Model:                            `"6MP-9Y8        "`,
		ExposureBiasValue:                `"0/10"`,
		PixelYDimension:                  `2112`,
		ImageDescription:                 `"Digital image  "`,
	},
	"2007-02-02-18-13-29-sep-2007-02-02-18-13-29a.jpg": map[FieldName]string{
		Software:                         `"Optio S5z Ver 1.00 "`,
		FNumber:                          `"26/10"`,
		Sharpness:                        `0`,
		Orientation:                      `1`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `586`,
		ExposureTime:                     `"1/60"`,
		ComponentsConfiguration:          `""`,
		MeteringMode:                     `5`,
		SubjectDistanceRange:             `2`,
		YResolution:                      `"72/1"`,
		ThumbJPEGInterchangeFormatLength: `8800`,
		ExposureBiasValue:                `"0/3"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1920`,
		WhiteBalance:                     `0`,
		Make:                             `"PENTAX Corporation "`,
		DateTimeDigitized:                `"2007:02:02 18:13:29"`,
		PixelXDimension:                  `2560`,
		InteroperabilityIFDPointer:       `30974`,
		CustomRendered:                   `0`,
		ExposureMode:                     `0`,
		InteroperabilityIndex:            `"R98"`,
		DateTime:                         `"2007:02:02 18:13:29"`,
		ExposureProgram:                  `2`,
		XResolution:                      `"72/1"`,
		ISOSpeedRatings:                  `200`,
		ExifVersion:                      `"0220"`,
		CompressedBitsPerPixel:           `"27033600/4915200"`,
		Flash: `25`,
		FocalLengthIn35mmFilm: `35`,
		Saturation:            `0`,
		Model:                 `"PENTAX Optio S5z "`,
		ThumbJPEGInterchangeFormat: `31098`,
		MaxApertureValue:           `"28/10"`,
		FocalLength:                `"580/100"`,
		ColorSpace:                 `1`,
		DateTimeOriginal:           `"2007:02:02 18:13:29"`,
		MakerNote:                  `""`,
		DigitalZoomRatio:           `"0/0"`,
		SceneCaptureType:           `0`,
		Contrast:                   `0`,
	},
	"2007-05-02-17-02-21-sep-2007-05-02-17-02-21a.jpg": map[FieldName]string{
		UserComment:              `""`,
		PixelXDimension:          `1600`,
		SensingMethod:            `2`,
		DateTimeDigitized:        `"2007:05:02 17:02:21"`,
		CompressedBitsPerPixel:   `"3/1"`,
		MeteringMode:             `5`,
		MakerNote:                `""`,
		Model:                    `"Canon IXY DIGITAL 55"`,
		ExposureBiasValue:        `"0/3"`,
		PixelYDimension:          `1200`,
		FocalPlaneResolutionUnit: `2`,
		FocalPlaneYResolution:    `"1200000/168"`,
		CustomRendered:           `0`,
		DigitalZoomRatio:         `"2592/2592"`,
		Orientation:              `1`,
		XResolution:              `"180/1"`,
		ExifVersion:              `"0220"`,
		Flash:                    `9`,
		ThumbJPEGInterchangeFormat:       `5108`,
		ThumbJPEGInterchangeFormatLength: `6306`,
		MaxApertureValue:                 `"107/32"`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `196`,
		ExposureTime:                     `"1/60"`,
		FocalLength:                      `"7109/1000"`,
		FlashpixVersion:                  `"0100"`,
		FocalPlaneXResolution:            `"1600000/225"`,
		YResolution:                      `"180/1"`,
		DateTime:                         `"2007:05:02 17:02:21"`,
		ShutterSpeedValue:                `"189/32"`,
		ApertureValue:                    `"107/32"`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Make:                             `"Canon"`,
		DateTimeOriginal:                 `"2007:05:02 17:02:21"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `2226`,
		FNumber:                          `"32/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
	},
	"2007-05-12-08-19-07-sep-2007-05-12-08-19-07a.jpg": map[FieldName]string{
		Model:             `"EX-Z70     "`,
		ExposureBiasValue: `"0/3"`,
		PixelYDimension:   `480`,
		CustomRendered:    `0`,
		DigitalZoomRatio:  `"0/0"`,
		Orientation:       `1`,
		XResolution:       `"72/1"`,
		ExifVersion:       `"0221"`,
		Flash:             `16`,
		ThumbJPEGInterchangeFormat:       `27422`,
		ThumbJPEGInterchangeFormatLength: `8332`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"33/10"`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `282`,
		ExposureTime:                     `"1/50"`,
		FocalLength:                      `"630/100"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"72/1"`,
		Software:                         `"1.00             "`,
		DateTime:                         `"2007:06:17 22:56:38"`,
		LightSource:                      `0`,
		ExposureMode:                     `0`,
		FocalLengthIn35mmFilm:            `38`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		Make:                             `"CASIO COMPUTER CO.,LTD."`,
		DateTimeOriginal:                 `"2007:05:12 08:19:07"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `27298`,
		Sharpness:                        `0`,
		FNumber:                          `"31/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		PixelXDimension:                  `640`,
		GainControl:                      `2`,
		Saturation:                       `0`,
		DateTimeDigitized:                `"2007:06:17 22:56:38"`,
		CompressedBitsPerPixel:           `"252746/307200"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
	},
	"2007-05-26-04-49-45-sep-2007-05-26-04-49-45a.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `4596`,
		ThumbJPEGInterchangeFormatLength: `10120`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"34/10"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `284`,
		ExposureTime:                     `"10/3486"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		YResolution:                      `"300/1"`,
		Software:                         `"COOLPIX L3v1.2"`,
		DateTime:                         `"2007:05:26 04:49:45"`,
		LightSource:                      `0`,
		FocalLength:                      `"63/10"`,
		FlashpixVersion:                  `"0100"`,
		Contrast:                         `0`,
		Make:                             `"NIKON"`,
		DateTimeOriginal:                 `"2007:05:26 04:49:45"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `1026`,
		ExposureMode:                     `0`,
		FocalLengthIn35mmFilm:            `38`,
		SceneCaptureType:                 `2`,
		FNumber:                          `"32/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		Saturation:                       `0`,
		DateTimeDigitized:                `"2007:05:26 04:49:45"`,
		CompressedBitsPerPixel:           `"4/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		UserComment:                      `"                                                                                                                     "`,
		PixelXDimension:                  `2592`,
		GainControl:                      `0`,
		SubjectDistanceRange:             `0`,
		ImageDescription:                 `"          "`,
		Model:                            `"COOLPIX L3"`,
		ExposureBiasValue:                `"0/10"`,
		PixelYDimension:                  `1944`,
		Orientation:                      `1`,
		XResolution:                      `"300/1"`,
		ISOSpeedRatings:                  `50`,
		ExifVersion:                      `"0220"`,
		Flash:                            `24`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/100"`,
	},
	"2007-05-30-14-28-01-sep-2007-05-30-14-28-01a.jpg": map[FieldName]string{
		CompressedBitsPerPixel:           `"2/1"`,
		MeteringMode:                     `5`,
		UserComment:                      `"                                                                                                                     "`,
		GainControl:                      `1`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		ExifIFDPointer:                   `284`,
		ExposureTime:                     `"10/40"`,
		InteroperabilityIndex:            `"R98"`,
		Software:                         `"COOLPIX S6V1.0"`,
		ImageDescription:                 `"          "`,
		Model:                            `"COOLPIX S6"`,
		XResolution:                      `"300/1"`,
		ISOSpeedRatings:                  `53`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `1026`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/100"`,
		Make:                             `"NIKON"`,
		Orientation:                      `1`,
		Contrast:                         `0`,
		FocalLengthIn35mmFilm:            `35`,
		SceneCaptureType:                 `0`,
		FileSource:                       `""`,
		FNumber:                          `"30/10"`,
		ExposureProgram:                  `2`,
		DateTimeDigitized:                `"2007:05:30 14:28:01"`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2816`,
		SceneType:                        `""`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExposureBiasValue:                `"0/10"`,
		LightSource:                      `0`,
		FocalLength:                      `"58/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2112`,
		YResolution:                      `"300/1"`,
		DateTime:                         `"2007:05:30 14:28:01"`,
		Flash:                            `16`,
		ExposureMode:                     `0`,
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2007:05:30 14:28:01"`,
		MaxApertureValue:                 `"32/10"`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ThumbJPEGInterchangeFormat:       `4596`,
		ThumbJPEGInterchangeFormatLength: `5274`,
	},
	"2007-06-06-16-15-25-sep-2007-06-06-16-15-25a.jpg": map[FieldName]string{
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2007:06:06 16:15:25"`,
		Flash:                            `24`,
		ExposureMode:                     `0`,
		ThumbJPEGInterchangeFormat:       `4596`,
		ThumbJPEGInterchangeFormatLength: `5967`,
		MaxApertureValue:                 `"30/10"`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ExifIFDPointer:                   `284`,
		ExposureTime:                     `"10/2870"`,
		CompressedBitsPerPixel:           `"2/1"`,
		MeteringMode:                     `5`,
		UserComment:                      `"                                                                                                                     "`,
		GainControl:                      `0`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		InteroperabilityIndex:            `"R98"`,
		ImageDescription:                 `"          "`,
		Model:                            `"E3700"`,
		Software:                         `"E3700v1.2"`,
		Make:                             `"NIKON"`,
		Orientation:                      `1`,
		XResolution:                      `"300/1"`,
		ISOSpeedRatings:                  `50`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `1026`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/100"`,
		FocalLengthIn35mmFilm:            `35`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		FNumber:                          `"48/10"`,
		ExposureProgram:                  `2`,
		FileSource:                       `""`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		DateTimeDigitized:                `"2007:06:06 16:15:25"`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2048`,
		SceneType:                        `""`,
		YResolution:                      `"300/1"`,
		DateTime:                         `"2007:06:06 16:15:25"`,
		ExposureBiasValue:                `"0/10"`,
		LightSource:                      `0`,
		FocalLength:                      `"54/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1536`,
	},
	"2007-06-26-10-13-04-sep-2007-06-26-10-13-04a.jpg": map[FieldName]string{
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		FNumber:                          `"3/1"`,
		CompressedBitsPerPixel:           `"6389872/3145728"`,
		MeteringMode:                     `2`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2048`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2007:06:26 10:13:04"`,
		Model:                            `"DV"`,
		Copyright:                        `"Copyright2004"`,
		ExposureBiasValue:                `"1/4"`,
		PixelYDimension:                  `1536`,
		ImageDescription:                 `"My beautiful picture"`,
		XResolution:                      `"320/1"`,
		ISOSpeedRatings:                  `100`,
		ExifVersion:                      `"0210"`,
		Flash:                            `0`,
		Orientation:                      `1`,
		ThumbJPEGInterchangeFormatLength: `6292`,
		ExposureProgram:                  `3`,
		MaxApertureValue:                 `"3/1"`,
		ExposureIndex:                    `"146/1"`,
		ThumbJPEGInterchangeFormat:       `1306`,
		YCbCrPositioning:                 `2`,
		ExposureTime:                     `"23697424/268435456"`,
		ExifIFDPointer:                   `262`,
		RelatedSoundFile:                 `"RelatedSound"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		Software:                         `"DVWare 1.0"`,
		DateTime:                         `"2007:06:26 10:13:04"`,
		ShutterSpeedValue:                `"7/1"`,
		ApertureValue:                    `"3/1"`,
		LightSource:                      `0`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"384/1"`,
		DateTimeOriginal:                 `"2007:06:26 10:13:04"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `1170`,
		Make: `"CEC"`,
	},
	"2007-07-13-17-02-30-sep-2007-07-13-17-02-30a.jpg": map[FieldName]string{
		Software:                `"Ver 1.00    "`,
		DateTime:                `"2007:07:13 17:02:30"`,
		FNumber:                 `"48/10"`,
		ExposureProgram:         `2`,
		RelatedSoundFile:        `"            "`,
		Saturation:              `0`,
		XResolution:             `"72/1"`,
		ExifIFDPointer:          `266`,
		ExposureTime:            `"1/110"`,
		ISOSpeedRatings:         `64`,
		ComponentsConfiguration: `""`,
		ColorSpace:              `1`,
		PixelYDimension:         `2736`,
		FileSource:              `""`,
		Model:                   `"ViviCam X30 "`,
		ThumbJPEGInterchangeFormatLength: `20544`,
		ShutterSpeedValue:                `"678/100"`,
		ExposureBiasValue:                `"0/10"`,
		LightSource:                      `0`,
		DigitalZoomRatio:                 `"100/100"`,
		GainControl:                      `0`,
		InteroperabilityIndex:            `"R98"`,
		Make:                       `"Vivitar"`,
		DateTimeOriginal:           `"2007:07:13 17:02:30"`,
		DateTimeDigitized:          `"2007:07:13 17:02:30"`,
		PixelXDimension:            `3648`,
		InteroperabilityIFDPointer: `1010`,
		ImageDescription:           `"Digital StillCamera"`,
		Sharpness:                  `0`,
		Flash:                      `0`,
		FocalLengthIn35mmFilm:      `35`,
		SubjectDistanceRange:       `0`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		ExifVersion:                `"0220"`,
		MeteringMode:               `2`,
		WhiteBalance:               `0`,
		YResolution:                `"72/1"`,
		ThumbJPEGInterchangeFormat: `1156`,
		ApertureValue:              `"45/10"`,
		MaxApertureValue:           `"30/10"`,
		FlashpixVersion:            `"0100"`,
		MakerNote:                  `""`,
		CustomRendered:             `0`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Contrast:                   `0`,
	},
	"2007-08-15-14-42-46-sep-2007-08-15-14-42-46a.jpg": map[FieldName]string{
		Model:                            `"KODAK C663 ZOOM DIGITAL CAMERA"`,
		ShutterSpeedValue:                `"73/10"`,
		DigitalZoomRatio:                 `"0/100"`,
		FocalLengthIn35mmFilm:            `66`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		Make:                             `"EASTMAN KODAK COMPANY"`,
		Orientation:                      `1`,
		XResolution:                      `"230/1"`,
		CustomRendered:                   `0`,
		ISOSpeedRatings:                  `80`,
		ComponentsConfiguration:          `""`,
		FNumber:                          `"36/10"`,
		ExposureProgram:                  `2`,
		FileSource:                       `""`,
		PixelXDimension:                  `2832`,
		SensingMethod:                    `2`,
		SceneType:                        `""`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		DateTimeDigitized:                `"2007:08:15 14:42:46"`,
		MakerNote:                        `""`,
		FocalLength:                      `"110/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2128`,
		YResolution:                      `"230/1"`,
		ApertureValue:                    `"37/10"`,
		ExposureBiasValue:                `"0/3"`,
		LightSource:                      `0`,
		ExposureMode:                     `0`,
		ExifVersion:                      `"0221"`,
		DateTimeOriginal:                 `"2007:08:15 14:42:46"`,
		Flash:                            `24`,
		MaxApertureValue:                 `"37/10"`,
		ColorSpace:                       `1`,
		ExposureIndex:                    `"80/1"`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ThumbJPEGInterchangeFormat:       `8472`,
		ThumbJPEGInterchangeFormatLength: `3060`,
		ExposureTime:                     `"1/160"`,
		MeteringMode:                     `5`,
		ExifIFDPointer:                   `320`,
		GainControl:                      `0`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
	},
	"2007-08-24-02-40-42-sep-2007-08-24-02-40-42a.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `5108`,
		ThumbJPEGInterchangeFormatLength: `2084`,
		MaxApertureValue:                 `"147/32"`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		ExifIFDPointer:                   `196`,
		ExposureTime:                     `"1/400"`,
		CompressedBitsPerPixel:           `"5/1"`,
		MeteringMode:                     `5`,
		UserComment:                      `""`,
		InteroperabilityIndex:            `"R98"`,
		Model:                      `"Canon PowerShot SD450"`,
		ShutterSpeedValue:          `"277/32"`,
		FocalPlaneResolutionUnit:   `2`,
		DigitalZoomRatio:           `"2592/2592"`,
		Make:                       `"Canon"`,
		Orientation:                `1`,
		XResolution:                `"180/1"`,
		ComponentsConfiguration:    `""`,
		InteroperabilityIFDPointer: `2206`,
		FocalPlaneYResolution:      `"1944000/168"`,
		CustomRendered:             `0`,
		SceneCaptureType:           `0`,
		FNumber:                    `"100/10"`,
		FileSource:                 `""`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `1`,
		DateTimeDigitized:          `"2007:08:24 02:40:42"`,
		MakerNote:                  `""`,
		PixelXDimension:            `2592`,
		SensingMethod:              `2`,
		FocalPlaneXResolution:      `"2592000/225"`,
		YResolution:                `"180/1"`,
		DateTime:                   `"2007:08:24 02:40:42"`,
		ApertureValue:              `"213/32"`,
		ExposureBiasValue:          `"0/3"`,
		FocalLength:                `"17400/1000"`,
		FlashpixVersion:            `"0100"`,
		PixelYDimension:            `1944`,
		ExifVersion:                `"0220"`,
		DateTimeOriginal:           `"2007:08:24 02:40:42"`,
		Flash:                      `24`,
		ExposureMode:               `0`,
	},
	"2007-11-07-11-40-44-sep-2007-11-07-11-40-44a.jpg": map[FieldName]string{
		YResolution:                `"72/1"`,
		Copyright:                  `"    "`,
		ThumbJPEGInterchangeFormat: `1306`,
		ApertureValue:              `"600/100"`,
		MaxApertureValue:           `"360/100"`,
		FlashpixVersion:            `"0100"`,
		WhiteBalance:               `0`,
		MakerNote:                  `""`,
		SensingMethod:              `2`,
		CustomRendered:             `1`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Software:                   `"Digital Camera FinePix Z1      Ver1.00"`,
		DateTime:                   `"2007:11:07 11:40:44"`,
		FNumber:                    `"800/100"`,
		ExposureProgram:            `2`,
		XResolution:                `"72/1"`,
		ExifIFDPointer:             `294`,
		ExposureTime:               `"10/2000"`,
		ISOSpeedRatings:            `64`,
		ComponentsConfiguration:    `""`,
		CompressedBitsPerPixel:     `"20/10"`,
		PixelYDimension:            `1944`,
		Model:                      `"FinePix Z1     "`,
		ThumbJPEGInterchangeFormatLength: `9900`,
		ShutterSpeedValue:                `"764/100"`,
		ExposureBiasValue:                `"0/100"`,
		LightSource:                      `0`,
		FocalLength:                      `"610/100"`,
		ColorSpace:                       `1`,
		FocalPlaneXResolution:            `"4442/1"`,
		FileSource:                       `""`,
		InteroperabilityIndex:            `"R98"`,
		Make:                       `"FUJIFILM"`,
		DateTimeOriginal:           `"2007:11:07 11:40:44"`,
		DateTimeDigitized:          `"2007:11:07 11:40:44"`,
		BrightnessValue:            `"906/100"`,
		PixelXDimension:            `2592`,
		InteroperabilityIFDPointer: `1158`,
		SceneType:                  `""`,
		FocalPlaneResolutionUnit:   `3`,
		Sharpness:                  `0`,
		SubjectDistanceRange:       `0`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		ExifVersion:                `"0220"`,
		MeteringMode:               `5`,
		Flash:                      `16`,
		FocalPlaneYResolution: `"4442/1"`,
	},
	"2008-06-02-10-03-57-sep-2008-06-02-10-03-57a.jpg": map[FieldName]string{
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		FNumber:                          `"2800/1000"`,
		CompressedBitsPerPixel:           `"5896224/3145728"`,
		MeteringMode:                     `4`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2048`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2008:06:13 06:16:19"`,
		Copyright:                        `"Copyright 2006"`,
		ExposureBiasValue:                `"0/10"`,
		PixelYDimension:                  `1536`,
		Model:                            `"i533"`,
		XResolution:                      `"288/3"`,
		ISOSpeedRatings:                  `100`,
		ExifVersion:                      `"0220"`,
		Flash:                            `65`,
		DigitalZoomRatio:                 `"100/100"`,
		Orientation:                      `1`,
		ThumbJPEGInterchangeFormatLength: `5972`,
		ExposureProgram:                  `7`,
		MaxApertureValue:                 `"2970/1000"`,
		ThumbJPEGInterchangeFormat:       `3756`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `226`,
		ExposureTime:                     `"10/600"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		Software:                         `"00.00.1240a"`,
		DateTime:                         `"2008:06:13 06:16:19"`,
		ShutterSpeedValue:                `"5907/1000"`,
		ApertureValue:                    `"2970/1000"`,
		LightSource:                      `4`,
		FocalLength:                      `"6200/1000"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"288/3"`,
		DateTimeOriginal:                 `"2008:06:02 10:03:57"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `3620`,
		ExposureMode:                     `0`,
		Make:                             `"Polaroid"`,
	},
	"2008-06-06-13-29-29-sep-2008-06-06-13-29-29a.jpg": map[FieldName]string{
		PixelXDimension:            `1600`,
		InteroperabilityIFDPointer: `3334`,
		DigitalZoomRatio:           `"3072/3072"`,
		InteroperabilityIndex:      `"R98"`,
		Make:                     `"Canon"`,
		DateTimeOriginal:         `"2008:06:06 13:29:29"`,
		DateTimeDigitized:        `"2008:06:06 13:29:29"`,
		FocalPlaneResolutionUnit: `2`,
		ExifVersion:              `"0220"`,
		MeteringMode:             `5`,
		Flash:                    `16`,
		FocalPlaneYResolution:      `"1200000/169"`,
		Orientation:                `6`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `1`,
		MaxApertureValue:           `"116/32"`,
		FlashpixVersion:            `"0100"`,
		WhiteBalance:               `0`,
		YResolution:                `"180/1"`,
		ThumbJPEGInterchangeFormat: `5108`,
		ApertureValue:              `"116/32"`,
		CustomRendered:             `0`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		MakerNote:                  `""`,
		UserComment:                `""`,
		SensingMethod:              `2`,
		DateTime:                   `"2008:06:06 13:29:29"`,
		FNumber:                    `"35/10"`,
		ISOSpeedRatings:            `80`,
		ComponentsConfiguration:    `""`,
		CompressedBitsPerPixel:     `"5/1"`,
		XResolution:                `"180/1"`,
		ExifIFDPointer:             `196`,
		ExposureTime:               `"1/320"`,
		ExposureBiasValue:          `"0/3"`,
		FocalLength:                `"8462/1000"`,
		ColorSpace:                 `1`,
		PixelYDimension:            `1200`,
		FocalPlaneXResolution:      `"1600000/225"`,
		Model: `"Canon DIGITAL IXUS 75"`,
		ThumbJPEGInterchangeFormatLength: `6594`,
		ShutterSpeedValue:                `"266/32"`,
		FileSource:                       `""`,
	},
	"2008-06-17-01-21-30-sep-2008-06-17-01-21-30a.jpg": map[FieldName]string{
		MaxApertureValue:                 `"30/10"`,
		ThumbJPEGInterchangeFormat:       `1041`,
		ThumbJPEGInterchangeFormatLength: `13506`,
		ExposureProgram:                  `2`,
		ExposureTime:                     `"10/326"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `253`,
		LightSource:                      `0`,
		FocalLength:                      `"645/100"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"72/1"`,
		Software:                         `"A520_CT019"`,
		DateTime:                         `"2008:06:17 01:22:13"`,
		InteroperabilityIFDPointer:       `1011`,
		Make:                    `"Polaroid"`,
		DateTimeOriginal:        `"2008:06:17 01:21:30"`,
		ComponentsConfiguration: `""`,
		FNumber:                 `"28/10"`,
		ColorSpace:              `1`,
		FileSource:              `""`,
		UserComment:             `""`,
		PixelXDimension:         `2592`,
		DateTimeDigitized:       `"2008:06:17 01:21:30"`,
		CompressedBitsPerPixel:  `"2/1"`,
		MeteringMode:            `2`,
		PixelYDimension:         `1944`,
		ImageDescription:        `"DCFC1247.JPG                   "`,
		Model:                   `"5MP Digital Camera"`,
		ExposureBiasValue:       `"0/10"`,
		ExifVersion:             `"0220"`,
		Flash:                   `0`,
		Orientation:             `1`,
		XResolution:             `"72/1"`,
		ISOSpeedRatings:         `100`,
	},
	"2008-09-02-17-43-48-sep-2008-09-02-17-43-48a.jpg": map[FieldName]string{
		ImageDescription:                 `"                               "`,
		Model:                            `"Z550a"`,
		YResolution:                      `"72/1"`,
		Software:                         `"R6GA004     prgCXC1250583_GENERIC_M 2.0"`,
		DateTime:                         `"2008:09:02 17:43:48"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1024`,
		Make:                             `"Sony Ericsson"`,
		Orientation:                      `1`,
		XResolution:                      `"72/1"`,
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2008:09:02 17:43:48"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `612`,
		ThumbJPEGInterchangeFormat:       `748`,
		ThumbJPEGInterchangeFormatLength: `4641`,
		ColorSpace:                       `1`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `302`,
		DateTimeDigitized:                `"2008:09:02 17:43:48"`,
		PixelXDimension:                  `1280`,
		InteroperabilityIndex:            `"R98"`,
	},
	"2009-03-26-09-23-20-sep-2009-03-26-09-23-20a.jpg": map[FieldName]string{
		FocalLength:           `"5800/1000"`,
		ColorSpace:            `1`,
		PixelYDimension:       `2304`,
		FocalPlaneXResolution: `"3072000/225"`,
		Model: `"Canon PowerShot SD750"`,
		ThumbJPEGInterchangeFormatLength: `5513`,
		ShutterSpeedValue:                `"287/32"`,
		ExposureBiasValue:                `"0/3"`,
		FileSource:                       `""`,
		InteroperabilityIFDPointer:       `3334`,
		DigitalZoomRatio:                 `"3072/3072"`,
		InteroperabilityIndex:            `"R98"`,
		Make:                     `"Canon"`,
		DateTimeOriginal:         `"2009:03:26 09:23:20"`,
		DateTimeDigitized:        `"2009:03:26 09:23:20"`,
		PixelXDimension:          `3072`,
		FocalPlaneResolutionUnit: `2`,
		MeteringMode:             `5`,
		Flash:                    `24`,
		FocalPlaneYResolution:      `"2304000/169"`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `1`,
		ExifVersion:                `"0220"`,
		FlashpixVersion:            `"0100"`,
		WhiteBalance:               `0`,
		YResolution:                `"180/1"`,
		ThumbJPEGInterchangeFormat: `5108`,
		ApertureValue:              `"95/32"`,
		MaxApertureValue:           `"95/32"`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		MakerNote:                  `""`,
		UserComment:                `""`,
		SensingMethod:              `2`,
		CustomRendered:             `0`,
		DateTime:                   `"2009:03:26 09:23:20"`,
		FNumber:                    `"28/10"`,
		ComponentsConfiguration:    `""`,
		CompressedBitsPerPixel:     `"5/1"`,
		XResolution:                `"180/1"`,
		ExifIFDPointer:             `196`,
		ExposureTime:               `"1/500"`,
		ISOSpeedRatings:            `160`,
	},
	"2009-04-11-03-01-38-sep-2009-04-11-03-01-38a.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `33660`,
		MaxApertureValue:                 `"30/10"`,
		FlashpixVersion:                  `"0100"`,
		WhiteBalance:                     `0`,
		YResolution:                      `"300/1"`,
		UserComment:                      `"       "`,
		CustomRendered:                   `0`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		MakerNote:                        `""`,
		DateTime:                         `"2009:04:11 03:01:38"`,
		FNumber:                          `"28/10"`,
		ExposureProgram:                  `2`,
		Software:                         `"COOLPIX L18 V1.1"`,
		ExifIFDPointer:                   `230`,
		ExposureTime:                     `"1/250"`,
		ISOSpeedRatings:                  `227`,
		ComponentsConfiguration:          `""`,
		CompressedBitsPerPixel:           `"4/1"`,
		Saturation:                       `0`,
		XResolution:                      `"300/1"`,
		ThumbJPEGInterchangeFormatLength: `9697`,
		ExposureBiasValue:                `"0/10"`,
		LightSource:                      `0`,
		FocalLength:                      `"5700/1000"`,
		ColorSpace:                       `1`,
		PixelYDimension:                  `2448`,
		FileSource:                       `""`,
		Model:                            `"COOLPIX L18"`,
		DateTimeOriginal:                 `"2009:04:11 03:01:38"`,
		DateTimeDigitized:                `"2009:04:11 03:01:38"`,
		PixelXDimension:                  `3264`,
		InteroperabilityIFDPointer:       `33536`,
		SceneType:                        `""`,
		DigitalZoomRatio:                 `"0/100"`,
		GainControl:                      `1`,
		Make:                             `"NIKON"`,
		InteroperabilityIndex: `"R98"`,
		Sharpness:             `1`,
		ImageDescription:      `"          "`,
		ResolutionUnit:        `2`,
		YCbCrPositioning:      `2`,
		ExifVersion:           `"0220"`,
		MeteringMode:          `5`,
		Flash:                 `24`,
		FocalLengthIn35mmFilm: `35`,
		SubjectDistanceRange:  `0`,
		Orientation:           `1`,
	},
	"2009-04-23-07-21-35-sep-2009-04-23-07-21-35a.jpg": map[FieldName]string{
		Sharpness:    `0`,
		MeteringMode: `5`,
		Flash:        `9`,
		FocalLengthIn35mmFilm:      `35`,
		SubjectDistanceRange:       `3`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		ExifVersion:                `"0220"`,
		WhiteBalance:               `0`,
		YResolution:                `"72/1"`,
		ThumbJPEGInterchangeFormat: `31176`,
		MaxApertureValue:           `"28/10"`,
		FlashpixVersion:            `"0100"`,
		Contrast:                   `0`,
		MakerNote:                  `""`,
		CustomRendered:             `0`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Software:                   `"Optio S50 Ver 1.00"`,
		DateTime:                   `"2009:04:23 07:21:35"`,
		FNumber:                    `"26/10"`,
		ComponentsConfiguration:    `""`,
		CompressedBitsPerPixel:     `"13301888/4915200"`,
		Saturation:                 `0`,
		XResolution:                `"72/1"`,
		ExifIFDPointer:             `590`,
		ExposureTime:               `"1/40"`,
		ISOSpeedRatings:            `100`,
		ColorSpace:                 `1`,
		PixelYDimension:            `1920`,
		Model:                      `"PENTAX Optio S50"`,
		ThumbJPEGInterchangeFormatLength: `6015`,
		ExposureBiasValue:                `"0/10"`,
		FocalLength:                      `"58/10"`,
		InteroperabilityIFDPointer:       `31040`,
		DigitalZoomRatio:                 `"0/100"`,
		InteroperabilityIndex:            `"R98"`,
		Make:              `"PENTAX Corporation"`,
		DateTimeOriginal:  `"2009:04:23 07:21:35"`,
		DateTimeDigitized: `"2009:04:23 07:21:35"`,
		PixelXDimension:   `2560`,
	},
	"2009-06-11-19-23-18-sep-2009-06-11-19-23-18a.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `606`,
		ThumbJPEGInterchangeFormatLength: `7150`,
		ExposureProgram:                  `1`,
		ColorSpace:                       `65535`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `264`,
		ExposureTime:                     `"1/4"`,
		DateTimeDigitized:                `"2009:06:11 19:23:18"`,
		MeteringMode:                     `1`,
		PixelXDimension:                  `1400`,
		PixelYDimension:                  `2100`,
		Model:                            `"Canon EOS DIGITAL REBEL XTi"`,
		YResolution:                      `"3500000/10000"`,
		Software:                         `"Adobe Photoshop CS3 Macintosh"`,
		DateTime:                         `"2009:06:23 18:42:05"`,
		ApertureValue:                    `"11257/1627"`,
		ExposureBiasValue:                `"0/1"`,
		FocalLength:                      `"47/1"`,
		Make:                             `"Canon"`,
		Orientation:                      `1`,
		XResolution:                      `"3500000/10000"`,
		ISOSpeedRatings:                  `200`,
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2009:06:11 19:23:18"`,
		Flash:                            `16`,
	},
	"2009-06-20-07-59-05-sep-2009-06-20-07-59-05a.jpg": map[FieldName]string{
		DateTimeOriginal:                 `"2009:06:20 07:59:05"`,
		Flash:                            `89`,
		ExposureMode:                     `0`,
		ExifVersion:                      `"0221"`,
		ThumbJPEGInterchangeFormatLength: `4569`,
		MaxApertureValue:                 `"36/10"`,
		ColorSpace:                       `1`,
		ExposureIndex:                    `"160/1"`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ThumbJPEGInterchangeFormat:       `9032`,
		ExposureTime:                     `"1/500"`,
		MeteringMode:                     `5`,
		GainControl:                      `2`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		InteroperabilityIndex:            `"R98"`,
		ExifIFDPointer:                   `514`,
		ShutterSpeedValue:                `"9/1"`,
		Model:                            `"KODAK EASYSHARE Z710 ZOOM DIGITAL CAMERA"`,
		Orientation:                      `1`,
		XResolution:                      `"480/1"`,
		ISOSpeedRatings:                  `160`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `8728`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/100"`,
		Make:                             `"EASTMAN KODAK COMPANY"`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		FocalLengthIn35mmFilm:            `337`,
		ExposureProgram:                  `2`,
		FileSource:                       `""`,
		FNumber:                          `"35/10"`,
		YCbCrPositioning:                 `1`,
		DateTimeDigitized:                `"2009:06:20 07:59:05"`,
		MakerNote:                        `""`,
		PixelXDimension:                  `3072`,
		SensingMethod:                    `2`,
		SceneType:                        `""`,
		ResolutionUnit:                   `2`,
		ApertureValue:                    `"36/10"`,
		ExposureBiasValue:                `"0/3"`,
		LightSource:                      `0`,
		FocalLength:                      `"559/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2304`,
		YResolution:                      `"480/1"`,
	},
	"2009-08-05-08-11-31-sep-2009-08-05-08-11-31a.jpg": map[FieldName]string{
		XResolution:                `"72/1"`,
		ISOSpeedRatings:            `100`,
		ComponentsConfiguration:    `""`,
		InteroperabilityIFDPointer: `1158`,
		FocalPlaneYResolution:      `"5292/1"`,
		CustomRendered:             `0`,
		Make:                       `"FUJIFILM"`,
		Orientation:                `1`,
		SceneCaptureType:           `0`,
		FileSource:                 `""`,
		FNumber:                    `"400/100"`,
		ExposureProgram:            `2`,
		DateTimeDigitized:          `"2009:08:05 08:11:31"`,
		MakerNote:                  `"FUJIFILM0130" !"#,012NORMAL d"`,
		PixelXDimension:            `2848`,
		SensingMethod:              `2`,
		SceneType:                  `""`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		Copyright:                  `"    "`,
		ApertureValue:              `"400/100"`,
		ExposureBiasValue:          `"0/100"`,
		LightSource:                `0`,
		FocalLength:                `"720/100"`,
		FlashpixVersion:            `"0100"`,
		YResolution:                `"72/1"`,
		DateTime:                   `"2009:08:05 08:11:31"`,
		PixelYDimension:            `2136`,
		FocalPlaneXResolution:      `"5292/1"`,
		Flash:                            `16`,
		ExposureMode:                     `0`,
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2009:08:05 08:11:31"`,
		MaxApertureValue:                 `"300/100"`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `1`,
		Sharpness:                        `0`,
		ThumbJPEGInterchangeFormat:       `1306`,
		ThumbJPEGInterchangeFormatLength: `8596`,
		CompressedBitsPerPixel:           `"20/10"`,
		BrightnessValue:                  `"719/100"`,
		MeteringMode:                     `5`,
		SubjectDistanceRange:             `0`,
		InteroperabilityIndex:            `"R98"`,
		ExifIFDPointer:                   `294`,
		ExposureTime:                     `"10/3000"`,
		ShutterSpeedValue:                `"820/100"`,
		FocalPlaneResolutionUnit:         `3`,
		Model:    `"FinePix E550   "`,
		Software: `"Digital Camera FinePix E550    Ver1.00"`,
	},
	"2010-06-08-04-44-24-sep-2010-06-08-04-44-24a.jpg": map[FieldName]string{
		CompressedBitsPerPixel:           `"8/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		PixelXDimension:                  `2816`,
		Saturation:                       `0`,
		DateTimeDigitized:                `"2010:06:08 04:44:24"`,
		Model:                            `"DSC-S600"`,
		ExposureBiasValue:                `"0/10"`,
		PixelYDimension:                  `2112`,
		ImageDescription:                 `"                               "`,
		XResolution:                      `"72/1"`,
		ISOSpeedRatings:                  `80`,
		ExifVersion:                      `"0221"`,
		Flash:                            `31`,
		CustomRendered:                   `0`,
		Orientation:                      `1`,
		ThumbJPEGInterchangeFormatLength: `4029`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"48/16"`,
		ThumbJPEGInterchangeFormat:       `6892`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `2314`,
		ExposureTime:                     `"10/400"`,
		SceneType:                        `""`,
		ResolutionUnit:                   `2`,
		DateTime:                         `"2010:06:08 04:44:24"`,
		LightSource:                      `0`,
		FocalLength:                      `"51/10"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"72/1"`,
		DateTimeOriginal:                 `"2010:06:08 04:44:24"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `6640`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		Make:                             `"SONY"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		FNumber:                          `"28/10"`,
	},
	"2010-06-20-20-07-39-sep-2010-06-20-20-07-39a.jpg": map[FieldName]string{
		FocalPlaneYResolution: `"2736000/181"`,
		CustomRendered:        `0`,
		DigitalZoomRatio:      `"3648/3648"`,
		Orientation:           `1`,
		XResolution:           `"4718592/65536"`,
		ISOSpeedRatings:       `800`,
		ExifVersion:           `"0220"`,
		Flash:                 `16`,
		ThumbJPEGInterchangeFormat:       `3408`,
		ThumbJPEGInterchangeFormatLength: `5126`,
		MaxApertureValue:                 `"116/32"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `302`,
		ExposureTime:                     `"1/10"`,
		FocalLength:                      `"9681/1000"`,
		FlashpixVersion:                  `"0100"`,
		FocalPlaneXResolution:            `"3648000/241"`,
		YResolution:                      `"4718592/65536"`,
		Software:                         `"QuickTime 7.6.6"`,
		DateTime:                         `"2010:10:31 22:39:25"`,
		ShutterSpeedValue:                `"106/32"`,
		ApertureValue:                    `"116/32"`,
		Make:                             `"Canon"`,
		DateTimeOriginal:                 `"2010:06:20 20:07:39"`,
		ComponentsConfiguration:          `""`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		FNumber:                          `"35/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		PixelXDimension:                  `3648`,
		SensingMethod:                    `2`,
		DateTimeDigitized:                `"2010:06:20 20:07:39"`,
		CompressedBitsPerPixel:           `"3/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		UserComment:                      `""`,
		ImageDescription:                 `"                               "`,
		Model:                            `"Canon PowerShot SD1200 IS"`,
		ExposureBiasValue:                `"0/3"`,
		PixelYDimension:                  `2736`,
		FocalPlaneResolutionUnit:         `2`,
	},
	"2010-09-02-08-43-02-sep-2010-09-02-08-43-02a.jpg": map[FieldName]string{
		DateTime:               `"2010:09:02 08:43:02"`,
		ExposureProgram:        `5`,
		ExifVersion:            `"0221"`,
		CompressedBitsPerPixel: `"1/1"`,
		Flash:            `65`,
		Saturation:       `0`,
		XResolution:      `"72/1"`,
		ISOSpeedRatings:  `800`,
		MaxApertureValue: `"362/100"`,
		LightSource:      `0`,
		FocalLength:      `"210/10"`,
		ColorSpace:       `1`,
		Model:            `"FE370,X880,C575        "`,
		ThumbJPEGInterchangeFormat:       `9204`,
		SceneType:                        `""`,
		DigitalZoomRatio:                 `"0/100"`,
		SceneCaptureType:                 `3`,
		GainControl:                      `2`,
		Contrast:                         `0`,
		DateTimeOriginal:                 `"2010:09:02 08:43:02"`,
		MakerNote:                        `""`,
		FNumber:                          `"53/10"`,
		Sharpness:                        `0`,
		ImageDescription:                 `"OLYMPUS DIGITAL CAMERA         "`,
		Software:                         `"Version 1.0                    "`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `996`,
		ExposureTime:                     `"10/500"`,
		ComponentsConfiguration:          `""`,
		MeteringMode:                     `5`,
		Orientation:                      `1`,
		ResolutionUnit:                   `2`,
		ExposureBiasValue:                `"0/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2448`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		YResolution:                      `"72/1"`,
		ThumbJPEGInterchangeFormatLength: `3562`,
		UserComment:                      `"                                                                                                                             "`,
		PixelXDimension:                  `3264`,
		InteroperabilityIFDPointer:       `1714`,
		CustomRendered:                   `0`,
		ExposureMode:                     `0`,
		InteroperabilityIndex:            `"R98"`,
		Make:              `"OLYMPUS IMAGING CORP.  "`,
		DateTimeDigitized: `"2010:09:02 08:43:02"`,
	},
	"2011-01-24-22-06-02-sep-2011-01-24-22-06-02a.jpg": map[FieldName]string{
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		ThumbJPEGInterchangeFormat:       `25601`,
		ThumbJPEGInterchangeFormatLength: `3385`,
		ExifIFDPointer:                   `157`,
		PixelXDimension:                  `1200`,
		MakerNote:                        `""`,
		DateTimeDigitized:                `"2011:01:24 22:06:02"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		Software:                         `"V 12.40"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1600`,
		Model:                            `"6350"`,
		YResolution:                      `"300/1"`,
		XResolution:                      `"300/1"`,
		ExifVersion:                      `"0220"`,
		ComponentsConfiguration:          `""`,
		CustomRendered:                   `0`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		Make:                             `"Nokia"`,
		Orientation:                      `1`,
		DigitalZoomRatio:                 `"1024/1024"`,
		DateTimeOriginal:                 `"2011:01:24 22:06:02"`,
	},
	"2011-03-07-09-28-03-sep-2011-03-07-09-28-03a.jpg": map[FieldName]string{
		Model:                            `"GU295"`,
		Software:                         `"GU295-MSM1530032L-V10i-APR-22-2010-ATT-US"`,
		Make:                             `"LG Elec."`,
		Orientation:                      `1`,
		XResolution:                      `"72/1"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `538`,
		CustomRendered:                   `1`,
		DigitalZoomRatio:                 `"0/0"`,
		Contrast:                         `0`,
		ExposureProgram:                  `2`,
		FileSource:                       `""`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		DateTimeDigitized:                `"2011:03:07 09:28:03"`,
		PixelXDimension:                  `1280`,
		SceneType:                        `""`,
		YResolution:                      `"72/1"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `960`,
		ExifVersion:                      `"0220"`,
		DateTimeOriginal:                 `"2011:03:07 09:28:03"`,
		ExposureMode:                     `0`,
		ThumbJPEGInterchangeFormat:       `662`,
		ThumbJPEGInterchangeFormatLength: `9850`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ExifIFDPointer:                   `224`,
		BrightnessValue:                  `"0/1024"`,
		MeteringMode:                     `2`,
		Saturation:                       `0`,
		InteroperabilityIndex:            `"R98"`,
	},
	"2011-05-07-13-02-49-sep-2011-05-07-13-02-49a.jpg": map[FieldName]string{
		DateTimeOriginal:                 `"2011:05:07 13:02:49"`,
		SceneType:                        `""`,
		Contrast:                         `0`,
		Software:                         `"M7500BSAAAAAAD3050"`,
		GPSVersionID:                     `[2,2,0,0]`,
		GPSLatitudeRef:                   `"N"`,
		GPSAltitude:                      `"0/1"`,
		Orientation:                      `1`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		ExifIFDPointer:                   `218`,
		GPSInfoIFDPointer:                `502`,
		ComponentsConfiguration:          `""`,
		GPSLongitudeRef:                  `"E"`,
		GPSTimeStamp:                     `["19/1","3/1","43/1"]`,
		GPSDateStamp:                     `"2011:05:07 "`,
		YResolution:                      `"72/1"`,
		ThumbJPEGInterchangeFormatLength: `22806`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1536`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		GPSAltitudeRef:                   `0`,
		Make:                             `"HTC"`,
		DateTimeDigitized:                `"2011:05:07 13:02:49"`,
		PixelXDimension:                  `2048`,
		InteroperabilityIFDPointer:       `472`,
		GPSLatitude:                      `["0/1","0/1","0/100"]`,
		InteroperabilityIndex:            `"R98"`,
		GPSLongitude:                     `["0/1","0/1","0/100"]`,
		XResolution:                      `"72/1"`,
		ExifVersion:                      `"0220"`,
		GPSProcessingMethod:              `"ASCIIHYBRID-FIX"`,
		Model:                            `"RAPH800"`,
		ThumbJPEGInterchangeFormat: `920`,
		ColorSpace:                 `1`,
		GPSMapDatum:                `"WGS-84"`,
	},
	"2011-08-07-19-22-57-sep-2011-08-07-19-22-57a.jpg": map[FieldName]string{
		ResolutionUnit:                   `2`,
		DateTimeDigitized:                `"2011:08:07 19:22:57"`,
		SensingMethod:                    `2`,
		SceneType:                        `""`,
		YResolution:                      `"300/1"`,
		DateTime:                         `"2011:08:11 09:46:32"`,
		ApertureValue:                    `"433985/100000"`,
		ExposureBiasValue:                `"2/6"`,
		LightSource:                      `0`,
		FocalLength:                      `"620/10"`,
		ExifVersion:                      `"0221"`,
		DateTimeOriginal:                 `"2011:08:07 19:22:57"`,
		Flash:                            `7`,
		ExposureMode:                     `0`,
		ThumbJPEGInterchangeFormat:       `802`,
		ThumbJPEGInterchangeFormatLength: `9117`,
		MaxApertureValue:                 `"43/10"`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ExifIFDPointer:                   `186`,
		ExposureTime:                     `"1/30"`,
		MeteringMode:                     `2`,
		GainControl:                      `1`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		Model:                            `"NIKON D200"`,
		Software:                         `"Ver.1.00"`,
		ShutterSpeedValue:                `"4906891/1000000"`,
		SubSecTimeOriginal:               `"65"`,
		SubSecTimeDigitized:              `"65"`,
		FocalLengthIn35mmFilm:            `93`,
		SceneCaptureType:                 `0`,
		Make:                             `"NIKON CORPORATION"`,
		XResolution:                      `"300/1"`,
		ISOSpeedRatings:                  `400`,
		CFAPattern:                       `""`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"1/1"`,
		Contrast:                         `0`,
		FNumber:                          `"45/10"`,
		ExposureProgram:                  `3`,
		SubjectDistance:                  `"63/100"`,
		FileSource:                       `""`,
	},
	"2011-10-28-17-50-18-sep-2011-10-28-17-50-18a.jpg": map[FieldName]string{
		SubSecTime:                       `"92"`,
		CustomRendered:                   `0`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		UserComment:                      `""`,
		DateTime:                         `"2011:11:08 07:27:55"`,
		FNumber:                          `"4/1"`,
		ExposureProgram:                  `2`,
		SubSecTimeOriginal:               `"92"`,
		GPSVersionID:                     `[2,2,0,0]`,
		Software:                         `"Adobe Photoshop CS4 Macintosh"`,
		ExifIFDPointer:                   `364`,
		ExposureTime:                     `"1/60"`,
		ISOSpeedRatings:                  `800`,
		ComponentsConfiguration:          `""`,
		XResolution:                      `"720000/10000"`,
		ThumbJPEGInterchangeFormatLength: `6186`,
		ShutterSpeedValue:                `"393216/65536"`,
		ExposureBiasValue:                `"0/1"`,
		FocalLength:                      `"34/1"`,
		ColorSpace:                       `65535`,
		PixelYDimension:                  `864`,
		FocalPlaneXResolution:            `"5616000/1459"`,
		Model:                      `"Canon EOS 5D Mark II"`,
		DateTimeOriginal:           `"2011:10:28 17:50:18"`,
		DateTimeDigitized:          `"2011:10:28 17:50:18"`,
		PixelXDimension:            `576`,
		InteroperabilityIFDPointer: `1120`,
		InteroperabilityIndex:      `"R03"`,
		Make: `"Canon"`,
		FocalPlaneResolutionUnit: `2`,
		ResolutionUnit:           `2`,
		YCbCrPositioning:         `2`,
		GPSInfoIFDPointer:        `1152`,
		ExifVersion:              `"0221"`,
		MeteringMode:             `5`,
		Flash:                    `9`,
		FocalPlaneYResolution:      `"3744000/958"`,
		Orientation:                `1`,
		ThumbJPEGInterchangeFormat: `1266`,
		ApertureValue:              `"262144/65536"`,
		SubSecTimeDigitized:        `"92"`,
		FlashpixVersion:            `"0100"`,
		WhiteBalance:               `1`,
		YResolution:                `"720000/10000"`,
	},
	"2011-10-28-18-25-43-sep-2011-10-28-18-25-43.jpg": map[FieldName]string{
		SubSecTimeOriginal:               `"50"`,
		DateTime:                         `"2011:10:28 18:25:43"`,
		ISOSpeedRatings:                  `1250`,
		ComponentsConfiguration:          `""`,
		Saturation:                       `0`,
		XResolution:                      `"300/1"`,
		ExposureTime:                     `"10/600"`,
		ColorSpace:                       `1`,
		ThumbJPEGInterchangeFormatLength: `3670`,
		LightSource:                      `0`,
		FocalLength:                      `"800/10"`,
		CFAPattern:                       `""`,
		DigitalZoomRatio:                 `"1/1"`,
		InteroperabilityIndex:            `"R98"`,
		Make:                       `"NIKON CORPORATION"`,
		DateTimeOriginal:           `"2011:10:28 18:25:43"`,
		InteroperabilityIFDPointer: `3604`,
		Sharpness:                  `0`,
		ExifVersion:                `"0221"`,
		MeteringMode:               `5`,
		Flash:                      `31`,
		FocalLengthIn35mmFilm:      `120`,
		Orientation:                `1`,
		YCbCrPositioning:           `2`,
		SubSecTimeDigitized:        `"50"`,
		WhiteBalance:               `0`,
		ThumbJPEGInterchangeFormat: `3728`,
		SensingMethod:              `2`,
		CustomRendered:             `0`,
		SubSecTime:                 `"50"`,
		ExposureProgram:            `0`,
		Software:                   `"Ver.1.11 "`,
		FNumber:                    `"56/10"`,
		CompressedBitsPerPixel:     `"2/1"`,
		ExifIFDPointer:             `208`,
		FileSource:                 `""`,
		Model:                      `"NIKON D80"`,
		ExposureBiasValue:          `"0/6"`,
		PixelYDimension:            `537`,
		GainControl:                `2`,
		DateTimeDigitized:          `"2011:10:28 18:25:43"`,
		PixelXDimension:            `800`,
		SceneType:                  `""`,
		ImageUniqueID:              `"7fa4f6d028df5f2fc1bad8102be81064"`,
		SubjectDistanceRange:       `0`,
		ResolutionUnit:             `2`,
		FlashpixVersion:            `"0100"`,
		YResolution:                `"300/1"`,
		MaxApertureValue:           `"50/10"`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Contrast:                   `0`,
		MakerNote:                  `""`,
		UserComment:                `"ASCII                                    "`,
	},
	"2011-11-18-15-38-34-sep-Photo11181538.jpg": map[FieldName]string{
		WhiteBalance:               `0`,
		YResolution:                `"72/1"`,
		ThumbJPEGInterchangeFormat: `642`,
		FlashpixVersion:            `"0100"`,
		CustomRendered:             `1`,
		ExposureMode:               `0`,
		Contrast:                   `1`,
		Software:                   `"M6290A-KPVMZL-2.6.0140T"`,
		ExposureProgram:            `2`,
		Saturation:                 `0`,
		XResolution:                `"72/1"`,
		ExifIFDPointer:             `204`,
		ComponentsConfiguration:    `""`,
		PixelYDimension:            `1200`,
		FileSource:                 `""`,
		Model:                      `"P2020"`,
		ThumbJPEGInterchangeFormatLength: `12226`,
		ColorSpace:                       `1`,
		BrightnessValue:                  `"0/1024"`,
		PixelXDimension:                  `1600`,
		InteroperabilityIFDPointer:       `518`,
		SceneType:                        `""`,
		DigitalZoomRatio:                 `"0/0"`,
		Make:                             `"PANTECH"`,
		DateTimeOriginal:                 `"2011:11:18 15:38:34"`,
		DateTimeDigitized:                `"2011:11:18 15:38:34"`,
		InteroperabilityIndex:            `"R98"`,
		Sharpness:                        `0`,
		ExifVersion:                      `"0220"`,
		MeteringMode:                     `2`,
		Orientation:                      `1`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
	},
	"2012-06-02-10-12-28-sep-2012-06-02-10-12-28.jpg": map[FieldName]string{
		YResolution:                      `"180/1"`,
		Software:                         `"Ver.1.0  "`,
		DateTime:                         `"2012:06:02 10:12:28"`,
		LightSource:                      `0`,
		FocalLength:                      `"50/10"`,
		FlashpixVersion:                  `"0100"`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		Make:                             `"Panasonic"`,
		DateTimeOriginal:                 `"2012:06:02 10:12:28"`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `10506`,
		ExposureMode:                     `0`,
		FocalLengthIn35mmFilm:            `28`,
		FNumber:                          `"33/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		GainControl:                      `0`,
		Saturation:                       `0`,
		DateTimeDigitized:                `"2012:06:02 10:12:28"`,
		CompressedBitsPerPixel:           `"4/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		PixelXDimension:                  `4608`,
		SensingMethod:                    `2`,
		Model:                            `"DMC-FH25"`,
		ExposureBiasValue:                `"0/100"`,
		PixelYDimension:                  `3456`,
		DigitalZoomRatio:                 `"0/10"`,
		Orientation:                      `1`,
		XResolution:                      `"180/1"`,
		ISOSpeedRatings:                  `100`,
		ExifVersion:                      `"0230"`,
		Flash:                            `16`,
		CustomRendered:                   `0`,
		ThumbJPEGInterchangeFormat:       `11764`,
		ThumbJPEGInterchangeFormatLength: `7486`,
		ExposureProgram:                  `2`,
		MaxApertureValue:                 `"441/128"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `636`,
		ExposureTime:                     `"10/4000"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
	},
	"2012-09-21-22-07-34-sep-2012-09-21-22-07-34.jpg": map[FieldName]string{
		ThumbJPEGInterchangeFormat:       `5108`,
		ThumbJPEGInterchangeFormatLength: `4855`,
		MaxApertureValue:                 `"95/32"`,
		ColorSpace:                       `1`,
		WhiteBalance:                     `0`,
		ExifIFDPointer:                   `240`,
		ExposureTime:                     `"1/60"`,
		CompressedBitsPerPixel:           `"3/1"`,
		MeteringMode:                     `5`,
		UserComment:                      `""`,
		InteroperabilityIndex:            `"R98"`,
		ImageDescription:                 `"                               "`,
		Model:                            `"Canon PowerShot SD940 IS"`,
		ShutterSpeedValue:                `"189/32"`,
		FocalPlaneResolutionUnit:         `2`,
		CustomRendered:                   `0`,
		Make:                             `"Canon"`,
		Orientation:                      `1`,
		XResolution:                      `"180/1"`,
		ISOSpeedRatings:                  `500`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `3288`,
		FocalPlaneYResolution:            `"2448000/183"`,
		DigitalZoomRatio:                 `"4000/4000"`,
		SceneCaptureType:                 `2`,
		FNumber:                          `"28/10"`,
		FileSource:                       `""`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		DateTimeDigitized:                `"2012:09:21 22:07:34"`,
		MakerNote:                        `""`,
		PixelXDimension:                  `3264`,
		SensingMethod:                    `2`,
		FocalPlaneXResolution:            `"3264000/244"`,
		YResolution:                      `"180/1"`,
		DateTime:                         `"2012:09:21 22:07:34"`,
		ApertureValue:                    `"95/32"`,
		ExposureBiasValue:                `"0/3"`,
		FocalLength:                      `"5000/1000"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2448`,
		ExifVersion:                      `"0221"`,
		DateTimeOriginal:                 `"2012:09:21 22:07:34"`,
		Flash:                            `25`,
		ExposureMode:                     `0`,
	},
	"2012-12-19-21-38-40-sep-temple_square1.jpg": map[FieldName]string{
		InteroperabilityIFDPointer: `322`,
		GPSLatitude:                `["40/1","46/1","1322/100"]`,
		InteroperabilityIndex:      `"R98"`,
		Make:                       `"HTC"`,
		DateTimeOriginal:           `"2012:12:19 21:38:40"`,
		DateTimeDigitized:          `"2012:12:19 21:38:40"`,
		PixelXDimension:            `3264`,
		GPSLatitudeRef:             `"N"`,
		GPSLongitude:               `["111/1","53/1","2840/100"]`,
		GPSLongitudeRef:            `"W"`,
		GPSProcessingMethod:        `"ASCIIGPS"`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `1`,
		GPSInfoIFDPointer:          `352`,
		ExifVersion:                `"0220"`,
		GPSMapDatum:                `"WGS-84"`,
		YResolution:                `"72/1"`,
		ThumbJPEGInterchangeFormat: `696`,
		FlashpixVersion:            `"0100"`,
		GPSAltitudeRef:             `0`,
		GPSVersionID:               `[2,2,0]`,
		GPSAltitude:                `"1334/1"`,
		GPSTimeStamp:               `["4/1","38/1","40/1"]`,
		XResolution:                `"72/1"`,
		ExifIFDPointer:             `136`,
		ISOSpeedRatings:            `801`,
		ComponentsConfiguration:    `""`,
		PixelYDimension:            `1952`,
		GPSDateStamp:               `"2012:12:20"`,
		Model:                      `"ADR6400L"`,
		ThumbJPEGInterchangeFormatLength: `38469`,
		FocalLength:                      `"457/100"`,
		ColorSpace:                       `1`,
	},
	"2012-12-21-11-15-19-sep-IMG_0001.jpg": map[FieldName]string{
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
		ExifIFDPointer:             `360`,
		ExposureTime:               `"1/30"`,
		InteroperabilityIndex:      `"R98"`,
		SubSecTimeDigitized:        `"00"`,
		FlashpixVersion:            `"0100"`,
		FocalPlaneXResolution:      `"5184000/894"`,
		YResolution:                `"72/1"`,
		DateTime:                   `"2012:12:21 11:15:19"`,
		ShutterSpeedValue:          `"327680/65536"`,
		ApertureValue:              `"286720/65536"`,
		FocalLength:                `"24/1"`,
		LensModel:                  `"EF-S18-55mm f/3.5-5.6 IS II"`,
		GPSVersionID:               `[2,3,0,0]`,
		InteroperabilityIFDPointer: `8806`,
		ExposureMode:               `0`,
		SceneCaptureType:           `0`,
		Make:                       `"Canon"`,
		GPSInfoIFDPointer:          `9034`,
		DateTimeOriginal:           `"2012:12:21 11:15:19"`,
		ComponentsConfiguration:    `""`,
		SubSecTime:                 `"00"`,
		Artist:                     `""`,
		FNumber:                    `"45/10"`,
		ColorSpace:                 `1`,
		WhiteBalance:               `0`,
		DateTimeDigitized:          `"2012:12:21 11:15:19"`,
		MeteringMode:               `5`,
		MakerNote:                  `""`,
		UserComment:                `""`,
		PixelXDimension:            `5184`,
		FocalPlaneResolutionUnit:   `2`,
		Model:                 `"Canon EOS REBEL T4i"`,
		Copyright:             `""`,
		ExposureBiasValue:     `"0/1"`,
		SubSecTimeOriginal:    `"00"`,
		PixelYDimension:       `3456`,
		FocalPlaneYResolution: `"3456000/597"`,
		CustomRendered:        `0`,
		Orientation:           `1`,
		XResolution:           `"72/1"`,
		ISOSpeedRatings:       `1600`,
		ExifVersion:           `"0230"`,
		Flash:                 `16`,
		ThumbJPEGInterchangeFormat:       `10924`,
		ThumbJPEGInterchangeFormatLength: `14327`,
		ExposureProgram:                  `0`,
	},
	"2013-02-05-23-12-09-sep-DSCI0001.jpg": map[FieldName]string{
		ApertureValue:                    `"3072/1000"`,
		ExposureBiasValue:                `"0/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `1200`,
		FileSource:                       `""`,
		YResolution:                      `"288/3"`,
		ThumbJPEGInterchangeFormatLength: `5863`,
		ShutterSpeedValue:                `"5907/1000"`,
		WhiteBalance:                     `0`,
		InteroperabilityIFDPointer:       `4838`,
		ExposureMode:                     `0`,
		InteroperabilityIndex:            `"R98"`,
		Make:                   `"Polaroid"`,
		DateTimeDigitized:      `"2013:02:05 23:12:09"`,
		PixelXDimension:        `1600`,
		DateTime:               `"2013:02:05 23:12:09"`,
		ExposureProgram:        `2`,
		CompressedBitsPerPixel: `"3766184/1920000"`,
		Flash: `1`,
		FocalLengthIn35mmFilm:      `35`,
		XResolution:                `"288/3"`,
		ISOSpeedRatings:            `100`,
		ExifVersion:                `"0210"`,
		MaxApertureValue:           `"3072/1000"`,
		LightSource:                `0`,
		FocalLength:                `"5954/1000"`,
		ColorSpace:                 `1`,
		Model:                      `"Polaroid i532"`,
		Copyright:                  `"Copyright 2005"`,
		ThumbJPEGInterchangeFormat: `4974`,
		SceneType:                  `""`,
		DigitalZoomRatio:           `"100/100"`,
		SceneCaptureType:           `0`,
		DateTimeOriginal:           `"2013:02:05 23:12:09"`,
		MakerNote:                  `" BARCODE:A265KS008000; ZP:812; FP:124; AWB:235,679; PWB:476,304; PMF:12,11610; LV:493; LUM:3-8-9-8-1-11;20;26;19;10;A:1,F1:6,F2:18;ET:145, W:2, F:3 ;FV:        41FV:        36FV:        43FV:       223FV:       258FV:         9FV:       466FV:       216FP: 10FP:  8FP:  6FP:  6FP:  6FP:  0FP:  8FP:  8AFS: 110"`,
		SensingMethod:              `2`,
		Sharpness:                  `0`,
		ImageDescription:           `""`,
		Software:                   `"  1.0"`,
		FNumber:                    `"28/10"`,
		ExifIFDPointer:             `240`,
		ExposureTime:               `"1/60"`,
		ComponentsConfiguration:    `""`,
		MeteringMode:               `3`,
		Orientation:                `1`,
		ResolutionUnit:             `2`,
		YCbCrPositioning:           `2`,
	},
	"2099-08-12-19-59-29-sep-2099-08-12-19-59-29a.jpg": map[FieldName]string{
		Model:              `"NIKON D70s"`,
		ExposureBiasValue:  `"0/6"`,
		SubSecTimeOriginal: `"00"`,
		PixelYDimension:    `2000`,
		CFAPattern:         `""`,
		CustomRendered:     `0`,
		DigitalZoomRatio:   `"1/1"`,
		Orientation:        `1`,
		XResolution:        `"300/1"`,
		ExifVersion:        `"0221"`,
		Flash:              `31`,
		ThumbJPEGInterchangeFormat:       `28588`,
		ThumbJPEGInterchangeFormatLength: `8886`,
		ExposureProgram:                  `0`,
		MaxApertureValue:                 `"36/10"`,
		SceneType:                        `""`,
		InteroperabilityIndex:            `"R98"`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `2`,
		ExifIFDPointer:                   `216`,
		ExposureTime:                     `"10/600"`,
		FocalLength:                      `"180/10"`,
		SubSecTimeDigitized:              `"00"`,
		FlashpixVersion:                  `"0100"`,
		YResolution:                      `"300/1"`,
		Software:                         `"Ver.1.00 "`,
		DateTime:                         `"2099:08:12 19:59:29"`,
		LightSource:                      `0`,
		InteroperabilityIFDPointer:       `28448`,
		ExposureMode:                     `0`,
		FocalLengthIn35mmFilm:            `27`,
		SceneCaptureType:                 `0`,
		Make:                             `"NIKON CORPORATION"`,
		DateTimeOriginal:                 `"2099:08:12 19:59:29"`,
		ComponentsConfiguration:          `""`,
		SubSecTime:                       `"00"`,
		Contrast:                         `1`,
		Sharpness:                        `0`,
		FNumber:                          `"35/10"`,
		ColorSpace:                       `1`,
		FileSource:                       `""`,
		WhiteBalance:                     `0`,
		UserComment:                      `"ASCII                                    "`,
		PixelXDimension:                  `3008`,
		SensingMethod:                    `2`,
		GainControl:                      `0`,
		DateTimeDigitized:                `"2099:08:12 19:59:29"`,
		CompressedBitsPerPixel:           `"2/1"`,
		MeteringMode:                     `5`,
		MakerNote:                        `""`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
	},
	"2216-11-15-11-46-51-sep-2216-11-15-11-46-51a.jpg": map[FieldName]string{
		ExposureProgram:                  `2`,
		FileSource:                       `""`,
		FNumber:                          `"480/100"`,
		YCbCrPositioning:                 `2`,
		DateTimeDigitized:                `"2216:11:15 11:46:51"`,
		MakerNote:                        `""`,
		PixelXDimension:                  `3296`,
		SensingMethod:                    `2`,
		SceneType:                        `""`,
		ResolutionUnit:                   `2`,
		ApertureValue:                    `"452/100"`,
		ExposureBiasValue:                `"0/10"`,
		LightSource:                      `0`,
		FocalLength:                      `"60/10"`,
		FlashpixVersion:                  `"0100"`,
		PixelYDimension:                  `2472`,
		YResolution:                      `"480/1"`,
		DateTimeOriginal:                 `"2216:11:15 11:46:51"`,
		Flash:                            `24`,
		ExposureMode:                     `0`,
		ExifVersion:                      `"0221"`,
		ThumbJPEGInterchangeFormatLength: `5175`,
		MaxApertureValue:                 `"286/100"`,
		ColorSpace:                       `1`,
		ExposureIndex:                    `"80/1"`,
		WhiteBalance:                     `0`,
		Sharpness:                        `0`,
		ThumbJPEGInterchangeFormat:       `17818`,
		ExposureTime:                     `"1016/1000000"`,
		MeteringMode:                     `5`,
		GainControl:                      `0`,
		Saturation:                       `0`,
		SubjectDistanceRange:             `0`,
		ExifIFDPointer:                   `2316`,
		Software:                         `"KODAK EASYSHARE C813 ZOOM DIGITAL CAMERA"`,
		ShutterSpeedValue:                `"994/100"`,
		Model:                            `"KODAK EASYSHARE C813 ZOOM DIGITAL CAMERA"`,
		Orientation:                      `1`,
		XResolution:                      `"480/1"`,
		ISOSpeedRatings:                  `80`,
		ComponentsConfiguration:          `""`,
		InteroperabilityIFDPointer:       `17674`,
		CustomRendered:                   `0`,
		DigitalZoomRatio:                 `"0/10"`,
		Make:                             `"EASTMAN KODAK COMPANY"`,
		SceneCaptureType:                 `0`,
		Contrast:                         `0`,
		FocalLengthIn35mmFilm:            `36`,
	},
	"FailedHash-NoDate-sep-remembory.jpg": map[FieldName]string{
		Model:           `"MFC-7840W"`,
		YResolution:     `"150/1"`,
		Software:        `"Apple Image Capture"`,
		PixelYDimension: `1626`,
		ExifIFDPointer:  `192`,
		PixelXDimension: `1232`,
		Make:            `"Brother"`,
		Orientation:     `1`,
		XResolution:     `"150/1"`,
		ResolutionUnit:  `2`,
	},
	"f1-exif.jpg": map[FieldName]string{
		PixelXDimension:         `0`,
		Orientation:             `1`,
		XResolution:             `"72/1"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:02"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
	},
	"f2-exif.jpg": map[FieldName]string{
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `2`,
		XResolution:             `"72/1"`,
	},
	"f3-exif.jpg": map[FieldName]string{
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `3`,
		XResolution:             `"72/1"`,
	},
	"f4-exif.jpg": map[FieldName]string{
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `4`,
		XResolution:             `"72/1"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
	},
	"f5-exif.jpg": map[FieldName]string{
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `5`,
		XResolution:             `"72/1"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		PixelYDimension:         `0`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
	},
	"f6-exif.jpg": map[FieldName]string{
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `6`,
		XResolution:             `"72/1"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
	},
	"f7-exif.jpg": map[FieldName]string{
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `7`,
		XResolution:             `"72/1"`,
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		PixelYDimension:         `0`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
	},
	"f8-exif.jpg": map[FieldName]string{
		ResolutionUnit:          `2`,
		YCbCrPositioning:        `1`,
		ExifIFDPointer:          `134`,
		ExifVersion:             `"0210"`,
		ComponentsConfiguration: `""`,
		PixelXDimension:         `0`,
		Orientation:             `8`,
		XResolution:             `"72/1"`,
		FlashpixVersion:         `"0100"`,
		ColorSpace:              `65535`,
		PixelYDimension:         `0`,
		YResolution:             `"72/1"`,
		DateTime:                `"2012:11:04 05:42:32"`,
	},
	"geodegrees_as_string.jpg": map[FieldName]string{
		GPSAltitudeRef:                   `0`,
		ThumbJPEGInterchangeFormat:       `539`,
		ThumbJPEGInterchangeFormatLength: `13132`,
		WhiteBalance:                     `0`,
		ExposureProgram:                  `0`,
		Sharpness:                        `2`,
		ExifIFDPointer:                   `114`,
		ExposureTime:                     `"0/1024"`,
		Saturation:                       `0`,
		GPSLatitude:                      `"52,00000,50,00000,34,01180"`,
		GPSTimeStamp:                     `"17,00000,8,00000,29,00000"`,
		Model:                            `"HTC One_M8"`,
		ApertureValue:                    `"2048/1024"`,
		FocalLength:                      `"3072/1024"`,
		GPSLatitudeRef:                   `"N"`,
		GPSLongitude:                     `"11,00000,10,00000,58,28360"`,
		GPSAltitude:                      `"0/1024"`,
		GPSLongitudeRef:                  `"E"`,
		GPSProcessingMethod:              `"ASCII"`,
		GPSInfoIFDPointer:                `317`,
		Make:                             `"HTC"`,
		DateTimeOriginal:                 `"2014:04:26 19:09:19"`,
		ISOSpeedRatings:                  `125`,
		Contrast:                         `0`,
	},
	"has-lens-info.jpg": map[FieldName]string{
		LensModel: `"iPhone 4S back camera 4.28mm f/2.4"`,
		Model:     `"iPhone 4S"`,
		ThumbJPEGInterchangeFormatLength: `10875`,
		ShutterSpeedValue:                `"106906/10353"`,
		FocalLength:                      `"107/25"`,
		SubjectArea:                      `[1631,1223,881,881]`,
		ColorSpace:                       `1`,
		PixelYDimension:                  `2448`,
		GPSLatitude:                      `["59/1","19/1","5717/100"]`,
		Make:                             `"Apple"`,
		DateTimeOriginal:                 `"2014:09:01 15:03:47"`,
		DateTimeDigitized:                `"2014:09:01 15:03:47"`,
		BrightnessValue:                  `"3927/419"`,
		PixelXDimension:                  `3264`,
		SceneType:                        `""`,
		LensMake:                         `"Apple"`,
		GPSLatitudeRef:                   `"N"`,
		GPSLongitude:                     `["18/1","3/1","5379/100"]`,
		FocalLengthIn35mmFilm:            `35`,
		Orientation:                      `6`,
		ResolutionUnit:                   `2`,
		YCbCrPositioning:                 `1`,
		GPSInfoIFDPointer:                `948`,
		ExifVersion:                      `"0221"`,
		MeteringMode:                     `5`,
		Flash:                            `16`,
		GPSLongitudeRef:                  `"E"`,
		YResolution:                      `"72/1"`,
		ThumbJPEGInterchangeFormat:       `1244`,
		ApertureValue:                    `"4845/1918"`,
		SubSecTimeDigitized:              `"880"`,
		FlashpixVersion:                  `"0100"`,
		WhiteBalance:                     `0`,
		GPSAltitudeRef:                   `0`,
		MakerNote:                        `""`,
		SensingMethod:                    `2`,
		ExposureMode:                     `0`,
		SceneCaptureType:                 `0`,
		GPSImgDirection:                  `"18329/175"`,
		Software:                         `"7.1.1"`,
		DateTime:                         `"2014:09:01 15:03:47"`,
		FNumber:                          `"12/5"`,
		ExposureProgram:                  `2`,
		SubSecTimeOriginal:               `"880"`,
		GPSImgDirectionRef:               `"T"`,
		XResolution:                      `"72/1"`,
		ExifIFDPointer:                   `204`,
		ExposureTime:                     `"1/1284"`,
		ISOSpeedRatings:                  `50`,
		ComponentsConfiguration:          `""`,
		GPSAltitude:                      `"29/1"`,
		GPSTimeStamp:                     `["13/1","3/1","4279/100"]`,
	},
}
